import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.56 1H10.44C10.0195 0.99962 9.60954 1.1318 9.26845 1.37774C8.92735 1.62369 8.67246 1.97089 8.53999 2.37L8.22308 3.32663C7.42003 3.46658 6.62442 3.65121 5.84 3.88C5.01823 4.12901 4.2984 4.63586 3.78696 5.32559C3.27551 6.01533 2.99959 6.85133 3 7.71V17.29C2.99959 18.1487 3.27551 18.9847 3.78696 19.6744C4.2984 20.3641 5.01823 20.871 5.84 21.12L6.45 21.29L7.63185 19.5439C7.76126 19.4079 7.91216 19.2931 8.0791 19.2044C8.33182 19.0702 8.61358 19 8.89971 19H8.89999H15.02C15.3122 19.0009 15.5995 19.0744 15.8562 19.2141C16.1128 19.3538 16.3306 19.5551 16.49 19.8L17.49 21.3C17.72 21.25 17.94 21.19 18.16 21.12C18.9818 20.871 19.7016 20.3641 20.213 19.6744C20.7245 18.9847 21.0004 18.1487 21 17.29V7.71C21.0004 6.85133 20.7245 6.01533 20.213 5.32559C19.7016 4.63586 18.9818 4.12901 18.16 3.88C17.3756 3.65121 16.58 3.46658 15.7769 3.32663L15.46 2.37C15.3275 1.97089 15.0726 1.62369 14.7316 1.37774C14.3905 1.1318 13.9805 0.99962 13.56 1ZM19 10.5512V7.71C19.0005 7.28404 18.8649 6.86907 18.6131 6.52552C18.3613 6.18197 18.0063 5.92779 17.6 5.8C15.7807 5.26936 13.8951 5 12 5C10.1049 5 8.21933 5.26936 6.39999 5.8C5.99366 5.92779 5.63874 6.18197 5.38692 6.52552C5.1351 6.86907 4.99955 7.28404 5 7.71V10.5512C5.44225 10.8119 6.08008 11 7 11H17C17.9199 11 18.5578 10.8119 19 10.5512ZM5 14V16H9C9 15.4696 8.78929 14.9609 8.41422 14.5858C8.03914 14.2107 7.53043 14 7 14H5ZM19 16V14H17C16.4696 14 15.9609 14.2107 15.5858 14.5858C15.2107 14.9609 15 15.4696 15 16H19ZM13 20H14.31C14.5178 20.0004 14.7214 20.0586 14.898 20.1681C15.0746 20.2776 15.2172 20.4341 15.31 20.62L17 24H14L13 20ZM9.69 20H11L10 24H7L8.69 20.62C8.78277 20.4341 8.92542 20.2776 9.10202 20.1681C9.27862 20.0586 9.48221 20.0004 9.69 20Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default TrainIcon;
