import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const UserOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 14.35C8.75004 14.35 7.00004 11.175 7.00004 7.625C7.00004 4.15 9.00004 2 12 2C15 2 17 4.15 17 7.625C17 11.175 15.25 14.35 12 14.35ZM12 12.35C13.74 12.35 15 10.501 15 7.625C15 5.246 13.878 4 12 4C10.122 4 9.00004 5.246 9.00004 7.625C9.00004 10.501 10.26 12.35 12 12.35ZM4.94004 21.998C5.20471 22.0139 5.46485 21.924 5.66325 21.7481C5.86165 21.5722 5.98207 21.3247 5.99804 21.06C6.11404 19.138 8.04104 18 12.004 18C15.964 18 17.887 19.136 18.004 21.06C18.0249 21.3209 18.1473 21.5633 18.3449 21.735C18.5425 21.9067 18.7996 21.994 19.0609 21.9783C19.3222 21.9626 19.5669 21.8451 19.7425 21.6509C19.9181 21.4568 20.0105 21.2016 20 20.94C19.805 17.722 16.89 16 12.004 16C7.11404 16 4.19404 17.724 4.00204 20.94C3.98618 21.2047 4.07608 21.4648 4.25198 21.6632C4.42788 21.8616 4.67537 21.982 4.94004 21.998Z"
            fill={props.fill}
        />
    </svg>
);

UserOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default UserOutlineIcon;
