import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnMountainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.0455 21.9744C12.0923 21.9797 12.14 21.9769 12.1864 21.9655L23.6929 19.1457C23.9731 19.077 24.0907 18.7432 23.9154 18.5141L15.4236 7.41523C15.2635 7.20598 14.9483 7.20598 14.7882 7.41523L8.25057 15.96L11.9159 7.42673L9.33702 2.65169C9.18585 2.3718 8.78428 2.3718 8.63312 2.65169L0.0497573 18.5446C-0.0746793 18.775 0.0521635 19.0609 0.3065 19.1232L11.9045 21.9655C11.951 21.9769 11.9987 21.9797 12.0455 21.9744Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnMountainIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnMountainIcon;
