import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WithoutHandLuggageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00001 8.15137C3.79087 8.15137 2.00001 9.94222 2.00001 12.1514L2 16.001C1.99999 18.2101 3.79086 20.001 6 20.001H18C20.2091 20.001 22 18.2101 22 16.001L22 12.1514C22 9.94223 20.2092 8.15137 18 8.15137H6.00001ZM9.62944 17.2544C9.38536 17.4985 8.98964 17.4985 8.74556 17.2544C8.50148 17.0104 8.50148 16.6146 8.74556 16.3706L11.1161 14L8.74556 11.6294C8.50148 11.3854 8.50148 10.9896 8.74556 10.7456C8.98964 10.5015 9.38536 10.5015 9.62944 10.7456L12 13.1161L14.3706 10.7456C14.6146 10.5015 15.0104 10.5015 15.2544 10.7456C15.4985 10.9896 15.4985 11.3854 15.2544 11.6294L12.8839 14L15.2544 16.3706C15.4985 16.6146 15.4985 17.0104 15.2544 17.2544C15.0104 17.4985 14.6146 17.4985 14.3706 17.2544L12 14.8839L9.62944 17.2544Z"
            fill={props.fill}
        />
        <path
            d="M8.50398 6.77629L8.49683 6.88298H8.60376H9.35206H9.44362L9.45167 6.79178C9.55782 5.5907 10.6003 4.894 11.8963 4.894C13.1918 4.894 14.2358 5.59061 14.3598 6.79324L14.369 6.88298H14.4592H15.2075H15.3157L15.3072 6.77519C15.2394 5.90783 14.8312 5.23633 14.2144 4.78375C13.5997 4.3327 12.7826 4.10209 11.8963 4.10209C11.0101 4.10209 10.1928 4.33268 9.58038 4.78386C8.96573 5.23666 8.56213 5.90856 8.50398 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

WithoutHandLuggageIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default WithoutHandLuggageIcon;
