import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 28 28"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M24.5001 1.89033C25.3634 1.622 26.0284 1.587 26.2501 1.80866C26.4717 2.03033 26.4367 2.69532 26.1684 3.55865C25.5933 5.31078 24.6233 6.90738 23.3334 8.22529L21.0001 10.5586L22.1667 25.7252L21.0001 26.8919L15.8937 15.6579C14.9413 16.5725 13.918 17.4109 12.8334 18.1652C12.1821 18.6685 11.4957 19.1214 10.7804 19.5211L11.6667 25.7252L10.5001 26.8919L7.00008 21.0586L1.16675 17.5586L2.33341 16.3919L8.545 17.2793C8.94343 16.5645 9.39386 15.8779 9.89342 15.2253C10.7684 13.9743 11.7522 12.803 12.8334 11.7253L19.8334 4.72531C21.1513 3.4354 22.7479 2.46547 24.5001 1.89033ZM2.33341 5.89197L1.16675 7.05863L10.9551 11.5036C12.306 9.85036 13.7887 8.30922 15.3884 6.8953L2.33341 5.89197Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 28,
    height: 28,
    fill: 'currentColor',
};

export default FlightIcon;
