import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 28 28"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.66685 10.7707C4.04903 11.0884 3.51398 11.5526 3.11104 12.1271C2.57183 12.8959 2.29878 13.8199 2.33351 14.7583V25.6667H5.83351L7.00018 23.3333H21.0002L22.1668 25.6667H25.6668V14.7583C25.7016 13.8199 25.4285 12.8959 24.8893 12.1271C24.4864 11.5526 23.9513 11.0884 23.3335 10.7707V6.83334C23.3335 5.43552 23.3335 4.73661 23.1052 4.18529C22.8007 3.45021 22.2166 2.86619 21.4816 2.5617C20.9302 2.33334 20.2313 2.33334 18.8335 2.33334H9.16684C7.76902 2.33334 7.07011 2.33334 6.5188 2.5617C5.78371 2.86619 5.19969 3.45021 4.89521 4.18529C4.66685 4.73661 4.66685 5.43552 4.66685 6.83334V10.7707ZM19.2502 9.72499C15.7747 9.14043 12.2256 9.14043 8.75018 9.72499V6.72001C8.7479 6.60932 8.76849 6.49934 8.81064 6.39697C8.8528 6.29459 8.91562 6.20201 8.99518 6.12501C9.15342 5.97673 9.36166 5.89343 9.57851 5.89168H9.75351C11.1507 6.19223 12.5719 6.36792 14.0002 6.41668C15.4282 6.37176 16.8493 6.19997 18.2468 5.90334H18.4218C18.6387 5.9051 18.8469 5.9884 19.0052 6.13668C19.0847 6.21367 19.1476 6.30625 19.1897 6.40863C19.2319 6.51101 19.2525 6.62098 19.2502 6.73168V9.72499ZM4.66685 14.7583V16.3333H23.3335V14.7583C23.3444 14.3411 23.2242 13.931 22.9898 13.5856C22.7554 13.2403 22.4186 12.9772 22.0268 12.8333C16.7799 11.3398 11.2204 11.3398 5.97351 12.8333C5.58172 12.9772 5.24492 13.2403 5.01051 13.5856C4.77611 13.931 4.65591 14.3411 4.66685 14.7583Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 28,
    height: 28,
    fill: 'currentColor',
};

export default HotelIcon;
