import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M28.265 1.84895C29.2733 1.53557 30.0499 1.49469 30.3088 1.75358C30.5677 2.01246 30.5268 2.78912 30.2134 3.79741C29.5417 5.84375 28.4089 7.70844 26.9024 9.24764L24.1775 11.9726L25.54 29.6848L24.1774 31.0473L18.214 17.9279C17.1015 18.9962 15.9063 19.9755 14.6394 20.8566C13.8788 21.4443 13.0773 21.9733 12.242 22.44L13.277 29.6853L11.9144 31.0479L7.82711 24.2356L7.82663 24.2358L7.8268 24.2351L7.82677 24.2351L1.01399 20.1474L2.37654 18.7849L9.63131 19.8212C10.0966 18.9867 10.6225 18.185 11.2058 17.423C12.2277 15.9619 13.3767 14.5941 14.6394 13.3353L22.8148 5.15997C24.354 3.65347 26.2186 2.52067 28.265 1.84895ZM2.37638 6.52143L1.01382 7.88399L12.4457 13.0753C14.0235 11.1445 15.755 9.34457 17.6234 7.69323L2.37638 6.52143Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default FlightIcon;
