import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.64785 12.2621C3.89644 12.6485 3.24569 13.2131 2.75563 13.9119C2.0998 14.8469 1.76769 15.9708 1.80993 17.1122V30.3798H6.06691L7.48591 27.5418H24.5138L25.9328 30.3798H30.1898V17.1122C30.2321 15.9708 29.8999 14.8469 29.2441 13.9119C28.754 13.2131 28.1032 12.6484 27.3518 12.262V8C27.3518 6.13623 27.3518 5.20435 27.0473 4.46927C26.6413 3.48915 25.8626 2.71046 24.8825 2.30448C24.1474 2 23.2155 2 21.3518 2H10.6478C8.78408 2 7.8522 2 7.11712 2.30448C6.137 2.71046 5.35831 3.48915 4.95233 4.46927C4.64785 5.20435 4.64785 6.13623 4.64785 8V12.2621ZM22.3853 10.9902C18.1582 10.2792 13.8414 10.2792 9.61433 10.9902V7.33542C9.61156 7.20078 9.6366 7.06703 9.68787 6.94251C9.73914 6.81799 9.81555 6.70538 9.91232 6.61173C10.1048 6.43138 10.3581 6.33007 10.6218 6.32793H10.8347C12.534 6.69349 14.2626 6.90718 15.9998 6.96648C17.7366 6.91185 19.4651 6.70291 21.1649 6.34212H21.3778C21.6415 6.34426 21.8948 6.44557 22.0873 6.62592C22.1841 6.71957 22.2605 6.83218 22.3117 6.9567C22.363 7.08122 22.388 7.21497 22.3853 7.34961V10.9902ZM4.64792 17.1122V19.0278H27.3518V17.1122C27.3651 16.6047 27.2189 16.1059 26.9338 15.6858C26.6487 15.2658 26.2391 14.9458 25.7625 14.7708C19.3808 12.9543 12.6189 12.9543 6.23719 14.7708C5.76066 14.9458 5.35101 15.2658 5.06591 15.6858C4.78081 16.1059 4.63462 16.6047 4.64792 17.1122Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default HotelIcon;
