import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#022342a6__clip0_31191_5173)">
            <path
                d="M14.3333 1H18.5755C19.1473 0.999482 19.7047 1.17921 20.1684 1.51362C20.6322 1.84803 20.9788 2.32015 21.1589 2.86281L21.8931 5.07907H11.0156L11.7499 2.86281C11.93 2.32015 12.2765 1.84803 12.7403 1.51362C13.2041 1.17921 13.7615 0.999482 14.3333 1Z"
                fill={props.fill}
            />
            <path
                d="M16.4545 5.76057C19.0956 5.76203 21.7232 6.13742 24.2591 6.87552C24.9517 7.08791 25.558 7.51688 25.9887 8.09936C26.4195 8.68185 26.652 9.38714 26.6522 10.1116V23.1238C26.655 23.7458 26.4865 24.3565 26.1651 24.889C25.8437 25.4214 25.3818 25.8551 24.8302 26.1424L23.5793 24.3068L22.9674 23.4094H9.91439L9.30252 24.3476L8.1196 26.1695C7.55819 25.8833 7.08697 25.4473 6.75818 24.9097C6.42939 24.3721 6.25586 23.754 6.25682 23.1238V10.1116C6.25332 9.38302 6.48399 8.67262 6.91485 8.08509C7.34571 7.49756 7.95394 7.064 8.64988 6.84834C11.1871 6.11944 13.8147 5.7532 16.4545 5.76057ZM16.4545 3.72103C13.62 3.72103 10.7999 4.12391 8.0788 4.91757C6.96367 5.25547 5.98656 5.94259 5.29136 6.87768C4.59616 7.81277 4.21965 8.9464 4.21729 10.1116V23.1238C4.21673 24.2914 4.59189 25.4281 5.2873 26.3659C5.98271 27.3037 6.96145 27.9929 8.0788 28.3314C8.37793 28.4266 8.67707 28.5082 8.9898 28.5762L11.0157 25.4489H21.8933L24.0008 28.5626L24.8302 28.3314C25.9431 27.9942 26.9186 27.3092 27.6136 26.3768C28.3086 25.4444 28.6864 24.3139 28.6917 23.151V10.1116C28.6952 8.94175 28.3214 7.80198 27.6257 6.86142C26.9301 5.92085 25.9498 5.22964 24.8302 4.89039C22.1078 4.10593 19.2877 3.71219 16.4545 3.72103Z"
                fill={props.fill}
            />
            <path
                d="M23.2539 14.5946H9.65695C5.57788 14.5946 5.57788 11.8752 5.57788 11.8752V25.4721L8.99071 28.5995L10.3504 26.5599C10.5671 26.227 10.8633 25.9532 11.2122 25.7633C11.5611 25.5734 11.9519 25.4733 12.3491 25.4721H20.6704C21.0596 25.4721 21.4429 25.5675 21.7866 25.7501C22.1303 25.9326 22.4241 26.1967 22.642 26.5191L24.0017 28.5858L27.3329 25.4721V11.8752C27.3329 11.8752 27.3329 14.5946 23.2539 14.5946ZM6.93757 21.3931V18.6737H9.65695C10.3782 18.6737 11.0699 18.9602 11.5798 19.4702C12.0898 19.9802 12.3763 20.6719 12.3763 21.3931H6.93757ZM25.9732 21.3931H20.5345C20.5345 20.6719 20.821 19.9802 21.331 19.4702C21.8409 18.9602 22.5326 18.6737 23.2539 18.6737H25.9732V21.3931Z"
                fill={props.fill}
            />
            <path
                d="M15.0979 26.8318H12.3786L9.65918 32.2706H13.7382L15.0979 26.8318Z"
                fill={props.fill}
            />
            <path
                d="M17.8176 26.8318H20.537L23.2564 32.2706H19.1773L17.8176 26.8318Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="022342a6__clip0_31191_5173">
                <rect width={32} height={32} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

TrainIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default TrainIcon;
