import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLeftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M21.2595 8.08227L11.8957 17.0722C11.3681 17.578 11.3681 18.4222 11.8957 18.93L21.2595 27.9179C21.8337 28.4693 22.7403 28.4693 23.3146 27.9179C23.9221 27.3343 23.9221 26.3623 23.3146 25.7777L15.4721 18.2488C15.3298 18.1128 15.3298 17.8874 15.4721 17.7514L23.3146 10.2225C23.9221 9.63892 23.9221 8.66692 23.3146 8.08227C23.0269 7.80811 22.6572 7.67 22.2875 7.67C21.9168 7.67 21.5471 7.80811 21.2595 8.08227Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLeftIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default ArrowLeftIcon;
