import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M30 25.5C30 26.3284 29.3284 27 28.5 27H7.5C6.67157 27 6 26.3284 6 25.5V10.5C6 9.67157 6.67157 9 7.5 9H28.5C29.3284 9 30 9.67157 30 10.5V25.5ZM9 12.5C9 12.2239 9.22386 12 9.5 12H11.5C11.7761 12 12 12.2239 12 12.5V14.5C12 14.7761 11.7761 15 11.5 15H9.5C9.22386 15 9 14.7761 9 14.5V12.5ZM9.5 21C9.22386 21 9 21.2239 9 21.5V23.5C9 23.7761 9.22386 24 9.5 24H26.5C26.7761 24 27 23.7761 27 23.5V21.5C27 21.2239 26.7761 21 26.5 21H9.5Z"
            fill={props.fill}
        />
    </svg>
);

CardIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default CardIcon;
