import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MirCardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 10"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#829fceae__clip0_20773_4789)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M25.9456 4.59985V10H28.9456V6.79991H32.6407C34.0718 6.78929 35.2874 5.87518 35.7457 4.59985H25.9456Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M25.532 0C25.7126 2.28157 27.8711 4.08306 30.5073 4.08306C30.5159 4.08306 35.8994 4.08306 35.8994 4.08306C35.9392 3.87381 35.96 3.65784 35.96 3.437C35.96 1.54701 34.4351 0.0139818 32.5488 9.50957e-05L25.532 0Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20.8573 3.97702L20.8597 3.97188L20.8601 3.97195C20.8914 3.91564 20.9516 3.87755 21.0206 3.87755C21.1203 3.87755 21.2015 3.95703 21.2042 4.05611L21.2043 4.05612V10H24.2655V0H21.2043C20.8161 0.012921 20.3775 0.297785 20.2144 0.647462L17.7783 5.87179C17.7723 5.89315 17.7629 5.91308 17.7507 5.93098L17.7499 5.93273L17.7496 5.93263C17.7127 5.98568 17.6513 6.02041 17.5818 6.02041C17.4691 6.02041 17.3778 5.92904 17.3778 5.81633V0H14.3165V10H17.3778V9.99886C17.7617 9.9788 18.19 9.69714 18.3507 9.35254L20.8511 3.99049C20.853 3.9859 20.8551 3.98141 20.8573 3.97702Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M9.24251 4.14795L7.45336 10H5.25118L3.46095 4.1444C3.44369 4.05063 3.36152 3.97959 3.26276 3.97959C3.15145 3.97959 3.06122 4.06982 3.06122 4.18112C3.06122 4.18197 3.06123 4.18282 3.06124 4.18367L3.06122 10H0V0H2.62755H3.41009C3.97336 0 4.56363 0.437133 4.72824 0.975524L6.21806 5.8485C6.29218 6.09096 6.41244 6.0907 6.48649 5.8485L7.97631 0.975524C8.14103 0.436757 8.73111 0 9.29446 0L10.0768 0H12.7041V10H9.64286V4.18367C9.64285 4.18282 9.64286 4.18197 9.64286 4.18112C9.64286 4.06982 9.55263 3.97959 9.44133 3.97959C9.34132 3.97959 9.25833 4.05243 9.24251 4.14795Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="829fceae__clip0_20773_4789">
                <rect width={36} height={10} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

MirCardIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default MirCardIcon;
