import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M17.9679 28.1912L24.7845 31.6838C26.603 32.6159 28.354 31.378 28.009 29.3996L26.708 22.0018C26.7192 22.0755 26.7454 22.0092 26.6855 22.0607L32.2085 16.8218C33.6783 15.4219 33.0071 13.414 30.9711 13.1266L23.3596 12.0435C23.4346 12.0545 23.3784 12.014 23.4084 12.0803L19.9851 5.34564C19.0852 3.55145 16.9105 3.55145 16.0106 5.34564L12.5986 12.0803C12.6361 12.014 12.5723 12.0545 12.6473 12.0435L5.0246 13.1266C2.99237 13.414 2.32496 15.4219 3.78726 16.8182L9.31402 22.0534C9.25778 22.0018 9.27653 22.0681 9.29528 21.9944L7.99045 29.3996C7.6455 31.367 9.39651 32.6048 11.215 31.6838L18.0316 28.1838C17.9679 28.2207 18.0391 28.2207 17.9716 28.1838L17.9679 28.1912Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default StarIcon;
