import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelStarRatingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 8 8"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#557c19f6__clip0_30514_5118)">
            <path
                d="M3.99196 6.56601L5.80996 7.51401C6.29496 7.76701 6.76196 7.43101 6.66996 6.89401L6.32296 4.88601C6.32596 4.90601 6.33296 4.88801 6.31696 4.90201L7.78996 3.48001C8.18196 3.10001 8.00296 2.55501 7.45996 2.47701L5.42996 2.18301C5.44996 2.18601 5.43496 2.17501 5.44296 2.19301L4.52996 0.365006C4.28996 -0.121994 3.70996 -0.121994 3.46996 0.365006L2.55996 2.19301C2.56996 2.17501 2.55296 2.18601 2.57296 2.18301L0.539964 2.47701C-0.00203568 2.55501 -0.180036 3.10001 0.209964 3.47901L1.68396 4.90001C1.66896 4.88601 1.67396 4.90401 1.67896 4.88401L1.33096 6.89401C1.23896 7.42801 1.70596 7.76401 2.19096 7.51401L4.00896 6.56401C3.99196 6.57401 4.01096 6.57401 3.99296 6.56401L3.99196 6.56601Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="557c19f6__clip0_30514_5118">
                <rect width={8} height={8} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HotelStarRatingIcon.defaultProps = {
    width: 8,
    height: 8,
    fill: 'currentColor',
};

export default HotelStarRatingIcon;
