import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 8 8"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.99148 6.56545L5.80925 7.51333C6.2942 7.7663 6.76114 7.43034 6.66915 6.89341L6.32219 4.88565C6.32519 4.90565 6.33219 4.88765 6.31619 4.90165L7.78901 3.47983C8.18096 3.09987 8.00199 2.55494 7.45905 2.47695L5.4293 2.18298C5.4493 2.18598 5.4343 2.17499 5.4423 2.19298L4.52941 0.365205C4.28944 -0.121735 3.70951 -0.121735 3.46954 0.365205L2.55965 2.19298C2.56965 2.17499 2.55265 2.18598 2.57265 2.18298L0.539898 2.47695C-0.00203543 2.55494 -0.180014 3.09987 0.209939 3.47883L1.68376 4.89965C1.66876 4.88565 1.67376 4.90365 1.67876 4.88365L1.3308 6.89341C1.23881 7.42734 1.70576 7.7633 2.1907 7.51333L4.00847 6.56345C3.99148 6.57345 4.01047 6.57345 3.99248 6.56345L3.99148 6.56545Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 8,
    height: 8,
    fill: 'currentColor',
};

export default StarIcon;
