import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import IllustrationsShowcase from './IllustrationsShowcase';

export default {
    title: 'Common/IllustrationsShowcase',
    component: IllustrationsShowcase,
} as Meta;

const ILLUSTRATIONS_RE =
    /^illustrations\/(?<name>[^/\s]+)\/(?<nameAndSize>[^/\s]+)\.tsx?$/;

const config = {
    title: 'Список векторных иллюстраций',
    figmaUrl:
        'https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles?node-id=9287%3A1824',
    filter(filePath: string): boolean {
        return ILLUSTRATIONS_RE.test(filePath);
    },
    getName(filePath: string): string {
        const matchResult = ILLUSTRATIONS_RE.exec(filePath);

        if (!matchResult || !matchResult.groups) {
            throw new Error('Unexpected filePath');
        }

        return matchResult.groups.nameAndSize;
    },
    getSize(): string {
        return 'NO_SIZE';
    },
};

export const Illustrations: TStorybookFunctionComponent = () => (
    <IllustrationsShowcase {...config} />
);

const RASTER_ILLUSTRATIONS_RE =
    /^raster-illustrations\/(?<size>[^/\s]+)\/(?<name>[^/\s]+)\.tsx?$/;

const rasterConfig = {
    title: 'Список растровых иллюстраций',
    figmaUrl:
        'https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles?node-id=29780%3A5036',
    filter(filePath: string): boolean {
        return RASTER_ILLUSTRATIONS_RE.test(filePath);
    },
    getName(filePath: string): string {
        const matchResult = RASTER_ILLUSTRATIONS_RE.exec(filePath);

        if (!matchResult || !matchResult.groups) {
            throw new Error('Unexpected filePath');
        }

        return `${matchResult.groups.size} / ${matchResult.groups.name}`;
    },
    getSize(): string {
        return 'NO_SIZE';
    },
};

export const RasterIllustrations: TStorybookFunctionComponent = () => (
    <IllustrationsShowcase {...rasterConfig} />
);
