import {ComponentType, SVGProps, useEffect, useState} from 'react';

import {getIconFiles} from 'icons/docs/hooks/utilities/getIconFiles';

interface IParams {
    filter: (filePath: string) => boolean;
    getName: (filePath: string) => string;
    getSize: (filePath: string) => string;
}

export interface IIcon {
    name: string;
    size: string;
    Component: ComponentType<SVGProps<SVGElement>>;
}

export default function useIcons({filter, getName, getSize}: IParams): IIcon[] {
    const [icons, setIcons] = useState<IIcon[]>([]);

    useEffect(() => {
        (async function loadIcons(): Promise<void> {
            const iconFiles = getIconFiles().filter(filter);

            const loadedIcons = await Promise.all(
                iconFiles.map(filePath => {
                    return import(`../../${filePath}`).then(mod => {
                        return {
                            name: getName(filePath),
                            size: getSize(filePath),
                            Component: mod.default,
                        };
                    });
                }),
            );

            setIcons(loadedIcons);
        })();
    }, [filter, getName, getSize]);

    return icons;
}
