import preval from 'preval.macro';

const files: string[] = preval`
    const fs = require('fs');
    const path = require('path');

    function getFiles(dir) {
        const dirents = fs.readdirSync(dir, { withFileTypes: true });

        const files = dirents.map((dirent) => {
            const res = path.resolve(dir, dirent.name);

            return dirent.isDirectory() ? getFiles(res) : res;
        });

        return files.flat();
    }

    const rootDir = path.resolve(__dirname, '..', '..', '..');

    module.exports = getFiles(rootDir).map(file => path.relative(rootDir, file));
`;

function isIconFile(filePath: string): boolean {
    return /.tsx?$/.test(filePath);
}

/**
 * Получаем список всех файлов .tsx из папки src/icons с относительными путями
 */
export function getIconFiles(): string[] {
    return files.filter(isIconFile);
}
