import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AdLowPriceM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 109 69"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M85.1826 61.3001C89.7259 59.2496 92.3231 57.0216 92.0882 54.9392C91.5249 49.9451 74.9286 47.6826 55.0196 49.8859C35.1106 52.089 19.4279 57.9236 19.9913 62.9177C20.5547 67.912 37.1509 70.1744 57.0599 67.9712C59.8314 67.6645 62.5167 67.2853 65.0919 66.8498C65.6238 68.6907 71.9408 69.5082 79.4999 68.6717C87.264 67.8125 93.3798 65.537 93.1601 63.5896C93.0061 62.2241 89.7735 61.3854 85.1826 61.3001Z"
            fill="#FF8500"
        />
        <path
            d="M24.9118 46.9194C24.8769 46.802 24.8164 46.6939 24.7346 46.6029C24.6528 46.5119 24.5518 46.4402 24.439 46.393C24.439 46.393 22.6811 45.6522 21.8355 45.3056C20.9614 44.9502 20.01 45.574 18.904 46.2946C18.3721 46.692 17.7851 47.0097 17.1616 47.2377C16.5165 47.1888 15.88 47.0593 15.267 46.8522C15.4192 46.3476 15.7223 45.6188 16.0263 44.8961C16.9427 42.719 17.4481 41.5196 16.4894 40.986C15.6214 40.5684 14.727 40.2084 13.8118 39.9083C13.3581 39.7459 12.7782 39.5643 7.1676 44.1832C6.87787 44.0804 6.59568 43.9809 6.28948 43.8716L5.40158 43.5565C3.5859 42.9229 2.44404 43.5766 1.12077 44.3327L0.879851 44.4697C0.59474 44.6222 0.360181 44.8545 0.204818 45.1382C0.049455 45.4219 -0.0199885 45.7448 0.00496809 46.0673C0.0708896 47.1506 1.06866 48.2493 2.5466 48.8659C3.32951 49.1924 3.93176 49.3995 4.37041 49.5511C4.75614 49.6386 5.12037 49.8028 5.44143 50.0339C5.56757 50.1596 6.19505 50.9294 6.80217 51.6742C10.5581 56.2816 11.9115 57.7687 12.5935 58.0388C13.8721 58.5482 15.2148 58.8785 16.5837 59.0206C16.6683 59.021 16.7528 59.0167 16.8368 59.0077C16.9906 58.9917 17.1384 58.9393 17.2679 58.8548C17.3974 58.7703 17.5049 58.6561 17.5815 58.5216C17.9469 57.8881 17.7695 56.8596 15.7544 52.4392C15.6462 52.2022 15.5656 52.0265 15.5282 51.937C15.4012 51.6363 15.1034 50.9319 10.5841 49.5422C10.3737 49.4766 10.146 49.4969 9.9505 49.5986C9.75503 49.7004 9.60773 49.8754 9.54074 50.0855C9.50846 50.1894 9.49706 50.2986 9.5072 50.4069C9.51733 50.5153 9.54881 50.6205 9.59981 50.7166C9.65081 50.8126 9.72032 50.8977 9.80433 50.9667C9.88834 51.0357 9.98519 51.0875 10.0893 51.1188C11.4556 51.4969 12.7782 52.0186 14.0348 52.6753C14.0812 52.7817 14.1503 52.9325 14.235 53.1187C14.8907 54.4766 15.4633 55.8731 15.9498 57.3004C15.0305 57.1174 14.1281 56.8581 13.2519 56.525C12.5772 56.1301 9.43903 52.2812 8.09861 50.6376C7.21882 49.5575 6.78832 49.0312 6.61416 48.8611C6.12526 48.4414 5.54409 48.1434 4.91811 47.9914C4.47697 47.8398 3.92767 47.6504 3.19359 47.3441C1.98259 46.8395 1.61555 46.0867 1.70832 45.9029L1.9541 45.7626C3.23509 45.0307 3.7942 44.7486 4.84975 45.1138L5.72463 45.4249C14.3147 48.4903 16.6285 49.0142 17.4529 48.8619C18.3076 48.613 19.1098 48.2103 19.8204 47.6738C20.2704 47.3474 20.7568 47.0745 21.2698 46.8605C21.6849 47.0314 22.2822 47.2804 22.7909 47.4932C21.8265 48.6289 19.8732 50.582 17.7215 50.7618C17.6129 50.7701 17.507 50.7998 17.41 50.8492C17.3129 50.8987 17.2266 50.9669 17.1561 51.0499C17.0855 51.1329 17.0321 51.2291 16.9989 51.3329C16.9657 51.4367 16.9533 51.546 16.9626 51.6546C16.9718 51.7632 17.0024 51.8688 17.0527 51.9655C17.103 52.0622 17.1719 52.1479 17.2555 52.2178C17.3391 52.2877 17.4356 52.3403 17.5396 52.3726C17.6436 52.4049 17.753 52.4163 17.8614 52.4061C21.6914 52.0869 24.6765 47.7987 24.8019 47.6166C24.871 47.5159 24.9168 47.4011 24.9358 47.2804C24.9548 47.1598 24.9466 47.0364 24.9118 46.9194ZM13.4773 41.5438C14.401 41.8767 14.9504 42.0968 15.2751 42.237C15.1286 42.74 14.7542 43.6283 14.4881 44.2602C14.1577 45.0451 13.8499 45.7861 13.6698 46.3793C12.5064 46.0176 10.9911 45.5178 9.00264 44.8277C10.4185 43.6333 11.9135 42.5362 13.4773 41.5438Z"
            fill="#157BF0"
        />
        <path
            d="M73.8612 55.6489C73.6473 55.6493 73.4337 55.6331 73.2223 55.6006L61.4745 53.8015C60.8027 53.6998 60.1654 53.4375 59.6165 53.0367C59.0676 52.6359 58.6235 52.1086 58.3217 51.4994C58.023 50.8928 57.8771 50.2222 57.8965 49.5462C57.9159 48.8702 58.1002 48.2092 58.4332 47.6207L82.3211 5.37643C82.7477 4.63067 83.39 4.03172 84.1634 3.65848C84.9369 3.28523 85.8052 3.1552 86.654 3.28553L98.4001 5.08463C99.0722 5.18621 99.7098 5.44861 100.259 5.84953C100.808 6.25045 101.252 6.77805 101.554 7.38752C101.852 7.99419 101.998 8.66478 101.979 9.34083C101.959 10.0169 101.775 10.6779 101.441 11.2662L77.5544 53.5097C77.1818 54.1603 76.6439 54.7008 75.9954 55.0764C75.3468 55.4521 74.6106 55.6496 73.8612 55.6489ZM86.0118 4.88715C85.558 4.88702 85.1122 5.00671 84.7194 5.23414C84.3266 5.46157 84.0007 5.78869 83.7746 6.18247L59.8867 48.4268C59.6826 48.7823 59.5696 49.1829 59.5579 49.5928C59.5463 50.0027 59.6363 50.409 59.82 50.7756C60.0003 51.1462 60.2684 51.467 60.6011 51.7101C60.9338 51.9532 61.3208 52.1111 61.7285 52.1701L73.4763 53.9692C73.9903 54.048 74.5161 53.9693 74.9845 53.7434C75.453 53.5175 75.8422 53.1551 76.1009 52.7037L99.9879 10.4594C100.192 10.104 100.306 9.7034 100.317 9.29348C100.329 8.88356 100.239 8.47711 100.055 8.11055C99.8751 7.73984 99.6068 7.41894 99.274 7.17587C98.9412 6.93279 98.554 6.77494 98.1462 6.71608L86.3992 4.91698C86.2711 4.89706 86.1416 4.88709 86.0118 4.88715Z"
            fill="#157BF0"
        />
        <path
            d="M96.6705 57.6558C96.1828 57.6556 95.6958 57.6184 95.2138 57.5446C93.7904 57.3142 92.434 56.7774 91.2381 55.9714C90.0423 55.1653 89.0355 54.1092 88.2872 52.8759C86.6563 50.2419 86.0392 47.104 86.5513 44.0481C87.5751 37.4957 93.1418 32.8899 98.9249 33.7749C100.348 34.0052 101.705 34.5419 102.901 35.3479C104.097 36.154 105.104 37.2102 105.852 38.4436C107.483 41.0775 108.099 44.2151 107.587 47.2706V47.2715C107.14 50.3426 105.596 53.1475 103.241 55.1667C101.414 56.749 99.0861 57.6311 96.6705 57.6558ZM97.4852 35.3161C93.0416 35.3161 89.0099 39.1061 88.1985 44.3011C87.7481 46.9638 88.2809 49.6995 89.6975 51.9981C90.3102 53.0392 91.1467 53.9307 92.1464 54.6081C93.1461 55.2855 94.284 55.7317 95.4774 55.9145C96.6709 56.0972 97.89 56.0119 99.0464 55.6646C100.203 55.3174 101.267 54.7169 102.163 53.9068C104.187 52.1256 105.523 49.6911 105.939 47.0265C106.355 44.3619 105.825 41.6356 104.441 39.3214C103.819 38.2901 102.982 37.406 101.986 36.7301C100.989 36.0542 99.8585 35.6026 98.671 35.4064C98.2786 35.3465 97.8822 35.3163 97.4852 35.3161V35.3161Z"
            fill="#157BF0"
        />
        <path
            d="M63.6515 23.9881C63.1638 23.9879 62.6768 23.9507 62.1947 23.8769C60.7715 23.6465 59.4151 23.1098 58.2193 22.3039C57.0234 21.498 56.0165 20.4421 55.2681 19.209C53.6373 16.575 53.0202 13.4371 53.5322 10.3812C54.5552 3.82797 60.117 -0.769738 65.9058 0.107243C71.7061 0.996321 75.5913 7.05056 74.5683 13.6038C74.1211 16.6748 72.5768 19.4797 70.2216 21.499C68.3954 23.0813 66.067 23.9634 63.6515 23.9881ZM64.4661 1.64841C60.0226 1.64841 55.9908 5.43847 55.1794 10.6335C54.729 13.2961 55.2618 16.0319 56.6785 18.3304C57.2911 19.3715 58.1276 20.263 59.1274 20.9404C60.1271 21.6178 61.2649 22.064 62.4584 22.2468C63.6518 22.4295 64.8709 22.3442 66.0273 21.9969C67.1837 21.6497 68.2484 21.0492 69.1441 20.2392C71.194 18.4755 72.5358 16.0283 72.9211 13.3507C73.8041 7.69783 70.5431 2.48832 65.6511 1.7387C65.2589 1.67875 64.8628 1.64857 64.4661 1.64841Z"
            fill="#157BF0"
        />
        <path
            d="M80.0368 28.7908C77.1231 13.3341 63.0135 2.9763 48.5222 5.65603L40.5264 7.13564L40.7616 8.47129C30.8707 14.0389 25.2072 26.0192 27.559 38.4947C29.863 50.7175 39.1698 59.7446 50.1285 61.6649L50.4038 63.2286L59.0354 61.6355C59.0481 61.6332 59.0609 61.6319 59.0736 61.6295L59.1105 61.6217L59.2841 61.5896L59.2831 61.5849C73.6542 58.8019 82.9363 44.1721 80.0368 28.7908Z"
            fill="#FF6526"
        />
        <path
            opacity={0.17}
            d="M77.6062 21.3567L69.5937 23.3028L61.4536 12.7807L69.6958 11.2559L69.8063 11.3486L70.8185 12.2248C73.6627 14.7893 75.9699 17.8932 77.6062 21.3567Z"
            fill="white"
        />
        <path
            d="M51.5977 62.9999C65.9994 59.8775 74.9758 44.8838 71.6472 29.5105C68.3186 14.1372 53.9454 4.20592 39.5438 7.32832C25.1421 10.4507 16.1657 25.4444 19.4943 40.8177C22.8229 56.191 37.1961 66.1223 51.5977 62.9999Z"
            fill="url(#7f12d9c4__paint0_linear_7649_66)"
        />
        <path
            d="M49.791 56.4002C60.7781 54.0181 67.6263 42.5793 65.0869 30.8509C62.5475 19.1226 51.5821 11.546 40.595 13.928C29.608 16.3101 22.7598 27.7489 25.2992 39.4773C27.8386 51.2056 38.804 58.7823 49.791 56.4002Z"
            fill="#FB730D"
        />
        <path
            d="M51.0765 55.4036C40.4115 57.6331 29.7796 50.1202 27.3294 38.6231C24.8791 27.1259 31.5385 15.9981 42.2034 13.7686C42.7733 13.6495 43.3429 13.5639 43.9114 13.4995C42.9568 13.5307 42.0058 13.6329 41.0663 13.8052C30.0109 15.8495 22.8507 27.0661 25.0735 38.858C27.2964 50.6499 38.0606 58.5518 49.1161 56.5074C52.1715 55.9432 55.0443 54.6449 57.4875 52.7241C55.5402 54.017 53.3643 54.9264 51.0765 55.4036Z"
            fill="#FF6526"
        />
        <path
            d="M49.1525 37.5079C50.3638 37.2608 51.5144 36.7768 52.5383 36.0837C53.5622 35.3905 54.4392 34.5019 55.1191 33.4687C55.7989 32.4355 56.2682 31.2782 56.5 30.0631C56.7317 28.848 56.7214 27.5991 56.4697 26.388C56.0732 23.9161 54.7154 21.7016 52.6929 20.228C50.6704 18.7544 48.1474 18.1414 45.6747 18.5228L42.0597 19.1724L37.4095 20.008C37.3037 20.0296 37.2032 20.0719 37.1138 20.1324C37.0244 20.1929 36.9478 20.2705 36.8885 20.3607C36.8291 20.451 36.7881 20.552 36.7679 20.6581C36.7477 20.7642 36.7485 20.8733 36.7705 20.979L38.8913 32.5562L35.8451 33.1036C35.7393 33.1252 35.6389 33.1674 35.5494 33.228C35.46 33.2885 35.3834 33.3661 35.3241 33.4563C35.2647 33.5465 35.2237 33.6476 35.2035 33.7537C35.1833 33.8598 35.1842 33.9688 35.2062 34.0746L36.0991 38.9489C36.1337 39.1647 36.2523 39.3581 36.4289 39.4868C36.6055 39.6154 36.8258 39.669 37.0417 39.6357L40.0879 39.0883L40.657 42.1945L37.6107 42.7419C37.505 42.7635 37.4045 42.8058 37.3151 42.8663C37.2257 42.9268 37.1491 43.0044 37.0897 43.0946C37.0303 43.1849 36.9894 43.2859 36.9691 43.392C36.9489 43.4981 36.9498 43.6072 36.9718 43.7129L37.8647 48.5874C37.8993 48.8032 38.0178 48.9966 38.1945 49.1253C38.3711 49.254 38.5914 49.3075 38.8073 49.2742L41.8535 48.7268L42.2087 50.6655C42.2433 50.8813 42.3619 51.0747 42.5385 51.2034C42.7151 51.3321 42.9354 51.3856 43.1513 51.3523L47.8016 50.5167C47.9073 50.4951 48.0078 50.4528 48.0972 50.3923C48.1866 50.3318 48.2632 50.2542 48.3226 50.164C48.3819 50.0737 48.4229 49.9727 48.4431 49.8666C48.4634 49.7605 48.4625 49.6514 48.4405 49.5457L48.0854 47.607L54.1114 46.5241C54.2172 46.5025 54.3176 46.4603 54.407 46.3997C54.4964 46.3392 54.573 46.2616 54.6324 46.1714C54.6917 46.0812 54.7327 45.9801 54.753 45.874C54.7732 45.7679 54.7723 45.6589 54.7503 45.5531L53.8574 40.6787C53.8228 40.4629 53.7042 40.2695 53.5276 40.1408C53.351 40.0121 53.1307 39.9586 52.9148 39.9919L46.8887 41.0748L46.3283 38.0155L49.1525 37.5079ZM44.199 26.3915C44.177 26.2857 44.1761 26.1767 44.1963 26.0706C44.2166 25.9645 44.2575 25.8634 44.3169 25.7732C44.3763 25.683 44.4529 25.6054 44.5423 25.5449C44.6317 25.4843 44.7322 25.4421 44.8379 25.4205L46.8937 25.0511C47.6547 24.9482 48.426 25.1426 49.0476 25.5939C49.6692 26.0451 50.0932 26.7185 50.2317 27.4744C50.3701 28.2302 50.2124 29.0104 49.7912 29.6529C49.37 30.2954 48.7177 30.7509 47.9697 30.9249L45.9139 31.2943C45.698 31.3276 45.4777 31.2741 45.3011 31.1454C45.1245 31.0167 45.0059 30.8233 44.9713 30.6075L44.199 26.3915Z"
            fill="#FF8700"
        />
        <path
            d="M48.0512 37.7115C49.2625 37.4644 50.4131 36.9804 51.437 36.2873C52.4609 35.5941 53.338 34.7054 54.0178 33.6723C54.6976 32.6391 55.1669 31.4818 55.3987 30.2667C55.6304 29.0516 55.6201 27.8027 55.3684 26.5916C54.9719 24.1197 53.6141 21.9052 51.5916 20.4316C49.5691 18.958 47.046 18.345 44.5734 18.7264L40.9584 19.376L36.3082 20.2117C36.2024 20.2332 36.1019 20.2755 36.0125 20.336C35.9231 20.3965 35.8465 20.4741 35.7872 20.5644C35.7278 20.6546 35.6868 20.7556 35.6666 20.8617C35.6463 20.9678 35.6472 21.0769 35.6692 21.1826L37.79 32.7598L34.7438 33.3072C34.638 33.3288 34.5375 33.371 34.4481 33.4316C34.3587 33.4921 34.2821 33.5697 34.2228 33.6599C34.1634 33.7501 34.1224 33.8512 34.1022 33.9573C34.0819 34.0634 34.0828 34.1724 34.1048 34.2782L34.9977 39.1525C35.0324 39.3683 35.1509 39.5617 35.3275 39.6904C35.5042 39.8191 35.7245 39.8726 35.9404 39.8393L38.9866 39.2919L39.5556 42.3982L36.5094 42.9456C36.4036 42.9671 36.3032 43.0094 36.2138 43.0699C36.1243 43.1304 36.0478 43.208 35.9884 43.2983C35.929 43.3885 35.888 43.4895 35.8678 43.5956C35.8476 43.7017 35.8485 43.8108 35.8705 43.9166L36.7634 48.7909C36.798 49.0068 36.9166 49.2002 37.0932 49.3288C37.2698 49.4575 37.4901 49.511 37.706 49.4777L40.7523 48.9303L41.1074 50.869C41.142 51.0849 41.2606 51.2783 41.4372 51.4069C41.6138 51.5356 41.8341 51.5891 42.05 51.5558L46.7003 50.7202C46.8061 50.6986 46.9065 50.6564 46.9959 50.5958C47.0853 50.5353 47.1619 50.4577 47.2213 50.3675C47.2807 50.2773 47.3216 50.1762 47.3419 50.0701C47.3621 49.964 47.3612 49.855 47.3392 49.7492L46.9841 47.8105L53.0101 46.7277C53.1159 46.7061 53.2164 46.6638 53.3058 46.6033C53.3952 46.5428 53.4718 46.4652 53.5311 46.3749C53.5905 46.2847 53.6315 46.1837 53.6517 46.0776C53.672 45.9715 53.6711 45.8624 53.6491 45.7567L52.7561 40.8823C52.7215 40.6664 52.603 40.473 52.4264 40.3444C52.2498 40.2157 52.0294 40.1622 51.8135 40.1955L45.7875 41.2783L45.227 38.219L48.0512 37.7115ZM43.0977 26.5951C43.0757 26.4893 43.0748 26.3803 43.095 26.2742C43.1153 26.1681 43.1562 26.067 43.2156 25.9768C43.275 25.8866 43.3516 25.809 43.441 25.7484C43.5304 25.6879 43.6309 25.6457 43.7366 25.6241L45.7924 25.2547C46.5534 25.1518 47.3248 25.3462 47.9464 25.7974C48.5679 26.2486 48.992 26.9221 49.1305 27.6779C49.2689 28.4338 49.1112 29.214 48.6899 29.8565C48.2687 30.499 47.6164 30.9545 46.8684 31.1285L44.8126 31.4979C44.5967 31.5312 44.3764 31.4776 44.1998 31.349C44.0232 31.2203 43.9046 31.0269 43.87 30.8111L43.0977 26.5951Z"
            fill="url(#7f12d9c4__paint1_linear_7649_66)"
        />
        <path
            d="M75.5743 44.3635C76.9362 48.0252 79.1702 52.136 83.0007 53.3162C83.1636 53.3693 83.3093 53.4648 83.423 53.593C83.5367 53.7212 83.6141 53.8775 83.6474 54.0456C83.6806 54.2137 83.6685 54.3877 83.6122 54.5495C83.5559 54.7114 83.4575 54.8553 83.3271 54.9665C80.3109 57.7851 78.2202 61.4531 77.3313 65.4858C77.2825 65.6821 77.1749 65.8587 77.0228 65.9919C76.8707 66.1251 76.6815 66.2085 76.4806 66.2308C76.2797 66.2532 76.0768 66.2134 75.8992 66.1168C75.7216 66.0203 75.5779 65.8716 75.4873 65.6908C73.1247 60.9675 71.218 58.028 68.1605 56.5017C68.0144 56.4287 67.8892 56.3197 67.7969 56.1849C67.7045 56.0502 67.6479 55.8941 67.6325 55.7314C67.617 55.5687 67.6433 55.4048 67.7086 55.255C67.774 55.1053 67.8764 54.9746 68.0062 54.8754C70.3737 52.9938 72.4556 49.3871 73.6833 44.4805C73.7329 44.2743 73.8474 44.0895 74.0098 43.9531C74.1722 43.8168 74.374 43.7362 74.5856 43.7231C74.7972 43.71 75.0074 43.7651 75.1853 43.8804C75.3633 43.9957 75.4996 44.165 75.5743 44.3635Z"
            fill="white"
        />
        <path
            d="M24.7091 4.73035C24.6847 10.4852 25.7283 17.2463 29.3459 20.5647C29.4547 20.6785 29.5362 20.8156 29.5844 20.9655C29.6326 21.1154 29.6461 21.2744 29.624 21.4303C29.6019 21.5863 29.5447 21.7351 29.4568 21.8658C29.3688 21.9964 29.2524 22.1053 29.1163 22.1844C23.5775 25.1011 19.1967 29.8186 16.6953 35.5597C16.6227 35.7437 16.4869 35.8958 16.3123 35.9886C16.1377 36.0814 15.9357 36.1088 15.7427 36.0659C15.5497 36.023 15.3784 35.9127 15.2594 35.7547C15.1404 35.5967 15.0817 35.4014 15.0937 35.2039C14.7887 27.4396 12.4772 21.1707 10.7141 18.6279C10.6281 18.5023 10.5714 18.359 10.5482 18.2085C10.525 18.058 10.536 17.9042 10.5801 17.7585C10.6243 17.6128 10.7007 17.4789 10.8035 17.3667C10.9064 17.2545 11.0332 17.1669 11.1744 17.1103C14.6351 15.8815 19.5969 11.6779 23.1058 4.32652C23.1802 4.13812 23.3205 3.98325 23.5006 3.89079C23.6807 3.79834 23.8883 3.77462 24.0846 3.82406C24.2809 3.87351 24.4525 3.99274 24.5674 4.1595C24.6824 4.32626 24.7327 4.52917 24.7091 4.73035Z"
            fill="white"
        />
        <path
            d="M29.1167 22.1889C23.5761 25.1028 19.1933 29.8192 16.6911 35.5603C16.6142 35.7584 16.4636 35.919 16.2709 36.0083C16.0782 36.0975 15.8584 36.1086 15.6577 36.0391V36.0308C16.1578 34.8504 19.3829 21.4708 17.5245 18.3178C20.5496 16.7908 23.3747 6.84472 24.1665 3.85693C24.3355 3.9296 24.4781 4.05251 24.575 4.20899C24.6719 4.36548 24.7184 4.54799 24.7082 4.7318C24.6831 10.4848 25.7249 17.2448 29.3417 20.5712C29.4508 20.6845 29.5327 20.8211 29.5813 20.9707C29.6299 21.1203 29.6439 21.279 29.6222 21.4348C29.6006 21.5906 29.5438 21.7394 29.4562 21.8701C29.3686 22.0007 29.2526 22.1097 29.1167 22.1889Z"
            fill="#D8E5FF"
        />
        <path
            d="M15.6577 36.0308V36.0391C15.4893 35.9749 15.3447 35.8605 15.2433 35.7114C15.142 35.5623 15.0888 35.3857 15.091 35.2054C14.791 27.4384 12.4742 21.1737 10.7158 18.6314C10.6113 18.4827 10.548 18.309 10.5325 18.1279C12.8314 18.6225 15.202 18.6869 17.5244 18.3179C19.3829 21.4708 16.1577 34.8504 15.6577 36.0308Z"
            fill="#ECF1FF"
        />
        <path
            d="M83.3283 54.9624C80.3104 57.7822 78.2182 61.4517 77.328 65.4863C77.2823 65.6883 77.1723 65.8699 77.0145 66.0039C76.8566 66.1379 76.6596 66.2169 76.453 66.229C75.6446 63.2988 76.2613 55.8785 77.9697 54.3846C75.4946 53.5923 74.5612 44.1166 74.5195 43.7287C74.7423 43.695 74.9698 43.74 75.163 43.856C75.3562 43.972 75.5029 44.1517 75.5779 44.3643C76.9363 48.0208 79.1698 52.1313 83.0033 53.3116C83.166 53.3651 83.3115 53.4609 83.4248 53.5892C83.5382 53.7176 83.6154 53.8738 83.6485 54.0419C83.6816 54.21 83.6694 54.3838 83.6131 54.5456C83.5568 54.7074 83.4585 54.8513 83.3283 54.9624Z"
            fill="url(#7f12d9c4__paint2_linear_7649_66)"
        />
        <path
            d="M103.208 24.5512C103.138 24.5514 103.068 24.5427 103 24.5254C102.895 24.4992 102.795 24.4523 102.708 24.3875C102.621 24.3226 102.547 24.2412 102.491 24.1477C102.435 24.0543 102.399 23.9508 102.383 23.8431C102.367 23.7354 102.373 23.6257 102.4 23.5203L103.013 21.1642C103.071 20.952 103.21 20.771 103.399 20.66C103.589 20.5489 103.815 20.5167 104.028 20.5702C104.133 20.5964 104.233 20.6433 104.32 20.7081C104.407 20.7729 104.481 20.8544 104.537 20.9478C104.593 21.0413 104.629 21.1448 104.645 21.2525C104.66 21.3602 104.655 21.4699 104.628 21.5753L104.015 23.9314C103.968 24.1094 103.863 24.2667 103.717 24.3789C103.571 24.491 103.392 24.5516 103.208 24.5512Z"
            fill="#157BF0"
        />
        <path
            d="M101.498 31.126C101.428 31.1261 101.358 31.1175 101.29 31.1002C101.185 31.0739 101.085 31.027 100.998 30.9622C100.911 30.8974 100.837 30.8159 100.781 30.7225C100.725 30.6291 100.689 30.5255 100.673 30.4179C100.657 30.3102 100.663 30.2005 100.69 30.095L101.303 27.739C101.36 27.5264 101.499 27.345 101.689 27.2338C101.879 27.1227 102.105 27.0907 102.318 27.1449C102.423 27.1712 102.523 27.2181 102.61 27.2829C102.697 27.3477 102.771 27.4292 102.827 27.5226C102.883 27.616 102.919 27.7196 102.935 27.8272C102.951 27.9349 102.945 28.0446 102.918 28.1501L102.305 30.5061C102.258 30.6841 102.153 30.8415 102.007 30.9536C101.861 31.0658 101.682 31.1264 101.498 31.126Z"
            fill="#157BF0"
        />
        <path
            d="M107.169 27.8111C107.098 27.8112 107.028 27.8026 106.96 27.7853L104.581 27.1783C104.476 27.1521 104.377 27.1052 104.289 27.0404C104.202 26.9755 104.128 26.8941 104.072 26.8006C104.017 26.7072 103.98 26.6037 103.964 26.496C103.949 26.3883 103.955 26.2786 103.982 26.1732C104.039 25.9609 104.178 25.7797 104.368 25.6686C104.557 25.5576 104.783 25.5254 104.996 25.5791L107.375 26.1861C107.571 26.2348 107.743 26.3538 107.857 26.5205C107.971 26.6873 108.02 26.8901 107.994 27.0906C107.969 27.2911 107.87 27.4752 107.718 27.608C107.566 27.7408 107.37 27.8131 107.169 27.8111L107.169 27.8111Z"
            fill="#157BF0"
        />
        <path
            d="M100.529 26.1173C100.459 26.1175 100.389 26.1088 100.321 26.0916L97.9419 25.4846C97.8364 25.4583 97.7371 25.4114 97.6498 25.3466C97.5624 25.2818 97.4888 25.2003 97.433 25.1069C97.3773 25.0135 97.3405 24.9099 97.3249 24.8023C97.3093 24.6946 97.3152 24.5849 97.3421 24.4794C97.3997 24.2671 97.5383 24.0858 97.7281 23.9747C97.9179 23.8636 98.1438 23.8315 98.357 23.8854L100.736 24.4923C100.932 24.5411 101.103 24.6601 101.217 24.8268C101.331 24.9935 101.38 25.1964 101.355 25.3968C101.329 25.5973 101.231 25.7814 101.079 25.9142C100.927 26.047 100.731 26.1193 100.529 26.1173L100.529 26.1173Z"
            fill="#157BF0"
        />
        <path
            d="M7.92786 7.74458C7.85761 7.74476 7.78761 7.7361 7.71951 7.71881C7.61399 7.69254 7.5147 7.64565 7.42736 7.58083C7.34003 7.51601 7.26636 7.43454 7.21061 7.34112C7.15486 7.2477 7.11813 7.14417 7.10253 7.03648C7.08692 6.92879 7.09276 6.81908 7.1197 6.71366L7.73254 4.35756C7.79043 4.14538 7.92911 3.96436 8.11883 3.85331C8.30855 3.74226 8.53421 3.71003 8.7474 3.76354C8.85292 3.78981 8.95221 3.8367 9.03955 3.90152C9.12689 3.96634 9.20055 4.0478 9.2563 4.14123C9.31205 4.23465 9.34879 4.33818 9.36439 4.44587C9.37999 4.55355 9.37415 4.66326 9.34722 4.76868L8.73439 7.12477C8.68731 7.30275 8.58262 7.4601 8.4367 7.57224C8.29078 7.68438 8.11185 7.74499 7.92786 7.74458Z"
            fill="#157BF0"
        />
        <path
            d="M6.2179 14.32C6.14765 14.3202 6.07765 14.3115 6.00955 14.2942C5.90403 14.2679 5.80474 14.2211 5.7174 14.1562C5.63006 14.0914 5.5564 14.0099 5.50065 13.9165C5.4449 13.8231 5.40817 13.7196 5.39257 13.6119C5.37696 13.5042 5.3828 13.3945 5.40974 13.2891L6.02256 10.933C6.08024 10.7207 6.21887 10.5395 6.40866 10.4284C6.59844 10.3173 6.82421 10.2852 7.03742 10.3389C7.14295 10.3652 7.24223 10.4121 7.32957 10.4769C7.41691 10.5417 7.49058 10.6232 7.54633 10.7166C7.60208 10.81 7.63881 10.9136 7.65441 11.0213C7.67001 11.1289 7.66418 11.2387 7.63724 11.3441L7.02441 13.7002C6.97733 13.8781 6.87265 14.0355 6.72674 14.1476C6.58082 14.2598 6.40189 14.3204 6.2179 14.32Z"
            fill="#157BF0"
        />
        <path
            d="M11.888 11.0053C11.8178 11.0055 11.7478 10.9968 11.6797 10.9795L9.30081 10.3726C9.19529 10.3463 9.096 10.2994 9.00866 10.2346C8.92132 10.1698 8.84766 10.0883 8.79191 9.99487C8.73616 9.90145 8.69943 9.79791 8.68383 9.69023C8.66822 9.58254 8.67406 9.47283 8.701 9.36741C8.75829 9.15486 8.89686 8.9734 9.08676 8.86225C9.27665 8.75109 9.50263 8.71916 9.71586 8.77336L12.0947 9.38032C12.2907 9.42902 12.462 9.54803 12.5761 9.71477C12.6902 9.88151 12.7391 10.0844 12.7136 10.2848C12.6881 10.4853 12.5899 10.6694 12.4378 10.8022C12.2856 10.935 12.0899 11.0073 11.888 11.0053L11.888 11.0053Z"
            fill="#157BF0"
        />
        <path
            d="M5.2487 9.31058C5.17844 9.31076 5.10844 9.3021 5.04035 9.28481L2.66149 8.67866C2.55594 8.65243 2.45662 8.60557 2.36926 8.54076C2.28189 8.47595 2.20821 8.39448 2.15245 8.30105C2.0967 8.20761 2.05997 8.10406 2.04439 7.99636C2.02881 7.88865 2.03468 7.77893 2.06167 7.67351C2.11903 7.461 2.2576 7.27958 2.44748 7.16843C2.63736 7.05729 2.86331 7.02533 3.07653 7.07945L5.4554 7.68558C5.65138 7.73429 5.82267 7.85331 5.93675 8.02004C6.05083 8.18678 6.09977 8.38962 6.07427 8.59007C6.04877 8.79053 5.95061 8.97463 5.79842 9.10745C5.64623 9.24027 5.45061 9.31255 5.24869 9.31057L5.2487 9.31058Z"
            fill="#157BF0"
        />
        <defs>
            <linearGradient
                id="7f12d9c4__paint0_linear_7649_66"
                x1={39.5438}
                y1={7.32832}
                x2={66.494}
                y2={73.1436}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE572" />
                <stop offset={1} stopColor="#FFAD0D" />
            </linearGradient>
            <linearGradient
                id="7f12d9c4__paint1_linear_7649_66"
                x1={29.0786}
                y1={9.14412}
                x2={55.6915}
                y2={61.5032}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE572" />
                <stop offset={1} stopColor="#FFAD0E" />
            </linearGradient>
            <linearGradient
                id="7f12d9c4__paint2_linear_7649_66"
                x1={918.658}
                y1={1448.68}
                x2={1051.32}
                y2={1579.66}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0026} stopColor="#D8E5FF" />
                <stop offset={0.99879} stopColor="#0269E8" />
            </linearGradient>
        </defs>
    </svg>
);

export default AdLowPriceM;
