import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AlarmLightM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 190 128"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M161.184 107H77.9031C61.5697 107 66.067 89.2629 75.2904 86.3996C82.6939 84.0765 86.5981 86.6203 86.5981 86.6203C86.5981 86.6203 90.7079 68.5753 104.64 68.0352C108.563 67.8117 112.473 68.6555 115.945 70.4749C119.418 72.2943 122.32 75.0199 124.337 78.3557C124.337 78.3557 133.502 71.9671 145.168 77.6472C156.834 83.3272 155.466 92.4572 155.466 92.4572C155.466 92.4572 162.558 90.3025 168.506 94.6119C174.453 98.9213 173.308 107 161.184 107Z"
            fill="#EDF2F7"
        />
        <path
            d="M108.079 69.5638H24.5282C3.8996 69.5638 13.2067 47.1994 21.0048 45.5543C28.8029 43.9092 34.0814 46.9209 34.0814 46.9209C34.0814 46.9209 37.6501 28.5657 53.026 28.0217C68.4019 27.4776 73.0328 37.3612 73.0328 37.3612C73.0328 37.3612 80.6949 31.5321 92.6187 39.0063C100.902 44.1877 101.757 51.8886 101.757 51.8886C101.757 51.8886 109.53 49.6995 116.097 54.0843C122.664 58.469 121.376 69.5638 108.079 69.5638Z"
            fill="#EDF2F7"
        />
        <path
            d="M142.551 80.7877C148.962 55.0098 134.023 29.102 108.245 22.6985C78.1134 15.1811 55.6226 31.8014 49.1918 57.552C42.761 83.3026 58.2947 110.174 84.0453 116.605C109.796 123.036 136.141 106.573 142.551 80.7877Z"
            fill="#E31740"
        />
        <path
            d="M136.818 79.3595C143.228 53.5816 128.289 27.6738 102.504 21.2703C72.3796 13.7528 49.882 30.3732 43.4512 56.1238C37.0204 81.8744 52.5541 108.746 78.3389 115.183C104.124 121.621 130.407 105.144 136.818 79.3595Z"
            fill="#FF3737"
        />
        <path
            d="M129.006 77.4863C134.35 56.0069 121.906 34.4319 100.426 29.0877C75.3249 22.8551 56.5655 36.6666 51.2282 58.146C45.8908 79.6253 58.8139 102.007 80.2864 107.351C101.759 112.695 123.669 98.9656 129.006 77.4863Z"
            fill="#DAE7F2"
        />
        <path
            d="M131.043 78.1572C136.38 56.6778 123.942 35.1028 102.456 29.7518C80.2045 24.223 58.6022 37.3375 53.258 58.8169C47.9138 80.2962 60.8437 102.671 82.3231 108.022C103.802 113.373 125.699 99.6365 131.043 78.1572Z"
            fill="white"
        />
        <path
            d="M100.03 43.0234L90.5923 68.0086"
            stroke="#18123D"
            strokeWidth={2.89043}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M119.487 56.8013L92.0276 68.631"
            stroke="#18123D"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M95.7862 69.5247C95.9401 68.9547 95.9788 68.3598 95.9 67.7747C95.8213 67.1896 95.6267 66.626 95.3276 66.117C95.0286 65.608 94.631 65.1637 94.1583 64.81C93.6855 64.4564 93.147 64.2006 92.5742 64.0575C91.9942 63.875 91.3822 63.817 90.7782 63.8874C90.1742 63.9578 89.5919 64.1549 89.0694 64.4658C88.5468 64.7768 88.0959 65.1946 87.7459 65.6918C87.396 66.1891 87.155 66.7546 87.0387 67.3515C86.8896 67.9276 86.8561 68.5275 86.9402 69.1165C87.0244 69.7056 87.2244 70.2722 87.5287 70.7835C87.8331 71.2948 88.2358 71.7407 88.7135 72.0955C89.1912 72.4503 89.7345 72.7069 90.312 72.8505C90.8895 72.994 91.4896 73.0218 92.0779 72.932C92.6661 72.8423 93.2308 72.6368 93.7391 72.3276C94.2475 72.0184 94.6896 71.6114 95.0398 71.1303C95.39 70.6492 95.6414 70.1035 95.7794 69.5247H95.7862Z"
            fill="#18123D"
        />
        <path
            d="M102.224 35.7514C102.311 35.4229 102.332 35.0803 102.285 34.7436C102.239 34.407 102.125 34.0829 101.952 33.7904C101.78 33.4978 101.55 33.2426 101.277 33.0396C101.005 32.8365 100.695 32.6898 100.365 32.6077C100.033 32.503 99.6824 32.4689 99.3364 32.5077C98.9903 32.5466 98.6562 32.6574 98.3556 32.8332C98.055 33.0089 97.7945 33.2456 97.5908 33.5281C97.3872 33.8106 97.245 34.1327 97.1734 34.4734C97.0775 34.8094 97.0503 35.1612 97.0932 35.5079C97.1362 35.8546 97.2485 36.1891 97.4234 36.4915C97.5983 36.794 97.8323 37.0581 98.1115 37.2682C98.3906 37.4782 98.7091 37.63 99.0482 37.7144C99.3872 37.7988 99.7397 37.8142 100.085 37.7595C100.43 37.7048 100.76 37.5812 101.057 37.3962C101.353 37.2111 101.609 36.9683 101.809 36.6822C102.01 36.3961 102.151 36.0726 102.224 35.7309V35.7514Z"
            fill="#DAE7F2"
        />
        <path
            d="M85.5211 102.931C85.6063 102.602 85.6257 102.26 85.5783 101.924C85.5309 101.588 85.4176 101.265 85.2449 100.973C85.0722 100.681 84.8434 100.426 84.5719 100.222C84.3003 100.019 83.9911 99.8708 83.6623 99.7872C83.3287 99.6826 82.977 99.6492 82.6297 99.6893C82.2825 99.7294 81.9476 99.842 81.6467 100.02C81.3457 100.198 81.0856 100.437 80.883 100.722C80.6804 101.006 80.54 101.331 80.4708 101.673C80.3749 102.009 80.3477 102.361 80.3906 102.708C80.4336 103.055 80.5458 103.389 80.7208 103.691C80.8957 103.994 81.1297 104.258 81.4088 104.468C81.688 104.678 82.0065 104.83 82.3455 104.914C82.6845 104.999 83.0371 105.014 83.3821 104.959C83.7272 104.905 84.0577 104.781 84.354 104.596C84.6503 104.411 84.9063 104.168 85.1068 103.882C85.3074 103.596 85.4482 103.272 85.5211 102.931Z"
            fill="#DAE7F2"
        />
        <path
            d="M94.4193 69.1898C94.5741 68.6198 94.6135 68.0246 94.5352 67.4392C94.4569 66.8537 94.2624 66.2898 93.9633 65.7806C93.6641 65.2713 93.2662 64.827 92.7929 64.4735C92.3197 64.1201 91.7806 63.8648 91.2073 63.7226C90.6273 63.5389 90.015 63.4801 89.4107 63.55C88.8063 63.6199 88.2236 63.8169 87.7007 64.128C87.1779 64.4391 86.7268 64.8573 86.3771 65.3551C86.0275 65.853 85.7871 66.4192 85.6718 67.0166C85.5291 67.5909 85.5009 68.1878 85.5889 68.773C85.6769 69.3583 85.8792 69.9205 86.1845 70.4275C86.4897 70.9346 86.8918 71.3766 87.3679 71.7282C87.8439 72.0798 88.3846 72.3343 88.9589 72.4769C89.5333 72.6196 90.1302 72.6478 90.7154 72.5598C91.3007 72.4719 91.8629 72.2695 92.3699 71.9642C92.877 71.659 93.3189 71.2569 93.6706 70.7808C94.0222 70.3048 94.2766 69.7642 94.4193 69.1898Z"
            fill="#002669"
        />
        <path
            d="M124.325 79.6192C124.654 79.7044 124.996 79.7238 125.332 79.6764C125.668 79.629 125.991 79.5157 126.283 79.343C126.575 79.1703 126.83 78.9416 127.034 78.67C127.237 78.3984 127.385 78.0892 127.469 77.7604C127.573 77.4264 127.606 77.0741 127.566 76.7265C127.525 76.3789 127.412 76.0437 127.234 75.7427C127.055 75.4416 126.815 75.1816 126.53 74.9793C126.244 74.7771 125.919 74.6373 125.576 74.5689C125.239 74.4701 124.885 74.4406 124.536 74.4821C124.188 74.5235 123.851 74.6351 123.547 74.81C123.242 74.985 122.976 75.2198 122.765 75.5002C122.553 75.7806 122.401 76.1009 122.316 76.4418C122.232 76.7826 122.217 77.1371 122.273 77.4838C122.33 77.8304 122.455 78.1622 122.643 78.459C122.831 78.7558 123.076 79.0116 123.365 79.211C123.655 79.4104 123.981 79.5493 124.325 79.6192Z"
            fill="#DAE7F2"
        />
        <path
            d="M57.1464 62.9097C57.4745 62.9969 57.8166 63.0181 58.1529 62.9719C58.4892 62.9258 58.813 62.8133 59.1054 62.641C59.3979 62.4687 59.6532 62.24 59.8566 61.9682C60.0599 61.6964 60.2073 61.3869 60.29 61.0577C60.3946 60.7233 60.4277 60.3706 60.3873 60.0226C60.3468 59.6745 60.2337 59.3389 60.0552 59.0373C59.8768 58.7358 59.6369 58.4751 59.3513 58.2722C59.0656 58.0693 58.7405 57.9286 58.397 57.8594C58.06 57.7607 57.7065 57.7311 57.3578 57.7726C57.009 57.814 56.6723 57.9256 56.3678 58.1006C56.0633 58.2755 55.7974 58.5103 55.5859 58.7907C55.3745 59.0711 55.222 59.3914 55.1376 59.7323C55.0532 60.0732 55.0386 60.4276 55.0947 60.7743C55.1509 61.1209 55.2765 61.4527 55.4642 61.7495C55.6519 62.0464 55.8976 62.3022 56.1867 62.5016C56.4758 62.7009 56.8022 62.8398 57.1464 62.9097Z"
            fill="#DAE7F2"
        />
        <path
            d="M83.3686 34.5152C83.2794 34.1893 83.1265 33.8843 82.919 33.6177C82.7114 33.3511 82.4531 33.1282 82.159 32.9617C81.8649 32.7953 81.5409 32.6887 81.2054 32.648C80.87 32.6074 80.5298 32.6334 80.2045 32.7247C79.8626 32.8004 79.5405 32.9471 79.2591 33.1555C78.9777 33.3638 78.7433 33.6291 78.5712 33.934C78.3991 34.2389 78.2931 34.5767 78.2601 34.9252C78.2271 35.2738 78.2679 35.6254 78.3798 35.9572C78.4683 36.2926 78.6229 36.607 78.8346 36.8818C79.0463 37.1567 79.3107 37.3864 79.6125 37.5576C79.9142 37.7288 80.2471 37.838 80.5916 37.8787C80.9361 37.9195 81.2852 37.891 81.6186 37.7949C81.9519 37.6988 82.2627 37.5371 82.5326 37.3192C82.8026 37.1013 83.0263 36.8317 83.1906 36.5262C83.3549 36.2207 83.4565 35.8854 83.4894 35.5401C83.5223 35.1947 83.4859 34.8463 83.3823 34.5152H83.3686Z"
            fill="#DAE7F2"
        />
        <path
            d="M102.49 101.051C102.402 100.723 102.249 100.415 102.041 100.147C101.833 99.8785 101.573 99.6541 101.278 99.4869C100.982 99.3196 100.656 99.2128 100.318 99.1727C99.9811 99.1326 99.6392 99.16 99.3125 99.2532C98.9712 99.3298 98.6497 99.4772 98.3689 99.6858C98.0881 99.8944 97.8542 100.16 97.6822 100.464C97.5102 100.769 97.4041 101.106 97.3706 101.454C97.3371 101.803 97.3771 102.154 97.4878 102.486C97.5723 102.825 97.7243 103.144 97.9347 103.423C98.1451 103.702 98.4096 103.936 98.7124 104.111C99.0152 104.286 99.3501 104.398 99.6972 104.441C100.044 104.483 100.396 104.455 100.732 104.359C101.068 104.263 101.382 104.1 101.653 103.879C101.925 103.659 102.15 103.387 102.314 103.078C102.478 102.769 102.578 102.431 102.608 102.082C102.639 101.734 102.599 101.383 102.49 101.051Z"
            fill="#DAE7F2"
        />
        <path
            d="M68.9148 43.2282C68.6754 42.9871 68.3906 42.7957 68.0768 42.6651C67.7631 42.5345 67.4266 42.4673 67.0867 42.4673C66.7469 42.4673 66.4104 42.5345 66.0967 42.6651C65.7829 42.7957 65.4981 42.9871 65.2586 43.2282C65.0009 43.465 64.7958 43.7534 64.6568 44.0746C64.5178 44.3959 64.4479 44.7428 64.4518 45.0928C64.4557 45.4428 64.5332 45.7881 64.6792 46.1062C64.8253 46.4243 65.0367 46.7081 65.2996 46.9391C65.5431 47.1883 65.834 47.3861 66.1553 47.5208C66.4765 47.6555 66.8216 47.7244 67.1699 47.7233C67.5183 47.7223 67.8629 47.6514 68.1833 47.5148C68.5038 47.3781 68.7935 47.1786 69.0355 46.928C69.2774 46.6773 69.4666 46.3807 69.5918 46.0556C69.7171 45.7306 69.7758 45.3837 69.7646 45.0355C69.7533 44.6873 69.6723 44.3449 69.5264 44.0286C69.3804 43.7123 69.1725 43.4285 68.9148 43.194V43.2282Z"
            fill="#DAE7F2"
        />
        <path
            d="M118.735 91.2854C118.494 91.0467 118.208 90.8581 117.893 90.7306C117.579 90.603 117.242 90.5389 116.903 90.5421C116.564 90.5453 116.228 90.6156 115.916 90.7491C115.604 90.8825 115.322 91.0764 115.085 91.3196C114.828 91.5564 114.622 91.8448 114.483 92.166C114.344 92.4873 114.275 92.8342 114.278 93.1842C114.282 93.5342 114.36 93.8795 114.506 94.1976C114.652 94.5156 114.863 94.7994 115.126 95.0305C115.368 95.2884 115.659 95.4946 115.983 95.6364C116.306 95.7781 116.655 95.8526 117.009 95.8552C117.362 95.8577 117.712 95.7884 118.038 95.6514C118.363 95.5143 118.657 95.3125 118.903 95.0581C119.148 94.8037 119.338 94.502 119.463 94.1715C119.588 93.8411 119.644 93.4886 119.629 93.1357C119.613 92.7828 119.526 92.4367 119.372 92.1186C119.218 91.8005 119.001 91.517 118.735 91.2854Z"
            fill="#DAE7F2"
        />
        <path
            d="M125.692 60.5246C126.02 60.4368 126.327 60.2849 126.596 60.0776C126.865 59.8702 127.09 59.6117 127.258 59.3168C127.427 59.022 127.535 58.6966 127.577 58.3597C127.619 58.0227 127.594 57.6808 127.503 57.3537C127.428 57.0119 127.282 56.6897 127.074 56.408C126.867 56.1262 126.602 55.891 126.298 55.7178C125.994 55.5445 125.657 55.437 125.309 55.4021C124.961 55.3672 124.609 55.4058 124.277 55.5153C123.939 55.6 123.622 55.7517 123.343 55.9614C123.065 56.1711 122.832 56.4345 122.657 56.736C122.483 57.0375 122.37 57.3709 122.327 57.7166C122.284 58.0623 122.31 58.4132 122.405 58.7485C122.499 59.0838 122.66 59.3967 122.878 59.6686C123.096 59.9405 123.366 60.166 123.673 60.3316C123.979 60.4972 124.316 60.5996 124.663 60.6328C125.009 60.666 125.359 60.6292 125.692 60.5246Z"
            fill="#DAE7F2"
        />
        <path
            d="M59.0669 79.326C59.3942 79.2382 59.7009 79.0864 59.9692 78.8796C60.2376 78.6727 60.4625 78.4148 60.6308 78.1208C60.7991 77.8267 60.9076 77.5022 60.95 77.166C60.9924 76.8298 60.968 76.4886 60.878 76.1619C60.8046 75.819 60.6597 75.4954 60.4528 75.2123C60.246 74.9291 59.9817 74.6928 59.6773 74.5187C59.373 74.3446 59.0353 74.2366 58.6864 74.2018C58.3374 74.167 57.9851 74.2061 57.6523 74.3167C57.3144 74.4014 56.9969 74.5531 56.7186 74.7628C56.4404 74.9725 56.2071 75.2359 56.0325 75.5374C55.8579 75.8389 55.7455 76.1723 55.7022 76.518C55.6588 76.8637 55.6852 77.2146 55.7799 77.5499C55.8746 77.8852 56.0356 78.198 56.2534 78.47C56.4712 78.7419 56.7413 78.9674 57.0479 79.133C57.3544 79.2986 57.691 79.401 58.0378 79.4342C58.3846 79.4673 58.7346 79.4306 59.0669 79.326Z"
            fill="#DAE7F2"
        />
        <path
            d="M116.869 44.2803C117.11 44.0414 117.301 43.7572 117.432 43.444C117.562 43.1308 117.629 42.7949 117.629 42.4556C117.629 42.1164 117.562 41.7804 117.432 41.4673C117.301 41.1541 117.11 40.8698 116.869 40.631C116.635 40.3706 116.349 40.1624 116.029 40.0199C115.71 39.8774 115.364 39.8037 115.014 39.8037C114.664 39.8037 114.317 39.8774 113.998 40.0199C113.678 40.1624 113.392 40.3706 113.158 40.631C112.919 40.876 112.731 41.1656 112.604 41.4833C112.478 41.801 112.415 42.1406 112.419 42.4826C112.424 42.8247 112.495 43.1625 112.63 43.4768C112.765 43.7911 112.961 44.0758 113.206 44.3145C113.451 44.5532 113.741 44.7413 114.058 44.8681C114.376 44.9949 114.716 45.0579 115.058 45.0535C115.4 45.049 115.738 44.9773 116.052 44.8423C116.366 44.7073 116.651 44.5117 116.89 44.2667L116.869 44.2803Z"
            fill="#DAE7F2"
        />
        <path
            d="M68.5868 93.8687C68.8277 93.6298 69.019 93.3456 69.1495 93.0324C69.28 92.7192 69.3472 92.3833 69.3472 92.044C69.3472 91.7047 69.28 91.3688 69.1495 91.0556C69.019 90.7425 68.8277 90.4582 68.5868 90.2193C68.3529 89.959 68.0668 89.7508 67.7471 89.6083C67.4275 89.4657 67.0814 89.3921 66.7314 89.3921C66.3814 89.3921 66.0353 89.4657 65.7156 89.6083C65.396 89.7508 65.1099 89.959 64.8759 90.2193C64.616 90.4591 64.4076 90.7493 64.2634 91.0722C64.1193 91.3952 64.0425 91.7441 64.0376 92.0977C64.0327 92.4513 64.1 92.8022 64.2352 93.129C64.3704 93.4558 64.5708 93.7516 64.8241 93.9984C65.0774 94.2452 65.3783 94.4378 65.7085 94.5644C66.0387 94.6911 66.3912 94.7492 66.7446 94.7351C67.0979 94.7211 67.4447 94.6352 67.7638 94.4827C68.0829 94.3302 68.3676 94.1143 68.6005 93.8482L68.5868 93.8687Z"
            fill="#DAE7F2"
        />
        <path
            d="M92.7448 68.7868C92.8391 68.4358 92.8624 68.0696 92.8135 67.7094C92.7645 67.3493 92.6443 67.0026 92.4597 66.6895C92.2752 66.3765 92.0301 66.1033 91.7387 65.8861C91.4474 65.6689 91.1156 65.5119 90.7629 65.4244C90.4061 65.3126 90.0297 65.277 89.6582 65.3198C89.2867 65.3626 88.9284 65.4829 88.6063 65.6729C88.2842 65.863 88.0056 66.1185 87.7885 66.4229C87.5714 66.7274 87.4206 67.0741 87.3459 67.4405C87.2562 67.795 87.2371 68.1637 87.2899 68.5255C87.3426 68.8874 87.4661 69.2353 87.6533 69.5494C87.8405 69.8636 88.0878 70.1377 88.3809 70.3563C88.6741 70.5749 89.0074 70.7336 89.3619 70.8233C89.7164 70.9131 90.0851 70.9321 90.447 70.8794C90.8088 70.8266 91.1568 70.7031 91.4709 70.5159C91.785 70.3287 92.0592 70.0814 92.2778 69.7883C92.4964 69.4951 92.655 69.1618 92.7448 68.8073V68.7868Z"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeMiterlimit={10}
        />
        <path
            d="M64.2129 61.9883L87.2777 67.722"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M92.7449 68.7881L97.5014 69.9704"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M44.696 121.465C46.7691 120.284 50.6057 116.613 49.8421 114.255C48.8638 111.225 46.2601 114.561 39.6297 106.974C38.3018 105.441 35.7349 104.38 33.4961 105.248C33.352 104.659 33.2692 102.865 32.3952 101.147C31.1071 98.5897 26.6511 100.712 28.4022 103.564C29.1094 104.716 30.0382 105.715 31.1347 106.505C29.4143 107.673 28.0005 110.01 29.2456 113.099C32.5608 121.403 28.347 123.219 30.2883 125.335C31.8217 127.016 36.8236 125.559 38.9274 124.722"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M33.4854 122.015C35.2573 119.386 41.5922 115.724 45.1962 115.084"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M41.7366 126.175C43.5625 126.175 45.0426 124.695 45.0426 122.869C45.0426 121.044 43.5625 119.563 41.7366 119.563C39.9108 119.563 38.4307 121.044 38.4307 122.869C38.4307 124.695 39.9108 126.175 41.7366 126.175Z"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M149.852 38.2255C146.353 36.2329 139.879 30.0375 141.167 26.0574C142.818 20.9438 147.213 26.575 158.402 13.7703C160.643 11.1824 164.976 9.39162 168.754 10.8563C168.997 9.86261 169.137 6.83482 170.612 3.93642C172.786 -0.380126 180.306 3.20147 177.351 8.01488C176.157 9.95828 174.59 11.6454 172.739 12.9784C175.643 14.9503 178.029 18.8942 175.927 24.1062C170.332 38.122 177.444 41.186 174.168 44.7573C171.58 47.5936 163.138 45.1351 159.588 43.7221"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M168.772 39.1545C165.782 34.7175 155.091 28.5375 149.008 27.4575"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M154.847 46.1754C151.765 46.1754 149.267 43.6774 149.267 40.596C149.267 37.5146 151.765 35.0166 154.847 35.0166C157.928 35.0166 160.426 37.5146 160.426 40.596C160.426 43.6774 157.928 46.1754 154.847 46.1754Z"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export default AlarmLightM;
