import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BarierDarkM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 263 182"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#0ea4dd4e__clip0_15032_1)">
            <mask
                id="0ea4dd4e__mask0_15032_1"
                style={{
                    maskType: 'alpha',
                }}
                maskUnits="userSpaceOnUse"
                x={5}
                y={-8}
                width={253}
                height={439}
            >
                <rect
                    x={5.57422}
                    y={-7.16797}
                    width={252.309}
                    height={437.49}
                    rx={6.1727}
                    fill="white"
                />
            </mask>
            <g mask="url(#0ea4dd4e__mask0_15032_1)">
                <path
                    d="M222.949 52.7207C222.949 52.7207 109.628 136.508 109.628 134.574V181.213C126.829 182.202 145.024 180.538 163.038 175.951C188.185 169.564 208.276 157.241 222.949 142.04V52.7207Z"
                    fill="#808B95"
                />
                <path
                    d="M207.419 32.4832C226.832 37.1156 229.586 61.6267 208.367 96.6168C187.147 131.607 159.156 158.412 126.649 151.531C94.1428 144.65 112.879 104.442 135.002 75.5238C157.124 46.6052 177.17 26.0069 207.419 32.4832Z"
                    fill="#A9B1BC"
                />
                <path
                    d="M160.284 92.1172C136.671 85.6409 124.436 97.6041 121.095 119.057C117.799 140.51 136.536 148.2 159.697 133.359C180.6 120.001 188.411 99.8078 160.284 92.1172Z"
                    fill="#7A7C80"
                />
                <path
                    d="M200.105 91.5347L148.817 75.9735C147.643 75.7037 146.83 74.6693 146.83 73.41L148.094 47.9545C148.094 47.9545 153.241 43.8618 153.738 43.412C154.279 42.8723 155.092 42.6475 155.905 42.7824L206.786 51.4175C207.96 51.6424 208.818 52.7217 208.818 53.981L207.373 78.4471C207.373 79.3916 207.057 80.471 206.786 81.1906C204.89 86.0478 200.105 91.5347 200.105 91.5347Z"
                    fill="#CCD6E3"
                />
                <path
                    d="M200.105 91.5347L148.817 75.9735C147.643 75.7037 146.83 74.6693 146.83 73.41L148.094 47.9545C148.094 47.9545 153.241 43.8618 153.738 43.412C154.279 42.8723 155.092 42.6475 155.905 42.7824L206.786 51.4175C207.96 51.6424 208.818 52.7217 208.818 53.981L207.373 78.4471C207.373 79.3916 207.057 80.471 206.786 81.1906C204.89 86.0478 200.105 91.5347 200.105 91.5347Z"
                    fill="#808B95"
                />
                <path
                    d="M188.321 53.623L167.237 45.7524C166.65 45.6175 166.244 45.0778 166.244 44.4482L165.747 31.0008C165.747 31.0008 167.011 30.5061 168.004 30.1913C169.043 29.8765 170.397 29.3817 170.804 29.4717L194.326 33.3395C194.913 33.4744 195.364 34.0141 195.364 34.6438L194.371 49.8001C194.371 50.115 194.281 50.3848 194.1 50.6097C193.784 51.0144 188.321 53.623 188.321 53.623Z"
                    fill="#808B95"
                />
                <path
                    d="M162.857 49.845L164.799 32.3499C164.799 31.4504 165.566 30.8208 166.379 30.9557L190.985 35.1833C191.617 35.3182 192.068 35.9029 192.068 36.5775L190.669 55.152L162.857 49.845Z"
                    fill="#A9B1BC"
                />
                <path
                    d="M128.049 111.907C128.5 110.423 129.268 108.444 130.803 106.915C131.164 106.555 131.525 106.285 132.022 106.375C142.767 108.669 154.55 111.547 165.566 114.47C166.289 114.65 166.65 115.505 166.244 116.134C166.244 116.134 164.709 119.642 162.812 121.306C162.451 121.621 162.09 121.846 161.639 121.756C149.539 119.283 137.304 116.134 128.771 113.481C128.049 113.301 127.868 112.581 128.049 111.907Z"
                    fill="#616366"
                />
                <path
                    d="M184.665 49.394L169.54 46.2908C169.179 46.2008 168.908 45.841 168.908 45.4812L169.901 36.3514C169.901 35.8567 170.353 35.4519 170.85 35.5419L185.658 38.0155C186.064 38.1054 186.335 38.4203 186.335 38.825L185.703 48.5845C185.658 49.1242 185.161 49.5289 184.665 49.394Z"
                    fill="#616366"
                />
                <path
                    d="M91.2522 152.881C91.2522 152.881 110.982 134.126 115 127.02C117.573 122.388 63.9829 90.3213 63.9829 90.3213C63.9829 90.3213 71.658 84.1148 73.3285 77.7734C75.2699 70.4426 70.123 62.8869 66.8723 67.8341C61.274 76.4242 55.3145 80.7867 54.0052 83.9349C52.6959 87.0382 52.6959 102.374 55.2242 114.563C57.301 124.727 61.8609 137.095 64.3441 140.018C66.8272 142.851 91.2522 152.881 91.2522 152.881Z"
                    fill="#FAC4B5"
                />
                <path
                    d="M124.616 38.6895C127.009 41.298 126.377 44.8959 126.151 46.3801C123.533 62.9757 105.88 119.554 100.191 124.006C93.961 128.818 57.2107 124.501 57.3009 116.54C57.3912 108.085 80.823 42.6472 84.3897 38.3746C87.8661 34.0571 119.47 32.9777 124.616 38.6895Z"
                    fill="#222F65"
                />
                <path
                    d="M118.025 42.5574C118.882 47.7295 98.2497 116.495 93.6447 119.644C89.0396 122.792 62.2669 116.945 61.2736 114.202C60.2804 111.458 83.1252 44.986 86.6467 41.613C89.9877 38.3748 117.076 36.8007 118.025 42.5574Z"
                    fill="#505356"
                    stroke="#222F65"
                    strokeWidth={0.834554}
                    strokeMiterlimit={10}
                />
                <path
                    d="M114.323 128.055C119.831 120.904 116.264 116.406 116.264 116.406C116.264 116.406 121.005 114.877 123.037 105.118C123.849 101.34 120.147 97.5169 120.147 97.5169C120.147 97.5169 123.172 94.8634 123.217 90.0061C123.262 85.1489 122.991 81.1911 122.45 73.6354C121.953 67.1141 116.309 68.1486 113.601 74.1302C111.93 77.8181 111.208 88.522 111.208 88.522C111.208 88.522 101.817 87.9823 91.5233 94.1888C89.0402 95.7179 88.4533 100.98 92.2005 102.869C87.8663 105.702 89.4465 111.324 92.8326 112.853C97.5731 115.057 101.275 114.472 101.275 114.472L114.323 128.055Z"
                    fill="#FAC4B5"
                />
                <path
                    d="M109.627 38.0596C109.627 38.0596 108.633 41.8374 107.144 42.6919C105.654 43.5914 95.6309 43.5914 94.2313 42.647C92.8317 41.7025 94.3216 38.3294 94.3216 38.3294C99.7845 37.5649 104.886 37.5199 109.627 38.0596Z"
                    fill="#222F65"
                />
                <path
                    d="M116.941 103.408C113.826 101.339 105.429 98.7307 92.2002 102.913"
                    stroke="#F3977A"
                    strokeWidth={1.66913}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                    strokeLinejoin="round"
                />
                <path
                    d="M85.0215 131.427C88.8591 126.704 95.4958 124.006 101.591 123.961L103.532 118.384C95.9473 110.963 100.372 106.421 103.938 107.815C107.911 109.389 114.909 114.381 115.361 115.371"
                    stroke="#F3977A"
                    strokeWidth={1.66913}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                    strokeLinejoin="round"
                />
                <path
                    d="M118.928 95.0413C117.212 93.0175 114.594 90.4989 112.427 88.9248"
                    stroke="#F3977A"
                    strokeWidth={1.66913}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                    strokeLinejoin="round"
                />
                <path
                    d="M102.857 76.0652C102.767 76.3351 102.451 76.515 102.18 76.515C100.735 76.38 99.2905 76.2901 97.8909 76.1552C97.6651 76.1552 97.5748 76.2001 97.4845 76.425C97.1234 77.5044 96.717 78.5838 96.401 79.7081C96.3558 79.888 96.1753 79.978 95.9947 79.978C94.1887 79.7981 92.428 79.6182 90.6221 79.4833C90.3963 79.4833 90.3512 79.3933 90.4415 79.1684C90.8027 78.0891 91.1638 77.0097 91.525 75.9303C91.6153 75.7504 91.5702 75.6604 91.3444 75.6604C90.2157 75.5705 89.1322 75.4805 88.0035 75.3906C87.7777 75.3906 87.7326 75.3006 87.8229 75.1207C88.4098 73.4117 88.9516 71.7027 89.5385 69.9937C89.5837 69.8138 89.674 69.7238 89.8546 69.7688C90.9832 69.8587 92.1119 69.9037 93.2406 69.9937C93.3761 69.9937 93.4664 70.1286 93.4212 70.2635C93.2406 70.7132 93.1052 71.208 92.9698 71.6577C92.9246 71.8376 92.8343 71.9276 92.6086 71.8826C92.1119 71.8376 91.6153 71.8376 91.1638 71.7926C90.9381 71.7926 90.893 71.8826 90.8478 72.1075C90.7575 72.5122 90.6221 72.917 90.4415 73.3218C90.306 73.5916 90.3512 73.6816 90.5769 73.6816C91.7056 73.7715 92.8343 73.8615 93.963 73.9514C94.1887 73.9514 94.2339 74.0414 94.1436 74.2662C93.7824 75.3456 93.4212 76.425 93.0149 77.5044C92.9246 77.7742 93.0149 77.8192 93.4212 77.7742C93.7824 77.7742 94.1436 77.8192 94.4596 77.8642C94.7757 77.9541 94.866 77.9092 94.9563 77.6393C95.3174 76.5599 95.6786 75.4805 96.0398 74.3562C96.1301 74.0863 96.2204 74.0414 96.4461 74.0863C98.5681 74.2662 100.735 74.4461 102.947 74.5811C103.128 74.5811 103.218 74.716 103.173 74.8959L102.857 76.0652Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M83.7587 87.1719C83.8038 87.0819 83.849 86.992 83.8941 86.902C84.7519 84.3834 85.5646 81.8649 86.4224 79.3463C86.5127 79.1214 86.4676 78.9865 86.1967 78.9865C84.8874 78.9865 83.4878 78.7167 82.1334 78.6267C81.9076 78.6267 81.8625 78.5368 81.9528 78.3119C82.1334 77.8622 82.2688 77.4124 82.4043 76.9627C82.4494 76.7828 82.4946 76.7378 82.6751 76.7378C84.9777 77.0526 86.7385 77.0976 88.8604 77.2775C89.1313 77.2775 89.041 77.4124 88.9958 77.5923C88.138 80.2008 87.2802 82.7644 86.3773 85.2829C86.287 85.5528 86.3321 85.5977 86.603 85.6427C87.2351 85.6877 87.8671 85.7776 88.4992 85.8676C89.041 85.9575 89.5828 85.9575 90.0794 86.0925C89.944 86.6771 89.6731 87.2618 89.5376 87.8465L83.7587 87.1719Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M88.997 65.7198C88.4101 67.5637 88.2295 68.913 87.3717 70.7119C87.1008 71.3416 86.6945 71.3866 86.6042 71.3866C84.8434 71.2516 83.4438 71.1617 81.683 71.0268C81.0961 70.9818 80.7801 70.4871 81.0058 69.9024C81.5927 68.1484 81.8636 67.2939 82.4054 65.5399C82.4506 65.405 82.7666 64.4605 83.6696 64.5055C85.4755 64.5954 86.559 64.6404 88.3649 64.7303C88.8616 64.7303 89.1324 65.1801 88.997 65.7198ZM83.805 69.2728C84.3919 69.3177 85.024 69.3627 85.6561 69.4077C85.7464 69.4077 85.8818 69.3177 85.9269 69.2278C86.1978 68.4182 86.4687 67.6087 86.7396 66.7992C86.7848 66.6193 86.7396 66.5743 86.4236 66.6193C85.8818 66.6642 85.3852 66.6642 84.8885 66.6193C84.0759 66.4843 83.9856 66.3494 83.8953 66.8441C83.7598 67.5637 83.5341 68.2833 83.2181 68.9579C83.0826 69.2278 83.1278 69.2728 83.3084 69.2728C83.4438 69.2278 83.6244 69.2278 83.805 69.2728Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M77.8903 80.0215C79.8768 80.1114 81.9084 80.2913 83.8498 80.6062C83.9401 80.6062 84.0304 80.6961 83.9852 80.831C83.308 82.8998 82.6308 84.9237 81.9084 86.9476C79.8316 86.6777 77.8 86.4528 75.8135 86.183C75.7232 86.183 75.6329 86.0481 75.678 85.9581C76.3101 84.0692 76.9422 82.1803 77.5742 80.2913C77.5742 80.2014 77.6645 80.0215 77.8903 80.0215ZM78.2515 83.8443C78.2063 84.0242 78.1612 84.2041 78.0709 84.339C77.9806 84.6089 77.9806 84.6539 78.3418 84.6539C78.9738 84.6539 79.651 84.6988 80.238 84.8787C80.5991 84.9687 80.6894 84.9687 80.7797 84.7438C81.0055 83.9792 81.2764 83.2596 81.5021 82.4951C81.5472 82.3152 81.5472 82.2252 81.3215 82.2252C80.554 82.1803 79.8316 82.0903 79.1093 82.0004C78.9287 81.9554 78.8835 82.0453 78.7932 82.1803C78.6578 82.72 78.432 83.3046 78.2515 83.8443Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M91.7506 87.0835C92.3375 85.3295 92.9244 83.5755 93.5565 81.8215C93.6017 81.7315 93.692 81.6416 93.8274 81.6416C95.9493 81.8665 98.1164 82.0014 100.284 82.3162C100.69 82.3612 100.6 82.676 100.509 82.8109C99.8321 84.7898 99.1097 86.8137 98.4325 88.7476C98.3873 88.8375 98.2519 88.9275 98.1616 88.9275C96.2654 88.7026 94.3692 88.4777 92.5181 88.2528C91.886 88.1629 91.57 87.6232 91.7506 87.0835ZM94.7304 84.475C94.5046 85.0597 94.324 85.6443 94.0983 86.274C94.0531 86.4539 94.0531 86.4988 94.2337 86.5438C95.0915 86.6338 95.9493 86.7237 96.8071 86.8586C96.9877 86.9036 97.078 86.8586 97.1232 86.6338C97.3489 85.8692 97.5747 85.1046 97.8907 84.385C98.0713 83.9803 97.8907 84.0702 97.078 84.0252C96.4911 84.0252 95.9042 83.9353 95.3624 83.8004C95.0012 83.7104 94.9109 83.8004 94.8658 84.0702C94.8206 84.1602 94.7755 84.3401 94.7304 84.475Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M98.8394 66.1695C98.0719 68.0585 97.6204 69.8125 96.9883 71.7014C96.898 72.0162 96.7626 72.0612 96.4466 72.0612C96.0402 72.0162 95.6339 72.0162 95.2276 71.9712C94.7761 71.9263 94.8212 72.0162 94.9567 71.5665C95.4082 70.2172 95.8596 68.823 96.3563 67.4288C96.4466 67.159 96.4014 67.114 96.1305 67.069C94.2343 66.7992 92.609 66.8891 90.8482 66.7992C90.6225 66.7992 90.5322 66.7092 90.6225 66.4844C90.8482 65.9447 90.9385 65.36 91.2094 64.8203C91.2094 64.8203 96.2208 64.8653 98.2976 65.1801C99.02 65.2701 99.02 65.7648 98.8394 66.1695Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M104.256 71.9255C104.121 72.2853 103.714 72.6001 103.308 72.6001C101.953 72.6001 100.599 72.5102 99.2897 72.2853C98.7931 72.1953 99.1091 71.5657 99.1542 71.4308C99.7863 69.5868 99.9218 68.1926 100.87 66.3487C101.186 65.6741 101.321 65.3143 101.999 65.3592C103.398 65.4492 104.798 65.4942 106.242 65.5841C106.333 65.5841 106.423 65.6741 106.378 65.764C106.242 66.1688 106.107 66.5735 105.972 66.9783C105.836 67.3381 105.43 67.608 105.069 67.563C104.346 67.518 103.624 67.473 102.947 67.4281C102.676 67.4281 102.631 67.473 102.54 67.6979C102.269 68.5074 101.999 69.272 101.728 70.0815C101.637 70.3514 101.728 70.3964 101.953 70.3964C102.676 70.4413 103.398 70.4863 104.121 70.5313C104.437 70.5763 104.662 70.8461 104.527 71.1609L104.256 71.9255Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M79.922 73.0964C79.9671 72.9165 80.1477 72.7816 80.3283 72.8266C82.8566 72.8266 84.211 73.1414 86.1975 73.2763C86.5136 73.3213 86.5136 73.4113 86.333 73.816C86.1975 74.1309 86.0621 74.4906 86.0169 74.8504C85.9718 75.1653 85.8815 75.2102 85.6557 75.2102C84.3013 75.0753 82.9469 74.9854 81.5924 74.8504C81.3667 74.8504 81.2764 74.8954 81.2313 75.1203C80.9152 76.1547 80.554 77.1891 80.238 78.2235C80.1929 78.4034 80.1026 78.4934 79.922 78.4484C79.3802 78.4034 78.8836 78.3584 78.3418 78.3135L79.922 73.0964Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M101.592 79.7069C101.457 80.1117 101.005 80.3816 100.554 80.3366C99.8766 80.2916 99.2446 80.2016 98.5673 80.1567C98.2513 80.1117 98.2513 80.0218 98.3868 79.7069C98.5673 79.3471 98.7028 78.9424 98.7931 78.5826C98.8834 78.2677 98.9285 78.1778 99.1994 78.2228C99.8766 78.3127 100.554 78.3577 101.231 78.4027C101.637 78.4476 101.863 78.7625 101.728 79.1672L101.592 79.7069Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M90.9836 83.4391C90.9385 83.619 90.8482 83.7539 90.803 83.9338C90.7579 84.1587 90.7127 84.2486 90.4418 84.2037C89.9904 84.1137 89.4937 84.0687 89.0423 84.0238C88.8165 84.0238 88.7714 83.9788 88.8165 83.7989C89.0874 82.9893 89.3583 82.2248 89.6292 81.4152C89.7195 81.1904 89.8098 81.1904 90.1258 81.2803C90.487 81.3703 90.8933 81.3703 91.2997 81.3703C91.5705 81.3703 91.6157 81.4152 91.5705 81.5951C91.3899 82.2248 91.2094 82.8544 90.9836 83.4391Z"
                    fill="#EDF2F7"
                />
                <path
                    d="M75.0448 40.937C72.5166 40.3074 69.9883 39.6777 67.46 39.0931C67.0988 39.0031 66.7376 38.9132 66.3764 38.8232C65.338 38.5534 64.1191 39.138 63.8933 40.2174C63.6676 41.2518 64.2093 42.4212 65.2929 42.691C67.8212 43.3207 70.3495 43.9503 72.8777 44.535C73.2389 44.6249 73.6001 44.7149 73.9613 44.8048C74.9997 45.0747 76.2187 44.49 76.4444 43.4106C76.7153 42.3762 76.1735 41.2069 75.0448 40.937Z"
                    fill="#CCD6E3"
                />
                <path
                    d="M81.7264 33.0684C79.5142 31.2694 77.3019 29.5154 75.0897 27.7164C71.5682 24.8831 68.0918 22.0497 64.5702 19.2612C63.7576 18.6316 62.9449 17.957 62.1774 17.3273C61.3647 16.6527 60.1006 16.4728 59.2879 17.3273C58.6107 18.0469 58.385 19.4861 59.2879 20.2057C61.5002 22.0047 63.7124 23.7587 65.9247 25.5577C69.4462 28.3911 72.9226 31.2245 76.4441 34.0129C77.2568 34.6425 78.0695 35.3171 78.837 35.9468C79.6496 36.6214 80.9138 36.8013 81.7264 35.9468C82.4037 35.1822 82.5842 33.788 81.7264 33.0684Z"
                    fill="#CCD6E3"
                />
                <path
                    d="M90.6207 28.3445C90.0789 26.1408 89.5372 23.937 88.9954 21.7333C88.9051 21.4185 88.86 21.1037 88.7697 20.7888C88.4988 19.7544 87.2798 19.0348 86.2865 19.3946C85.203 19.7544 84.6161 20.7888 84.8869 21.8682C85.4287 24.072 85.9705 26.2757 86.5123 28.4795C86.6026 28.7943 86.6477 29.1091 86.738 29.4239C87.0089 30.4583 88.2279 31.1779 89.2211 30.8181C90.3047 30.5033 90.8916 29.4689 90.6207 28.3445Z"
                    fill="#CCD6E3"
                />
                <path
                    d="M206.245 52.4076C204.303 54.3415 202.362 56.2754 200.375 58.1644C200.104 58.4342 199.834 58.704 199.518 58.9739C199.021 59.4686 198.976 60.4131 199.518 60.8628C200.059 61.3575 200.917 61.4025 201.414 60.8628C203.355 58.9289 205.296 56.995 207.283 55.1061C207.554 54.8362 207.825 54.5664 208.141 54.2965C208.637 53.8018 208.683 52.8574 208.141 52.4076C207.644 51.9129 206.786 51.8679 206.245 52.4076Z"
                    fill="#A9B1BC"
                />
                <path
                    d="M93.2849 179.37C96.084 170.24 97.7094 163.359 97.7094 160.526C97.8448 147.303 55.9927 122.747 50.0332 130.887C45.8344 136.599 40.3264 144.02 34.2314 152.25C48.8594 166.192 69.6725 175.502 93.2849 179.37Z"
                    fill="#222F65"
                />
                <path
                    d="M83.3069 60.6379C88.5441 60.548 93.7812 60.8628 98.9732 61.2676C101.682 61.4924 104.391 61.7623 107.1 62.1221C107.822 62.212 108.454 61.4475 108.454 60.7728C108.454 59.9633 107.822 59.5136 107.1 59.4236C99.6956 58.4791 92.2462 57.9844 84.7968 57.9395C84.3002 57.9395 83.8035 57.9395 83.3069 57.9395C81.5461 57.9844 81.5461 60.6829 83.3069 60.6379Z"
                    fill="#A9B1BC"
                />
                <path
                    d="M73.3293 92.8386C78.6116 93.5582 83.8939 94.2328 89.131 94.9074C91.7045 95.2672 94.2779 95.582 96.8513 95.8968C97.5737 95.9868 98.2057 95.2222 98.2057 94.5476C98.2057 93.7381 97.5737 93.2883 96.8513 93.1984C89.5374 92.2539 82.1783 91.2645 74.8643 90.32C74.3225 90.2301 73.8259 90.1851 73.2841 90.0951C72.5618 90.0052 71.9297 90.7698 71.9297 91.4444C71.9748 92.2989 72.5618 92.7037 73.3293 92.8386Z"
                    fill="#A9B1BC"
                />
                <path
                    d="M89.8536 96.4811C90.6211 93.8276 93.2849 92.9731 96.1292 91.8037C97.8899 91.0842 101.502 89.7349 103.804 89.2852C106.152 88.8354 102.224 94.9969 99.1541 95.6266C96.0389 96.2113 89.2215 98.6399 89.8536 96.4811Z"
                    fill="#FAC4B5"
                />
                <path
                    d="M197.757 92.2546L145.837 80.6962C144.663 80.4263 143.851 79.3919 143.851 78.1326L146.875 49.9786C146.921 48.4045 148.32 47.1902 149.855 47.505L200.782 57.1296C201.956 57.3545 202.814 58.4338 202.814 59.6931L200.827 89.781C200.782 91.4001 199.337 92.6144 197.757 92.2546Z"
                    fill="#007CE9"
                />
                <path
                    d="M197.803 92.298L145.883 80.7396C144.709 80.4698 143.896 79.4354 143.896 78.1761L144.393 72.9141L201.099 84.9222L200.783 89.8244C200.828 91.4435 199.383 92.6578 197.803 92.298Z"
                    fill="#F0494A"
                />
                <path
                    d="M186.967 78.0882L158.163 72.1516C157.531 72.0167 157.079 71.432 157.079 70.7574L158.75 54.6566C158.75 53.7571 159.562 53.1274 160.42 53.2624L188.637 58.6143C189.315 58.7492 189.766 59.3339 189.766 60.0535L188.637 76.739C188.637 77.5935 187.825 78.2681 186.967 78.0882Z"
                    fill="#CCD6E3"
                />
                <path
                    d="M179.968 65.8095C179.968 65.9894 179.787 66.0794 179.652 66.0344C178.794 65.8545 177.936 65.7196 177.033 65.5397C176.898 65.4947 176.853 65.5397 176.853 65.6746C176.807 66.3942 176.717 67.0688 176.627 67.7434C176.627 67.8334 176.537 67.9233 176.401 67.8784C175.272 67.6535 174.144 67.4736 173.015 67.2487C172.88 67.2037 172.834 67.1588 172.834 67.0238C172.925 66.3043 172.97 65.6296 173.06 64.91C173.06 64.7751 173.06 64.7301 172.925 64.7301C172.202 64.5952 171.48 64.4603 170.803 64.3254C170.667 64.2804 170.622 64.2354 170.667 64.1005C170.803 62.9761 170.893 61.8968 171.029 60.7724C171.029 60.6375 171.074 60.5925 171.209 60.6375C171.931 60.7724 172.654 60.9073 173.376 61.0422C173.466 61.0422 173.557 61.1322 173.512 61.2221C173.466 61.537 173.421 61.8068 173.421 62.1216C173.421 62.2566 173.376 62.3015 173.241 62.2565C172.925 62.2116 172.609 62.1216 172.293 62.0767C172.157 62.0317 172.112 62.1216 172.112 62.2565C172.112 62.5264 172.067 62.7962 172.022 63.0211C171.977 63.201 172.022 63.246 172.157 63.246C172.88 63.3809 173.602 63.5158 174.279 63.6508C174.415 63.6957 174.46 63.7407 174.46 63.8756C174.369 64.5503 174.324 65.2698 174.234 65.9445C174.234 66.1244 174.279 66.1244 174.55 66.1693C174.776 66.1693 175.002 66.2143 175.227 66.3043C175.453 66.3492 175.498 66.3492 175.498 66.2143C175.543 65.4947 175.634 64.8201 175.724 64.1005C175.724 63.9206 175.814 63.9206 175.95 63.9656C177.259 64.2354 178.568 64.4603 179.878 64.6852C179.968 64.6852 180.058 64.8201 180.058 64.91L179.968 65.8095Z"
                    fill="#505356"
                />
                <path
                    d="M169.764 72.2844C169.764 72.2394 169.81 72.1495 169.81 72.1045C169.99 70.3955 170.171 68.7314 170.351 67.0224C170.351 66.8425 170.351 66.7975 170.171 66.7525C169.313 66.6626 168.365 66.4377 167.462 66.2578C167.326 66.2128 167.281 66.1679 167.281 66.0329C167.326 65.7181 167.372 65.4033 167.372 65.1335C167.372 65.0435 167.417 64.9985 167.507 64.9985C169.042 65.3583 170.216 65.4933 171.57 65.7631C171.751 65.8081 171.706 65.853 171.706 65.988C171.525 67.697 171.345 69.406 171.164 71.1151C171.164 71.295 171.164 71.3399 171.39 71.3849C171.796 71.4299 172.202 71.5198 172.609 71.6098C172.97 71.6997 173.286 71.6997 173.647 71.8346C173.647 72.2394 173.557 72.5992 173.557 73.004L169.764 72.2844Z"
                    fill="#505356"
                />
                <path
                    d="M170.08 58.0283C169.945 59.1976 170.035 60.0971 169.719 61.2215C169.629 61.6262 169.358 61.6262 169.313 61.6262C168.139 61.4013 167.191 61.2215 166.017 60.9966C165.611 60.9066 165.34 60.5468 165.385 60.1421C165.52 58.9727 165.565 58.433 165.701 57.2637C165.701 57.1737 165.791 56.5441 166.378 56.679C167.552 56.9039 168.274 57.0388 169.448 57.2637C169.854 57.3536 170.125 57.6685 170.08 58.0283ZM167.236 59.9622C167.642 60.0521 168.049 60.0971 168.455 60.187C168.545 60.187 168.59 60.1421 168.59 60.0971C168.635 59.5574 168.726 59.0627 168.771 58.523C168.771 58.3881 168.726 58.3881 168.545 58.3431C168.229 58.3431 167.868 58.2981 167.552 58.2082C167.01 58.0283 166.92 57.9383 166.92 58.2531C166.92 58.7479 166.875 59.1976 166.739 59.6473C166.694 59.8272 166.739 59.8722 166.83 59.8722C167.01 59.9172 167.1 59.9622 167.236 59.9622Z"
                    fill="#505356"
                />
                <path
                    d="M164.798 67.0225C166.153 67.2024 167.552 67.4272 168.861 67.787C168.952 67.787 168.997 67.877 168.997 67.922C168.861 69.3162 168.681 70.6654 168.545 72.0596C167.146 71.7898 165.701 71.5199 164.301 71.295C164.211 71.295 164.166 71.2051 164.166 71.1151C164.301 69.8109 164.482 68.5066 164.617 67.2024C164.617 67.1124 164.617 67.0225 164.798 67.0225ZM165.611 69.7209C165.611 69.8559 165.566 69.9458 165.566 70.0807C165.52 70.2606 165.566 70.3056 165.791 70.3056C166.243 70.3506 166.694 70.3955 167.101 70.5305C167.372 70.6204 167.417 70.6204 167.417 70.4405C167.462 69.9458 167.507 69.4061 167.597 68.9114C167.597 68.7765 167.597 68.7315 167.417 68.7315C166.92 68.6415 166.378 68.5516 165.882 68.4616C165.746 68.4167 165.701 68.4616 165.701 68.5966C165.701 68.9564 165.656 69.3611 165.611 69.7209Z"
                    fill="#505356"
                />
                <path
                    d="M174.867 72.555C175.002 71.3857 175.092 70.2613 175.228 69.092C175.228 69.002 175.318 68.957 175.363 69.002C176.673 69.2719 178.027 69.4518 179.336 69.7666C179.562 69.8116 179.562 69.9915 179.562 70.0814C179.427 71.3407 179.291 72.645 179.201 73.9042C179.201 73.9942 179.111 74.0392 179.065 73.9942C177.892 73.7693 176.718 73.5444 175.544 73.3196C175.137 73.2746 174.821 72.9148 174.867 72.555ZM176.311 70.9359C176.266 71.3407 176.221 71.7005 176.176 72.1053C176.176 72.1952 176.176 72.2402 176.311 72.2852C176.853 72.3751 177.395 72.4651 177.892 72.6C178.027 72.6 178.027 72.6 178.027 72.4651C178.027 71.9703 178.072 71.4756 178.162 70.9809C178.208 70.7111 178.117 70.756 177.621 70.7111C177.259 70.6661 176.898 70.5761 176.537 70.4862C176.311 70.3962 176.266 70.4862 176.266 70.6211C176.356 70.7111 176.356 70.846 176.311 70.9359Z"
                    fill="#505356"
                />
                <path
                    d="M176.265 59.1541C176.04 60.3235 176.04 61.4478 175.904 62.6172C175.904 62.7971 175.814 62.842 175.633 62.7971C175.362 62.7521 175.137 62.7071 174.866 62.6621C174.595 62.6172 174.64 62.6621 174.64 62.3473C174.73 61.4928 174.821 60.5933 174.911 59.7388C174.911 59.5589 174.911 59.5589 174.73 59.5139C173.556 59.1991 172.518 59.1092 171.434 58.8843C171.299 58.8393 171.254 58.7943 171.254 58.6594C171.299 58.2996 171.299 57.9398 171.389 57.625C171.389 57.625 174.505 58.0747 175.814 58.4345C176.22 58.5695 176.31 58.8843 176.265 59.1541Z"
                    fill="#505356"
                />
                <path
                    d="M180.239 63.2455C180.239 63.4704 180.013 63.6503 179.787 63.6053C178.974 63.5153 178.207 63.3804 177.349 63.1555C177.033 63.0656 177.123 62.6608 177.168 62.5709C177.304 61.4015 177.168 60.547 177.485 59.4227C177.575 59.0179 177.62 58.793 178.026 58.883C178.839 59.0629 179.697 59.1978 180.509 59.3327C180.555 59.3327 180.6 59.4227 180.6 59.4676C180.555 59.7375 180.555 59.9624 180.509 60.2322C180.509 60.4571 180.284 60.592 180.058 60.547C179.652 60.4571 179.245 60.4121 178.794 60.3222C178.658 60.2772 178.613 60.3221 178.613 60.4571C178.568 60.9518 178.523 61.4465 178.478 61.9412C178.478 62.1211 178.523 62.1211 178.658 62.1661C179.065 62.256 179.516 62.301 179.923 62.391C180.103 62.4359 180.284 62.6158 180.239 62.7957V63.2455Z"
                    fill="#505356"
                />
                <path
                    d="M165.159 62.3015C165.159 62.2115 165.25 62.1216 165.385 62.1216C167.055 62.3015 168.004 62.6163 169.313 62.8412C169.539 62.8861 169.539 62.9761 169.493 63.201C169.448 63.4258 169.403 63.6507 169.403 63.8756C169.403 64.1005 169.358 64.1005 169.223 64.1005C168.32 63.9206 167.417 63.7407 166.469 63.6057C166.288 63.5608 166.288 63.6057 166.243 63.7856C166.153 64.5052 166.062 65.1798 166.017 65.8545C166.017 65.9894 165.972 66.0344 165.836 65.9894C165.475 65.8994 165.114 65.8545 164.753 65.8095L165.159 62.3015Z"
                    fill="#505356"
                />
                <path
                    d="M179.741 68.1026C179.696 68.3725 179.47 68.5074 179.245 68.4624C178.838 68.3725 178.432 68.3275 178.071 68.2375C177.89 68.1926 177.845 68.1476 177.89 67.9227C177.935 67.6979 177.981 67.428 177.981 67.2031C177.981 67.0232 178.026 66.9333 178.161 66.9783C178.568 67.0682 178.974 67.1582 179.38 67.2031C179.606 67.2481 179.787 67.473 179.787 67.7428L179.741 68.1026Z"
                    fill="#505356"
                />
                <path
                    d="M173.873 70.081C173.873 70.171 173.828 70.3059 173.828 70.3958C173.828 70.5308 173.782 70.5757 173.647 70.5757C173.331 70.4858 173.015 70.4408 172.744 70.3958C172.609 70.3958 172.563 70.3509 172.563 70.2159C172.609 69.6763 172.699 69.1815 172.744 68.6418C172.744 68.5069 172.834 68.5069 173.06 68.5969C173.331 68.6868 173.557 68.7318 173.828 68.7318C174.008 68.7318 174.053 68.7768 174.008 68.9117C173.963 69.2715 173.918 69.6763 173.873 70.081Z"
                    fill="#505356"
                />
            </g>
        </g>
        <defs>
            <clipPath id="0ea4dd4e__clip0_15032_1">
                <rect width={263} height={182} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default BarierDarkM;
