import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidTrainsS = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 153 79"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M88.0899 0.943816C72.858 1.06992 54.8452 2.96147 35.8211 13.9325C9.14942 29.3171 -2.66953 36.8833 0.68023 49.2414C4.85162 64.626 37.5908 76.6059 68.8762 76.5428C82.3385 76.4798 96.3695 74.6513 108.504 69.6702C169.306 44.8278 138.652 0.565505 88.0899 0.943816Z"
            fill="#EDF2F7"
        />
        <path
            d="M115.963 39.0267C116.153 40.2247 116.848 41.2966 117.859 41.9901C118.934 42.6837 120.134 42.9359 121.335 42.6837L137.136 39.5942C138.969 39.2159 140.675 38.5223 142.256 37.5135C143.646 36.5677 145.289 35.9372 146.933 35.6219L150.914 34.8653C151.61 34.7392 152.115 34.2978 152.494 33.7934C152.874 33.2259 153.063 32.5954 152.874 31.9019C152.684 31.2083 152.305 30.7039 151.799 30.3256C151.23 29.9473 150.598 29.7581 149.903 29.9473L145.921 30.7039C144.278 31.0191 142.508 31.0191 140.865 30.7039C139.032 30.3256 137.136 30.3256 135.303 30.6408L119.566 33.6673C117.101 34.1087 115.457 36.5677 115.963 39.0267ZM150.219 31.0191C150.914 30.893 151.61 31.3974 151.736 32.028C151.799 32.3432 151.673 32.7215 151.483 33.0368C151.294 33.352 151.041 33.5412 150.662 33.6043L147.312 34.2348L146.806 31.6497L150.219 31.0191ZM119.818 34.8653L135.682 31.7758C137.326 31.4605 139.095 31.4605 140.739 31.7758C142.382 32.091 144.088 32.1541 145.795 31.9019L146.301 34.55C144.657 34.9283 143.077 35.5589 141.687 36.5677C140.296 37.5135 138.716 38.207 137.01 38.4592L121.146 41.4857C120.261 41.6749 119.313 41.4857 118.618 40.9813C117.859 40.4769 117.354 39.6572 117.227 38.7745C116.722 36.946 117.922 35.1805 119.818 34.8653Z"
            fill="#00E6C5"
        />
        <path
            d="M128.224 38.0812C128.287 38.3965 128.604 38.5856 128.92 38.5226L137.705 36.8202C138.021 36.7571 138.21 36.4419 138.147 36.1266L137.642 33.4154C137.578 33.2262 137.515 33.1632 137.389 33.0371C137.262 32.911 137.136 32.911 136.946 32.974L128.161 34.6764C127.845 34.7395 127.655 35.0547 127.719 35.37L128.224 38.0812ZM136.63 34.2351L136.946 35.8114L129.299 37.3246L128.983 35.7483L136.63 34.2351Z"
            fill="#00E6C5"
        />
        <path
            d="M121.209 38.6484L125.76 37.7657C126.076 37.7026 126.266 37.3874 126.202 37.0721C126.139 36.883 126.076 36.7569 125.95 36.6938C125.823 36.5677 125.697 36.5677 125.507 36.6308L120.956 37.5135C120.64 37.5765 120.451 37.8918 120.514 38.2071C120.577 38.5223 120.893 38.7115 121.209 38.6484Z"
            fill="#00E6C5"
        />
        <path
            d="M36.5815 6.36609C36.6447 6.36609 33.4214 6.17693 33.4214 6.17693C33.4214 6.17693 36.2655 -0.128241 42.9018 2.39383C37.5928 2.20467 36.5815 6.36609 36.5815 6.36609Z"
            fill="url(#6d2cd0ee__paint0_linear_9962_573)"
        />
        <path
            d="M13.1958 40.6663C17.7464 49.1783 23.1819 54.4116 33.4208 55.4835C37.2762 55.9248 45.0501 55.1682 46.883 54.4116C53.9617 51.3851 56.8691 17.3372 53.0137 10.7798C49.1583 4.22242 32.2831 3.08749 26.342 5.73566C20.401 8.38383 7.94998 30.8933 13.1958 40.6663Z"
            fill="#FFD34D"
        />
        <path
            d="M47.073 9.26627L43.976 8.38355C44.2921 5.60927 43.5336 2.9611 40.2471 1.82617C47.1362 2.64584 47.389 7.43777 47.073 9.26627Z"
            fill="#66B3FF"
        />
        <path
            d="M28.554 12.4822C28.1748 12.7344 27.29 15.1934 27.606 15.6348C27.922 16.0131 32.8518 17.0219 33.1679 16.8328C33.4839 16.6436 34.5583 13.7433 34.2423 13.428C33.9263 13.1127 28.9333 12.23 28.554 12.4822Z"
            fill="#0066DA"
        />
        <path
            d="M33.1683 54.2855C38.6037 52.0156 42.3959 28.4973 40.9422 24.3989C39.4885 20.2375 19.39 17.0219 15.5346 19.8592C10.668 23.3901 6.3702 39.5944 6.74942 44.8277C7.19184 49.9979 27.7328 56.4923 33.1683 54.2855Z"
            fill="#FFD34D"
            stroke="#FAAC1A"
            strokeWidth={1.30973}
            strokeMiterlimit={10}
        />
        <path
            d="M50.9915 32.0913C51.4972 28.6865 51.75 25.1556 51.8132 21.6877C51.8132 19.8592 51.8132 17.9677 51.6236 16.1392C51.4972 14.8151 51.2444 13.428 50.6123 12.23C49.9803 11.032 48.7162 10.0862 47.6418 9.39266C46.2513 8.50993 44.7344 7.87942 43.2176 7.31195C39.931 6.24007 36.4549 5.67261 32.9787 5.48345C31.3986 5.4204 29.8186 5.35735 28.2385 5.48345C27.2904 5.5465 26.216 5.60955 25.3311 6.05092C24.6991 6.36617 25.2679 7.2489 25.9 6.99669C26.4056 6.74449 27.3536 6.68143 28.0489 6.61838C29.3129 6.49228 30.577 6.49228 31.841 6.55533C35.0644 6.68143 38.351 7.1228 41.4479 7.94247C44.292 8.76214 47.4522 9.96012 49.3483 12.293C50.1067 13.1758 50.2963 14.3737 50.4859 15.5087C50.7387 17.2111 50.8019 18.9135 50.8019 20.6159C50.8019 24.3359 50.5491 28.119 49.9803 31.8391C49.8539 32.4696 50.8651 32.7848 50.9915 32.0913Z"
            fill="#FAAC1A"
        />
        <path
            d="M36.9841 30.4211C32.3311 29.8165 27.6874 29.0229 23.1191 27.9806C21.1775 27.5707 19.239 27.0978 17.3036 26.562C15.9933 26.1828 14.683 25.8035 13.4451 25.2384C12.8262 24.9559 12.2149 25.81 12.8308 26.1555C14.0656 26.7836 15.439 27.1659 16.7493 27.5451C18.7478 28.084 20.7495 28.5599 22.7511 29.0358C27.4456 30.0844 32.1525 30.881 36.8656 31.5516C37.6231 31.5884 37.6755 30.5178 36.9841 30.4211Z"
            fill="#FAAC1A"
        />
        <path
            d="M36.5815 30.704C37.6559 31.2715 37.4663 35.8743 37.0239 36.5678C36.5183 37.2614 33.6109 36.9461 33.6109 35.8112C33.5477 34.7393 35.4438 30.1366 36.5815 30.704Z"
            fill="#FAAC1A"
        />
        <path
            d="M78.7366 78.3086C78.7366 78.3086 99.4039 69.8597 126.265 56.9341C127.087 56.5558 127.592 55.7361 127.656 55.2317C127.782 54.6642 127.972 53.214 127.972 53.214L104.207 43.8193L55.6675 60.2758C55.6675 60.2758 55.9203 61.663 56.0467 62.1674C56.1731 62.6718 56.4891 63.3023 56.8683 63.6806L72.5427 77.4259C74.2492 78.8761 76.6509 79.2544 78.7366 78.3086Z"
            fill="#4E9CE9"
        />
        <path
            d="M78.7363 75.7866L127.213 54.286C128.224 53.8446 128.224 52.3944 127.213 51.953L104.207 41.3604L55.7305 60.2759L72.6057 74.9039C74.2489 76.3541 76.6507 76.7324 78.7363 75.7866Z"
            fill="#66B3FF"
        />
        <path
            d="M104.208 41.3597L94.6643 7.18562C94.1587 5.48323 92.389 4.4744 90.6825 4.97881L45.2396 18.4719C43.4699 18.9763 42.5218 20.8678 43.0907 22.5702L55.7313 60.2752L104.208 41.3597Z"
            fill="#0066DA"
        />
        <path
            d="M100.858 37.892L92.7044 9.14046C92.5148 8.44689 91.7564 8.00553 91.0612 8.25773L47.4511 21.1833C46.6927 21.3725 46.3135 22.1922 46.5663 22.8857L57.6268 54.0333C57.8796 54.7269 58.638 55.1052 59.3333 54.853L100.099 39.5314C100.731 39.2792 101.047 38.5856 100.858 37.892Z"
            fill="white"
        />
        <path
            d="M71.911 68.157L115.584 49.8089L103.513 44.1343L62.3042 60.2125L71.911 68.157Z"
            fill="#0066DA"
        />
        <path
            d="M58.2601 26.2903L55.1632 27.2361C54.784 27.3622 54.3416 27.173 54.152 26.7317L53.0775 23.6421C52.9511 23.2638 53.1407 22.8225 53.5831 22.6964L56.6801 21.7506C57.0593 21.6245 57.5017 21.8767 57.6281 22.255L58.7026 25.2815C58.8922 25.7859 58.6394 26.1642 58.2601 26.2903Z"
            fill="#DAE6F2"
        />
        <path
            d="M62.6214 20.6784C62.6846 20.6784 62.7478 20.7414 62.7478 20.7414L63.759 23.7679V23.831C63.759 23.831 63.6958 23.831 63.6958 23.894L60.6621 24.8398C60.6621 24.8398 60.6621 24.8398 60.5989 24.8398C60.5357 24.8398 60.4725 24.8398 60.4725 24.7767L59.5244 21.7502C59.5244 21.6872 59.5244 21.6872 59.5244 21.6872C59.5244 21.6872 59.5244 21.6872 59.5876 21.6241L62.6214 20.6784ZM62.6214 20.0479C62.5582 20.0479 62.495 20.0479 62.4318 20.0479L59.398 20.9936C59.0188 21.1197 58.766 21.498 58.9556 21.9394L60.03 24.9659C60.1565 25.2811 60.4725 25.4703 60.7885 25.4703C60.8517 25.4703 60.9149 25.4703 61.0413 25.4072L64.075 24.4615C64.4543 24.3354 64.6439 23.9571 64.5175 23.5157L63.5062 20.4892C63.2534 20.3001 62.9374 20.0479 62.6214 20.0479Z"
            fill="#027BF3"
        />
        <path
            d="M69.4473 22.8224L66.4768 23.7682C66.0976 23.8943 65.6552 23.6421 65.5288 23.2638L64.5175 20.2373C64.3911 19.859 64.5807 19.4176 64.9599 19.2915L67.9305 18.4088C68.3097 18.2827 68.7521 18.5349 68.8785 18.9132L69.8898 21.8766C70.0794 22.318 69.8266 22.6963 69.4473 22.8224Z"
            fill="#DAE6F2"
        />
        <path
            d="M58.9547 28.1823C59.0179 28.1823 59.0811 28.1823 59.0811 28.2453L60.1555 31.2718V31.3349C60.1555 31.3349 60.1555 31.3979 60.0923 31.3979L56.9954 32.4067C56.9954 32.4067 56.9954 32.4067 56.9322 32.4067C56.869 32.4067 56.8058 32.4067 56.8058 32.3437L55.7313 29.3172V29.2542C55.7313 29.2542 55.7313 29.1911 55.7945 29.1911L58.9547 28.1823ZM58.9547 27.5518C58.8915 27.5518 58.8283 27.5518 58.7019 27.6148L55.6049 28.5606C55.2257 28.6867 54.9729 29.1281 55.0993 29.5064L56.1737 32.5328C56.3001 32.8481 56.553 33.0373 56.9322 33.0373C56.9954 33.0373 57.1218 33.0373 57.185 32.9742L60.2187 31.9654C60.5979 31.8393 60.7875 31.3979 60.6611 31.0196L59.5867 27.9931C59.5867 27.7409 59.2707 27.5518 58.9547 27.5518Z"
            fill="#027BF3"
        />
        <path
            d="M65.8443 30.1995L62.8738 31.1453C62.4946 31.2714 62.0521 31.0823 61.9257 30.7039L60.9145 27.6775C60.7881 27.2991 60.9777 26.8578 61.3569 26.7317L64.3907 25.7859C64.7699 25.6598 65.2123 25.849 65.3387 26.2903L66.3499 29.2538C66.4764 29.6321 66.2235 30.0734 65.8443 30.1995Z"
            fill="#DAE6F2"
        />
        <path
            d="M71.3436 28.4341L68.4363 29.3799C68.0571 29.506 67.6778 29.3168 67.4882 28.9385L66.477 25.9751C66.3506 25.5968 66.5402 25.1554 66.9194 25.0923L69.89 24.1466C70.2692 24.0205 70.6484 24.2727 70.7748 24.651L71.7228 27.6144C71.9125 27.8666 71.7228 28.308 71.3436 28.4341Z"
            fill="#DAE6F2"
        />
        <path
            d="M62.1782 37.5135L59.1445 38.5223C58.7653 38.6484 58.3229 38.4593 58.1965 38.081L57.122 35.1175C56.9956 34.7392 57.1852 34.2979 57.5644 34.1718L60.5982 33.1629C60.9774 33.0368 61.4198 33.226 61.5462 33.6043L62.5575 36.5677C62.8103 37.0091 62.5575 37.3874 62.1782 37.5135Z"
            fill="#DAE6F2"
        />
        <path
            d="M67.7408 35.6848L64.7703 36.6936C64.391 36.8198 63.9486 36.6306 63.8222 36.2523L62.811 33.2889C62.6846 32.9105 62.8742 32.4692 63.2534 32.3431L66.2239 31.3973C66.6031 31.2712 67.0456 31.4604 67.172 31.8387L68.1832 34.8021C68.3096 35.1174 68.12 35.5587 67.7408 35.6848Z"
            fill="#DAE6F2"
        />
        <path
            d="M73.1124 33.8566L70.2051 34.8024C69.8259 34.9285 69.4467 34.7394 69.3203 34.361L68.309 31.4607C68.1826 31.0824 68.3722 30.704 68.7514 30.5779L71.6588 29.6322C72.038 29.5061 72.4172 29.6952 72.5436 30.0735L73.4917 32.9739C73.6813 33.2892 73.4917 33.7305 73.1124 33.8566Z"
            fill="#DAE6F2"
        />
        <path
            d="M64.1383 43.0618L61.1677 44.1336C60.7885 44.2598 60.3461 44.0706 60.2197 43.6923L59.2084 40.7289C59.082 40.3506 59.2716 39.9092 59.6509 39.7831L62.6846 38.7743C63.0638 38.6482 63.5062 38.8373 63.6326 39.2156L64.6439 42.116C64.7071 42.4943 64.5175 42.9357 64.1383 43.0618Z"
            fill="#DAE6F2"
        />
        <path
            d="M69.5736 41.1707L66.6663 42.1795C66.287 42.3056 65.8446 42.1164 65.7182 41.7381L64.707 38.8377C64.5806 38.4594 64.7702 38.0811 65.1494 37.892L68.1199 36.8831C68.4992 36.757 68.8784 36.9462 69.0048 37.3245L70.016 40.2249C70.1424 40.6032 69.9528 41.0446 69.5736 41.1707Z"
            fill="#DAE6F2"
        />
        <path
            d="M74.9455 39.279L72.1014 40.2878C71.7222 40.4139 71.3429 40.2248 71.2165 39.8465L70.2685 36.9461C70.1421 36.5678 70.3317 36.1895 70.7109 36.0634L73.6183 35.0545C73.9975 34.9284 74.3767 35.1176 74.5031 35.4959L75.4511 38.3332C75.5144 38.7115 75.3247 39.1529 74.9455 39.279Z"
            fill="#027BF3"
        />
        <path
            d="M65.9708 48.3587L63.0002 49.4305C62.621 49.5566 62.1786 49.3675 62.0522 48.9892L61.041 46.0888C60.9145 45.7105 61.1042 45.2691 61.4834 45.143L64.4539 44.0711C64.8331 43.945 65.2756 44.1342 65.402 44.5125L66.4132 47.4129C66.5396 47.8542 66.35 48.2325 65.9708 48.3587Z"
            fill="#DAE6F2"
        />
        <path
            d="M71.4064 46.4039L68.499 47.4758C68.1198 47.6019 67.7406 47.4127 67.6142 47.0344L66.603 44.1971C66.4766 43.8187 66.6662 43.4404 67.0454 43.3143L69.9527 42.3055C70.3319 42.1794 70.7112 42.3686 70.8376 42.7469L71.7856 45.5842C71.9752 45.8364 71.7856 46.2778 71.4064 46.4039Z"
            fill="#DAE6F2"
        />
        <path
            d="M76.6521 44.4493L73.8079 45.4582C73.4287 45.5843 73.0495 45.3951 72.9231 45.0168L71.975 42.1795C71.8486 41.8012 72.0382 41.4229 72.4175 41.2968L75.2616 40.2879C75.6408 40.1618 76.02 40.351 76.1464 40.7293L77.0945 43.5666C77.2209 43.9449 77.0313 44.3232 76.6521 44.4493Z"
            fill="#DAE6F2"
        />
        <path
            d="M78.6745 19.9849L75.8304 20.8677C75.4512 20.9938 75.0719 20.7416 74.9455 20.3632L73.9975 17.3998C73.8711 17.0215 74.0607 16.6432 74.4399 16.5171L77.284 15.6344C77.6633 15.5083 78.0425 15.7605 78.1689 16.1388L79.1169 19.1022C79.1801 19.4175 78.9905 19.8588 78.6745 19.9849Z"
            fill="#DAE6F2"
        />
        <path
            d="M83.8574 18.3457L81.0765 19.2284C80.6973 19.3545 80.318 19.1023 80.1916 18.724L79.2436 15.7606C79.1172 15.3823 79.3068 15.004 79.686 14.8779L82.467 14.0582C82.8462 13.9321 83.2254 14.1843 83.3518 14.5626L84.2366 17.463C84.363 17.8413 84.1734 18.2196 83.8574 18.3457Z"
            fill="#DAE6F2"
        />
        <path
            d="M88.9134 16.7695L86.1957 17.5892C85.8165 17.7153 85.4372 17.4631 85.374 17.0848L84.4892 14.1844C84.3628 13.8061 84.5524 13.4278 84.9316 13.3017L87.6493 12.482C88.0286 12.3559 88.3446 12.6081 88.471 12.9864L89.3558 15.8868C89.419 16.2651 89.2294 16.6434 88.9134 16.7695Z"
            fill="#DAE6F2"
        />
        <path
            d="M80.3813 25.4706L77.6004 26.3534C77.2212 26.4795 76.842 26.2903 76.7156 25.912L75.7675 23.0116C75.6411 22.6333 75.8307 22.255 76.2099 22.1289L79.0541 21.2462C79.4333 21.1201 79.8125 21.3723 79.9389 21.7506L80.8869 24.651C80.9502 24.9662 80.7605 25.3445 80.3813 25.4706Z"
            fill="#DAE6F2"
        />
        <path
            d="M85.564 23.7684L82.8463 24.6511C82.4671 24.7772 82.0878 24.588 81.9614 24.2097L81.0766 21.3094C80.9502 20.931 81.1398 20.5527 81.519 20.4266L84.2999 19.5439C84.6792 19.4178 85.0584 19.67 85.1216 19.9853L86.0064 22.8856C86.0696 23.264 85.88 23.7053 85.564 23.7684Z"
            fill="#DAE6F2"
        />
        <path
            d="M90.5563 22.1921L87.9017 23.0748C87.5857 23.2009 87.2065 23.0117 87.0801 22.6334L86.1952 19.7961C86.0688 19.4178 86.2585 19.0395 86.6377 18.9134L89.3554 18.0937C89.6714 17.9676 90.0506 18.2198 90.177 18.5351L91.0619 21.3724C91.0619 21.6877 90.8723 22.066 90.5563 22.1921Z"
            fill="#DAE6F2"
        />
        <path
            d="M82.0879 30.8298L79.3069 31.7756C78.9277 31.9017 78.5485 31.7125 78.4221 31.3342L77.4741 28.4338C77.3477 28.0555 77.5373 27.6772 77.9165 27.5511L80.6974 26.6053C81.0766 26.4792 81.4558 26.6684 81.5822 27.0467L82.4671 29.884C82.6567 30.2623 82.4671 30.7037 82.0879 30.8298Z"
            fill="white"
        />
        <path
            d="M87.2069 29.0645L84.4891 30.0103C84.1099 30.1364 83.7307 29.9472 83.6675 29.5689L82.7827 26.7316C82.6562 26.3533 82.8459 25.975 83.2251 25.8489L85.9428 24.9662C86.322 24.84 86.638 25.0292 86.7644 25.4075L87.6493 28.2448C87.7125 28.5601 87.5229 28.9384 87.2069 29.0645Z"
            fill="#DAE6F2"
        />
        <path
            d="M92.1368 27.4249L89.4823 28.3076C89.1663 28.4338 88.7871 28.2446 88.6607 27.8663L87.7758 25.029C87.6494 24.6507 87.839 24.2723 88.2182 24.1462L90.8728 23.2635C91.1888 23.1374 91.568 23.3266 91.6944 23.7049L92.516 26.5422C92.6424 26.9205 92.4528 27.2988 92.1368 27.4249Z"
            fill="#DAE6F2"
        />
        <path
            d="M83.7942 36.1266L81.0765 37.0724C80.6973 37.1985 80.318 37.0093 80.1916 36.631L79.2436 33.7937C79.1172 33.4154 79.3068 33.0371 79.686 32.911L82.4669 31.9652C82.8462 31.8391 83.2254 32.0282 83.2886 32.4065L84.1734 35.2439C84.363 35.6222 84.1734 36.0005 83.7942 36.1266Z"
            fill="#DAE6F2"
        />
        <path
            d="M88.8502 34.361L86.1957 35.3067C85.8797 35.4328 85.5004 35.2437 85.374 34.8654L84.4892 32.0281C84.3628 31.6497 84.5524 31.2714 84.9316 31.1453L87.6493 30.1996C87.9654 30.0734 88.3446 30.2626 88.471 30.6409L89.3558 33.4152C89.3558 33.8566 89.1662 34.2349 88.8502 34.361Z"
            fill="#DAE6F2"
        />
        <path
            d="M93.7172 32.6587L91.1258 33.6045C90.8098 33.7306 90.4306 33.5414 90.3042 33.1631L89.4194 30.3888C89.293 30.0105 89.4826 29.6322 89.8618 29.5061L92.5163 28.6234C92.8323 28.4973 93.2115 28.6864 93.3379 29.0647L94.1596 31.839C94.2228 32.1543 94.0964 32.5326 93.7172 32.6587Z"
            fill="#DAE6F2"
        />
        <path
            d="M85.4368 41.2969L82.7191 42.3057C82.3399 42.4318 81.9607 42.2426 81.8975 41.8643L81.0126 39.0901C80.8862 38.7118 81.0758 38.3334 81.4551 38.2073L84.1728 37.2616C84.552 37.1355 84.868 37.3246 84.9944 37.7029L85.8793 40.4772C86.0057 40.7925 85.8161 41.1708 85.4368 41.2969Z"
            fill="#DAE6F2"
        />
        <path
            d="M90.4303 39.4683L87.7758 40.4141C87.4597 40.5402 87.0805 40.351 86.9541 39.9727L86.0693 37.1985C85.9429 36.8202 86.1325 36.4418 86.5117 36.3157L89.1662 35.37C89.4822 35.2439 89.8614 35.433 89.9879 35.8113L90.8727 38.5856C90.9359 38.9639 90.7463 39.3422 90.4303 39.4683Z"
            fill="#DAE6F2"
        />
        <path
            d="M95.2335 37.7027L92.6422 38.6485C92.3262 38.7746 91.947 38.5854 91.8206 38.2071L90.999 35.4328C90.8726 35.0545 91.0622 34.6762 91.4414 34.5501L94.0327 33.6043C94.3487 33.4782 94.7279 33.6674 94.8543 34.0457L95.676 36.7569C95.8024 37.1983 95.6128 37.5766 95.2335 37.7027Z"
            fill="#DAE6F2"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.2842 26.9057C91.2063 24.7412 98.2843 22.3151 102.817 20.4897C103.829 20.0483 104.461 19.0395 104.145 18.0306C104.145 18.0306 103.386 9.4556 99.4676 1.70024C98.962 0.691412 98.0139 -0.00215662 96.9395 0.313102C96.9395 0.313102 78.0418 4.41146 67.4237 8.50983C66.3493 8.95119 65.8436 9.96002 66.0333 11.0949C67.1077 18.9134 68.9406 23.5161 71.4055 28.6233C71.9111 29.6322 72.9224 30.2627 73.9968 29.9474C74.8858 29.7028 75.8087 29.4427 76.7569 29.1699C76.6432 30.829 76.1417 32.4484 75.7034 33.5414C75.5138 34.1089 76.0826 34.6133 76.5882 34.3611C81.0735 32.2092 83.2403 29.2062 84.2842 26.9057Z"
            fill="#70D164"
        />
        <path
            d="M73.3965 15.0181C73.7321 12.7306 75.2207 11.16 77.8622 10.3065C79.8247 9.67245 81.5019 9.70926 82.8939 10.417C84.2913 11.1229 85.2976 12.4277 85.9126 14.3313C86.5536 16.3151 86.5247 18.0076 85.8258 19.4086C85.1252 20.8042 83.8311 21.807 81.9435 22.4169C80.2431 22.9663 78.8277 23.0545 77.6973 22.6816C76.5653 22.3032 75.6447 21.6381 74.9355 20.6862L78.0544 18.6597C78.7763 19.7611 79.7336 20.1191 80.926 19.7338C82.3163 19.2846 82.8676 18.2768 82.5799 16.7103L79.0347 17.8558L78.3298 15.6741L81.8911 14.5234C81.1722 13.0845 80.123 12.5879 78.7434 13.0336C77.6686 13.3809 77.111 14.1043 77.0707 15.204L73.3965 15.0181ZM85.996 7.89991L92.0357 5.94844C93.3511 5.52342 94.4361 5.51833 95.2906 5.93317C96.1504 6.34629 96.7669 7.13035 97.1401 8.28535C97.5237 9.47243 97.4652 10.5159 96.9646 11.4159C96.4694 12.314 95.4892 12.9998 94.0241 13.4732L92.0349 14.1159L93.4447 18.4793L89.7953 19.6585L85.996 7.89991ZM91.2652 11.7338L92.1555 11.4461C92.856 11.2198 93.3091 10.9405 93.5147 10.6083C93.7187 10.2708 93.7593 9.91216 93.6366 9.53251C93.5174 9.16355 93.2934 8.89048 92.9645 8.71328C92.6356 8.53609 92.1316 8.55721 91.4525 8.77663L90.4178 9.11094L91.2652 11.7338Z"
            fill="white"
        />
        <defs>
            <linearGradient
                id="6d2cd0ee__paint0_linear_9962_573"
                x1={33.6689}
                y1={3.68571}
                x2={42.7002}
                y2={4.52824}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0908376} stopColor="#0065D9" />
                <stop offset={0.7003} stopColor="#027BF3" />
            </linearGradient>
        </defs>
    </svg>
);

export default CovidTrainsS;
