import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DesktopInnerLogoTravelSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 29 30"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="e3b3a3aa__mask0_16347_126"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={28}
            height={29}
        >
            <circle cx={13.76} cy={14.6702} r={13.76} fill="white" />
        </mask>
        <g mask="url(#e3b3a3aa__mask0_16347_126)">
            <rect
                y={0.910156}
                width={27.52}
                height={27.52}
                fill="url(#e3b3a3aa__paint0_linear_16347_126)"
            />
            <path
                d="M19.2431 5.25977C18.3114 5.25977 17.4253 5.32347 16.6839 5.57447C15.8867 5.84436 15.205 6.35196 14.8423 7.21293C14.5245 7.96714 14.413 8.3768 14.1078 9.7645C13.9584 10.4441 14.3075 11.0522 14.941 11.2257C15.5746 11.3991 16.2474 11.0064 16.4208 10.3728C16.7041 9.14081 16.7631 8.82604 16.9646 8.30857C17.0612 8.0608 17.1825 7.91703 17.4467 7.82759C17.8046 7.70642 18.368 7.6385 19.2431 7.6385C19.8353 7.6385 20.2393 7.70398 20.4983 7.78456C20.782 7.8728 20.8684 8.03765 20.811 8.33683C20.6847 8.99465 20.5977 9.39255 20.4676 10.0496C20.3401 10.694 20.759 11.3197 21.4034 11.4473C22.0477 11.5749 22.6735 11.1559 22.8011 10.5115C22.978 9.61748 23.1759 8.72504 23.2227 8.08433C23.2982 7.05191 22.7685 6.28792 21.8891 5.80117C21.1607 5.39794 20.2275 5.25977 19.2431 5.25977Z"
                fill="#BD0C42"
            />
            <path
                d="M10.5273 12.2105L10.5276 12.2105C12.5235 12.2115 14.5194 12.2112 16.5153 12.2108C17.4994 12.2107 18.4835 12.2105 19.4675 12.2105C21.9374 12.2088 23.7122 13.861 23.7049 16.3697C23.7014 17.5586 23.5818 19.4093 23.3991 21.4076C23.1941 23.6506 22.901 26.2047 22.5613 28.4299H20.0586C20.462 25.8852 20.7786 23.3268 21.0145 20.7612C21.1691 19.0797 21.277 17.9052 21.2642 16.6048C21.2503 15.1975 20.6206 14.582 19.2802 14.582H10.7054C8.74892 14.582 7.47378 14.7293 6.63601 16.6817C6.17249 17.7619 5.46528 19.9932 4.95528 22.6749C4.62133 24.4308 4.37888 26.5343 4.33745 28.4299H1.89673C1.93963 26.3217 2.21057 24.212 2.57042 22.3199C3.11569 19.4528 3.88168 17.0004 4.43629 15.7079C5.62638 12.9344 7.69686 12.2089 10.5273 12.2105Z"
                fill="#FF6D3A"
            />
            <path
                d="M16.6466 28.4299H14.1693C14.3647 24.0015 15.2364 19.4844 16.1942 16.8049C16.4242 16.1613 17.1324 15.8261 17.776 16.0562C18.4195 16.2862 18.7548 16.9944 18.5247 17.6379C17.6647 20.0442 16.8413 24.2664 16.6466 28.4299Z"
                fill="#FF6D3A"
            />
        </g>
        <defs>
            <linearGradient
                id="e3b3a3aa__paint0_linear_16347_126"
                x1={27.4097}
                y1={0.790168}
                x2={0.324078}
                y2={28.44}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEB75" />
                <stop offset={0.920669} stopColor="#FEE14A" />
            </linearGradient>
        </defs>
    </svg>
);

export default DesktopInnerLogoTravelSign;
