import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DesktopInnerLogoYaSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 28 30"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="5c45f995__mask0_16347_125"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={28}
            height={29}
        >
            <circle cx={13.76} cy={14.6702} r={13.76} fill="white" />
        </mask>
        <g mask="url(#5c45f995__mask0_16347_125)">
            <rect
                width={27.52}
                height={27.52}
                transform="translate(0 0.910156)"
                fill="#FC3F1D"
            />
            <path
                d="M15.7889 8.61607H14.3963C12.009 8.61607 10.8154 9.80971 10.8154 11.6002C10.8154 13.5896 11.6111 14.5843 13.4016 15.7779L14.7942 16.7726L10.8154 22.9397H7.63232L11.4122 17.3694C9.22384 15.7779 8.0302 14.3853 8.0302 11.7991C8.0302 8.61607 10.2185 6.42773 14.3963 6.42773H18.574V22.9397H15.7889V8.61607Z"
                fill="white"
            />
        </g>
    </svg>
);

export default DesktopInnerLogoYaSign;
