import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DriveM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#521ba997__clip0_16290_137)">
            <path
                d="M20.199 8.86936C20.199 4.04972 18.1384 1.3896 14.9089 0H0.000976562V3.9098C1.31964 3.46453 2.70272 3.2398 4.09453 3.24465C13.7434 3.24465 13.7214 13.5561 7.06637 20.2111C5.30857 21.9689 3.58898 23.1755 1.98166 24H10.6677C16.3815 20.5442 20.199 14.7997 20.199 8.86936Z"
                fill="#0000F7"
            />
            <path
                d="M4.09355 3.24471C2.70174 3.23983 1.31866 3.46456 0 3.90986V23.9998H1.98092C3.58825 23.1755 5.3076 21.9687 7.06563 20.2109C13.7204 13.5559 13.7424 3.24471 4.09355 3.24471Z"
                fill="#161616"
            />
            <path
                d="M14.908 0C18.1374 1.3896 20.198 4.04973 20.198 8.86937C20.198 14.7997 16.3805 20.5442 10.667 23.9998H23.9998V0H14.908Z"
                fill="#E3E3E3"
            />
            <path
                d="M20.199 8.86936C20.199 4.04972 18.1384 1.3896 14.9089 0H0.000976562V3.9098C1.31964 3.46453 2.70272 3.2398 4.09453 3.24465C13.7434 3.24465 13.7214 13.5561 7.06637 20.2111C5.30857 21.9689 3.58898 23.1755 1.98166 24H10.6677C16.3815 20.5442 20.199 14.7997 20.199 8.86936Z"
                fill="url(#521ba997__paint0_linear_16290_137)"
            />
            <path
                d="M4.09355 3.24471C2.70174 3.23983 1.31866 3.46456 0 3.90986V23.9998H1.98092C3.58825 23.1755 5.3076 21.9687 7.06563 20.2109C13.7204 13.5559 13.7424 3.24471 4.09355 3.24471Z"
                fill="url(#521ba997__paint1_linear_16290_137)"
            />
        </g>
        <defs>
            <linearGradient
                id="521ba997__paint0_linear_16290_137"
                x1={20.199}
                y1={12}
                x2={0.000974155}
                y2={12}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.25} />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="521ba997__paint1_linear_16290_137"
                x1={-2.44838}
                y1={14.8624}
                x2={12.2442}
                y2={10.9255}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#CADEF2" stopOpacity={0.2} />
                <stop
                    offset={0.0206}
                    stopColor="#C3D6EA"
                    stopOpacity={0.1959}
                />
                <stop offset={0.167} stopColor="#96A4B2" stopOpacity={0.1666} />
                <stop
                    offset={0.3143}
                    stopColor="#6F7982"
                    stopOpacity={0.1371}
                />
                <stop
                    offset={0.4595}
                    stopColor="#4F555B"
                    stopOpacity={0.1081}
                />
                <stop offset={0.602} stopColor="#36393D" stopOpacity={0.0796} />
                <stop
                    offset={0.7413}
                    stopColor="#242627"
                    stopOpacity={0.0517}
                />
                <stop
                    offset={0.8757}
                    stopColor="#1A1A1A"
                    stopOpacity={0.0249}
                />
                <stop offset={1} stopColor="#161616" stopOpacity={0} />
            </linearGradient>
            <clipPath id="521ba997__clip0_16290_137">
                <path
                    d="M0 12C0 5.37258 5.37258 0 12 0C18.6274 0 24 5.37258 24 12C24 18.6274 18.6274 24 12 24C5.37258 24 0 18.6274 0 12Z"
                    fill="white"
                />
            </clipPath>
        </defs>
    </svg>
);

export default DriveM;
