import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightNoCityPhotoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#ae8bd6c5__clip0_25495_5756)">
            <path
                d="M1221 -3H-8V350H1221V-3Z"
                fill="url(#ae8bd6c5__paint0_linear_25495_5756)"
            />
            <path
                opacity={0.67}
                d="M561.905 213H446C446 213 464.538 202.024 472.241 202.61C479.944 203.195 478.645 208.605 478.645 208.605C478.645 208.605 494.131 195.988 507.767 196.722C521.403 197.456 519.788 204.144 519.788 204.144C519.788 204.144 534.812 189.16 558.747 191.189C577.529 192.739 561.905 213 561.905 213Z"
                fill="white"
            />
            <path
                opacity={0.5}
                d="M1265.26 99.5992H1122.45C1122.45 99.5992 1145.29 86.2892 1154.74 86.9992C1164.19 87.7092 1162.64 94.2492 1162.64 94.2492C1162.64 94.2492 1181.71 78.9492 1198.51 79.8492C1215.31 80.7492 1213.32 88.8492 1213.32 88.8492C1213.32 88.8492 1231.83 70.6792 1261.37 73.1392C1284.5 74.9992 1265.26 99.5992 1265.26 99.5992Z"
                fill="url(#ae8bd6c5__paint1_linear_25495_5756)"
            />
            <path
                opacity={0.6}
                d="M404.73 164H119C119 164 157.049 126.522 197.179 120.938C237.309 115.354 235.919 142.469 235.919 142.469C235.919 142.469 288.329 65.1547 368.581 72.4909C448.832 79.8272 416.492 134.496 416.492 134.496C416.492 134.496 460.24 106.524 488.608 118.002C516.977 129.479 494.653 164 494.653 164H404.73Z"
                fill="url(#ae8bd6c5__paint2_linear_25495_5756)"
            />
            <path
                opacity={0.4}
                d="M771.74 109.389H570.64C570.64 109.389 597.42 86.5091 625.64 83.1091C653.86 79.7091 652.91 96.2491 652.91 96.2491C652.91 96.2491 689.78 49.0591 746.26 53.5291C802.74 57.9991 779.97 91.3791 779.97 91.3791C779.97 91.3791 810.74 74.3091 830.74 81.3091C850.74 88.3091 835 109.389 835 109.389H771.74Z"
                fill="url(#ae8bd6c5__paint3_linear_25495_5756)"
            />
            <path
                opacity={0.7}
                d="M742.81 190.696H600C600 190.696 622.84 177.376 632.34 178.086C641.84 178.796 640.23 185.336 640.23 185.336C640.23 185.336 659.3 170.036 676.11 170.936C692.92 171.836 690.91 179.936 690.91 179.936C690.91 179.936 709.42 161.736 738.94 164.236C762.05 166.126 742.81 190.696 742.81 190.696Z"
                fill="url(#ae8bd6c5__paint4_linear_25495_5756)"
            />
            <path
                opacity={0.5}
                d="M72.22 28.5206C59.42 26.3806 42.38 32.9106 33.22 37.0906C33.54 25.7706 28.83 9.39062 -1.07001 9.39062C-46.78 9.39062 -67.07 39.2806 -67.07 39.2806C-67.07 39.2806 -64.13 24.7806 -86.29 24.7806C-108.45 24.7806 -134 47.6506 -134 47.6506H80.74C80.74 47.6506 90.62 31.6106 72.22 28.5206Z"
                fill="url(#ae8bd6c5__paint5_linear_25495_5756)"
            />
            <path
                d="M1130 79H1336.26C1347.31 27.0504 1356 -4 1356 -4H1150.61C1150.61 -4 1141.62 27.0504 1130 79Z"
                fill="#F2F5F8"
            />
            <path
                d="M938.85 -15.5C930.85 2.4 906.77 60.22 891.68 134.5C881.94 182.45 875.96 233.5 872.5 270.8C870.993 287.072 863.779 302.287 852.134 313.753C840.489 325.218 825.164 332.196 808.87 333.45C784.655 335.297 760.341 335.484 736.1 334.01C697.1 331.66 667.92 297.14 671.71 258.22C675.2 222.51 681.02 177.22 690.58 134.5C707.17 60.23 732.39 2.41 740.68 -15.5H579.13C571 2.83 545.79 63 530.06 140.46C519.94 190.24 513.73 243.29 510.14 282C508.561 298.886 501.064 314.67 488.974 326.564C476.884 338.458 460.98 345.696 444.07 347C418.93 348.919 393.687 349.112 368.52 347.58C328 345.14 297.72 309.29 301.66 268.89C305.28 231.8 311.33 184.82 321.25 140.43C338.55 63 364.87 2.83 373.37 -15.5H143.61C135.2 3.36 108.61 66.67 92.0601 148.19C81.4601 200.36 75.0001 256 71.1901 296.48C69.5534 314.179 61.7105 330.728 49.0485 343.202C36.3864 355.675 19.7212 363.269 2.00008 364.64C-5.99992 365.253 -13.9733 365.707 -21.9199 366V384.5H1063V-15.5H938.85Z"
                fill="#BBC5CB"
            />
            <path
                d="M960.77 0C952.82 17.9 928.7 75.72 913.6 150C903.86 197.95 897.88 249 894.42 286.3C892.915 302.573 885.701 317.789 874.056 329.255C862.411 340.721 847.084 347.698 830.79 348.95C806.578 350.797 782.268 350.984 758.03 349.51C719.03 347.16 689.84 312.64 693.64 273.72C697.12 238 703 192.74 712.5 150C729.1 75.72 754.31 17.9 762.6 0H601.05C592.9 18.33 567.71 78.54 552 156C541.88 205.78 535.68 258.83 532.09 297.52C530.51 314.408 523.012 330.193 510.92 342.087C498.828 353.981 482.921 361.219 466.01 362.52C440.869 364.439 415.627 364.632 390.46 363.1C349.94 360.66 319.67 324.81 323.61 284.41C327.22 247.32 333.27 200.34 343.19 155.95C360.47 78.54 386.8 18.33 395.3 0H165.53C157.12 18.86 130.53 82.17 113.98 163.69C103.38 215.86 96.88 271.45 93.12 312C91.4798 329.706 83.6291 346.26 70.9572 358.735C58.2854 371.209 41.6093 378.798 23.88 380.16C15.96 380.76 8 381.193 0 381.46V400H1056V0H960.77Z"
                fill="#D0DFEA"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.3}
                    d="M960.77 0C952.82 17.9 928.7 75.72 913.6 150C903.86 197.95 897.88 249 894.42 286.3C892.915 302.573 885.701 317.789 874.056 329.255C862.411 340.721 847.084 347.698 830.79 348.95C806.578 350.797 782.268 350.984 758.03 349.51C719.03 347.16 689.84 312.64 693.64 273.72C697.12 238 703 192.74 712.5 150C729.1 75.72 754.31 17.9 762.6 0H601.05C592.9 18.33 567.71 78.54 552 156C541.88 205.78 535.68 258.83 532.09 297.52C530.51 314.408 523.012 330.193 510.92 342.087C498.828 353.981 482.921 361.219 466.01 362.52C440.869 364.439 415.627 364.632 390.46 363.1C349.94 360.66 319.67 324.81 323.61 284.41C327.22 247.32 333.27 200.34 343.19 155.95C360.47 78.54 386.8 18.33 395.3 0H165.53C157.12 18.86 130.53 82.17 113.98 163.69C103.38 215.86 96.88 271.45 93.12 312C91.4798 329.706 83.6291 346.26 70.9572 358.735C58.2854 371.209 41.6093 378.798 23.88 380.16C15.96 380.76 8 381.193 0 381.46V400H1045V0H960.77Z"
                    fill="url(#ae8bd6c5__paint6_linear_25495_5756)"
                />
            </g>
            <path
                d="M937.07 -5.7793C937.07 -5.7793 905.54 60.0007 887.27 150.001C877.52 197.951 871.54 249.001 868.09 286.301C866.582 302.575 859.367 317.791 847.72 329.257C836.073 340.722 820.745 347.699 804.45 348.951C795.43 349.617 786.396 350.077 777.35 350.331C795.175 350.766 813.011 350.306 830.79 348.951C847.084 347.698 862.41 340.722 874.056 329.256C885.701 317.79 892.914 302.574 894.42 286.301C897.88 249.041 903.86 197.951 913.6 150.001C931.88 60.0007 963.41 -5.7793 963.41 -5.7793H937.07Z"
                fill="#BBC5CB"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M656.13 -59.71C645.3 -36.92 604.43 41.88 582.23 138.76C567.96 201.06 560.23 259.88 554.53 308.42C552.034 329.621 542.121 349.256 526.543 363.853C510.966 378.449 490.728 387.066 469.41 388.18C437.744 389.821 406.003 389.283 374.41 386.57C323.52 382.24 286.56 336.21 292.77 285.52C298.47 238.99 307.54 180.09 321.39 124.52C345.52 27.73 380.5 -47.18 391.75 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M227.89 -59.71C217.07 -36.92 176.19 41.88 154 138.76C139.73 201.06 132 259.88 126.29 308.42C123.794 329.621 113.881 349.256 98.3032 363.853C82.7258 378.449 62.4882 387.066 41.1699 388.18C9.50376 389.821 -22.2377 389.283 -53.8301 386.57C-104.72 382.24 -141.68 336.21 -135.47 285.52C-129.77 238.99 -120.7 180.09 -106.84 124.52C-82.7201 27.73 -47.7401 -47.18 -36.4801 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M1005.65 -53.6009C995.31 -31.8109 963.24 39.8091 942.03 132.399C928.39 191.999 919.35 255.549 913.89 301.939C911.506 322.204 902.031 340.973 887.141 354.926C872.252 368.878 852.907 377.115 832.53 378.179C802.254 379.74 771.906 379.226 741.7 376.639C693.06 372.489 657.7 328.509 663.7 280.059C669.15 235.579 677.82 179.279 691.07 126.209C714.16 33.6591 747.59 -37.9309 758.35 -59.7109"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <path
                d="M1704 -15.5C1696 2.4 1671.92 60.22 1656.83 134.5C1647.09 182.45 1641.11 233.5 1637.65 270.8C1636.14 287.072 1628.93 302.287 1617.29 313.753C1605.64 325.218 1590.32 332.196 1574.02 333.45C1549.81 335.297 1525.49 335.484 1501.25 334.01C1462.25 331.66 1433.07 297.14 1436.86 258.22C1440.35 222.51 1446.17 177.22 1455.73 134.5C1472.32 60.23 1497.54 2.41 1505.83 -15.5H1344.28C1336.15 2.83 1310.94 63 1295.21 140.46C1285.09 190.24 1278.88 243.29 1275.29 282C1273.71 298.886 1266.22 314.67 1254.13 326.564C1242.04 338.458 1226.13 345.696 1209.22 347C1184.08 348.919 1158.84 349.112 1133.67 347.58C1093.15 345.14 1062.87 309.29 1066.81 268.89C1070.43 231.8 1076.48 184.82 1086.4 140.43C1103.7 63 1130.02 2.83 1138.52 -15.5H908.761C900.351 3.36 873.761 66.67 857.211 148.19C846.611 200.36 840.151 256 836.341 296.48C834.705 314.179 826.862 330.728 814.2 343.202C801.538 355.675 784.873 363.269 767.151 364.64C759.151 365.253 751.178 365.707 743.231 366V384.5H1943.23V-15.5H1704Z"
                fill="#BBC5CB"
            />
            <path
                d="M1725.92 0C1717.97 17.9 1693.85 75.72 1678.75 150C1669.01 197.95 1663.03 249 1659.57 286.3C1658.07 302.573 1650.85 317.789 1639.21 329.255C1627.56 340.721 1612.24 347.698 1595.94 348.95C1571.73 350.797 1547.42 350.984 1523.18 349.51C1484.18 347.16 1454.99 312.64 1458.79 273.72C1462.27 238 1468.15 192.74 1477.65 150C1494.25 75.72 1519.46 17.9 1527.75 0H1366.2C1358.05 18.33 1332.86 78.54 1317.15 156C1307.03 205.78 1300.83 258.83 1297.24 297.52C1295.66 314.408 1288.16 330.193 1276.07 342.087C1263.98 353.981 1248.07 361.219 1231.16 362.52C1206.02 364.439 1180.78 364.632 1155.61 363.1C1115.09 360.66 1084.82 324.81 1088.76 284.41C1092.37 247.32 1098.42 200.34 1108.34 155.95C1125.62 78.54 1151.95 18.33 1160.45 0H930.681C922.271 18.86 895.681 82.17 879.131 163.69C868.531 215.86 862.031 271.45 858.271 312C856.631 329.706 848.78 346.26 836.109 358.735C823.437 371.209 806.761 378.798 789.031 380.16C781.111 380.76 773.151 381.193 765.151 381.46V400H1965.15V0H1725.92Z"
                fill="#D0DFEA"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.3}
                    d="M1725.92 0C1717.97 17.9 1693.85 75.72 1678.75 150C1669.01 197.95 1663.03 249 1659.57 286.3C1658.07 302.573 1650.85 317.789 1639.21 329.255C1627.56 340.721 1612.24 347.698 1595.94 348.95C1571.73 350.797 1547.42 350.984 1523.18 349.51C1484.18 347.16 1454.99 312.64 1458.79 273.72C1462.27 238 1468.15 192.74 1477.65 150C1494.25 75.72 1519.46 17.9 1527.75 0H1366.2C1358.05 18.33 1332.86 78.54 1317.15 156C1307.03 205.78 1300.83 258.83 1297.24 297.52C1295.66 314.408 1288.16 330.193 1276.07 342.087C1263.98 353.981 1248.07 361.219 1231.16 362.52C1206.02 364.439 1180.78 364.632 1155.61 363.1C1115.09 360.66 1084.82 324.81 1088.76 284.41C1092.37 247.32 1098.42 200.34 1108.34 155.95C1125.62 78.54 1151.95 18.33 1160.45 0H930.681C922.271 18.86 895.681 82.17 879.131 163.69C868.531 215.86 862.031 271.45 858.271 312C856.631 329.706 848.78 346.26 836.109 358.735C823.437 371.209 806.761 378.798 789.031 380.16C781.111 380.76 773.151 381.193 765.151 381.46V400H1965.15V0H1725.92Z"
                    fill="url(#ae8bd6c5__paint7_linear_25495_5756)"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M1421.28 -59.71C1410.45 -36.92 1369.58 41.88 1347.38 138.76C1333.11 201.06 1325.38 259.88 1319.68 308.42C1317.19 329.621 1307.27 349.256 1291.69 363.853C1276.12 378.449 1255.88 387.066 1234.56 388.18C1202.9 389.821 1171.15 389.283 1139.56 386.57C1088.67 382.24 1051.71 336.21 1057.92 285.52C1063.62 238.99 1072.69 180.09 1086.54 124.52C1110.67 27.73 1145.65 -47.18 1156.9 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <path
                opacity={0.3}
                d="M556.59 42.8691L553.53 51.4391L583.93 42.8691H556.59Z"
                fill="#7D9CAE"
            />
            <path
                opacity={0.3}
                d="M90.5 156L89 165L115.5 157L90.5 156Z"
                fill="#7D9CAE"
            />
            <path
                d="M377.359 42.8707H583.929C594.999 12.4207 603.699 -5.7793 603.699 -5.7793H397.999C397.999 -5.7793 388.999 12.4207 377.359 42.8707Z"
                fill="#F2F5F8"
            />
            <path
                d="M445.87 27.2207H528.04"
                stroke="#BBC5CB"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M-101 156.74H115.43C125.94 109.52 150.57 31.7402 168.17 -5.77979H-47.32C-47.32 -5.77979 -88.86 124.83 -101 156.74Z"
                fill="#F2F5F8"
            />
            <path
                d="M-16.54 138.91H69.57"
                stroke="#BBC5CB"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M745.42 41.0702H944.42C955.06 11.7502 963.42 -5.77979 963.42 -5.77979H765.35C765.35 -5.77979 756.63 11.7502 745.42 41.0702Z"
                fill="#F2F5F8"
            />
            <path
                d="M811.41 26H890.55"
                stroke="#FFD2C6"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M286.18 609C287.327 505.735 282.88 402.484 272.86 299.7C270.799 279.014 262.466 259.452 248.978 243.633C235.49 227.815 217.49 216.495 197.39 211.19C128.62 193 40.6001 179.84 -29.8799 176.55C-44.3699 175.88 -72.2199 177.55 -88.7699 182.9C-91.6499 183.84 -115.46 189.73 -116.98 190.97C-132.29 203.43 -114.34 222.41 -119.24 245.15C-135.3 319.64 -159.54 447.42 -171.17 585.75"
                fill="#5F8296"
            />
            <path
                d="M226.3 620.42C227.455 517.152 223.015 413.897 213 311.11C210.937 290.42 202.6 270.854 189.106 255.035C175.612 239.216 157.606 227.899 137.5 222.6C68.73 204.42 -19.28 191.25 -89.76 188C-110.363 187.006 -130.651 193.354 -147.013 205.914C-163.376 218.473 -174.753 236.43 -179.12 256.59C-195.18 331.05 -219.43 458.83 -231 597.16"
                fill="url(#ae8bd6c5__paint8_linear_25495_5756)"
            />
            <path
                d="M1181.5 527.771C1180.44 433.376 1174.26 339.108 1163 245.381C1160.7 226.518 1152.69 208.809 1140.04 194.627C1127.39 180.445 1110.71 170.468 1092.23 166.031C1029.01 150.811 948.31 140.571 883.83 139.031C868.27 138.661 835.97 141.551 823.38 149.031C804.45 160.331 807.98 180.541 803.56 203.511C790.41 271.901 770.85 389.171 763.05 515.831"
                fill="#5F8296"
            />
            <path
                d="M1134 534.261C1132.94 439.863 1126.77 345.592 1115.52 251.861C1113.22 232.999 1105.2 215.29 1092.56 201.109C1079.91 186.927 1063.23 176.949 1044.75 172.511C981.53 157.301 900.83 147.061 836.35 145.511C817.485 145.005 799.053 151.213 784.338 163.029C769.622 174.845 759.58 191.502 756 210.031C742.85 278.431 723.29 395.701 715.49 522.351"
                fill="#4F6C7F"
            />
            <path
                d="M905.735 -32.4427C873.424 -32.4427 849.487 -18.631 831.716 -1.59109C826.633 3.28324 820.893 7.27512 817.033 12.6928C805.403 29.017 799.362 46.9486 799.115 61.3103L810.748 83.1342C810.748 83.1342 812.105 108.555 779.99 125.607C747.876 142.66 732.361 163.727 743.525 186.645C743.525 186.645 714.123 212.954 725.559 242.574C736.994 272.193 776.182 276.995 776.182 276.995L1033.25 312.183C1033.25 312.183 1069.16 347.452 1099.42 321.551C1129.67 295.651 1126 234.5 1106.23 210.573C1093.24 194.844 1073.36 185.848 1073.36 185.848C1073.36 185.848 1082.4 162.859 1062.59 143.63C1042.79 124.401 1021.75 139.753 1015.49 114.373C1009.23 88.9936 1037.03 34.0869 990.692 -10.0923C950.375 -42.8001 905.735 -32.4427 905.735 -32.4427Z"
                fill="#333333"
            />
            <path
                d="M932.923 203.132C1008.3 218.653 1068.27 260.049 1085.86 306.097C1103.46 352.144 1112.11 410.062 1112.11 410.062C1112.11 410.062 1031.55 460.255 822.554 460.255C701.609 460.255 659.447 411.104 661.043 410.062C660.97 405.258 699.484 339.172 726.886 286.44C754.288 233.708 812.703 215.549 845.302 206.752C877.901 197.955 932.923 203.132 932.923 203.132Z"
                fill="url(#ae8bd6c5__paint9_linear_25495_5756)"
            />
            <path
                d="M880.944 213.69L872.286 231.314C872.286 231.314 875.529 252.587 862.448 270.161C849.367 287.735 830.107 299.467 803.568 293.884C777.028 288.3 762.221 257.843 768.093 227.119C773.964 196.394 809.201 173.693 809.201 173.693L878.475 176.559L880.944 213.69Z"
                fill="url(#ae8bd6c5__paint10_linear_25495_5756)"
            />
            <path
                d="M865.376 267.527C867.826 271.395 871.733 274.47 877.852 275.789C901.526 280.837 924.207 266.476 924.207 266.476C924.207 266.476 954.267 248.238 955.249 224.565C956.231 200.891 959.117 161.801 944.984 140.503C935.39 126.044 944.211 91.6891 944.211 91.6891C944.211 91.6891 908.161 78.9054 888.752 25.3506C888.752 25.3506 852.86 59.6257 799.305 58.6637C799.305 58.6637 798.532 74.7698 799.305 87.4246C800.079 100.079 803.957 108.767 802.211 126.044C800.466 143.32 799.891 159.763 806.674 179.787C813.458 199.81 820.727 211.682 835.723 215.946C848.616 219.606 861.588 217.632 874.53 212.713L876.236 218.793C873.071 220.989 870.88 224.327 870.127 228.105C869.135 234.185 870.9 245.57 869.869 254.238C868.837 262.906 865.376 267.527 865.376 267.527Z"
                fill="#FFD4C2"
            />
            <path
                opacity={0.6}
                d="M926.765 94.213C922.798 101.155 916.658 144.518 931.643 165.748C934.651 170.009 946.089 184.379 952.873 185.728C950.135 167.143 951.605 152.394 944.983 140.508C935.39 123.289 944.21 91.6939 944.21 91.6939C944.21 91.6939 908.685 79.0986 889.177 26.605C889.177 26.605 901.068 74.8341 926.765 94.213Z"
                fill="#F4C2AD"
            />
            <path
                opacity={0.6}
                d="M919.001 183.952C906.153 195.738 891.428 205.298 875.433 212.237L874.639 213.228L876.196 218.762C873.031 220.958 870.841 224.297 870.087 228.075C869.234 233.093 870.315 241.721 870.137 249.457C875.155 255.199 880.61 251.728 880.61 251.728C881.928 250.514 883.038 249.089 883.892 247.513C885.717 244.459 881.453 234.452 881.453 234.452C913.169 213.437 919.001 183.952 919.001 183.952Z"
                fill="#F8BDA4"
            />
            <path
                d="M946.214 147.131C946.214 147.131 984.644 145.554 1011.46 176.556C1038.28 207.558 1041.91 269.295 1009.48 300.307C977.048 331.32 914.785 328.513 899.7 296.668C884.616 264.822 904.887 241.645 924.355 231.311C943.824 220.977 952.264 208.431 952.938 193.624C951.163 178.222 948.882 162.721 946.214 147.131Z"
                fill="url(#ae8bd6c5__paint11_linear_25495_5756)"
            />
            <path
                d="M889.882 21.7937C889.882 21.7937 897.251 0.649429 916.461 -10.2202"
                stroke="#333333"
                strokeWidth={0.991756}
                strokeMiterlimit={10}
            />
            <path
                d="M924.245 178.191C908.704 197.788 874.529 212.665 874.529 212.665L883.583 241.346C883.583 241.346 886.559 248.913 879.676 252.256"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M898.518 160.07C911.637 154.907 918.463 141.041 913.764 129.099C909.064 117.157 894.619 111.662 881.5 116.824C868.381 121.987 861.555 135.853 866.254 147.795C870.953 159.737 885.398 165.233 898.518 160.07Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M822.631 131.339C821.047 127.216 818.323 123.629 814.778 120.995C811.233 118.361 807.012 116.789 802.607 116.462C802.647 119.642 802.501 122.821 802.171 125.983C800.951 138.103 800.306 149.855 802.379 162.678C805.095 162.674 807.785 162.163 810.313 161.171C821.798 156.648 827.332 143.289 822.631 131.339Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M876.78 108.121C877.482 104.379 875.612 100.888 872.603 100.323C869.594 99.7587 866.585 102.334 865.883 106.075C865.18 109.817 867.051 113.307 870.06 113.872C873.069 114.437 876.078 111.862 876.78 108.121Z"
                fill="#333333"
            />
            <path
                d="M824.707 108.121C825.409 104.379 823.539 100.888 820.53 100.323C817.521 99.7586 814.512 102.334 813.81 106.075C813.107 109.817 814.978 113.307 817.987 113.872C820.996 114.437 824.005 111.862 824.707 108.121Z"
                fill="#333333"
            />
            <path
                d="M867.567 85.9399C867.567 85.9399 887.164 81.4373 896.279 97.5434"
                stroke="#333333"
                strokeWidth={3.96702}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M824.405 85.9399C824.405 85.9399 808.388 81.4373 800.93 97.5434"
                stroke="#333333"
                strokeWidth={3.96702}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M835.554 91.4541C835.554 91.4541 839.432 104.654 833.482 112.668C827.531 120.681 819.26 126.185 819.26 132.503C819.26 141.429 832.153 145.693 832.153 145.693"
                fill="#FFD4C2"
            />
            <path
                d="M835.554 91.4541C835.554 91.4541 839.432 104.654 833.482 112.668C827.531 120.681 819.26 126.185 819.26 132.503C819.26 141.429 832.153 145.693 832.153 145.693"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M829.038 178.192C834.595 181.527 842.182 183.5 850.408 181.527C859.553 179.334 864.865 174.381 869.7 166.445"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M743.252 348.933L726.826 406.532"
                stroke="#EEA70D"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M976.869 377.723L971.444 413.168"
                stroke="#EEA70D"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M1032.96 238.659C1033.29 242.355 1032.8 244.422 1032.8 244.422L1032.96 238.659C1031.89 226.758 1022.31 197.973 960.365 166.999C917.907 145.768 942.883 90.8208 942.883 90.8208L1035.29 154.509L1032.96 238.659Z"
                fill="#333333"
            />
        </g>
        <defs>
            <linearGradient
                id="ae8bd6c5__paint0_linear_25495_5756"
                x1={678.192}
                y1={-91.7923}
                x2={585.046}
                y2={390.108}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint1_linear_25495_5756"
                x1={182228}
                y1={1945.14}
                x2={182237}
                y2={3006.11}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint2_linear_25495_5756"
                x1={125126}
                y1={576.16}
                x2={125033}
                y2={13909.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint3_linear_25495_5756"
                x1={194199}
                y1={2476.48}
                x2={194159}
                y2={7296.73}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint4_linear_25495_5756"
                x1={99999.3}
                y1={4320.81}
                x2={99991.1}
                y2={5673.67}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint5_linear_25495_5756"
                x1={-4144.83}
                y1={354.878}
                x2={-4134.24}
                y2={1933.79}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint6_linear_25495_5756"
                x1={536.42}
                y1={-15.4101}
                x2={608}
                y2={400}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint7_linear_25495_5756"
                x1={1301.57}
                y1={-15.41}
                x2={1373.15}
                y2={400}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint8_linear_25495_5756"
                x1={-7.90732}
                y1={443.161}
                x2={-19.4989}
                y2={208.778}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#79A1B5" />
                <stop offset={1} stopColor="#7E99AB" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint9_linear_25495_5756"
                x1={876.639}
                y1={321.647}
                x2={1108.21}
                y2={418.343}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint10_linear_25495_5756"
                x1={840.144}
                y1={187.012}
                x2={815.836}
                y2={248.184}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint11_linear_25495_5756"
                x1={134362}
                y1={30435}
                x2={136411}
                y2={49278.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <clipPath id="ae8bd6c5__clip0_25495_5756">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default FlightNoCityPhotoL;
