import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightNoCityPhotoS = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 328 205"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#4e60b009__clip0_25495_5755)">
            <g clipPath="url(#4e60b009__clip1_25495_5755)">
                <path
                    d="M377.767 -1.53809H-237.233V177.76H377.767V-1.53809Z"
                    fill="url(#4e60b009__paint0_linear_25495_5755)"
                />
                <path
                    d="M322.468 141.409C324.907 141.954 327.441 141.913 329.861 141.29C332.282 140.666 334.52 139.477 336.392 137.821C338.037 136.34 339.375 134.5 341.235 133.311C344.823 131 349.476 131.6 353.756 131.615C354.704 131.685 355.655 131.525 356.528 131.149C357.451 130.672 358.066 129.785 358.706 128.96C361.694 125.055 365.743 121.749 370.535 120.663C375.327 119.576 380.877 121.109 383.681 125.147C385.059 127.131 385.7 129.539 386.92 131.625C388.396 134.122 390.65 136.066 393.336 137.16C395.975 138.221 399.204 138.605 400.793 140.968C401.567 142.126 401.777 143.561 401.961 144.945C402.197 146.763 402.416 148.584 402.617 150.408C402.697 150.753 402.656 151.115 402.5 151.433C402.228 151.854 401.649 151.91 401.152 151.946L383.214 152.412C375.66 152.612 368.09 152.807 360.562 152.161C347.877 151.075 335.536 147.615 323.277 144.176"
                    fill="#428C8A"
                />
                <path
                    opacity={0.67}
                    d="M54.9758 109.162H-4.42529C-4.42529 109.162 5.07557 103.537 9.02316 103.837C12.9708 104.137 12.3052 106.909 12.3052 106.909C12.3052 106.909 20.242 100.443 27.2304 100.819C34.2187 101.195 33.3909 104.623 33.3909 104.623C33.3909 104.623 41.0906 96.9439 53.3577 97.9835C62.9833 98.778 54.9758 109.162 54.9758 109.162Z"
                    fill="white"
                />
                <path
                    opacity={0.6}
                    d="M-25.5762 84.0494H-172.013C-172.013 84.0494 -152.513 64.8421 -131.946 61.9802C-111.379 59.1182 -112.092 73.0148 -112.092 73.0148C-112.092 73.0148 -85.2316 33.3912 -44.1026 37.151C-2.97363 40.9108 -19.5483 68.9285 -19.5483 68.9285C-19.5483 68.9285 2.87285 54.5932 17.4116 60.4752C31.9504 66.3573 20.5097 84.0494 20.5097 84.0494H-25.5762Z"
                    fill="url(#4e60b009__paint1_linear_25495_5755)"
                />
                <path
                    opacity={0.4}
                    d="M162.516 56.0616H59.4526C59.4526 56.0616 73.1774 44.3356 87.6401 42.5931C102.103 40.8506 101.616 49.3273 101.616 49.3273C101.616 49.3273 120.512 25.1424 149.458 27.4333C178.404 29.7242 166.734 46.8314 166.734 46.8314C166.734 46.8314 182.504 38.0831 192.754 41.6706C203.004 45.2581 194.937 56.0616 194.937 56.0616H162.516Z"
                    fill="url(#4e60b009__paint2_linear_25495_5755)"
                />
                <path
                    opacity={0.7}
                    d="M147.69 97.7309H74.4998C74.4998 97.7309 86.2053 90.9044 91.074 91.2683C95.9428 91.6322 95.1176 94.9839 95.1176 94.9839C95.1176 94.9839 104.891 87.1427 113.506 87.6039C122.121 88.0652 121.091 92.2164 121.091 92.2164C121.091 92.2164 130.578 82.8889 145.707 84.1702C157.55 85.1388 147.69 97.7309 147.69 97.7309Z"
                    fill="url(#4e60b009__paint3_linear_25495_5755)"
                />
                <path
                    d="M248.161 -7.94385C244.061 1.2299 231.72 30.8627 223.986 68.9312C218.994 93.5055 215.93 119.669 214.156 138.785C213.384 147.124 209.687 154.922 203.719 160.798C197.751 166.674 189.897 170.25 181.546 170.893C169.136 171.84 156.675 171.935 144.251 171.18C124.264 169.976 109.309 152.284 111.251 132.338C113.04 114.036 116.023 90.8251 120.922 68.9312C129.425 30.8678 142.35 1.23503 146.599 -7.94385H63.8042C59.6376 1.45028 46.7175 32.2874 38.6559 71.9857C33.4694 97.4979 30.2867 124.686 28.4469 144.525C27.6374 153.179 23.7952 161.268 17.5992 167.364C11.4032 173.46 3.25209 177.169 -5.414 177.837C-18.2985 178.821 -31.2353 178.92 -44.1334 178.135C-64.8999 176.884 -80.4184 158.511 -78.3991 137.806C-76.5439 118.797 -73.4433 94.7201 -68.3593 71.9703C-59.493 32.2874 -46.004 1.45028 -41.6478 -7.94385H-159.4C-163.71 1.7219 -177.337 34.1683 -185.819 75.9473C-191.252 102.684 -194.562 131.2 -196.515 151.946C-197.354 161.016 -201.373 169.498 -207.863 175.891C-214.352 182.283 -222.893 186.175 -231.975 186.878C-236.075 187.192 -240.161 187.425 -244.234 187.575V197.056H370.766V-7.94385H248.161Z"
                    fill="#BBC5CB"
                />
                <path
                    d="M259.395 0C255.32 9.17375 242.959 38.8065 235.22 76.875C230.228 101.449 227.164 127.612 225.39 146.729C224.619 155.069 220.922 162.867 214.954 168.743C208.986 174.619 201.131 178.195 192.78 178.837C180.371 179.783 167.912 179.879 155.491 179.124C135.503 177.919 120.543 160.228 122.491 140.281C124.274 121.975 127.288 98.7793 132.156 76.875C140.664 38.8065 153.584 9.17375 157.833 0H75.0384C70.8615 9.39412 57.9516 40.2518 49.9002 79.95C44.7137 105.462 41.5363 132.65 39.6964 152.479C38.8867 161.134 35.0438 169.224 28.8467 175.32C22.6497 181.415 14.4974 185.125 5.83037 185.791C-7.05415 186.775 -19.9909 186.874 -32.889 186.089C-53.6555 184.838 -69.1689 166.465 -67.1496 145.76C-65.2995 126.751 -62.1989 102.674 -57.1149 79.9244C-48.2589 40.2517 -34.7648 9.39412 -30.4085 0H-148.166C-152.476 9.66575 -166.103 42.1121 -174.585 83.8911C-180.018 110.628 -183.349 139.118 -185.276 159.9C-186.116 168.974 -190.14 177.458 -196.634 183.851C-203.129 190.245 -211.675 194.134 -220.761 194.832C-224.82 195.139 -228.9 195.362 -233 195.498V205H382V0H259.395Z"
                    fill="#D0DFEA"
                />
                <g opacity={0.3}>
                    <path
                        opacity={0.3}
                        d="M259.395 0C255.32 9.17375 242.959 38.8065 235.22 76.875C230.228 101.449 227.164 127.612 225.39 146.729C224.619 155.069 220.922 162.867 214.954 168.743C208.986 174.619 201.131 178.195 192.78 178.837C180.371 179.783 167.912 179.879 155.491 179.124C135.503 177.919 120.543 160.228 122.491 140.281C124.274 121.975 127.288 98.7793 132.156 76.875C140.664 38.8065 153.584 9.17375 157.833 0H75.0384C70.8615 9.39412 57.9516 40.2518 49.9002 79.95C44.7137 105.462 41.5363 132.65 39.6964 152.479C38.8867 161.134 35.0438 169.224 28.8467 175.32C22.6497 181.415 14.4974 185.125 5.83037 185.791C-7.05415 186.775 -19.9909 186.874 -32.889 186.089C-53.6555 184.838 -69.1689 166.465 -67.1496 145.76C-65.2995 126.751 -62.1989 102.674 -57.1149 79.9244C-48.2589 40.2517 -34.7648 9.39412 -30.4085 0H-148.166C-152.476 9.66575 -166.103 42.1121 -174.585 83.8911C-180.018 110.628 -183.349 139.118 -185.276 159.9C-186.116 168.974 -190.14 177.458 -196.634 183.851C-203.129 190.245 -211.675 194.134 -220.761 194.832C-224.82 195.139 -228.9 195.362 -233 195.498V205H382V0H259.395Z"
                        fill="url(#4e60b009__paint4_linear_25495_5755)"
                    />
                </g>
                <path
                    d="M247.248 -2.96191C247.248 -2.96191 231.089 30.7503 221.726 76.8753C216.729 101.45 213.664 127.613 211.896 146.729C211.124 155.069 207.426 162.868 201.456 168.744C195.487 174.62 187.632 178.195 179.281 178.837C174.658 179.179 170.028 179.415 165.392 179.544C174.527 179.768 183.668 179.532 192.78 178.837C201.131 178.195 208.985 174.62 214.954 168.744C220.922 162.867 224.619 155.069 225.39 146.729C227.163 127.633 230.228 101.45 235.22 76.8753C244.588 30.7503 260.748 -2.96191 260.748 -2.96191H247.248Z"
                    fill="#BBC5CB"
                />
                <g opacity={0.3}>
                    <path
                        opacity={0.5}
                        d="M103.267 -30.6014C97.7166 -18.9215 76.7707 21.4635 65.3932 71.1145C58.0798 103.043 54.1182 133.189 51.197 158.065C49.9178 168.931 44.8372 178.994 36.8538 186.474C28.8704 193.955 18.4986 198.371 7.57296 198.942C-8.65594 199.783 -24.9234 199.507 -41.1145 198.117C-67.1957 195.898 -86.1377 172.308 -82.955 146.329C-80.0338 122.482 -75.3854 92.2961 -68.2873 63.8165C-55.9207 14.2116 -37.9934 -24.1798 -32.2278 -35.875"
                        stroke="#7E9BAD"
                        strokeWidth={1.025}
                        strokeMiterlimit={10}
                        strokeLinecap="round"
                    />
                </g>
                <g opacity={0.3}>
                    <path
                        opacity={0.5}
                        d="M282.396 -27.4707C277.097 -16.3033 260.661 20.4019 249.791 67.8543C242.8 98.3993 238.167 130.969 235.369 154.744C234.147 165.13 229.291 174.749 221.66 181.899C214.029 189.05 204.115 193.271 193.672 193.817C178.155 194.617 162.602 194.353 147.121 193.027C122.193 190.9 104.071 168.361 107.146 143.53C109.94 120.734 114.383 91.8803 121.174 64.6819C133.007 17.2501 150.14 -19.4398 155.655 -30.6021"
                        stroke="#7E9BAD"
                        strokeWidth={1.025}
                        strokeMiterlimit={10}
                        strokeLinecap="round"
                    />
                </g>
                <path
                    opacity={0.3}
                    d="M52.2526 21.9702L50.6843 26.3623L66.2643 21.9702H52.2526Z"
                    fill="#7D9CAE"
                />
                <path
                    d="M-39.6031 21.9712H66.264C71.9374 6.36558 76.3961 -2.96191 76.3961 -2.96191H-29.0251C-29.0251 -2.96191 -33.6376 6.36558 -39.6031 21.9712Z"
                    fill="#F2F5F8"
                />
                <path
                    d="M-4.49146 13.9507H37.6207"
                    stroke="#BBC5CB"
                    strokeWidth={3.075}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M149.028 21.0487H251.015C256.468 6.02221 260.753 -2.96191 260.753 -2.96191H159.242C159.242 -2.96191 154.773 6.02221 149.028 21.0487Z"
                    fill="#F2F5F8"
                />
                <path
                    d="M182.848 13.3252H223.407"
                    stroke="#FFD2C6"
                    strokeWidth={3.075}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M372.518 270.483C371.973 222.106 368.808 173.793 363.037 125.758C361.857 116.091 357.751 107.015 351.268 99.7468C344.786 92.4786 336.237 87.365 326.767 85.0913C294.367 77.2911 253.008 72.0431 219.962 71.2538C211.988 71.0642 195.434 72.5453 188.982 76.3788C179.28 82.1701 181.089 92.5277 178.824 104.3C172.085 139.35 162.06 199.451 158.063 264.364"
                    fill="#5F8296"
                />
                <path
                    d="M348.175 273.809C347.632 225.43 344.471 177.116 338.704 129.079C337.523 119.412 333.417 110.337 326.934 103.069C320.452 95.8004 311.904 90.6866 302.434 88.4123C270.034 80.6171 228.675 75.3691 195.629 74.5748C185.961 74.3154 176.514 77.497 168.973 83.5527C161.431 89.6084 156.284 98.1449 154.45 107.641C147.71 142.696 137.686 202.797 133.688 267.705"
                    fill="#4F6C7F"
                />
                <path
                    d="M233.359 -15.2029C216.819 -15.2029 204.566 -8.1329 195.47 0.589506C192.868 3.08458 189.93 5.12795 187.954 7.90118C182.001 16.2572 178.908 25.436 178.782 32.7875L184.737 43.9588C184.737 43.9588 185.431 56.971 168.992 65.6999C152.554 74.4287 144.612 85.213 150.327 96.9438C150.327 96.9438 135.276 110.411 141.13 125.573C146.983 140.734 167.043 143.193 167.043 143.193L298.633 161.205C298.633 161.205 317.012 179.258 332.5 166C347.988 152.742 340.886 116.012 335.989 109.192C329.897 100.709 319.163 96.5359 319.163 96.5359C319.163 96.5359 323.789 84.7682 313.652 74.9254C303.515 65.0825 292.742 72.9407 289.538 59.9494C286.334 46.9581 300.565 18.8524 276.846 -3.76208C256.209 -20.5046 233.359 -15.2029 233.359 -15.2029Z"
                    fill="#333333"
                />
                <path
                    d="M247.276 105.383C285.858 113.328 316.556 134.518 325.562 158.089C334.568 181.66 339 211.307 339 211.307C339 211.307 297.76 237 190.78 237C128.87 237 107.288 211.84 108.106 211.307C108.068 208.848 127.783 175.019 141.809 148.027C155.836 121.035 185.737 111.739 202.424 107.236C219.111 102.734 247.276 105.383 247.276 105.383Z"
                    fill="url(#4e60b009__paint5_linear_25495_5755)"
                />
                <path
                    d="M220.669 110.788L216.237 119.809C216.237 119.809 217.897 130.698 211.201 139.694C204.505 148.69 194.646 154.696 181.061 151.837C167.476 148.979 159.897 133.389 162.902 117.662C165.908 101.934 183.945 90.314 183.945 90.314L219.405 91.7811L220.669 110.788Z"
                    fill="url(#4e60b009__paint6_linear_25495_5755)"
                />
                <path
                    d="M212.7 138.346C213.954 140.326 215.954 141.9 219.086 142.575C231.204 145.159 242.814 137.808 242.814 137.808C242.814 137.808 258.202 128.472 258.704 116.354C259.207 104.236 260.684 84.2267 253.45 73.3249C248.538 65.9232 253.054 48.3378 253.054 48.3378C253.054 48.3378 234.6 41.7941 224.665 14.3804C224.665 14.3804 206.293 31.9251 178.879 31.4327C178.879 31.4327 178.484 39.6771 178.879 46.1549C179.275 52.6326 181.26 57.0797 180.367 65.9232C179.473 74.7667 179.179 83.1837 182.651 93.4334C186.124 103.683 189.845 109.76 197.521 111.943C204.12 113.816 210.761 112.806 217.386 110.288L218.259 113.4C216.638 114.524 215.517 116.233 215.132 118.167C214.624 121.279 215.528 127.107 215 131.543C214.472 135.98 212.7 138.346 212.7 138.346Z"
                    fill="#FFD4C2"
                />
                <path
                    opacity={0.6}
                    d="M244.123 49.6297C242.093 53.1833 238.95 75.3799 246.621 86.2469C248.16 88.4281 254.015 95.7842 257.488 96.4746C256.086 86.961 256.839 79.4116 253.449 73.3273C248.538 64.513 253.053 48.3403 253.053 48.3403C253.053 48.3403 234.869 41.893 224.883 15.0225C224.883 15.0225 230.97 39.71 244.123 49.6297Z"
                    fill="#F4C2AD"
                />
                <path
                    opacity={0.6}
                    d="M240.149 95.5654C233.572 101.599 226.035 106.492 217.848 110.044L217.441 110.552L218.238 113.384C216.618 114.508 215.497 116.217 215.111 118.151C214.675 120.72 215.228 125.137 215.137 129.096C217.705 132.036 220.498 130.259 220.498 130.259C221.173 129.637 221.74 128.908 222.178 128.101C223.112 126.538 220.929 121.416 220.929 121.416C237.164 110.658 240.149 95.5654 240.149 95.5654Z"
                    fill="#F8BDA4"
                />
                <path
                    d="M254.079 76.7173C254.079 76.7173 273.751 75.9101 287.478 91.7796C301.205 107.649 303.063 139.251 286.463 155.126C269.862 171 237.991 169.563 230.27 153.262C222.548 136.961 232.925 125.097 242.89 119.808C252.856 114.518 257.176 108.096 257.521 100.516C256.612 92.6325 255.445 84.6978 254.079 76.7173Z"
                    fill="url(#4e60b009__paint7_linear_25495_5755)"
                />
                <path
                    d="M225.244 12.5597C225.244 12.5597 229.016 1.73633 238.849 -3.82764"
                    stroke="#333333"
                    strokeWidth={0.507661}
                    strokeMiterlimit={10}
                />
                <path
                    d="M242.834 92.6167C234.879 102.648 217.385 110.263 217.385 110.263L222.02 124.945C222.02 124.945 223.543 128.818 220.02 130.529"
                    stroke="#E49776"
                    strokeWidth={1.01532}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M229.664 83.3406C236.38 80.698 239.874 73.6002 237.468 67.4873C235.063 61.3744 227.669 58.5612 220.953 61.2039C214.238 63.8465 210.744 70.9442 213.149 77.0571C215.555 83.17 222.949 85.9832 229.664 83.3406Z"
                    fill="#FC8D72"
                    fillOpacity={0.28}
                />
                <path
                    d="M190.819 68.634C190.008 66.5236 188.614 64.6873 186.8 63.3391C184.985 61.9908 182.824 61.1862 180.57 61.019C180.59 62.6465 180.515 64.2738 180.346 65.8926C179.722 72.0962 179.392 78.112 180.453 84.6761C181.843 84.6738 183.22 84.4121 184.514 83.9044C190.393 81.5895 193.226 74.7513 190.819 68.634Z"
                    fill="#FC8D72"
                    fillOpacity={0.28}
                />
                <path
                    d="M218.537 56.7487C218.897 54.8335 217.939 53.0467 216.399 52.7575C214.859 52.4684 213.319 53.7866 212.959 55.7017C212.6 57.6169 213.557 59.4038 215.097 59.6929C216.638 59.982 218.178 58.6639 218.537 56.7487Z"
                    fill="#333333"
                />
                <path
                    d="M191.882 56.7487C192.241 54.8335 191.284 53.0466 189.744 52.7575C188.203 52.4684 186.663 53.7866 186.304 55.7017C185.944 57.6169 186.902 59.4038 188.442 59.6929C189.982 59.982 191.523 58.6639 191.882 56.7487Z"
                    fill="#333333"
                />
                <path
                    d="M213.821 45.395C213.821 45.395 223.853 43.0902 228.518 51.3347"
                    stroke="#333333"
                    strokeWidth={2.03064}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M191.728 45.395C191.728 45.395 183.529 43.0902 179.711 51.3347"
                    stroke="#333333"
                    strokeWidth={2.03064}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M197.434 48.2178C197.434 48.2178 199.419 54.9747 196.373 59.0766C193.328 63.1785 189.094 65.9961 189.094 69.2299C189.094 73.7988 195.693 75.9818 195.693 75.9818"
                    fill="#FFD4C2"
                />
                <path
                    d="M197.434 48.2178C197.434 48.2178 199.419 54.9747 196.373 59.0766C193.328 63.1785 189.094 65.9961 189.094 69.2299C189.094 73.7988 195.693 75.9818 195.693 75.9818"
                    stroke="#E49776"
                    strokeWidth={1.01532}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M194.099 92.6172C196.943 94.3242 200.827 95.334 205.038 94.3242C209.719 93.2015 212.438 90.6665 214.913 86.604"
                    stroke="#E49776"
                    strokeWidth={1.01532}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M150.187 180.016L141.779 209.5"
                    stroke="#EEA70D"
                    strokeWidth={1.01532}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M269.771 194.753L266.994 212.897"
                    stroke="#EEA70D"
                    strokeWidth={1.01532}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M298.481 123.569C298.65 125.461 298.399 126.519 298.399 126.519L298.481 123.569C297.935 117.477 293.029 102.743 261.323 86.8879C239.589 76.0198 252.374 47.8936 252.374 47.8936L299.677 80.4944L298.481 123.569Z"
                    fill="#333333"
                />
            </g>
        </g>
        <defs>
            <linearGradient
                id="4e60b009__paint0_linear_25495_5755"
                x1={106.142}
                y1={-46.6381}
                x2={58.1716}
                y2={197.865}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint1_linear_25495_5755"
                x1={63894.3}
                y1={295.281}
                x2={63846.7}
                y2={7128.51}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint2_linear_25495_5755"
                x1={99294}
                y1={1269.19}
                x2={99273.3}
                y2={3739.58}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint3_linear_25495_5755"
                x1={51016.6}
                y1={2214.41}
                x2={51012.4}
                y2={2907.75}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint4_linear_25495_5755"
                x1={41.9155}
                y1={-7.89762}
                x2={78.6003}
                y2={205}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint5_linear_25495_5755"
                x1={218.465}
                y1={166.049}
                x2={337.004}
                y2={215.546}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint6_linear_25495_5755"
                x1={199.784}
                y1={97.1319}
                x2={187.341}
                y2={128.444}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint7_linear_25495_5755"
                x1={68547}
                y1={15580.5}
                x2={69595.9}
                y2={25226.1}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <clipPath id="4e60b009__clip0_25495_5755">
                <rect width={328} height={205} fill="white" />
            </clipPath>
            <clipPath id="4e60b009__clip1_25495_5755">
                <rect
                    width={615}
                    height={205}
                    fill="white"
                    transform="translate(-233)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default FlightNoCityPhotoS;
