import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LogoMonochrome = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 113 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M33.1099 2.71875H40.0591V13.264H38.2232V4.14502H34.9458V13.264H33.1099V2.71875Z"
            fill="#0D0D0D"
        />
        <path
            d="M42.5417 15.6159C42.1877 15.6159 41.9348 15.5703 41.7831 15.4793C41.6313 15.3984 41.5555 15.3579 41.5555 15.3579V13.8861C41.6566 13.9873 41.778 14.0631 41.9196 14.1137C42.0612 14.1643 42.213 14.1896 42.3748 14.1896C42.6277 14.1896 42.83 14.134 42.9817 14.0227C43.1335 13.9215 43.2599 13.7799 43.3611 13.5978L40.7361 5.63198H42.6327L44.317 11.3674L46.0012 5.63198H47.7461L45.3639 12.8544C45.111 13.6332 44.7873 14.2857 44.3928 14.8117C43.9983 15.3478 43.3813 15.6159 42.5417 15.6159Z"
            fill="#0D0D0D"
        />
        <path
            d="M54.1781 7.05825H52.0539V13.264H50.2483V7.05825H48.1241V5.63198H54.1781V7.05825Z"
            fill="#0D0D0D"
        />
        <path
            d="M60.5553 12.7482C60.2923 12.9302 59.9484 13.087 59.5236 13.2185C59.0987 13.35 58.598 13.4158 58.0214 13.4158C56.8784 13.4158 55.9882 13.0921 55.351 12.4447C54.7238 11.7872 54.4102 10.7959 54.4102 9.47077C54.4102 8.89419 54.476 8.36313 54.6075 7.87759C54.739 7.38194 54.9362 6.96215 55.1992 6.61823C55.4724 6.26419 55.8112 5.98602 56.2158 5.78371C56.6306 5.5814 57.1111 5.48025 57.6573 5.48025C58.5576 5.48025 59.2757 5.75842 59.8119 6.31477C60.3581 6.87111 60.6312 7.81184 60.6312 9.13696V10.0929H56.2765C56.317 10.7301 56.4788 11.2056 56.7621 11.5191C57.0453 11.8327 57.5157 11.9895 58.1732 11.9895C58.6081 11.9895 59.0431 11.9187 59.4781 11.7771C59.913 11.6355 60.2721 11.4686 60.5553 11.2764V12.7482ZM57.6269 6.90652C57.192 6.90652 56.8632 7.06331 56.6407 7.37688C56.4182 7.69046 56.2968 8.15071 56.2765 8.75763H58.7953V8.6059C58.7953 8.13048 58.7093 7.73092 58.5373 7.40723C58.3755 7.07342 58.072 6.90652 57.6269 6.90652Z"
            fill="#0D0D0D"
        />
        <path
            d="M61.8409 13.264V5.63198H63.6465V11.8378H65.619V5.63198H67.4246V11.8378H69.3971V5.63198H71.2027V13.264H61.8409Z"
            fill="#0D0D0D"
        />
        <path
            d="M78.5585 12.7482C78.2955 12.9302 77.9516 13.087 77.5268 13.2185C77.1019 13.35 76.6012 13.4158 76.0246 13.4158C74.8816 13.4158 73.9915 13.0921 73.3542 12.4447C72.727 11.7872 72.4135 10.7959 72.4135 9.47077C72.4135 8.89419 72.4792 8.36313 72.6107 7.87759C72.7422 7.38194 72.9395 6.96215 73.2025 6.61823C73.4756 6.26419 73.8144 5.98602 74.219 5.78371C74.6338 5.5814 75.1143 5.48025 75.6605 5.48025C76.5608 5.48025 77.2789 5.75842 77.8151 6.31477C78.3613 6.87111 78.6344 7.81184 78.6344 9.13696V10.0929H74.2797C74.3202 10.7301 74.482 11.2056 74.7653 11.5191C75.0485 11.8327 75.5189 11.9895 76.1764 11.9895C76.6113 11.9895 77.0463 11.9187 77.4813 11.7771C77.9162 11.6355 78.2753 11.4686 78.5585 11.2764V12.7482ZM75.6301 6.90652C75.1952 6.90652 74.8664 7.06331 74.6439 7.37688C74.4214 7.69046 74.3 8.15071 74.2797 8.75763H76.7985V8.6059C76.7985 8.13048 76.7125 7.73092 76.5405 7.40723C76.3787 7.07342 76.0752 6.90652 75.6301 6.90652Z"
            fill="#0D0D0D"
        />
        <path
            d="M83.1808 13.4158C81.977 13.4158 81.0768 13.0718 80.48 12.384C79.8933 11.6961 79.5999 10.72 79.5999 9.45559C79.5999 8.87902 79.6758 8.34796 79.8275 7.86242C79.9792 7.36677 80.1967 6.94698 80.48 6.60306C80.7733 6.24902 81.1375 5.9759 81.5724 5.78371C82.0175 5.5814 82.5283 5.48025 83.1049 5.48025C83.55 5.48025 83.9344 5.51565 84.258 5.58646C84.5919 5.65727 84.8549 5.74325 85.047 5.8444V7.37688C84.865 7.26561 84.6121 7.1594 84.2884 7.05825C83.9748 6.95709 83.6461 6.90652 83.3021 6.90652C82.7155 6.90652 82.2603 7.11894 81.9366 7.54379C81.623 7.96863 81.4662 8.59073 81.4662 9.41008C81.4662 10.1991 81.6078 10.8262 81.8911 11.2915C82.1844 11.7568 82.6497 11.9895 83.287 11.9895C83.6612 11.9895 83.99 11.944 84.2732 11.8529C84.5666 11.7619 84.8245 11.6355 85.047 11.4736V12.9454C84.8245 13.1072 84.5615 13.2236 84.258 13.2944C83.9546 13.3753 83.5955 13.4158 83.1808 13.4158Z"
            fill="#0D0D0D"
        />
        <path
            d="M91.7848 7.05825H89.6606V13.264H87.855V7.05825H85.7308V5.63198H91.7848V7.05825Z"
            fill="#0D0D0D"
        />
        <path
            d="M95.8581 13.264H92.8538V5.63198H95.8884C96.7179 5.63198 97.3451 5.79383 97.7699 6.11752C98.2049 6.44121 98.4223 6.92675 98.4223 7.57413C98.4223 8.02933 98.301 8.40359 98.0582 8.69694C97.8154 8.98017 97.4917 9.17742 97.0871 9.28869C97.5929 9.37973 97.9874 9.57192 98.2706 9.86527C98.564 10.1586 98.7106 10.5531 98.7106 11.0488C98.7106 11.7771 98.4577 12.3284 97.952 12.7026C97.4462 13.0769 96.7482 13.264 95.8581 13.264ZM95.6305 6.99756H94.6594V8.69694H95.5698C95.9137 8.69694 96.1767 8.62107 96.3588 8.46934C96.551 8.31761 96.6471 8.11025 96.6471 7.84725C96.6471 7.56402 96.5561 7.35159 96.374 7.20998C96.202 7.06836 95.9542 6.99756 95.6305 6.99756ZM95.6609 10.017H94.6594V11.8985H95.6609C96.025 11.8985 96.3133 11.8226 96.5257 11.6709C96.7381 11.5191 96.8444 11.2713 96.8444 10.9274C96.8444 10.6138 96.7432 10.3862 96.5409 10.2446C96.3386 10.0929 96.0452 10.017 95.6609 10.017Z"
            fill="#0D0D0D"
        />
        <path
            d="M99.9218 5.63198H101.682V10.3508L104.474 5.63198H106.037V13.264H104.276V8.54521L101.485 13.264H99.9218V5.63198Z"
            fill="#0D0D0D"
        />
        <path
            d="M107.022 13.264L108.736 10.3811C108.251 10.2193 107.876 9.95631 107.613 9.59215C107.35 9.21788 107.219 8.74246 107.219 8.16588C107.219 7.34654 107.502 6.71938 108.069 6.28442C108.635 5.84946 109.358 5.63198 110.238 5.63198H113V13.264H111.194V10.7757H110.329L108.873 13.264H107.022ZM110.375 7.05825C109.98 7.05825 109.662 7.14929 109.419 7.33136C109.176 7.51344 109.055 7.81184 109.055 8.22657C109.055 8.66154 109.166 8.97511 109.389 9.16731C109.611 9.3595 109.925 9.45559 110.329 9.45559H111.194V7.05825H110.375Z"
            fill="#0D0D0D"
        />
        <mask
            id="7dd9d903__mask0_27464_4722"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={15}
            y={1}
            width={14}
            height={14}
        >
            <circle cx={22} cy={8} r={7} fill="white" />
        </mask>
        <g mask="url(#7dd9d903__mask0_27464_4722)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M29 1H15V15H15.9649C15.9867 13.9275 16.1246 12.8543 16.3076 11.8917C16.585 10.4332 16.9747 9.18554 17.2568 8.52802C17.8623 7.11711 18.9156 6.74803 20.3555 6.74881H20.3556C21.3705 6.74936 22.3853 6.74918 23.4001 6.749H23.4017L24.9036 6.74883C26.16 6.74798 27.0629 7.5885 27.0592 8.8647C27.0574 9.46954 26.9966 10.411 26.9036 11.4276C26.7993 12.5687 26.6502 13.868 26.4774 15H29V1ZM25.2042 15C25.4094 13.7054 25.5705 12.4039 25.6905 11.0988C25.7692 10.2433 25.8241 9.64585 25.8176 8.98429C25.8105 8.26836 25.4901 7.95529 24.8082 7.95529H20.4461C19.4508 7.95529 18.8021 8.03018 18.3759 9.02341C18.1401 9.57293 17.7803 10.708 17.5209 12.0723C17.351 12.9656 17.2276 14.0357 17.2066 15H22.2082C22.3077 12.7472 22.7511 10.4492 23.2383 9.08611C23.3554 8.75871 23.7156 8.58817 24.043 8.7052C24.3704 8.82222 24.541 9.18249 24.4239 9.50989C23.9864 10.734 23.5675 12.8819 23.4685 15H25.2042ZM23.4875 3.42179C23.8647 3.2941 24.3154 3.26169 24.7894 3.26169C25.2902 3.26169 25.7649 3.33198 26.1355 3.53712C26.5828 3.78473 26.8523 4.17339 26.8139 4.69861C26.7943 4.96763 26.7223 5.3239 26.6471 5.69587L26.6471 5.69598L26.647 5.69609L26.647 5.69621L26.647 5.69653C26.6311 5.775 26.6151 5.85418 26.5994 5.93337C26.5345 6.26118 26.2162 6.47431 25.8884 6.40942C25.5606 6.34453 25.3475 6.02619 25.4123 5.69839C25.4399 5.55926 25.4636 5.44297 25.4866 5.33049L25.4866 5.3304L25.4867 5.33008C25.5189 5.17246 25.5496 5.02225 25.587 4.82706C25.6162 4.67486 25.5723 4.591 25.428 4.54611C25.2962 4.50511 25.0907 4.4718 24.7894 4.4718C24.3442 4.4718 24.0576 4.50636 23.8755 4.568C23.7411 4.6135 23.6794 4.68663 23.6303 4.81268C23.5414 5.04084 23.507 5.19154 23.4056 5.6357L23.3536 5.8628C23.2654 6.18511 22.9232 6.38488 22.6009 6.29666C22.2786 6.20845 22.101 5.89907 22.177 5.55334C22.3322 4.84739 22.389 4.63899 22.5506 4.25531C22.7351 3.81731 23.0819 3.55909 23.4875 3.42179Z"
                fill="#0D0D0D"
            />
        </g>
        <mask
            id="7dd9d903__mask1_27464_4722"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={1}
            width={14}
            height={14}
        >
            <circle cx={7} cy={8} r={7} fill="white" />
        </mask>
        <g mask="url(#7dd9d903__mask1_27464_4722)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7 15C3.13401 15 0 11.866 0 8C0 4.13401 3.134 1 7 1C10.866 1 14 4.134 14 8C14 11.866 10.866 15 7 15ZM7.32375 4.92009H8.03218V12.2068H9.44905V3.80683H7.32375C5.19845 3.80683 4.08519 4.92009 4.08519 6.53936C4.08519 7.85503 4.69242 8.56346 5.80568 9.3731L3.88279 12.2068H5.50206L7.52616 9.06949L6.81772 8.56346C5.90688 7.95623 5.50206 7.45021 5.50206 6.43816C5.50206 5.52732 6.10929 4.92009 7.32375 4.92009Z"
                fill="#0D0D0D"
            />
        </g>
    </svg>
);

export default LogoMonochrome;
