import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlusPromoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 800 300"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        xmlnsXlink="http://www.w3.org/1999/xlink"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#ff5a980b__clip0_27804_5736)">
            <rect width={800} height={300} fill="white" />
            <g opacity={0.4} filter="url(#ff5a980b__filter0_f_27804_5736)">
                <path
                    d="M-304.092 172.936L361.385 -134.237L1038.56 88.2929L365.313 601.121L-304.092 172.936Z"
                    fill="url(#ff5a980b__paint0_radial_27804_5736)"
                />
                <path
                    d="M-304.092 172.936L361.385 -134.237L1038.56 88.2929L365.313 601.121L-304.092 172.936Z"
                    fill="url(#ff5a980b__paint1_radial_27804_5736)"
                />
            </g>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M118.628 -63.4665C119.88 -63.4665 120.895 -64.4813 120.895 -65.7332C120.895 -66.9851 119.88 -68 118.628 -68C117.376 -68 116.361 -66.9851 116.361 -65.7332C116.361 -64.4813 117.376 -63.4665 118.628 -63.4665ZM45.3355 -61.9547C45.3355 -59.4508 43.3057 -57.4211 40.8019 -57.4211C38.2981 -57.4211 36.2684 -59.4508 36.2684 -61.9547C36.2684 -64.4585 38.2981 -66.4882 40.8019 -66.4882C43.3057 -66.4882 45.3355 -64.4585 45.3355 -61.9547ZM456.377 -4.53015C464.723 -4.53015 471.489 -11.2959 471.489 -19.642C471.489 -27.988 464.723 -34.7538 456.377 -34.7538C448.031 -34.7538 441.266 -27.988 441.266 -19.642C441.266 -11.2959 448.031 -4.53015 456.377 -4.53015ZM388.374 179.835C388.374 188.181 381.608 194.947 373.262 194.947C364.916 194.947 358.15 188.181 358.15 179.835C358.15 171.489 364.916 164.723 373.262 164.723C381.608 164.723 388.374 171.489 388.374 179.835ZM25.6901 330.953C32.3669 330.953 37.7795 325.541 37.7795 318.864C37.7795 312.187 32.3669 306.774 25.6901 306.774C19.0132 306.774 13.6006 312.187 13.6006 318.864C13.6006 325.541 19.0132 330.953 25.6901 330.953ZM104.272 453.358C110.948 453.358 116.361 447.945 116.361 441.268C116.361 434.591 110.948 429.179 104.272 429.179C97.5947 429.179 92.1821 434.591 92.1821 441.268C92.1821 447.945 97.5947 453.358 104.272 453.358ZM513.802 468.47C513.802 473.478 509.743 477.538 504.735 477.538C499.727 477.538 495.668 473.478 495.668 468.47C495.668 463.463 499.727 459.403 504.735 459.403C509.743 459.403 513.802 463.463 513.802 468.47ZM476.023 609.011C479.361 609.011 482.068 606.305 482.068 602.966C482.068 599.628 479.361 596.921 476.023 596.921C472.684 596.921 469.978 599.628 469.978 602.966C469.978 606.305 472.684 609.011 476.023 609.011ZM188.898 580.298C188.898 586.975 183.485 592.387 176.808 592.387C170.131 592.387 164.719 586.975 164.719 580.298C164.719 573.621 170.131 568.208 176.808 568.208C183.485 568.208 188.898 573.621 188.898 580.298ZM160.185 800.931C168.531 800.931 175.297 794.165 175.297 785.819C175.297 777.473 168.531 770.707 160.185 770.707C151.839 770.707 145.074 777.473 145.074 785.819C145.074 794.165 151.839 800.931 160.185 800.931ZM182.853 466.958C182.853 472.8 178.117 477.536 172.275 477.536C166.433 477.536 161.697 472.8 161.697 466.958C161.697 461.116 166.433 456.38 172.275 456.38C178.117 456.38 182.853 461.116 182.853 466.958ZM482.067 361.176C490.413 361.176 497.179 354.41 497.179 346.064C497.179 337.718 490.413 330.952 482.067 330.952C473.721 330.952 466.956 337.718 466.956 346.064C466.956 354.41 473.721 361.176 482.067 361.176ZM63.4696 33.2487C63.4696 41.5947 56.7038 48.3605 48.3577 48.3605C40.0117 48.3605 33.2459 41.5947 33.2459 33.2487C33.2459 24.9026 40.0117 18.1368 48.3577 18.1368C56.7038 18.1368 63.4696 24.9026 63.4696 33.2487ZM101.249 273.527C109.595 273.527 116.361 266.761 116.361 258.415C116.361 250.069 109.595 243.303 101.249 243.303C92.9032 243.303 86.1374 250.069 86.1374 258.415C86.1374 266.761 92.9032 273.527 101.249 273.527ZM226.677 179.835C226.677 188.181 219.912 194.947 211.566 194.947C203.22 194.947 196.454 188.181 196.454 179.835C196.454 171.489 203.22 164.723 211.566 164.723C219.912 164.723 226.677 171.489 226.677 179.835ZM364.195 856.845C372.541 856.845 379.307 850.079 379.307 841.733C379.307 833.387 372.541 826.621 364.195 826.621C355.849 826.621 349.083 833.387 349.083 841.733C349.083 850.079 355.849 856.845 364.195 856.845ZM409.531 631.678C409.531 640.024 402.765 646.79 394.419 646.79C386.073 646.79 379.307 640.024 379.307 631.678C379.307 623.332 386.073 616.566 394.419 616.566C402.765 616.566 409.531 623.332 409.531 631.678ZM40.8018 507.76C49.1478 507.76 55.9136 500.994 55.9136 492.648C55.9136 484.302 49.1478 477.536 40.8018 477.536C32.4558 477.536 25.69 484.302 25.69 492.648C25.69 500.994 32.4558 507.76 40.8018 507.76ZM172.275 126.943C172.275 133.62 166.862 139.033 160.186 139.033C153.509 139.033 148.096 133.62 148.096 126.943C148.096 120.267 153.509 114.854 160.186 114.854C166.862 114.854 172.275 120.267 172.275 126.943ZM33.246 178.322C39.9228 178.322 45.3355 172.909 45.3355 166.232C45.3355 159.556 39.9228 154.143 33.246 154.143C26.5692 154.143 21.1565 159.556 21.1565 166.232C21.1565 172.909 26.5692 178.322 33.246 178.322ZM222.144 317.351C222.144 322.359 218.084 326.418 213.077 326.418C208.069 326.418 204.01 322.359 204.01 317.351C204.01 312.344 208.069 308.284 213.077 308.284C218.084 308.284 222.144 312.344 222.144 317.351ZM208.543 681.547C214.386 681.547 219.122 676.811 219.122 670.969C219.122 665.126 214.386 660.39 208.543 660.39C202.701 660.39 197.965 665.126 197.965 670.969C197.965 676.811 202.701 681.547 208.543 681.547ZM426.154 547.05C426.154 552.058 422.094 556.118 417.087 556.118C412.079 556.118 408.02 552.058 408.02 547.05C408.02 542.043 412.079 537.983 417.087 537.983C422.094 537.983 426.154 542.043 426.154 547.05ZM417.087 207.035C422.094 207.035 426.154 202.976 426.154 197.968C426.154 192.96 422.094 188.901 417.087 188.901C412.079 188.901 408.019 192.96 408.019 197.968C408.019 202.976 412.079 207.035 417.087 207.035ZM101.249 52.8956C101.249 57.9032 97.1899 61.9627 92.1823 61.9627C87.1747 61.9627 83.1152 57.9032 83.1152 52.8956C83.1152 47.888 87.1747 43.8285 92.1823 43.8285C97.1899 43.8285 101.249 47.888 101.249 52.8956ZM340.016 61.9627C345.024 61.9627 349.083 57.9032 349.083 52.8956C349.083 47.888 345.024 43.8285 340.016 43.8285C335.009 43.8285 330.949 47.888 330.949 52.8956C330.949 57.9032 335.009 61.9627 340.016 61.9627ZM371.751 465.447C371.751 470.455 367.692 474.514 362.684 474.514C357.676 474.514 353.617 470.455 353.617 465.447C353.617 460.439 357.676 456.38 362.684 456.38C367.692 456.38 371.751 460.439 371.751 465.447ZM110.316 689.103C115.324 689.103 119.383 685.043 119.383 680.035C119.383 675.028 115.324 670.968 110.316 670.968C105.309 670.968 101.249 675.028 101.249 680.035C101.249 685.043 105.309 689.103 110.316 689.103ZM525.892 719.327C525.892 724.334 521.832 728.394 516.824 728.394C511.817 728.394 507.757 724.334 507.757 719.327C507.757 714.319 511.817 710.26 516.824 710.26C521.832 710.26 525.892 714.319 525.892 719.327ZM293.169 335.486C295.673 335.486 297.703 333.456 297.703 330.952C297.703 328.449 295.673 326.419 293.169 326.419C290.666 326.419 288.636 328.449 288.636 330.952C288.636 333.456 290.666 335.486 293.169 335.486ZM408.019 268.993C408.019 271.497 405.99 273.527 403.486 273.527C400.982 273.527 398.952 271.497 398.952 268.993C398.952 266.489 400.982 264.46 403.486 264.46C405.99 264.46 408.019 266.489 408.019 268.993ZM403.486 403.49C405.99 403.49 408.019 401.46 408.019 398.957C408.019 396.453 405.99 394.423 403.486 394.423C400.982 394.423 398.952 396.453 398.952 398.957C398.952 401.46 400.982 403.49 403.486 403.49ZM408.019 139.032C408.019 141.536 405.99 143.566 403.486 143.566C400.982 143.566 398.952 141.536 398.952 139.032C398.952 136.528 400.982 134.498 403.486 134.498C405.99 134.498 408.019 136.528 408.019 139.032ZM152.63 188.902C155.133 188.902 157.163 186.872 157.163 184.368C157.163 181.864 155.133 179.835 152.63 179.835C150.126 179.835 148.096 181.864 148.096 184.368C148.096 186.872 150.126 188.902 152.63 188.902ZM157.163 43.8266C157.163 46.3305 155.133 48.3602 152.63 48.3602C150.126 48.3602 148.096 46.3305 148.096 43.8266C148.096 41.3228 150.126 39.2931 152.63 39.2931C155.133 39.2931 157.163 41.3228 157.163 43.8266ZM471.489 48.3602C473.993 48.3602 476.023 46.3305 476.023 43.8266C476.023 41.3228 473.993 39.2931 471.489 39.2931C468.985 39.2931 466.956 41.3228 466.956 43.8266C466.956 46.3305 468.985 48.3602 471.489 48.3602ZM344.55 -9.06411C344.55 -6.5603 342.52 -4.53056 340.016 -4.53056C337.512 -4.53056 335.482 -6.5603 335.482 -9.06411C335.482 -11.5679 337.512 -13.5977 340.016 -13.5977C342.52 -13.5977 344.55 -11.5679 344.55 -9.06411ZM340.016 235.747C342.52 235.747 344.55 233.718 344.55 231.214C344.55 228.71 342.52 226.68 340.016 226.68C337.512 226.68 335.482 228.71 335.482 231.214C335.482 233.718 337.512 235.747 340.016 235.747ZM69.5145 231.214C69.5145 233.718 67.4848 235.747 64.981 235.747C62.4771 235.747 60.4474 233.718 60.4474 231.214C60.4474 228.71 62.4771 226.68 64.981 226.68C67.4848 226.68 69.5145 228.71 69.5145 231.214ZM64.9808 547.05C67.4846 547.05 69.5144 545.021 69.5144 542.517C69.5144 540.013 67.4846 537.983 64.9808 537.983C62.477 537.983 60.4473 540.013 60.4473 542.517C60.4473 545.021 62.477 547.05 64.9808 547.05ZM367.217 542.517C367.217 545.021 365.188 547.05 362.684 547.05C360.18 547.05 358.15 545.021 358.15 542.517C358.15 540.013 360.18 537.983 362.684 537.983C365.188 537.983 367.217 540.013 367.217 542.517ZM362.684 667.945C365.188 667.945 367.218 665.916 367.218 663.412C367.218 660.908 365.188 658.878 362.684 658.878C360.18 658.878 358.15 660.908 358.15 663.412C358.15 665.916 360.18 667.945 362.684 667.945ZM78.5813 710.26C78.5813 712.764 76.5515 714.794 74.0477 714.794C71.5439 714.794 69.5142 712.764 69.5142 710.26C69.5142 707.756 71.5439 705.727 74.0477 705.727C76.5515 705.727 78.5813 707.756 78.5813 710.26ZM338.505 737.461C341.009 737.461 343.039 735.432 343.039 732.928C343.039 730.424 341.009 728.394 338.505 728.394C336.001 728.394 333.971 730.424 333.971 732.928C333.971 735.432 336.001 737.461 338.505 737.461ZM344.55 96.7196C344.55 99.2234 342.52 101.253 340.016 101.253C337.512 101.253 335.482 99.2234 335.482 96.7196C335.482 94.2158 337.512 92.186 340.016 92.186C342.52 92.186 344.55 94.2158 344.55 96.7196ZM4.53355 101.253C7.03736 101.253 9.0671 99.2233 9.0671 96.7195C9.0671 94.2157 7.03736 92.186 4.53355 92.186C2.02974 92.186 0 94.2157 0 96.7195C0 99.2233 2.02974 101.253 4.53355 101.253ZM231.211 96.7195C231.211 99.2233 229.181 101.253 226.678 101.253C224.174 101.253 222.144 99.2233 222.144 96.7195C222.144 94.2157 224.174 92.186 226.678 92.186C229.181 92.186 231.211 94.2157 231.211 96.7195ZM226.678 -9.06363C229.181 -9.06363 231.211 -11.0934 231.211 -13.5972C231.211 -16.101 229.181 -18.1307 226.678 -18.1307C224.174 -18.1307 222.144 -16.101 222.144 -13.5972C222.144 -11.0934 224.174 -9.06363 226.678 -9.06363ZM148.096 607.498C150.6 607.498 152.629 605.468 152.629 602.965C152.629 600.461 150.6 598.431 148.096 598.431C145.592 598.431 143.562 600.461 143.562 602.965C143.562 605.468 145.592 607.498 148.096 607.498ZM152.629 873.467C152.629 875.971 150.6 878.001 148.096 878.001C145.592 878.001 143.562 875.971 143.562 873.467C143.562 870.963 145.592 868.934 148.096 868.934C150.6 868.934 152.629 870.963 152.629 873.467ZM451.844 695.147C454.348 695.147 456.378 693.117 456.378 690.613C456.378 688.109 454.348 686.08 451.844 686.08C449.34 686.08 447.311 688.109 447.311 690.613C447.311 693.117 449.34 695.147 451.844 695.147ZM439.754 790.352C439.754 792.856 437.725 794.885 435.221 794.885C432.717 794.885 430.687 792.856 430.687 790.352C430.687 787.848 432.717 785.818 435.221 785.818C437.725 785.818 439.754 787.848 439.754 790.352ZM13.6007 837.198C16.1045 837.198 18.1343 835.168 18.1343 832.664C18.1343 830.16 16.1045 828.131 13.6007 828.131C11.0969 828.131 9.06717 830.16 9.06717 832.664C9.06717 835.168 11.0969 837.198 13.6007 837.198ZM18.1343 658.879C18.1343 661.383 16.1045 663.412 13.6007 663.412C11.0969 663.412 9.06717 661.383 9.06717 658.879C9.06717 656.375 11.0969 654.345 13.6007 654.345C16.1045 654.345 18.1343 656.375 18.1343 658.879ZM273.524 785.819C276.028 785.819 278.058 783.789 278.058 781.285C278.058 778.782 276.028 776.752 273.524 776.752C271.02 776.752 268.991 778.782 268.991 781.285C268.991 783.789 271.02 785.819 273.524 785.819ZM344.55 311.308C344.55 313.812 342.52 315.842 340.016 315.842C337.512 315.842 335.482 313.812 335.482 311.308C335.482 308.804 337.512 306.774 340.016 306.774C342.52 306.774 344.55 308.804 344.55 311.308ZM268.991 479.048C272.329 479.048 275.035 476.341 275.035 473.003C275.035 469.664 272.329 466.958 268.991 466.958C265.652 466.958 262.946 469.664 262.946 473.003C262.946 476.341 265.652 479.048 268.991 479.048ZM262.946 391.4C262.946 393.07 261.593 394.423 259.924 394.423C258.254 394.423 256.901 393.07 256.901 391.4C256.901 389.731 258.254 388.378 259.924 388.378C261.593 388.378 262.946 389.731 262.946 391.4ZM207.788 408.023C209.04 408.023 210.055 407.008 210.055 405.756C210.055 404.504 209.04 403.489 207.788 403.489C206.536 403.489 205.521 404.504 205.521 405.756C205.521 407.008 206.536 408.023 207.788 408.023ZM210.055 266.726C210.055 267.978 209.04 268.993 207.788 268.993C206.536 268.993 205.521 267.978 205.521 266.726C205.521 265.474 206.536 264.46 207.788 264.46C209.04 264.46 210.055 265.474 210.055 266.726ZM449.577 268.993C450.829 268.993 451.844 267.978 451.844 266.726C451.844 265.474 450.829 264.459 449.577 264.459C448.325 264.459 447.311 265.474 447.311 266.726C447.311 267.978 448.325 268.993 449.577 268.993ZM451.844 129.209C451.844 130.461 450.829 131.475 449.577 131.475C448.325 131.475 447.311 130.461 447.311 129.209C447.311 127.957 448.325 126.942 449.577 126.942C450.829 126.942 451.844 127.957 451.844 129.209ZM449.577 18.1371C450.829 18.1371 451.844 17.1222 451.844 15.8703C451.844 14.6184 450.829 13.6035 449.577 13.6035C448.325 13.6035 447.311 14.6184 447.311 15.8703C447.311 17.1222 448.325 18.1371 449.577 18.1371ZM196.454 15.8704C196.454 17.1223 195.439 18.1372 194.187 18.1372C192.935 18.1372 191.92 17.1223 191.92 15.8704C191.92 14.6185 192.935 13.6037 194.187 13.6037C195.439 13.6037 196.454 14.6185 196.454 15.8704ZM306.77 -65.7332C306.77 -64.4813 305.755 -63.4665 304.504 -63.4665C303.252 -63.4665 302.237 -64.4813 302.237 -65.7332C302.237 -66.9851 303.252 -68 304.504 -68C305.755 -68 306.77 -66.9851 306.77 -65.7332ZM304.504 211.569C305.755 211.569 306.77 210.554 306.77 209.303C306.77 208.051 305.755 207.036 304.504 207.036C303.252 207.036 302.237 208.051 302.237 209.303C302.237 210.554 303.252 211.569 304.504 211.569ZM247.834 531.184C247.834 532.436 246.819 533.451 245.567 533.451C244.315 533.451 243.301 532.436 243.301 531.184C243.301 529.932 244.315 528.917 245.567 528.917C246.819 528.917 247.834 529.932 247.834 531.184ZM245.567 849.287C246.819 849.287 247.834 848.273 247.834 847.021C247.834 845.769 246.819 844.754 245.567 844.754C244.315 844.754 243.301 845.769 243.301 847.021C243.301 848.273 244.315 849.287 245.567 849.287ZM480.556 847.021C480.556 848.273 479.541 849.287 478.29 849.287C477.038 849.287 476.023 848.273 476.023 847.021C476.023 845.769 477.038 844.754 478.29 844.754C479.541 844.754 480.556 845.769 480.556 847.021ZM67.2476 849.287C68.4995 849.287 69.5144 848.273 69.5144 847.021C69.5144 845.769 68.4995 844.754 67.2476 844.754C65.9957 844.754 64.9809 845.769 64.9809 847.021C64.9809 848.273 65.9957 849.287 67.2476 849.287ZM69.5144 615.811C69.5144 617.063 68.4995 618.078 67.2476 618.078C65.9957 618.078 64.9809 617.063 64.9809 615.811C64.9809 614.559 65.9957 613.545 67.2476 613.545C68.4995 613.545 69.5144 614.559 69.5144 615.811ZM67.2476 432.203C68.4995 432.203 69.5144 431.188 69.5144 429.936C69.5144 428.684 68.4995 427.669 67.2476 427.669C65.9957 427.669 64.9809 428.684 64.9809 429.936C64.9809 431.188 65.9957 432.203 67.2476 432.203ZM417.087 466.203C417.087 467.455 416.072 468.47 414.82 468.47C413.568 468.47 412.553 467.455 412.553 466.203C412.553 464.952 413.568 463.937 414.82 463.937C416.072 463.937 417.087 464.952 417.087 466.203ZM417.842 306.772C419.094 306.772 420.109 305.758 420.109 304.506C420.109 303.254 419.094 302.239 417.842 302.239C416.59 302.239 415.575 303.254 415.575 304.506C415.575 305.758 416.59 306.772 417.842 306.772ZM420.109 11.3373C420.109 12.5892 419.094 13.604 417.842 13.604C416.59 13.604 415.575 12.5892 415.575 11.3373C415.575 10.0854 416.59 9.0705 417.842 9.0705C419.094 9.0705 420.109 10.0854 420.109 11.3373ZM321.882 380.822C324.386 380.822 326.415 378.792 326.415 376.288C326.415 373.785 324.386 371.755 321.882 371.755C319.378 371.755 317.348 373.785 317.348 376.288C317.348 378.792 319.378 380.822 321.882 380.822ZM476.023 394.421C476.023 396.925 473.993 398.955 471.489 398.955C468.985 398.955 466.956 396.925 466.956 394.421C466.956 391.917 468.985 389.888 471.489 389.888C473.993 389.888 476.023 391.917 476.023 394.421ZM45.3354 398.955C47.8392 398.955 49.8689 396.925 49.8689 394.421C49.8689 391.917 47.8392 389.888 45.3354 389.888C42.8316 389.888 40.8018 391.917 40.8018 394.421C40.8018 396.925 42.8316 398.955 45.3354 398.955Z"
                fill="white"
                fillOpacity={0.5}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M933.155 873.467C931.903 873.467 930.889 874.482 930.889 875.734C930.889 876.986 931.903 878.001 933.155 878.001C934.407 878.001 935.422 876.986 935.422 875.734C935.422 874.482 934.407 873.467 933.155 873.467ZM1006.45 871.956C1006.45 869.452 1008.48 867.422 1010.98 867.422C1013.48 867.422 1015.51 869.452 1015.51 871.956C1015.51 874.459 1013.48 876.489 1010.98 876.489C1008.48 876.489 1006.45 874.459 1006.45 871.956ZM595.406 814.531C587.06 814.531 580.294 821.297 580.294 829.643C580.294 837.989 587.06 844.755 595.406 844.755C603.752 844.755 610.518 837.989 610.518 829.643C610.518 821.297 603.752 814.531 595.406 814.531ZM663.409 630.166C663.409 621.82 670.175 615.054 678.521 615.054C686.867 615.054 693.633 621.82 693.633 630.166C693.633 638.512 686.867 645.278 678.521 645.278C670.175 645.278 663.409 638.512 663.409 630.166ZM1026.09 479.048C1019.42 479.048 1014 484.46 1014 491.137C1014 497.814 1019.42 503.227 1026.09 503.227C1032.77 503.227 1038.18 497.814 1038.18 491.137C1038.18 484.46 1032.77 479.048 1026.09 479.048ZM947.511 356.643C940.835 356.643 935.422 362.056 935.422 368.733C935.422 375.41 940.835 380.822 947.511 380.822C954.188 380.822 959.601 375.41 959.601 368.733C959.601 362.056 954.188 356.643 947.511 356.643ZM537.981 341.531C537.981 336.523 542.041 332.463 547.048 332.463C552.056 332.463 556.115 336.523 556.115 341.531C556.115 346.538 552.056 350.598 547.048 350.598C542.041 350.598 537.981 346.538 537.981 341.531ZM575.76 200.99C572.422 200.99 569.716 203.696 569.716 207.035C569.716 210.373 572.422 213.08 575.76 213.08C579.099 213.08 581.805 210.373 581.805 207.035C581.805 203.696 579.099 200.99 575.76 200.99ZM862.885 229.703C862.885 223.026 868.298 217.614 874.975 217.614C881.651 217.614 887.064 223.026 887.064 229.703C887.064 236.38 881.651 241.793 874.975 241.793C868.298 241.793 862.885 236.38 862.885 229.703ZM891.598 9.07043C883.252 9.07043 876.486 15.8362 876.486 24.1823C876.486 32.5283 883.252 39.2941 891.598 39.2941C899.944 39.2941 906.71 32.5283 906.71 24.1823C906.71 15.8362 899.944 9.07043 891.598 9.07043ZM868.93 343.043C868.93 337.201 873.666 332.464 879.508 332.464C885.351 332.464 890.087 337.201 890.087 343.043C890.087 348.885 885.351 353.621 879.508 353.621C873.666 353.621 868.93 348.885 868.93 343.043ZM569.716 448.825C561.37 448.825 554.604 455.591 554.604 463.937C554.604 472.283 561.37 479.049 569.716 479.049C578.062 479.049 584.828 472.283 584.828 463.937C584.828 455.591 578.062 448.825 569.716 448.825ZM988.313 776.752C988.313 768.406 995.079 761.64 1003.43 761.64C1011.77 761.64 1018.54 768.406 1018.54 776.752C1018.54 785.098 1011.77 791.864 1003.43 791.864C995.079 791.864 988.313 785.098 988.313 776.752ZM950.534 536.474C942.188 536.474 935.422 543.24 935.422 551.586C935.422 559.932 942.188 566.698 950.534 566.698C958.88 566.698 965.646 559.932 965.646 551.586C965.646 543.24 958.88 536.474 950.534 536.474ZM825.105 630.166C825.105 621.82 831.871 615.054 840.217 615.054C848.563 615.054 855.329 621.82 855.329 630.166C855.329 638.512 848.563 645.278 840.217 645.278C831.871 645.278 825.105 638.512 825.105 630.166ZM687.588 -46.8438C679.242 -46.8438 672.477 -40.078 672.477 -31.7319C672.477 -23.3859 679.242 -16.6201 687.588 -16.6201C695.934 -16.6201 702.7 -23.3859 702.7 -31.7319C702.7 -40.078 695.934 -46.8438 687.588 -46.8438ZM642.253 178.323C642.253 169.977 649.018 163.211 657.364 163.211C665.71 163.211 672.476 169.977 672.476 178.323C672.476 186.669 665.71 193.435 657.364 193.435C649.018 193.435 642.253 186.669 642.253 178.323ZM1010.98 302.241C1002.64 302.241 995.87 309.007 995.87 317.353C995.87 325.699 1002.64 332.465 1010.98 332.465C1019.33 332.465 1026.09 325.699 1026.09 317.353C1026.09 309.007 1019.33 302.241 1010.98 302.241ZM879.508 683.057C879.508 676.381 884.921 670.968 891.598 670.968C898.275 670.968 903.687 676.381 903.687 683.057C903.687 689.734 898.275 695.147 891.598 695.147C884.921 695.147 879.508 689.734 879.508 683.057ZM1018.54 631.679C1011.86 631.679 1006.45 637.092 1006.45 643.769C1006.45 650.445 1011.86 655.858 1018.54 655.858C1025.21 655.858 1030.63 650.445 1030.63 643.769C1030.63 637.092 1025.21 631.679 1018.54 631.679ZM829.639 492.65C829.639 487.642 833.699 483.583 838.706 483.583C843.714 483.583 847.773 487.642 847.773 492.65C847.773 497.657 843.714 501.717 838.706 501.717C833.699 501.717 829.639 497.657 829.639 492.65ZM843.24 128.454C837.398 128.454 832.662 133.19 832.662 139.032C832.662 144.875 837.398 149.611 843.24 149.611C849.082 149.611 853.818 144.875 853.818 139.032C853.818 133.19 849.082 128.454 843.24 128.454ZM625.629 262.951C625.629 257.943 629.689 253.883 634.697 253.883C639.704 253.883 643.764 257.943 643.764 262.951C643.764 267.958 639.704 272.018 634.697 272.018C629.689 272.018 625.629 267.958 625.629 262.951ZM634.697 602.966C629.689 602.966 625.63 607.025 625.63 612.033C625.63 617.041 629.689 621.1 634.697 621.1C639.704 621.1 643.764 617.041 643.764 612.033C643.764 607.025 639.704 602.966 634.697 602.966ZM950.534 757.105C950.534 752.098 954.594 748.038 959.601 748.038C964.609 748.038 968.668 752.098 968.668 757.105C968.668 762.113 964.609 766.173 959.601 766.173C954.594 766.173 950.534 762.113 950.534 757.105ZM711.767 748.038C706.759 748.038 702.7 752.098 702.7 757.105C702.7 762.113 706.759 766.173 711.767 766.173C716.775 766.173 720.834 762.113 720.834 757.105C720.834 752.098 716.775 748.038 711.767 748.038ZM680.032 344.554C680.032 339.546 684.092 335.487 689.099 335.487C694.107 335.487 698.166 339.546 698.166 344.554C698.166 349.562 694.107 353.621 689.099 353.621C684.092 353.621 680.032 349.562 680.032 344.554ZM941.467 120.898C936.459 120.898 932.4 124.958 932.4 129.966C932.4 134.973 936.459 139.033 941.467 139.033C946.474 139.033 950.534 134.973 950.534 129.966C950.534 124.958 946.474 120.898 941.467 120.898ZM525.892 90.6741C525.892 85.6665 529.951 81.607 534.959 81.607C539.966 81.607 544.026 85.6665 544.026 90.6741C544.026 95.6818 539.966 99.7412 534.959 99.7412C529.951 99.7412 525.892 95.6818 525.892 90.6741ZM758.614 474.515C756.11 474.515 754.08 476.545 754.08 479.049C754.08 481.552 756.11 483.582 758.614 483.582C761.118 483.582 763.147 481.552 763.147 479.049C763.147 476.545 761.118 474.515 758.614 474.515ZM643.764 541.008C643.764 538.504 645.794 536.474 648.297 536.474C650.801 536.474 652.831 538.504 652.831 541.008C652.831 543.512 650.801 545.541 648.297 545.541C645.794 545.541 643.764 543.512 643.764 541.008ZM648.297 406.511C645.794 406.511 643.764 408.541 643.764 411.044C643.764 413.548 645.794 415.578 648.297 415.578C650.801 415.578 652.831 413.548 652.831 411.044C652.831 408.541 650.801 406.511 648.297 406.511ZM643.764 670.969C643.764 668.465 645.794 666.435 648.297 666.435C650.801 666.435 652.831 668.465 652.831 670.969C652.831 673.473 650.801 675.503 648.297 675.503C645.794 675.503 643.764 673.473 643.764 670.969ZM899.154 621.099C896.65 621.099 894.62 623.129 894.62 625.633C894.62 628.137 896.65 630.166 899.154 630.166C901.657 630.166 903.687 628.137 903.687 625.633C903.687 623.129 901.657 621.099 899.154 621.099ZM894.62 766.174C894.62 763.671 896.65 761.641 899.154 761.641C901.657 761.641 903.687 763.671 903.687 766.174C903.687 768.678 901.657 770.708 899.154 770.708C896.65 770.708 894.62 768.678 894.62 766.174ZM580.294 761.641C577.79 761.641 575.76 763.671 575.76 766.174C575.76 768.678 577.79 770.708 580.294 770.708C582.798 770.708 584.828 768.678 584.828 766.174C584.828 763.671 582.798 761.641 580.294 761.641ZM707.233 819.065C707.233 816.561 709.263 814.531 711.767 814.531C714.271 814.531 716.301 816.561 716.301 819.065C716.301 821.569 714.271 823.599 711.767 823.599C709.263 823.599 707.233 821.569 707.233 819.065ZM711.767 574.254C709.263 574.254 707.233 576.283 707.233 578.787C707.233 581.291 709.263 583.321 711.767 583.321C714.271 583.321 716.301 581.291 716.301 578.787C716.301 576.283 714.271 574.254 711.767 574.254ZM982.269 578.787C982.269 576.283 984.298 574.254 986.802 574.254C989.306 574.254 991.336 576.283 991.336 578.787C991.336 581.291 989.306 583.321 986.802 583.321C984.298 583.321 982.269 581.291 982.269 578.787ZM986.802 262.951C984.299 262.951 982.269 264.98 982.269 267.484C982.269 269.988 984.299 272.018 986.802 272.018C989.306 272.018 991.336 269.988 991.336 267.484C991.336 264.98 989.306 262.951 986.802 262.951ZM684.566 267.484C684.566 264.98 686.595 262.951 689.099 262.951C691.603 262.951 693.633 264.98 693.633 267.484C693.633 269.988 691.603 272.018 689.099 272.018C686.595 272.018 684.566 269.988 684.566 267.484ZM689.099 142.055C686.595 142.055 684.566 144.085 684.566 146.589C684.566 149.093 686.595 151.123 689.099 151.123C691.603 151.123 693.633 149.093 693.633 146.589C693.633 144.085 691.603 142.055 689.099 142.055ZM973.202 99.7408C973.202 97.2371 975.232 95.2073 977.735 95.2073C980.239 95.2073 982.269 97.2371 982.269 99.7408C982.269 102.245 980.239 104.274 977.735 104.274C975.232 104.274 973.202 102.245 973.202 99.7408ZM713.278 72.5395C710.774 72.5395 708.745 74.5692 708.745 77.073C708.745 79.5768 710.774 81.6066 713.278 81.6066C715.782 81.6066 717.812 79.5768 717.812 77.073C717.812 74.5692 715.782 72.5395 713.278 72.5395ZM707.233 713.281C707.233 710.778 709.263 708.748 711.767 708.748C714.271 708.748 716.301 710.778 716.301 713.281C716.301 715.785 714.271 717.815 711.767 717.815C709.263 717.815 707.233 715.785 707.233 713.281ZM1047.25 708.748C1044.75 708.748 1042.72 710.778 1042.72 713.281C1042.72 715.785 1044.75 717.815 1047.25 717.815C1049.75 717.815 1051.78 715.785 1051.78 713.281C1051.78 710.778 1049.75 708.748 1047.25 708.748ZM820.572 713.281C820.572 710.778 822.602 708.748 825.106 708.748C827.609 708.748 829.639 710.778 829.639 713.281C829.639 715.785 827.609 717.815 825.106 717.815C822.602 717.815 820.572 715.785 820.572 713.281ZM825.106 819.065C822.602 819.065 820.572 821.094 820.572 823.598C820.572 826.102 822.602 828.132 825.106 828.132C827.609 828.132 829.639 826.102 829.639 823.598C829.639 821.094 827.609 819.065 825.106 819.065ZM903.687 202.503C901.184 202.503 899.154 204.533 899.154 207.036C899.154 209.54 901.184 211.57 903.687 211.57C906.191 211.57 908.221 209.54 908.221 207.036C908.221 204.533 906.191 202.503 903.687 202.503ZM899.154 -63.4662C899.154 -65.97 901.184 -67.9998 903.687 -67.9998C906.191 -67.9998 908.221 -65.97 908.221 -63.4662C908.221 -60.9624 906.191 -58.9327 903.687 -58.9327C901.184 -58.9327 899.154 -60.9624 899.154 -63.4662ZM599.939 114.854C597.435 114.854 595.406 116.884 595.406 119.388C595.406 121.892 597.435 123.921 599.939 123.921C602.443 123.921 604.473 121.892 604.473 119.388C604.473 116.884 602.443 114.854 599.939 114.854ZM612.029 19.6492C612.029 17.1454 614.059 15.1157 616.562 15.1157C619.066 15.1157 621.096 17.1454 621.096 19.6492C621.096 22.153 619.066 24.1827 616.562 24.1827C614.059 24.1827 612.029 22.153 612.029 19.6492ZM1038.18 -27.1968C1035.68 -27.1968 1033.65 -25.1671 1033.65 -22.6633C1033.65 -20.1595 1035.68 -18.1298 1038.18 -18.1298C1040.69 -18.1298 1042.72 -20.1595 1042.72 -22.6633C1042.72 -25.1671 1040.69 -27.1968 1038.18 -27.1968ZM1033.65 151.122C1033.65 148.618 1035.68 146.589 1038.18 146.589C1040.69 146.589 1042.72 148.618 1042.72 151.122C1042.72 153.626 1040.69 155.656 1038.18 155.656C1035.68 155.656 1033.65 153.626 1033.65 151.122ZM778.259 24.182C775.755 24.182 773.726 26.2117 773.726 28.7155C773.726 31.2194 775.755 33.2491 778.259 33.2491C780.763 33.2491 782.793 31.2194 782.793 28.7155C782.793 26.2117 780.763 24.182 778.259 24.182ZM707.233 498.693C707.233 496.189 709.263 494.16 711.767 494.16C714.271 494.16 716.301 496.189 716.301 498.693C716.301 501.197 714.271 503.227 711.767 503.227C709.263 503.227 707.233 501.197 707.233 498.693ZM782.793 330.953C779.454 330.953 776.748 333.66 776.748 336.998C776.748 340.337 779.454 343.043 782.793 343.043C786.131 343.043 788.837 340.337 788.837 336.998C788.837 333.66 786.131 330.953 782.793 330.953ZM788.838 418.601C788.838 416.931 790.191 415.578 791.86 415.578C793.529 415.578 794.882 416.931 794.882 418.601C794.882 420.27 793.529 421.623 791.86 421.623C790.191 421.623 788.838 420.27 788.838 418.601ZM843.995 401.978C842.744 401.978 841.729 402.993 841.729 404.245C841.729 405.497 842.744 406.512 843.995 406.512C845.247 406.512 846.262 405.497 846.262 404.245C846.262 402.993 845.247 401.978 843.995 401.978ZM841.729 543.275C841.729 542.023 842.744 541.008 843.995 541.008C845.247 541.008 846.262 542.023 846.262 543.275C846.262 544.526 845.247 545.541 843.995 545.541C842.744 545.541 841.729 544.526 841.729 543.275ZM602.206 541.008C600.954 541.008 599.939 542.023 599.939 543.275C599.939 544.527 600.954 545.542 602.206 545.542C603.458 545.542 604.473 544.527 604.473 543.275C604.473 542.023 603.458 541.008 602.206 541.008ZM599.939 680.792C599.939 679.54 600.954 678.526 602.206 678.526C603.458 678.526 604.473 679.54 604.473 680.792C604.473 682.044 603.458 683.059 602.206 683.059C600.954 683.059 599.939 682.044 599.939 680.792ZM602.206 791.864C600.954 791.864 599.939 792.879 599.939 794.131C599.939 795.383 600.954 796.397 602.206 796.397C603.458 796.397 604.473 795.383 604.473 794.131C604.473 792.879 603.458 791.864 602.206 791.864ZM855.329 794.131C855.329 792.879 856.344 791.864 857.596 791.864C858.848 791.864 859.863 792.879 859.863 794.131C859.863 795.382 858.848 796.397 857.596 796.397C856.344 796.397 855.329 795.382 855.329 794.131ZM745.013 875.734C745.013 874.482 746.028 873.467 747.28 873.467C748.532 873.467 749.546 874.482 749.546 875.734C749.546 876.986 748.532 878.001 747.28 878.001C746.028 878.001 745.013 876.986 745.013 875.734ZM747.28 598.432C746.028 598.432 745.013 599.447 745.013 600.698C745.013 601.95 746.028 602.965 747.28 602.965C748.532 602.965 749.546 601.95 749.546 600.698C749.546 599.447 748.532 598.432 747.28 598.432ZM803.949 278.817C803.949 277.565 804.964 276.55 806.216 276.55C807.468 276.55 808.483 277.565 808.483 278.817C808.483 280.069 807.468 281.084 806.216 281.084C804.964 281.084 803.949 280.069 803.949 278.817ZM806.216 -39.2864C804.964 -39.2864 803.949 -38.2715 803.949 -37.0197C803.949 -35.7678 804.964 -34.7529 806.216 -34.7529C807.468 -34.7529 808.483 -35.7678 808.483 -37.0197C808.483 -38.2715 807.468 -39.2864 806.216 -39.2864ZM571.227 -37.0197C571.227 -38.2715 572.242 -39.2864 573.494 -39.2864C574.746 -39.2864 575.76 -38.2715 575.76 -37.0197C575.76 -35.7678 574.746 -34.7529 573.494 -34.7529C572.242 -34.7529 571.227 -35.7678 571.227 -37.0197ZM984.535 -39.2864C983.283 -39.2864 982.269 -38.2715 982.269 -37.0197C982.269 -35.7678 983.283 -34.7529 984.535 -34.7529C985.787 -34.7529 986.802 -35.7678 986.802 -37.0197C986.802 -38.2715 985.787 -39.2864 984.535 -39.2864ZM982.269 194.19C982.269 192.938 983.283 191.923 984.535 191.923C985.787 191.923 986.802 192.938 986.802 194.19C986.802 195.442 985.787 196.456 984.535 196.456C983.283 196.456 982.269 195.442 982.269 194.19ZM984.535 377.798C983.283 377.798 982.269 378.813 982.269 380.065C982.269 381.317 983.283 382.332 984.535 382.332C985.787 382.332 986.802 381.317 986.802 380.065C986.802 378.813 985.787 377.798 984.535 377.798ZM634.697 343.797C634.697 342.546 635.711 341.531 636.963 341.531C638.215 341.531 639.23 342.546 639.23 343.797C639.23 345.049 638.215 346.064 636.963 346.064C635.711 346.064 634.697 345.049 634.697 343.797ZM633.941 503.228C632.689 503.228 631.674 504.243 631.674 505.495C631.674 506.747 632.689 507.762 633.941 507.762C635.193 507.762 636.208 506.747 636.208 505.495C636.208 504.243 635.193 503.228 633.941 503.228ZM631.674 798.664C631.674 797.412 632.689 796.397 633.941 796.397C635.193 796.397 636.208 797.412 636.208 798.664C636.208 799.916 635.193 800.93 633.941 800.93C632.689 800.93 631.674 799.916 631.674 798.664ZM729.901 429.179C727.398 429.179 725.368 431.209 725.368 433.713C725.368 436.216 727.398 438.246 729.901 438.246C732.405 438.246 734.435 436.216 734.435 433.713C734.435 431.209 732.405 429.179 729.901 429.179ZM575.76 415.58C575.76 413.076 577.79 411.046 580.294 411.046C582.798 411.046 584.828 413.076 584.828 415.58C584.828 418.084 582.798 420.113 580.294 420.113C577.79 420.113 575.76 418.084 575.76 415.58ZM1006.45 411.046C1003.94 411.046 1001.91 413.076 1001.91 415.58C1001.91 418.084 1003.94 420.113 1006.45 420.113C1008.95 420.113 1010.98 418.084 1010.98 415.58C1010.98 413.076 1008.95 411.046 1006.45 411.046Z"
                fill="white"
                fillOpacity={0.5}
            />
            <path
                opacity={0.4}
                fillRule="evenodd"
                clipRule="evenodd"
                d="M198.556 157.676C199.381 167.567 206.326 177.319 219.392 184.872L350.477 260.656C378.368 276.78 423.589 276.78 451.48 260.656L582.565 184.872C595.631 177.319 602.576 167.567 603.4 157.676C604.336 168.899 597.391 180.301 582.565 188.872L451.48 264.656C423.589 280.78 378.368 280.78 350.477 264.656L219.392 188.872C204.566 180.301 197.621 168.899 198.556 157.676Z"
                fill="#F5F4F2"
            />
            <path
                opacity={0.6}
                d="M219.392 184.872C191.5 168.747 191.5 142.604 219.392 126.48L350.477 50.696C378.368 34.5714 423.589 34.5714 451.48 50.6961L582.565 126.48C610.456 142.604 610.456 168.747 582.565 184.872L451.48 260.656C423.589 276.78 378.368 276.78 350.477 260.656L219.392 184.872Z"
                fill="white"
            />
            <mask
                id="ff5a980b__mask0_27804_5736"
                style={{
                    maskType: 'alpha',
                }}
                maskUnits="userSpaceOnUse"
                x={198}
                y={-23}
                width={406}
                height={296}
            >
                <path
                    d="M218.919 185.024C191.027 168.899 191.027 142.756 218.919 126.631L301.631 -10.9065C329.522 -27.0312 462.245 -27.0312 490.137 -10.9065L582.092 126.631C609.983 142.756 609.983 168.899 582.092 185.024L451.007 260.807C423.116 276.932 377.895 276.932 350.003 260.807L218.919 185.024Z"
                    fill="#48CCE0"
                />
            </mask>
            <g mask="url(#ff5a980b__mask0_27804_5736)">
                <rect
                    x={303}
                    y={39}
                    width={176}
                    height={229}
                    rx={21}
                    stroke="white"
                    strokeWidth={10}
                />
                <rect
                    x={307.599}
                    y={43.1875}
                    width={167.746}
                    height={360.061}
                    rx={17.7863}
                    fill="#F5F4F2"
                />
            </g>
            <mask
                id="ff5a980b__mask1_27804_5736"
                style={{
                    maskType: 'alpha',
                }}
                maskUnits="userSpaceOnUse"
                x={307}
                y={43}
                width={167}
                height={230}
            >
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M473.746 246.798L450.101 260.468C422.21 276.593 376.989 276.593 349.098 260.468L307 236.131V60.9327C307 51.1096 314.963 43.1465 324.786 43.1465H341.683L342.08 43.2426C342.919 43.4462 343.61 44.0741 343.908 44.8806C343.923 44.9204 343.927 44.9632 343.927 45.0056L343.924 46.6864C343.924 52.352 348.503 56.9308 354.151 56.9308H426.595C432.244 56.9308 436.822 52.352 436.822 46.7037L436.82 45.0055C436.819 44.9627 436.826 44.9209 436.841 44.8806C437.137 44.0683 437.823 43.4471 438.666 43.2426L439.063 43.1465H455.96C465.783 43.1465 473.746 51.1097 473.746 60.9327V246.798Z"
                    fill="#48CCE0"
                />
            </mask>
            <g mask="url(#ff5a980b__mask1_27804_5736)">
                <rect
                    opacity={0.7}
                    width={126.325}
                    height={126.325}
                    rx={20}
                    transform="matrix(1 0 0 -1 341.32 328.949)"
                    fill="white"
                />
                <rect
                    opacity={0.7}
                    width={126.325}
                    height={126.325}
                    rx={20}
                    transform="matrix(1 0 0 -1 206.233 328.949)"
                    fill="white"
                />
                <rect
                    opacity={0.7}
                    width={126.325}
                    height={126.325}
                    rx={20}
                    transform="matrix(1 0 0 -1 206.233 192.639)"
                    fill="white"
                />
                <g filter="url(#ff5a980b__filter1_d_27804_5736)">
                    <rect
                        x={322}
                        y={190}
                        width={56}
                        height={24}
                        rx={12}
                        fill="white"
                    />
                    <mask
                        id="ff5a980b__mask2_27804_5736"
                        style={{
                            maskType: 'alpha',
                        }}
                        maskUnits="userSpaceOnUse"
                        x={327}
                        y={193}
                        width={45}
                        height={19}
                    >
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M335.203 206.295L336.167 201.697L340.087 201.697C340.103 201.872 340.11 202.049 340.11 202.227C340.11 205.586 337.388 208.308 334.029 208.308C330.671 208.308 327.948 205.586 327.948 202.227C327.948 198.869 330.671 196.146 334.029 196.146C334.537 196.146 335.029 196.209 335.5 196.326L334.7 200.165L330.322 200.165L329.993 201.697L334.371 201.697L333.386 206.295L335.203 206.295ZM337.173 197.021L336.517 200.165L339.752 200.165C339.276 198.845 338.356 197.737 337.173 197.021Z"
                            fill="url(#ff5a980b__paint2_linear_27804_5736)"
                        />
                        <path
                            d="M352.67 203.158C352.67 203.748 352.564 204.291 352.353 204.787C352.143 205.271 351.842 205.693 351.452 206.051C351.062 206.399 350.598 206.673 350.061 206.874C349.523 207.063 348.928 207.158 348.274 207.158C347.515 207.158 346.888 207.074 346.393 206.905C345.908 206.736 345.486 206.547 345.128 206.336L345.128 204.391C345.497 204.634 345.924 204.866 346.409 205.087C346.904 205.298 347.478 205.403 348.132 205.403C348.87 205.403 349.428 205.198 349.808 204.787C350.198 204.375 350.393 203.864 350.393 203.253C350.393 202.642 350.24 202.157 349.934 201.798C349.639 201.44 349.175 201.261 348.543 201.261C348.153 201.261 347.832 201.324 347.579 201.45C347.326 201.577 347.136 201.719 347.009 201.877L345.349 201.877L345.349 195.664L352.132 195.664L352.132 197.498L347.294 197.498L347.294 200.075C347.473 199.938 347.71 199.817 348.005 199.711C348.301 199.595 348.685 199.537 349.16 199.537C350.245 199.537 351.099 199.859 351.721 200.502C352.353 201.134 352.67 202.02 352.67 203.158ZM361.13 207L353.636 207L353.636 204.913C354.595 204.196 355.407 203.564 356.071 203.016C356.746 202.468 357.288 201.967 357.699 201.514C358.111 201.06 358.406 200.639 358.585 200.249C358.775 199.848 358.869 199.432 358.869 199C358.869 198.473 358.711 198.062 358.395 197.767C358.089 197.461 357.652 197.308 357.083 197.308C356.514 197.308 355.966 197.429 355.439 197.672C354.912 197.914 354.416 198.236 353.952 198.636L353.952 196.644C354.395 196.307 354.885 196.038 355.423 195.838C355.96 195.627 356.614 195.521 357.383 195.521C357.952 195.521 358.469 195.601 358.933 195.759C359.396 195.906 359.792 196.128 360.118 196.423C360.456 196.718 360.714 197.081 360.893 197.514C361.083 197.935 361.178 198.415 361.178 198.952C361.178 199.501 361.067 200.017 360.846 200.502C360.624 200.987 360.292 201.472 359.85 201.956C359.418 202.441 358.875 202.947 358.221 203.474C357.578 203.991 356.825 204.56 355.96 205.182L361.13 205.182L361.13 207ZM367.103 207.158C366.439 207.158 365.817 207.037 365.237 206.794C364.668 206.541 364.167 206.173 363.735 205.688C363.314 205.192 362.982 204.581 362.739 203.854C362.497 203.126 362.376 202.283 362.376 201.324C362.376 200.365 362.497 199.527 362.739 198.81C362.982 198.083 363.314 197.477 363.735 196.992C364.167 196.507 364.668 196.143 365.237 195.901C365.817 195.648 366.439 195.521 367.103 195.521C367.767 195.521 368.389 195.643 368.969 195.885C369.548 196.128 370.049 196.491 370.471 196.976C370.892 197.461 371.224 198.067 371.467 198.794C371.709 199.511 371.83 200.344 371.83 201.292C371.83 202.241 371.709 203.079 371.467 203.806C371.224 204.534 370.892 205.15 370.471 205.656C370.049 206.151 369.548 206.526 368.969 206.779C368.389 207.032 367.767 207.158 367.103 207.158ZM367.087 205.403C367.446 205.403 367.778 205.329 368.083 205.182C368.389 205.034 368.652 204.802 368.874 204.486C369.095 204.159 369.269 203.738 369.395 203.221C369.522 202.705 369.585 202.078 369.585 201.34C369.585 200.602 369.522 199.975 369.395 199.458C369.269 198.931 369.095 198.51 368.874 198.193C368.652 197.867 368.389 197.63 368.083 197.482C367.778 197.334 367.451 197.261 367.103 197.261C366.755 197.261 366.428 197.334 366.123 197.482C365.828 197.63 365.569 197.867 365.348 198.193C365.127 198.51 364.953 198.931 364.826 199.458C364.7 199.975 364.636 200.602 364.636 201.34C364.636 202.078 364.7 202.705 364.826 203.221C364.953 203.738 365.127 204.159 365.348 204.486C365.569 204.802 365.828 205.034 366.123 205.182C366.418 205.329 366.739 205.403 367.087 205.403Z"
                            fill="url(#ff5a980b__paint3_linear_27804_5736)"
                        />
                    </mask>
                    <g mask="url(#ff5a980b__mask2_27804_5736)">
                        <rect
                            x={321}
                            y={193}
                            width={51}
                            height={21}
                            fill="url(#ff5a980b__paint4_linear_27804_5736)"
                        />
                    </g>
                </g>
                <g clipPath="url(#ff5a980b__clip1_27804_5736)">
                    <g clipPath="url(#ff5a980b__clip2_27804_5736)">
                        <rect
                            width={126.325}
                            height={126.325}
                            transform="matrix(1 0 0 -1 341.32 193.949)"
                            fill="url(#ff5a980b__paint5_radial_27804_5736)"
                        />
                        <rect
                            width={126.325}
                            height={126.325}
                            transform="matrix(1 0 0 -1 341.32 193.949)"
                            fill="url(#ff5a980b__paint6_radial_27804_5736)"
                        />
                        <rect
                            width={126.325}
                            height={126.325}
                            transform="matrix(1 0 0 -1 341.32 193.949)"
                            fill="white"
                            fillOpacity={0.2}
                        />
                        <rect
                            x={382.32}
                            y={114.625}
                            width={86}
                            height={80}
                            fill="url(#ff5a980b__pattern0)"
                        />
                    </g>
                </g>
                <path
                    d="M361.868 86.5592V95.9873H359.609V86.5592H356.214V84.6641H365.263V86.5592H361.868ZM370.636 95.8925C370.457 96.3874 370.267 96.8243 370.067 97.2033C369.867 97.5823 369.63 97.8982 369.357 98.1509C369.093 98.4141 368.778 98.6089 368.409 98.7352C368.041 98.8721 367.598 98.9405 367.082 98.9405C366.767 98.9405 366.488 98.9142 366.245 98.8615C366.003 98.8194 365.766 98.7457 365.535 98.6404V96.7453C365.714 96.8717 365.93 96.9717 366.182 97.0454C366.446 97.1296 366.73 97.1717 367.035 97.1717C367.372 97.1717 367.646 97.1086 367.856 96.9822C368.067 96.8664 368.246 96.6874 368.393 96.4453L365.124 87.791H367.446L369.499 93.7132L371.504 87.791H373.51L370.636 95.8925ZM379.49 96.1452C378.88 96.1452 378.353 96.0136 377.911 95.7504C377.48 95.4767 377.127 95.1135 376.853 94.6607V98.7826H374.674V87.791H376.711L376.822 89.1334C377.095 88.6596 377.453 88.2911 377.895 88.0279C378.338 87.7647 378.875 87.6331 379.506 87.6331C379.991 87.6331 380.449 87.7226 380.88 87.9016C381.322 88.07 381.707 88.3332 382.033 88.6912C382.37 89.0386 382.633 89.4808 382.823 90.0177C383.012 90.5442 383.107 91.1653 383.107 91.8813C383.107 92.6077 383.007 93.2394 382.807 93.7764C382.617 94.3028 382.359 94.745 382.033 95.1029C381.707 95.4504 381.322 95.7136 380.88 95.8925C380.438 96.061 379.975 96.1452 379.49 96.1452ZM378.875 94.3923C379.464 94.3923 379.943 94.187 380.312 93.7764C380.68 93.3658 380.864 92.7341 380.864 91.8813C380.864 91.039 380.68 90.4126 380.312 90.002C379.943 89.5808 379.469 89.3703 378.89 89.3703C378.301 89.3703 377.811 89.5808 377.422 90.002C377.032 90.4126 376.837 91.039 376.837 91.8813C376.837 92.7341 377.032 93.3658 377.422 93.7764C377.811 94.187 378.295 94.3923 378.875 94.3923ZM391.398 93.0815C391.398 93.5553 391.308 93.9764 391.13 94.3449C390.961 94.7028 390.724 95.0082 390.419 95.2609C390.114 95.503 389.745 95.6872 389.313 95.8136C388.892 95.9294 388.429 95.9873 387.924 95.9873H384.544V87.791H386.723V90.2862H387.955C389.04 90.2862 389.882 90.5231 390.482 90.9969C391.093 91.4601 391.398 92.155 391.398 93.0815ZM394.304 95.9873H392.109V87.791H394.304V95.9873ZM386.723 91.9444V94.3449H387.671C388.113 94.3449 388.466 94.2554 388.729 94.0764C389.003 93.8869 389.14 93.5763 389.14 93.1447C389.14 92.7235 389.013 92.4182 388.761 92.2287C388.518 92.0392 388.161 91.9444 387.687 91.9444H386.723ZM360.794 114.145C360.109 114.145 359.493 114.05 358.946 113.861C358.409 113.661 357.951 113.382 357.572 113.024C357.193 112.655 356.898 112.208 356.688 111.682C356.488 111.155 356.388 110.555 356.388 109.881C356.388 109.218 356.488 108.623 356.688 108.097C356.898 107.57 357.193 107.128 357.572 106.77C357.951 106.402 358.414 106.123 358.962 105.933C359.509 105.733 360.125 105.633 360.809 105.633C361.441 105.633 361.968 105.702 362.389 105.838C362.81 105.965 363.141 106.117 363.384 106.296V108.034C363.068 107.833 362.731 107.676 362.373 107.56C362.015 107.433 361.557 107.37 360.999 107.37C359.42 107.37 358.63 108.207 358.63 109.881C358.63 111.555 359.409 112.392 360.967 112.392C361.546 112.392 362.015 112.334 362.373 112.219C362.731 112.092 363.068 111.934 363.384 111.745V113.466C363.141 113.645 362.805 113.803 362.373 113.94C361.952 114.077 361.425 114.145 360.794 114.145ZM370.978 110.797H370.268V113.987H368.088V105.791H370.268V109.06H371.01L373.41 105.791H375.606L372.731 109.676L375.811 113.987H373.253L370.978 110.797ZM383.508 113.45C383.382 113.524 383.234 113.603 383.066 113.687C382.908 113.761 382.713 113.835 382.482 113.908C382.26 113.972 381.997 114.024 381.692 114.066C381.397 114.119 381.044 114.145 380.634 114.145C379.033 114.145 377.849 113.771 377.08 113.024C376.312 112.276 375.928 111.229 375.928 109.881C375.928 109.218 376.028 108.623 376.228 108.097C376.438 107.57 376.728 107.128 377.096 106.77C377.465 106.402 377.902 106.123 378.407 105.933C378.923 105.733 379.491 105.633 380.113 105.633C380.744 105.633 381.313 105.738 381.818 105.949C382.324 106.149 382.739 106.449 383.066 106.849C383.403 107.249 383.634 107.755 383.761 108.365C383.887 108.976 383.887 109.681 383.761 110.481H378.202C378.286 111.124 378.518 111.608 378.897 111.934C379.286 112.25 379.902 112.408 380.744 112.408C381.418 112.408 381.966 112.334 382.387 112.187C382.818 112.04 383.192 111.887 383.508 111.729V113.45ZM380.144 107.26C379.66 107.26 379.255 107.407 378.928 107.702C378.602 107.997 378.381 108.423 378.265 108.981H381.676C381.687 108.402 381.56 107.97 381.297 107.686C381.034 107.402 380.65 107.26 380.144 107.26ZM396.21 113.987H385.377V105.791H387.556V112.25H389.704V105.791H391.899V112.25H394.015V105.791H396.21V113.987ZM406.028 109.929C406.028 110.613 405.923 111.218 405.712 111.745C405.502 112.271 405.207 112.713 404.828 113.071C404.459 113.429 404.017 113.698 403.501 113.877C402.996 114.056 402.448 114.145 401.859 114.145C401.259 114.145 400.706 114.045 400.201 113.845C399.695 113.635 399.258 113.329 398.89 112.929C398.521 112.529 398.232 112.029 398.021 111.429C397.811 110.818 397.705 110.108 397.705 109.297C397.705 108.486 397.742 107.776 397.816 107.165C397.89 106.544 398.006 106.002 398.163 105.538C398.332 105.065 398.542 104.659 398.795 104.322C399.048 103.985 399.348 103.691 399.695 103.438C400.138 103.133 400.617 102.927 401.132 102.822C401.659 102.706 402.217 102.633 402.806 102.601C403.217 102.59 403.564 102.575 403.849 102.554C404.133 102.522 404.375 102.485 404.575 102.443C404.786 102.401 404.959 102.359 405.096 102.317C405.233 102.264 405.36 102.206 405.475 102.143V104.054C405.36 104.117 405.233 104.175 405.096 104.228C404.97 104.27 404.807 104.307 404.607 104.338C404.417 104.37 404.186 104.401 403.912 104.433C403.638 104.454 403.307 104.48 402.917 104.512C402.422 104.554 401.98 104.612 401.59 104.686C401.201 104.749 400.864 104.896 400.58 105.128C400.274 105.37 400.032 105.702 399.853 106.123C399.685 106.533 399.564 107.049 399.49 107.67C400.006 106.512 401.017 105.933 402.522 105.933C402.975 105.933 403.412 106.023 403.833 106.202C404.254 106.381 404.628 106.644 404.954 106.991C405.281 107.328 405.539 107.744 405.728 108.239C405.928 108.734 406.028 109.297 406.028 109.929ZM401.859 112.392C402.417 112.392 402.875 112.197 403.233 111.808C403.591 111.418 403.77 110.813 403.77 109.992C403.77 109.192 403.591 108.597 403.233 108.207C402.875 107.807 402.417 107.607 401.859 107.607C401.311 107.607 400.859 107.807 400.501 108.207C400.143 108.597 399.964 109.186 399.964 109.976C399.964 110.797 400.143 111.408 400.501 111.808C400.859 112.197 401.311 112.392 401.859 112.392ZM414.081 109.881C414.081 110.555 413.975 111.155 413.765 111.682C413.565 112.208 413.275 112.655 412.896 113.024C412.517 113.382 412.054 113.661 411.506 113.861C410.959 114.05 410.348 114.145 409.674 114.145C409.032 114.145 408.501 114.077 408.079 113.94C407.658 113.803 407.321 113.645 407.069 113.466V111.745C407.227 111.84 407.385 111.929 407.542 112.013C407.711 112.087 407.89 112.155 408.079 112.219C408.269 112.271 408.479 112.313 408.711 112.345C408.943 112.376 409.206 112.392 409.501 112.392C410.806 112.392 411.57 111.818 411.791 110.671H408.632V108.95H411.759C411.506 107.897 410.754 107.37 409.501 107.37C408.932 107.37 408.469 107.428 408.111 107.544C407.764 107.66 407.432 107.823 407.116 108.034V106.296C407.358 106.117 407.69 105.965 408.111 105.838C408.543 105.702 409.074 105.633 409.706 105.633C410.38 105.633 410.985 105.733 411.522 105.933C412.07 106.123 412.533 106.402 412.912 106.77C413.291 107.128 413.58 107.57 413.78 108.097C413.981 108.623 414.081 109.218 414.081 109.881ZM418.402 110.797H417.691V113.987H415.512V105.791H417.691V109.06H418.434L420.834 105.791H423.029L420.155 109.676L423.235 113.987H420.676L418.402 110.797ZM427.489 114.145C426.899 114.145 426.352 114.056 425.847 113.877C425.352 113.687 424.915 113.414 424.536 113.056C424.167 112.687 423.878 112.24 423.667 111.713C423.457 111.176 423.351 110.566 423.351 109.881C423.351 109.197 423.457 108.592 423.667 108.065C423.878 107.528 424.167 107.081 424.536 106.723C424.915 106.365 425.352 106.096 425.847 105.917C426.352 105.728 426.899 105.633 427.489 105.633C428.079 105.633 428.626 105.728 429.131 105.917C429.647 106.096 430.089 106.365 430.458 106.723C430.837 107.081 431.132 107.528 431.342 108.065C431.563 108.592 431.674 109.197 431.674 109.881C431.674 110.566 431.563 111.176 431.342 111.713C431.132 112.24 430.837 112.687 430.458 113.056C430.089 113.414 429.647 113.687 429.131 113.877C428.626 114.056 428.079 114.145 427.489 114.145ZM427.489 112.392C428.058 112.392 428.521 112.187 428.879 111.776C429.237 111.366 429.416 110.734 429.416 109.881C429.416 109.039 429.237 108.413 428.879 108.002C428.521 107.591 428.058 107.386 427.489 107.386C426.952 107.386 426.499 107.591 426.131 108.002C425.773 108.413 425.594 109.039 425.594 109.881C425.594 110.734 425.773 111.366 426.131 111.776C426.499 112.187 426.952 112.392 427.489 112.392ZM440.705 108.57L438.573 113.308H437.041L435.051 108.602V113.987H433.109V105.791H435.967L437.973 110.545L440.105 105.791H442.885V113.987H440.705V108.57Z"
                    fill="white"
                />
            </g>
            <g filter="url(#ff5a980b__filter2_d_27804_5736)">
                <rect
                    x={450}
                    y={101}
                    width={75}
                    height={27}
                    rx={13.5}
                    fill="white"
                />
                <mask
                    id="ff5a980b__mask3_27804_5736"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={456}
                    y={104}
                    width={62}
                    height={21}
                >
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M464.656 118.968L465.715 113.916L470.023 113.916C470.04 114.108 470.048 114.303 470.048 114.499C470.048 118.19 467.057 121.182 463.366 121.182C459.675 121.182 456.683 118.19 456.683 114.499C456.683 110.808 459.675 107.816 463.366 107.816C463.923 107.816 464.465 107.885 464.983 108.013L464.103 112.232L459.292 112.232L458.931 113.916L463.742 113.916L462.66 118.968L464.656 118.968ZM466.82 108.777L466.1 112.232L469.654 112.232C469.131 110.782 468.121 109.564 466.82 108.777Z"
                        fill="url(#ff5a980b__paint7_linear_27804_5736)"
                    />
                    <path
                        d="M481.592 117.29L481.592 120L479.194 120L479.194 117.29L473.564 117.29L473.564 115.5L479.09 107.542L481.592 107.542L481.592 115.396L483.103 115.396L483.103 117.29L481.592 117.29ZM479.194 115.396L479.194 110.461L475.788 115.396L479.194 115.396ZM493.967 115.778C493.967 116.496 493.834 117.127 493.567 117.672C493.313 118.216 492.965 118.674 492.525 119.044C492.096 119.415 491.598 119.699 491.031 119.896C490.463 120.081 489.878 120.174 489.276 120.174C488.581 120.174 487.938 120.069 487.347 119.861C486.768 119.653 486.27 119.317 485.853 118.853C485.436 118.378 485.112 117.776 484.88 117.046C484.648 116.305 484.532 115.401 484.532 114.336C484.532 113.386 484.642 112.494 484.863 111.66C485.083 110.814 485.419 110.073 485.87 109.436C486.334 108.799 486.919 108.295 487.625 107.924C488.343 107.554 489.195 107.368 490.179 107.368C490.816 107.368 491.384 107.432 491.882 107.56C492.38 107.687 492.809 107.866 493.168 108.098L493.168 110.096C492.693 109.818 492.212 109.616 491.726 109.488C491.251 109.361 490.787 109.297 490.336 109.297C489.351 109.297 488.587 109.61 488.042 110.235C487.509 110.849 487.168 111.706 487.017 112.807C487.399 112.378 487.834 112.071 488.32 111.886C488.818 111.689 489.363 111.591 489.953 111.591C490.475 111.591 490.979 111.672 491.465 111.834C491.952 111.996 492.38 112.251 492.751 112.598C493.121 112.934 493.417 113.369 493.637 113.901C493.857 114.423 493.967 115.048 493.967 115.778ZM489.293 118.263C489.583 118.263 489.855 118.21 490.11 118.106C490.376 118.002 490.608 117.851 490.805 117.654C491.013 117.446 491.175 117.191 491.291 116.89C491.419 116.577 491.482 116.218 491.482 115.813C491.482 115.419 491.424 115.077 491.309 114.788C491.193 114.486 491.036 114.243 490.84 114.058C490.654 113.861 490.434 113.716 490.179 113.623C489.924 113.531 489.658 113.484 489.38 113.484C489.079 113.484 488.795 113.531 488.529 113.623C488.262 113.716 488.025 113.861 487.816 114.058C487.619 114.243 487.457 114.486 487.33 114.788C487.214 115.077 487.156 115.419 487.156 115.813C487.133 116.612 487.33 117.22 487.747 117.637C488.164 118.054 488.679 118.263 489.293 118.263ZM500.586 120.174C499.856 120.174 499.173 120.041 498.536 119.774C497.91 119.496 497.36 119.091 496.885 118.558C496.422 118.013 496.057 117.342 495.791 116.542C495.524 115.743 495.391 114.816 495.391 113.762C495.391 112.708 495.524 111.787 495.791 111C496.057 110.201 496.422 109.534 496.885 109.002C497.36 108.469 497.91 108.069 498.536 107.803C499.173 107.525 499.856 107.386 500.586 107.386C501.316 107.386 501.999 107.519 502.636 107.785C503.273 108.052 503.824 108.451 504.287 108.984C504.75 109.517 505.115 110.183 505.382 110.982C505.648 111.77 505.781 112.685 505.781 113.728C505.781 114.77 505.648 115.691 505.382 116.49C505.115 117.29 504.75 117.967 504.287 118.523C503.824 119.068 503.273 119.479 502.636 119.757C501.999 120.035 501.316 120.174 500.586 120.174ZM500.569 118.245C500.963 118.245 501.327 118.164 501.663 118.002C501.999 117.84 502.289 117.585 502.532 117.237C502.775 116.878 502.966 116.415 503.105 115.847C503.244 115.28 503.314 114.591 503.314 113.78C503.314 112.969 503.244 112.28 503.105 111.712C502.966 111.133 502.775 110.67 502.532 110.322C502.289 109.963 501.999 109.702 501.663 109.54C501.327 109.378 500.968 109.297 500.586 109.297C500.204 109.297 499.845 109.378 499.509 109.54C499.184 109.702 498.901 109.963 498.657 110.322C498.414 110.67 498.223 111.133 498.084 111.712C497.945 112.28 497.876 112.969 497.876 113.78C497.876 114.591 497.945 115.28 498.084 115.847C498.223 116.415 498.414 116.878 498.657 117.237C498.901 117.585 499.184 117.84 499.509 118.002C499.833 118.164 500.186 118.245 500.569 118.245ZM512.43 120.174C511.7 120.174 511.016 120.041 510.379 119.774C509.754 119.496 509.204 119.091 508.729 118.558C508.265 118.013 507.9 117.342 507.634 116.542C507.368 115.743 507.234 114.816 507.234 113.762C507.234 112.708 507.368 111.787 507.634 111C507.9 110.201 508.265 109.534 508.729 109.002C509.204 108.469 509.754 108.069 510.379 107.803C511.016 107.525 511.7 107.386 512.43 107.386C513.159 107.386 513.843 107.519 514.48 107.785C515.117 108.052 515.667 108.451 516.13 108.984C516.594 109.517 516.959 110.183 517.225 110.982C517.491 111.77 517.625 112.685 517.625 113.728C517.625 114.77 517.491 115.691 517.225 116.49C516.959 117.29 516.594 117.967 516.13 118.523C515.667 119.068 515.117 119.479 514.48 119.757C513.843 120.035 513.159 120.174 512.43 120.174ZM512.412 118.245C512.806 118.245 513.171 118.164 513.507 118.002C513.843 117.84 514.132 117.585 514.376 117.237C514.619 116.878 514.81 116.415 514.949 115.847C515.088 115.28 515.157 114.591 515.157 113.78C515.157 112.969 515.088 112.28 514.949 111.712C514.81 111.133 514.619 110.67 514.376 110.322C514.132 109.963 513.843 109.702 513.507 109.54C513.171 109.378 512.812 109.297 512.43 109.297C512.047 109.297 511.688 109.378 511.352 109.54C511.028 109.702 510.744 109.963 510.501 110.322C510.258 110.67 510.067 111.133 509.928 111.712C509.789 112.28 509.719 112.969 509.719 113.78C509.719 114.591 509.789 115.28 509.928 115.847C510.067 116.415 510.258 116.878 510.501 117.237C510.744 117.585 511.028 117.84 511.352 118.002C511.677 118.164 512.03 118.245 512.412 118.245Z"
                        fill="url(#ff5a980b__paint8_linear_27804_5736)"
                    />
                </mask>
                <g mask="url(#ff5a980b__mask3_27804_5736)">
                    <rect
                        x={443}
                        y={104}
                        width={82}
                        height={21}
                        fill="url(#ff5a980b__paint9_linear_27804_5736)"
                    />
                </g>
            </g>
            <g filter="url(#ff5a980b__filter3_d_27804_5736)">
                <rect
                    x={313}
                    y={54}
                    width={67}
                    height={25}
                    rx={12.5}
                    fill="white"
                />
                <mask
                    id="ff5a980b__mask4_27804_5736"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={318}
                    y={56}
                    width={57}
                    height={20}
                >
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M326.517 70.572L327.526 65.7592L331.631 65.7592C331.647 65.9425 331.655 66.1279 331.655 66.3153C331.655 69.8311 328.805 72.6813 325.289 72.6813C321.774 72.6813 318.923 69.8311 318.923 66.3153C318.923 62.7994 321.774 59.9492 325.289 59.9492C325.82 59.9492 326.335 60.0141 326.828 60.1365L325.99 64.155L321.407 64.155L321.063 65.7592L325.647 65.7592L324.615 70.572L326.517 70.572ZM328.579 60.8638L327.892 64.155L331.28 64.155C330.781 62.773 329.818 61.6131 328.579 60.8638Z"
                        fill="url(#ff5a980b__paint10_linear_27804_5736)"
                    />
                    <path
                        d="M341.686 72L339.385 72L339.385 62.6483L336.936 65.0814L336.936 62.8469L339.65 60.1324L341.686 60.1324L341.686 72ZM351.57 72L343.724 72L343.724 69.8152C344.729 69.0648 345.578 68.4028 346.273 67.829C346.98 67.2552 347.548 66.731 347.978 66.2565C348.409 65.7821 348.718 65.3407 348.905 64.9324C349.104 64.5131 349.203 64.0772 349.203 63.6248C349.203 63.0731 349.038 62.6427 348.706 62.3338C348.386 62.0138 347.929 61.8538 347.333 61.8538C346.737 61.8538 346.163 61.9807 345.611 62.2345C345.06 62.4883 344.541 62.8248 344.055 63.2441L344.055 61.1586C344.519 60.8055 345.032 60.5241 345.595 60.3145C346.158 60.0938 346.842 59.9834 347.647 59.9834C348.243 59.9834 348.784 60.0662 349.269 60.2317C349.755 60.3862 350.169 60.6179 350.511 60.9269C350.864 61.2359 351.134 61.6165 351.322 62.069C351.52 62.5103 351.62 63.0124 351.62 63.5752C351.62 64.149 351.504 64.6896 351.272 65.1972C351.04 65.7048 350.693 66.2124 350.229 66.72C349.777 67.2276 349.209 67.7572 348.524 68.309C347.851 68.8497 347.062 69.4455 346.158 70.0965L351.57 70.0965L351.57 72ZM357.822 72.1655C357.127 72.1655 356.476 72.0386 355.869 71.7848C355.274 71.52 354.749 71.1338 354.297 70.6262C353.856 70.1076 353.508 69.4676 353.254 68.7062C353 67.9448 352.874 67.0621 352.874 66.0579C352.874 65.0538 353 64.1765 353.254 63.4262C353.508 62.6648 353.856 62.0303 354.297 61.5227C354.749 61.0152 355.274 60.6345 355.869 60.3807C356.476 60.1159 357.127 59.9834 357.822 59.9834C358.518 59.9834 359.169 60.1103 359.776 60.3641C360.382 60.6179 360.907 60.9986 361.348 61.5062C361.789 62.0138 362.137 62.6483 362.391 63.4096C362.645 64.16 362.771 65.0317 362.771 66.0248C362.771 67.0179 362.645 67.8952 362.391 68.6565C362.137 69.4179 361.789 70.0634 361.348 70.5931C360.907 71.1117 360.382 71.5034 359.776 71.7683C359.169 72.0331 358.518 72.1655 357.822 72.1655ZM357.806 70.3283C358.181 70.3283 358.529 70.251 358.849 70.0965C359.169 69.9421 359.445 69.6993 359.676 69.3683C359.908 69.0262 360.09 68.5848 360.222 68.0441C360.355 67.5034 360.421 66.8469 360.421 66.0745C360.421 65.3021 360.355 64.6455 360.222 64.1048C360.09 63.5531 359.908 63.1117 359.676 62.7807C359.445 62.4386 359.169 62.1903 358.849 62.0359C358.529 61.8814 358.187 61.8041 357.822 61.8041C357.458 61.8041 357.116 61.8814 356.796 62.0359C356.487 62.1903 356.217 62.4386 355.985 62.7807C355.754 63.1117 355.571 63.5531 355.439 64.1048C355.307 64.6455 355.24 65.3021 355.24 66.0745C355.24 66.8469 355.307 67.5034 355.439 68.0441C355.571 68.5848 355.754 69.0262 355.985 69.3683C356.217 69.6993 356.487 69.9421 356.796 70.0965C357.105 70.251 357.442 70.3283 357.806 70.3283ZM369.105 72.1655C368.41 72.1655 367.759 72.0386 367.152 71.7848C366.556 71.52 366.032 71.1338 365.579 70.6262C365.138 70.1076 364.79 69.4676 364.537 68.7062C364.283 67.9448 364.156 67.0621 364.156 66.0579C364.156 65.0538 364.283 64.1765 364.537 63.4262C364.79 62.6648 365.138 62.0303 365.579 61.5227C366.032 61.0152 366.556 60.6345 367.152 60.3807C367.759 60.1159 368.41 59.9834 369.105 59.9834C369.8 59.9834 370.451 60.1103 371.058 60.3641C371.665 60.6179 372.189 60.9986 372.63 61.5062C373.072 62.0138 373.419 62.6483 373.673 63.4096C373.927 64.16 374.054 65.0317 374.054 66.0248C374.054 67.0179 373.927 67.8952 373.673 68.6565C373.419 69.4179 373.072 70.0634 372.63 70.5931C372.189 71.1117 371.665 71.5034 371.058 71.7683C370.451 72.0331 369.8 72.1655 369.105 72.1655ZM369.088 70.3283C369.463 70.3283 369.811 70.251 370.131 70.0965C370.451 69.9421 370.727 69.6993 370.959 69.3683C371.19 69.0262 371.372 68.5848 371.505 68.0441C371.637 67.5034 371.703 66.8469 371.703 66.0745C371.703 65.3021 371.637 64.6455 371.505 64.1048C371.372 63.5531 371.19 63.1117 370.959 62.7807C370.727 62.4386 370.451 62.1903 370.131 62.0359C369.811 61.8814 369.469 61.8041 369.105 61.8041C368.741 61.8041 368.399 61.8814 368.079 62.0359C367.77 62.1903 367.499 62.4386 367.268 62.7807C367.036 63.1117 366.854 63.5531 366.721 64.1048C366.589 64.6455 366.523 65.3021 366.523 66.0745C366.523 66.8469 366.589 67.5034 366.721 68.0441C366.854 68.5848 367.036 69.0262 367.268 69.3683C367.499 69.6993 367.77 69.9421 368.079 70.0965C368.388 70.251 368.724 70.3283 369.088 70.3283Z"
                        fill="url(#ff5a980b__paint11_linear_27804_5736)"
                    />
                </mask>
                <g mask="url(#ff5a980b__mask4_27804_5736)">
                    <rect
                        x={308}
                        y={54}
                        width={69}
                        height={21}
                        fill="url(#ff5a980b__paint12_linear_27804_5736)"
                    />
                </g>
            </g>
        </g>
        <defs>
            <filter
                id="ff5a980b__filter0_f_27804_5736"
                x={-383.585}
                y={-213.729}
                width={1501.64}
                height={894.343}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feGaussianBlur
                    stdDeviation={39.7462}
                    result="effect1_foregroundBlur_27804_5736"
                />
            </filter>
            <filter
                id="ff5a980b__filter1_d_27804_5736"
                x={297.676}
                y={175.406}
                width={104.648}
                height={72.648}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={9.72961} />
                <feGaussianBlur stdDeviation={12.162} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_5736"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_5736"
                    result="shape"
                />
            </filter>
            <pattern
                id="ff5a980b__pattern0"
                patternContentUnits="objectBoundingBox"
                width={1}
                height={1}
            >
                <use
                    xlinkHref="#ff5a980b__image0_27804_5736"
                    transform="scale(0.00581395 0.00625)"
                />
            </pattern>
            <filter
                id="ff5a980b__filter2_d_27804_5736"
                x={427.569}
                y={87.1963}
                width={119.862}
                height={71.8621}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={8.62733} />
                <feGaussianBlur stdDeviation={11.2155} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.555272 0 0 0 0 0.810518 0 0 0 0 0.954094 0 0 0 0.34 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_5736"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_5736"
                    result="shape"
                />
            </filter>
            <filter
                id="ff5a980b__filter3_d_27804_5736"
                x={287.536}
                y={38.7215}
                width={117.928}
                height={75.9284}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={10.1857} />
                <feGaussianBlur stdDeviation={12.7321} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_5736"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_5736"
                    result="shape"
                />
            </filter>
            <radialGradient
                id="ff5a980b__paint0_radial_27804_5736"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(-298.618 -152) rotate(30.1339) scale(1535.79 1995.75)"
            >
                <stop offset={0.0755925} stopColor="#48CCE0" />
                <stop offset={0.307872} stopColor="#428BEB" />
                <stop offset={0.647543} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="ff5a980b__paint1_radial_27804_5736"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(1029.62 619) rotate(-178.458) scale(1324.75 2557.14)"
            >
                <stop offset={0.0285744} stopColor="#FCAB14" />
                <stop offset={0.191856} stopColor="#FA6641" />
                <stop offset={0.402081} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="ff5a980b__paint2_linear_27804_5736"
                x1={327.948}
                y1={202.227}
                x2={358.962}
                y2={202.227}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint3_linear_27804_5736"
                x1={345.067}
                y1={202}
                x2={374}
                y2={202}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint4_linear_27804_5736"
                x1={372}
                y1={203.5}
                x2={321}
                y2={203.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <radialGradient
                id="ff5a980b__paint5_radial_27804_5736"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(0 126.325) rotate(-45) scale(178.651 270.385)"
            >
                <stop stopColor="#48CCE0" />
                <stop offset={0.288462} stopColor="#428BEB" />
                <stop offset={0.601763} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="ff5a980b__paint6_radial_27804_5736"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(126.325) rotate(-180) scale(124.784 353.993)"
            >
                <stop stopColor="#FCAB14" />
                <stop offset={0.159058} stopColor="#FA6641" />
                <stop offset={0.402081} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="ff5a980b__paint7_linear_27804_5736"
                x1={456.683}
                y1={114.499}
                x2={490.765}
                y2={114.499}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint8_linear_27804_5736"
                x1={475.788}
                y1={114.5}
                x2={518.722}
                y2={114.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint9_linear_27804_5736"
                x1={525}
                y1={114.5}
                x2={443}
                y2={114.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint10_linear_27804_5736"
                x1={318.923}
                y1={66.3153}
                x2={351.39}
                y2={66.3151}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint11_linear_27804_5736"
                x1={336.867}
                y1={66.5}
                x2={377}
                y2={66.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="ff5a980b__paint12_linear_27804_5736"
                x1={377}
                y1={64.5}
                x2={308}
                y2={64.5009}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <clipPath id="ff5a980b__clip0_27804_5736">
                <rect width={800} height={300} fill="white" />
            </clipPath>
            <clipPath id="ff5a980b__clip1_27804_5736">
                <rect
                    x={341.32}
                    y={67.6245}
                    width={126.325}
                    height={126.325}
                    rx={19.4369}
                    fill="white"
                />
            </clipPath>
            <clipPath id="ff5a980b__clip2_27804_5736">
                <rect
                    width={126.34}
                    height={126.34}
                    fill="white"
                    transform="translate(341.32 67.6245)"
                />
            </clipPath>
            <image
                id="ff5a980b__image0_27804_5736"
                width={172}
                height={160}
                xlinkHref="data:image/png;base64,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"
            />
        </defs>
    </svg>
);

export default PlusPromoL;
