import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlusPromoM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 375 378"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        xmlnsXlink="http://www.w3.org/1999/xlink"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#f2e5ff76__clip0_27804_6153)">
            <rect width={375} height={378} fill="white" />
            <g clipPath="url(#f2e5ff76__clip1_27804_6153)">
                <rect
                    width={800}
                    height={300}
                    transform="translate(-137 78)"
                    fill="white"
                />
                <g opacity={0.4} filter="url(#f2e5ff76__filter0_f_27804_6153)">
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint0_radial_27804_6153)"
                    />
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint1_radial_27804_6153)"
                    />
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint2_linear_27804_6153)"
                    />
                </g>
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M-70.6636 12.5351C-69.9636 12.5351 -69.3961 11.9676 -69.3961 11.2676C-69.3961 10.5675 -69.9636 10 -70.6636 10C-71.3637 10 -71.9312 10.5675 -71.9312 11.2676C-71.9312 11.9676 -71.3637 12.5351 -70.6636 12.5351ZM-111.649 13.3803C-111.649 14.7804 -112.784 15.9154 -114.184 15.9154C-115.584 15.9154 -116.719 14.7804 -116.719 13.3803C-116.719 11.9801 -115.584 10.8451 -114.184 10.8451C-112.784 10.8451 -111.649 11.9801 -111.649 13.3803ZM118.204 45.4921C122.871 45.4921 126.655 41.7087 126.655 37.0417C126.655 32.3746 122.871 28.5912 118.204 28.5912C113.537 28.5912 109.754 32.3746 109.754 37.0417C109.754 41.7087 113.537 45.4921 118.204 45.4921ZM80.1773 148.589C80.1773 153.256 76.3939 157.039 71.7268 157.039C67.0597 157.039 63.2763 153.256 63.2763 148.589C63.2763 143.922 67.0597 140.138 71.7268 140.138C76.3939 140.138 80.1773 143.922 80.1773 148.589ZM-122.634 233.093C-118.901 233.093 -115.874 230.066 -115.874 226.333C-115.874 222.599 -118.901 219.572 -122.634 219.572C-126.368 219.572 -129.395 222.599 -129.395 226.333C-129.395 230.066 -126.368 233.093 -122.634 233.093ZM-78.6917 301.541C-74.958 301.541 -71.9313 298.514 -71.9313 294.781C-71.9313 291.047 -74.958 288.02 -78.6917 288.02C-82.4253 288.02 -85.452 291.047 -85.452 294.781C-85.452 298.514 -82.4253 301.541 -78.6917 301.541ZM150.316 309.992C150.316 312.793 148.046 315.063 145.246 315.063C142.446 315.063 140.176 312.793 140.176 309.992C140.176 307.192 142.446 304.922 145.246 304.922C148.046 304.922 150.316 307.192 150.316 309.992ZM129.19 388.582C131.057 388.582 132.57 387.069 132.57 385.202C132.57 383.335 131.057 381.822 129.19 381.822C127.323 381.822 125.81 383.335 125.81 385.202C125.81 387.069 127.323 388.582 129.19 388.582ZM-31.3692 372.525C-31.3692 376.259 -34.3959 379.286 -38.1296 379.286C-41.8632 379.286 -44.8899 376.259 -44.8899 372.525C-44.8899 368.792 -41.8632 365.765 -38.1296 365.765C-34.3959 365.765 -31.3692 368.792 -31.3692 372.525ZM-47.4249 495.903C-42.7579 495.903 -38.9744 492.119 -38.9744 487.452C-38.9744 482.785 -42.7579 479.002 -47.4249 479.002C-52.092 479.002 -55.8754 482.785 -55.8754 487.452C-55.8754 492.119 -52.092 495.903 -47.4249 495.903ZM-34.7491 309.146C-34.7491 312.413 -37.3975 315.062 -40.6645 315.062C-43.9314 315.062 -46.5798 312.413 -46.5798 309.146C-46.5798 305.879 -43.9314 303.231 -40.6645 303.231C-37.3975 303.231 -34.7491 305.879 -34.7491 309.146ZM132.57 249.994C137.237 249.994 141.021 246.21 141.021 241.543C141.021 236.876 137.237 233.093 132.57 233.093C127.903 233.093 124.12 236.876 124.12 241.543C124.12 246.21 127.903 249.994 132.57 249.994ZM-101.508 66.6179C-101.508 71.285 -105.291 75.0684 -109.958 75.0684C-114.625 75.0684 -118.409 71.285 -118.409 66.6179C-118.409 61.9509 -114.625 58.1674 -109.958 58.1674C-105.291 58.1674 -101.508 61.9509 -101.508 66.6179ZM-80.3821 200.981C-75.715 200.981 -71.9316 197.198 -71.9316 192.531C-71.9316 187.864 -75.715 184.08 -80.3821 184.08C-85.0491 184.08 -88.8326 187.864 -88.8326 192.531C-88.8326 197.198 -85.0491 200.981 -80.3821 200.981ZM-10.2429 148.589C-10.2429 153.256 -14.0263 157.039 -18.6934 157.039C-23.3605 157.039 -27.1439 153.256 -27.1439 148.589C-27.1439 143.922 -23.3605 140.138 -18.6934 140.138C-14.0263 140.138 -10.2429 143.922 -10.2429 148.589ZM66.6564 527.17C71.3235 527.17 75.1069 523.386 75.1069 518.719C75.1069 514.052 71.3235 510.269 66.6564 510.269C61.9894 510.269 58.206 514.052 58.206 518.719C58.206 523.386 61.9894 527.17 66.6564 527.17ZM92.0079 401.257C92.0079 405.924 88.2245 409.708 83.5574 409.708C78.8903 409.708 75.1069 405.924 75.1069 401.257C75.1069 396.59 78.8903 392.807 83.5574 392.807C88.2245 392.807 92.0079 396.59 92.0079 401.257ZM-114.184 331.962C-109.517 331.962 -105.733 328.179 -105.733 323.512C-105.733 318.845 -109.517 315.061 -114.184 315.061C-118.851 315.061 -122.634 318.845 -122.634 323.512C-122.634 328.179 -118.851 331.962 -114.184 331.962ZM-40.6644 119.012C-40.6644 122.746 -43.6911 125.772 -47.4248 125.772C-51.1584 125.772 -54.1851 122.746 -54.1851 119.012C-54.1851 115.278 -51.1584 112.252 -47.4248 112.252C-43.6911 112.252 -40.6644 115.278 -40.6644 119.012ZM-118.409 147.742C-114.675 147.742 -111.649 144.715 -111.649 140.981C-111.649 137.248 -114.675 134.221 -118.409 134.221C-122.143 134.221 -125.169 137.248 -125.169 140.981C-125.169 144.715 -122.143 147.742 -118.409 147.742ZM-12.7781 225.487C-12.7781 228.287 -15.0481 230.557 -17.8483 230.557C-20.6486 230.557 -22.9186 228.287 -22.9186 225.487C-22.9186 222.687 -20.6486 220.417 -17.8483 220.417C-15.0481 220.417 -12.7781 222.687 -12.7781 225.487ZM-20.3834 429.144C-17.1165 429.144 -14.4681 426.495 -14.4681 423.228C-14.4681 419.961 -17.1165 417.313 -20.3834 417.313C-23.6504 417.313 -26.2987 419.961 -26.2987 423.228C-26.2987 426.495 -23.6504 429.144 -20.3834 429.144ZM101.303 353.933C101.303 356.734 99.0333 359.004 96.233 359.004C93.4328 359.004 91.1627 356.734 91.1627 353.933C91.1627 351.133 93.4328 348.863 96.233 348.863C99.0333 348.863 101.303 351.133 101.303 353.933ZM96.233 163.799C99.0333 163.799 101.303 161.529 101.303 158.728C101.303 155.928 99.0333 153.658 96.233 153.658C93.4328 153.658 91.1627 155.928 91.1627 158.728C91.1627 161.529 93.4328 163.799 96.233 163.799ZM-80.3818 77.6041C-80.3818 80.4043 -82.6519 82.6744 -85.4521 82.6744C-88.2524 82.6744 -90.5224 80.4043 -90.5224 77.6041C-90.5224 74.8039 -88.2524 72.5338 -85.4521 72.5338C-82.6519 72.5338 -80.3818 74.8039 -80.3818 77.6041ZM53.1359 82.6744C55.9362 82.6744 58.2062 80.4043 58.2062 77.6041C58.2062 74.8039 55.9362 72.5338 53.1359 72.5338C50.3357 72.5338 48.0656 74.8039 48.0656 77.6041C48.0656 80.4043 50.3357 82.6744 53.1359 82.6744ZM70.8819 308.301C70.8819 311.102 68.6119 313.372 65.8116 313.372C63.0114 313.372 60.7413 311.102 60.7413 308.301C60.7413 305.501 63.0114 303.231 65.8116 303.231C68.6119 303.231 70.8819 305.501 70.8819 308.301ZM-75.3118 433.369C-72.5116 433.369 -70.2415 431.099 -70.2415 428.299C-70.2415 425.499 -72.5116 423.229 -75.3118 423.229C-78.112 423.229 -80.3821 425.499 -80.3821 428.299C-80.3821 431.099 -78.112 433.369 -75.3118 433.369ZM157.076 450.27C157.076 453.07 154.806 455.34 152.006 455.34C149.206 455.34 146.936 453.07 146.936 450.27C146.936 447.47 149.206 445.2 152.006 445.2C154.806 445.2 157.076 447.47 157.076 450.27ZM26.9392 235.628C28.3393 235.628 29.4744 234.493 29.4744 233.093C29.4744 231.692 28.3393 230.557 26.9392 230.557C25.5391 230.557 24.4041 231.692 24.4041 233.093C24.4041 234.493 25.5391 235.628 26.9392 235.628ZM91.1626 198.446C91.1626 199.846 90.0276 200.981 88.6275 200.981C87.2274 200.981 86.0924 199.846 86.0924 198.446C86.0924 197.045 87.2274 195.91 88.6275 195.91C90.0276 195.91 91.1626 197.045 91.1626 198.446ZM88.6275 273.655C90.0276 273.655 91.1626 272.52 91.1626 271.12C91.1626 269.72 90.0276 268.585 88.6275 268.585C87.2274 268.585 86.0924 269.72 86.0924 271.12C86.0924 272.52 87.2274 273.655 88.6275 273.655ZM91.1626 125.771C91.1626 127.171 90.0276 128.306 88.6275 128.306C87.2274 128.306 86.0924 127.171 86.0924 125.771C86.0924 124.371 87.2274 123.236 88.6275 123.236C90.0276 123.236 91.1626 124.371 91.1626 125.771ZM-51.65 153.658C-50.2499 153.658 -49.1149 152.523 -49.1149 151.123C-49.1149 149.723 -50.2499 148.588 -51.65 148.588C-53.0501 148.588 -54.1851 149.723 -54.1851 151.123C-54.1851 152.523 -53.0501 153.658 -51.65 153.658ZM-49.1149 72.5328C-49.1149 73.9329 -50.2499 75.0679 -51.65 75.0679C-53.0501 75.0679 -54.1851 73.9329 -54.1851 72.5328C-54.1851 71.1326 -53.0501 69.9976 -51.65 69.9976C-50.2499 69.9976 -49.1149 71.1326 -49.1149 72.5328ZM126.655 75.0679C128.055 75.0679 129.19 73.9329 129.19 72.5328C129.19 71.1326 128.055 69.9976 126.655 69.9976C125.255 69.9976 124.12 71.1326 124.12 72.5328C124.12 73.9329 125.255 75.0679 126.655 75.0679ZM55.6709 42.9565C55.6709 44.3566 54.5359 45.4917 53.1358 45.4917C51.7357 45.4917 50.6006 44.3566 50.6006 42.9565C50.6006 41.5564 51.7357 40.4214 53.1358 40.4214C54.5359 40.4214 55.6709 41.5564 55.6709 42.9565ZM53.1358 179.855C54.5359 179.855 55.6709 178.72 55.6709 177.32C55.6709 175.92 54.5359 174.785 53.1358 174.785C51.7357 174.785 50.6006 175.92 50.6006 177.32C50.6006 178.72 51.7357 179.855 53.1358 179.855ZM-98.1278 177.32C-98.1278 178.72 -99.2628 179.855 -100.663 179.855C-102.063 179.855 -103.198 178.72 -103.198 177.32C-103.198 175.92 -102.063 174.785 -100.663 174.785C-99.2628 174.785 -98.1278 175.92 -98.1278 177.32ZM-100.663 353.933C-99.2628 353.933 -98.1278 352.798 -98.1278 351.398C-98.1278 349.998 -99.2628 348.863 -100.663 348.863C-102.063 348.863 -103.198 349.998 -103.198 351.398C-103.198 352.798 -102.063 353.933 -100.663 353.933ZM68.3466 351.398C68.3466 352.798 67.2116 353.933 65.8115 353.933C64.4114 353.933 63.2763 352.798 63.2763 351.398C63.2763 349.998 64.4114 348.863 65.8115 348.863C67.2116 348.863 68.3466 349.998 68.3466 351.398ZM65.8115 421.538C67.2116 421.538 68.3466 420.403 68.3466 419.003C68.3466 417.603 67.2116 416.468 65.8115 416.468C64.4114 416.468 63.2763 417.603 63.2763 419.003C63.2763 420.403 64.4114 421.538 65.8115 421.538ZM-93.0579 445.2C-93.0579 446.6 -94.1929 447.735 -95.593 447.735C-96.9931 447.735 -98.1282 446.6 -98.1282 445.2C-98.1282 443.8 -96.9931 442.665 -95.593 442.665C-94.1929 442.665 -93.0579 443.8 -93.0579 445.2ZM52.2906 460.411C53.6908 460.411 54.8258 459.276 54.8258 457.876C54.8258 456.475 53.6908 455.34 52.2906 455.34C50.8905 455.34 49.7555 456.475 49.7555 457.876C49.7555 459.276 50.8905 460.411 52.2906 460.411ZM55.6709 102.111C55.6709 103.511 54.5359 104.646 53.1358 104.646C51.7357 104.646 50.6006 103.511 50.6006 102.111C50.6006 100.711 51.7357 99.5755 53.1358 99.5755C54.5359 99.5755 55.6709 100.711 55.6709 102.111ZM-134.465 104.646C-133.065 104.646 -131.93 103.511 -131.93 102.111C-131.93 100.711 -133.065 99.5755 -134.465 99.5755C-135.865 99.5755 -137 100.711 -137 102.111C-137 103.511 -135.865 104.646 -134.465 104.646ZM-7.70763 102.111C-7.70763 103.511 -8.84265 104.646 -10.2428 104.646C-11.6429 104.646 -12.7779 103.511 -12.7779 102.111C-12.7779 100.711 -11.6429 99.5755 -10.2428 99.5755C-8.84265 99.5755 -7.70763 100.711 -7.70763 102.111ZM-10.2428 42.9571C-8.84265 42.9571 -7.70763 41.8221 -7.70763 40.4219C-7.70763 39.0218 -8.84265 37.8868 -10.2428 37.8868C-11.6429 37.8868 -12.7779 39.0218 -12.7779 40.4219C-12.7779 41.8221 -11.6429 42.9571 -10.2428 42.9571ZM-54.1854 387.735C-52.7853 387.735 -51.6502 386.6 -51.6502 385.2C-51.6502 383.8 -52.7853 382.665 -54.1854 382.665C-55.5855 382.665 -56.7205 383.8 -56.7205 385.2C-56.7205 386.6 -55.5855 387.735 -54.1854 387.735ZM-51.6502 536.464C-51.6502 537.865 -52.7853 539 -54.1854 539C-55.5855 539 -56.7205 537.865 -56.7205 536.464C-56.7205 535.064 -55.5855 533.929 -54.1854 533.929C-52.7853 533.929 -51.6502 535.064 -51.6502 536.464ZM115.67 436.749C117.07 436.749 118.205 435.614 118.205 434.214C118.205 432.813 117.07 431.678 115.67 431.678C114.269 431.678 113.134 432.813 113.134 434.214C113.134 435.614 114.269 436.749 115.67 436.749ZM108.909 489.987C108.909 491.387 107.774 492.522 106.374 492.522C104.973 492.522 103.838 491.387 103.838 489.987C103.838 488.587 104.973 487.452 106.374 487.452C107.774 487.452 108.909 488.587 108.909 489.987ZM-129.394 516.183C-127.994 516.183 -126.859 515.048 -126.859 513.648C-126.859 512.248 -127.994 511.113 -129.394 511.113C-130.795 511.113 -131.93 512.248 -131.93 513.648C-131.93 515.048 -130.795 516.183 -129.394 516.183ZM-126.859 416.468C-126.859 417.868 -127.994 419.003 -129.394 419.003C-130.795 419.003 -131.93 417.868 -131.93 416.468C-131.93 415.068 -130.795 413.933 -129.394 413.933C-127.994 413.933 -126.859 415.068 -126.859 416.468ZM15.9536 487.452C17.3537 487.452 18.4887 486.317 18.4887 484.917C18.4887 483.517 17.3537 482.382 15.9536 482.382C14.5535 482.382 13.4185 483.517 13.4185 484.917C13.4185 486.317 14.5535 487.452 15.9536 487.452ZM55.6709 222.107C55.6709 223.508 54.5359 224.643 53.1358 224.643C51.7357 224.643 50.6006 223.508 50.6006 222.107C50.6006 220.707 51.7357 219.572 53.1358 219.572C54.5359 219.572 55.6709 220.707 55.6709 222.107ZM13.4183 315.907C15.2851 315.907 16.7985 314.393 16.7985 312.526C16.7985 310.66 15.2851 309.146 13.4183 309.146C11.5515 309.146 10.0381 310.66 10.0381 312.526C10.0381 314.393 11.5515 315.907 13.4183 315.907ZM10.0386 266.895C10.0386 267.828 9.28192 268.585 8.34851 268.585C7.4151 268.585 6.65842 267.828 6.65842 266.895C6.65842 265.961 7.4151 265.204 8.34851 265.204C9.28192 265.204 10.0386 265.961 10.0386 266.895ZM-20.8059 276.19C-20.1059 276.19 -19.5384 275.622 -19.5384 274.922C-19.5384 274.222 -20.1059 273.655 -20.8059 273.655C-21.506 273.655 -22.0735 274.222 -22.0735 274.922C-22.0735 275.622 -21.506 276.19 -20.8059 276.19ZM-19.5384 197.178C-19.5384 197.878 -20.1059 198.446 -20.8059 198.446C-21.506 198.446 -22.0735 197.878 -22.0735 197.178C-22.0735 196.478 -21.506 195.91 -20.8059 195.91C-20.1059 195.91 -19.5384 196.478 -19.5384 197.178ZM114.402 198.446C115.102 198.446 115.67 197.878 115.67 197.178C115.67 196.478 115.102 195.91 114.402 195.91C113.702 195.91 113.134 196.478 113.134 197.178C113.134 197.878 113.702 198.446 114.402 198.446ZM115.67 120.278C115.67 120.978 115.102 121.545 114.402 121.545C113.702 121.545 113.134 120.978 113.134 120.278C113.134 119.578 113.702 119.01 114.402 119.01C115.102 119.01 115.67 119.578 115.67 120.278ZM114.402 58.1672C115.102 58.1672 115.67 57.5997 115.67 56.8996C115.67 56.1996 115.102 55.6321 114.402 55.6321C113.702 55.6321 113.134 56.1996 113.134 56.8996C113.134 57.5997 113.702 58.1672 114.402 58.1672ZM-27.1437 56.8996C-27.1437 57.5997 -27.7112 58.1672 -28.4113 58.1672C-29.1113 58.1672 -29.6788 57.5997 -29.6788 56.8996C-29.6788 56.1996 -29.1113 55.6321 -28.4113 55.6321C-27.7112 55.6321 -27.1437 56.1996 -27.1437 56.8996ZM34.5446 11.2676C34.5446 11.9676 33.9771 12.5351 33.277 12.5351C32.5769 12.5351 32.0094 11.9676 32.0094 11.2676C32.0094 10.5675 32.5769 10 33.277 10C33.9771 10 34.5446 10.5675 34.5446 11.2676ZM33.277 166.334C33.9771 166.334 34.5446 165.766 34.5446 165.066C34.5446 164.366 33.9771 163.799 33.277 163.799C32.5769 163.799 32.0094 164.366 32.0094 165.066C32.0094 165.766 32.5769 166.334 33.277 166.334ZM1.58781 345.062C1.58781 345.762 1.02031 346.329 0.320251 346.329C-0.379822 346.329 -0.947327 345.762 -0.947327 345.062C-0.947327 344.362 -0.379822 343.794 0.320251 343.794C1.02031 343.794 1.58781 344.362 1.58781 345.062ZM0.320251 522.943C1.02031 522.943 1.58781 522.376 1.58781 521.676C1.58781 520.975 1.02031 520.408 0.320251 520.408C-0.379822 520.408 -0.947327 520.975 -0.947327 521.676C-0.947327 522.376 -0.379822 522.943 0.320251 522.943ZM131.725 521.676C131.725 522.376 131.158 522.943 130.458 522.943C129.758 522.943 129.19 522.376 129.19 521.676C129.19 520.975 129.758 520.408 130.458 520.408C131.158 520.408 131.725 520.975 131.725 521.676ZM-99.3952 522.943C-98.6951 522.943 -98.1276 522.376 -98.1276 521.676C-98.1276 520.975 -98.6951 520.408 -99.3952 520.408C-100.095 520.408 -100.663 520.975 -100.663 521.676C-100.663 522.376 -100.095 522.943 -99.3952 522.943ZM-98.1276 392.385C-98.1276 393.085 -98.6951 393.652 -99.3952 393.652C-100.095 393.652 -100.663 393.085 -100.663 392.385C-100.663 391.685 -100.095 391.117 -99.3952 391.117C-98.6951 391.117 -98.1276 391.685 -98.1276 392.385ZM-99.3952 289.711C-98.6951 289.711 -98.1276 289.144 -98.1276 288.444C-98.1276 287.744 -98.6951 287.176 -99.3952 287.176C-100.095 287.176 -100.663 287.744 -100.663 288.444C-100.663 289.144 -100.095 289.711 -99.3952 289.711ZM96.2333 308.724C96.2333 309.424 95.6658 309.992 94.9657 309.992C94.2656 309.992 93.6981 309.424 93.6981 308.724C93.6981 308.024 94.2656 307.457 94.9657 307.457C95.6658 307.457 96.2333 308.024 96.2333 308.724ZM96.6555 219.571C97.3556 219.571 97.9231 219.004 97.9231 218.304C97.9231 217.604 97.3556 217.036 96.6555 217.036C95.9555 217.036 95.388 217.604 95.388 218.304C95.388 219.004 95.9555 219.571 96.6555 219.571ZM97.9231 54.3651C97.9231 55.0651 97.3556 55.6326 96.6555 55.6326C95.9555 55.6326 95.388 55.0651 95.388 54.3651C95.388 53.665 95.9555 53.0975 96.6555 53.0975C97.3556 53.0975 97.9231 53.665 97.9231 54.3651ZM42.995 260.979C44.3952 260.979 45.5302 259.844 45.5302 258.444C45.5302 257.044 44.3952 255.909 42.995 255.909C41.5949 255.909 40.4599 257.044 40.4599 258.444C40.4599 259.844 41.5949 260.979 42.995 260.979ZM129.19 268.584C129.19 269.984 128.055 271.119 126.655 271.119C125.255 271.119 124.12 269.984 124.12 268.584C124.12 267.184 125.255 266.049 126.655 266.049C128.055 266.049 129.19 267.184 129.19 268.584ZM-111.649 271.119C-110.249 271.119 -109.114 269.984 -109.114 268.584C-109.114 267.184 -110.249 266.049 -111.649 266.049C-113.049 266.049 -114.184 267.184 -114.184 268.584C-114.184 269.984 -113.049 271.119 -111.649 271.119Z"
                    fill="white"
                    fillOpacity={0.5}
                />
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M384.816 536.465C384.116 536.465 383.549 537.032 383.549 537.732C383.549 538.432 384.116 539 384.816 539C385.517 539 386.084 538.432 386.084 537.732C386.084 537.032 385.517 536.465 384.816 536.465ZM425.801 535.62C425.801 534.22 426.937 533.085 428.337 533.085C429.737 533.085 430.872 534.22 430.872 535.62C430.872 537.02 429.737 538.155 428.337 538.155C426.937 538.155 425.801 537.02 425.801 535.62ZM195.948 503.508C191.281 503.508 187.498 507.291 187.498 511.958C187.498 516.625 191.281 520.409 195.948 520.409C200.616 520.409 204.399 516.625 204.399 511.958C204.399 507.291 200.616 503.508 195.948 503.508ZM233.976 400.411C233.976 395.744 237.759 391.961 242.426 391.961C247.093 391.961 250.876 395.744 250.876 400.411C250.876 405.078 247.093 408.862 242.426 408.862C237.759 408.862 233.976 405.078 233.976 400.411ZM436.787 315.907C433.053 315.907 430.027 318.934 430.027 322.667C430.027 326.401 433.053 329.428 436.787 329.428C440.521 329.428 443.547 326.401 443.547 322.667C443.547 318.934 440.521 315.907 436.787 315.907ZM392.844 247.459C389.111 247.459 386.084 250.486 386.084 254.219C386.084 257.953 389.111 260.98 392.844 260.98C396.578 260.98 399.605 257.953 399.605 254.219C399.605 250.486 396.578 247.459 392.844 247.459ZM163.837 239.008C163.837 236.207 166.107 233.937 168.907 233.937C171.707 233.937 173.977 236.207 173.977 239.008C173.977 241.808 171.707 244.078 168.907 244.078C166.107 244.078 163.837 241.808 163.837 239.008ZM184.963 160.418C183.096 160.418 181.583 161.931 181.583 163.798C181.583 165.665 183.096 167.178 184.963 167.178C186.83 167.178 188.343 165.665 188.343 163.798C188.343 161.931 186.83 160.418 184.963 160.418ZM345.522 176.475C345.522 172.741 348.548 169.714 352.282 169.714C356.016 169.714 359.042 172.741 359.042 176.475C359.042 180.208 356.016 183.235 352.282 183.235C348.548 183.235 345.522 180.208 345.522 176.475ZM361.578 53.0975C356.911 53.0975 353.127 56.8809 353.127 61.548C353.127 66.215 356.911 69.9984 361.578 69.9984C366.245 69.9984 370.028 66.215 370.028 61.548C370.028 56.8809 366.245 53.0975 361.578 53.0975ZM348.902 239.854C348.902 236.587 351.55 233.938 354.817 233.938C358.084 233.938 360.733 236.587 360.733 239.854C360.733 243.121 358.084 245.769 354.817 245.769C351.55 245.769 348.902 243.121 348.902 239.854ZM181.583 299.006C176.916 299.006 173.132 302.79 173.132 307.457C173.132 312.124 176.916 315.907 181.583 315.907C186.25 315.907 190.033 312.124 190.033 307.457C190.033 302.79 186.25 299.006 181.583 299.006ZM415.661 482.382C415.661 477.715 419.444 473.932 424.111 473.932C428.778 473.932 432.562 477.715 432.562 482.382C432.562 487.049 428.778 490.833 424.111 490.833C419.444 490.833 415.661 487.049 415.661 482.382ZM394.535 348.019C389.868 348.019 386.084 351.802 386.084 356.469C386.084 361.136 389.868 364.92 394.535 364.92C399.202 364.92 402.985 361.136 402.985 356.469C402.985 351.802 399.202 348.019 394.535 348.019ZM324.395 400.411C324.395 395.744 328.179 391.961 332.846 391.961C337.513 391.961 341.296 395.744 341.296 400.411C341.296 405.078 337.513 408.862 332.846 408.862C328.179 408.862 324.395 405.078 324.395 400.411ZM247.496 21.8301C242.829 21.8301 239.046 25.6136 239.046 30.2806C239.046 34.9477 242.829 38.7311 247.496 38.7311C252.163 38.7311 255.947 34.9477 255.947 30.2806C255.947 25.6136 252.163 21.8301 247.496 21.8301ZM222.145 147.743C222.145 143.076 225.928 139.292 230.595 139.292C235.263 139.292 239.046 143.076 239.046 147.743C239.046 152.41 235.263 156.193 230.595 156.193C225.928 156.193 222.145 152.41 222.145 147.743ZM428.337 217.038C423.67 217.038 419.886 220.821 419.886 225.488C419.886 230.155 423.67 233.938 428.337 233.938C433.004 233.938 436.787 230.155 436.787 225.488C436.787 220.821 433.004 217.038 428.337 217.038ZM354.817 429.988C354.817 426.254 357.844 423.228 361.578 423.228C365.311 423.228 368.338 426.254 368.338 429.988C368.338 433.722 365.311 436.748 361.578 436.748C357.844 436.748 354.817 433.722 354.817 429.988ZM432.562 401.258C428.828 401.258 425.801 404.285 425.801 408.019C425.801 411.752 428.828 414.779 432.562 414.779C436.296 414.779 439.322 411.752 439.322 408.019C439.322 404.285 436.296 401.258 432.562 401.258ZM326.931 323.513C326.931 320.713 329.201 318.443 332.001 318.443C334.801 318.443 337.071 320.713 337.071 323.513C337.071 326.313 334.801 328.583 332.001 328.583C329.201 328.583 326.931 326.313 326.931 323.513ZM334.536 119.856C331.269 119.856 328.621 122.505 328.621 125.772C328.621 129.039 331.269 131.687 334.536 131.687C337.803 131.687 340.452 129.039 340.452 125.772C340.452 122.505 337.803 119.856 334.536 119.856ZM212.85 195.067C212.85 192.266 215.12 189.996 217.92 189.996C220.72 189.996 222.99 192.266 222.99 195.067C222.99 197.867 220.72 200.137 217.92 200.137C215.12 200.137 212.85 197.867 212.85 195.067ZM217.92 385.201C215.12 385.201 212.85 387.471 212.85 390.272C212.85 393.072 215.12 395.342 217.92 395.342C220.72 395.342 222.99 393.072 222.99 390.272C222.99 387.471 220.72 385.201 217.92 385.201ZM394.535 471.396C394.535 468.596 396.805 466.326 399.605 466.326C402.405 466.326 404.675 468.596 404.675 471.396C404.675 474.196 402.405 476.466 399.605 476.466C396.805 476.466 394.535 474.196 394.535 471.396ZM261.017 466.326C258.217 466.326 255.947 468.596 255.947 471.396C255.947 474.196 258.217 476.466 261.017 476.466C263.817 476.466 266.087 474.196 266.087 471.396C266.087 468.596 263.817 466.326 261.017 466.326ZM243.271 240.699C243.271 237.898 245.541 235.628 248.341 235.628C251.141 235.628 253.411 237.898 253.411 240.699C253.411 243.499 251.141 245.769 248.341 245.769C245.541 245.769 243.271 243.499 243.271 240.699ZM389.465 115.631C386.664 115.631 384.394 117.901 384.394 120.701C384.394 123.501 386.664 125.771 389.465 125.771C392.265 125.771 394.535 123.501 394.535 120.701C394.535 117.901 392.265 115.631 389.465 115.631ZM157.076 98.73C157.076 95.9298 159.346 93.6598 162.147 93.6598C164.947 93.6598 167.217 95.9298 167.217 98.73C167.217 101.53 164.947 103.8 162.147 103.8C159.346 103.8 157.076 101.53 157.076 98.73ZM287.214 313.372C285.813 313.372 284.678 314.507 284.678 315.907C284.678 317.308 285.813 318.443 287.214 318.443C288.614 318.443 289.749 317.308 289.749 315.907C289.749 314.507 288.614 313.372 287.214 313.372ZM222.99 350.554C222.99 349.154 224.125 348.019 225.525 348.019C226.925 348.019 228.06 349.154 228.06 350.554C228.06 351.955 226.925 353.09 225.525 353.09C224.125 353.09 222.99 351.955 222.99 350.554ZM225.525 275.345C224.125 275.345 222.99 276.48 222.99 277.88C222.99 279.28 224.125 280.415 225.525 280.415C226.925 280.415 228.06 279.28 228.06 277.88C228.06 276.48 226.925 275.345 225.525 275.345ZM222.99 423.229C222.99 421.829 224.125 420.694 225.525 420.694C226.925 420.694 228.06 421.829 228.06 423.229C228.06 424.629 226.925 425.764 225.525 425.764C224.125 425.764 222.99 424.629 222.99 423.229ZM365.803 395.342C364.403 395.342 363.268 396.477 363.268 397.877C363.268 399.277 364.403 400.412 365.803 400.412C367.203 400.412 368.338 399.277 368.338 397.877C368.338 396.477 367.203 395.342 365.803 395.342ZM363.268 476.467C363.268 475.067 364.403 473.932 365.803 473.932C367.203 473.932 368.338 475.067 368.338 476.467C368.338 477.867 367.203 479.002 365.803 479.002C364.403 479.002 363.268 477.867 363.268 476.467ZM187.498 473.932C186.098 473.932 184.963 475.067 184.963 476.467C184.963 477.867 186.098 479.002 187.498 479.002C188.898 479.002 190.033 477.867 190.033 476.467C190.033 475.067 188.898 473.932 187.498 473.932ZM258.482 506.043C258.482 504.643 259.617 503.508 261.017 503.508C262.417 503.508 263.552 504.643 263.552 506.043C263.552 507.444 262.417 508.579 261.017 508.579C259.617 508.579 258.482 507.444 258.482 506.043ZM261.017 369.145C259.617 369.145 258.482 370.28 258.482 371.68C258.482 373.08 259.617 374.215 261.017 374.215C262.417 374.215 263.552 373.08 263.552 371.68C263.552 370.28 262.417 369.145 261.017 369.145ZM412.281 371.68C412.281 370.28 413.416 369.145 414.816 369.145C416.216 369.145 417.351 370.28 417.351 371.68C417.351 373.08 416.216 374.215 414.816 374.215C413.416 374.215 412.281 373.08 412.281 371.68ZM414.816 195.067C413.416 195.067 412.281 196.202 412.281 197.602C412.281 199.002 413.416 200.137 414.816 200.137C416.216 200.137 417.351 199.002 417.351 197.602C417.351 196.202 416.216 195.067 414.816 195.067ZM245.806 197.602C245.806 196.202 246.941 195.067 248.341 195.067C249.741 195.067 250.876 196.202 250.876 197.602C250.876 199.002 249.741 200.137 248.341 200.137C246.941 200.137 245.806 199.002 245.806 197.602ZM248.341 127.463C246.941 127.463 245.806 128.598 245.806 129.998C245.806 131.398 246.941 132.533 248.341 132.533C249.741 132.533 250.876 131.398 250.876 129.998C250.876 128.598 249.741 127.463 248.341 127.463ZM407.211 103.8C407.211 102.4 408.346 101.265 409.746 101.265C411.146 101.265 412.281 102.4 412.281 103.8C412.281 105.2 411.146 106.335 409.746 106.335C408.346 106.335 407.211 105.2 407.211 103.8ZM261.862 88.5893C260.462 88.5893 259.327 89.7243 259.327 91.1244C259.327 92.5246 260.462 93.6596 261.862 93.6596C263.262 93.6596 264.397 92.5246 264.397 91.1244C264.397 89.7243 263.262 88.5893 261.862 88.5893ZM258.482 446.889C258.482 445.489 259.617 444.354 261.017 444.354C262.417 444.354 263.552 445.489 263.552 446.889C263.552 448.289 262.417 449.425 261.017 449.425C259.617 449.425 258.482 448.289 258.482 446.889ZM448.618 444.354C447.218 444.354 446.083 445.489 446.083 446.889C446.083 448.289 447.218 449.425 448.618 449.425C450.018 449.425 451.153 448.289 451.153 446.889C451.153 445.489 450.018 444.354 448.618 444.354ZM321.86 446.889C321.86 445.489 322.995 444.354 324.396 444.354C325.796 444.354 326.931 445.489 326.931 446.889C326.931 448.289 325.796 449.425 324.396 449.425C322.995 449.425 321.86 448.289 321.86 446.889ZM324.396 506.043C322.995 506.043 321.86 507.178 321.86 508.578C321.86 509.978 322.995 511.113 324.396 511.113C325.796 511.113 326.931 509.978 326.931 508.578C326.931 507.178 325.796 506.043 324.396 506.043ZM368.338 161.265C366.938 161.265 365.803 162.4 365.803 163.8C365.803 165.2 366.938 166.335 368.338 166.335C369.738 166.335 370.873 165.2 370.873 163.8C370.873 162.4 369.738 161.265 368.338 161.265ZM365.803 12.5356C365.803 11.1355 366.938 10.0004 368.338 10.0004C369.738 10.0004 370.873 11.1355 370.873 12.5356C370.873 13.9357 369.738 15.0707 368.338 15.0707C366.938 15.0707 365.803 13.9357 365.803 12.5356ZM198.483 112.251C197.083 112.251 195.948 113.386 195.948 114.786C195.948 116.187 197.083 117.322 198.483 117.322C199.883 117.322 201.018 116.187 201.018 114.786C201.018 113.386 199.883 112.251 198.483 112.251ZM205.244 59.0128C205.244 57.6127 206.379 56.4777 207.779 56.4777C209.179 56.4777 210.314 57.6127 210.314 59.0128C210.314 60.4129 209.179 61.5479 207.779 61.5479C206.379 61.5479 205.244 60.4129 205.244 59.0128ZM443.547 32.8165C442.147 32.8165 441.012 33.9515 441.012 35.3517C441.012 36.7518 442.147 37.8868 443.547 37.8868C444.947 37.8868 446.082 36.7518 446.082 35.3517C446.082 33.9515 444.947 32.8165 443.547 32.8165ZM441.012 132.532C441.012 131.132 442.147 129.997 443.547 129.997C444.947 129.997 446.082 131.132 446.082 132.532C446.082 133.932 444.947 135.067 443.547 135.067C442.147 135.067 441.012 133.932 441.012 132.532ZM298.199 61.5479C296.799 61.5479 295.664 62.6829 295.664 64.083C295.664 65.4832 296.799 66.6182 298.199 66.6182C299.599 66.6182 300.734 65.4832 300.734 64.083C300.734 62.6829 299.599 61.5479 298.199 61.5479ZM258.482 326.893C258.482 325.492 259.617 324.357 261.017 324.357C262.417 324.357 263.552 325.492 263.552 326.893C263.552 328.293 262.417 329.428 261.017 329.428C259.617 329.428 258.482 328.293 258.482 326.893ZM300.735 233.093C298.868 233.093 297.354 234.607 297.354 236.474C297.354 238.34 298.868 239.854 300.735 239.854C302.601 239.854 304.115 238.34 304.115 236.474C304.115 234.607 302.601 233.093 300.735 233.093ZM304.115 282.105C304.115 281.172 304.871 280.415 305.805 280.415C306.738 280.415 307.495 281.172 307.495 282.105C307.495 283.039 306.738 283.796 305.805 283.796C304.871 283.796 304.115 283.039 304.115 282.105ZM334.959 272.81C334.259 272.81 333.691 273.378 333.691 274.078C333.691 274.778 334.259 275.345 334.959 275.345C335.659 275.345 336.226 274.778 336.226 274.078C336.226 273.378 335.659 272.81 334.959 272.81ZM333.691 351.822C333.691 351.122 334.259 350.554 334.959 350.554C335.659 350.554 336.226 351.122 336.226 351.822C336.226 352.522 335.659 353.09 334.959 353.09C334.259 353.09 333.691 352.522 333.691 351.822ZM199.751 350.554C199.051 350.554 198.483 351.122 198.483 351.822C198.483 352.522 199.051 353.09 199.751 353.09C200.451 353.09 201.018 352.522 201.018 351.822C201.018 351.122 200.451 350.554 199.751 350.554ZM198.483 428.722C198.483 428.022 199.051 427.455 199.751 427.455C200.451 427.455 201.018 428.022 201.018 428.722C201.018 429.422 200.451 429.99 199.751 429.99C199.051 429.99 198.483 429.422 198.483 428.722ZM199.751 490.833C199.051 490.833 198.483 491.4 198.483 492.1C198.483 492.8 199.051 493.368 199.751 493.368C200.451 493.368 201.018 492.8 201.018 492.1C201.018 491.4 200.451 490.833 199.751 490.833ZM341.297 492.1C341.297 491.4 341.864 490.833 342.564 490.833C343.264 490.833 343.832 491.4 343.832 492.1C343.832 492.8 343.264 493.368 342.564 493.368C341.864 493.368 341.297 492.8 341.297 492.1ZM279.608 537.732C279.608 537.032 280.175 536.465 280.875 536.465C281.576 536.465 282.143 537.032 282.143 537.732C282.143 538.432 281.576 539 280.875 539C280.175 539 279.608 538.432 279.608 537.732ZM280.875 382.666C280.175 382.666 279.608 383.234 279.608 383.934C279.608 384.634 280.175 385.201 280.875 385.201C281.576 385.201 282.143 384.634 282.143 383.934C282.143 383.234 281.576 382.666 280.875 382.666ZM312.565 203.938C312.565 203.238 313.133 202.671 313.833 202.671C314.533 202.671 315.1 203.238 315.1 203.938C315.1 204.638 314.533 205.206 313.833 205.206C313.133 205.206 312.565 204.638 312.565 203.938ZM313.833 26.0569C313.133 26.0569 312.565 26.6244 312.565 27.3244C312.565 28.0245 313.133 28.592 313.833 28.592C314.533 28.592 315.1 28.0245 315.1 27.3244C315.1 26.6244 314.533 26.0569 313.833 26.0569ZM182.427 27.3244C182.427 26.6244 182.995 26.0569 183.695 26.0569C184.395 26.0569 184.963 26.6244 184.963 27.3244C184.963 28.0245 184.395 28.592 183.695 28.592C182.995 28.592 182.427 28.0245 182.427 27.3244ZM413.548 26.0569C412.848 26.0569 412.28 26.6244 412.28 27.3244C412.28 28.0245 412.848 28.592 413.548 28.592C414.248 28.592 414.816 28.0245 414.816 27.3244C414.816 26.6244 414.248 26.0569 413.548 26.0569ZM412.28 156.615C412.28 155.915 412.848 155.348 413.548 155.348C414.248 155.348 414.816 155.915 414.816 156.615C414.816 157.315 414.248 157.883 413.548 157.883C412.848 157.883 412.28 157.315 412.28 156.615ZM413.548 259.289C412.848 259.289 412.28 259.856 412.28 260.556C412.28 261.256 412.848 261.824 413.548 261.824C414.248 261.824 414.816 261.256 414.816 260.556C414.816 259.856 414.248 259.289 413.548 259.289ZM217.92 240.276C217.92 239.576 218.487 239.008 219.187 239.008C219.887 239.008 220.455 239.576 220.455 240.276C220.455 240.976 219.887 241.543 219.187 241.543C218.487 241.543 217.92 240.976 217.92 240.276ZM217.497 329.429C216.797 329.429 216.23 329.996 216.23 330.696C216.23 331.396 216.797 331.964 217.497 331.964C218.197 331.964 218.765 331.396 218.765 330.696C218.765 329.996 218.197 329.429 217.497 329.429ZM216.23 494.635C216.23 493.935 216.797 493.367 217.497 493.367C218.197 493.367 218.765 493.935 218.765 494.635C218.765 495.335 218.197 495.903 217.497 495.903C216.797 495.903 216.23 495.335 216.23 494.635ZM271.158 288.021C269.758 288.021 268.623 289.156 268.623 290.556C268.623 291.956 269.758 293.091 271.158 293.091C272.558 293.091 273.693 291.956 273.693 290.556C273.693 289.156 272.558 288.021 271.158 288.021ZM184.963 280.416C184.963 279.016 186.098 277.881 187.498 277.881C188.898 277.881 190.033 279.016 190.033 280.416C190.033 281.816 188.898 282.951 187.498 282.951C186.098 282.951 184.963 281.816 184.963 280.416ZM425.802 277.881C424.402 277.881 423.267 279.016 423.267 280.416C423.267 281.816 424.402 282.951 425.802 282.951C427.202 282.951 428.337 281.816 428.337 280.416C428.337 279.016 427.202 277.881 425.802 277.881Z"
                    fill="white"
                    fillOpacity={0.5}
                />
                <path
                    opacity={0.4}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M-10.4435 235.676C-9.61898 245.567 -2.67392 255.319 10.3916 262.872L141.477 338.656C169.368 354.78 214.589 354.78 242.48 338.656L373.565 262.872C386.631 255.319 393.576 245.567 394.4 235.676C395.336 246.899 388.391 258.301 373.565 266.872L242.48 342.656C214.589 358.78 169.368 358.78 141.477 342.656L10.3916 266.872C-4.43412 258.301 -11.3792 246.899 -10.4435 235.676Z"
                    fill="#F5F4F2"
                />
                <path
                    opacity={0.6}
                    d="M9.39165 262.872C-18.4997 246.747 -18.4997 220.604 9.39165 204.48L140.477 128.696C168.368 112.571 213.589 112.571 241.48 128.696L372.565 204.48C400.456 220.604 400.456 246.747 372.565 262.872L241.48 338.656C213.589 354.78 168.368 354.78 140.477 338.656L9.39165 262.872Z"
                    fill="white"
                />
                <mask
                    id="f2e5ff76__mask0_27804_6153"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={-12}
                    y={55}
                    width={406}
                    height={296}
                >
                    <path
                        d="M8.9185 263.024C-18.9728 246.899 -18.9728 220.756 8.91851 204.631L91.6309 67.0935C119.522 50.9688 252.245 50.9688 280.137 67.0935L372.092 204.631C399.983 220.756 399.983 246.899 372.092 263.024L241.007 338.807C213.116 354.932 167.895 354.932 140.003 338.807L8.9185 263.024Z"
                        fill="#48CCE0"
                    />
                </mask>
                <g mask="url(#f2e5ff76__mask0_27804_6153)">
                    <rect
                        x={93}
                        y={117}
                        width={176}
                        height={229}
                        rx={21}
                        stroke="white"
                        strokeWidth={10}
                    />
                    <rect
                        x={97.5986}
                        y={121.188}
                        width={167.746}
                        height={360.061}
                        rx={17.7863}
                        fill="#F5F4F2"
                    />
                </g>
                <mask
                    id="f2e5ff76__mask1_27804_6153"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={97}
                    y={121}
                    width={167}
                    height={230}
                >
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M263.746 324.798L240.101 338.468C212.21 354.593 166.989 354.593 139.098 338.468L97 314.131V138.933C97 129.11 104.963 121.146 114.786 121.146H131.683L132.08 121.243C132.919 121.446 133.61 122.074 133.908 122.881C133.923 122.92 133.927 122.963 133.927 123.006L133.924 124.686C133.924 130.352 138.503 134.931 144.151 134.931H216.595C222.244 134.931 226.822 130.352 226.822 124.704L226.82 123.006C226.819 122.963 226.826 122.921 226.841 122.881C227.137 122.068 227.823 121.447 228.666 121.243L229.063 121.146H245.96C255.783 121.146 263.746 129.11 263.746 138.933V324.798Z"
                        fill="#48CCE0"
                    />
                </mask>
                <g mask="url(#f2e5ff76__mask1_27804_6153)">
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 131.32 406.949)"
                        fill="white"
                    />
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 -3.7666 406.949)"
                        fill="white"
                    />
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 -3.7666 270.639)"
                        fill="white"
                    />
                    <g filter="url(#f2e5ff76__filter1_d_27804_6153)">
                        <rect
                            x={112}
                            y={268}
                            width={56}
                            height={24}
                            rx={12}
                            fill="white"
                        />
                        <mask
                            id="f2e5ff76__mask2_27804_6153"
                            style={{
                                maskType: 'alpha',
                            }}
                            maskUnits="userSpaceOnUse"
                            x={117}
                            y={271}
                            width={45}
                            height={19}
                        >
                            <path
                                fillRule="evenodd"
                                clipRule="evenodd"
                                d="M125.203 284.295L126.167 279.697L130.087 279.697C130.103 279.872 130.11 280.049 130.11 280.227C130.11 283.586 127.388 286.308 124.029 286.308C120.671 286.308 117.948 283.586 117.948 280.227C117.948 276.869 120.671 274.146 124.029 274.146C124.537 274.146 125.029 274.209 125.5 274.326L124.7 278.165L120.322 278.165L119.993 279.697L124.371 279.697L123.386 284.295L125.203 284.295ZM127.173 275.021L126.517 278.165L129.752 278.165C129.276 276.845 128.356 275.737 127.173 275.021Z"
                                fill="url(#f2e5ff76__paint3_linear_27804_6153)"
                            />
                            <path
                                d="M142.67 281.158C142.67 281.748 142.564 282.291 142.353 282.787C142.143 283.271 141.842 283.693 141.452 284.051C141.062 284.399 140.598 284.673 140.061 284.874C139.523 285.063 138.928 285.158 138.274 285.158C137.515 285.158 136.888 285.074 136.393 284.905C135.908 284.736 135.486 284.547 135.128 284.336L135.128 282.391C135.497 282.634 135.924 282.866 136.409 283.087C136.904 283.298 137.478 283.403 138.132 283.403C138.87 283.403 139.428 283.198 139.808 282.787C140.198 282.375 140.393 281.864 140.393 281.253C140.393 280.642 140.24 280.157 139.934 279.798C139.639 279.44 139.175 279.261 138.543 279.261C138.153 279.261 137.832 279.324 137.579 279.45C137.326 279.577 137.136 279.719 137.009 279.877L135.349 279.877L135.349 273.664L142.132 273.664L142.132 275.498L137.294 275.498L137.294 278.075C137.473 277.938 137.71 277.817 138.005 277.711C138.301 277.595 138.685 277.537 139.16 277.537C140.245 277.537 141.099 277.859 141.721 278.502C142.353 279.134 142.67 280.02 142.67 281.158ZM151.13 285L143.636 285L143.636 282.913C144.595 282.196 145.407 281.564 146.071 281.016C146.746 280.468 147.288 279.967 147.699 279.514C148.111 279.06 148.406 278.639 148.585 278.249C148.775 277.848 148.869 277.432 148.869 277C148.869 276.473 148.711 276.062 148.395 275.767C148.089 275.461 147.652 275.308 147.083 275.308C146.514 275.308 145.966 275.429 145.439 275.672C144.912 275.914 144.416 276.236 143.952 276.636L143.952 274.644C144.395 274.307 144.885 274.038 145.423 273.838C145.96 273.627 146.614 273.521 147.383 273.521C147.952 273.521 148.469 273.601 148.933 273.759C149.396 273.906 149.792 274.128 150.118 274.423C150.456 274.718 150.714 275.081 150.893 275.514C151.083 275.935 151.178 276.415 151.178 276.952C151.178 277.501 151.067 278.017 150.846 278.502C150.624 278.987 150.292 279.472 149.85 279.956C149.418 280.441 148.875 280.947 148.221 281.474C147.578 281.991 146.825 282.56 145.96 283.182L151.13 283.182L151.13 285ZM157.103 285.158C156.439 285.158 155.817 285.037 155.237 284.794C154.668 284.541 154.167 284.173 153.735 283.688C153.314 283.192 152.982 282.581 152.739 281.854C152.497 281.126 152.376 280.283 152.376 279.324C152.376 278.365 152.497 277.527 152.739 276.81C152.982 276.083 153.314 275.477 153.735 274.992C154.167 274.507 154.668 274.143 155.237 273.901C155.817 273.648 156.439 273.521 157.103 273.521C157.767 273.521 158.389 273.643 158.969 273.885C159.548 274.128 160.049 274.491 160.471 274.976C160.892 275.461 161.224 276.067 161.467 276.794C161.709 277.511 161.83 278.344 161.83 279.292C161.83 280.241 161.709 281.079 161.467 281.806C161.224 282.534 160.892 283.15 160.471 283.656C160.049 284.151 159.548 284.526 158.969 284.779C158.389 285.032 157.767 285.158 157.103 285.158ZM157.087 283.403C157.446 283.403 157.778 283.329 158.083 283.182C158.389 283.034 158.652 282.802 158.874 282.486C159.095 282.159 159.269 281.738 159.395 281.221C159.522 280.705 159.585 280.078 159.585 279.34C159.585 278.602 159.522 277.975 159.395 277.458C159.269 276.931 159.095 276.51 158.874 276.193C158.652 275.867 158.389 275.63 158.083 275.482C157.778 275.334 157.451 275.261 157.103 275.261C156.755 275.261 156.428 275.334 156.123 275.482C155.828 275.63 155.569 275.867 155.348 276.193C155.127 276.51 154.953 276.931 154.826 277.458C154.7 277.975 154.636 278.602 154.636 279.34C154.636 280.078 154.7 280.705 154.826 281.221C154.953 281.738 155.127 282.159 155.348 282.486C155.569 282.802 155.828 283.034 156.123 283.182C156.418 283.329 156.739 283.403 157.087 283.403Z"
                                fill="url(#f2e5ff76__paint4_linear_27804_6153)"
                            />
                        </mask>
                        <g mask="url(#f2e5ff76__mask2_27804_6153)">
                            <rect
                                x={111}
                                y={271}
                                width={51}
                                height={21}
                                fill="url(#f2e5ff76__paint5_linear_27804_6153)"
                            />
                        </g>
                    </g>
                    <g clipPath="url(#f2e5ff76__clip2_27804_6153)">
                        <g clipPath="url(#f2e5ff76__clip3_27804_6153)">
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 131.32 271.949)"
                                fill="url(#f2e5ff76__paint6_radial_27804_6153)"
                            />
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 131.32 271.949)"
                                fill="url(#f2e5ff76__paint7_radial_27804_6153)"
                            />
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 131.32 271.949)"
                                fill="white"
                                fillOpacity={0.2}
                            />
                            <rect
                                x={172.32}
                                y={192.625}
                                width={86}
                                height={80}
                                fill="url(#f2e5ff76__pattern0)"
                            />
                        </g>
                    </g>
                    <path
                        d="M151.868 164.559V173.987H149.609V164.559H146.214V162.664H155.263V164.559H151.868ZM160.636 173.893C160.457 174.387 160.267 174.824 160.067 175.203C159.867 175.582 159.63 175.898 159.357 176.151C159.093 176.414 158.778 176.609 158.409 176.735C158.041 176.872 157.598 176.94 157.082 176.94C156.767 176.94 156.488 176.914 156.245 176.862C156.003 176.819 155.766 176.746 155.535 176.64V174.745C155.714 174.872 155.93 174.972 156.182 175.045C156.446 175.13 156.73 175.172 157.035 175.172C157.372 175.172 157.646 175.109 157.856 174.982C158.067 174.866 158.246 174.687 158.393 174.445L155.124 165.791H157.446L159.499 171.713L161.504 165.791H163.51L160.636 173.893ZM169.49 174.145C168.88 174.145 168.353 174.014 167.911 173.75C167.48 173.477 167.127 173.113 166.853 172.661V176.783H164.674V165.791H166.711L166.822 167.133C167.095 166.66 167.453 166.291 167.895 166.028C168.338 165.765 168.875 165.633 169.506 165.633C169.991 165.633 170.449 165.723 170.88 165.902C171.322 166.07 171.707 166.333 172.033 166.691C172.37 167.039 172.633 167.481 172.823 168.018C173.012 168.544 173.107 169.165 173.107 169.881C173.107 170.608 173.007 171.239 172.807 171.776C172.617 172.303 172.359 172.745 172.033 173.103C171.707 173.45 171.322 173.714 170.88 173.893C170.438 174.061 169.975 174.145 169.49 174.145ZM168.875 172.392C169.464 172.392 169.943 172.187 170.312 171.776C170.68 171.366 170.864 170.734 170.864 169.881C170.864 169.039 170.68 168.413 170.312 168.002C169.943 167.581 169.469 167.37 168.89 167.37C168.301 167.37 167.811 167.581 167.422 168.002C167.032 168.413 166.837 169.039 166.837 169.881C166.837 170.734 167.032 171.366 167.422 171.776C167.811 172.187 168.295 172.392 168.875 172.392ZM181.398 171.081C181.398 171.555 181.308 171.976 181.13 172.345C180.961 172.703 180.724 173.008 180.419 173.261C180.114 173.503 179.745 173.687 179.313 173.814C178.892 173.929 178.429 173.987 177.924 173.987H174.544V165.791H176.723V168.286H177.955C179.04 168.286 179.882 168.523 180.482 168.997C181.093 169.46 181.398 170.155 181.398 171.081ZM184.304 173.987H182.109V165.791H184.304V173.987ZM176.723 169.944V172.345H177.671C178.113 172.345 178.466 172.255 178.729 172.076C179.003 171.887 179.14 171.576 179.14 171.145C179.14 170.724 179.013 170.418 178.761 170.229C178.518 170.039 178.161 169.944 177.687 169.944H176.723ZM150.794 192.145C150.109 192.145 149.493 192.05 148.946 191.861C148.409 191.661 147.951 191.382 147.572 191.024C147.193 190.655 146.898 190.208 146.688 189.682C146.488 189.155 146.388 188.555 146.388 187.881C146.388 187.218 146.488 186.623 146.688 186.097C146.898 185.57 147.193 185.128 147.572 184.77C147.951 184.402 148.414 184.123 148.962 183.933C149.509 183.733 150.125 183.633 150.809 183.633C151.441 183.633 151.968 183.702 152.389 183.838C152.81 183.965 153.141 184.117 153.384 184.296V186.034C153.068 185.833 152.731 185.676 152.373 185.56C152.015 185.433 151.557 185.37 150.999 185.37C149.42 185.37 148.63 186.207 148.63 187.881C148.63 189.555 149.409 190.392 150.967 190.392C151.546 190.392 152.015 190.334 152.373 190.219C152.731 190.092 153.068 189.934 153.384 189.745V191.466C153.141 191.645 152.805 191.803 152.373 191.94C151.952 192.077 151.425 192.145 150.794 192.145ZM160.978 188.797H160.268V191.987H158.088V183.791H160.268V187.06H161.01L163.41 183.791H165.606L162.731 187.676L165.811 191.987H163.253L160.978 188.797ZM173.508 191.45C173.382 191.524 173.234 191.603 173.066 191.687C172.908 191.761 172.713 191.835 172.482 191.908C172.26 191.972 171.997 192.024 171.692 192.066C171.397 192.119 171.044 192.145 170.634 192.145C169.033 192.145 167.849 191.771 167.08 191.024C166.312 190.276 165.928 189.229 165.928 187.881C165.928 187.218 166.028 186.623 166.228 186.097C166.438 185.57 166.728 185.128 167.096 184.77C167.465 184.402 167.902 184.123 168.407 183.933C168.923 183.733 169.491 183.633 170.113 183.633C170.744 183.633 171.313 183.738 171.818 183.949C172.324 184.149 172.739 184.449 173.066 184.849C173.403 185.249 173.634 185.755 173.761 186.365C173.887 186.976 173.887 187.681 173.761 188.481H168.202C168.286 189.124 168.518 189.608 168.897 189.934C169.286 190.25 169.902 190.408 170.744 190.408C171.418 190.408 171.966 190.334 172.387 190.187C172.818 190.04 173.192 189.887 173.508 189.729V191.45ZM170.144 185.26C169.66 185.26 169.255 185.407 168.928 185.702C168.602 185.997 168.381 186.423 168.265 186.981H171.676C171.687 186.402 171.56 185.97 171.297 185.686C171.034 185.402 170.65 185.26 170.144 185.26ZM186.21 191.987H175.377V183.791H177.556V190.25H179.704V183.791H181.899V190.25H184.015V183.791H186.21V191.987ZM196.028 187.929C196.028 188.613 195.923 189.218 195.712 189.745C195.502 190.271 195.207 190.713 194.828 191.071C194.459 191.429 194.017 191.698 193.501 191.877C192.996 192.056 192.448 192.145 191.859 192.145C191.259 192.145 190.706 192.045 190.201 191.845C189.695 191.635 189.258 191.329 188.89 190.929C188.521 190.529 188.232 190.029 188.021 189.429C187.811 188.818 187.705 188.108 187.705 187.297C187.705 186.486 187.742 185.776 187.816 185.165C187.89 184.544 188.006 184.002 188.163 183.538C188.332 183.065 188.542 182.659 188.795 182.322C189.048 181.985 189.348 181.691 189.695 181.438C190.138 181.133 190.617 180.927 191.132 180.822C191.659 180.706 192.217 180.633 192.806 180.601C193.217 180.59 193.564 180.575 193.849 180.554C194.133 180.522 194.375 180.485 194.575 180.443C194.786 180.401 194.959 180.359 195.096 180.317C195.233 180.264 195.36 180.206 195.475 180.143V182.054C195.36 182.117 195.233 182.175 195.096 182.228C194.97 182.27 194.807 182.307 194.607 182.338C194.417 182.37 194.186 182.401 193.912 182.433C193.638 182.454 193.307 182.48 192.917 182.512C192.422 182.554 191.98 182.612 191.59 182.686C191.201 182.749 190.864 182.896 190.58 183.128C190.274 183.37 190.032 183.702 189.853 184.123C189.685 184.533 189.564 185.049 189.49 185.67C190.006 184.512 191.017 183.933 192.522 183.933C192.975 183.933 193.412 184.023 193.833 184.202C194.254 184.381 194.628 184.644 194.954 184.991C195.281 185.328 195.539 185.744 195.728 186.239C195.928 186.734 196.028 187.297 196.028 187.929ZM191.859 190.392C192.417 190.392 192.875 190.197 193.233 189.808C193.591 189.418 193.77 188.813 193.77 187.992C193.77 187.192 193.591 186.597 193.233 186.207C192.875 185.807 192.417 185.607 191.859 185.607C191.311 185.607 190.859 185.807 190.501 186.207C190.143 186.597 189.964 187.186 189.964 187.976C189.964 188.797 190.143 189.408 190.501 189.808C190.859 190.197 191.311 190.392 191.859 190.392ZM204.081 187.881C204.081 188.555 203.975 189.155 203.765 189.682C203.565 190.208 203.275 190.655 202.896 191.024C202.517 191.382 202.054 191.661 201.506 191.861C200.959 192.05 200.348 192.145 199.674 192.145C199.032 192.145 198.501 192.077 198.079 191.94C197.658 191.803 197.321 191.645 197.069 191.466V189.745C197.227 189.84 197.385 189.929 197.542 190.013C197.711 190.087 197.89 190.155 198.079 190.219C198.269 190.271 198.479 190.313 198.711 190.345C198.943 190.376 199.206 190.392 199.501 190.392C200.806 190.392 201.57 189.818 201.791 188.671H198.632V186.95H201.759C201.506 185.897 200.754 185.37 199.501 185.37C198.932 185.37 198.469 185.428 198.111 185.544C197.764 185.66 197.432 185.823 197.116 186.034V184.296C197.358 184.117 197.69 183.965 198.111 183.838C198.543 183.702 199.074 183.633 199.706 183.633C200.38 183.633 200.985 183.733 201.522 183.933C202.07 184.123 202.533 184.402 202.912 184.77C203.291 185.128 203.58 185.57 203.78 186.097C203.981 186.623 204.081 187.218 204.081 187.881ZM208.402 188.797H207.691V191.987H205.512V183.791H207.691V187.06H208.434L210.834 183.791H213.029L210.155 187.676L213.235 191.987H210.676L208.402 188.797ZM217.489 192.145C216.899 192.145 216.352 192.056 215.847 191.877C215.352 191.687 214.915 191.414 214.536 191.056C214.167 190.687 213.878 190.24 213.667 189.713C213.457 189.176 213.351 188.566 213.351 187.881C213.351 187.197 213.457 186.592 213.667 186.065C213.878 185.528 214.167 185.081 214.536 184.723C214.915 184.365 215.352 184.096 215.847 183.917C216.352 183.728 216.899 183.633 217.489 183.633C218.079 183.633 218.626 183.728 219.131 183.917C219.647 184.096 220.089 184.365 220.458 184.723C220.837 185.081 221.132 185.528 221.342 186.065C221.563 186.592 221.674 187.197 221.674 187.881C221.674 188.566 221.563 189.176 221.342 189.713C221.132 190.24 220.837 190.687 220.458 191.056C220.089 191.414 219.647 191.687 219.131 191.877C218.626 192.056 218.079 192.145 217.489 192.145ZM217.489 190.392C218.058 190.392 218.521 190.187 218.879 189.776C219.237 189.366 219.416 188.734 219.416 187.881C219.416 187.039 219.237 186.413 218.879 186.002C218.521 185.591 218.058 185.386 217.489 185.386C216.952 185.386 216.499 185.591 216.131 186.002C215.773 186.413 215.594 187.039 215.594 187.881C215.594 188.734 215.773 189.366 216.131 189.776C216.499 190.187 216.952 190.392 217.489 190.392ZM230.705 186.57L228.573 191.308H227.041L225.051 186.602V191.987H223.109V183.791H225.967L227.973 188.545L230.105 183.791H232.885V191.987H230.705V186.57Z"
                        fill="white"
                    />
                </g>
                <g filter="url(#f2e5ff76__filter2_d_27804_6153)">
                    <rect
                        x={240}
                        y={179}
                        width={75}
                        height={27}
                        rx={13.5}
                        fill="white"
                    />
                    <mask
                        id="f2e5ff76__mask3_27804_6153"
                        style={{
                            maskType: 'alpha',
                        }}
                        maskUnits="userSpaceOnUse"
                        x={246}
                        y={182}
                        width={62}
                        height={21}
                    >
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M254.656 196.968L255.715 191.916L260.023 191.916C260.04 192.108 260.048 192.303 260.048 192.499C260.048 196.19 257.057 199.182 253.366 199.182C249.675 199.182 246.683 196.19 246.683 192.499C246.683 188.808 249.675 185.816 253.366 185.816C253.923 185.816 254.465 185.885 254.983 186.013L254.103 190.232L249.292 190.232L248.931 191.916L253.742 191.916L252.66 196.968L254.656 196.968ZM256.82 186.777L256.1 190.232L259.654 190.232C259.131 188.782 258.121 187.564 256.82 186.777Z"
                            fill="url(#f2e5ff76__paint8_linear_27804_6153)"
                        />
                        <path
                            d="M271.592 195.29L271.592 198L269.194 198L269.194 195.29L263.564 195.29L263.564 193.5L269.09 185.542L271.592 185.542L271.592 193.396L273.103 193.396L273.103 195.29L271.592 195.29ZM269.194 193.396L269.194 188.461L265.788 193.396L269.194 193.396ZM283.967 193.778C283.967 194.496 283.834 195.127 283.567 195.672C283.313 196.216 282.965 196.674 282.525 197.044C282.096 197.415 281.598 197.699 281.031 197.896C280.463 198.081 279.878 198.174 279.276 198.174C278.581 198.174 277.938 198.069 277.347 197.861C276.768 197.653 276.27 197.317 275.853 196.853C275.436 196.378 275.112 195.776 274.88 195.046C274.648 194.305 274.532 193.401 274.532 192.336C274.532 191.386 274.642 190.494 274.863 189.66C275.083 188.814 275.419 188.073 275.87 187.436C276.334 186.799 276.919 186.295 277.625 185.924C278.343 185.554 279.195 185.368 280.179 185.368C280.816 185.368 281.384 185.432 281.882 185.56C282.38 185.687 282.809 185.866 283.168 186.098L283.168 188.096C282.693 187.818 282.212 187.616 281.726 187.488C281.251 187.361 280.787 187.297 280.336 187.297C279.351 187.297 278.587 187.61 278.042 188.235C277.509 188.849 277.168 189.706 277.017 190.807C277.399 190.378 277.834 190.071 278.32 189.886C278.818 189.689 279.363 189.591 279.953 189.591C280.475 189.591 280.979 189.672 281.465 189.834C281.952 189.996 282.38 190.251 282.751 190.598C283.121 190.934 283.417 191.369 283.637 191.901C283.857 192.423 283.967 193.048 283.967 193.778ZM279.293 196.263C279.583 196.263 279.855 196.21 280.11 196.106C280.376 196.002 280.608 195.851 280.805 195.654C281.013 195.446 281.175 195.191 281.291 194.89C281.419 194.577 281.482 194.218 281.482 193.813C281.482 193.419 281.424 193.077 281.309 192.788C281.193 192.486 281.036 192.243 280.84 192.058C280.654 191.861 280.434 191.716 280.179 191.623C279.924 191.531 279.658 191.484 279.38 191.484C279.079 191.484 278.795 191.531 278.529 191.623C278.262 191.716 278.025 191.861 277.816 192.058C277.619 192.243 277.457 192.486 277.33 192.788C277.214 193.077 277.156 193.419 277.156 193.813C277.133 194.612 277.33 195.22 277.747 195.637C278.164 196.054 278.679 196.263 279.293 196.263ZM290.586 198.174C289.856 198.174 289.173 198.041 288.536 197.774C287.91 197.496 287.36 197.091 286.885 196.558C286.422 196.013 286.057 195.342 285.791 194.542C285.524 193.743 285.391 192.816 285.391 191.762C285.391 190.708 285.524 189.787 285.791 189C286.057 188.201 286.422 187.534 286.885 187.002C287.36 186.469 287.91 186.069 288.536 185.803C289.173 185.525 289.856 185.386 290.586 185.386C291.316 185.386 291.999 185.519 292.636 185.785C293.273 186.052 293.824 186.451 294.287 186.984C294.75 187.517 295.115 188.183 295.382 188.982C295.648 189.77 295.781 190.685 295.781 191.728C295.781 192.77 295.648 193.691 295.382 194.49C295.115 195.29 294.75 195.967 294.287 196.523C293.824 197.068 293.273 197.479 292.636 197.757C291.999 198.035 291.316 198.174 290.586 198.174ZM290.569 196.245C290.963 196.245 291.327 196.164 291.663 196.002C291.999 195.84 292.289 195.585 292.532 195.237C292.775 194.878 292.966 194.415 293.105 193.847C293.244 193.28 293.314 192.591 293.314 191.78C293.314 190.969 293.244 190.28 293.105 189.712C292.966 189.133 292.775 188.67 292.532 188.322C292.289 187.963 291.999 187.702 291.663 187.54C291.327 187.378 290.968 187.297 290.586 187.297C290.204 187.297 289.845 187.378 289.509 187.54C289.184 187.702 288.901 187.963 288.657 188.322C288.414 188.67 288.223 189.133 288.084 189.712C287.945 190.28 287.876 190.969 287.876 191.78C287.876 192.591 287.945 193.28 288.084 193.847C288.223 194.415 288.414 194.878 288.657 195.237C288.901 195.585 289.184 195.84 289.509 196.002C289.833 196.164 290.186 196.245 290.569 196.245ZM302.43 198.174C301.7 198.174 301.016 198.041 300.379 197.774C299.754 197.496 299.204 197.091 298.729 196.558C298.265 196.013 297.9 195.342 297.634 194.542C297.368 193.743 297.234 192.816 297.234 191.762C297.234 190.708 297.368 189.787 297.634 189C297.9 188.201 298.265 187.534 298.729 187.002C299.204 186.469 299.754 186.069 300.379 185.803C301.016 185.525 301.7 185.386 302.43 185.386C303.159 185.386 303.843 185.519 304.48 185.785C305.117 186.052 305.667 186.451 306.13 186.984C306.594 187.517 306.959 188.183 307.225 188.982C307.491 189.77 307.625 190.685 307.625 191.728C307.625 192.77 307.491 193.691 307.225 194.49C306.959 195.29 306.594 195.967 306.13 196.523C305.667 197.068 305.117 197.479 304.48 197.757C303.843 198.035 303.159 198.174 302.43 198.174ZM302.412 196.245C302.806 196.245 303.171 196.164 303.507 196.002C303.843 195.84 304.132 195.585 304.376 195.237C304.619 194.878 304.81 194.415 304.949 193.847C305.088 193.28 305.157 192.591 305.157 191.78C305.157 190.969 305.088 190.28 304.949 189.712C304.81 189.133 304.619 188.67 304.376 188.322C304.132 187.963 303.843 187.702 303.507 187.54C303.171 187.378 302.812 187.297 302.43 187.297C302.047 187.297 301.688 187.378 301.352 187.54C301.028 187.702 300.744 187.963 300.501 188.322C300.258 188.67 300.067 189.133 299.928 189.712C299.789 190.28 299.719 190.969 299.719 191.78C299.719 192.591 299.789 193.28 299.928 193.847C300.067 194.415 300.258 194.878 300.501 195.237C300.744 195.585 301.028 195.84 301.352 196.002C301.677 196.164 302.03 196.245 302.412 196.245Z"
                            fill="url(#f2e5ff76__paint9_linear_27804_6153)"
                        />
                    </mask>
                    <g mask="url(#f2e5ff76__mask3_27804_6153)">
                        <rect
                            x={233}
                            y={182}
                            width={82}
                            height={21}
                            fill="url(#f2e5ff76__paint10_linear_27804_6153)"
                        />
                    </g>
                </g>
                <g filter="url(#f2e5ff76__filter3_d_27804_6153)">
                    <rect
                        x={103}
                        y={132}
                        width={67}
                        height={25}
                        rx={12.5}
                        fill="white"
                    />
                    <mask
                        id="f2e5ff76__mask4_27804_6153"
                        style={{
                            maskType: 'alpha',
                        }}
                        maskUnits="userSpaceOnUse"
                        x={108}
                        y={134}
                        width={57}
                        height={20}
                    >
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M116.517 148.572L117.526 143.759L121.631 143.759C121.647 143.942 121.655 144.128 121.655 144.315C121.655 147.831 118.805 150.681 115.289 150.681C111.774 150.681 108.923 147.831 108.923 144.315C108.923 140.799 111.774 137.949 115.289 137.949C115.82 137.949 116.335 138.014 116.828 138.136L115.99 142.155L111.407 142.155L111.063 143.759L115.647 143.759L114.615 148.572L116.517 148.572ZM118.579 138.864L117.892 142.155L121.28 142.155C120.781 140.773 119.818 139.613 118.579 138.864Z"
                            fill="url(#f2e5ff76__paint11_linear_27804_6153)"
                        />
                        <path
                            d="M131.686 150L129.385 150L129.385 140.648L126.936 143.081L126.936 140.847L129.65 138.132L131.686 138.132L131.686 150ZM141.57 150L133.724 150L133.724 147.815C134.729 147.065 135.578 146.403 136.273 145.829C136.98 145.255 137.548 144.731 137.978 144.257C138.409 143.782 138.718 143.341 138.905 142.932C139.104 142.513 139.203 142.077 139.203 141.625C139.203 141.073 139.038 140.643 138.706 140.334C138.386 140.014 137.929 139.854 137.333 139.854C136.737 139.854 136.163 139.981 135.611 140.234C135.06 140.488 134.541 140.825 134.055 141.244L134.055 139.159C134.519 138.806 135.032 138.524 135.595 138.314C136.158 138.094 136.842 137.983 137.647 137.983C138.243 137.983 138.784 138.066 139.269 138.232C139.755 138.386 140.169 138.618 140.511 138.927C140.864 139.236 141.134 139.617 141.322 140.069C141.52 140.51 141.62 141.012 141.62 141.575C141.62 142.149 141.504 142.69 141.272 143.197C141.04 143.705 140.693 144.212 140.229 144.72C139.777 145.228 139.209 145.757 138.524 146.309C137.851 146.85 137.062 147.446 136.158 148.097L141.57 148.097L141.57 150ZM147.822 150.166C147.127 150.166 146.476 150.039 145.869 149.785C145.274 149.52 144.749 149.134 144.297 148.626C143.856 148.108 143.508 147.468 143.254 146.706C143 145.945 142.874 145.062 142.874 144.058C142.874 143.054 143 142.177 143.254 141.426C143.508 140.665 143.856 140.03 144.297 139.523C144.749 139.015 145.274 138.634 145.869 138.381C146.476 138.116 147.127 137.983 147.822 137.983C148.518 137.983 149.169 138.11 149.776 138.364C150.382 138.618 150.907 138.999 151.348 139.506C151.789 140.014 152.137 140.648 152.391 141.41C152.645 142.16 152.771 143.032 152.771 144.025C152.771 145.018 152.645 145.895 152.391 146.657C152.137 147.418 151.789 148.063 151.348 148.593C150.907 149.112 150.382 149.503 149.776 149.768C149.169 150.033 148.518 150.166 147.822 150.166ZM147.806 148.328C148.181 148.328 148.529 148.251 148.849 148.097C149.169 147.942 149.445 147.699 149.676 147.368C149.908 147.026 150.09 146.585 150.222 146.044C150.355 145.503 150.421 144.847 150.421 144.074C150.421 143.302 150.355 142.646 150.222 142.105C150.09 141.553 149.908 141.112 149.676 140.781C149.445 140.439 149.169 140.19 148.849 140.036C148.529 139.881 148.187 139.804 147.822 139.804C147.458 139.804 147.116 139.881 146.796 140.036C146.487 140.19 146.217 140.439 145.985 140.781C145.754 141.112 145.571 141.553 145.439 142.105C145.307 142.646 145.24 143.302 145.24 144.074C145.24 144.847 145.307 145.503 145.439 146.044C145.571 146.585 145.754 147.026 145.985 147.368C146.217 147.699 146.487 147.942 146.796 148.097C147.105 148.251 147.442 148.328 147.806 148.328ZM159.105 150.166C158.41 150.166 157.759 150.039 157.152 149.785C156.556 149.52 156.032 149.134 155.579 148.626C155.138 148.108 154.79 147.468 154.537 146.706C154.283 145.945 154.156 145.062 154.156 144.058C154.156 143.054 154.283 142.177 154.537 141.426C154.79 140.665 155.138 140.03 155.579 139.523C156.032 139.015 156.556 138.634 157.152 138.381C157.759 138.116 158.41 137.983 159.105 137.983C159.8 137.983 160.451 138.11 161.058 138.364C161.665 138.618 162.189 138.999 162.63 139.506C163.072 140.014 163.419 140.648 163.673 141.41C163.927 142.16 164.054 143.032 164.054 144.025C164.054 145.018 163.927 145.895 163.673 146.657C163.419 147.418 163.072 148.063 162.63 148.593C162.189 149.112 161.665 149.503 161.058 149.768C160.451 150.033 159.8 150.166 159.105 150.166ZM159.088 148.328C159.463 148.328 159.811 148.251 160.131 148.097C160.451 147.942 160.727 147.699 160.959 147.368C161.19 147.026 161.372 146.585 161.505 146.044C161.637 145.503 161.703 144.847 161.703 144.074C161.703 143.302 161.637 142.646 161.505 142.105C161.372 141.553 161.19 141.112 160.959 140.781C160.727 140.439 160.451 140.19 160.131 140.036C159.811 139.881 159.469 139.804 159.105 139.804C158.741 139.804 158.399 139.881 158.079 140.036C157.77 140.19 157.499 140.439 157.268 140.781C157.036 141.112 156.854 141.553 156.721 142.105C156.589 142.646 156.523 143.302 156.523 144.074C156.523 144.847 156.589 145.503 156.721 146.044C156.854 146.585 157.036 147.026 157.268 147.368C157.499 147.699 157.77 147.942 158.079 148.097C158.388 148.251 158.724 148.328 159.088 148.328Z"
                            fill="url(#f2e5ff76__paint12_linear_27804_6153)"
                        />
                    </mask>
                    <g mask="url(#f2e5ff76__mask4_27804_6153)">
                        <rect
                            x={98}
                            y={132}
                            width={69}
                            height={21}
                            fill="url(#f2e5ff76__paint13_linear_27804_6153)"
                        />
                    </g>
                </g>
            </g>
        </g>
        <defs>
            <filter
                id="f2e5ff76__filter0_f_27804_6153"
                x={-259.458}
                y={-121.511}
                width={954.126}
                height={752.536}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feGaussianBlur
                    stdDeviation={39.7462}
                    result="effect1_foregroundBlur_27804_6153"
                />
            </filter>
            <filter
                id="f2e5ff76__filter1_d_27804_6153"
                x={87.676}
                y={253.406}
                width={104.648}
                height={72.648}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={9.72961} />
                <feGaussianBlur stdDeviation={12.162} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <pattern
                id="f2e5ff76__pattern0"
                patternContentUnits="objectBoundingBox"
                width={1}
                height={1}
            >
                <use
                    xlinkHref="#f2e5ff76__image0_27804_6153"
                    transform="scale(0.00581395 0.00625)"
                />
            </pattern>
            <filter
                id="f2e5ff76__filter2_d_27804_6153"
                x={217.569}
                y={165.196}
                width={119.862}
                height={71.8621}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={8.62733} />
                <feGaussianBlur stdDeviation={11.2155} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.555272 0 0 0 0 0.810518 0 0 0 0 0.954094 0 0 0 0.34 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <filter
                id="f2e5ff76__filter3_d_27804_6153"
                x={77.5358}
                y={116.721}
                width={117.928}
                height={75.9284}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={10.1857} />
                <feGaussianBlur stdDeviation={12.7321} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <radialGradient
                id="f2e5ff76__paint0_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(-175.546 -52.532) rotate(38.1137) scale(995.825 1470.7)"
            >
                <stop offset={0.0755925} stopColor="#48CCE0" />
                <stop offset={0.307872} stopColor="#428BEB" />
                <stop offset={0.647543} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="f2e5ff76__paint1_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(607.957 562.115) rotate(-178.458) scale(784.106 2064.35)"
            >
                <stop offset={0.109375} stopColor="#FCAB14" />
                <stop offset={0.291667} stopColor="#FA6641" />
                <stop offset={0.53125} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="f2e5ff76__paint2_linear_27804_6153"
                x1={216}
                y1={129.5}
                x2={215.215}
                y2={207.492}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint3_linear_27804_6153"
                x1={117.948}
                y1={280.227}
                x2={148.962}
                y2={280.227}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint4_linear_27804_6153"
                x1={135.067}
                y1={280}
                x2={164}
                y2={280}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint5_linear_27804_6153"
                x1={162}
                y1={281.5}
                x2={111}
                y2={281.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <radialGradient
                id="f2e5ff76__paint6_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(0 126.325) rotate(-45) scale(178.651 270.385)"
            >
                <stop stopColor="#48CCE0" />
                <stop offset={0.288462} stopColor="#428BEB" />
                <stop offset={0.601763} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="f2e5ff76__paint7_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(126.325) rotate(-180) scale(124.784 353.993)"
            >
                <stop stopColor="#FCAB14" />
                <stop offset={0.159058} stopColor="#FA6641" />
                <stop offset={0.402081} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="f2e5ff76__paint8_linear_27804_6153"
                x1={246.683}
                y1={192.499}
                x2={280.765}
                y2={192.499}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint9_linear_27804_6153"
                x1={265.788}
                y1={192.5}
                x2={308.722}
                y2={192.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint10_linear_27804_6153"
                x1={315}
                y1={192.5}
                x2={233}
                y2={192.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint11_linear_27804_6153"
                x1={108.923}
                y1={144.315}
                x2={141.39}
                y2={144.315}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint12_linear_27804_6153"
                x1={126.867}
                y1={144.5}
                x2={167}
                y2={144.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint13_linear_27804_6153"
                x1={167}
                y1={142.5}
                x2={98}
                y2={142.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EE7D38" />
                <stop offset={0.254795} stopColor="#EC5D5D" />
                <stop offset={0.494392} stopColor="#B244CA" />
                <stop offset={0.765241} stopColor="#5D70C0" />
                <stop offset={1} stopColor="#51B5E6" />
            </linearGradient>
            <clipPath id="f2e5ff76__clip0_27804_6153">
                <rect width={375} height={378} fill="white" />
            </clipPath>
            <clipPath id="f2e5ff76__clip1_27804_6153">
                <rect
                    width={800}
                    height={300}
                    fill="white"
                    transform="translate(-137 78)"
                />
            </clipPath>
            <clipPath id="f2e5ff76__clip2_27804_6153">
                <rect
                    x={131.32}
                    y={145.625}
                    width={126.325}
                    height={126.325}
                    rx={19.4369}
                    fill="white"
                />
            </clipPath>
            <clipPath id="f2e5ff76__clip3_27804_6153">
                <rect
                    width={126.34}
                    height={126.34}
                    fill="white"
                    transform="translate(131.32 145.625)"
                />
            </clipPath>
            <image
                id="f2e5ff76__image0_27804_6153"
                width={172}
                height={160}
                xlinkHref="data:image/png;base64,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"
            />
        </defs>
    </svg>
);

export default PlusPromoM;
