import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo10Xs = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 137 102"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#4fc3b553__clip0_19033_0)">
            <path
                opacity={0.5}
                d="M233.483 111.094L211.022 36.5149C211.022 36.5149 207.874 13.0055 186.821 21.2684C172.704 26.8126 165.769 31.024 155.144 37.048C150.766 39.5535 146.487 40.9929 142.995 41.8991C143.486 33.4763 141.175 24.1471 132.468 23.6674C127.304 23.3475 119.089 23.9872 115.646 27.7189C118.253 19.4026 109.568 8.12726 100.173 7.221C73.0777 4.6072 53.2952 25.4668 46.1629 54.5203C33.9151 53.2409 21.8776 68.0076 32.3055 76.537C21.4349 75.2576 1.2345 96.8609 0.29993 109.069C0.152366 110.242 0.890187 111.095 2.11989 111.095C17.3682 112.001 32.6657 112.534 47.914 113.547C54.3085 112.854 60.7029 112.001 67.0482 110.935C105.169 111.254 233.483 111.094 233.483 111.094Z"
                fill="url(#4fc3b553__paint0_linear_19033_0)"
            />
            <path
                d="M84.3451 29.7218C84.3261 34.1807 85.1395 39.4194 87.959 41.9906C88.0438 42.0788 88.1074 42.185 88.1449 42.3011C88.1825 42.4173 88.193 42.5405 88.1758 42.6613C88.1586 42.7821 88.114 42.8975 88.0455 42.9987C87.9769 43.0999 87.8862 43.1843 87.7801 43.2456C83.4632 45.5055 80.0487 49.1607 78.0991 53.6091C78.0425 53.7517 77.9367 53.8695 77.8006 53.9414C77.6645 54.0133 77.5071 54.0345 77.3567 54.0013C77.2063 53.9681 77.0727 53.8826 76.98 53.7602C76.8872 53.6377 76.8415 53.4864 76.8508 53.3334C76.6131 47.3175 74.8115 42.4602 73.4374 40.4899C73.3703 40.3926 73.3261 40.2815 73.3081 40.1649C73.29 40.0483 73.2985 39.9292 73.3329 39.8163C73.3674 39.7034 73.4269 39.5997 73.5071 39.5127C73.5872 39.4258 73.686 39.3579 73.7961 39.3141C76.4934 38.362 80.3607 35.1049 83.0955 29.4089C83.1534 29.2629 83.2628 29.1429 83.4032 29.0713C83.5436 28.9996 83.7054 28.9812 83.8584 29.0196C84.0114 29.0579 84.1451 29.1502 84.2347 29.2795C84.3243 29.4087 84.3635 29.5659 84.3451 29.7218Z"
                fill="white"
            />
            <path
                d="M87.781 43.2495C83.4626 45.5072 80.0467 49.1616 78.0964 53.6099C78.0365 53.7634 77.9192 53.8878 77.7689 53.957C77.6187 54.0262 77.4474 54.0348 77.291 53.9809V53.9745C77.6808 53.0599 80.1944 42.6931 78.746 40.2501C81.1038 39.0669 83.3057 31.3604 83.9228 29.0454C84.0545 29.1017 84.1657 29.1969 84.2412 29.3182C84.3167 29.4394 84.3529 29.5809 84.345 29.7233C84.3255 34.1808 85.1374 39.4187 87.9564 41.996C88.0414 42.0838 88.1052 42.1896 88.1431 42.3055C88.181 42.4215 88.1919 42.5444 88.175 42.6651C88.1581 42.7859 88.1139 42.9012 88.0456 43.0024C87.9774 43.1036 87.8869 43.1881 87.781 43.2495Z"
                fill="#D8E5FF"
            />
            <path
                d="M77.2905 53.9741V53.9805C77.1593 53.9308 77.0465 53.8422 76.9676 53.7266C76.8886 53.6111 76.8471 53.4743 76.8488 53.3346C76.615 47.3165 74.8093 42.4625 73.4388 40.4926C73.3573 40.3775 73.308 40.2429 73.2959 40.1025C75.0877 40.4857 76.9354 40.5356 78.7455 40.2497C80.1939 42.6927 77.6803 53.0595 77.2905 53.9741Z"
                fill="#ECF1FF"
            />
            <path
                d="M124.758 59.8857L107.403 38.6454C104.953 35.6475 100.709 34.8337 97.3241 36.7131L68.7337 52.5889C68.7337 52.5889 67.6419 66.4274 66.2139 79.3018C66.2559 80.7695 69.7838 80.9371 71.0017 81.7339C75.9573 84.8371 86.1206 91.4629 111.739 89.9113C113.419 89.8274 116.526 90.5405 117.156 88.9889C118.458 83.621 121.398 73.9758 124.758 59.8857Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M102.717 51.0171L101.652 56.6048L89.6785 85.3416L88.082 84.0112L102.717 51.0171Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M111.099 28.3219C108.891 31.9678 105.973 35.9733 105.338 36.9747C105.958 37.748 106.042 38.3908 105.745 38.9528C105.291 39.8144 104.279 40.1943 103.41 39.8755C99.4832 46.1942 87.9184 58.0642 82.188 62.7153C83.2608 64.3972 92.8557 74.7087 96.1021 77.5472C96.5893 77.9731 97.3074 77.9906 97.8137 77.5873C107.32 70.0107 119.307 55.0183 120.661 52.8266C120.743 52.6941 120.741 52.534 120.663 52.3989C120.413 51.9618 120.199 51.1427 120.484 50.5685C120.869 49.7887 121.805 49.4603 122.754 49.5474C122.913 49.562 123.067 49.4994 123.154 49.3668C124.02 48.0595 127.158 42.2581 128.683 39.1022C128.978 38.4926 128.768 37.7643 128.194 37.405C124.827 35.2959 116.276 29.8646 112.917 27.8642C112.288 27.4892 111.478 27.6957 111.099 28.3219Z"
                fill="#FFCC00"
            />
            <path
                d="M112.88 49.6121C112.941 49.4731 112.917 49.3184 112.824 49.1984C112.535 48.8219 112.268 48.1283 112.397 47.5021C112.595 46.5487 113.561 46.128 114.528 46.0977C114.689 46.0927 114.835 46.009 114.905 45.8633C115.566 44.4765 117.667 38.6085 118.714 35.3534C118.918 34.7176 118.617 34.0339 118.01 33.7551C115.232 32.477 109.121 29.6253 104.826 27.6747C103.136 30.8292 101.319 33.8283 100.867 34.6889C101.547 35.4091 101.683 36.043 101.434 36.6273C101.051 37.523 100.073 37.984 99.1819 37.7368C95.7814 44.3542 85.2214 57.1264 79.8887 62.2286C81.0586 63.7697 90.877 72.7469 94.631 75.6266C103.868 65.7204 111.833 52.0127 112.88 49.6121Z"
                fill="#EBB409"
            />
            <path
                d="M97.6896 26.2538C96.3219 29.9011 94.6093 33.725 94.0229 35.1148C93.9557 35.2743 94.0013 35.4508 94.1218 35.575C94.6997 36.1688 94.8525 36.7943 94.6359 37.3234C94.3434 38.0381 93.6546 38.4094 92.7692 38.5456C92.625 38.5679 92.5019 38.6571 92.4468 38.7924C89.7534 45.4037 81.1482 58.0979 76.1864 64.2517C75.7237 64.8259 75.8143 65.6615 76.3899 66.122C79.6426 68.727 88.9004 75.1205 92.039 76.8673C92.5483 77.1506 93.2875 77.0262 93.6743 76.5905C102.944 66.1448 110.858 50.8046 111.826 48.2381C111.879 48.0963 111.847 47.9429 111.749 47.8277C111.442 47.466 111.139 46.7872 111.237 46.1553C111.386 45.1932 112.329 44.7244 113.293 44.6446C113.454 44.6314 113.595 44.5403 113.657 44.3915C114.247 42.9731 116.048 37.0061 116.927 33.7024C117.099 33.0573 116.764 32.3896 116.143 32.1418C112.465 30.6707 103.065 26.8449 99.3971 25.4726C98.7101 25.2146 97.9471 25.5665 97.6896 26.2538Z"
                fill="url(#4fc3b553__paint1_linear_19033_0)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M97.7643 50.0867C99.7982 51.2703 101.063 52.8255 99.9974 54.7209C98.9321 56.6161 96.8989 56.2524 94.865 55.0688C92.8311 53.8852 91.5347 52.2987 92.632 50.4346C93.7293 48.5706 95.7304 48.9031 97.7643 50.0867ZM96.9383 51.5278C98.3503 52.3495 99.4256 53.1133 98.8808 54.0712C98.3359 55.0291 97.1218 54.4606 95.7097 53.6389C94.2976 52.8171 93.2199 52.0142 93.7672 51.0954C94.3144 50.1766 95.5262 50.706 96.9383 51.5278Z"
                fill="white"
            />
            <path
                d="M89.8735 59.1675L91.2059 59.9429L90.9246 57.016L96.6293 60.3358L97.4811 58.8721L90.294 54.6896L89.5459 55.975L89.8735 59.1675Z"
                fill="white"
            />
            <path
                d="M90.8442 64.4926L89.7089 63.8319L91.1448 61.3644L92.2802 62.0251L90.8442 64.4926Z"
                fill="white"
            />
            <path
                d="M102.109 51.0447L102.498 50.3759L99.642 44.9332L99.253 45.6017L102.109 51.0447Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M100.284 49.1034C100.644 48.4991 100.313 47.8782 99.6832 47.5115C99.0531 47.1448 98.3459 47.1849 98.0022 47.7755C97.6585 48.366 97.9731 49.0007 98.6032 49.3674C99.2334 49.7341 99.9247 49.7077 100.284 49.1034ZM99.792 48.817C99.9169 48.601 99.6613 48.385 99.3091 48.1801C98.9569 47.9751 98.6498 47.8474 98.5167 48.0749C98.3835 48.3024 98.6474 48.507 98.9996 48.712C99.3518 48.9169 99.6672 49.0331 99.792 48.817Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M103.183 46.6223C103.813 46.989 104.144 47.6099 103.784 48.2142C103.425 48.8185 102.733 48.8448 102.103 48.4781C101.473 48.1114 101.159 47.4767 101.502 46.8863C101.846 46.2957 102.553 46.2556 103.183 46.6223ZM102.809 47.2909C103.161 47.4958 103.417 47.7119 103.292 47.9278C103.167 48.1439 102.852 48.0277 102.5 47.8227C102.148 47.6178 101.884 47.4132 102.017 47.1857C102.15 46.9581 102.457 47.0859 102.809 47.2909Z"
                fill="white"
            />
            <path
                d="M97.7382 37.8759C98.0079 38.0213 98.1076 38.358 97.9618 38.6275C97.8966 38.7483 97.793 38.835 97.674 38.8809C97.5274 38.9377 97.3581 38.9323 97.2093 38.8518C96.9424 38.7073 96.8216 38.3654 96.9625 38.0969C97.1033 37.8279 97.4143 37.712 97.6854 37.8488L97.4342 38.3435L97.6926 37.8526C97.6972 37.8547 97.7335 37.8734 97.7382 37.8759ZM102.627 39.989C102.346 39.8682 102.019 39.9974 101.898 40.2797C101.776 40.5611 101.906 40.8875 102.188 41.0082L102.246 41.0321C102.381 41.0851 102.524 41.0816 102.649 41.0331C102.789 40.9791 102.907 40.8688 102.966 40.719C103.078 40.4335 102.938 40.1118 102.652 39.9998L102.627 39.989ZM99.9068 39.4539L100.126 38.9443C99.8448 38.8234 99.518 38.9526 99.3967 39.235C99.2755 39.5163 99.4055 39.8427 99.6875 39.9634C99.6911 39.9654 99.7355 39.9839 99.7393 39.9852C99.8755 40.0405 100.021 40.0377 100.148 39.9885C100.286 39.9351 100.403 39.8268 100.462 39.6791C100.578 39.3952 100.441 39.072 100.156 38.957L99.9068 39.4539ZM105.124 41.0424C104.843 40.921 104.534 41.0586 104.413 41.3408C104.292 41.6222 104.439 41.9556 104.721 42.0768C104.861 42.1387 105.013 42.1379 105.146 42.0866C105.279 42.0353 105.392 41.9336 105.454 41.7936C105.578 41.5135 105.451 41.1862 105.171 41.0621L105.124 41.0424ZM110.131 43.3442C110.126 43.3417 110.082 43.319 110.076 43.3163C109.804 43.1832 109.494 43.3011 109.356 43.5715C109.218 43.8414 109.342 44.1816 109.609 44.324C109.758 44.4022 109.925 44.4072 110.07 44.3512C110.19 44.3047 110.295 44.2163 110.36 44.0941C110.504 43.8233 110.402 43.4877 110.131 43.3442ZM107.61 42.1393C107.332 42.0168 107.028 42.1488 106.901 42.4238C106.774 42.6988 106.912 43.0337 107.185 43.1648C107.329 43.2337 107.488 43.2352 107.626 43.1818C107.753 43.1326 107.863 43.0369 107.926 42.9044C108.059 42.6277 107.943 42.2964 107.666 42.1641C107.661 42.162 107.615 42.1411 107.61 42.1393Z"
                fill="#891712"
            />
            <path
                d="M124.758 59.8861L95.2758 71.1668C94.1838 71.5861 92.9659 71.4184 92.042 70.7055L68.7337 52.5894C68.7337 52.5894 66.802 65.5894 66.2139 79.3023C66.2559 80.77 67.0538 82.1119 68.2717 82.9087C75.4114 86.5571 92.042 91.7152 113.418 91.7152C115.098 91.6313 116.568 90.5829 117.198 89.0313C119.088 83.6216 121.608 75.0248 124.758 59.8861Z"
                fill="#D4E0ED"
            />
            <path
                d="M120.173 76.0453C120.155 80.0956 120.894 84.8542 123.455 87.1897C123.532 87.2698 123.59 87.3663 123.624 87.4718C123.658 87.5773 123.668 87.6892 123.652 87.799C123.637 87.9087 123.596 88.0135 123.534 88.1054C123.472 88.1974 123.389 88.274 123.293 88.3297C119.371 90.3825 116.27 93.7028 114.499 97.7435C114.448 97.873 114.352 97.98 114.228 98.0453C114.104 98.1106 113.961 98.1299 113.825 98.0997C113.688 98.0696 113.567 97.9919 113.482 97.8807C113.398 97.7695 113.357 97.632 113.365 97.493C113.149 92.0284 111.513 87.6163 110.265 85.8266C110.204 85.7382 110.163 85.6373 110.147 85.5314C110.131 85.4255 110.138 85.3172 110.17 85.2147C110.201 85.1122 110.255 85.0179 110.328 84.939C110.401 84.86 110.49 84.7983 110.59 84.7585C113.04 83.8937 116.553 80.9351 119.037 75.761C119.09 75.6285 119.19 75.5194 119.317 75.4544C119.445 75.3893 119.592 75.3726 119.73 75.4074C119.869 75.4422 119.991 75.5261 120.072 75.6435C120.154 75.7609 120.189 75.9037 120.173 76.0453Z"
                fill="white"
            />
            <path
                d="M123.292 88.333C119.37 90.3838 116.267 93.7033 114.495 97.744C114.441 97.8834 114.334 97.9964 114.198 98.0593C114.061 98.1221 113.906 98.1299 113.764 98.0809V98.0751C114.118 97.2444 116.401 87.8276 115.085 85.6085C117.227 84.5337 119.227 77.5335 119.788 75.4307C119.907 75.4818 120.008 75.5683 120.077 75.6784C120.145 75.7886 120.178 75.917 120.171 76.0464C120.153 80.0954 120.891 84.8533 123.452 87.1944C123.529 87.2742 123.587 87.3703 123.621 87.4756C123.656 87.5809 123.666 87.6926 123.65 87.8022C123.635 87.9119 123.595 88.0166 123.533 88.1086C123.471 88.2005 123.388 88.2773 123.292 88.333Z"
                fill="#D8E5FF"
            />
            <path
                d="M113.764 98.0754V98.0812C113.645 98.0361 113.543 97.9556 113.471 97.8506C113.399 97.7457 113.362 97.6214 113.363 97.4945C113.151 92.028 111.51 87.6188 110.266 85.8295C110.192 85.7248 110.147 85.6026 110.136 85.4751C111.763 85.8232 113.442 85.8685 115.086 85.6088C116.402 87.8279 114.118 97.2447 113.764 98.0754Z"
                fill="#ECF1FF"
            />
            <path
                d="M118.709 26.5477C120.616 23.8281 121.873 22.561 124.045 20.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M124.065 27.0615C125.521 25.9134 128.618 23.4588 130.074 22.3107"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M57.6955 29.6874C57.648 29.6875 57.6007 29.6816 57.5546 29.6699C57.4833 29.652 57.4162 29.62 57.3572 29.5759C57.2981 29.5317 57.2483 29.4762 57.2107 29.4126C57.173 29.349 57.1481 29.2784 57.1376 29.2051C57.1271 29.1317 57.131 29.057 57.1492 28.9852L57.5634 27.3803C57.6026 27.2358 57.6963 27.1125 57.8246 27.0368C57.9528 26.9612 58.1053 26.9393 58.2494 26.9757C58.3207 26.9936 58.3879 27.0255 58.4469 27.0697C58.5059 27.1138 58.5557 27.1693 58.5934 27.233C58.6311 27.2966 58.6559 27.3671 58.6665 27.4405C58.677 27.5138 58.6731 27.5886 58.6548 27.6604L58.2406 29.2652C58.2088 29.3865 58.138 29.4937 58.0394 29.57C57.9408 29.6464 57.8198 29.6877 57.6955 29.6874Z"
                fill="#1CB5F9"
            />
            <path
                d="M56.5392 34.1666C56.4917 34.1667 56.4444 34.1608 56.3984 34.149C56.3271 34.1311 56.26 34.0992 56.2009 34.055C56.1419 34.0109 56.0921 33.9554 56.0544 33.8918C56.0167 33.8281 55.9919 33.7576 55.9814 33.6842C55.9708 33.6109 55.9748 33.5362 55.993 33.4644L56.4072 31.8595C56.4462 31.7149 56.5399 31.5914 56.6682 31.5158C56.7964 31.4401 56.949 31.4182 57.0932 31.4548C57.1645 31.4727 57.2316 31.5047 57.2906 31.5488C57.3497 31.593 57.3995 31.6485 57.4371 31.7121C57.4748 31.7757 57.4996 31.8463 57.5102 31.9196C57.5207 31.993 57.5168 32.0677 57.4986 32.1395L57.0844 33.7444C57.0525 33.8656 56.9818 33.9728 56.8832 34.0492C56.7845 34.1256 56.6636 34.1668 56.5392 34.1666Z"
                fill="#1CB5F9"
            />
            <path
                d="M60.3727 31.9085C60.3252 31.9086 60.2779 31.9027 60.2319 31.8909L58.624 31.4775C58.5527 31.4596 58.4855 31.4277 58.4265 31.3835C58.3675 31.3394 58.3177 31.2839 58.28 31.2202C58.2423 31.1566 58.2175 31.0861 58.2069 31.0127C58.1964 30.9394 58.2003 30.8646 58.2185 30.7928C58.2573 30.648 58.3509 30.5244 58.4793 30.4487C58.6076 30.373 58.7604 30.3513 58.9045 30.3882L60.5124 30.8016C60.6449 30.8348 60.7607 30.9159 60.8378 31.0294C60.9149 31.143 60.948 31.2812 60.9308 31.4177C60.9135 31.5543 60.8472 31.6797 60.7443 31.7701C60.6414 31.8606 60.5092 31.9099 60.3727 31.9085L60.3727 31.9085Z"
                fill="#1CB5F9"
            />
            <path
                d="M55.8845 30.7541C55.837 30.7542 55.7897 30.7483 55.7437 30.7365L54.1358 30.3236C54.0644 30.3058 53.9973 30.2739 53.9382 30.2297C53.8792 30.1856 53.8294 30.1301 53.7917 30.0664C53.754 30.0028 53.7292 29.9323 53.7186 29.8589C53.7081 29.7855 53.7121 29.7108 53.7303 29.639C53.7691 29.4942 53.8628 29.3707 53.9911 29.2949C54.1194 29.2192 54.2722 29.1975 54.4163 29.2343L56.0242 29.6472C56.1567 29.6804 56.2725 29.7615 56.3496 29.875C56.4267 29.9886 56.4598 30.1268 56.4425 30.2633C56.4253 30.3998 56.359 30.5253 56.2561 30.6157C56.1532 30.7062 56.021 30.7554 55.8845 30.7541L55.8845 30.7541Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.465 92.7289C132.418 92.7291 132.37 92.7232 132.324 92.7114C132.253 92.6935 132.186 92.6615 132.127 92.6174C132.068 92.5732 132.018 92.5177 131.98 92.4541C131.943 92.3905 131.918 92.32 131.907 92.2466C131.897 92.1732 131.901 92.0985 131.919 92.0267L132.333 90.4218C132.372 90.2773 132.466 90.154 132.594 90.0784C132.722 90.0027 132.875 89.9808 133.019 90.0172C133.09 90.0351 133.157 90.067 133.216 90.1112C133.275 90.1553 133.325 90.2108 133.363 90.2745C133.401 90.3381 133.425 90.4086 133.436 90.482C133.447 90.5553 133.443 90.6301 133.424 90.7019L133.01 92.3067C132.978 92.428 132.908 92.5352 132.809 92.6115C132.71 92.6879 132.589 92.7292 132.465 92.7289Z"
                fill="#1CB5F9"
            />
            <path
                d="M131.309 97.2081C131.261 97.2082 131.214 97.2023 131.168 97.1905C131.097 97.1726 131.029 97.1407 130.97 97.0965C130.911 97.0524 130.862 96.9969 130.824 96.9333C130.786 96.8696 130.761 96.7991 130.751 96.7257C130.74 96.6524 130.744 96.5777 130.762 96.5059L131.177 94.901C131.216 94.7564 131.309 94.633 131.438 94.5573C131.566 94.4816 131.719 94.4597 131.863 94.4963C131.934 94.5142 132.001 94.5462 132.06 94.5903C132.119 94.6345 132.169 94.69 132.207 94.7536C132.244 94.8172 132.269 94.8878 132.28 94.9611C132.29 95.0345 132.286 95.1092 132.268 95.181L131.854 96.7859C131.822 96.9071 131.751 97.0143 131.653 97.0907C131.554 97.1671 131.433 97.2083 131.309 97.2081Z"
                fill="#1CB5F9"
            />
            <path
                d="M135.142 94.95C135.095 94.9501 135.047 94.9442 135.001 94.9324L133.394 94.519C133.322 94.5011 133.255 94.4692 133.196 94.425C133.137 94.3809 133.087 94.3254 133.05 94.2617C133.012 94.1981 132.987 94.1276 132.976 94.0542C132.966 93.9809 132.97 93.9061 132.988 93.8343C133.027 93.6895 133.12 93.5659 133.249 93.4902C133.377 93.4145 133.53 93.3928 133.674 93.4297L135.282 93.8431C135.414 93.8763 135.53 93.9574 135.607 94.0709C135.684 94.1845 135.718 94.3227 135.7 94.4592C135.683 94.5958 135.617 94.7212 135.514 94.8117C135.411 94.9021 135.279 94.9514 135.142 94.95L135.142 94.95Z"
                fill="#1CB5F9"
            />
            <path
                d="M130.654 93.7956C130.607 93.7957 130.559 93.7898 130.513 93.778L128.905 93.3651C128.834 93.3473 128.767 93.3154 128.708 93.2712C128.649 93.2271 128.599 93.1716 128.561 93.1079C128.524 93.0443 128.499 92.9738 128.488 92.9004C128.478 92.827 128.482 92.7523 128.5 92.6805C128.539 92.5357 128.632 92.4122 128.761 92.3364C128.889 92.2607 129.042 92.239 129.186 92.2758L130.794 92.6887C130.926 92.7219 131.042 92.803 131.119 92.9165C131.196 93.0301 131.229 93.1683 131.212 93.3048C131.195 93.4413 131.128 93.5668 131.026 93.6572C130.923 93.7477 130.791 93.7969 130.654 93.7956L130.654 93.7956Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="4fc3b553__paint0_linear_19033_0"
                x1={66.5748}
                y1={12.8891}
                x2={84.6034}
                y2={92.4098}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.393875} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="4fc3b553__paint1_linear_19033_0"
                x1={92.2812}
                y1={76.1576}
                x2={101.356}
                y2={26.3672}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="4fc3b553__clip0_19033_0">
                <rect width={137} height={102} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default Promo10Xs;
