import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo500L = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 532 204"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#330618e3__clip0_19033_11)">
            <g opacity={0.3}>
                <path
                    d="M694.202 251.078L639.272 102.958C639.272 102.958 624.486 169.93 573.001 189C538.477 201.795 557.411 130.036 526.501 119.5C506.638 112.729 481.448 121.293 472.907 123.385C474.11 103.946 468.456 50.4155 447.164 49.3082C434.533 48.57 414.444 50.0464 406.024 58.6585C412.399 39.4658 391.16 13.4438 368.184 11.3523C301.92 5.32005 253.54 53.4611 236.098 120.512C206.145 117.56 176.706 151.639 202.208 171.324C175.623 168.371 126.222 218.229 123.936 246.402C123.575 249.109 125.38 251.078 128.387 251.078C165.678 253.169 203.089 254.399 240.38 256.737C256.018 255.138 271.656 253.169 287.174 250.709C380.401 251.447 694.202 251.078 694.202 251.078Z"
                    fill="url(#330618e3__paint0_linear_19033_11)"
                />
                <path
                    d="M694.202 251.078L639.272 102.958C639.272 102.958 624.486 169.93 573.001 189C538.477 201.795 557.411 130.036 526.501 119.5C506.638 112.729 481.448 121.293 472.907 123.385C474.11 103.946 468.456 50.4155 447.164 49.3082C434.533 48.57 414.444 50.0464 406.024 58.6585C412.399 39.4658 391.16 13.4438 368.184 11.3523C301.92 5.32005 253.54 53.4611 236.098 120.512C206.145 117.56 176.706 151.639 202.208 171.324C175.623 168.371 126.222 218.229 123.936 246.402C123.575 249.109 125.38 251.078 128.387 251.078C165.678 253.169 203.089 254.399 240.38 256.737C256.018 255.138 271.656 253.169 287.174 250.709C380.401 251.447 694.202 251.078 694.202 251.078Z"
                    fill="#ECF2F9"
                />
            </g>
            <g opacity={0.3}>
                <path
                    d="M593.568 272.141L533.123 125.958C533.123 125.958 516.052 87.5856 493.651 81.5793C459.467 72.4139 435.5 90.5 426.291 102.211C418.5 91 400.757 86.6136 382.75 87.0026C369.456 87.2898 359.453 94.735 350.055 96.5113C351.379 80.0017 345.157 61.7157 321.728 60.7753C307.829 60.1483 285.723 77.4022 276.457 84.7166C283.473 68.416 245.783 50.2764 220.5 48.5C147.584 43.3767 108.665 104.302 89.4718 161.25C56.5118 158.742 24.1177 187.686 52.1801 204.405C22.9264 201.897 -31.4347 244.242 -33.9497 268.17C-34.3468 270.469 -32.3613 272.141 -29.052 272.141C11.9826 273.917 53.1496 274.962 94.1842 276.948C111.392 275.589 128.6 273.917 145.676 271.828C248.263 272.455 593.568 272.141 593.568 272.141Z"
                    fill="url(#330618e3__paint1_linear_19033_11)"
                />
                <path
                    d="M593.568 272.141L533.123 125.958C533.123 125.958 516.052 87.5856 493.651 81.5793C459.467 72.4139 435.5 90.5 426.291 102.211C418.5 91 400.757 86.6136 382.75 87.0026C369.456 87.2898 359.453 94.735 350.055 96.5113C351.379 80.0017 345.157 61.7157 321.728 60.7753C307.829 60.1483 285.723 77.4022 276.457 84.7166C283.473 68.416 245.783 50.2764 220.5 48.5C147.584 43.3767 108.665 104.302 89.4718 161.25C56.5118 158.742 24.1177 187.686 52.1801 204.405C22.9264 201.897 -31.4347 244.242 -33.9497 268.17C-34.3468 270.469 -32.3613 272.141 -29.052 272.141C11.9826 273.917 53.1496 274.962 94.1842 276.948C111.392 275.589 128.6 273.917 145.676 271.828C248.263 272.455 593.568 272.141 593.568 272.141Z"
                    fill="#ECF2F9"
                    fillOpacity={0.8}
                />
            </g>
            <path
                d="M215.23 48.3216C215.13 48.3906 215.023 48.4469 214.91 48.4892C214.735 48.5555 214.549 48.5867 214.362 48.5811C214.176 48.5754 213.992 48.5329 213.823 48.4562C213.653 48.3794 213.5 48.2698 213.374 48.1336C213.247 47.9975 213.148 47.8376 213.084 47.663L211.66 43.7512C211.535 43.3963 211.555 43.0061 211.716 42.6643C211.876 42.3226 212.164 42.0565 212.518 41.9231C212.692 41.8568 212.878 41.8256 213.065 41.8313C213.252 41.8369 213.435 41.8794 213.605 41.9562C213.774 42.033 213.927 42.1426 214.054 42.2787C214.181 42.4148 214.279 42.5747 214.343 42.7493L215.768 46.6611C215.874 46.9574 215.879 47.281 215.782 47.5814C215.684 47.8818 215.49 48.1421 215.23 48.3216Z"
                fill="#1CB5F9"
            />
            <path
                d="M219.204 59.2384C219.105 59.3073 218.998 59.3637 218.885 59.406C218.71 59.4723 218.524 59.5035 218.337 59.4979C218.151 59.4922 217.967 59.4497 217.797 59.3729C217.628 59.2962 217.475 59.1866 217.348 59.0504C217.222 58.9143 217.123 58.7544 217.059 58.5798L215.635 54.668C215.51 54.3131 215.53 53.9228 215.69 53.5809C215.85 53.239 216.139 52.973 216.492 52.8399C216.667 52.7736 216.853 52.7424 217.04 52.7481C217.226 52.7537 217.41 52.7962 217.579 52.873C217.749 52.9498 217.902 53.0594 218.029 53.1955C218.155 53.3316 218.254 53.4915 218.318 53.6661L219.742 57.5779C219.849 57.8742 219.854 58.1978 219.757 58.4982C219.659 58.7986 219.465 59.0589 219.204 59.2384Z"
                fill="#1CB5F9"
            />
            <path
                d="M224.002 49.03C223.902 49.099 223.795 49.1553 223.682 49.1977L219.727 50.6719C219.552 50.7382 219.366 50.7695 219.179 50.7638C218.993 50.7581 218.809 50.7157 218.64 50.6389C218.47 50.5621 218.317 50.4525 218.19 50.3164C218.064 50.1803 217.965 50.0203 217.901 49.8458C217.775 49.4909 217.795 49.1002 217.955 48.7582C218.116 48.4161 218.404 48.1501 218.759 48.0177L222.714 46.5434C223.038 46.4201 223.396 46.4198 223.72 46.5426C224.043 46.6654 224.31 46.9026 224.469 47.2094C224.628 47.5162 224.668 47.871 224.582 48.2067C224.496 48.5423 224.289 48.8353 224.002 49.0301L224.002 49.03Z"
                fill="#1CB5F9"
            />
            <path
                d="M212.964 53.1445C212.865 53.2134 212.757 53.2698 212.644 53.3121L208.69 54.7875C208.515 54.8539 208.329 54.8852 208.142 54.8796C207.956 54.8739 207.772 54.8315 207.602 54.7547C207.433 54.6779 207.28 54.5683 207.153 54.4321C207.027 54.2959 206.928 54.1359 206.864 53.9613C206.738 53.6065 206.758 53.2158 206.918 52.8738C207.079 52.5318 207.367 52.2658 207.722 52.1332L211.676 50.6578C212.001 50.5345 212.359 50.5342 212.682 50.657C213.006 50.7798 213.272 51.0171 213.431 51.3238C213.59 51.6306 213.63 51.9854 213.544 52.321C213.458 52.6566 213.251 52.9497 212.964 53.1445L212.964 53.1445Z"
                fill="#1CB5F9"
            />
            <path
                d="M466.133 145.848C466.013 145.848 465.892 145.834 465.775 145.804C465.594 145.759 465.423 145.679 465.273 145.568C465.122 145.457 464.996 145.318 464.9 145.158C464.804 144.999 464.741 144.822 464.714 144.638C464.687 144.454 464.697 144.266 464.743 144.086L465.797 140.059C465.897 139.696 466.136 139.386 466.462 139.197C466.788 139.007 467.176 138.952 467.543 139.043C467.724 139.088 467.895 139.168 468.045 139.279C468.196 139.39 468.322 139.529 468.418 139.689C468.514 139.848 468.577 140.025 468.604 140.21C468.631 140.394 468.621 140.581 468.575 140.761L467.521 144.789C467.44 145.093 467.26 145.362 467.009 145.554C466.758 145.745 466.45 145.849 466.133 145.848Z"
                fill="#1CB5F9"
            />
            <path
                d="M463.192 157.088C463.071 157.089 462.951 157.074 462.834 157.044C462.652 156.999 462.481 156.919 462.331 156.808C462.181 156.698 462.054 156.558 461.958 156.399C461.863 156.239 461.799 156.062 461.772 155.878C461.746 155.694 461.756 155.506 461.802 155.326L462.856 151.299C462.955 150.936 463.194 150.626 463.52 150.436C463.847 150.246 464.235 150.191 464.602 150.283C464.783 150.328 464.954 150.408 465.104 150.519C465.254 150.63 465.381 150.769 465.477 150.929C465.573 151.089 465.636 151.266 465.663 151.45C465.69 151.634 465.679 151.821 465.633 152.001L464.579 156.029C464.498 156.333 464.318 156.602 464.067 156.794C463.816 156.985 463.508 157.089 463.192 157.088Z"
                fill="#1CB5F9"
            />
            <path
                d="M472.944 151.421C472.823 151.422 472.702 151.407 472.585 151.377L468.494 150.34C468.312 150.295 468.142 150.215 467.991 150.104C467.841 149.993 467.714 149.854 467.619 149.694C467.523 149.534 467.459 149.357 467.433 149.173C467.406 148.989 467.416 148.802 467.462 148.622C467.561 148.258 467.799 147.948 468.126 147.758C468.452 147.568 468.841 147.513 469.208 147.606L473.299 148.644C473.636 148.727 473.931 148.93 474.127 149.215C474.323 149.5 474.407 149.847 474.364 150.19C474.32 150.532 474.151 150.847 473.889 151.074C473.627 151.301 473.291 151.425 472.944 151.421L472.944 151.421Z"
                fill="#1CB5F9"
            />
            <path
                d="M461.526 148.525C461.405 148.526 461.285 148.511 461.167 148.481L457.076 147.445C456.894 147.4 456.724 147.32 456.573 147.209C456.423 147.099 456.296 146.959 456.2 146.8C456.105 146.64 456.041 146.463 456.015 146.279C455.988 146.095 455.998 145.907 456.044 145.727C456.143 145.364 456.381 145.054 456.708 144.864C457.034 144.674 457.423 144.619 457.79 144.711L461.881 145.748C462.218 145.831 462.513 146.034 462.709 146.319C462.905 146.604 462.99 146.951 462.946 147.294C462.902 147.636 462.733 147.951 462.471 148.178C462.21 148.405 461.873 148.529 461.526 148.525L461.526 148.525Z"
                fill="#1CB5F9"
            />
            <path
                d="M277.915 49.0084C278.414 58.2734 280.735 69.0576 286.902 74.0587C287.088 74.2316 287.233 74.4446 287.325 74.6814C287.417 74.9182 287.454 75.1727 287.433 75.4258C287.412 75.6789 287.333 75.9239 287.203 76.1424C287.073 76.3609 286.894 76.5472 286.681 76.6872C277.988 81.9026 271.336 89.9073 267.824 99.3831C267.723 99.6861 267.518 99.9437 267.244 100.109C266.97 100.275 266.645 100.338 266.329 100.287C266.012 100.237 265.725 100.075 265.517 99.8319C265.31 99.5888 265.197 99.28 265.198 98.961C263.978 86.4927 259.65 76.6198 256.558 72.6928C256.408 72.4987 256.302 72.2733 256.251 72.0333C256.199 71.7932 256.202 71.5447 256.26 71.306C256.318 71.0674 256.429 70.8447 256.585 70.6544C256.741 70.4642 256.938 70.3112 257.162 70.2069C262.649 67.9038 270.289 60.6714 275.282 48.5091C275.385 48.1989 275.598 47.9364 275.881 47.7707C276.164 47.6049 276.497 47.5472 276.82 47.6083C277.142 47.6695 277.431 47.8452 277.633 48.1029C277.834 48.3605 277.935 48.6823 277.915 49.0084Z"
                fill="white"
            />
            <path
                d="M286.683 76.6961C277.986 81.907 271.332 89.9102 267.818 99.3861C267.712 99.7122 267.483 99.9848 267.179 100.147C266.876 100.308 266.521 100.347 266.189 100.254L266.189 100.241C266.888 98.2937 270.858 76.4553 267.555 71.5552C272.31 68.8129 275.954 52.5386 276.956 47.6552C277.236 47.7563 277.479 47.9407 277.65 48.1835C277.822 48.4262 277.914 48.7156 277.915 49.0124C278.412 58.2745 280.73 69.0572 286.896 74.0712C287.083 74.2433 287.229 74.4554 287.321 74.6917C287.414 74.9279 287.452 75.182 287.431 75.4348C287.411 75.6876 287.333 75.9325 287.203 76.151C287.073 76.3695 286.896 76.5559 286.683 76.6961Z"
                fill="#D8E5FF"
            />
            <path
                d="M266.189 100.24L266.19 100.253C265.911 100.165 265.666 99.9949 265.488 99.7644C265.31 99.534 265.208 99.2547 265.194 98.9643C263.983 86.4911 259.647 76.6255 256.563 72.6989C256.379 72.4695 256.261 72.1958 256.219 71.9058C259.987 72.4857 263.83 72.3665 267.556 71.5542C270.859 76.4543 266.888 98.2927 266.189 100.24Z"
                fill="url(#330618e3__paint2_linear_19033_11)"
            />
            <path
                d="M389.708 109.898L345.738 56.076C343.288 53.0776 339.043 52.2637 335.658 54.1435L264.607 93.602C264.607 93.602 262.169 124.507 258.98 153.259C259.074 156.537 266.952 156.911 269.672 158.691C280.737 165.621 303.432 180.418 360.637 176.953C364.388 176.766 371.327 178.358 372.734 174.893C375.641 162.905 382.206 141.365 389.708 109.898Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M306.13 78.708L304.013 89.822L280.197 146.98L277.021 144.334L306.13 78.708Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M359.216 39.4079C354.286 47.5502 347.768 56.4956 346.352 58.732C347.735 60.4589 347.922 61.8944 347.261 63.1496C346.247 65.0739 343.986 65.9222 342.047 65.2101C333.278 79.3216 307.454 105.831 294.658 116.218C297.053 119.974 318.479 143.002 325.728 149.341C326.816 150.293 328.419 150.332 329.55 149.431C350.778 132.51 377.544 99.0283 380.567 94.1336C380.75 93.8378 380.745 93.4802 380.572 93.1785C380.014 92.2023 379.537 90.373 380.171 89.0907C381.032 87.3491 383.121 86.6157 385.242 86.8102C385.596 86.8427 385.939 86.7029 386.135 86.407C388.068 83.4874 395.074 70.5311 398.48 63.4832C399.139 62.1218 398.669 60.4954 397.388 59.6928C389.871 54.9827 370.775 42.8531 363.275 38.3856C361.871 37.5482 360.062 38.0093 359.216 39.4079Z"
                fill="#FFCC00"
            />
            <path
                d="M363.193 86.9552C363.328 86.6448 363.275 86.2994 363.068 86.0315C362.424 85.1905 361.825 83.6415 362.115 82.2431C362.556 80.1139 364.714 79.1745 366.872 79.1067C367.232 79.0955 367.559 78.9085 367.714 78.5832C369.19 75.486 373.883 62.3812 376.219 55.1117C376.676 53.6919 376.004 52.1649 374.649 51.5424C368.444 48.6879 354.8 42.3194 345.208 37.963C341.435 45.0079 337.376 51.7057 336.368 53.6277C337.887 55.2362 338.191 56.6517 337.634 57.9566C336.78 59.9571 334.595 60.9866 332.605 60.4345C325.012 75.2129 301.432 103.737 289.524 115.131C292.136 118.573 314.061 138.622 322.443 145.053C343.07 122.929 360.854 92.3166 363.193 86.9552Z"
                fill="#EBB409"
            />
            <path
                d="M329.272 34.7897C326.218 42.935 322.394 51.4749 321.084 54.5788C320.934 54.9349 321.036 55.329 321.305 55.6065C322.595 56.9326 322.937 58.3294 322.453 59.5111C321.8 61.1073 320.262 61.9364 318.285 62.2407C317.963 62.2905 317.688 62.4895 317.565 62.7918C311.551 77.5568 292.335 105.906 281.256 119.649C280.222 120.932 280.425 122.798 281.71 123.826C288.973 129.644 309.646 143.923 316.654 147.823C317.792 148.456 319.442 148.178 320.306 147.205C341.005 123.877 358.677 89.6183 360.838 83.8867C360.958 83.57 360.886 83.2273 360.667 82.97C359.981 82.1624 359.305 80.6464 359.523 79.2353C359.855 77.0866 361.962 76.0396 364.114 75.8615C364.473 75.8318 364.789 75.6285 364.927 75.2962C366.243 72.1284 370.265 58.8025 372.228 51.4245C372.612 49.9837 371.864 48.4926 370.479 47.9392C362.264 44.6538 341.276 36.1098 333.085 33.045C331.551 32.4689 329.847 33.2546 329.272 34.7897Z"
                fill="url(#330618e3__paint3_linear_19033_11)"
            />
            <path
                d="M317.922 114.584C318.63 115.002 319.205 115.512 319.65 116.115C320.082 116.711 320.374 117.369 320.528 118.09C320.676 118.791 320.68 119.534 320.54 120.32C320.387 121.098 320.083 121.873 319.628 122.643C319.106 123.527 318.572 124.2 318.027 124.661C317.482 125.123 316.964 125.481 316.472 125.736L314.142 124.36C314.674 124.095 315.24 123.757 315.841 123.345C316.449 122.921 316.977 122.329 317.424 121.572C317.939 120.7 318.084 119.892 317.86 119.146C317.643 118.388 317.169 117.793 316.436 117.36C315.704 116.928 315.015 116.768 314.369 116.881C313.731 116.981 313.192 117.403 312.752 118.148C312.491 118.59 312.35 119.001 312.33 119.381C312.31 119.761 312.354 120.077 312.461 120.327L311.298 122.298L303.853 117.901L308.585 109.888L310.783 111.186L307.415 116.888L310.484 118.7C310.447 118.388 310.466 118.025 310.541 117.609C310.616 117.194 310.81 116.721 311.123 116.19C311.891 114.889 312.877 114.1 314.08 113.823C315.278 113.525 316.558 113.779 317.922 114.584ZM326.282 111.375C325.871 112.07 325.362 112.629 324.754 113.054C324.146 113.478 323.441 113.734 322.639 113.823C321.824 113.904 320.904 113.804 319.879 113.522C318.86 113.227 317.732 112.714 316.495 111.983C315.257 111.252 314.27 110.516 313.532 109.774C312.79 109.012 312.264 108.259 311.955 107.514C311.632 106.761 311.517 106.02 311.607 105.29C311.685 104.553 311.929 103.836 312.339 103.142C312.742 102.46 313.244 101.913 313.844 101.501C314.44 101.07 315.139 100.809 315.94 100.721C316.742 100.632 317.652 100.735 318.671 101.03C319.676 101.317 320.792 101.823 322.017 102.546C323.254 103.277 324.248 104.017 324.998 104.766C325.747 105.516 326.283 106.266 326.606 107.019C326.928 107.771 327.056 108.52 326.991 109.265C326.921 109.99 326.684 110.693 326.282 111.375ZM324.149 110.141C324.343 109.813 324.438 109.478 324.436 109.136C324.421 108.786 324.272 108.417 323.99 108.029C323.709 107.642 323.281 107.227 322.706 106.786C322.14 106.332 321.396 105.833 320.474 105.288C319.564 104.751 318.774 104.344 318.103 104.067C317.44 103.778 316.87 103.603 316.394 103.544C315.926 103.471 315.535 103.513 315.222 103.669C314.916 103.812 314.662 104.054 314.461 104.395C314.259 104.736 314.166 105.081 314.181 105.431C314.196 105.78 314.341 106.155 314.615 106.556C314.897 106.944 315.322 107.364 315.888 107.818C316.462 108.259 317.204 108.749 318.113 109.286C319.035 109.83 319.828 110.247 320.492 110.537C321.163 110.814 321.736 110.982 322.212 111.041C322.695 111.088 323.09 111.04 323.396 110.897C323.696 110.734 323.947 110.482 324.149 110.141ZM332.432 100.96C332.022 101.655 331.513 102.214 330.904 102.638C330.296 103.063 329.591 103.319 328.789 103.408C327.975 103.489 327.055 103.388 326.029 103.106C325.011 102.812 323.883 102.299 322.645 101.568C321.407 100.837 320.42 100.101 319.683 99.3588C318.941 98.5968 318.415 97.8434 318.105 97.0985C317.783 96.3461 317.667 95.6049 317.757 94.8748C317.835 94.1373 318.079 93.4212 318.49 92.7266C318.892 92.0446 319.394 91.4978 319.995 91.0861C320.59 90.6543 321.289 90.3941 322.091 90.3055C322.893 90.2169 323.803 90.3199 324.821 90.6147C325.827 90.9019 326.942 91.4073 328.167 92.1307C329.405 92.8615 330.398 93.6016 331.148 94.351C331.898 95.1004 332.434 95.8512 332.756 96.6036C333.078 97.3559 333.207 98.1046 333.142 98.8496C333.071 99.5746 332.835 100.278 332.432 100.96ZM330.299 99.726C330.493 99.3977 330.589 99.0624 330.586 98.7204C330.571 98.3708 330.423 98.0021 330.141 97.6142C329.859 97.2263 329.431 96.8117 328.857 96.3705C328.29 95.9167 327.546 95.4176 326.624 94.8732C325.715 94.3362 324.925 93.9292 324.254 93.6522C323.59 93.3625 323.02 93.1879 322.545 93.1284C322.076 93.0562 321.685 93.0979 321.372 93.2535C321.066 93.3965 320.813 93.6385 320.611 93.9795C320.41 94.3205 320.317 94.6657 320.332 95.0153C320.347 95.3648 320.491 95.7398 320.766 96.1404C321.048 96.5283 321.472 96.9492 322.039 97.403C322.613 97.8442 323.354 98.3333 324.264 98.8702C325.186 99.4147 325.978 99.8317 326.642 100.121C327.313 100.398 327.886 100.567 328.362 100.626C328.846 100.673 329.24 100.625 329.546 100.482C329.847 100.319 330.098 100.067 330.299 99.726ZM332.24 83.8918L326.084 80.2561L328.243 76.6C328.653 75.9054 329.108 75.3225 329.608 74.8511C330.102 74.3597 330.633 74.0088 331.2 73.7986C331.767 73.5884 332.37 73.5188 333.01 73.5897C333.649 73.6607 334.316 73.9013 335.011 74.3115C335.718 74.7291 336.247 75.2033 336.598 75.7341C336.943 76.2449 337.151 76.8018 337.221 77.405C337.29 78.0082 337.223 78.6413 337.019 79.3043C336.815 79.9673 336.507 80.646 336.097 81.3406L335.583 82.212L336.719 82.8832L338.901 79.1893L340.644 80.2184L338.462 83.9124L341.266 85.568L339.666 88.277L336.862 86.6213L336.068 87.9663L334.325 86.9372L335.12 85.5922L333.983 84.921L333.189 86.266L331.446 85.2368L332.24 83.8918ZM329.786 78.7889L333.84 81.1829L334.377 80.2736C335.167 78.9349 334.855 77.8479 333.441 77.0127C332.734 76.595 332.142 76.4583 331.665 76.6025C331.195 76.7341 330.756 77.1472 330.345 77.8418L329.786 78.7889Z"
                fill="white"
            />
            <path
                d="M328.124 60.9053C328.716 61.2486 328.916 62.007 328.571 62.5984C328.418 62.8636 328.18 63.05 327.912 63.1444C327.58 63.2608 327.203 63.2371 326.876 63.0473C326.291 62.7061 326.045 61.9346 326.378 61.345C326.711 60.7544 327.413 60.517 328.008 60.8411L327.414 61.9281L328.024 60.8503C328.034 60.8551 328.114 60.8995 328.124 60.9053ZM338.89 65.9605C338.27 65.6713 337.532 65.9372 337.242 66.559C336.951 67.1787 337.219 67.9162 337.84 68.2051L337.967 68.2626C338.264 68.3901 338.583 68.3923 338.867 68.2926C339.182 68.1818 339.453 67.9438 339.595 67.6133C339.865 66.984 339.576 66.2562 338.946 65.9862L338.89 65.9605ZM332.855 64.5779L333.381 63.4554C332.761 63.1662 332.022 63.432 331.732 64.0539C331.442 64.6735 331.71 65.4111 332.331 65.7C332.339 65.7046 332.436 65.749 332.445 65.7523C332.745 65.8852 333.069 65.8888 333.356 65.7878C333.668 65.6783 333.936 65.4444 334.079 65.119C334.356 64.4933 334.073 63.7622 333.446 63.486L332.855 64.5779ZM344.391 68.4846C343.771 68.1941 343.072 68.48 342.782 69.1015C342.492 69.7212 342.798 70.4757 343.419 70.7658C343.727 70.9136 344.067 70.9223 344.366 70.8171C344.666 70.7118 344.925 70.4925 345.073 70.1842C345.37 69.5675 345.11 68.8283 344.493 68.5318L344.391 68.4846ZM355.405 73.9691C355.395 73.9633 355.297 73.9095 355.285 73.9031C354.687 73.5872 353.988 73.8289 353.66 74.4228C353.333 75.0159 353.586 75.7837 354.173 76.1202C354.499 76.305 354.873 76.3279 355.2 76.2127C355.472 76.1173 355.711 75.9272 355.865 75.6589C356.206 75.0644 356 74.3082 355.405 73.9691ZM349.862 71.1051C349.251 70.8126 348.563 71.086 348.26 71.6912C347.958 72.2963 348.242 73.0534 348.844 73.3648C349.16 73.5288 349.514 73.5429 349.826 73.4333C350.113 73.3323 350.364 73.1263 350.515 72.8349C350.83 72.2264 350.594 71.4789 349.986 71.1644C349.974 71.1593 349.873 71.1096 349.862 71.1051Z"
                fill="#891712"
            />
            <path
                d="M389.708 109.898L323.875 135.091C321.437 136.028 318.717 135.653 316.654 134.061L264.607 93.6025C264.607 93.6025 260.294 122.635 258.98 153.26C259.074 156.538 260.856 159.535 263.576 161.314C279.518 169.462 316.654 180.981 364.388 180.981C368.139 180.794 371.421 178.453 372.828 174.987C377.048 162.906 382.675 143.707 389.708 109.898Z"
                fill="#D4E0ED"
            />
            <path
                d="M374.407 138.405C374.371 146.833 375.909 156.735 381.237 161.595C381.397 161.761 381.517 161.962 381.588 162.182C381.659 162.401 381.679 162.634 381.647 162.862C381.614 163.091 381.53 163.309 381.4 163.5C381.271 163.691 381.099 163.851 380.899 163.967C372.741 168.238 366.288 175.147 362.603 183.555C362.496 183.825 362.296 184.047 362.039 184.183C361.782 184.319 361.484 184.359 361.2 184.296C360.916 184.234 360.663 184.072 360.488 183.841C360.313 183.609 360.226 183.323 360.244 183.034C359.795 171.663 356.39 162.482 353.793 158.758C353.666 158.574 353.583 158.364 353.549 158.144C353.515 157.924 353.531 157.698 353.596 157.485C353.661 157.272 353.773 157.076 353.925 156.911C354.076 156.747 354.263 156.619 354.471 156.536C359.569 154.736 366.877 148.58 372.046 137.814C372.155 137.538 372.362 137.311 372.627 137.176C372.893 137.04 373.198 137.006 373.487 137.078C373.777 137.15 374.029 137.325 374.199 137.569C374.368 137.813 374.442 138.111 374.407 138.405Z"
                fill="white"
            />
            <path
                d="M380.899 163.974C372.738 168.241 366.282 175.148 362.596 183.556C362.483 183.846 362.261 184.082 361.977 184.212C361.694 184.343 361.37 184.359 361.074 184.257V184.245C361.811 182.517 366.561 162.922 363.824 158.305C368.28 156.068 372.441 141.502 373.607 137.126C373.856 137.233 374.066 137.413 374.209 137.642C374.352 137.871 374.42 138.139 374.405 138.408C374.368 146.833 375.903 156.733 381.23 161.605C381.391 161.771 381.512 161.971 381.583 162.19C381.655 162.409 381.675 162.641 381.644 162.869C381.612 163.098 381.528 163.316 381.399 163.507C381.27 163.698 381.099 163.858 380.899 163.974Z"
                fill="#D8E5FF"
            />
            <path
                d="M361.075 184.245V184.257C360.827 184.163 360.614 183.996 360.464 183.778C360.315 183.559 360.237 183.3 360.24 183.036C359.798 171.662 356.385 162.487 353.795 158.764C353.641 158.546 353.548 158.292 353.525 158.026C356.912 158.751 360.404 158.845 363.824 158.305C366.562 162.922 361.811 182.517 361.075 184.245Z"
                fill="url(#330618e3__paint4_linear_19033_11)"
            />
            <path
                d="M217.753 135.331C218.912 141.263 221.383 148.012 225.813 150.682C225.949 150.777 226.062 150.901 226.143 151.045C226.223 151.19 226.27 151.351 226.279 151.516C226.288 151.681 226.26 151.846 226.196 151.999C226.131 152.152 226.033 152.288 225.908 152.398C220.77 156.548 217.201 162.313 215.79 168.744C215.753 168.948 215.644 169.133 215.482 169.265C215.32 169.396 215.116 169.466 214.908 169.462C214.699 169.458 214.499 169.38 214.343 169.242C214.187 169.103 214.086 168.914 214.058 168.709C212.145 160.774 208.462 154.795 206.112 152.54C205.997 152.429 205.909 152.293 205.854 152.142C205.799 151.992 205.779 151.832 205.795 151.672C205.811 151.513 205.862 151.359 205.946 151.223C206.029 151.086 206.142 150.969 206.277 150.882C209.61 148.9 213.886 143.544 216.009 135.246C216.048 135.037 216.161 134.848 216.329 134.716C216.496 134.583 216.707 134.516 216.92 134.526C217.134 134.537 217.336 134.624 217.489 134.772C217.643 134.92 217.737 135.119 217.753 135.331Z"
                fill="white"
            />
            <path
                d="M225.91 152.403C220.769 156.55 217.199 162.315 215.787 168.746C215.748 168.966 215.625 169.163 215.444 169.294C215.262 169.426 215.037 169.483 214.815 169.453L214.813 169.444C215.088 168.125 215.678 153.676 213.105 150.813C215.925 148.615 216.806 137.785 217.012 134.544C217.202 134.584 217.375 134.681 217.508 134.822C217.641 134.963 217.726 135.142 217.753 135.333C218.91 141.264 221.38 148.012 225.811 150.69C225.947 150.784 226.06 150.908 226.141 151.052C226.222 151.196 226.269 151.357 226.279 151.522C226.289 151.687 226.26 151.852 226.197 152.004C226.133 152.157 226.035 152.293 225.91 152.403Z"
                fill="#D8E5FF"
            />
            <path
                d="M214.813 169.444L214.815 169.452C214.627 169.421 214.454 169.333 214.318 169.201C214.183 169.068 214.091 168.897 214.056 168.711C212.149 160.773 208.46 154.799 206.116 152.544C205.977 152.412 205.876 152.246 205.822 152.063C208.306 152.097 210.775 151.673 213.105 150.813C215.679 153.676 215.089 168.125 214.813 169.444Z"
                fill="url(#330618e3__paint5_linear_19033_11)"
            />
            <path
                d="M410.053 57.9599C413.244 53.4077 415.349 51.2867 418.983 47.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M419.015 58.8192C421.451 56.8974 426.635 52.7887 429.071 50.867"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
        </g>
        <defs>
            <linearGradient
                id="330618e3__paint0_linear_19033_11"
                x1={336.501}
                y1={-5}
                x2={351.774}
                y2={188.36}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.428979} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="330618e3__paint1_linear_19033_11"
                x1={200}
                y1={23}
                x2={225.828}
                y2={270.729}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.189743} stopColor="#ECF2F9" />
                <stop offset={0.663927} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="330618e3__paint2_linear_19033_11"
                x1={262.362}
                y1={73.7255}
                x2={268.513}
                y2={103.694}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="330618e3__paint3_linear_19033_11"
                x1={317.195}
                y1={146.239}
                x2={337.465}
                y2={35.0437}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="330618e3__paint4_linear_19033_11"
                x1={359}
                y1={160}
                x2={363}
                y2={187.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="330618e3__paint5_linear_19033_11"
                x1={209.95}
                y1={152.682}
                x2={216.624}
                y2={171.463}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <clipPath id="330618e3__clip0_19033_11">
                <rect width={532} height={204} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default Promo500L;
