import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo500M = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 307 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#06744177__clip0_19033_10)">
            <g opacity={0.6}>
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="url(#06744177__paint0_linear_19033_10)"
                />
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="#F2F6FB"
                />
            </g>
            <path
                d="M246.372 36.3185C249.058 32.4882 250.829 30.7035 253.887 27.0967"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M253.913 37.0417C255.964 35.4247 260.326 31.9676 262.376 30.3506"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M176.344 41.2637C176.311 49.0706 177.735 58.2427 182.671 62.7444C182.82 62.8988 182.931 63.0847 182.997 63.2881C183.063 63.4915 183.081 63.7071 183.051 63.9187C183.021 64.1302 182.943 64.3322 182.823 64.5094C182.703 64.6866 182.544 64.8344 182.358 64.9416C174.8 68.8985 168.822 75.2981 165.408 83.0865C165.309 83.3361 165.124 83.5424 164.886 83.6683C164.648 83.7941 164.372 83.8313 164.109 83.7732C163.845 83.715 163.611 83.5653 163.449 83.3509C163.287 83.1366 163.206 82.8717 163.223 82.6038C162.807 72.0709 159.652 63.5665 157.246 60.117C157.129 59.9466 157.052 59.7521 157.02 59.548C156.988 59.3438 157.003 59.1352 157.064 58.9376C157.124 58.7399 157.228 58.5583 157.368 58.4061C157.509 58.2539 157.682 58.135 157.875 58.0582C162.597 56.3913 169.368 50.6887 174.156 40.7159C174.258 40.4603 174.449 40.2502 174.695 40.1248C174.941 39.9993 175.224 39.9672 175.492 40.0342C175.76 40.1013 175.994 40.2631 176.151 40.4893C176.308 40.7155 176.376 40.9908 176.344 41.2637Z"
                fill="white"
            />
            <path
                d="M182.36 64.949C174.8 68.902 168.819 75.3001 165.404 83.0885C165.299 83.3572 165.094 83.5751 164.831 83.6962C164.568 83.8173 164.268 83.8323 163.994 83.738V83.7268C164.677 82.1255 169.078 63.9749 166.542 59.6976C170.67 57.626 174.525 44.1333 175.605 40.0801C175.836 40.1787 176.031 40.3454 176.163 40.5577C176.295 40.77 176.358 41.0176 176.344 41.2669C176.31 49.0713 177.732 58.2419 182.667 62.7545C182.816 62.9081 182.928 63.0934 182.994 63.2964C183.061 63.4993 183.08 63.7146 183.05 63.926C183.021 64.1374 182.943 64.3393 182.824 64.5165C182.704 64.6937 182.546 64.8416 182.36 64.949Z"
                fill="#D8E5FF"
            />
            <path
                d="M163.994 83.7258V83.737C163.764 83.6499 163.567 83.4948 163.428 83.2925C163.29 83.0903 163.218 82.8507 163.221 82.6061C162.811 72.0695 159.65 63.5708 157.25 60.122C157.108 59.9203 157.021 59.6846 157 59.439C160.137 60.1099 163.372 60.1972 166.541 59.6966C169.077 63.9739 164.676 82.1245 163.994 83.7258Z"
                fill="#ECF1FF"
            />
            <path
                d="M248.968 96.9284L212.636 52.4623C210.186 49.4644 205.942 48.6506 202.557 50.53L143.692 83.2168C143.692 83.2168 141.641 109.221 138.957 133.414C139.036 136.172 145.665 136.487 147.954 137.984C157.266 143.815 176.364 156.266 224.504 153.35C227.66 153.193 233.5 154.533 234.684 151.617C237.131 141.53 242.655 123.405 248.968 96.9284Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M207.551 80.2632L205.551 90.7632L183.051 144.763L180.051 142.263L207.551 80.2632Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M223.303 37.6168C219.155 44.4678 213.67 51.9947 212.478 53.8764C213.642 55.3294 213.8 56.5373 213.243 57.5934C212.39 59.2126 210.487 59.9264 208.855 59.3272C201.476 71.2009 179.744 93.5061 168.976 102.246C170.992 105.407 189.022 124.783 195.122 130.117C196.038 130.917 197.387 130.95 198.338 130.192C216.202 115.955 238.727 87.7825 241.271 83.664C241.425 83.4151 241.421 83.1142 241.275 82.8603C240.806 82.039 240.404 80.4998 240.938 79.4208C241.663 77.9553 243.42 77.3383 245.205 77.5019C245.503 77.5293 245.792 77.4117 245.957 77.1627C247.583 74.706 253.479 63.8044 256.346 57.8742C256.899 56.7287 256.505 55.3602 255.426 54.6849C249.1 50.7217 233.031 40.5156 226.719 36.7565C225.538 36.0519 224.016 36.4399 223.303 37.6168Z"
                fill="#FFCC00"
            />
            <path
                d="M226.65 77.6241C226.763 77.3629 226.719 77.0722 226.545 76.8468C226.002 76.1392 225.499 74.8359 225.743 73.6592C226.114 71.8676 227.93 71.0772 229.746 71.0202C230.049 71.0108 230.324 70.8534 230.454 70.5796C231.696 67.9737 235.645 56.947 237.612 50.8303C237.996 49.6356 237.431 48.3508 236.29 47.827C231.069 45.4252 219.587 40.0666 211.514 36.4011C208.34 42.3288 204.924 47.9645 204.076 49.5817C205.354 50.935 205.61 52.1261 205.141 53.224C204.422 54.9073 202.584 55.7736 200.909 55.3091C194.519 67.7438 174.676 91.7443 164.655 101.332C166.853 104.228 185.303 121.097 192.358 126.509C209.716 107.894 224.682 82.1352 226.65 77.6241Z"
                fill="#EBB409"
            />
            <path
                d="M198.105 33.7311C195.535 40.5846 192.317 47.7703 191.215 50.3819C191.089 50.6816 191.175 51.0132 191.401 51.2467C192.487 52.3625 192.774 53.5378 192.367 54.5321C191.818 55.8752 190.523 56.5729 188.859 56.8288C188.588 56.8707 188.357 57.0382 188.254 57.2926C183.193 69.7161 167.022 93.57 157.698 105.134C156.829 106.213 156.999 107.783 158.081 108.648C164.193 113.543 181.59 125.558 187.487 128.84C188.444 129.372 189.833 129.138 190.56 128.32C207.979 108.691 222.851 79.8649 224.67 75.0422C224.77 74.7757 224.71 74.4874 224.525 74.2709C223.948 73.5914 223.379 72.3158 223.562 71.1284C223.842 69.3205 225.615 68.4395 227.426 68.2896C227.728 68.2647 227.994 68.0936 228.11 67.814C229.218 65.1486 232.602 53.9359 234.255 47.7279C234.578 46.5156 233.948 45.2609 232.783 44.7953C225.87 42.0309 208.207 34.8418 201.314 32.2631C200.023 31.7783 198.589 32.4394 198.105 33.7311Z"
                fill="url(#06744177__paint1_linear_19033_10)"
            />
            <path
                d="M188.827 100.173C189.402 100.521 189.869 100.944 190.227 101.441C190.575 101.932 190.809 102.473 190.928 103.064C191.044 103.639 191.041 104.247 190.919 104.888C190.787 105.524 190.532 106.155 190.153 106.781C189.718 107.5 189.276 108.046 188.826 108.419C188.376 108.792 187.949 109.08 187.545 109.285L185.65 108.139C186.088 107.927 186.554 107.654 187.049 107.323C187.55 106.981 187.987 106.502 188.359 105.886C188.788 105.177 188.914 104.517 188.737 103.905C188.566 103.283 188.183 102.792 187.587 102.432C186.992 102.072 186.43 101.935 185.9 102.021C185.377 102.098 184.933 102.439 184.566 103.045C184.349 103.404 184.23 103.739 184.211 104.05C184.191 104.361 184.224 104.619 184.31 104.825L183.341 106.427L177.288 102.766L181.228 96.2509L183.015 97.3315L180.211 101.968L182.706 103.477C182.678 103.221 182.697 102.924 182.762 102.585C182.827 102.245 182.99 101.86 183.251 101.429C183.89 100.371 184.703 99.7339 185.69 99.5172C186.672 99.2839 187.718 99.5027 188.827 100.173ZM195.694 97.6197C195.352 98.1844 194.931 98.6378 194.429 98.9797C193.928 99.3216 193.349 99.5254 192.692 99.591C192.025 99.6504 191.273 99.5603 190.437 99.3207C189.606 99.0709 188.688 98.6416 187.681 98.0331C186.675 97.4245 185.874 96.8135 185.277 96.2002C184.676 95.5704 184.252 94.9495 184.005 94.3374C183.748 93.7191 183.66 93.1117 183.74 92.5151C183.81 91.9124 184.016 91.3287 184.357 90.7639C184.693 90.2094 185.108 89.7663 185.603 89.4347C186.094 89.0865 186.668 88.8797 187.325 88.814C187.981 88.7484 188.725 88.8406 189.556 89.0904C190.376 89.3341 191.284 89.7571 192.28 90.3595C193.286 90.968 194.093 91.5821 194.7 92.2016C195.307 92.8211 195.739 93.4401 195.996 94.0584C196.253 94.6767 196.352 95.2903 196.292 95.8992C196.228 96.4917 196.029 97.0652 195.694 97.6197ZM193.959 96.5918C194.121 96.3248 194.202 96.0514 194.203 95.7715C194.194 95.4854 194.075 95.1825 193.848 94.8627C193.621 94.5429 193.274 94.2001 192.808 93.8342C192.348 93.458 191.744 93.0433 190.994 92.5899C190.255 92.1428 189.612 91.8031 189.065 91.5707C188.525 91.328 188.06 91.1802 187.672 91.1274C187.289 91.0643 186.969 91.0951 186.711 91.2198C186.46 91.3341 186.25 91.5299 186.082 91.8072C185.915 92.0844 185.836 92.3661 185.845 92.6522C185.854 92.9383 185.969 93.2463 186.19 93.5764C186.418 93.8962 186.761 94.2442 187.221 94.6203C187.687 94.9862 188.289 95.3927 189.029 95.8398C189.778 96.2932 190.423 96.6412 190.964 96.8838C191.51 97.1163 191.978 97.2589 192.367 97.3117C192.762 97.3542 193.085 97.3183 193.337 97.2039C193.584 97.0731 193.791 96.8691 193.959 96.5918ZM200.815 89.1514C200.473 89.7162 200.052 90.1695 199.551 90.5114C199.049 90.8534 198.47 91.0571 197.814 91.1227C197.147 91.1821 196.395 91.092 195.558 90.8524C194.727 90.6026 193.809 90.1734 192.803 89.5648C191.796 88.9562 190.995 88.3453 190.398 87.7319C189.797 87.1022 189.374 86.4812 189.127 85.8691C188.87 85.2508 188.781 84.6434 188.861 84.0469C188.931 83.4441 189.137 82.8604 189.479 82.2956C189.814 81.7411 190.229 81.2981 190.724 80.9664C191.215 80.6183 191.789 80.4114 192.446 80.3458C193.103 80.2802 193.846 80.3723 194.677 80.6222C195.497 80.8658 196.405 81.2888 197.401 81.8912C198.408 82.4998 199.214 83.1138 199.821 83.7333C200.428 84.3529 200.86 84.9718 201.118 85.5901C201.375 86.2084 201.473 86.822 201.414 87.431C201.35 88.0234 201.15 88.5969 200.815 89.1514ZM199.081 88.1235C199.242 87.8566 199.323 87.5831 199.324 87.3032C199.315 87.0172 199.197 86.7142 198.969 86.3944C198.742 86.0746 198.395 85.7318 197.929 85.3659C197.47 84.9897 196.865 84.575 196.116 84.1217C195.376 83.6745 194.733 83.3348 194.187 83.1024C193.646 82.8597 193.182 82.712 192.793 82.6591C192.41 82.5961 192.09 82.6268 191.833 82.7515C191.581 82.8658 191.372 83.0616 191.204 83.3389C191.036 83.6161 190.957 83.8978 190.966 84.1839C190.976 84.47 191.091 84.7781 191.312 85.1081C191.539 85.4279 191.883 85.7759 192.342 86.152C192.808 86.5179 193.411 86.9244 194.15 87.3716C194.9 87.8249 195.545 88.1729 196.085 88.4156C196.632 88.648 197.099 88.7906 197.488 88.8434C197.883 88.8859 198.206 88.85 198.458 88.7357C198.705 88.6048 198.913 88.4008 199.081 88.1235ZM200.805 75.1857L195.799 72.1583L197.597 69.1857C197.938 68.6209 198.315 68.1479 198.728 67.7665C199.137 67.3687 199.575 67.0862 200.04 66.9191C200.506 66.752 201 66.7002 201.523 66.7638C202.045 66.8273 202.589 67.0299 203.153 67.3714C203.728 67.7192 204.157 68.1117 204.44 68.549C204.718 68.9698 204.883 69.4273 204.935 69.9214C204.987 70.4155 204.926 70.9328 204.754 71.4735C204.581 72.0141 204.324 72.5668 203.982 73.1316L203.554 73.8401L204.478 74.399L206.294 71.3955L207.711 72.2525L205.895 75.256L208.174 76.6346L206.842 78.8371L204.563 77.4585L203.901 78.5521L202.484 77.6951L203.146 76.6015L202.222 76.0426L201.56 77.1362L200.143 76.2792L200.805 75.1857ZM198.841 70.9897L202.137 72.9831L202.584 72.2438C203.242 71.1554 202.996 70.2634 201.846 69.5679C201.271 69.2201 200.788 69.1032 200.396 69.2171C200.011 69.3207 199.648 69.6549 199.306 70.2196L198.841 70.9897Z"
                fill="white"
            />
            <path
                d="M196.966 56.011C197.472 56.2859 197.657 56.9192 197.382 57.4247C197.258 57.6513 197.063 57.8136 196.839 57.8992C196.563 58.0049 196.245 57.9937 195.966 57.8417C195.466 57.5684 195.241 56.9253 195.507 56.4215C195.773 55.917 196.359 55.701 196.867 55.9597L196.392 56.8878L196.881 55.967C196.889 55.9709 196.957 56.0064 196.966 56.011ZM206.14 60.0119C205.612 59.7831 204.997 60.0239 204.767 60.5537C204.538 61.0817 204.78 61.6958 205.309 61.9243L205.417 61.9697C205.67 62.07 205.939 62.0644 206.175 61.974C206.438 61.8734 206.66 61.6669 206.772 61.3856C206.984 60.85 206.724 60.2446 206.188 60.0322L206.14 60.0119ZM201.031 58.9897L201.447 58.0333C200.919 57.8045 200.304 58.0453 200.074 58.5751C199.845 59.1031 200.087 59.7172 200.616 59.9457C200.623 59.9494 200.706 59.9845 200.714 59.987C200.969 60.0918 201.242 60.0873 201.481 59.9957C201.741 59.8963 201.961 59.6933 202.074 59.4162C202.292 58.8835 202.037 58.2752 201.503 58.0575L201.031 58.9897ZM210.826 62.0066C210.298 61.7768 209.717 62.0335 209.488 62.563C209.258 63.091 209.533 63.7184 210.062 63.948C210.325 64.0651 210.611 64.0645 210.86 63.969C211.11 63.8735 211.323 63.683 211.44 63.4202C211.675 62.8946 211.439 62.2789 210.913 62.0439L210.826 62.0066ZM220.22 66.3628C220.211 66.3581 220.127 66.3151 220.117 66.31C219.607 66.0583 219.024 66.2779 218.763 66.7851C218.501 67.2915 218.731 67.9315 219.233 68.2008C219.512 68.3486 219.827 68.3591 220.1 68.2547C220.326 68.1681 220.523 68.0026 220.646 67.7733C220.919 67.2654 220.728 66.6342 220.22 66.3628ZM215.49 64.0831C214.969 63.8513 214.397 64.0974 214.156 64.6134C213.916 65.1295 214.173 65.7596 214.686 66.0075C214.956 66.138 215.254 66.1417 215.514 66.0423C215.753 65.9506 215.96 65.7715 216.08 65.5228C216.331 65.0037 216.114 64.3805 215.596 64.1301C215.585 64.1261 215.499 64.0867 215.49 64.0831Z"
                fill="#891712"
            />
            <path
                d="M248.968 96.9288L193.568 118.127C191.516 118.915 189.227 118.599 187.491 117.26L143.692 83.2173C143.692 83.2173 140.062 107.646 138.957 133.414C139.036 136.172 140.535 138.694 142.824 140.191C156.24 147.047 187.491 156.739 227.66 156.739C230.817 156.582 233.579 154.612 234.763 151.696C238.314 141.531 243.049 125.376 248.968 96.9288Z"
                fill="#D4E0ED"
            />
            <path
                d="M239.072 122.369C239.041 129.46 240.335 137.792 244.819 141.881C244.954 142.021 245.055 142.19 245.115 142.375C245.175 142.559 245.191 142.755 245.164 142.947C245.137 143.14 245.066 143.323 244.957 143.484C244.848 143.645 244.703 143.779 244.535 143.877C237.669 147.471 232.239 153.284 229.138 160.359C229.048 160.585 228.88 160.773 228.663 160.887C228.447 161.001 228.197 161.035 227.957 160.982C227.718 160.929 227.506 160.793 227.358 160.599C227.211 160.404 227.138 160.163 227.153 159.92C226.775 150.352 223.91 142.627 221.724 139.494C221.618 139.339 221.547 139.163 221.519 138.977C221.49 138.792 221.503 138.602 221.558 138.423C221.613 138.243 221.708 138.078 221.835 137.94C221.963 137.802 222.12 137.694 222.295 137.624C226.584 136.11 232.735 130.93 237.084 121.871C237.176 121.639 237.35 121.448 237.574 121.334C237.797 121.22 238.054 121.191 238.298 121.252C238.541 121.313 238.754 121.46 238.896 121.665C239.039 121.871 239.101 122.121 239.072 122.369Z"
                fill="white"
            />
            <path
                d="M244.535 143.883C237.667 147.473 232.234 153.285 229.132 160.36C229.037 160.604 228.851 160.802 228.612 160.912C228.373 161.022 228.1 161.036 227.852 160.95V160.94C228.471 159.485 232.469 142.998 230.165 139.113C233.915 137.231 237.417 124.975 238.399 121.293C238.608 121.383 238.785 121.534 238.905 121.727C239.025 121.92 239.083 122.145 239.07 122.371C239.039 129.46 240.33 137.79 244.814 141.889C244.949 142.029 245.05 142.197 245.111 142.382C245.171 142.566 245.188 142.762 245.161 142.954C245.134 143.146 245.064 143.329 244.955 143.49C244.847 143.651 244.703 143.785 244.535 143.883Z"
                fill="#D8E5FF"
            />
            <path
                d="M227.853 160.94V160.95C227.644 160.871 227.465 160.73 227.339 160.546C227.214 160.362 227.148 160.145 227.151 159.922C226.779 150.351 223.907 142.632 221.727 139.499C221.598 139.316 221.519 139.102 221.5 138.878C224.35 139.488 227.288 139.567 230.167 139.112C232.471 142.998 228.473 159.485 227.853 160.94Z"
                fill="#ECF1FF"
            />
            <path
                d="M126.133 51.8481C126.013 51.8484 125.892 51.8336 125.775 51.8041C125.594 51.7592 125.423 51.679 125.273 51.5682C125.122 51.4574 124.996 51.3182 124.9 51.1585C124.804 50.9988 124.741 50.8218 124.714 50.6378C124.687 50.4537 124.697 50.2661 124.743 50.086L125.797 46.0586C125.897 45.6959 126.136 45.3864 126.462 45.1966C126.788 45.0068 127.176 44.9517 127.543 45.0432C127.724 45.0881 127.895 45.1682 128.045 45.279C128.196 45.3898 128.322 45.5291 128.418 45.6888C128.514 45.8485 128.577 46.0254 128.604 46.2095C128.631 46.3936 128.621 46.5811 128.575 46.7613L127.521 50.7887C127.44 51.0929 127.26 51.3619 127.009 51.5536C126.758 51.7452 126.45 51.8488 126.133 51.8481Z"
                fill="#1CB5F9"
            />
            <path
                d="M123.192 63.0882C123.071 63.0885 122.951 63.0737 122.834 63.0442C122.652 62.9993 122.481 62.9191 122.331 62.8083C122.181 62.6975 122.054 62.5583 121.958 62.3986C121.863 62.2389 121.799 62.0619 121.772 61.8779C121.746 61.6938 121.756 61.5062 121.802 61.3261L122.856 57.2987C122.955 56.9358 123.194 56.6261 123.52 56.4362C123.847 56.2463 124.235 56.1914 124.602 56.2832C124.783 56.3281 124.954 56.4083 125.104 56.5191C125.254 56.6299 125.381 56.7692 125.477 56.9288C125.573 57.0885 125.636 57.2655 125.663 57.4496C125.69 57.6337 125.679 57.8212 125.633 58.0014L124.579 62.0287C124.498 62.333 124.318 62.6019 124.067 62.7936C123.816 62.9853 123.508 63.0889 123.192 63.0882Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.944 57.4213C132.823 57.4216 132.702 57.4068 132.585 57.3772L128.494 56.3397C128.312 56.2948 128.142 56.2146 127.991 56.1038C127.841 55.993 127.714 55.8538 127.619 55.6941C127.523 55.5344 127.459 55.3574 127.433 55.1734C127.406 54.9893 127.416 54.8018 127.462 54.6216C127.561 54.2582 127.799 53.9481 128.126 53.7581C128.452 53.568 128.841 53.5135 129.208 53.6061L133.299 54.6436C133.636 54.7269 133.931 54.9303 134.127 55.2153C134.323 55.5003 134.407 55.8471 134.364 56.1897C134.32 56.5324 134.151 56.8471 133.889 57.0741C133.627 57.3011 133.291 57.4247 132.944 57.4213L132.944 57.4213Z"
                fill="#1CB5F9"
            />
            <path
                d="M121.526 54.5252C121.405 54.5256 121.285 54.5108 121.167 54.4812L117.076 53.4451C116.894 53.4002 116.724 53.3201 116.573 53.2094C116.423 53.0986 116.296 52.9593 116.2 52.7996C116.105 52.6399 116.041 52.4629 116.015 52.2788C115.988 52.0947 115.998 51.9071 116.044 51.7269C116.143 51.3637 116.381 51.0536 116.708 50.8636C117.034 50.6736 117.423 50.619 117.79 50.7115L121.881 51.7476C122.218 51.8308 122.513 52.0343 122.709 52.3193C122.905 52.6043 122.99 52.951 122.946 53.2937C122.902 53.6363 122.733 53.951 122.471 54.178C122.21 54.4051 121.873 54.5286 121.526 54.5252L121.526 54.5252Z"
                fill="#1CB5F9"
            />
            <path
                d="M279.133 149.848C279.013 149.848 278.892 149.834 278.775 149.804C278.594 149.759 278.423 149.679 278.273 149.568C278.122 149.457 277.996 149.318 277.9 149.158C277.804 148.999 277.741 148.822 277.714 148.638C277.687 148.454 277.697 148.266 277.743 148.086L278.797 144.059C278.897 143.696 279.136 143.386 279.462 143.197C279.788 143.007 280.176 142.952 280.543 143.043C280.724 143.088 280.895 143.168 281.045 143.279C281.196 143.39 281.322 143.529 281.418 143.689C281.514 143.848 281.577 144.025 281.604 144.21C281.631 144.394 281.621 144.581 281.575 144.761L280.521 148.789C280.44 149.093 280.26 149.362 280.009 149.554C279.758 149.745 279.45 149.849 279.133 149.848Z"
                fill="#1CB5F9"
            />
            <path
                d="M276.192 161.088C276.071 161.089 275.951 161.074 275.834 161.044C275.652 160.999 275.481 160.919 275.331 160.808C275.181 160.698 275.054 160.558 274.958 160.399C274.863 160.239 274.799 160.062 274.772 159.878C274.746 159.694 274.756 159.506 274.802 159.326L275.856 155.299C275.955 154.936 276.194 154.626 276.52 154.436C276.847 154.246 277.235 154.191 277.602 154.283C277.783 154.328 277.954 154.408 278.104 154.519C278.254 154.63 278.381 154.769 278.477 154.929C278.573 155.089 278.636 155.266 278.663 155.45C278.69 155.634 278.679 155.821 278.633 156.001L277.579 160.029C277.498 160.333 277.318 160.602 277.067 160.794C276.816 160.985 276.508 161.089 276.192 161.088Z"
                fill="#1CB5F9"
            />
            <path
                d="M285.944 155.421C285.823 155.422 285.702 155.407 285.585 155.377L281.494 154.34C281.312 154.295 281.142 154.215 280.991 154.104C280.841 153.993 280.714 153.854 280.619 153.694C280.523 153.534 280.459 153.357 280.433 153.173C280.406 152.989 280.416 152.802 280.462 152.622C280.561 152.258 280.799 151.948 281.126 151.758C281.452 151.568 281.841 151.513 282.208 151.606L286.299 152.644C286.636 152.727 286.931 152.93 287.127 153.215C287.323 153.5 287.407 153.847 287.364 154.19C287.32 154.532 287.151 154.847 286.889 155.074C286.627 155.301 286.291 155.425 285.944 155.421L285.944 155.421Z"
                fill="#1CB5F9"
            />
            <path
                d="M274.526 152.525C274.405 152.526 274.285 152.511 274.167 152.481L270.076 151.445C269.894 151.4 269.724 151.32 269.573 151.209C269.423 151.099 269.296 150.959 269.2 150.8C269.105 150.64 269.041 150.463 269.015 150.279C268.988 150.095 268.998 149.907 269.044 149.727C269.143 149.364 269.381 149.054 269.708 148.864C270.034 148.674 270.423 148.619 270.79 148.711L274.881 149.748C275.218 149.831 275.513 150.034 275.709 150.319C275.905 150.604 275.99 150.951 275.946 151.294C275.902 151.636 275.733 151.951 275.471 152.178C275.21 152.405 274.873 152.529 274.526 152.525L274.526 152.525Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="06744177__paint0_linear_19033_10"
                x1={144.412}
                y1={24.1047}
                x2={190.955}
                y2={238.576}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.206374} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="06744177__paint1_linear_19033_10"
                x1={187.943}
                y1={127.506}
                x2={204.995}
                y2={33.944}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="06744177__clip0_19033_10">
                <rect width={307} height={180} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default Promo500M;
