import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo500S = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 280 193"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#56f3da8a__clip0_19033_9)">
            <path
                opacity={0.7}
                d="M413.264 188.781L371.412 60.464C371.412 60.464 365.546 20.0153 326.318 34.2319C300.014 43.7709 287.091 51.0168 267.294 61.3812C259.136 65.692 251.163 68.1685 244.655 69.7277C245.572 55.2359 241.264 39.1848 225.041 38.3594C215.418 37.809 200.112 38.9097 193.696 45.3301C198.554 31.0217 182.371 11.6221 164.865 10.0629C114.378 5.56573 77.5164 41.4554 64.2266 91.4429C41.405 89.2416 18.9753 114.648 38.4058 129.323C18.1504 127.122 -19.4894 164.291 -21.2308 185.295C-21.5058 187.313 -20.131 188.781 -17.8396 188.781C10.5729 190.34 39.077 191.257 67.4895 193C79.4044 191.807 91.3194 190.34 103.143 188.505C174.174 189.056 413.264 188.781 413.264 188.781Z"
                fill="url(#56f3da8a__paint0_linear_19033_9)"
            />
            <path
                d="M211.742 131.019C211.63 131.019 211.519 131.006 211.41 130.978C211.242 130.937 211.084 130.862 210.945 130.76C210.806 130.657 210.689 130.528 210.6 130.38C210.511 130.232 210.453 130.068 210.428 129.898C210.403 129.728 210.412 129.554 210.455 129.387L211.431 125.657C211.523 125.321 211.744 125.035 212.046 124.859C212.349 124.683 212.708 124.632 213.048 124.717C213.216 124.758 213.374 124.833 213.513 124.935C213.652 125.038 213.77 125.167 213.858 125.315C213.947 125.463 214.006 125.626 214.03 125.797C214.055 125.967 214.046 126.141 214.003 126.308L213.027 130.038C212.952 130.32 212.785 130.569 212.553 130.746C212.32 130.924 212.035 131.02 211.742 131.019Z"
                fill="#1CB5F9"
            />
            <path
                d="M209.02 141.428C208.908 141.429 208.796 141.415 208.688 141.388C208.52 141.346 208.362 141.272 208.222 141.169C208.083 141.067 207.966 140.938 207.877 140.79C207.788 140.642 207.73 140.478 207.705 140.308C207.68 140.137 207.689 139.963 207.732 139.796L208.708 136.067C208.8 135.731 209.021 135.444 209.323 135.268C209.626 135.092 209.985 135.041 210.325 135.126C210.493 135.168 210.651 135.242 210.79 135.345C210.93 135.447 211.047 135.576 211.136 135.724C211.224 135.872 211.283 136.036 211.308 136.206C211.333 136.377 211.323 136.551 211.28 136.717L210.304 140.447C210.229 140.729 210.063 140.978 209.83 141.156C209.598 141.333 209.313 141.429 209.02 141.428Z"
                fill="#1CB5F9"
            />
            <path
                d="M218.051 136.181C217.939 136.181 217.828 136.167 217.719 136.14L213.93 135.179C213.762 135.137 213.604 135.063 213.465 134.96C213.325 134.858 213.208 134.729 213.119 134.581C213.031 134.433 212.972 134.269 212.947 134.099C212.922 133.928 212.932 133.755 212.975 133.588C213.066 133.251 213.287 132.964 213.589 132.788C213.891 132.612 214.251 132.561 214.591 132.647L218.38 133.608C218.692 133.685 218.965 133.874 219.147 134.138C219.329 134.402 219.407 134.723 219.366 135.04C219.325 135.357 219.169 135.649 218.927 135.859C218.684 136.069 218.373 136.184 218.051 136.181L218.051 136.181Z"
                fill="#1CB5F9"
            />
            <path
                d="M207.475 133.498C207.363 133.498 207.252 133.485 207.143 133.457L203.354 132.498C203.186 132.456 203.028 132.382 202.888 132.279C202.749 132.177 202.632 132.048 202.543 131.9C202.454 131.752 202.396 131.588 202.371 131.418C202.346 131.247 202.356 131.073 202.398 130.906C202.49 130.57 202.711 130.283 203.013 130.107C203.315 129.931 203.675 129.88 204.015 129.966L207.804 130.926C208.116 131.003 208.389 131.191 208.571 131.455C208.753 131.719 208.831 132.04 208.79 132.357C208.749 132.675 208.593 132.966 208.351 133.176C208.108 133.387 207.797 133.501 207.475 133.498L207.475 133.498Z"
                fill="#1CB5F9"
            />
            <path
                d="M189.116 38.9752C191.198 36.0063 192.571 34.6231 194.941 31.8274"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M194.964 39.5357C196.553 38.2824 199.934 35.6028 201.524 34.3495"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M85.8673 45.3178C85.7554 45.3181 85.6439 45.3044 85.5354 45.277C85.3673 45.2354 85.2092 45.1612 85.0701 45.0586C84.931 44.956 84.8136 44.827 84.7248 44.6791C84.636 44.5312 84.5775 44.3673 84.5527 44.1968C84.5278 44.0264 84.5371 43.8527 84.58 43.6858L85.5562 39.9559C85.6484 39.62 85.8693 39.3335 86.1715 39.1577C86.4737 38.9819 86.8331 38.9309 87.1727 39.0156C87.3408 39.0572 87.4989 39.1314 87.6381 39.234C87.7772 39.3366 87.8945 39.4656 87.9833 39.6135C88.0721 39.7614 88.1306 39.9253 88.1555 40.0957C88.1803 40.2662 88.171 40.4399 88.1281 40.6068L87.152 44.3366C87.077 44.6184 86.9102 44.8675 86.6778 45.045C86.4454 45.2225 86.1604 45.3184 85.8673 45.3178Z"
                fill="#1CB5F9"
            />
            <path
                d="M83.1446 55.7273C83.0327 55.7276 82.9212 55.7139 82.8128 55.6865C82.6447 55.6449 82.4865 55.5707 82.3474 55.4681C82.2083 55.3655 82.091 55.2365 82.0022 55.0886C81.9134 54.9407 81.8549 54.7768 81.83 54.6063C81.8051 54.4359 81.8144 54.2622 81.8574 54.0953L82.8335 50.3655C82.9254 50.0294 83.1462 49.7425 83.4485 49.5667C83.7508 49.3908 84.1104 49.34 84.45 49.4251C84.6181 49.4666 84.7763 49.5409 84.9154 49.6435C85.0545 49.7461 85.1718 49.8751 85.2606 50.023C85.3494 50.1709 85.408 50.3348 85.4328 50.5052C85.4577 50.6757 85.4484 50.8494 85.4055 51.0163L84.4293 54.7461C84.3543 55.0278 84.1876 55.2769 83.9551 55.4545C83.7227 55.632 83.4377 55.7279 83.1446 55.7273Z"
                fill="#1CB5F9"
            />
            <path
                d="M92.176 50.4794C92.0641 50.4797 91.9526 50.466 91.8442 50.4386L88.055 49.4777C87.8869 49.4362 87.7287 49.3619 87.5896 49.2593C87.4505 49.1567 87.3332 49.0277 87.2444 48.8798C87.1555 48.7319 87.097 48.568 87.0722 48.3976C87.0473 48.2271 87.0566 48.0534 87.0995 47.8865C87.1908 47.5501 87.4115 47.2628 87.714 47.0868C88.0165 46.9109 88.3764 46.8603 88.7161 46.9461L92.5053 47.907C92.8174 47.9841 93.0903 48.1725 93.272 48.4364C93.4538 48.7004 93.5317 49.0215 93.4911 49.3389C93.4505 49.6562 93.2941 49.9477 93.0517 50.1579C92.8092 50.3682 92.4976 50.4826 92.176 50.4794L92.176 50.4794Z"
                fill="#1CB5F9"
            />
            <path
                d="M81.6 47.7969C81.4881 47.7972 81.3766 47.7835 81.2681 47.7561L77.4789 46.7965C77.3108 46.755 77.1526 46.6808 77.0134 46.5782C76.8743 46.4756 76.7569 46.3466 76.6681 46.1987C76.5793 46.0508 76.5208 45.8869 76.496 45.7164C76.4711 45.5459 76.4805 45.3722 76.5235 45.2053C76.6149 44.8689 76.8356 44.5817 77.138 44.4057C77.4405 44.2298 77.8004 44.1792 78.14 44.2649L81.9292 45.2244C82.2414 45.3015 82.5142 45.4899 82.696 45.7539C82.8777 46.0178 82.9556 46.3389 82.915 46.6563C82.8744 46.9736 82.718 47.2651 82.4756 47.4753C82.2332 47.6856 81.9216 47.8 81.6 47.7969L81.6 47.7969Z"
                fill="#1CB5F9"
            />
            <path
                d="M128.196 36.058C128.168 42.5942 129.36 50.2732 133.493 54.0422C133.618 54.1714 133.711 54.3271 133.766 54.4974C133.821 54.6677 133.836 54.8482 133.811 55.0253C133.786 55.2024 133.721 55.3715 133.62 55.5199C133.52 55.6682 133.387 55.792 133.231 55.8818C126.903 59.1945 121.898 64.5525 119.04 71.0731C118.957 71.2821 118.802 71.4548 118.603 71.5602C118.403 71.6656 118.173 71.6967 117.952 71.648C117.732 71.5993 117.536 71.474 117.4 71.2945C117.264 71.1151 117.197 70.8933 117.211 70.669C116.862 61.8505 114.221 54.7305 112.207 51.8424C112.109 51.6998 112.044 51.537 112.017 51.3661C111.991 51.1951 112.003 51.0205 112.054 50.855C112.104 50.6895 112.192 50.5375 112.309 50.41C112.427 50.2826 112.571 50.1831 112.733 50.1188C116.687 48.7232 122.355 43.9488 126.364 35.5993C126.449 35.3854 126.61 35.2095 126.815 35.1045C127.021 34.9994 127.258 34.9725 127.483 35.0287C127.707 35.0848 127.903 35.2202 128.034 35.4096C128.165 35.599 128.223 35.8295 128.196 36.058Z"
                fill="white"
            />
            <path
                d="M133.232 55.8873C126.902 59.1968 121.895 64.5535 119.036 71.0741C118.948 71.2991 118.776 71.4815 118.556 71.5829C118.336 71.6843 118.085 71.6969 117.855 71.6179V71.6085C118.427 70.2679 122.111 55.0717 119.988 51.4907C123.444 49.7563 126.672 38.4598 127.577 35.0664C127.77 35.1489 127.933 35.2885 128.043 35.4663C128.154 35.644 128.207 35.8513 128.195 36.06C128.167 42.5941 129.357 50.272 133.489 54.05C133.614 54.1786 133.707 54.3338 133.763 54.5037C133.818 54.6736 133.834 54.8539 133.81 55.0308C133.785 55.2078 133.72 55.3768 133.62 55.5252C133.52 55.6736 133.387 55.7974 133.232 55.8873Z"
                fill="#D8E5FF"
            />
            <path
                d="M117.855 71.6085V71.6179C117.663 71.5449 117.498 71.415 117.382 71.2457C117.266 71.0764 117.206 70.8758 117.208 70.671C116.865 61.8495 114.218 54.7342 112.209 51.8467C112.09 51.6779 112.018 51.4806 112 51.2749C114.627 51.8366 117.335 51.9098 119.988 51.4906C122.111 55.0717 118.427 70.2678 117.855 71.6085Z"
                fill="#ECF1FF"
            />
            <g clipPath="url(#56f3da8a__clip1_19033_9)">
                <path
                    d="M186.51 82.5602L160.542 50.9319C158.094 47.9502 153.867 47.1404 150.49 49.0063L108.149 72.4035C108.149 72.4035 106.622 91.6659 104.625 109.586C104.684 111.629 109.618 111.862 111.322 112.971C118.253 117.291 132.469 126.514 168.301 124.354C170.651 124.237 174.997 125.23 175.878 123.07C177.699 115.598 181.811 102.173 186.51 82.5602Z"
                    fill="#C6D4E3"
                />
                <g
                    style={{
                        mixBlendMode: 'multiply',
                    }}
                >
                    <path
                        d="M166.167 78.1343L164.371 87.5669L144.158 136.077L141.463 133.831L166.167 78.1343Z"
                        fill="#1C508B"
                        fillOpacity={0.1}
                    />
                </g>
                <path
                    d="M167.407 38.6264C164.319 43.7012 160.237 49.2767 159.349 50.6705C160.216 51.7468 160.333 52.6416 159.919 53.4239C159.284 54.6232 157.868 55.152 156.653 54.7081C151.16 63.5034 134.984 80.0257 126.969 86.4998C128.47 88.8409 141.89 103.194 146.431 107.145C147.112 107.738 148.117 107.762 148.825 107.201C162.122 96.6544 178.888 75.786 180.781 72.7353C180.896 72.5509 180.893 72.328 180.784 72.14C180.435 71.5316 180.136 70.3914 180.533 69.5922C181.073 68.5067 182.381 68.0496 183.709 68.1708C183.931 68.1911 184.146 68.104 184.269 67.9195C185.48 66.0998 189.868 58.0246 192.002 53.6318C192.414 52.7833 192.12 51.7696 191.317 51.2694C186.609 48.3337 174.648 40.7737 169.95 37.9892C169.071 37.4673 167.937 37.7547 167.407 38.6264Z"
                    fill="#FFCC00"
                />
                <path
                    d="M169.899 68.2611C169.984 68.0676 169.95 67.8523 169.821 67.6854C169.417 67.1612 169.043 66.1958 169.224 65.3242C169.5 63.9971 170.852 63.4116 172.204 63.3693C172.429 63.3624 172.634 63.2458 172.731 63.043C173.656 61.1127 176.595 52.9448 178.059 48.4139C178.345 47.529 177.924 46.5773 177.075 46.1893C173.188 44.4102 164.642 40.4409 158.634 37.7257C156.27 42.1165 153.728 46.2911 153.096 47.489C154.048 48.4915 154.238 49.3738 153.889 50.1871C153.354 51.4339 151.986 52.0756 150.74 51.7315C145.983 60.9424 131.213 78.7205 123.754 85.8225C125.39 87.9677 139.124 100.463 144.374 104.472C157.295 90.6828 168.434 71.6027 169.899 68.2611Z"
                    fill="#EBB409"
                />
                <path
                    d="M148.653 35.7482C146.74 40.8249 144.345 46.1476 143.524 48.0821C143.43 48.3041 143.494 48.5497 143.663 48.7227C144.471 49.5492 144.685 50.4198 144.382 51.1563C143.973 52.1512 143.009 52.668 141.771 52.8576C141.569 52.8886 141.397 53.0127 141.32 53.2011C137.553 62.4037 125.517 80.0731 118.576 88.6387C117.929 89.438 118.056 90.6011 118.861 91.2421C123.411 94.8681 136.36 103.768 140.75 106.199C141.462 106.593 142.496 106.42 143.037 105.814C156.002 91.2739 167.072 69.9213 168.426 66.3489C168.5 66.1515 168.456 65.9379 168.318 65.7776C167.888 65.2742 167.465 64.3294 167.602 63.4498C167.81 62.1106 169.13 61.458 170.477 61.347C170.702 61.3286 170.9 61.2018 170.987 60.9947C171.811 59.0203 174.33 50.7147 175.56 46.1162C175.801 45.2182 175.332 44.2888 174.465 43.9439C169.319 41.8962 156.172 36.571 151.041 34.6608C150.08 34.3017 149.013 34.7914 148.653 35.7482Z"
                    fill="url(#56f3da8a__paint1_linear_19033_9)"
                />
                <path
                    d="M141.753 85.3431C142.2 85.6136 142.563 85.9422 142.842 86.3289C143.112 86.7109 143.294 87.1317 143.387 87.5914C143.477 88.0383 143.474 88.5113 143.38 89.0103C143.277 89.5046 143.078 89.9953 142.784 90.4825C142.446 91.0415 142.102 91.4661 141.752 91.7562C141.402 92.0463 141.07 92.2708 140.755 92.4298L139.282 91.5386C139.622 91.3734 139.984 91.1617 140.369 90.9038C140.759 90.6378 141.099 90.2653 141.389 89.7861C141.722 89.235 141.82 88.7216 141.682 88.2457C141.55 87.7618 141.252 87.3798 140.788 87.0997C140.325 86.8195 139.888 86.7132 139.476 86.7806C139.069 86.84 138.724 87.1053 138.439 87.5765C138.269 87.856 138.177 88.1166 138.162 88.3582C138.147 88.5999 138.173 88.8008 138.239 88.9611L137.486 90.207L132.778 87.3597L135.842 82.2924L137.232 83.1328L135.051 86.7386L136.992 87.9123C136.97 87.7138 136.985 87.4825 137.035 87.2186C137.086 86.9547 137.212 86.655 137.415 86.3195C137.913 85.4969 138.545 85.0014 139.313 84.8328C140.077 84.6514 140.89 84.8215 141.753 85.3431ZM147.093 83.3569C146.827 83.7962 146.5 84.1488 146.11 84.4147C145.72 84.6807 145.27 84.8392 144.759 84.8902C144.24 84.9364 143.655 84.8663 143.004 84.68C142.358 84.4856 141.644 84.1518 140.861 83.6785C140.079 83.2051 139.455 82.7299 138.991 82.2529C138.524 81.7631 138.194 81.2801 138.002 80.8041C137.802 80.3232 137.733 79.8507 137.796 79.3868C137.85 78.9179 138.01 78.4639 138.276 78.0247C138.537 77.5934 138.86 77.2488 139.245 76.9908C139.627 76.7201 140.073 76.5592 140.584 76.5081C141.095 76.4571 141.673 76.5287 142.319 76.7231C142.957 76.9126 143.663 77.2416 144.438 77.7101C145.221 78.1834 145.848 78.661 146.32 79.1429C146.792 79.6247 147.128 80.1061 147.328 80.587C147.528 81.0679 147.605 81.5452 147.559 82.0188C147.509 82.4796 147.354 82.9257 147.093 83.3569ZM145.744 82.5575C145.87 82.3498 145.933 82.1372 145.934 81.9195C145.926 81.697 145.834 81.4614 145.658 81.2126C145.481 80.9639 145.211 80.6973 144.849 80.4127C144.491 80.1201 144.021 79.7975 143.438 79.4449C142.863 79.0972 142.363 78.8329 141.938 78.6521C141.518 78.4634 141.156 78.3485 140.854 78.3074C140.556 78.2583 140.307 78.2823 140.107 78.3792C139.911 78.4682 139.748 78.6205 139.618 78.8361C139.487 79.0517 139.426 79.2708 139.433 79.4933C139.44 79.7158 139.53 79.9555 139.702 80.2122C139.879 80.4609 140.146 80.7315 140.503 81.0241C140.866 81.3087 141.334 81.6249 141.909 81.9726C142.492 82.3252 142.994 82.5959 143.414 82.7846C143.84 82.9654 144.203 83.0763 144.506 83.1174C144.813 83.1505 145.064 83.1225 145.26 83.0336C145.452 82.9318 145.614 82.7731 145.744 82.5575ZM151.076 76.7705C150.811 77.2098 150.483 77.5624 150.093 77.8283C149.703 78.0942 149.253 78.2527 148.742 78.3038C148.223 78.35 147.638 78.2799 146.988 78.0935C146.342 77.8992 145.627 77.5654 144.845 77.092C144.062 76.6187 143.439 76.1435 142.974 75.6665C142.507 75.1766 142.178 74.6937 141.986 74.2176C141.786 73.7367 141.717 73.2643 141.779 72.8003C141.834 72.3315 141.994 71.8775 142.259 71.4382C142.52 71.007 142.843 70.6624 143.228 70.4044C143.61 70.1336 144.056 69.9727 144.567 69.9217C145.078 69.8706 145.656 69.9423 146.302 70.1366C146.94 70.3262 147.647 70.6552 148.421 71.1237C149.204 71.597 149.832 72.0746 150.304 72.5565C150.776 73.0383 151.112 73.5197 151.312 74.0006C151.512 74.4815 151.589 74.9587 151.542 75.4324C151.492 75.8932 151.337 76.3392 151.076 76.7705ZM149.727 75.9711C149.853 75.7634 149.916 75.5507 149.917 75.3331C149.91 75.1105 149.818 74.8749 149.641 74.6262C149.464 74.3775 149.195 74.1108 148.832 73.8262C148.475 73.5337 148.004 73.2111 147.421 72.8585C146.846 72.5107 146.346 72.2465 145.921 72.0657C145.501 71.877 145.139 71.762 144.837 71.721C144.54 71.6719 144.291 71.6958 144.09 71.7928C143.895 71.8817 143.732 72.034 143.601 72.2497C143.471 72.4653 143.409 72.6844 143.416 72.9069C143.424 73.1294 143.513 73.369 143.685 73.6257C143.862 73.8744 144.129 74.1451 144.487 74.4377C144.849 74.7223 145.318 75.0384 145.893 75.3862C146.476 75.7388 146.977 76.0094 147.398 76.1982C147.823 76.379 148.187 76.4899 148.489 76.5309C148.796 76.564 149.048 76.5361 149.243 76.4472C149.436 76.3454 149.597 76.1867 149.727 75.9711ZM151.068 65.9083L147.175 63.5537L148.573 61.2416C148.839 60.8023 149.132 60.4344 149.454 60.1378C149.772 59.8284 150.112 59.6087 150.474 59.4787C150.836 59.3487 151.22 59.3085 151.627 59.3579C152.033 59.4073 152.456 59.5649 152.895 59.8305C153.342 60.101 153.676 60.4063 153.896 60.7464C154.112 61.0737 154.241 61.4295 154.281 61.8138C154.321 62.1981 154.274 62.6005 154.14 63.021C154.005 63.4415 153.805 63.8714 153.54 64.3107L153.207 64.8617L153.925 65.2964L155.338 62.9604L156.44 63.6269L155.027 65.9629L156.8 67.0352L155.764 68.7483L153.991 67.676L153.477 68.5266L152.375 67.86L152.889 67.0095L152.171 66.5748L151.656 67.4253L150.554 66.7588L151.068 65.9083ZM149.541 62.6448L152.104 64.1952L152.452 63.6202C152.964 62.7736 152.773 62.0798 151.878 61.5389C151.431 61.2684 151.055 61.1775 150.751 61.266C150.451 61.3466 150.169 61.6065 149.903 62.0458L149.541 62.6448Z"
                    fill="white"
                />
                <path
                    d="M147.889 52.2731C148.259 52.4867 148.384 52.9594 148.169 53.3282C148.072 53.4936 147.923 53.6098 147.755 53.6688C147.548 53.7416 147.311 53.727 147.107 53.6089C146.74 53.3966 146.586 52.9158 146.795 52.5481C147.003 52.1798 147.443 52.0315 147.816 52.2332L147.443 52.911L147.826 52.2388C147.832 52.2419 147.882 52.2695 147.889 52.2731ZM154.632 55.4181C154.243 55.2381 153.781 55.4042 153.599 55.792C153.417 56.1784 153.585 56.638 153.974 56.8177L154.053 56.8534C154.239 56.9328 154.439 56.934 154.617 56.8717C154.814 56.8024 154.984 56.6539 155.073 56.4479C155.242 56.0554 155.061 55.602 154.666 55.4341L154.632 55.4181ZM150.852 54.5596L151.181 53.8597C150.792 53.6797 150.33 53.8458 150.148 54.2336C149.966 54.62 150.134 55.0796 150.523 55.2593C150.528 55.2621 150.589 55.2898 150.594 55.2918C150.782 55.3745 150.985 55.3766 151.165 55.3135C151.361 55.245 151.528 55.0991 151.618 54.8962C151.792 54.506 151.615 54.0505 151.222 53.8787L150.852 54.5596ZM158.077 56.9883C157.689 56.8076 157.25 56.9861 157.069 57.3737C156.887 57.7601 157.079 58.2302 157.468 58.4107C157.661 58.5026 157.874 58.5079 158.061 58.4421C158.249 58.3763 158.411 58.2395 158.504 58.0472C158.69 57.6627 158.527 57.2021 158.14 57.0176L158.077 56.9883ZM164.975 60.4006C164.969 60.397 164.908 60.3635 164.9 60.3596C164.526 60.163 164.088 60.314 163.883 60.6844C163.677 61.0542 163.836 61.5327 164.204 61.7421C164.408 61.8571 164.642 61.8712 164.847 61.7992C165.017 61.7396 165.167 61.621 165.263 61.4536C165.477 61.0829 165.348 60.6117 164.975 60.4006ZM161.504 58.6186C161.121 58.4366 160.69 58.6074 160.5 58.9848C160.311 59.3621 160.489 59.8338 160.866 60.0276C161.064 60.1296 161.285 60.1383 161.481 60.0698C161.661 60.0067 161.818 59.8781 161.913 59.6964C162.11 59.317 161.962 58.8512 161.581 58.6555C161.573 58.6523 161.51 58.6214 161.504 58.6186Z"
                    fill="#891712"
                />
                <path
                    d="M186.51 82.5604L145.274 98.2624C143.747 98.8461 142.043 98.6126 140.751 97.6203L108.149 72.4038C108.149 72.4038 105.448 90.499 104.625 109.586C104.684 111.629 105.8 113.497 107.503 114.606C117.49 119.685 140.751 126.864 170.65 126.864C173 126.748 175.056 125.288 175.937 123.129C178.581 115.599 182.105 103.633 186.51 82.5604Z"
                    fill="#D4E0ED"
                />
            </g>
            <path
                d="M180.712 103.961C180.687 109.898 181.77 116.874 185.524 120.297C185.637 120.414 185.722 120.556 185.772 120.711C185.822 120.865 185.836 121.029 185.813 121.19C185.79 121.351 185.73 121.505 185.639 121.639C185.548 121.774 185.427 121.887 185.286 121.968C179.538 124.977 174.991 129.844 172.396 135.767C172.32 135.957 172.179 136.114 171.998 136.21C171.817 136.305 171.607 136.334 171.407 136.289C171.207 136.245 171.029 136.131 170.905 135.968C170.782 135.805 170.721 135.604 170.733 135.4C170.417 127.39 168.018 120.922 166.188 118.299C166.099 118.169 166.04 118.021 166.016 117.866C165.992 117.711 166.003 117.552 166.049 117.402C166.095 117.252 166.174 117.114 166.281 116.998C166.388 116.882 166.519 116.792 166.666 116.733C170.257 115.466 175.407 111.129 179.048 103.544C179.125 103.35 179.271 103.19 179.458 103.095C179.645 102.999 179.86 102.975 180.064 103.026C180.268 103.077 180.446 103.2 180.565 103.372C180.684 103.544 180.737 103.753 180.712 103.961Z"
                fill="white"
            />
            <path
                d="M185.286 121.973C179.536 124.98 174.988 129.845 172.391 135.768C172.311 135.973 172.155 136.138 171.955 136.231C171.755 136.323 171.527 136.334 171.318 136.262V136.254C171.837 135.036 175.184 121.232 173.256 117.98C176.395 116.404 179.327 106.143 180.149 103.061C180.324 103.136 180.472 103.262 180.573 103.424C180.673 103.585 180.721 103.773 180.711 103.963C180.685 109.898 181.766 116.873 185.519 120.304C185.633 120.421 185.718 120.562 185.768 120.717C185.818 120.871 185.833 121.035 185.81 121.195C185.788 121.356 185.729 121.51 185.638 121.644C185.547 121.779 185.427 121.892 185.286 121.973Z"
                fill="#D8E5FF"
            />
            <path
                d="M171.319 136.254V136.262C171.144 136.196 170.994 136.078 170.889 135.924C170.784 135.77 170.728 135.588 170.731 135.402C170.419 127.389 168.015 120.926 166.19 118.303C166.082 118.15 166.016 117.971 166 117.784C168.386 118.294 170.846 118.36 173.256 117.98C175.185 121.232 171.838 135.036 171.319 136.254Z"
                fill="#ECF1FF"
            />
        </g>
        <defs>
            <linearGradient
                id="56f3da8a__paint0_linear_19033_9"
                x1={143.499}
                y1={9.99976}
                x2={139.612}
                y2={355.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.230015} stopColor="#F2F6FB" />
                <stop offset={0.498302} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="56f3da8a__paint1_linear_19033_9"
                x1={141.088}
                y1={105.211}
                x2={153.663}
                y2={35.8844}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="56f3da8a__clip0_19033_9">
                <path
                    d="M0 8C0 3.58173 3.58172 0 8 0H272C276.418 0 280 3.58172 280 8V185C280 189.418 276.418 193 272 193H8C3.58172 193 0 189.418 0 185V8Z"
                    fill="white"
                />
            </clipPath>
            <clipPath id="56f3da8a__clip1_19033_9">
                <rect
                    width={87}
                    height={94}
                    fill="white"
                    transform="translate(105 33)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default Promo500S;
