import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PromoPercentL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 532 204"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#aeaaca25__clip0_19033_7)">
            <g opacity={0.3}>
                <path
                    d="M694.202 251.078L639.272 102.958C639.272 102.958 624.486 169.93 573.001 189C538.477 201.795 557.411 130.036 526.501 119.5C506.638 112.729 481.448 121.293 472.907 123.385C474.11 103.946 468.456 50.4155 447.164 49.3082C434.533 48.57 414.444 50.0464 406.024 58.6585C412.399 39.4658 391.16 13.4438 368.184 11.3523C301.92 5.32005 253.54 53.4611 236.098 120.512C206.145 117.56 176.706 151.639 202.208 171.324C175.623 168.371 126.222 218.229 123.936 246.402C123.575 249.109 125.38 251.078 128.387 251.078C165.678 253.169 203.089 254.399 240.38 256.737C256.018 255.138 271.656 253.169 287.174 250.709C380.401 251.447 694.202 251.078 694.202 251.078Z"
                    fill="url(#aeaaca25__paint0_linear_19033_7)"
                />
                <path
                    d="M694.202 251.078L639.272 102.958C639.272 102.958 624.486 169.93 573.001 189C538.477 201.795 557.411 130.036 526.501 119.5C506.638 112.729 481.448 121.293 472.907 123.385C474.11 103.946 468.456 50.4155 447.164 49.3082C434.533 48.57 414.444 50.0464 406.024 58.6585C412.399 39.4658 391.16 13.4438 368.184 11.3523C301.92 5.32005 253.54 53.4611 236.098 120.512C206.145 117.56 176.706 151.639 202.208 171.324C175.623 168.371 126.222 218.229 123.936 246.402C123.575 249.109 125.38 251.078 128.387 251.078C165.678 253.169 203.089 254.399 240.38 256.737C256.018 255.138 271.656 253.169 287.174 250.709C380.401 251.447 694.202 251.078 694.202 251.078Z"
                    fill="#ECF2F9"
                />
            </g>
            <g opacity={0.3}>
                <path
                    d="M593.568 272.141L533.123 125.958C533.123 125.958 516.052 87.5856 493.651 81.5793C459.467 72.4139 435.5 90.5 426.291 102.211C418.5 91 400.757 86.6136 382.75 87.0026C369.456 87.2898 359.453 94.735 350.055 96.5113C351.379 80.0017 345.157 61.7157 321.728 60.7753C307.829 60.1483 285.723 77.4022 276.457 84.7166C283.473 68.416 245.783 50.2764 220.5 48.5C147.584 43.3767 108.665 104.302 89.4718 161.25C56.5118 158.742 24.1177 187.686 52.1801 204.405C22.9264 201.897 -31.4347 244.242 -33.9497 268.17C-34.3468 270.469 -32.3613 272.141 -29.052 272.141C11.9826 273.917 53.1496 274.962 94.1842 276.948C111.392 275.589 128.6 273.917 145.676 271.828C248.263 272.455 593.568 272.141 593.568 272.141Z"
                    fill="url(#aeaaca25__paint1_linear_19033_7)"
                />
                <path
                    d="M593.568 272.141L533.123 125.958C533.123 125.958 516.052 87.5856 493.651 81.5793C459.467 72.4139 435.5 90.5 426.291 102.211C418.5 91 400.757 86.6136 382.75 87.0026C369.456 87.2898 359.453 94.735 350.055 96.5113C351.379 80.0017 345.157 61.7157 321.728 60.7753C307.829 60.1483 285.723 77.4022 276.457 84.7166C283.473 68.416 245.783 50.2764 220.5 48.5C147.584 43.3767 108.665 104.302 89.4718 161.25C56.5118 158.742 24.1177 187.686 52.1801 204.405C22.9264 201.897 -31.4347 244.242 -33.9497 268.17C-34.3468 270.469 -32.3613 272.141 -29.052 272.141C11.9826 273.917 53.1496 274.962 94.1842 276.948C111.392 275.589 128.6 273.917 145.676 271.828C248.263 272.455 593.568 272.141 593.568 272.141Z"
                    fill="#ECF2F9"
                    fillOpacity={0.8}
                />
            </g>
            <path
                d="M215.23 48.3216C215.13 48.3906 215.023 48.4469 214.91 48.4892C214.735 48.5555 214.549 48.5867 214.362 48.5811C214.176 48.5754 213.992 48.5329 213.823 48.4562C213.653 48.3794 213.5 48.2698 213.374 48.1336C213.247 47.9975 213.148 47.8376 213.084 47.663L211.66 43.7512C211.535 43.3963 211.555 43.0061 211.716 42.6643C211.876 42.3226 212.164 42.0565 212.518 41.9231C212.692 41.8568 212.878 41.8256 213.065 41.8313C213.252 41.8369 213.435 41.8794 213.605 41.9562C213.774 42.033 213.927 42.1426 214.054 42.2787C214.181 42.4148 214.279 42.5747 214.343 42.7493L215.768 46.6611C215.874 46.9574 215.879 47.281 215.782 47.5814C215.684 47.8818 215.49 48.1421 215.23 48.3216Z"
                fill="#1CB5F9"
            />
            <path
                d="M219.204 59.2384C219.105 59.3073 218.998 59.3637 218.885 59.406C218.71 59.4723 218.524 59.5035 218.337 59.4979C218.151 59.4922 217.967 59.4497 217.797 59.3729C217.628 59.2962 217.475 59.1866 217.348 59.0504C217.222 58.9143 217.123 58.7544 217.059 58.5798L215.635 54.668C215.51 54.3131 215.53 53.9228 215.69 53.5809C215.85 53.239 216.139 52.973 216.492 52.8399C216.667 52.7736 216.853 52.7424 217.04 52.7481C217.226 52.7537 217.41 52.7962 217.579 52.873C217.749 52.9498 217.902 53.0594 218.029 53.1955C218.155 53.3316 218.254 53.4915 218.318 53.6661L219.742 57.5779C219.849 57.8742 219.854 58.1978 219.757 58.4982C219.659 58.7986 219.465 59.0589 219.204 59.2384Z"
                fill="#1CB5F9"
            />
            <path
                d="M224.002 49.03C223.902 49.099 223.795 49.1553 223.682 49.1977L219.727 50.6719C219.552 50.7382 219.366 50.7695 219.179 50.7638C218.993 50.7581 218.809 50.7157 218.64 50.6389C218.47 50.5621 218.317 50.4525 218.19 50.3164C218.064 50.1803 217.965 50.0203 217.901 49.8458C217.775 49.4909 217.795 49.1002 217.955 48.7582C218.116 48.4161 218.404 48.1501 218.759 48.0177L222.714 46.5434C223.038 46.4201 223.396 46.4198 223.72 46.5426C224.043 46.6654 224.31 46.9026 224.469 47.2094C224.628 47.5162 224.668 47.871 224.582 48.2067C224.496 48.5423 224.289 48.8353 224.002 49.0301L224.002 49.03Z"
                fill="#1CB5F9"
            />
            <path
                d="M212.964 53.1445C212.865 53.2134 212.757 53.2698 212.644 53.3121L208.69 54.7875C208.515 54.8539 208.329 54.8852 208.142 54.8796C207.956 54.8739 207.772 54.8315 207.602 54.7547C207.433 54.6779 207.28 54.5683 207.153 54.4321C207.027 54.2959 206.928 54.1359 206.864 53.9613C206.738 53.6065 206.758 53.2158 206.918 52.8738C207.079 52.5318 207.367 52.2658 207.722 52.1332L211.676 50.6578C212.001 50.5345 212.359 50.5342 212.682 50.657C213.006 50.7798 213.272 51.0171 213.431 51.3238C213.59 51.6306 213.63 51.9854 213.544 52.321C213.458 52.6566 213.251 52.9497 212.964 53.1445L212.964 53.1445Z"
                fill="#1CB5F9"
            />
            <path
                d="M466.133 145.848C466.013 145.848 465.892 145.834 465.775 145.804C465.594 145.759 465.423 145.679 465.273 145.568C465.122 145.457 464.996 145.318 464.9 145.158C464.804 144.999 464.741 144.822 464.714 144.638C464.687 144.454 464.697 144.266 464.743 144.086L465.797 140.059C465.897 139.696 466.136 139.386 466.462 139.197C466.788 139.007 467.176 138.952 467.543 139.043C467.724 139.088 467.895 139.168 468.045 139.279C468.196 139.39 468.322 139.529 468.418 139.689C468.514 139.848 468.577 140.025 468.604 140.21C468.631 140.394 468.621 140.581 468.575 140.761L467.521 144.789C467.44 145.093 467.26 145.362 467.009 145.554C466.758 145.745 466.45 145.849 466.133 145.848Z"
                fill="#1CB5F9"
            />
            <path
                d="M463.192 157.088C463.071 157.089 462.951 157.074 462.834 157.044C462.652 156.999 462.481 156.919 462.331 156.808C462.181 156.698 462.054 156.558 461.958 156.399C461.863 156.239 461.799 156.062 461.772 155.878C461.746 155.694 461.756 155.506 461.802 155.326L462.856 151.299C462.955 150.936 463.194 150.626 463.52 150.436C463.847 150.246 464.235 150.191 464.602 150.283C464.783 150.328 464.954 150.408 465.104 150.519C465.254 150.63 465.381 150.769 465.477 150.929C465.573 151.089 465.636 151.266 465.663 151.45C465.69 151.634 465.679 151.821 465.633 152.001L464.579 156.029C464.498 156.333 464.318 156.602 464.067 156.794C463.816 156.985 463.508 157.089 463.192 157.088Z"
                fill="#1CB5F9"
            />
            <path
                d="M472.944 151.421C472.823 151.422 472.702 151.407 472.585 151.377L468.494 150.34C468.312 150.295 468.142 150.215 467.991 150.104C467.841 149.993 467.714 149.854 467.619 149.694C467.523 149.534 467.459 149.357 467.433 149.173C467.406 148.989 467.416 148.802 467.462 148.622C467.561 148.258 467.799 147.948 468.126 147.758C468.452 147.568 468.841 147.513 469.208 147.606L473.299 148.644C473.636 148.727 473.931 148.93 474.127 149.215C474.323 149.5 474.407 149.847 474.364 150.19C474.32 150.532 474.151 150.847 473.889 151.074C473.627 151.301 473.291 151.425 472.944 151.421L472.944 151.421Z"
                fill="#1CB5F9"
            />
            <path
                d="M461.526 148.525C461.405 148.526 461.285 148.511 461.167 148.481L457.076 147.445C456.894 147.4 456.724 147.32 456.573 147.209C456.423 147.099 456.296 146.959 456.2 146.8C456.105 146.64 456.041 146.463 456.015 146.279C455.988 146.095 455.998 145.907 456.044 145.727C456.143 145.364 456.381 145.054 456.708 144.864C457.034 144.674 457.423 144.619 457.79 144.711L461.881 145.748C462.218 145.831 462.513 146.034 462.709 146.319C462.905 146.604 462.99 146.951 462.946 147.294C462.902 147.636 462.733 147.951 462.471 148.178C462.21 148.405 461.873 148.529 461.526 148.525L461.526 148.525Z"
                fill="#1CB5F9"
            />
            <path
                d="M277.915 49.0084C278.414 58.2734 280.735 69.0576 286.902 74.0587C287.088 74.2316 287.233 74.4446 287.325 74.6814C287.417 74.9182 287.454 75.1727 287.433 75.4258C287.412 75.6789 287.333 75.9239 287.203 76.1424C287.073 76.3609 286.894 76.5472 286.681 76.6872C277.988 81.9026 271.336 89.9073 267.824 99.3831C267.723 99.6861 267.518 99.9437 267.244 100.109C266.97 100.275 266.645 100.338 266.329 100.287C266.012 100.237 265.725 100.075 265.517 99.8319C265.31 99.5888 265.197 99.28 265.198 98.961C263.978 86.4927 259.65 76.6198 256.558 72.6928C256.408 72.4987 256.302 72.2733 256.251 72.0333C256.199 71.7932 256.202 71.5447 256.26 71.306C256.318 71.0674 256.429 70.8447 256.585 70.6544C256.741 70.4642 256.938 70.3112 257.162 70.2069C262.649 67.9038 270.289 60.6714 275.282 48.5091C275.385 48.1989 275.598 47.9364 275.881 47.7707C276.164 47.6049 276.497 47.5472 276.82 47.6083C277.142 47.6695 277.431 47.8452 277.633 48.1029C277.834 48.3605 277.935 48.6823 277.915 49.0084Z"
                fill="white"
            />
            <path
                d="M286.683 76.6961C277.986 81.907 271.332 89.9102 267.818 99.3861C267.712 99.7122 267.483 99.9848 267.179 100.147C266.876 100.308 266.521 100.347 266.189 100.254L266.189 100.241C266.888 98.2937 270.858 76.4553 267.555 71.5552C272.31 68.8129 275.954 52.5386 276.956 47.6552C277.236 47.7563 277.479 47.9407 277.65 48.1835C277.822 48.4262 277.914 48.7156 277.915 49.0124C278.412 58.2745 280.73 69.0572 286.896 74.0712C287.083 74.2433 287.229 74.4554 287.321 74.6917C287.414 74.9279 287.452 75.182 287.431 75.4348C287.411 75.6876 287.333 75.9325 287.203 76.151C287.073 76.3695 286.896 76.5559 286.683 76.6961Z"
                fill="#D8E5FF"
            />
            <path
                d="M266.189 100.24L266.19 100.253C265.911 100.165 265.666 99.9949 265.488 99.7644C265.31 99.534 265.208 99.2547 265.194 98.9643C263.983 86.4911 259.647 76.6255 256.563 72.6989C256.379 72.4695 256.261 72.1958 256.219 71.9058C259.987 72.4857 263.83 72.3665 267.556 71.5542C270.859 76.4543 266.888 98.2927 266.189 100.24Z"
                fill="url(#aeaaca25__paint2_linear_19033_7)"
            />
            <path
                d="M389.708 109.898L345.738 56.076C343.288 53.0776 339.043 52.2637 335.658 54.1435L264.607 93.602C264.607 93.602 262.169 124.507 258.98 153.259C259.074 156.537 266.952 156.911 269.672 158.691C280.737 165.621 303.432 180.418 360.637 176.953C364.388 176.766 371.327 178.358 372.734 174.893C375.641 162.905 382.206 141.365 389.708 109.898Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M306.13 78.708L304.013 89.822L280.197 146.98L277.021 144.334L306.13 78.708Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M359.218 39.4079C354.288 47.5502 347.77 56.4956 346.354 58.732C347.737 60.4589 347.924 61.8944 347.263 63.1496C346.249 65.0739 343.988 65.9222 342.049 65.2101C333.28 79.3216 307.456 105.831 294.66 116.218C297.055 119.974 318.48 143.002 325.73 149.341C326.818 150.293 328.421 150.332 329.552 149.431C350.78 132.51 377.546 99.0283 380.569 94.1336C380.752 93.8378 380.747 93.4802 380.574 93.1785C380.016 92.2023 379.539 90.373 380.173 89.0907C381.034 87.3491 383.123 86.6157 385.244 86.8102C385.598 86.8427 385.941 86.7029 386.137 86.407C388.07 83.4874 395.076 70.5311 398.482 63.4832C399.141 62.1218 398.671 60.4954 397.39 59.6928C389.872 54.9827 370.777 42.8531 363.277 38.3856C361.873 37.5482 360.064 38.0093 359.218 39.4079Z"
                fill="#FFCC00"
            />
            <path
                d="M363.195 86.9552C363.33 86.6448 363.277 86.2994 363.07 86.0315C362.426 85.1905 361.827 83.6415 362.117 82.2431C362.558 80.1139 364.716 79.1745 366.874 79.1067C367.234 79.0955 367.561 78.9085 367.716 78.5832C369.192 75.486 373.884 62.3812 376.221 55.1117C376.678 53.6919 376.006 52.1649 374.651 51.5424C368.446 48.6879 354.802 42.3194 345.21 37.963C341.437 45.0079 337.378 51.7057 336.37 53.6277C337.889 55.2362 338.193 56.6517 337.636 57.9566C336.781 59.9571 334.597 60.9866 332.607 60.4345C325.014 75.2129 301.434 103.737 289.526 115.131C292.138 118.573 314.062 138.622 322.445 145.053C343.072 122.929 360.856 92.3166 363.195 86.9552Z"
                fill="#EBB409"
            />
            <path
                d="M329.274 34.7897C326.22 42.935 322.396 51.4749 321.086 54.5788C320.936 54.9349 321.038 55.329 321.307 55.6065C322.597 56.9326 322.939 58.3294 322.455 59.5111C321.802 61.1073 320.264 61.9364 318.287 62.2407C317.965 62.2905 317.69 62.4895 317.567 62.7918C311.553 77.5568 292.337 105.906 281.258 119.649C280.224 120.932 280.427 122.798 281.712 123.826C288.975 129.644 309.648 143.923 316.656 147.823C317.793 148.456 319.444 148.178 320.308 147.205C341.007 123.877 358.679 89.6183 360.84 83.8867C360.959 83.57 360.888 83.2273 360.669 82.97C359.983 82.1624 359.307 80.6464 359.525 79.2353C359.857 77.0866 361.964 76.0396 364.116 75.8615C364.475 75.8318 364.791 75.6285 364.929 75.2962C366.245 72.1284 370.267 58.8025 372.23 51.4245C372.614 49.9837 371.866 48.4926 370.481 47.9392C362.266 44.6538 341.278 36.1098 333.087 33.045C331.553 32.4689 329.849 33.2546 329.274 34.7897Z"
                fill="url(#aeaaca25__paint3_linear_19033_7)"
            />
            <path
                d="M329.384 115.452L331.371 112.245L318.185 85.3312L316.198 88.5369L329.384 115.452Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M320.75 105.743C322.584 102.847 321.059 99.7761 318.037 97.9036C315.015 96.0311 311.563 96.1309 309.808 98.9628C308.054 101.795 309.501 104.931 312.523 106.803C315.544 108.675 318.918 108.64 320.75 105.743ZM318.391 104.281C319.029 103.245 317.812 102.158 316.124 101.112C314.434 100.065 312.955 99.4009 312.275 100.492C311.596 101.583 312.854 102.615 314.543 103.662C316.232 104.708 317.754 105.317 318.391 104.281Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M337.93 101.883C339.764 98.9856 338.238 95.9149 335.217 94.0424C332.195 92.17 328.743 92.2701 326.988 95.1018C325.233 97.9335 326.68 101.069 329.702 102.942C332.724 104.814 336.097 104.779 337.93 101.883ZM335.571 100.421C336.209 99.3847 334.992 98.2969 333.303 97.2504C331.614 96.2039 330.134 95.5397 329.455 96.6308C328.775 97.7219 330.034 98.7544 331.723 99.8009C333.411 100.847 334.933 101.456 335.571 100.421Z"
                fill="white"
            />
            <path
                d="M328.126 60.9053C328.718 61.2486 328.917 62.007 328.573 62.5984C328.419 62.8636 328.182 63.05 327.914 63.1444C327.582 63.2608 327.205 63.2371 326.878 63.0473C326.293 62.7061 326.047 61.9346 326.38 61.345C326.713 60.7544 327.415 60.517 328.01 60.8411L327.415 61.9281L328.026 60.8503C328.036 60.8551 328.116 60.8995 328.126 60.9053ZM338.892 65.9605C338.272 65.6713 337.534 65.9372 337.243 66.559C336.953 67.1787 337.221 67.9162 337.842 68.2051L337.969 68.2626C338.266 68.3901 338.585 68.3923 338.869 68.2926C339.184 68.1818 339.455 67.9438 339.597 67.6133C339.867 66.984 339.578 66.2562 338.948 65.9862L338.892 65.9605ZM332.857 64.5779L333.383 63.4554C332.762 63.1662 332.024 63.432 331.734 64.0539C331.444 64.6735 331.712 65.4111 332.333 65.7C332.34 65.7046 332.438 65.749 332.447 65.7523C332.747 65.8852 333.071 65.8888 333.358 65.7878C333.67 65.6783 333.938 65.4444 334.081 65.119C334.358 64.4933 334.075 63.7622 333.448 63.486L332.857 64.5779ZM344.393 68.4846C343.773 68.1941 343.073 68.48 342.784 69.1015C342.494 69.7212 342.8 70.4757 343.421 70.7658C343.729 70.9136 344.069 70.9223 344.368 70.8171C344.668 70.7118 344.927 70.4925 345.075 70.1842C345.372 69.5675 345.112 68.8283 344.494 68.5318L344.393 68.4846ZM355.407 73.9691C355.397 73.9633 355.299 73.9095 355.287 73.9031C354.689 73.5872 353.99 73.8289 353.662 74.4228C353.335 75.0159 353.588 75.7837 354.175 76.1202C354.501 76.305 354.875 76.3279 355.202 76.2127C355.474 76.1173 355.713 75.9272 355.867 75.6589C356.208 75.0644 356.002 74.3082 355.407 73.9691ZM349.864 71.1051C349.253 70.8126 348.565 71.086 348.262 71.6912C347.96 72.2963 348.244 73.0534 348.846 73.3648C349.162 73.5288 349.516 73.5429 349.828 73.4333C350.115 73.3323 350.366 73.1263 350.517 72.8349C350.832 72.2264 350.596 71.4789 349.988 71.1644C349.976 71.1593 349.875 71.1096 349.864 71.1051Z"
                fill="#891712"
            />
            <path
                d="M389.708 109.898L323.875 135.091C321.437 136.028 318.717 135.653 316.654 134.061L264.607 93.6025C264.607 93.6025 260.294 122.635 258.98 153.26C259.074 156.538 260.856 159.535 263.576 161.314C279.518 169.462 316.654 180.981 364.388 180.981C368.139 180.794 371.421 178.453 372.828 174.987C377.048 162.906 382.675 143.707 389.708 109.898Z"
                fill="#D4E0ED"
            />
            <path
                d="M374.407 138.405C374.371 146.833 375.909 156.735 381.237 161.595C381.397 161.761 381.517 161.962 381.588 162.182C381.659 162.401 381.679 162.634 381.647 162.862C381.614 163.091 381.53 163.309 381.4 163.5C381.271 163.691 381.099 163.851 380.899 163.967C372.741 168.238 366.288 175.147 362.603 183.555C362.496 183.825 362.296 184.047 362.039 184.183C361.782 184.319 361.484 184.359 361.2 184.296C360.916 184.234 360.663 184.072 360.488 183.841C360.313 183.609 360.226 183.323 360.244 183.034C359.795 171.663 356.39 162.482 353.793 158.758C353.666 158.574 353.583 158.364 353.549 158.144C353.515 157.924 353.531 157.698 353.596 157.485C353.661 157.272 353.773 157.076 353.925 156.911C354.076 156.747 354.263 156.619 354.471 156.536C359.569 154.736 366.877 148.58 372.046 137.814C372.155 137.538 372.362 137.311 372.627 137.176C372.893 137.04 373.198 137.006 373.487 137.078C373.777 137.15 374.029 137.325 374.199 137.569C374.368 137.813 374.442 138.111 374.407 138.405Z"
                fill="white"
            />
            <path
                d="M380.899 163.974C372.738 168.241 366.282 175.148 362.596 183.556C362.483 183.846 362.261 184.082 361.977 184.212C361.694 184.343 361.37 184.359 361.074 184.257V184.245C361.811 182.517 366.561 162.922 363.824 158.305C368.28 156.068 372.441 141.502 373.607 137.126C373.856 137.233 374.066 137.413 374.209 137.642C374.352 137.871 374.42 138.139 374.405 138.408C374.368 146.833 375.903 156.733 381.23 161.605C381.391 161.771 381.512 161.971 381.583 162.19C381.655 162.409 381.675 162.641 381.644 162.869C381.612 163.098 381.528 163.316 381.399 163.507C381.27 163.698 381.099 163.858 380.899 163.974Z"
                fill="#D8E5FF"
            />
            <path
                d="M361.075 184.245V184.257C360.827 184.163 360.614 183.996 360.464 183.778C360.315 183.559 360.237 183.3 360.24 183.036C359.798 171.662 356.385 162.487 353.795 158.764C353.641 158.546 353.548 158.292 353.525 158.026C356.912 158.751 360.404 158.845 363.824 158.305C366.562 162.922 361.811 182.517 361.075 184.245Z"
                fill="url(#aeaaca25__paint4_linear_19033_7)"
            />
            <path
                d="M217.753 135.331C218.912 141.263 221.383 148.012 225.813 150.682C225.949 150.777 226.062 150.901 226.143 151.045C226.223 151.19 226.27 151.351 226.279 151.516C226.288 151.681 226.26 151.846 226.196 151.999C226.131 152.152 226.033 152.288 225.908 152.398C220.77 156.548 217.201 162.313 215.79 168.744C215.753 168.948 215.644 169.133 215.482 169.265C215.32 169.396 215.116 169.466 214.908 169.462C214.699 169.458 214.499 169.38 214.343 169.242C214.187 169.103 214.086 168.914 214.058 168.709C212.145 160.774 208.462 154.795 206.112 152.54C205.997 152.429 205.909 152.293 205.854 152.142C205.799 151.992 205.779 151.832 205.795 151.672C205.811 151.513 205.862 151.359 205.946 151.223C206.029 151.086 206.142 150.969 206.277 150.882C209.61 148.9 213.886 143.544 216.009 135.246C216.048 135.037 216.161 134.848 216.329 134.716C216.496 134.583 216.707 134.516 216.92 134.526C217.134 134.537 217.336 134.624 217.489 134.772C217.643 134.92 217.737 135.119 217.753 135.331Z"
                fill="white"
            />
            <path
                d="M225.91 152.403C220.769 156.55 217.199 162.315 215.787 168.746C215.748 168.966 215.625 169.163 215.444 169.294C215.262 169.426 215.037 169.483 214.815 169.453L214.813 169.444C215.088 168.125 215.678 153.676 213.105 150.813C215.925 148.615 216.806 137.785 217.012 134.544C217.202 134.584 217.375 134.681 217.508 134.822C217.641 134.963 217.726 135.142 217.753 135.333C218.91 141.264 221.38 148.012 225.811 150.69C225.947 150.784 226.06 150.908 226.141 151.052C226.222 151.196 226.269 151.357 226.279 151.522C226.289 151.687 226.26 151.852 226.197 152.004C226.133 152.157 226.035 152.293 225.91 152.403Z"
                fill="#D8E5FF"
            />
            <path
                d="M214.813 169.444L214.815 169.452C214.627 169.421 214.454 169.333 214.318 169.201C214.183 169.068 214.091 168.897 214.056 168.711C212.149 160.773 208.46 154.799 206.116 152.544C205.977 152.412 205.876 152.246 205.822 152.063C208.306 152.097 210.775 151.673 213.105 150.813C215.679 153.676 215.089 168.125 214.813 169.444Z"
                fill="url(#aeaaca25__paint5_linear_19033_7)"
            />
            <path
                d="M410.053 57.9599C413.244 53.4077 415.349 51.2867 418.983 47.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M419.015 58.8192C421.451 56.8974 426.635 52.7887 429.071 50.867"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
        </g>
        <defs>
            <linearGradient
                id="aeaaca25__paint0_linear_19033_7"
                x1={336.501}
                y1={-5}
                x2={351.774}
                y2={188.36}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.428979} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="aeaaca25__paint1_linear_19033_7"
                x1={200}
                y1={23}
                x2={225.828}
                y2={270.729}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.189743} stopColor="#ECF2F9" />
                <stop offset={0.663927} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="aeaaca25__paint2_linear_19033_7"
                x1={262.362}
                y1={73.7255}
                x2={268.513}
                y2={103.694}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="aeaaca25__paint3_linear_19033_7"
                x1={317.197}
                y1={146.239}
                x2={337.466}
                y2={35.0437}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="aeaaca25__paint4_linear_19033_7"
                x1={359}
                y1={160}
                x2={363}
                y2={187.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="aeaaca25__paint5_linear_19033_7"
                x1={209.95}
                y1={152.682}
                x2={216.624}
                y2={171.463}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#ECF1FF" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <clipPath id="aeaaca25__clip0_19033_7">
                <rect width={532} height={204} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default PromoPercentL;
