import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PromoPercentM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 307 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#d26d7516__clip0_19033_6)">
            <g opacity={0.6}>
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="url(#d26d7516__paint0_linear_19033_6)"
                />
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="#F2F6FB"
                />
            </g>
            <path
                d="M246.372 36.3185C249.058 32.4882 250.829 30.7035 253.887 27.0967"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M253.913 37.0417C255.964 35.4247 260.326 31.9676 262.376 30.3506"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M176.344 41.2637C176.311 49.0706 177.735 58.2427 182.671 62.7444C182.82 62.8988 182.931 63.0847 182.997 63.2881C183.063 63.4915 183.081 63.7071 183.051 63.9187C183.021 64.1302 182.943 64.3322 182.823 64.5094C182.703 64.6866 182.544 64.8344 182.358 64.9416C174.8 68.8985 168.822 75.2981 165.408 83.0865C165.309 83.3361 165.124 83.5424 164.886 83.6683C164.648 83.7941 164.372 83.8313 164.109 83.7732C163.845 83.715 163.611 83.5653 163.449 83.3509C163.287 83.1366 163.206 82.8717 163.223 82.6038C162.807 72.0709 159.652 63.5665 157.246 60.117C157.129 59.9466 157.052 59.7521 157.02 59.548C156.988 59.3438 157.003 59.1352 157.064 58.9376C157.124 58.7399 157.228 58.5583 157.368 58.4061C157.509 58.2539 157.682 58.135 157.875 58.0582C162.597 56.3913 169.368 50.6887 174.156 40.7159C174.258 40.4603 174.449 40.2502 174.695 40.1248C174.941 39.9993 175.224 39.9672 175.492 40.0342C175.76 40.1013 175.994 40.2631 176.151 40.4893C176.308 40.7155 176.376 40.9908 176.344 41.2637Z"
                fill="white"
            />
            <path
                d="M182.36 64.949C174.8 68.902 168.819 75.3001 165.404 83.0885C165.299 83.3572 165.094 83.5751 164.831 83.6962C164.568 83.8173 164.268 83.8323 163.994 83.738V83.7268C164.677 82.1255 169.078 63.9749 166.542 59.6976C170.67 57.626 174.525 44.1333 175.605 40.0801C175.836 40.1787 176.031 40.3454 176.163 40.5577C176.295 40.77 176.358 41.0176 176.344 41.2669C176.31 49.0713 177.732 58.2419 182.667 62.7545C182.816 62.9081 182.928 63.0934 182.994 63.2964C183.061 63.4993 183.08 63.7146 183.05 63.926C183.021 64.1374 182.943 64.3393 182.824 64.5165C182.704 64.6937 182.546 64.8416 182.36 64.949Z"
                fill="#D8E5FF"
            />
            <path
                d="M163.994 83.7258V83.737C163.764 83.6499 163.567 83.4948 163.428 83.2925C163.29 83.0903 163.218 82.8507 163.221 82.6061C162.811 72.0695 159.65 63.5708 157.25 60.122C157.108 59.9203 157.021 59.6846 157 59.439C160.137 60.1099 163.372 60.1972 166.541 59.6966C169.077 63.9739 164.676 82.1245 163.994 83.7258Z"
                fill="#ECF1FF"
            />
            <path
                d="M248.968 96.9284L212.636 52.4623C210.186 49.4644 205.942 48.6506 202.557 50.53L143.692 83.2168C143.692 83.2168 141.641 109.221 138.957 133.414C139.036 136.172 145.665 136.487 147.954 137.984C157.266 143.815 176.364 156.266 224.504 153.35C227.66 153.193 233.5 154.533 234.684 151.617C237.131 141.53 242.655 123.405 248.968 96.9284Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M207.551 80.2632L205.551 90.7632L183.051 144.763L180.051 142.263L207.551 80.2632Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M223.305 37.6168C219.157 44.4678 213.672 51.9947 212.48 53.8764C213.644 55.3294 213.802 56.5373 213.245 57.5934C212.392 59.2126 210.489 59.9264 208.857 59.3272C201.478 71.2009 179.746 93.5061 168.978 102.246C170.994 105.407 189.024 124.783 195.124 130.117C196.04 130.917 197.389 130.95 198.34 130.192C216.204 115.955 238.729 87.7825 241.273 83.664C241.427 83.4151 241.423 83.1142 241.277 82.8603C240.808 82.039 240.406 80.4998 240.94 79.4208C241.665 77.9553 243.422 77.3383 245.207 77.5019C245.505 77.5293 245.794 77.4117 245.959 77.1627C247.585 74.706 253.481 63.8044 256.348 57.8742C256.901 56.7287 256.507 55.3602 255.428 54.6849C249.102 50.7217 233.033 40.5156 226.721 36.7565C225.54 36.0519 224.017 36.4399 223.305 37.6168Z"
                fill="#FFCC00"
            />
            <path
                d="M226.652 77.6241C226.765 77.3629 226.72 77.0722 226.547 76.8468C226.004 76.1392 225.501 74.8359 225.745 73.6592C226.116 71.8676 227.932 71.0772 229.748 71.0202C230.051 71.0108 230.326 70.8534 230.456 70.5796C231.698 67.9737 235.647 56.947 237.614 50.8303C237.998 49.6356 237.433 48.3508 236.292 47.827C231.07 45.4252 219.589 40.0666 211.516 36.4011C208.342 42.3288 204.926 47.9645 204.078 49.5817C205.356 50.935 205.612 52.1261 205.143 53.224C204.424 54.9073 202.586 55.7736 200.911 55.3091C194.521 67.7438 174.678 91.7443 164.657 101.332C166.855 104.228 185.305 121.097 192.359 126.509C209.718 107.894 224.684 82.1352 226.652 77.6241Z"
                fill="#EBB409"
            />
            <path
                d="M198.107 33.7311C195.537 40.5846 192.319 47.7703 191.217 50.3819C191.091 50.6816 191.177 51.0132 191.403 51.2467C192.489 52.3625 192.776 53.5378 192.369 54.5321C191.819 55.8752 190.525 56.5729 188.861 56.8288C188.59 56.8707 188.359 57.0382 188.256 57.2926C183.194 69.7161 167.024 93.57 157.7 105.134C156.831 106.213 157.001 107.783 158.083 108.648C164.195 113.543 181.591 125.558 187.489 128.84C188.446 129.372 189.835 129.138 190.562 128.32C207.981 108.691 222.852 79.8649 224.671 75.0422C224.772 74.7757 224.712 74.4874 224.527 74.2709C223.95 73.5914 223.381 72.3158 223.564 71.1284C223.844 69.3205 225.617 68.4395 227.428 68.2896C227.73 68.2647 227.996 68.0936 228.112 67.814C229.22 65.1486 232.604 53.9359 234.257 47.7279C234.58 46.5156 233.95 45.2609 232.784 44.7953C225.872 42.0309 208.209 34.8418 201.316 32.2631C200.025 31.7783 198.591 32.4394 198.107 33.7311Z"
                fill="url(#d26d7516__paint1_linear_19033_6)"
            />
            <path
                d="M198.873 99.1146L200.459 96.5538L189.931 75.0639L188.345 77.6235L198.873 99.1146Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M191.979 91.3624C193.444 89.0498 192.226 86.5977 189.813 85.1026C187.4 83.6075 184.644 83.6872 183.242 85.9483C181.841 88.2095 182.997 90.7134 185.41 92.2086C187.822 93.7037 190.516 93.6755 191.979 91.3624ZM190.095 90.1949C190.605 89.3678 189.633 88.4996 188.285 87.6641C186.936 86.8283 185.755 86.2981 185.212 87.169C184.669 88.0403 185.674 88.8647 187.023 89.7006C188.371 90.536 189.587 91.0224 190.095 90.1949Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M205.697 88.2797C207.161 85.9666 205.943 83.5147 203.53 82.0196C201.117 80.5245 198.361 80.6044 196.96 82.8654C195.559 85.1265 196.714 87.6305 199.127 89.1256C201.54 90.6207 204.233 90.5928 205.697 88.2797ZM203.813 87.1123C204.322 86.2852 203.351 85.4167 202.002 84.5811C200.654 83.7454 199.472 83.2151 198.93 84.0863C198.387 84.9575 199.392 85.782 200.74 86.6176C202.089 87.4532 203.304 87.9395 203.813 87.1123Z"
                fill="white"
            />
            <path
                d="M196.968 56.011C197.474 56.2859 197.659 56.9192 197.384 57.4247C197.26 57.6513 197.065 57.8136 196.841 57.8992C196.565 58.0049 196.247 57.9937 195.968 57.8417C195.468 57.5684 195.243 56.9253 195.509 56.4215C195.775 55.917 196.36 55.701 196.869 55.9597L196.394 56.8878L196.883 55.967C196.891 55.9709 196.959 56.0064 196.968 56.011ZM206.142 60.0119C205.614 59.7831 204.999 60.0239 204.769 60.5537C204.54 61.0817 204.782 61.6958 205.311 61.9243L205.419 61.9697C205.672 62.07 205.941 62.0644 206.177 61.974C206.44 61.8734 206.662 61.6669 206.774 61.3856C206.986 60.85 206.726 60.2446 206.19 60.0322L206.142 60.0119ZM201.033 58.9897L201.449 58.0333C200.921 57.8045 200.306 58.0453 200.076 58.5751C199.847 59.1031 200.089 59.7172 200.618 59.9457C200.625 59.9494 200.708 59.9845 200.715 59.987C200.971 60.0918 201.244 60.0873 201.483 59.9957C201.743 59.8963 201.963 59.6933 202.076 59.4162C202.294 58.8835 202.039 58.2752 201.505 58.0575L201.033 58.9897ZM210.828 62.0066C210.3 61.7768 209.718 62.0335 209.49 62.563C209.26 63.091 209.535 63.7184 210.064 63.948C210.327 64.0651 210.613 64.0645 210.862 63.969C211.112 63.8735 211.325 63.683 211.442 63.4202C211.677 62.8946 211.441 62.2789 210.915 62.0439L210.828 62.0066ZM220.222 66.3628C220.213 66.3581 220.129 66.3151 220.119 66.31C219.609 66.0583 219.026 66.2779 218.765 66.7851C218.503 67.2915 218.733 67.9315 219.235 68.2008C219.514 68.3486 219.829 68.3591 220.102 68.2547C220.328 68.1681 220.524 68.0026 220.648 67.7733C220.921 67.2654 220.73 66.6342 220.222 66.3628ZM215.492 64.0831C214.971 63.8513 214.399 64.0974 214.158 64.6134C213.918 65.1295 214.175 65.7596 214.688 66.0075C214.958 66.138 215.256 66.1417 215.516 66.0423C215.755 65.9506 215.962 65.7715 216.082 65.5228C216.333 65.0037 216.116 64.3805 215.598 64.1301C215.587 64.1261 215.501 64.0867 215.492 64.0831Z"
                fill="#891712"
            />
            <path
                d="M248.968 96.9288L193.568 118.127C191.516 118.915 189.227 118.599 187.491 117.26L143.692 83.2173C143.692 83.2173 140.062 107.646 138.957 133.414C139.036 136.172 140.535 138.694 142.824 140.191C156.24 147.047 187.491 156.739 227.66 156.739C230.817 156.582 233.579 154.612 234.763 151.696C238.314 141.531 243.049 125.376 248.968 96.9288Z"
                fill="#D4E0ED"
            />
            <path
                d="M239.072 122.369C239.041 129.46 240.335 137.792 244.819 141.881C244.954 142.021 245.055 142.19 245.115 142.375C245.175 142.559 245.191 142.755 245.164 142.947C245.137 143.14 245.066 143.323 244.957 143.484C244.848 143.645 244.703 143.779 244.535 143.877C237.669 147.471 232.239 153.284 229.138 160.359C229.048 160.585 228.88 160.773 228.663 160.887C228.447 161.001 228.197 161.035 227.957 160.982C227.718 160.929 227.506 160.793 227.358 160.599C227.211 160.404 227.138 160.163 227.153 159.92C226.775 150.352 223.91 142.627 221.724 139.494C221.618 139.339 221.547 139.163 221.519 138.977C221.49 138.792 221.503 138.602 221.558 138.423C221.613 138.243 221.708 138.078 221.835 137.94C221.963 137.802 222.12 137.694 222.295 137.624C226.584 136.11 232.735 130.93 237.084 121.871C237.176 121.639 237.35 121.448 237.574 121.334C237.797 121.22 238.054 121.191 238.298 121.252C238.541 121.313 238.754 121.46 238.896 121.665C239.039 121.871 239.101 122.121 239.072 122.369Z"
                fill="white"
            />
            <path
                d="M244.535 143.883C237.667 147.473 232.234 153.285 229.132 160.36C229.037 160.604 228.851 160.802 228.612 160.912C228.373 161.022 228.1 161.036 227.852 160.95V160.94C228.471 159.485 232.469 142.998 230.165 139.113C233.915 137.231 237.417 124.975 238.399 121.293C238.608 121.383 238.785 121.534 238.905 121.727C239.025 121.92 239.083 122.145 239.07 122.371C239.039 129.46 240.33 137.79 244.814 141.889C244.949 142.029 245.05 142.197 245.111 142.382C245.171 142.566 245.188 142.762 245.161 142.954C245.134 143.146 245.064 143.329 244.955 143.49C244.847 143.651 244.703 143.785 244.535 143.883Z"
                fill="#D8E5FF"
            />
            <path
                d="M227.853 160.94V160.95C227.644 160.871 227.465 160.73 227.339 160.546C227.214 160.362 227.148 160.145 227.151 159.922C226.779 150.351 223.907 142.632 221.727 139.499C221.598 139.316 221.519 139.102 221.5 138.878C224.35 139.488 227.288 139.567 230.167 139.112C232.471 142.998 228.473 159.485 227.853 160.94Z"
                fill="#ECF1FF"
            />
            <path
                d="M126.133 51.8481C126.013 51.8484 125.892 51.8336 125.775 51.8041C125.594 51.7592 125.423 51.679 125.273 51.5682C125.122 51.4574 124.996 51.3182 124.9 51.1585C124.804 50.9988 124.741 50.8218 124.714 50.6378C124.687 50.4537 124.697 50.2661 124.743 50.086L125.797 46.0586C125.897 45.6959 126.136 45.3864 126.462 45.1966C126.788 45.0068 127.176 44.9517 127.543 45.0432C127.724 45.0881 127.895 45.1682 128.045 45.279C128.196 45.3898 128.322 45.5291 128.418 45.6888C128.514 45.8485 128.577 46.0254 128.604 46.2095C128.631 46.3936 128.621 46.5811 128.575 46.7613L127.521 50.7887C127.44 51.0929 127.26 51.3619 127.009 51.5536C126.758 51.7452 126.45 51.8488 126.133 51.8481Z"
                fill="#1CB5F9"
            />
            <path
                d="M123.192 63.0882C123.071 63.0885 122.951 63.0737 122.834 63.0442C122.652 62.9993 122.481 62.9191 122.331 62.8083C122.181 62.6975 122.054 62.5583 121.958 62.3986C121.863 62.2389 121.799 62.0619 121.772 61.8779C121.746 61.6938 121.756 61.5062 121.802 61.3261L122.856 57.2987C122.955 56.9358 123.194 56.6261 123.52 56.4362C123.847 56.2463 124.235 56.1914 124.602 56.2832C124.783 56.3281 124.954 56.4083 125.104 56.5191C125.254 56.6299 125.381 56.7692 125.477 56.9288C125.573 57.0885 125.636 57.2655 125.663 57.4496C125.69 57.6337 125.679 57.8212 125.633 58.0014L124.579 62.0287C124.498 62.333 124.318 62.6019 124.067 62.7936C123.816 62.9853 123.508 63.0889 123.192 63.0882Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.944 57.4213C132.823 57.4216 132.702 57.4068 132.585 57.3772L128.494 56.3397C128.312 56.2948 128.142 56.2146 127.991 56.1038C127.841 55.993 127.714 55.8538 127.619 55.6941C127.523 55.5344 127.459 55.3574 127.433 55.1734C127.406 54.9893 127.416 54.8018 127.462 54.6216C127.561 54.2582 127.799 53.9481 128.126 53.7581C128.452 53.568 128.841 53.5135 129.208 53.6061L133.299 54.6436C133.636 54.7269 133.931 54.9303 134.127 55.2153C134.323 55.5003 134.407 55.8471 134.364 56.1897C134.32 56.5324 134.151 56.8471 133.889 57.0741C133.627 57.3011 133.291 57.4247 132.944 57.4213L132.944 57.4213Z"
                fill="#1CB5F9"
            />
            <path
                d="M121.526 54.5252C121.405 54.5256 121.285 54.5108 121.167 54.4812L117.076 53.4451C116.894 53.4002 116.724 53.3201 116.573 53.2094C116.423 53.0986 116.296 52.9593 116.2 52.7996C116.105 52.6399 116.041 52.4629 116.015 52.2788C115.988 52.0947 115.998 51.9071 116.044 51.7269C116.143 51.3637 116.381 51.0536 116.708 50.8636C117.034 50.6736 117.423 50.619 117.79 50.7115L121.881 51.7476C122.218 51.8308 122.513 52.0343 122.709 52.3193C122.905 52.6043 122.99 52.951 122.946 53.2937C122.902 53.6363 122.733 53.951 122.471 54.178C122.21 54.4051 121.873 54.5286 121.526 54.5252L121.526 54.5252Z"
                fill="#1CB5F9"
            />
            <path
                d="M279.133 149.848C279.013 149.848 278.892 149.834 278.775 149.804C278.594 149.759 278.423 149.679 278.273 149.568C278.122 149.457 277.996 149.318 277.9 149.158C277.804 148.999 277.741 148.822 277.714 148.638C277.687 148.454 277.697 148.266 277.743 148.086L278.797 144.059C278.897 143.696 279.136 143.386 279.462 143.197C279.788 143.007 280.176 142.952 280.543 143.043C280.724 143.088 280.895 143.168 281.045 143.279C281.196 143.39 281.322 143.529 281.418 143.689C281.514 143.848 281.577 144.025 281.604 144.21C281.631 144.394 281.621 144.581 281.575 144.761L280.521 148.789C280.44 149.093 280.26 149.362 280.009 149.554C279.758 149.745 279.45 149.849 279.133 149.848Z"
                fill="#1CB5F9"
            />
            <path
                d="M276.192 161.088C276.071 161.089 275.951 161.074 275.834 161.044C275.652 160.999 275.481 160.919 275.331 160.808C275.181 160.698 275.054 160.558 274.958 160.399C274.863 160.239 274.799 160.062 274.772 159.878C274.746 159.694 274.756 159.506 274.802 159.326L275.856 155.299C275.955 154.936 276.194 154.626 276.52 154.436C276.847 154.246 277.235 154.191 277.602 154.283C277.783 154.328 277.954 154.408 278.104 154.519C278.254 154.63 278.381 154.769 278.477 154.929C278.573 155.089 278.636 155.266 278.663 155.45C278.69 155.634 278.679 155.821 278.633 156.001L277.579 160.029C277.498 160.333 277.318 160.602 277.067 160.794C276.816 160.985 276.508 161.089 276.192 161.088Z"
                fill="#1CB5F9"
            />
            <path
                d="M285.944 155.421C285.823 155.422 285.702 155.407 285.585 155.377L281.494 154.34C281.312 154.295 281.142 154.215 280.991 154.104C280.841 153.993 280.714 153.854 280.619 153.694C280.523 153.534 280.459 153.357 280.433 153.173C280.406 152.989 280.416 152.802 280.462 152.622C280.561 152.258 280.799 151.948 281.126 151.758C281.452 151.568 281.841 151.513 282.208 151.606L286.299 152.644C286.636 152.727 286.931 152.93 287.127 153.215C287.323 153.5 287.407 153.847 287.364 154.19C287.32 154.532 287.151 154.847 286.889 155.074C286.627 155.301 286.291 155.425 285.944 155.421L285.944 155.421Z"
                fill="#1CB5F9"
            />
            <path
                d="M274.526 152.525C274.405 152.526 274.285 152.511 274.167 152.481L270.076 151.445C269.894 151.4 269.724 151.32 269.573 151.209C269.423 151.099 269.296 150.959 269.2 150.8C269.105 150.64 269.041 150.463 269.015 150.279C268.988 150.095 268.998 149.907 269.044 149.727C269.143 149.364 269.381 149.054 269.708 148.864C270.034 148.674 270.423 148.619 270.79 148.711L274.881 149.748C275.218 149.831 275.513 150.034 275.709 150.319C275.905 150.604 275.99 150.951 275.946 151.294C275.902 151.636 275.733 151.951 275.471 152.178C275.21 152.405 274.873 152.529 274.526 152.525L274.526 152.525Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="d26d7516__paint0_linear_19033_6"
                x1={144.412}
                y1={24.1047}
                x2={190.955}
                y2={238.576}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.206374} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="d26d7516__paint1_linear_19033_6"
                x1={187.944}
                y1={127.506}
                x2={204.997}
                y2={33.944}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="d26d7516__clip0_19033_6">
                <rect width={307} height={180} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default PromoPercentM;
