import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PromoSaleXs = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 145 102"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#2a571356__clip0_19033_12)">
            <path
                opacity={0.5}
                d="M233.483 111.094L211.022 36.5149C211.022 36.5149 207.874 13.0055 186.821 21.2684C172.704 26.8126 165.769 31.024 155.144 37.048C150.766 39.5535 146.487 40.9929 142.995 41.8991C143.486 33.4763 141.175 24.1471 132.468 23.6674C127.304 23.3475 119.089 23.9872 115.646 27.7189C118.253 19.4026 109.568 8.12726 100.173 7.221C73.0777 4.6072 53.2952 25.4668 46.1629 54.5203C33.9151 53.2409 21.8776 68.0076 32.3055 76.537C21.4349 75.2576 1.2345 96.8609 0.29993 109.069C0.152366 110.242 0.890187 111.095 2.11989 111.095C17.3682 112.001 32.6657 112.534 47.914 113.547C54.3085 112.854 60.7029 112.001 67.0482 110.935C105.169 111.254 233.483 111.094 233.483 111.094Z"
                fill="url(#2a571356__paint0_linear_19033_12)"
            />
            <path
                d="M84.347 29.7218C84.328 34.1807 85.1414 39.4194 87.961 41.9906C88.0457 42.0788 88.1093 42.185 88.1469 42.3011C88.1844 42.4173 88.195 42.5405 88.1778 42.6613C88.1605 42.7821 88.116 42.8975 88.0474 42.9987C87.9789 43.0999 87.8881 43.1843 87.782 43.2456C83.4651 45.5055 80.0507 49.1607 78.1011 53.6091C78.0445 53.7517 77.9386 53.8695 77.8026 53.9414C77.6665 54.0133 77.5091 54.0345 77.3586 54.0013C77.2082 53.9681 77.0746 53.8826 76.9819 53.7602C76.8892 53.6377 76.8434 53.4864 76.8528 53.3334C76.6151 47.3175 74.8135 42.4602 73.4393 40.4899C73.3723 40.3926 73.3281 40.2815 73.31 40.1649C73.292 40.0483 73.3005 39.9292 73.3349 39.8163C73.3693 39.7034 73.4288 39.5997 73.509 39.5127C73.5892 39.4258 73.688 39.3579 73.7981 39.3141C76.4953 38.362 80.3626 35.1049 83.0974 29.4089C83.1554 29.2629 83.2648 29.1429 83.4052 29.0713C83.5455 28.9996 83.7073 28.9812 83.8603 29.0196C84.0133 29.0579 84.1471 29.1502 84.2366 29.2795C84.3262 29.4087 84.3654 29.5659 84.347 29.7218Z"
                fill="white"
            />
            <path
                d="M87.783 43.2495C83.4646 45.5072 80.0486 49.1616 78.0984 53.6099C78.0385 53.7634 77.9211 53.8878 77.7709 53.957C77.6207 54.0262 77.4494 54.0348 77.293 53.9809V53.9745C77.6827 53.0599 80.1964 42.6931 78.7479 40.2501C81.1057 39.0669 83.3076 31.3604 83.9247 29.0454C84.0564 29.1017 84.1676 29.1969 84.2431 29.3182C84.3187 29.4394 84.3549 29.5809 84.3469 29.7233C84.3274 34.1808 85.1393 39.4187 87.9583 41.996C88.0433 42.0838 88.1072 42.1896 88.1451 42.3055C88.183 42.4215 88.1939 42.5444 88.177 42.6651C88.1601 42.7859 88.1158 42.9012 88.0476 43.0024C87.9793 43.1036 87.8888 43.1881 87.783 43.2495Z"
                fill="#D8E5FF"
            />
            <path
                d="M77.2915 53.9741V53.9805C77.1602 53.9308 77.0475 53.8422 76.9685 53.7266C76.8895 53.6111 76.8481 53.4743 76.8498 53.3346C76.616 47.3165 74.8103 42.4625 73.4398 40.4926C73.3583 40.3775 73.309 40.2429 73.2969 40.1025C75.0887 40.4857 76.9364 40.5356 78.7464 40.2497C80.1949 42.6927 77.6812 53.0595 77.2915 53.9741Z"
                fill="#ECF1FF"
            />
            <path
                d="M124.759 59.8857L107.404 38.6454C104.954 35.6475 100.71 34.8337 97.3251 36.7131L68.7347 52.5889C68.7347 52.5889 67.6429 66.4274 66.2148 79.3018C66.2568 80.7695 69.7847 80.9371 71.0027 81.7339C75.9583 84.8371 86.1216 91.4629 111.74 89.9113C113.42 89.8274 116.527 90.5405 117.157 88.9889C118.459 83.621 121.399 73.9758 124.759 59.8857Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M102.717 51.0171L101.652 56.6048L89.6785 85.3416L88.082 84.0112L102.717 51.0171Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M111.101 28.3214C108.893 31.9673 105.974 35.9729 105.34 36.9743C105.96 37.7475 106.044 38.3903 105.747 38.9523C105.293 39.814 104.281 40.1938 103.412 39.875C99.4852 46.1937 87.9203 58.0637 82.1899 62.7148C83.2628 64.3967 92.8576 74.7082 96.1041 77.5467C96.5913 77.9726 97.3093 77.9901 97.8157 77.5868C107.322 70.0102 119.309 55.0178 120.663 52.8261C120.745 52.6937 120.742 52.5335 120.665 52.3984C120.415 51.9613 120.201 51.1422 120.485 50.568C120.871 49.7882 121.806 49.4598 122.756 49.5469C122.915 49.5615 123.069 49.4989 123.156 49.3663C124.022 48.059 127.16 42.2576 128.685 39.1017C128.98 38.4921 128.77 37.7638 128.196 37.4045C124.829 35.2954 116.278 29.8641 112.919 27.8637C112.29 27.4887 111.48 27.6952 111.101 28.3214Z"
                fill="#FFCC00"
            />
            <path
                d="M112.883 49.6116C112.943 49.4726 112.92 49.3179 112.827 49.198C112.538 48.8214 112.27 48.1278 112.4 47.5016C112.598 46.5482 113.564 46.1276 114.531 46.0972C114.692 46.0922 114.838 46.0085 114.908 45.8628C115.568 44.476 117.67 38.608 118.717 35.3529C118.921 34.7171 118.62 34.0334 118.013 33.7547C115.234 32.4765 109.124 29.6249 104.829 27.6742C103.139 30.8287 101.321 33.8278 100.87 34.6884C101.55 35.4086 101.686 36.0425 101.437 36.6268C101.054 37.5225 100.076 37.9835 99.1849 37.7363C95.7843 44.3537 85.2243 57.1259 79.8916 62.2281C81.0615 63.7693 90.8799 72.7464 94.6339 75.6262C103.871 65.7199 111.836 52.0122 112.883 49.6116Z"
                fill="#EBB409"
            />
            <path
                d="M97.6925 26.2533C96.3249 29.9006 94.6122 33.7245 94.0259 35.1143C93.9587 35.2738 94.0042 35.4503 94.1247 35.5745C94.7026 36.1683 94.8554 36.7938 94.6388 37.3229C94.3463 38.0377 93.6576 38.4089 92.7721 38.5451C92.6279 38.5674 92.5048 38.6566 92.4498 38.7919C89.7564 45.4033 81.1512 58.0974 76.1894 64.2512C75.7266 64.8254 75.8173 65.661 76.3929 66.1215C79.6456 68.7265 88.9033 75.1201 92.042 76.8668C92.5512 77.1502 93.2904 77.0257 93.6773 76.59C102.947 66.1443 110.861 50.8041 111.829 48.2376C111.882 48.0958 111.85 47.9424 111.752 47.8272C111.445 47.4655 111.142 46.7867 111.24 46.1549C111.388 45.1927 112.332 44.7239 113.296 44.6442C113.456 44.6309 113.598 44.5398 113.66 44.391C114.25 42.9726 116.05 37.0056 116.93 33.7019C117.102 33.0568 116.766 32.3891 116.146 32.1413C112.468 30.6702 103.068 26.8444 99.4001 25.4721C98.713 25.2142 97.9501 25.566 97.6925 26.2533Z"
                fill="url(#2a571356__paint1_linear_19033_12)"
            />
            <path
                d="M94.6381 63.488C94.4832 63.7371 94.3254 63.953 94.1647 64.1357C94.0075 64.3127 93.8524 64.4674 93.6993 64.5999C93.5498 64.7267 93.4051 64.833 93.2654 64.9189C93.1235 64.9955 92.9933 65.0597 92.8747 65.1116L91.8557 64.4778C91.98 64.4295 92.1183 64.3585 92.2707 64.2649C92.421 64.1621 92.5745 64.0417 92.731 63.9035C92.8876 63.7654 93.0427 63.6106 93.1964 63.4393C93.3501 63.2679 93.4885 63.0832 93.6118 62.885C93.8477 62.5057 93.9851 62.1712 94.024 61.8813C94.0629 61.5915 93.9465 61.3621 93.6748 61.1931C93.5276 61.1016 93.3865 61.057 93.2516 61.0594C93.1166 61.0619 92.9828 61.1003 92.8501 61.1748C92.7174 61.2493 92.5773 61.3545 92.43 61.4906C92.2861 61.6209 92.1316 61.7682 91.9667 61.9325C91.7784 62.1216 91.5725 62.3076 91.3488 62.4904C91.1288 62.6676 90.8945 62.8045 90.6459 62.9011C90.3974 62.9978 90.1314 63.0404 89.848 63.029C89.5625 63.0085 89.2555 62.8961 88.9272 62.6919C88.6385 62.5123 88.4189 62.2973 88.2686 62.0467C88.1125 61.7927 88.0261 61.5151 88.0091 61.2141C87.9922 60.9131 88.0385 60.5926 88.148 60.2524C88.2553 59.9031 88.4234 59.5444 88.6523 59.1765C88.9234 58.7406 89.1824 58.4188 89.4293 58.2112C89.674 57.9944 89.8782 57.8427 90.042 57.7562L91.061 58.3899C90.8351 58.5006 90.6054 58.6679 90.372 58.8917C90.1386 59.1156 89.9128 59.403 89.6945 59.754C89.4304 60.1786 89.2945 60.5297 89.2866 60.8075C89.2731 61.0817 89.3767 61.2874 89.5975 61.4247C89.7334 61.5092 89.8659 61.5485 89.9952 61.5426C90.1224 61.5275 90.2478 61.4837 90.3713 61.4114C90.4948 61.339 90.6203 61.2444 90.748 61.1275C90.8735 61.0015 91.0071 60.8687 91.1488 60.7291C91.3533 60.5266 91.5663 60.3293 91.7878 60.1373C92.0128 59.9396 92.253 59.7868 92.5086 59.6788C92.7642 59.5709 93.0393 59.5261 93.3341 59.5445C93.6266 59.5538 93.9456 59.6658 94.2909 59.8805C94.6589 60.1094 94.9178 60.3685 95.0675 60.6579C95.2208 60.9417 95.3006 61.2425 95.307 61.5605C95.3076 61.875 95.2448 62.197 95.1183 62.5266C94.9918 62.8562 94.8318 63.1766 94.6381 63.488ZM98.1431 57.663C98.0476 57.6271 97.9267 57.5755 97.7802 57.5079C97.6317 57.4312 97.5029 57.3669 97.394 57.3148C97.462 57.42 97.5185 57.5375 97.5633 57.6674C97.6116 57.7917 97.642 57.9322 97.6543 58.0891C97.661 58.2424 97.6412 58.4068 97.595 58.5821C97.5523 58.7518 97.471 58.9329 97.3513 59.1254C97.2351 59.3122 97.0988 59.4747 96.9422 59.6128C96.7891 59.7453 96.6183 59.8432 96.4298 59.9065C96.2448 59.9642 96.0501 59.9805 95.8459 59.9555C95.6416 59.9305 95.4319 59.8512 95.2167 59.7174C94.7469 59.4251 94.499 59.0158 94.4731 58.4894C94.4472 57.963 94.6455 57.3601 95.068 56.6808L95.406 56.1373L95.2107 56.0159C94.9389 55.8469 94.7109 55.8032 94.5267 55.8849C94.3403 55.9574 94.152 56.1465 93.9619 56.4522C93.7718 56.7579 93.6371 57.0627 93.5579 57.3668C93.4788 57.6708 93.4274 57.949 93.404 58.2013L92.4699 57.6204C92.4933 57.3681 92.5588 57.0672 92.6661 56.7179C92.7734 56.3686 92.938 56.0156 93.1598 55.6589C93.519 55.0815 93.9206 54.7071 94.3647 54.5358C94.8123 54.3589 95.3022 54.4359 95.8344 54.7668L98.0847 56.1664C98.1356 56.1981 98.1951 56.235 98.263 56.2773C98.3288 56.3103 98.3956 56.348 98.4636 56.3902C98.535 56.4268 98.6037 56.4617 98.6694 56.4947C98.7296 56.5243 98.7812 56.5485 98.8244 56.5675L98.1431 57.663ZM96.7325 58.2459C96.8522 58.0534 96.9094 57.8731 96.904 57.7049C96.8931 57.5332 96.8549 57.38 96.7896 57.2451C96.7243 57.1103 96.6477 56.9999 96.5599 56.9139C96.47 56.8187 96.4023 56.757 96.357 56.7288L96.0938 56.5651L95.7822 57.0661C95.5639 57.4171 95.4632 57.7116 95.4799 57.9498C95.4946 58.1787 95.601 58.3548 95.7991 58.478C95.9803 58.5907 96.1535 58.6277 96.3188 58.5892C96.4819 58.5415 96.6198 58.4271 96.7325 58.2459ZM94.0504 50.6671L100.139 54.4538L99.4102 55.6256L93.3216 51.839L94.0504 50.6671ZM102.87 49.4187C102.867 49.5113 102.861 49.617 102.849 49.7357C102.836 49.8453 102.811 49.9747 102.773 50.1239C102.733 50.2639 102.673 50.423 102.594 50.6012C102.524 50.7774 102.42 50.9758 102.282 51.1966C101.747 52.0571 101.15 52.569 100.491 52.7323C99.8323 52.8956 99.1405 52.7519 98.4159 52.3012C98.0592 52.0794 97.7728 51.8267 97.5567 51.5431C97.344 51.2538 97.2031 50.9503 97.1338 50.6324C97.0589 50.3111 97.055 49.9828 97.1221 49.6477C97.1871 49.3034 97.3234 48.9643 97.5311 48.6303C97.7424 48.2906 97.9891 48.0201 98.2713 47.8188C98.5479 47.6139 98.8483 47.4907 99.1726 47.449C99.5004 47.4016 99.8496 47.4461 100.22 47.5823C100.591 47.7186 100.97 47.9545 101.358 48.29L99.4991 51.2791C99.8726 51.4486 100.21 51.486 100.513 51.3913C100.813 51.2875 101.104 51.0091 101.385 50.5562C101.611 50.1939 101.754 49.8749 101.816 49.5992C101.881 49.3178 101.924 49.0657 101.944 48.8431L102.87 49.4187ZM98.4163 49.1572C98.2544 49.4177 98.1981 49.6849 98.2475 49.959C98.2968 50.2331 98.4522 50.4945 98.7135 50.7434L99.8542 48.9092C99.5464 48.7099 99.272 48.6335 99.0311 48.6799C98.7903 48.7264 98.5853 48.8855 98.4163 49.1572Z"
                fill="white"
            />
            <path
                d="M97.7412 37.8754C98.0108 38.0208 98.1106 38.3575 97.9647 38.627C97.8995 38.7478 97.7959 38.8345 97.677 38.8805C97.5303 38.9372 97.361 38.9318 97.2123 38.8514C96.9453 38.7068 96.8245 38.3649 96.9655 38.0964C97.1063 37.8274 97.4172 37.7115 97.6883 37.8483L97.4372 38.343L97.6955 37.8521C97.7001 37.8542 97.7364 37.8729 97.7412 37.8754ZM102.63 39.9885C102.349 39.8677 102.022 39.9969 101.901 40.2793C101.779 40.5606 101.909 40.887 102.191 41.0077L102.249 41.0316C102.384 41.0846 102.527 41.0812 102.652 41.0326C102.792 40.9786 102.91 40.8683 102.969 40.7185C103.081 40.4331 102.941 40.1113 102.655 39.9993L102.63 39.9885ZM99.9097 39.4534L100.129 38.9438C99.8478 38.8229 99.521 38.9522 99.3996 39.2345C99.2784 39.5159 99.4085 39.8422 99.6905 39.9629C99.6941 39.9649 99.7384 39.9834 99.7423 39.9848C99.8784 40.0401 100.024 40.0372 100.151 39.988C100.289 39.9347 100.405 39.8263 100.465 39.6786C100.581 39.3947 100.444 39.0715 100.159 38.9565L99.9097 39.4534ZM105.127 41.0419C104.846 40.9205 104.537 41.0581 104.416 41.3403C104.295 41.6217 104.442 41.9551 104.724 42.0763C104.864 42.1382 105.016 42.1374 105.149 42.0861C105.281 42.0349 105.395 41.9331 105.457 41.7931C105.581 41.513 105.454 41.1857 105.174 41.0616L105.127 41.0419ZM110.134 43.3437C110.129 43.3412 110.085 43.3185 110.079 43.3158C109.807 43.1827 109.497 43.3006 109.359 43.571C109.221 43.8409 109.345 44.1811 109.612 44.3235C109.76 44.4017 109.928 44.4068 110.073 44.3507C110.193 44.3042 110.298 44.2158 110.363 44.0936C110.507 43.8228 110.405 43.4872 110.134 43.3437ZM107.613 42.1388C107.335 42.0163 107.031 42.1483 106.904 42.4233C106.777 42.6983 106.915 43.0332 107.188 43.1643C107.332 43.2333 107.491 43.2347 107.629 43.1813C107.756 43.1321 107.866 43.0364 107.929 42.9039C108.062 42.6272 107.946 42.2959 107.669 42.1636C107.664 42.1615 107.618 42.1407 107.613 42.1388Z"
                fill="#891712"
            />
            <path
                d="M124.759 59.8861L95.2767 71.1668C94.1848 71.5861 92.9669 71.4184 92.043 70.7055L68.7347 52.5894C68.7347 52.5894 66.803 65.5894 66.2148 79.3023C66.2568 80.77 67.0548 82.1119 68.2727 82.9087C75.4123 86.5571 92.043 91.7152 113.419 91.7152C115.099 91.6313 116.569 90.5829 117.199 89.0313C119.089 83.6216 121.609 75.0248 124.759 59.8861Z"
                fill="#D4E0ED"
            />
            <path
                d="M120.175 76.0453C120.157 80.0956 120.896 84.8542 123.457 87.1897C123.534 87.2698 123.592 87.3663 123.626 87.4718C123.66 87.5773 123.67 87.6892 123.654 87.799C123.639 87.9087 123.598 88.0135 123.536 88.1054C123.474 88.1974 123.391 88.274 123.295 88.3297C119.373 90.3825 116.272 93.7028 114.501 97.7435C114.45 97.873 114.353 97.98 114.23 98.0453C114.106 98.1106 113.963 98.1299 113.827 98.0997C113.69 98.0696 113.569 97.9919 113.484 97.8807C113.4 97.7695 113.359 97.632 113.367 97.493C113.151 92.0284 111.515 87.6163 110.266 85.8266C110.206 85.7382 110.165 85.6373 110.149 85.5314C110.133 85.4255 110.14 85.3172 110.172 85.2147C110.203 85.1122 110.257 85.0179 110.33 84.939C110.403 84.86 110.492 84.7983 110.592 84.7585C113.042 83.8937 116.555 80.9351 119.039 75.761C119.092 75.6285 119.191 75.5194 119.319 75.4544C119.447 75.3893 119.593 75.3726 119.732 75.4074C119.871 75.4422 119.993 75.5261 120.074 75.6435C120.156 75.7609 120.191 75.9037 120.175 76.0453Z"
                fill="white"
            />
            <path
                d="M123.294 88.333C119.372 90.3838 116.269 93.7033 114.497 97.744C114.443 97.8834 114.336 97.9964 114.2 98.0593C114.063 98.1221 113.908 98.1299 113.766 98.0809V98.0751C114.12 97.2444 116.403 87.8276 115.087 85.6085C117.229 84.5337 119.229 77.5335 119.79 75.4307C119.909 75.4818 120.01 75.5683 120.079 75.6784C120.147 75.7886 120.18 75.917 120.173 76.0464C120.155 80.0954 120.893 84.8533 123.454 87.1944C123.531 87.2742 123.589 87.3703 123.623 87.4756C123.658 87.5809 123.668 87.6926 123.652 87.8022C123.637 87.9119 123.597 88.0166 123.535 88.1086C123.473 88.2005 123.39 88.2773 123.294 88.333Z"
                fill="#D8E5FF"
            />
            <path
                d="M113.765 98.0754V98.0812C113.646 98.0361 113.544 97.9556 113.472 97.8506C113.4 97.7457 113.362 97.6214 113.364 97.4945C113.152 92.028 111.511 87.6188 110.267 85.8295C110.193 85.7248 110.148 85.6026 110.137 85.4751C111.764 85.8232 113.443 85.8685 115.087 85.6088C116.403 87.8279 114.119 97.2447 113.765 98.0754Z"
                fill="#ECF1FF"
            />
            <path
                d="M118.709 26.5477C120.616 23.8281 121.873 22.561 124.045 20.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M124.066 27.0615C125.522 25.9134 128.619 23.4588 130.075 22.3107"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M57.6964 29.6874C57.649 29.6875 57.6016 29.6816 57.5556 29.6699C57.4843 29.652 57.4172 29.62 57.3581 29.5759C57.2991 29.5317 57.2493 29.4762 57.2116 29.4126C57.174 29.349 57.1491 29.2784 57.1386 29.2051C57.128 29.1317 57.132 29.057 57.1502 28.9852L57.5644 27.3803C57.6036 27.2358 57.6973 27.1125 57.8255 27.0368C57.9538 26.9612 58.1063 26.9393 58.2504 26.9757C58.3217 26.9936 58.3888 27.0255 58.4479 27.0697C58.5069 27.1138 58.5567 27.1693 58.5944 27.233C58.6321 27.2966 58.6569 27.3671 58.6674 27.4405C58.678 27.5138 58.674 27.5886 58.6558 27.6604L58.2416 29.2652C58.2098 29.3865 58.139 29.4937 58.0404 29.57C57.9418 29.6464 57.8208 29.6877 57.6964 29.6874Z"
                fill="#1CB5F9"
            />
            <path
                d="M56.5402 34.1666C56.4927 34.1667 56.4454 34.1608 56.3994 34.149C56.328 34.1311 56.2609 34.0992 56.2019 34.055C56.1429 34.0109 56.0931 33.9554 56.0554 33.8918C56.0177 33.8281 55.9929 33.7576 55.9823 33.6842C55.9718 33.6109 55.9757 33.5362 55.9939 33.4644L56.4082 31.8595C56.4471 31.7149 56.5409 31.5914 56.6691 31.5158C56.7974 31.4401 56.95 31.4182 57.0941 31.4548C57.1655 31.4727 57.2326 31.5047 57.2916 31.5488C57.3506 31.593 57.4004 31.6485 57.4381 31.7121C57.4758 31.7757 57.5006 31.8463 57.5112 31.9196C57.5217 31.993 57.5178 32.0677 57.4996 32.1395L57.0853 33.7444C57.0535 33.8656 56.9828 33.9728 56.8841 34.0492C56.7855 34.1256 56.6646 34.1668 56.5402 34.1666Z"
                fill="#1CB5F9"
            />
            <path
                d="M60.3727 31.9085C60.3252 31.9086 60.2779 31.9027 60.2319 31.8909L58.624 31.4775C58.5527 31.4596 58.4855 31.4277 58.4265 31.3835C58.3675 31.3394 58.3177 31.2839 58.28 31.2202C58.2423 31.1566 58.2175 31.0861 58.2069 31.0127C58.1964 30.9394 58.2003 30.8646 58.2185 30.7928C58.2573 30.648 58.3509 30.5244 58.4793 30.4487C58.6076 30.373 58.7604 30.3513 58.9045 30.3882L60.5124 30.8016C60.6449 30.8348 60.7607 30.9159 60.8378 31.0294C60.9149 31.143 60.948 31.2812 60.9308 31.4177C60.9135 31.5543 60.8472 31.6797 60.7443 31.7701C60.6414 31.8606 60.5092 31.9099 60.3727 31.9085L60.3727 31.9085Z"
                fill="#1CB5F9"
            />
            <path
                d="M55.8845 30.7541C55.837 30.7542 55.7897 30.7483 55.7437 30.7365L54.1358 30.3236C54.0644 30.3058 53.9973 30.2739 53.9382 30.2297C53.8792 30.1856 53.8294 30.1301 53.7917 30.0664C53.754 30.0028 53.7292 29.9323 53.7186 29.8589C53.7081 29.7855 53.7121 29.7108 53.7303 29.639C53.7691 29.4942 53.8628 29.3707 53.9911 29.2949C54.1194 29.2192 54.2722 29.1975 54.4163 29.2343L56.0242 29.6472C56.1567 29.6804 56.2725 29.7615 56.3496 29.875C56.4267 29.9886 56.4598 30.1268 56.4425 30.2633C56.4253 30.3998 56.359 30.5253 56.2561 30.6157C56.1532 30.7062 56.021 30.7554 55.8845 30.7541L55.8845 30.7541Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.466 92.7289C132.418 92.7291 132.371 92.7232 132.325 92.7114C132.254 92.6935 132.187 92.6615 132.128 92.6174C132.069 92.5732 132.019 92.5177 131.981 92.4541C131.943 92.3905 131.919 92.32 131.908 92.2466C131.898 92.1732 131.902 92.0985 131.92 92.0267L132.334 90.4218C132.373 90.2773 132.467 90.154 132.595 90.0784C132.723 90.0027 132.876 89.9808 133.02 90.0172C133.091 90.0351 133.158 90.067 133.217 90.1112C133.276 90.1553 133.326 90.2108 133.364 90.2745C133.402 90.3381 133.426 90.4086 133.437 90.482C133.448 90.5553 133.444 90.6301 133.425 90.7019L133.011 92.3067C132.979 92.428 132.909 92.5352 132.81 92.6115C132.711 92.6879 132.59 92.7292 132.466 92.7289Z"
                fill="#1CB5F9"
            />
            <path
                d="M131.31 97.2081C131.262 97.2082 131.215 97.2023 131.169 97.1905C131.098 97.1726 131.03 97.1407 130.971 97.0965C130.912 97.0524 130.863 96.9969 130.825 96.9333C130.787 96.8696 130.762 96.7991 130.752 96.7257C130.741 96.6524 130.745 96.5777 130.763 96.5059L131.178 94.901C131.217 94.7564 131.31 94.633 131.439 94.5573C131.567 94.4816 131.72 94.4597 131.864 94.4963C131.935 94.5142 132.002 94.5462 132.061 94.5903C132.12 94.6345 132.17 94.69 132.208 94.7536C132.245 94.8172 132.27 94.8878 132.281 94.9611C132.291 95.0345 132.287 95.1092 132.269 95.181L131.855 96.7859C131.823 96.9071 131.752 97.0143 131.654 97.0907C131.555 97.1671 131.434 97.2083 131.31 97.2081Z"
                fill="#1CB5F9"
            />
            <path
                d="M135.142 94.95C135.095 94.9501 135.047 94.9442 135.001 94.9324L133.394 94.519C133.322 94.5011 133.255 94.4692 133.196 94.425C133.137 94.3809 133.087 94.3254 133.05 94.2617C133.012 94.1981 132.987 94.1276 132.976 94.0542C132.966 93.9809 132.97 93.9061 132.988 93.8343C133.027 93.6895 133.12 93.5659 133.249 93.4902C133.377 93.4145 133.53 93.3928 133.674 93.4297L135.282 93.8431C135.414 93.8763 135.53 93.9574 135.607 94.0709C135.684 94.1845 135.718 94.3227 135.7 94.4592C135.683 94.5958 135.617 94.7212 135.514 94.8117C135.411 94.9021 135.279 94.9514 135.142 94.95L135.142 94.95Z"
                fill="#1CB5F9"
            />
            <path
                d="M130.654 93.7956C130.607 93.7957 130.559 93.7898 130.513 93.778L128.905 93.3651C128.834 93.3473 128.767 93.3154 128.708 93.2712C128.649 93.2271 128.599 93.1716 128.561 93.1079C128.524 93.0443 128.499 92.9738 128.488 92.9004C128.478 92.827 128.482 92.7523 128.5 92.6805C128.539 92.5357 128.632 92.4122 128.761 92.3364C128.889 92.2607 129.042 92.239 129.186 92.2758L130.794 92.6887C130.926 92.7219 131.042 92.803 131.119 92.9165C131.196 93.0301 131.229 93.1683 131.212 93.3048C131.195 93.4413 131.128 93.5668 131.026 93.6572C130.923 93.7477 130.791 93.7969 130.654 93.7956L130.654 93.7956Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="2a571356__paint0_linear_19033_12"
                x1={66.5748}
                y1={12.8891}
                x2={84.6034}
                y2={92.4098}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.393875} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="2a571356__paint1_linear_19033_12"
                x1={92.2842}
                y1={76.1571}
                x2={101.359}
                y2={26.3667}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="2a571356__clip0_19033_12">
                <rect width={145} height={102} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default PromoSaleXs;
