import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SecurePayM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 167 120"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M163.275 31.23C162.363 29.7801 161.003 28.6682 159.403 28.0635C157.802 27.4587 156.047 27.3943 154.406 27.88C151.115 28.8839 147.959 30.2877 145.009 32.06L140.615 21.53C140.18 20.4873 139.518 19.5551 138.677 18.8019C137.836 18.0487 136.838 17.4935 135.755 17.177C134.672 16.8606 133.531 16.7909 132.418 16.9731C131.304 17.1553 130.246 17.5848 129.319 18.23L72.9038 57.68L13.7617 42.13C12.6442 41.8346 11.4739 41.8 10.3409 42.0289C9.20795 42.2578 8.14259 42.7441 7.22694 43.4503C6.31129 44.1566 5.5698 45.0639 5.0596 46.1024C4.5494 47.1408 4.28412 48.2827 4.2842 49.44V86.55C4.2795 89.4597 5.23869 92.2887 7.01153 94.5941C8.78438 96.8995 11.2708 98.551 14.0813 99.29L70.2373 114.06C74.6249 115.213 79.2103 115.398 83.6764 114.602C88.1424 113.806 92.3825 112.048 96.1032 109.45L150.312 71.55C152.77 69.8333 154.568 67.3255 155.406 64.4436C156.243 61.5618 156.07 58.4798 154.916 55.71L150.422 44.92C153.36 42.1693 156.845 40.0702 160.648 38.76C161.377 38.5147 162.039 38.106 162.586 37.565C163.133 37.024 163.548 36.3651 163.802 35.6387C164.055 34.9122 164.139 34.1373 164.048 33.3732C163.957 32.6092 163.692 31.8761 163.275 31.23ZM157.283 35.45C155.385 35.45 153.857 34.26 153.857 32.78C153.857 31.3 155.385 30.11 157.283 30.11C159.18 30.11 160.698 31.31 160.698 32.78C160.698 34.25 159.21 35.45 157.323 35.45H157.283Z"
            fill="#E9F0F8"
        />
        <path
            d="M131.357 55.9102L124.057 54.0702L130.538 28.2402C131.005 26.4648 131.116 24.6143 130.864 22.7958C130.612 20.9773 130.002 19.2269 129.07 17.646C128.138 16.065 126.902 14.685 125.433 13.5858C123.965 12.4866 122.293 11.69 120.515 11.2423C118.737 10.7945 116.887 10.7044 115.074 10.9772C113.261 11.25 111.52 11.8803 109.952 12.8316C108.383 13.7829 107.019 15.0362 105.938 16.519C104.857 18.0019 104.08 19.6847 103.653 21.4702L97.8111 44.7502L90.5107 42.9102L96.3531 19.6302C97.896 14.3017 101.444 9.78062 106.249 7.01859C111.054 4.25656 116.742 3.4691 122.115 4.82198C127.488 6.17485 132.128 9.56253 135.057 14.2718C137.986 18.9811 138.976 24.6447 137.818 30.0702L131.357 55.9102Z"
            fill="#1E85FF"
        />
        <g opacity={0.49}>
            <path
                opacity={0.49}
                d="M101.307 30.8303L94.2558 28.0103L90.5107 42.9103L97.8111 44.7503L101.307 30.8303Z"
                fill="#055EC0"
            />
            <path
                opacity={0.49}
                d="M134.333 44.0402L127.282 41.2202L124.416 52.6502L131.716 54.4802L134.333 44.0402Z"
                fill="#055EC0"
            />
        </g>
        <path
            d="M137.525 47.9344L88.1874 35.516C84.3306 34.5452 80.4182 36.8889 79.4487 40.7508L68.1837 85.6248C67.2142 89.4866 69.5548 93.4042 73.4116 94.3749L122.75 106.793C126.606 107.764 130.519 105.42 131.488 101.559L142.753 56.6845C143.723 52.8227 141.382 48.9051 137.525 47.9344Z"
            fill="url(#b6ec0ed9__paint0_linear_27801_5286)"
        />
        <path
            opacity={0.5}
            d="M95.1247 63.5202C94.0126 57.8327 91.5267 52.5042 87.8842 48.0002L87.0253 47.0002L86.8855 46.8202C86.6059 46.5002 86.3163 46.1902 86.0267 45.8902L85.8369 45.6902L84.9381 44.7902L84.7983 44.6602C83.0569 42.9957 81.1494 41.5146 79.1058 40.2402C78.2388 41.1385 77.6224 42.2488 77.3181 43.4602L66.762 85.2902C66.2995 87.1361 66.5876 89.0903 67.5633 90.7235C68.5389 92.3568 70.1222 93.5353 71.9652 94.0002L83.9494 97.0002C88.5601 92.8755 92.0161 87.6175 93.976 81.7458C95.9359 75.8742 96.3319 69.592 95.1247 63.5202Z"
            fill="url(#b6ec0ed9__paint1_linear_27801_5286)"
        />
        <path
            d="M114.669 65.4402C115.006 64.0914 114.964 62.6757 114.547 61.3495C114.13 60.0233 113.356 58.8382 112.309 57.9253C111.261 57.0123 109.983 56.4071 108.613 56.1763C107.244 55.9456 105.838 56.0984 104.55 56.6179C103.262 57.1374 102.143 58.0033 101.316 59.1199C100.489 60.2365 99.986 61.5604 99.8632 62.9452C99.7405 64.33 100.002 65.7218 100.62 66.9669C101.238 68.2119 102.188 69.2617 103.364 70.0001L94.4458 84.1902L109.047 87.8601L107.858 71.1202C109.448 71.0193 110.965 70.4147 112.19 69.3936C113.414 68.3725 114.282 66.988 114.669 65.4402Z"
            fill="#002669"
        />
        <path
            d="M58.4032 98.1902C77.2334 98.1902 92.4983 82.9052 92.4983 64.0502C92.4983 45.1952 77.2334 29.9102 58.4032 29.9102C39.573 29.9102 24.3081 45.1952 24.3081 64.0502C24.3081 82.9052 39.573 98.1902 58.4032 98.1902Z"
            fill="url(#b6ec0ed9__paint2_linear_27801_5286)"
        />
        <path
            opacity={0.5}
            d="M58.4034 91.0703C73.3065 91.0703 85.3878 78.973 85.3878 64.0503C85.3878 49.1275 73.3065 37.0303 58.4034 37.0303C43.5003 37.0303 31.4189 49.1275 31.4189 64.0503C31.4189 78.973 43.5003 91.0703 58.4034 91.0703Z"
            fill="#DC780A"
        />
        <path
            opacity={0.2}
            d="M54.9277 98.0002L84.8882 42.5602C80.0817 36.6273 73.4298 32.4767 65.9931 30.7702L64.9944 30.6602L34.0552 88.0002C39.6417 93.6595 47.0215 97.1951 54.9277 98.0002Z"
            fill="url(#b6ec0ed9__paint3_linear_27801_5286)"
        />
        <path
            d="M51.8576 60.4977L49.1739 46.9389L56.7896 45.4276C59.886 44.8131 62.4817 45.0374 64.5765 46.1004C66.6938 47.13 68.0395 49.0955 68.6138 51.997C68.912 53.5035 68.9149 54.8367 68.6226 55.9965C68.3303 57.1563 67.7902 58.1623 67.0021 59.0145C66.242 59.8613 65.2534 60.5793 64.0365 61.1688C62.814 61.7303 61.4356 62.1633 59.9013 62.4678L57.5999 62.9245L58.188 65.8957L66.5986 64.2267L67.2778 67.6582L58.8672 69.3273L60.1759 75.9393L55.1127 76.9441L53.8041 70.332L50.6239 70.9631L49.9447 67.5316L53.1249 66.9005L52.5368 63.9293L49.3566 64.5604L48.6774 61.1288L51.8576 60.4977ZM55.0488 50.0353L56.9207 59.493L59.264 59.0279C62.7789 58.3304 64.2105 56.3356 63.5589 53.0436C63.2442 51.4533 62.6133 50.3898 61.6663 49.8528C60.7416 49.2825 59.3866 49.1744 57.6013 49.5287L55.0488 50.0353Z"
            fill="#FFE596"
        />
        <path
            d="M147.965 100.44L144.809 100.17C137.509 99.5401 131.447 95.4201 128.831 89.3001L122.639 75.1101L136.95 75.0001L146.807 64.6201L152.959 78.8101C155.615 84.9301 154.477 92.1801 149.963 97.9501L147.965 100.44Z"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M125.285 81.22L139.596 81.15L149.433 70.73"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M39.4096 6.32463L14.0232 18.5802C12.3638 19.3813 11.6671 21.3778 12.4672 23.0393L18.9556 36.5149C19.7556 38.1765 21.7494 38.8741 23.4088 38.073L48.7952 25.8174C50.4546 25.0163 51.1513 23.0199 50.3512 21.3583L43.8628 7.88269C43.0628 6.2211 41.069 5.52353 39.4096 6.32463Z"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M47.1076 14.6192L15.7119 29.7759L17.9412 34.4059L49.3369 19.2492L47.1076 14.6192Z"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M16.958 24.3704L25.1972 20.4004"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M29.5312 18.3001L33.546 16.3701"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M22.6304 85.8203L10.3066 93.3203"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M29.5911 95.1304L20.1235 105.35"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M38.8492 101.65L32.4077 114.04"
            stroke="#00E4C3"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <defs>
            <linearGradient
                id="b6ec0ed9__paint0_linear_27801_5286"
                x1={111.381}
                y1={47.6436}
                x2={99.3314}
                y2={95.5166}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.23} stopColor="#037BF1" />
                <stop offset={1} stopColor="#1563CA" />
            </linearGradient>
            <linearGradient
                id="b6ec0ed9__paint1_linear_27801_5286"
                x1={86.3263}
                y1={55.0902}
                x2={73.721}
                y2={116.364}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.23} stopColor="#055EC0" />
                <stop offset={1} stopColor="#002669" />
            </linearGradient>
            <linearGradient
                id="b6ec0ed9__paint2_linear_27801_5286"
                x1={65.6493}
                y1={93.489}
                x2={48.545}
                y2={24.219}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFD13C" />
                <stop offset={1} stopColor="#FFDC91" />
            </linearGradient>
            <linearGradient
                id="b6ec0ed9__paint3_linear_27801_5286"
                x1={55.6588}
                y1={105.666}
                x2={61.8228}
                y2={40.5382}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.24} stopColor="white" stopOpacity={0} />
                <stop offset={1} stopColor="white" />
            </linearGradient>
        </defs>
    </svg>
);

export default SecurePayM;
