import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SelfConnectL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 220 220"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#d8841908__clip0_19048_68)">
            <path
                d="M154.998 174.211C127.681 199.806 86.9706 204.902 56.7119 184.183C26.4526 163.465 16.4803 123.667 30.4636 88.9436"
                stroke="white"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M154.998 174.211C127.681 199.806 86.9706 204.902 56.7119 184.183C26.4526 163.465 16.4803 123.667 30.4636 88.9436"
                stroke="#ECF2F9"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M52.0785 57.3819C79.3936 31.7861 120.104 26.6903 150.362 47.409C180.62 68.128 190.591 107.929 176.609 142.654"
                stroke="white"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M52.0785 57.3819C79.3936 31.7861 120.104 26.6903 150.362 47.409C180.62 68.128 190.591 107.929 176.609 142.654"
                stroke="#ECF2F9"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M45.8252 106.957L39.2503 74.2398C38.817 72.0858 36.2288 71.191 34.5584 72.6176L9.65342 93.8861C7.97602 95.3184 8.46596 98.0271 10.5385 98.7807L42.019 110.23C44.1301 110.997 46.2678 109.159 45.8252 106.957Z"
                fill="#ECF2F9"
            />
            <path
                d="M161.642 125.947L168.217 158.664C168.65 160.818 171.239 161.712 172.909 160.286L197.814 139.017C199.491 137.585 199.001 134.877 196.928 134.123L165.448 122.674C163.337 121.907 161.199 123.745 161.642 125.947Z"
                fill="#ECF2F9"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M123.236 45.047C121.754 44.9637 119.833 45.0113 116.991 45.0858L115.695 45.1197C112.983 45.1909 111.155 45.2414 109.747 45.3925C108.379 45.5392 107.705 45.756 107.247 46C106.103 46.6096 105.177 47.7377 104.597 48.8974C104.365 49.3615 104.166 50.0413 104.055 51.4124C103.837 54.1125 103.708 56.7918 103.708 59.5C103.708 61.416 102.385 62.8866 100.469 62.8866C98.5533 62.8866 97 61.3334 97 59.4173L97 57.2265C97 54.6889 96.9999 52.5785 97.1393 50.8535C97.2846 49.0556 97.5977 47.3821 98.3902 45.7961C99.6135 43.3478 101.568 41.341 103.984 40.054C105.548 39.2202 107.213 38.8633 109.007 38.671C110.727 38.4864 112.837 38.4311 115.374 38.3647L116.953 38.3233C119.615 38.2534 121.823 38.1955 123.626 38.2968C125.5 38.4022 127.249 38.6896 128.904 39.4947C131.45 40.7336 133.529 42.7592 134.834 45.2717C135.683 46.9047 136.016 48.6454 136.17 50.5168C136.319 52.3161 136.319 54.5255 136.319 57.1883V59.4173C136.319 61.3334 134.765 62.8866 132.849 62.8866C130.933 62.8866 129.38 61.3334 129.38 59.4173V57.3323C129.38 54.489 129.377 52.5676 129.255 51.0877C129.136 49.6474 128.922 48.9428 128.677 48.4703C128.059 47.2802 127.074 46.1432 125.868 45.5564C125.389 45.3234 124.679 45.1282 123.236 45.047Z"
                fill="#292929"
            />
            <path
                d="M103.999 51.115L103.707 59H101.207L102.037 51.2543C102.418 47.6973 105.42 45 108.997 45H121.707L109.824 45.3395C106.664 45.4298 104.116 47.9561 103.999 51.115Z"
                fill="black"
                fillOpacity={0.69}
            />
            <path
                d="M135.207 46C137.095 50.2481 136.707 59.5 136.707 59.5H134.207C134.207 59.5 134.867 53.5 133.707 48C132.547 42.5 129.707 40 129.707 40C129.707 40 133.319 41.7519 135.207 46Z"
                fill="black"
            />
            <path
                d="M65.0801 152.93C67.2309 152.273 68.7916 156.207 70.1643 158.351C73.8649 164.133 76.1777 168.528 76.1777 171.072C76.1777 174.31 76.0113 178.597 72.98 180.443C70.6855 181.258 68.2129 181.322 65.8833 180.629C63.2429 179.916 59.2938 174.418 59.2938 166.757C59.2938 159.095 61.4976 154.073 65.0801 152.93Z"
                fill="#292929"
            />
            <g filter="url(#d8841908__filter0_i_19048_68)">
                <path
                    d="M79.1767 60.6818L70.0149 64.4858C65.1626 66.5006 62 71.2381 62 76.4921V161.2C62 172.135 70.8648 181 81.8 181H131.747C137.137 181 142.294 178.803 146.027 174.916L150.48 170.279C154.022 166.592 156 161.677 156 156.564V72C156 64.8203 150.18 59 143 59H87.613C84.7176 59 81.8507 59.5715 79.1767 60.6818Z"
                    fill="url(#d8841908__paint0_linear_19048_68)"
                />
            </g>
            <path
                d="M62 78C62 71.9249 66.9249 67 73 67H133C139.075 67 144 71.9249 144 78V170C144 176.075 139.075 181 133 181H81.8C70.8648 181 62 172.135 62 161.2V78Z"
                fill="url(#d8841908__paint1_linear_19048_68)"
            />
            <path
                d="M77 79C77 76.7909 78.7909 75 81 75V174C78.7909 174 77 172.209 77 170V79Z"
                fill="url(#d8841908__paint2_linear_19048_68)"
            />
            <path
                d="M93 79C93 76.7909 94.7909 75 97 75V174C94.7909 174 93 172.209 93 170V79Z"
                fill="url(#d8841908__paint3_linear_19048_68)"
            />
            <path
                d="M109 79C109 76.7909 110.791 75 113 75V174C110.791 174 109 172.209 109 170V79Z"
                fill="url(#d8841908__paint4_linear_19048_68)"
            />
            <path
                d="M125 79C125 76.7909 126.791 75 129 75V174C126.791 174 125 172.209 125 170V79Z"
                fill="url(#d8841908__paint5_linear_19048_68)"
            />
            <path
                d="M58.4199 113.227C58.521 113.215 53.3296 113.526 53.3296 113.526C53.3296 113.526 56.6724 102.861 67.7684 105.646C59.2413 106.354 58.4199 113.227 58.4199 113.227Z"
                fill="url(#d8841908__paint6_linear_19048_68)"
            />
            <g filter="url(#d8841908__filter1_i_19048_68)">
                <path
                    d="M27.5789 172.752C36.4848 185.551 46.1787 192.917 62.759 192.687C69.0095 192.661 81.2979 189.965 84.0846 188.402C94.827 182.194 92.965 126.977 85.5448 117.184C78.1247 107.39 50.9187 108.783 41.9234 114.167C32.9281 119.55 17.3199 158.061 27.5789 172.752Z"
                    fill="#FFD34D"
                />
            </g>
            <path
                d="M75.7539 115.885L70.632 115.058C70.6069 110.544 68.8874 106.437 63.4141 105.241C74.5888 105.244 75.9096 112.889 75.7539 115.885Z"
                fill="#66B3FF"
            />
            <path
                d="M46.751 124.576C46.1927 125.053 45.2479 129.169 45.8377 129.818C46.4155 130.365 54.4928 131.045 54.962 130.681C55.4313 130.318 56.595 125.456 56.0293 125.01C55.4636 124.564 47.3092 124.099 46.751 124.576Z"
                fill="#0066DA"
            />
            <path
                d="M62.1264 190.811C70.3854 186.131 71.9524 147.651 68.8437 141.348C65.7229 134.944 32.9637 133.61 27.3403 138.9C20.2323 145.496 16.4578 172.33 18.0652 180.66C19.7616 188.877 53.8554 195.39 62.1264 190.811Z"
                fill="#FFD34D"
                stroke="url(#d8841908__paint7_linear_19048_68)"
                strokeWidth={2}
                strokeMiterlimit={10}
            />
            <path
                d="M86.3874 151.783C86.5449 146.221 86.274 140.504 85.7118 134.924C85.3621 131.989 85.0003 128.952 84.3474 126.052C83.892 123.951 83.2224 121.772 81.9824 119.969C80.7425 118.166 78.5399 116.888 76.6889 115.98C74.2963 114.827 71.7497 114.104 69.2152 113.482C63.7539 112.387 58.0859 112.138 52.4902 112.497C49.951 112.697 47.4119 112.897 44.909 113.4C43.4048 113.682 41.6985 113.988 40.3677 114.865C39.4172 115.492 40.4958 116.8 41.4583 116.275C42.2188 115.774 43.7229 115.492 44.8228 115.258C46.8203 114.815 48.842 114.574 50.8757 114.435C56.055 114.023 61.3957 114.105 66.5055 114.831C71.2109 115.605 76.4942 116.927 79.9728 120.311C81.3546 121.584 81.887 123.471 82.4073 125.257C83.1372 127.942 83.5639 130.663 83.8895 133.396C84.601 139.369 84.9202 145.49 84.7219 151.571C84.6403 152.608 86.3179 152.921 86.3874 151.783Z"
                fill="#FAAC1A"
            />
            <path
                d="M63.6674 151.772C56.1101 151.688 48.5314 151.299 41.0259 150.495C37.8423 150.207 34.6515 149.818 31.4537 149.326C29.2856 148.967 27.1175 148.608 25.0296 147.936C23.9856 147.6 23.1713 149.088 24.2224 149.526C26.3174 150.299 28.5871 150.651 30.7552 151.01C34.0546 151.494 37.3469 151.877 40.6391 152.26C48.3478 153.049 56.028 153.431 63.694 153.61C64.9126 153.524 64.7915 151.796 63.6674 151.772Z"
                fill="#FAAC1A"
            />
            <path
                d="M63.0751 152.301C64.902 153.008 65.479 160.433 64.9041 161.631C64.2281 162.841 59.518 162.889 59.301 161.067C58.9949 159.358 61.1471 151.607 63.0751 152.301Z"
                fill="#FAAC1A"
            />
            <path
                d="M30.3352 74.3266C32.8916 75.3492 38.1272 77.5171 38.6181 78.0079C39.2316 78.6215 44.4468 89.0518 43.8332 89.9721C43.2197 90.8924 37.3029 89.6653 36.6894 89.0518C36.0758 88.4382 22.6658 73.4063 21.4387 72.7928C20.2116 72.1792 14.0761 70.3386 13.1558 69.725C12.2355 69.1115 9.47452 65.737 10.0881 64.8166C10.7016 63.8963 13.9881 62.0557 17.6694 62.0557C20.7371 62.0557 44.3587 70.6453 44.6655 70.3386C44.9722 70.0318 52.3348 65.737 53.5619 66.0437C54.5436 66.2891 56.6155 67.2708 58.2516 67.8844C56.3663 70.6453 46.7656 79.0877 41.9058 77.3974"
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M25.0312 63.5897C28.099 60.931 34.8747 55 35.8564 55C37.0835 55 42.2987 55.9203 41.9919 57.1474C41.7465 58.1291 39.4496 65.4303 38.5293 68.1913"
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M199.805 115.617C200.27 115.185 202.213 113.471 202.655 113.036C203.088 112.611 203.766 112.624 204.177 113.07C206.37 115.456 211.878 121.805 214.053 124.281C214.424 124.703 214.43 125.344 214.067 125.776C212.188 128.009 208.473 132.039 207.511 132.911C207.414 133 207.28 133.017 207.159 132.969C206.435 132.685 205.632 132.743 205.161 133.293C204.814 133.698 204.803 134.414 204.903 134.827C204.934 134.955 204.901 135.086 204.808 135.176C203.273 136.66 190.638 146.205 181.555 150.256C181.071 150.471 180.513 150.295 180.225 149.839C180.162 149.739 179.069 148.115 179 148"
                stroke="#00E6C5"
                strokeWidth={2}
            />
            <path
                d="M167.006 136.983L167.006 136.983C166.951 137.021 166.939 137.092 166.977 137.146L166.977 137.146C168.968 139.975 174.899 147.247 176.976 149.346C176.978 149.347 176.981 149.349 176.987 149.351C177.001 149.358 177.023 149.364 177.049 149.367C177.075 149.37 177.098 149.369 177.113 149.366C177.117 149.365 177.121 149.364 177.123 149.363C182.001 146.277 186.915 142.124 190.792 138.497C194.345 135.173 196.971 132.346 197.884 131.233C197.736 130.691 197.702 129.971 198.004 129.319L167.006 136.983ZM167.006 136.983C169.757 135.054 173.618 132.02 177.255 128.88C180.74 125.87 184.081 122.711 186.04 120.307M167.006 136.983L186.04 120.307M205.521 120.361L205.521 120.361C204.846 119.834 203.908 119.098 202.842 118.26C199.738 115.824 195.547 112.533 193.593 111.078L193.593 111.078C193.546 111.043 193.475 111.048 193.433 111.105C193.433 111.105 193.433 111.105 193.433 111.105L192.631 110.508L205.521 120.361ZM205.521 120.361C205.564 120.394 205.576 120.452 205.547 120.5C204.184 122.769 201.699 126.618 200.716 127.962M205.521 120.361L200.716 127.962M186.04 120.307C186.86 120.343 187.752 120.136 188.371 119.353L186.04 120.307ZM200.716 127.962C199.786 127.879 198.564 128.114 198.004 129.319L200.716 127.962ZM198.099 130.961L198.099 130.961L198.099 130.961Z"
                stroke="#00E6C5"
                strokeWidth={2}
            />
            <line
                x1={191.029}
                y1={121.339}
                x2={195.615}
                y2={125.925}
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeDasharray="0.02 4"
            />
            <line
                x1={178.151}
                y1={42.9875}
                x2={181.812}
                y2={41.9785}
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
            />
            <line
                x1={168.091}
                y1={45.7605}
                x2={171.752}
                y2={44.7515}
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
            />
            <line
                x1={172.98}
                y1={37.1515}
                x2={173.989}
                y2={40.8121}
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
            />
            <line
                x1={175.753}
                y1={47.211}
                x2={176.762}
                y2={50.8717}
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
            />
            <path
                d="M156.483 150.066C154.382 149.548 153.075 152.161 153.001 154.796C152.535 171.359 146.016 172.348 146.016 174.982C146.016 175.499 145.748 176.648 147.413 178.087C149.078 179.526 154.075 179.768 156.245 179.05C158.415 178.332 159.971 172.489 159.971 164.558C159.971 156.628 158.979 150.681 156.483 150.066Z"
                fill="url(#d8841908__paint8_linear_19048_68)"
            />
            <path
                d="M156.513 150.066C154.412 149.548 153.105 152.161 153.031 154.796C152.86 160.886 151.87 164.871 150.687 167.606C150.191 174.844 152.078 179.994 156.275 179.05C158.445 178.332 160.001 172.489 160.001 164.558C160.001 156.628 159.009 150.681 156.513 150.066Z"
                fill="#292929"
            />
        </g>
        <defs>
            <filter
                id="d8841908__filter0_i_19048_68"
                x={57}
                y={51}
                width={99}
                height={130}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dx={-5} dy={-8} />
                <feGaussianBlur stdDeviation={6} />
                <feComposite
                    in2="hardAlpha"
                    operator="arithmetic"
                    k2={-1}
                    k3={1}
                />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.579167 0 0 0 0 0.0927356 0 0 0 0 0.086875 0 0 0 1 0"
                />
                <feBlend
                    mode="normal"
                    in2="shape"
                    result="effect1_innerShadow_19048_68"
                />
            </filter>
            <filter
                id="d8841908__filter1_i_19048_68"
                x={19.1207}
                y={104.879}
                width={72.5063}
                height={87.8129}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dx={-5.08831} dy={-5.08831} />
                <feGaussianBlur stdDeviation={4.85702} />
                <feComposite
                    in2="hardAlpha"
                    operator="arithmetic"
                    k2={-1}
                    k3={1}
                />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.95 0 0 0 0 0.639872 0 0 0 0 0.059375 0 0 0 1 0"
                />
                <feBlend
                    mode="normal"
                    in2="shape"
                    result="effect1_innerShadow_19048_68"
                />
            </filter>
            <linearGradient
                id="d8841908__paint0_linear_19048_68"
                x1={127.962}
                y1={129.28}
                x2={88.6078}
                y2={67.8331}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="d8841908__paint1_linear_19048_68"
                x1={144.056}
                y1={187.636}
                x2={58.6481}
                y2={87.2645}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.00339935} stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="d8841908__paint2_linear_19048_68"
                x1={76.3684}
                y1={115.85}
                x2={97.6868}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.130208} stopColor="#F74D30" />
                <stop offset={0.234375} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="d8841908__paint3_linear_19048_68"
                x1={92.3684}
                y1={115.85}
                x2={113.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.130208} stopColor="#F74D30" />
                <stop offset={0.234375} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="d8841908__paint4_linear_19048_68"
                x1={108.368}
                y1={115.85}
                x2={129.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.130208} stopColor="#F74D30" />
                <stop offset={0.234375} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="d8841908__paint5_linear_19048_68"
                x1={124.368}
                y1={115.85}
                x2={145.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.130208} stopColor="#F74D30" />
                <stop offset={0.234375} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="d8841908__paint6_linear_19048_68"
                x1={53.249}
                y1={109.479}
                x2={67.854}
                y2={109.101}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0908376} stopColor="#0065D9" />
                <stop offset={0.7003} stopColor="#027BF3" />
            </linearGradient>
            <linearGradient
                id="d8841908__paint7_linear_19048_68"
                x1={65.0007}
                y1={188}
                x2={21.5007}
                y2={121}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FAAC1A" />
                <stop offset={1} stopColor="#FFD34D" />
            </linearGradient>
            <linearGradient
                id="d8841908__paint8_linear_19048_68"
                x1={146}
                y1={175.361}
                x2={159.117}
                y2={173.254}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#292929" />
                <stop offset={0.432238} stopColor="#5B5B5B" />
                <stop offset={1} stopColor="#292929" />
            </linearGradient>
            <clipPath id="d8841908__clip0_19048_68">
                <rect width={220} height={220} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default SelfConnectL;
