import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SerpBudapestBadgeM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 72 60"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect width={72} height={58.8889} rx={8} fill="white" />
        <mask
            id="f834d0da__mask0_16290_135"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={72}
            height={60}
        >
            <rect width={72} height={60} rx={8} fill="white" />
        </mask>
        <g mask="url(#f834d0da__mask0_16290_135)">
            <path
                d="M64.4986 37.7145L53.1543 48.7734L63.6544 59.0093L74.9986 47.9505L64.4986 37.7145Z"
                fill="white"
            />
            <path
                d="M74.5751 58.5466C69.184 63.802 60.4434 63.802 55.0524 58.5466C49.6613 53.2911 49.6613 44.7704 55.0524 39.515C60.4434 34.2595 69.184 34.2595 74.5751 39.515C79.9661 44.7704 79.9661 53.2911 74.5751 58.5466ZM63.4944 56.4593C64.8925 56.4559 67.1778 55.0444 69.0876 53.1971C70.9825 51.3355 72.4305 49.1075 72.4339 47.7447C72.4425 44.3585 61.573 42.0138 59.5868 43.9311C57.6157 45.8715 60.0209 56.4676 63.4944 56.4593Z"
                fill="url(#f834d0da__paint0_linear_16290_135)"
            />
            <path
                d="M71.6581 -7.42233C69.2628 -9.71411 65.3792 -9.71411 62.9839 -7.42232L51.9504 3.1345C49.5551 5.42628 49.5551 9.14201 51.9504 11.4338L62.984 21.9907C65.3793 24.2825 69.2628 24.2825 71.6581 21.9907L82.6917 11.4338C85.087 9.14205 85.087 5.42631 82.6917 3.13452L71.6581 -7.42233Z"
                fill="#FFCC00"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M76.513 12.8322C74.9443 14.7363 72.7588 16.155 70.2458 16.7375C69.5311 16.9024 68.8008 16.9973 68.0661 17.0206C65.8709 17.0884 63.703 16.5403 61.8294 15.4439C59.3806 14.0079 57.676 11.7867 57.028 9.19016C56.4136 6.67155 56.8684 4.02259 58.2925 1.82435C59.6699 -0.299789 61.7918 -1.76788 64.2676 -2.30999C66.6658 -2.82176 69.1782 -2.40302 71.2543 -1.14554C73.2536 0.0647729 74.628 1.91268 75.1257 4.05669C75.3579 5.07876 75.3772 6.13462 75.1823 7.16381C74.9874 8.193 74.5823 9.1753 73.99 10.0545C72.8468 11.7492 71.1139 12.9017 69.1095 13.2999C68.1571 13.4845 67.176 13.4875 66.2224 13.3088C65.2688 13.1301 64.3615 12.7731 63.5523 12.2584C62.0038 11.2719 60.9617 9.79631 60.6172 8.10329C60.4577 7.30526 60.4655 6.48488 60.64 5.68974C60.8145 4.8946 61.1523 4.14054 61.6338 3.47131C62.5458 2.20809 63.8928 1.37494 65.4265 1.12467C66.1455 1.00985 66.8812 1.03336 67.5906 1.19382C68.3 1.35428 68.9689 1.64847 69.558 2.05919C70.6537 2.82607 71.3583 3.93356 71.542 5.17731C71.6263 5.75439 71.5876 6.34185 71.428 6.90418C71.2684 7.46651 70.9913 7.99205 70.6134 8.44905C70.2857 8.85215 69.8748 9.18642 69.4063 9.43107C68.9377 9.67573 68.4216 9.82554 67.89 9.87118C67.3971 9.90971 66.9013 9.85082 66.4332 9.69817C65.9652 9.54553 65.5349 9.30239 65.1693 8.98387C64.8603 8.71655 64.6139 8.3897 64.4463 8.02481C64.2787 7.65991 64.1936 7.26521 64.1967 6.86664C64.2047 6.11742 64.6033 5.35079 65.2115 4.91376C65.4559 4.73281 65.7412 4.60928 66.0446 4.55312C66.348 4.49696 66.6609 4.50975 66.9582 4.59044C67.0823 4.62289 67.1986 4.67846 67.3003 4.75396C67.4019 4.82946 67.487 4.9234 67.5507 5.03042C67.6144 5.13744 67.6554 5.25542 67.6713 5.37762C67.6873 5.49981 67.6779 5.62382 67.6437 5.74253C67.6094 5.86124 67.5511 5.97233 67.4719 6.06943C67.3928 6.16653 67.2944 6.24774 67.1824 6.30841C67.0704 6.36907 66.947 6.408 66.8192 6.42296C66.6915 6.43793 66.5619 6.42863 66.4379 6.39561C66.4236 6.39171 66.4156 6.39435 66.3901 6.41283C66.3198 6.47354 66.2629 6.54697 66.2224 6.62886C66.182 6.71075 66.1589 6.79949 66.1546 6.88995C66.1538 7.02668 66.1841 7.16194 66.2434 7.28634C66.3027 7.41074 66.3896 7.52131 66.498 7.61039C66.663 7.75085 66.8559 7.85811 67.0652 7.92578C67.2744 7.99346 67.4957 8.02016 67.716 8.00429C67.9831 7.98034 68.2422 7.90368 68.4768 7.77914C68.7114 7.65461 68.9165 7.48489 69.0791 7.28072C69.2906 7.02185 69.4459 6.72511 69.5357 6.40797C69.6255 6.09082 69.6481 5.7597 69.6022 5.43407C69.5442 5.06227 69.4082 4.70552 69.2024 4.38528C68.9966 4.06503 68.7253 3.78789 68.4048 3.57051C68.028 3.30718 67.6 3.11853 67.1459 3.01564C66.6918 2.91274 66.2208 2.89768 65.7606 2.97133C64.7492 3.13613 63.8566 3.69301 63.2465 4.53827C62.9123 5.00211 62.6777 5.52484 62.5563 6.07613C62.4349 6.62742 62.4291 7.19629 62.5393 7.74973C62.7826 8.94622 63.5269 9.994 64.6344 10.6995C65.2271 11.0772 65.8919 11.3392 66.5907 11.4706C67.2895 11.6019 68.0085 11.6 68.7065 11.4649C70.1953 11.1691 71.4869 10.3062 72.344 9.03535C72.7965 8.36454 73.1062 7.61494 73.2554 6.82947C73.4047 6.04399 73.3905 5.23806 73.2138 4.45782C72.8307 2.80502 71.7635 1.37691 70.2105 0.43649C68.5762 -0.55449 66.5981 -0.885493 64.7092 -0.484044C62.745 -0.0538657 61.0577 1.11762 59.9575 2.81462C58.8069 4.58829 58.4385 6.72617 58.9331 8.75937C59.4586 10.867 60.85 12.6735 62.8499 13.8469C64.9277 15.0657 67.4537 15.4557 69.7801 14.9162C71.8683 14.432 73.6843 13.25 74.9879 11.6628C76.3378 10.027 77.0879 8.01189 77.1226 5.92798C78.4278 5.95337 79.0804 5.96609 79.0805 5.96613C79.0359 8.46247 78.1336 10.8753 76.513 12.8322Z"
                fill="black"
            />
            <ellipse
                cx={5.80658}
                cy={9.99935}
                rx={13.9355}
                ry={13.3333}
                fill="#FFCC00"
            />
            <path
                d="M0.152027 14.7205L11.6628 4.52807L13.5813 5.02377L2.07057 15.2162L0.152027 14.7205ZM7.21426 6.71591C6.92963 7.72438 6.47371 8.43937 5.84649 8.86086C5.23111 9.28542 4.52076 9.39367 3.71545 9.18559C2.91014 8.97752 2.34258 8.55734 2.01278 7.92504C1.68618 7.28142 1.66679 6.4497 1.95461 5.4299C2.24564 4.39877 2.70316 3.67812 3.32718 3.26795C3.95441 2.84645 4.67067 2.73974 5.47599 2.94781C6.2813 3.15588 6.84134 3.5802 7.1561 4.22077C7.4859 4.85307 7.50529 5.68478 7.21426 6.71591ZM3.81169 5.87325C3.6326 6.50779 3.57141 6.9722 3.62813 7.26647C3.68804 7.54942 3.84827 7.72455 4.10881 7.79187C4.36935 7.85918 4.59994 7.78503 4.80057 7.5694C5.0044 7.34245 5.19586 6.9117 5.37495 6.27715C5.55724 5.63128 5.61843 5.16687 5.55851 4.88393C5.51044 4.60404 5.35021 4.42891 5.07783 4.35854C4.80544 4.28816 4.56893 4.36078 4.36831 4.57641C4.17952 4.7951 3.99398 5.22738 3.81169 5.87325ZM11.7418 14.3778C11.4571 15.3862 11.0012 16.1012 10.374 16.5227C9.7586 16.9473 9.04825 17.0555 8.24294 16.8474C7.44947 16.6424 6.88351 16.2166 6.54507 15.5699C6.21846 14.9263 6.19748 14.1002 6.4821 13.0917C6.77313 12.0606 7.23065 11.34 7.85467 10.9298C8.49374 10.5114 9.21001 10.4046 10.0035 10.6097C10.8088 10.8177 11.3688 11.242 11.6836 11.8826C12.0134 12.5149 12.0328 13.3466 11.7418 14.3778ZM8.33918 13.5351C8.16009 14.1696 8.1005 14.6284 8.16041 14.9113C8.23217 15.1973 8.3924 15.3725 8.6411 15.4367C8.91349 15.5071 9.14999 15.4345 9.35062 15.2188C9.55125 15.0032 9.74111 14.5781 9.9202 13.9436C10.0993 13.309 10.1589 12.8503 10.099 12.5674C10.0423 12.2731 9.8777 12.0908 9.60532 12.0204C9.34477 11.9531 9.11259 12.0329 8.90876 12.2598C8.70813 12.4755 8.51827 12.9006 8.33918 13.5351Z"
                fill="black"
            />
            <g clipPath="url(#f834d0da__clip0_16290_135)">
                <path
                    d="M4.61107 32.2219L-15.0967 51.0781L4.61107 69.9343L24.3188 51.0781L4.61107 32.2219Z"
                    fill="url(#f834d0da__paint1_linear_16290_135)"
                />
                <g filter="url(#f834d0da__filter0_d_16290_135)">
                    <path
                        d="M9.32294 60.746C7.32429 61.6372 5.09433 61.9412 2.91507 61.6197C0.735806 61.2983 -1.29488 60.3657 -2.92017 58.9399C-4.54546 57.5142 -5.69236 55.6593 -6.21582 53.6099C-6.73928 51.5604 -6.6158 49.4085 -5.86099 47.4263C-5.10617 45.444 -3.75393 43.7204 -1.97527 42.4735C-0.196613 41.2265 1.92857 40.5122 4.13152 40.421C6.33447 40.3297 8.51623 40.8655 10.4009 41.9606C12.2856 43.0558 13.7885 44.6611 14.7196 46.5735C15.968 49.1376 16.1008 52.0712 15.0887 54.729C14.0767 57.3868 12.0027 59.5512 9.32294 60.746ZM0.23438 51.5599C0.734735 51.3381 1.15509 50.9793 1.44225 50.5289C1.72941 50.0785 1.87047 49.5567 1.84758 49.0296C1.8247 48.5024 1.63889 47.9936 1.31367 47.5675C0.988449 47.1414 0.53844 46.8172 0.0205853 46.636C-0.497269 46.4547 -1.0597 46.4244 -1.59552 46.5491C-2.13134 46.6737 -2.61648 46.9476 -2.98955 47.3361C-3.36261 47.7247 -3.60684 48.2104 -3.69131 48.7317C-3.77578 49.2531 -3.69671 49.7867 -3.46411 50.2651C-3.15264 50.9057 -2.58823 51.4018 -1.89481 51.6445C-1.20138 51.8873 -0.43561 51.8569 0.23438 51.5599ZM7.81201 48.1794C8.31158 47.9565 8.73084 47.5968 9.01677 47.1459C9.30269 46.695 9.44245 46.1731 9.41836 45.6461C9.39427 45.1192 9.20741 44.611 8.88143 44.1857C8.55544 43.7604 8.10496 43.4371 7.58695 43.2568C7.06895 43.0764 6.50668 43.0471 5.97125 43.1725C5.43582 43.2979 4.95129 43.5724 4.57891 43.9613C4.20653 44.3502 3.96304 44.8359 3.87923 45.3572C3.79542 45.8785 3.87505 46.4119 4.10805 46.8899C4.26276 47.2072 4.48128 47.4923 4.75115 47.7289C5.02102 47.9655 5.33695 48.1489 5.68089 48.2686C6.02484 48.3884 6.39007 48.4421 6.75572 48.4268C7.12138 48.4115 7.48031 48.3274 7.81201 48.1794ZM11.3474 55.4275C11.8469 55.2046 12.2662 54.8449 12.5521 54.394C12.838 53.9431 12.9778 53.4212 12.9537 52.8943C12.9296 52.3673 12.7428 51.8591 12.4168 51.4338C12.0908 51.0085 11.6403 50.6852 11.1223 50.5049C10.6043 50.3245 10.042 50.2952 9.5066 50.4206C8.97117 50.546 8.48664 50.8205 8.11426 51.2094C7.74188 51.5983 7.49839 52.0841 7.41458 52.6053C7.33077 53.1266 7.4104 53.66 7.6434 54.138C7.79811 54.4553 8.01664 54.7404 8.28651 54.977C8.55637 55.2136 8.8723 55.397 9.21624 55.5167C9.56019 55.6365 9.92542 55.6902 10.2911 55.6749C10.6567 55.6596 11.0157 55.5755 11.3474 55.4275ZM3.76754 58.8101C4.26735 58.5873 4.68685 58.2276 4.97296 57.7766C5.25907 57.3256 5.39893 56.8036 5.37485 56.2765C5.35077 55.7494 5.16382 55.241 4.83766 54.8156C4.51151 54.3902 4.0608 54.067 3.54257 53.8867C3.02434 53.7065 2.46188 53.6774 1.92636 53.8031C1.39083 53.9288 0.906315 54.2036 0.534104 54.5929C0.161892 54.9821 -0.0812803 55.4683 -0.164646 55.9898C-0.248011 56.5113 -0.167825 57.0448 0.0657702 57.5227C0.378625 58.1627 0.944188 58.6578 1.63825 58.8992C2.33232 59.1406 3.09814 59.1085 3.76754 58.8101ZM5.20073 52.2869C5.45046 52.1754 5.66003 51.9956 5.80295 51.7701C5.94586 51.5447 6.01571 51.2838 6.00367 51.0204C5.99162 50.757 5.89822 50.5029 5.73527 50.2902C5.57231 50.0776 5.34713 49.916 5.08818 49.8258C4.82924 49.7356 4.54815 49.7209 4.28046 49.7835C4.01277 49.8461 3.7705 49.9833 3.58427 50.1776C3.39804 50.372 3.27621 50.6148 3.2342 50.8754C3.19218 51.1359 3.23185 51.4026 3.34821 51.6416C3.42551 51.8004 3.53476 51.9431 3.66971 52.0615C3.80467 52.1798 3.96268 52.2716 4.13472 52.3315C4.30676 52.3915 4.48946 52.4184 4.67237 52.4107C4.85528 52.4031 5.03482 52.361 5.20073 52.2869Z"
                        fill="black"
                    />
                </g>
                <path
                    d="M9.32294 60.746C7.32429 61.6372 5.09433 61.9412 2.91507 61.6197C0.735806 61.2983 -1.29488 60.3657 -2.92017 58.9399C-4.54546 57.5142 -5.69236 55.6593 -6.21582 53.6099C-6.73928 51.5604 -6.6158 49.4085 -5.86099 47.4263C-5.10617 45.444 -3.75393 43.7204 -1.97527 42.4735C-0.196613 41.2265 1.92857 40.5122 4.13152 40.421C6.33447 40.3297 8.51623 40.8655 10.4009 41.9606C12.2856 43.0558 13.7885 44.6611 14.7196 46.5735C15.968 49.1376 16.1008 52.0712 15.0887 54.729C14.0767 57.3868 12.0027 59.5512 9.32294 60.746ZM0.23438 51.5599C0.734735 51.3381 1.15509 50.9793 1.44225 50.5289C1.72941 50.0785 1.87047 49.5567 1.84758 49.0296C1.8247 48.5024 1.63889 47.9936 1.31367 47.5675C0.988449 47.1414 0.53844 46.8172 0.0205853 46.636C-0.497269 46.4547 -1.0597 46.4244 -1.59552 46.5491C-2.13134 46.6737 -2.61648 46.9476 -2.98955 47.3361C-3.36261 47.7247 -3.60684 48.2104 -3.69131 48.7317C-3.77578 49.2531 -3.69671 49.7867 -3.46411 50.2651C-3.15264 50.9057 -2.58823 51.4018 -1.89481 51.6445C-1.20138 51.8873 -0.43561 51.8569 0.23438 51.5599ZM7.81201 48.1794C8.31158 47.9565 8.73084 47.5968 9.01677 47.1459C9.30269 46.695 9.44245 46.1731 9.41836 45.6461C9.39427 45.1192 9.20741 44.611 8.88143 44.1857C8.55544 43.7604 8.10496 43.4371 7.58695 43.2568C7.06895 43.0764 6.50668 43.0471 5.97125 43.1725C5.43582 43.2979 4.95129 43.5724 4.57891 43.9613C4.20653 44.3502 3.96304 44.8359 3.87923 45.3572C3.79542 45.8785 3.87505 46.4119 4.10805 46.8899C4.26276 47.2072 4.48128 47.4923 4.75115 47.7289C5.02102 47.9655 5.33695 48.1489 5.68089 48.2686C6.02484 48.3884 6.39007 48.4421 6.75572 48.4268C7.12138 48.4115 7.48031 48.3274 7.81201 48.1794ZM11.3474 55.4275C11.8469 55.2046 12.2662 54.8449 12.5521 54.394C12.838 53.9431 12.9778 53.4212 12.9537 52.8943C12.9296 52.3673 12.7428 51.8591 12.4168 51.4338C12.0908 51.0085 11.6403 50.6852 11.1223 50.5049C10.6043 50.3245 10.042 50.2952 9.5066 50.4206C8.97117 50.546 8.48664 50.8205 8.11426 51.2094C7.74188 51.5983 7.49839 52.0841 7.41458 52.6053C7.33077 53.1266 7.4104 53.66 7.6434 54.138C7.79811 54.4553 8.01664 54.7404 8.28651 54.977C8.55637 55.2136 8.8723 55.397 9.21624 55.5167C9.56019 55.6365 9.92542 55.6902 10.2911 55.6749C10.6567 55.6596 11.0157 55.5755 11.3474 55.4275ZM3.76754 58.8101C4.26735 58.5873 4.68685 58.2276 4.97296 57.7766C5.25907 57.3256 5.39893 56.8036 5.37485 56.2765C5.35077 55.7494 5.16382 55.241 4.83766 54.8156C4.51151 54.3902 4.0608 54.067 3.54257 53.8867C3.02434 53.7065 2.46188 53.6774 1.92636 53.8031C1.39083 53.9288 0.906315 54.2036 0.534104 54.5929C0.161892 54.9821 -0.0812803 55.4683 -0.164646 55.9898C-0.248011 56.5113 -0.167825 57.0448 0.0657702 57.5227C0.378625 58.1627 0.944188 58.6578 1.63825 58.8992C2.33232 59.1406 3.09814 59.1085 3.76754 58.8101ZM5.20073 52.2869C5.45046 52.1754 5.66003 51.9956 5.80295 51.7701C5.94586 51.5447 6.01571 51.2838 6.00367 51.0204C5.99162 50.757 5.89822 50.5029 5.73527 50.2902C5.57231 50.0776 5.34713 49.916 5.08818 49.8258C4.82924 49.7356 4.54815 49.7209 4.28046 49.7835C4.01277 49.8461 3.7705 49.9833 3.58427 50.1776C3.39804 50.372 3.27621 50.6148 3.2342 50.8754C3.19218 51.1359 3.23185 51.4026 3.34821 51.6416C3.42551 51.8004 3.53476 51.9431 3.66971 52.0615C3.80467 52.1798 3.96268 52.2716 4.13472 52.3315C4.30676 52.3915 4.48946 52.4184 4.67237 52.4107C4.85528 52.4031 5.03482 52.361 5.20073 52.2869Z"
                    fill="white"
                />
            </g>
        </g>
        <g clipPath="url(#f834d0da__clip1_16290_135)">
            <path
                d="M30.7291 34.1844C23.3546 27.8312 22.4687 24.3466 22.607 22.5752C22.4707 24.2837 22.5914 26.4872 22.751 29.4009C23.0745 35.3065 23.2364 38.2619 25.2526 40.0039C27.274 41.7403 30.3629 41.5854 36.5353 41.276C39.5805 41.1232 41.8835 41.0078 43.6451 40.6995C41.8183 41.0163 38.1037 40.5375 30.7291 34.1844Z"
                fill="url(#f834d0da__paint2_linear_16290_135)"
            />
            <path
                d="M46.4446 17.4844C44.4232 15.748 41.3343 15.9029 35.162 16.2124C28.9896 16.5219 25.9007 16.6768 24.0801 18.6059C23.1651 19.5837 22.7515 20.8245 22.6066 22.5753C22.4683 24.3467 23.3369 27.8165 30.7287 34.1845C38.1205 40.5525 41.8181 41.0215 43.6447 40.6996C45.4497 40.384 46.6962 39.8607 47.6167 38.8825C49.4315 36.9485 49.2696 33.993 48.9462 28.0874C48.6227 22.1818 48.4608 19.2264 46.4446 17.4844Z"
                fill="url(#f834d0da__paint3_linear_16290_135)"
            />
            <path
                d="M39.8123 38.0695C39.7953 37.9604 39.7784 37.8513 39.7612 37.7369C38.9387 32.4114 38.53 29.7458 36.5259 28.0242C34.5269 26.2971 31.7135 26.1869 26.0919 25.9609C25.9767 25.9562 25.8561 25.9517 25.7409 25.947C23.8926 25.8721 22.468 24.3414 22.6066 22.5752C22.5401 22.9607 22.5131 23.3653 22.5833 23.7492C22.7296 24.6215 23.0454 25.4905 23.3991 26.1534C24.3933 28.02 26.4271 30.981 30.465 34.4646C34.5026 37.943 37.7984 39.5684 39.837 40.3197C40.5631 40.587 41.4994 40.7966 42.4214 40.8446C42.8278 40.8713 43.2452 40.798 43.6392 40.6997C41.8233 41.016 40.0833 39.8204 39.8123 38.0695Z"
                fill="url(#f834d0da__paint4_linear_16290_135)"
            />
        </g>
        <defs>
            <filter
                id="f834d0da__filter0_d_16290_135"
                x={-16.5342}
                y={32.4111}
                width={42.2969}
                height={41.333}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={2} />
                <feGaussianBlur stdDeviation={5} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_16290_135"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_16290_135"
                    result="shape"
                />
            </filter>
            <linearGradient
                id="f834d0da__paint0_linear_16290_135"
                x1={64.8137}
                y1={68.0623}
                x2={64.8137}
                y2={29.9992}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C926FF" />
                <stop offset={1} stopColor="#4A26FF" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint1_linear_16290_135"
                x1={10.9394}
                y1={63.8794}
                x2={-0.786809}
                y2={37.8357}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6600" />
                <stop offset={1} stopColor="#FF9900" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint2_linear_16290_135"
                x1={23.4375}
                y1={41.9327}
                x2={41.6698}
                y2={20.7734}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00E6E6" />
                <stop offset={0.494792} stopColor="#0059B3" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint3_linear_16290_135"
                x1={23.6186}
                y1={41.7411}
                x2={50.0288}
                y2={17.4815}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00BFFF" />
                <stop offset={1} stopColor="#80FFEA" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint4_linear_16290_135"
                x1={30.9291}
                y1={34.3038}
                x2={35.9036}
                y2={29.1041}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E6FBFF" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <clipPath id="f834d0da__clip0_16290_135">
                <rect
                    width={27.2642}
                    height={27.2642}
                    rx={6}
                    transform="matrix(0.722843 -0.691609 0.722843 0.691609 -15.0967 51.0781)"
                    fill="white"
                />
            </clipPath>
            <clipPath id="f834d0da__clip1_16290_135">
                <rect
                    width={27.871}
                    height={26.6667}
                    fill="white"
                    transform="translate(22.0645 15.5557)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default SerpBudapestBadgeM;
