import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TicketCatL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 210 210"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M90.0712 30.621V22.6589L92.0617 19.9053L96.1672 21.547L101.766 26.8721L105.995 26.2749L111.967 24.8816H119.431L122.666 23.8863L130.628 24.8816L138.093 25.2668L140.456 25.8768L144.313 22.6589L147.672 19.9053H149.538L151.28 21.8958L152.151 27.8674V32.8437L153.643 36.3721L155.883 39.8105L157.5 43.7915L159.366 47.7726L161.108 52.1517L162.103 57.7252V63.6967L160.361 69.6683L155.883 75.6399L171.309 126.398V131.374L168.946 134.659L165.338 135.356L163.72 140.332L159.366 146.303L160.361 150.284C160.361 150.284 159.491 152.276 158.495 153.64C157.5 155.004 154.639 158.247 154.639 158.247V163.593V167.574L153.643 176.161V180.142L154.639 182.973L151.28 186.484H146.552L142.82 186.114C142.82 186.114 140.456 185.983 140.456 184.886C140.456 183.789 138.839 182.133 138.839 182.133V171.185V162.228L122.666 163.223L101.766 162.228L99.6506 173.175L97.5357 184.886L94.6743 186.484H86.7122L84.7217 181.137V172.18L90.0712 30.621Z"
            fill="white"
        />
        <path
            d="M60.3377 25.8768L66.1849 23.8862L72.2808 25.2668L75.391 27.1267L76.3863 32.4483L74.1469 36.8246L70.1659 38.8151H64.9408C64.9408 38.8151 60.3377 37.3222 60.3377 37.0734C60.3377 36.8246 57.8495 34.4652 57.8495 34.152C57.8495 33.8388 56.6055 31.3507 56.6055 31.3507L57.2275 27.8673L58.7204 26.872L60.3377 25.8768Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M154.034 180.818C154.097 184.214 153.445 186.447 146.667 186C139.373 184.76 139.168 182.856 139.318 178.836C137.749 178.703 136.128 178.584 134.454 178.48C129.573 178.177 124.279 177.86 118.746 177.86C112.307 177.86 107.284 178.196 100.672 178.34C100.056 178.353 99.4503 178.373 98.8497 178.397C98.995 183.419 100.22 187.307 88.833 186.501C86.114 186.748 84.862 184.427 84.1923 180.153C78.186 181.496 74.5977 183.371 74.5977 185.067C74.5977 187.721 83.3543 190.705 96.468 191.14C104.285 191.4 110.62 192.274 118.746 192.274C125.425 192.274 131.75 191.642 137.433 191.448C153.217 190.91 162.895 187.957 162.895 185.067C162.895 183.441 159.596 181.984 154.034 180.818Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.556 35.1113H75.135C73.665 37.4083 70.4757 39.0003 66.776 39.0003C63.0763 39.0003 59.887 37.4083 58.417 35.1113C52.083 35.1113 47.1113 35.1113 47.1113 35.1113C43.0003 35.1113 41.667 37.778 41.667 41.3337C41.667 44.8893 42.637 52.3417 43.3337 57.1113C44.1653 62.8053 46.0003 63.0003 50.3337 63.0003C54.667 63.0003 82.3337 63.1113 86.1113 63.1113C89.889 63.1113 90.778 59.4447 91.1113 55.778C91.4447 52.1113 91.3337 45.0003 91.5557 40.3337C91.7777 35.667 88.2227 35.1113 84.556 35.1113Z"
            fill="#7DC9F0"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M91.556 86.1351C91.3337 81.4684 91.445 74.3574 91.1117 70.6908C90.7783 67.0241 89.8893 63.3574 86.1117 63.3574C82.3337 63.3574 54.667 63.4684 50.3337 63.4684C46.0003 63.4684 44.1653 63.6634 43.3337 69.3574C42.637 74.1271 41.667 81.5794 41.667 85.1351C41.667 88.6908 43.0003 91.3574 47.1113 91.3574C47.1113 91.3574 80.889 91.3574 84.5557 91.3574C88.2223 91.3574 91.778 90.8018 91.556 86.1351Z"
            fill="#F8CA45"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.5557 91.5176C80.889 91.5176 47.1113 91.5176 47.1113 91.5176C43.0003 91.5176 41.667 94.1842 41.667 97.7399C41.667 101.296 42.637 108.748 43.3337 113.518C44.1653 119.212 46.0003 119.407 50.3337 119.407C54.667 119.407 82.3337 119.518 86.1113 119.518C89.889 119.518 90.778 115.851 91.1113 112.184C91.4447 108.518 91.3337 101.407 91.5557 96.7399C91.7777 92.0732 88.2223 91.5176 84.5557 91.5176Z"
            fill="#6FCC62"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M91.1975 142.802C90.9752 138.135 90.5865 131.024 90.2532 127.358C89.9199 123.691 89.0315 120.024 85.2555 120.024C81.4795 120.024 53.8269 120.135 49.4955 120.135C45.1642 120.135 43.3302 120.33 42.4992 126.024C41.8029 130.794 41.8332 138.246 41.8332 141.802C41.8332 145.358 43.1659 148.024 47.2749 148.024C47.2749 148.024 80.5359 148.024 84.2005 148.024C87.8659 148.024 91.4195 147.469 91.1975 142.802Z"
            fill="#DD89CE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M159.667 84.3335C159.667 84.3335 161 75.3335 156.333 76.0001C156.333 76.0001 145.333 86.3335 123 86.3335C100.667 86.3335 96.3333 82.3335 96.3333 82.3335C96.3333 82.3335 97.6667 87.6668 94.3333 91.3335L91 93.6668C91 93.6668 91.6667 95.6668 91.3333 101C91 106.333 91 109.667 90.6667 113.333C90.3333 117 86 119.667 86 119.667C86 119.667 88.6667 120.667 90 124.333C91.3333 128 91.3333 142.333 91.3333 142.333C91.3333 142.333 91.6333 143.13 90.6667 146.667C108 152.333 156 149.333 164 144.333V129.333C164 129.333 174.667 126.333 176.333 110.667C178 95.0001 159.667 84.3335 159.667 84.3335Z"
            fill="#F0ECD8"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M151.001 88.6667C151.001 88.6667 151.451 82.8673 150.668 80L141.668 84L142.335 91C144.495 119.094 141.668 148.333 141.668 148.333L151.668 147C156.521 110.114 151.001 88.6667 151.001 88.6667ZM131.334 85.6665L120.667 86.3332V94.3332C119.641 131.254 119.334 149.333 119.334 149.333L130.667 148.667C131.907 123.618 131.667 92.9998 131.667 92.9998C131.667 92.9998 131.776 90.1402 131.334 85.6665ZM99.6674 84C99.6674 84 101.211 85.5643 109.334 86.6667C109.001 91.3333 110.001 94.6667 110.001 94.6667C110.001 94.6667 109.507 129.331 110.001 148.333C110.001 148.333 103.334 150 98.3341 148C98.3341 148 97.3341 122 100.001 93.3333L99.6674 84Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M170 94.8333C164.667 88.6667 159.334 84.5 159.334 84.5L159.167 91.5C166.086 104.861 164.5 129.667 164.5 129.667C164.5 129.667 171.834 125.5 174.667 115.833C177.5 106.167 175.334 101 170 94.8333Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M156.666 76.3331C161.333 75.6665 160 89.6665 160 89.6665C147.666 100.666 108.928 101.249 92.7041 93.6878C94.4424 90.1688 96.3331 82.6665 96.3331 82.6665C137.666 93.3331 156.666 76.3331 156.666 76.3331ZM91.6667 136C91.6667 136 116.528 142.913 163 134.666L163.667 144.666C163.667 144.666 147.333 153.666 90 147.333C92.0753 144.627 91.6667 136 91.6667 136Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.3673 148.021C80.7023 148.021 47.4417 148.021 47.4417 148.021C43.3327 148.021 42 150.767 42 154.428C42 158.089 42.636 165.262 43.3327 170.172C44.164 176.035 45.998 176.236 50.329 176.236C54.6603 176.236 81.6463 176.35 85.4223 176.35C89.1983 176.35 90.0867 172.575 90.4197 168.8C90.753 165.025 91.142 158.203 91.364 153.398C91.5857 148.594 88.032 148.021 84.3673 148.021Z"
            fill="#FF815E"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M128.523 23.5321C130.704 27.0321 132.246 36.5661 126.518 36.8335C121.728 37.0569 120.701 32.6779 119.543 27.7358C119.267 26.5599 118.984 25.3521 118.641 24.1668C121.193 22.8448 128.523 23.5321 128.523 23.5321ZM104.715 27.074C104.809 27.4065 104.902 27.7384 104.994 28.0679C106.205 32.4133 107.296 36.3264 110.905 35.3727C114.935 34.3084 114.729 29.017 113.091 24.8224C109.48 26.0004 104.715 27.074 104.715 27.074ZM134.515 27.531L134.515 27.5311C135.216 30.4151 136.016 33.7065 138.969 33.9548C142.88 34.2838 142.201 28.9214 140.439 25.3968C137.629 25.4314 133.902 25.2734 133.902 25.2734C134.129 25.9428 134.318 26.7208 134.515 27.531L134.515 27.531L134.515 27.531ZM131.975 57.0435C129.116 57.4815 124.18 57.3122 121.554 57.1439L121.33 57.1294C118.793 56.9648 116.508 56.8164 115.563 59.1009C114.935 60.6195 114.783 69.2815 126.562 69.5525C138.842 69.8352 139.075 59.2915 137.544 57.6782C136.259 56.3237 134.412 56.6357 132.656 56.932C132.427 56.9707 132.2 57.0091 131.975 57.0435ZM153.066 56.9155C151.838 51.8499 155.221 49.3572 160.27 49.8152C162.784 54.4638 162.924 61.46 162.927 61.6204L162.927 61.6232C159.893 61.8889 154.352 62.2189 153.066 56.9155Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M152.446 147.676C153.696 150.032 157.311 151.873 160.02 150.372L160.897 146.104C158.478 146.348 152.446 147.676 152.446 147.676ZM104.666 149.667C104.666 149.667 114.489 149.671 125.666 149.833C137.967 150.012 143.434 149.312 143.434 149.312C139.531 156.258 113.157 159.724 104.666 149.667ZM152.824 154.621C149.47 155.448 147.505 157.704 147.691 159.52C147.878 161.337 151.965 163.516 154.516 162.103L154.04 159.699L157.562 153.902L157.561 153.902C157.511 153.899 156.117 153.811 152.824 154.621ZM147.377 171.621C147.501 176.047 153.173 174.969 153.173 174.969C153.173 174.969 155.052 170.962 154.485 166.956C150.934 167.737 147.295 168.658 147.377 171.621ZM91.0869 163.937L91.2782 156.455C94.6322 157.281 96.0976 159.537 95.9112 161.354C95.7249 163.171 93.6372 165.349 91.0869 163.937ZM90.2684 169.694C90.2684 169.694 91.0884 172.327 87.4297 176.969C87.4297 176.969 93.009 179.358 93.3917 173.621C93.533 171.498 92.199 170.42 90.2684 169.694ZM98.1557 148.676C97.8471 152.619 93.7917 153.706 91.0824 152.206L89.7051 147.104C92.1247 147.348 98.1557 148.676 98.1557 148.676Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M92.778 63.3333C92.778 63.3333 95.1113 67.111 95.4447 70.889C95.778 74.6667 96.2227 88 96.2227 88C96.2227 88 96.3787 93.1907 91.1117 93.889L88.2227 91C88.2227 91 91.4447 91 91.6667 86.889C91.889 82.7777 91 73.3333 90.5557 69.5557C90.1113 65.7777 88.5557 64.2223 87.1113 63.3333C87.1113 63.3333 89.5557 63.111 90.1113 58.5557C90.667 54 91.667 39.5557 91.667 39.5557C91.667 39.5557 91.0003 36.111 87.3337 35.6667C83.667 35.2223 75.667 35 75.667 35L76.778 30.4443C76.778 30.4443 84.556 30.5557 88.667 31C92.778 31.4443 95.5557 33.2223 96.1113 37C96.667 40.7777 95.0003 57 95.0003 57C95.0003 57 93.889 61 92.778 63.3333ZM44.251 31.006C44.2783 31.004 44.3058 31.002 44.3334 30.9999C47.3334 30.7776 56.5557 30.8889 56.5557 30.8889L57.8891 35.4443C57.8891 35.4443 50.6667 35.3333 47.0001 35.3333C43.3334 35.3333 41.7777 37.2223 41.5554 40.7776C41.3334 44.3333 42.2221 54.4443 43.1111 58.1109C44.0001 61.7776 46.4444 62.7776 46.4444 62.7776C46.4444 62.7776 43.6667 65.6666 43.3334 68.7776C43.0001 71.8889 41.6667 85.2223 41.6667 85.2223C41.6667 85.2223 43.2224 90.5556 45.5557 91.3333L42.1111 93.7776C39.3331 92.8889 36.9997 90.9999 36.8887 86.4443C36.7777 81.8889 37.3334 72.4443 38.7777 67.7776C40.2224 63.1109 40.6667 62.9999 40.6667 62.9999C40.6667 62.9999 38.3334 58.1109 37.8891 52.4443C37.8235 51.6086 37.7435 50.7005 37.6597 49.7491C37.175 44.2488 36.5628 37.3025 37.8891 34.5556C39.4301 31.3629 41.2987 31.2246 44.251 31.006Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M74.4929 33.2293C73.7555 32.6346 72.6025 32.841 71.9172 33.6906C71.2319 34.54 71.2742 35.711 72.0115 36.3056C72.7485 36.9003 73.9019 36.6936 74.5872 35.8443C75.2722 34.9946 75.2299 33.8243 74.4929 33.2293ZM67.3401 35.4269C66.1475 35.4609 65.1961 36.2555 65.2151 37.2029C65.2345 38.1502 66.2165 38.8905 67.4091 38.8569C68.6018 38.8232 69.5531 38.0282 69.5341 37.0809C69.5151 36.1339 68.5331 35.3935 67.3401 35.4269ZM59.1291 33.9277C59.6281 33.1641 60.8164 33.0487 61.7831 33.6694C62.7497 34.2901 63.1287 35.4127 62.6297 36.1764C62.1307 36.9401 60.9424 37.0557 59.9757 36.4347C59.0091 35.8137 58.6301 34.6914 59.1291 33.9277Z"
            fill="#F0ABA7"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M75.2932 47.0556C72.9788 47.077 70.9308 47.108 69.8408 47.151C69.1972 47.176 68.6548 46.6743 68.6298 46.0306C68.6042 45.3866 69.1058 44.8443 69.7498 44.819C70.8988 44.7746 72.9455 44.744 75.2718 44.7226C77.5958 44.7013 80.1912 44.6886 82.4049 44.6816C83.0492 44.6796 83.5728 45.2003 83.5752 45.8446C83.5772 46.489 83.0565 47.0126 82.4118 47.015C80.2018 47.0216 77.6098 47.0346 75.2932 47.0556ZM82.7381 50.6816C83.3825 50.6796 83.9065 51.2003 83.9085 51.8446C83.9105 52.489 83.3898 53.0126 82.7451 53.015C80.5351 53.0216 77.9431 53.0346 75.6268 53.0556C73.3121 53.077 71.2641 53.108 70.1741 53.1506V53.151C69.5305 53.1763 68.9878 52.6746 68.9628 52.0306C68.9375 51.3866 69.4391 50.8443 70.0831 50.819C71.2325 50.7746 73.2788 50.744 75.6051 50.7226C77.9291 50.7013 80.5248 50.6886 82.7381 50.6816ZM49.1735 72.484C50.2635 72.441 52.3115 72.41 54.6262 72.3887C56.9425 72.3677 59.5345 72.3547 61.7445 72.348C62.3892 72.346 62.9095 71.822 62.9075 71.1777C62.9055 70.5333 62.3815 70.0127 61.7372 70.0147C59.5235 70.0217 56.9282 70.0343 54.6042 70.0557C52.2779 70.077 50.2315 70.1077 49.0822 70.152C48.4382 70.1773 47.9365 70.7197 47.9619 71.3637C47.9872 72.0077 48.5295 72.509 49.1735 72.484ZM54.6262 78.3887C52.3115 78.41 50.2635 78.441 49.1735 78.484C48.5295 78.509 47.9872 78.0077 47.9619 77.3637C47.9365 76.7197 48.4382 76.1773 49.0822 76.152C50.2315 76.1077 52.2779 76.077 54.6042 76.0557C56.9282 76.0343 59.5235 76.0217 61.7372 76.0147C62.3815 76.0127 62.9055 76.5333 62.9075 77.1777C62.9095 77.822 62.3892 78.346 61.7445 78.348C59.5345 78.3547 56.9425 78.3677 54.6262 78.3887ZM48.8405 85.1509C49.9588 85.1069 50.7478 85.0792 51.8128 85.0606C52.8775 85.0416 54.2212 85.0316 56.4308 85.0249C57.0755 85.0229 57.5958 84.4989 57.5938 83.8546C57.5918 83.2099 57.0678 82.6896 56.4235 82.6916C54.2095 82.6986 52.8568 82.7086 51.7712 82.7276C50.6855 82.7466 49.8702 82.7756 48.7492 82.8189C48.1052 82.8442 47.6035 83.3866 47.6288 84.0306C47.6542 84.6742 48.1965 85.1759 48.8405 85.1509ZM75.6054 98.3882C77.9298 98.3672 80.5248 98.3552 82.7381 98.3482C83.3824 98.3462 83.9064 98.8669 83.9084 99.5112C83.9104 100.156 83.3901 100.68 82.7454 100.682C80.5354 100.688 77.9434 100.7 75.6264 100.721C73.3121 100.742 71.2641 100.772 70.1731 100.814C69.5291 100.838 68.9874 100.336 68.9628 99.6922C68.9381 99.0485 69.4401 98.5065 70.0841 98.4822C71.2324 98.4385 73.2791 98.4092 75.6054 98.3882ZM83.9084 105.354C83.9068 104.71 83.3824 104.189 82.7381 104.191C80.5248 104.198 77.9298 104.21 75.6054 104.231C73.2791 104.252 71.2324 104.282 70.0841 104.325C69.4401 104.35 68.9381 104.892 68.9628 105.536C68.9874 106.179 69.5291 106.682 70.1731 106.657C71.2641 106.615 73.3121 106.585 75.6264 106.564C77.9434 106.543 80.5351 106.531 82.7454 106.525C83.3894 106.522 83.9104 105.998 83.9084 105.354ZM70.2504 110.33C71.3718 110.288 72.1864 110.26 73.2721 110.241C74.3574 110.222 75.7101 110.213 77.9238 110.206C78.5681 110.204 79.0921 110.725 79.0941 111.369C79.0961 112.013 78.5751 112.537 77.9308 112.539C75.7211 112.546 74.3774 112.555 73.3118 112.574C72.2471 112.592 71.4571 112.619 70.3388 112.662C69.6951 112.686 69.1534 112.184 69.1288 111.54C69.1044 110.896 69.6068 110.355 70.2504 110.33ZM50.6739 132.317C51.7639 132.275 53.8119 132.244 56.1262 132.222C58.4429 132.201 61.0349 132.188 63.2449 132.182C63.8896 132.18 64.4102 131.656 64.4082 131.011C64.4062 130.367 63.8822 129.846 63.2379 129.848C61.0242 129.855 58.4289 129.868 56.1049 129.889C53.7786 129.911 51.7319 129.941 50.5829 129.986C49.9389 130.011 49.4372 130.553 49.4629 131.197C49.4879 131.841 50.0302 132.343 50.6739 132.317ZM56.4379 135.889C58.7619 135.868 61.3575 135.856 63.5709 135.849C64.2152 135.847 64.7392 136.367 64.7412 137.012C64.7432 137.656 64.2229 138.18 63.5782 138.182C61.3682 138.189 58.7762 138.201 56.4599 138.223C54.1452 138.244 52.0975 138.275 51.0072 138.318C50.3632 138.343 49.8209 137.842 49.7959 137.198C49.7702 136.554 50.2719 136.011 50.9159 135.986C52.0652 135.941 54.1115 135.911 56.4379 135.889ZM80.9051 158.182C78.6914 158.189 76.0961 158.201 73.7721 158.223C71.4457 158.244 69.3991 158.275 68.2501 158.319C67.6061 158.344 67.1044 158.887 67.1297 159.531C67.1551 160.175 67.6971 160.676 68.3411 160.651C69.4314 160.608 71.4791 160.577 73.7934 160.556C76.1101 160.534 78.7021 160.522 80.9124 160.515C81.5571 160.513 82.0774 159.989 82.0754 159.345C82.0734 158.7 81.5494 158.18 80.9051 158.182ZM68.5828 164.319C70.0915 164.26 73.1628 164.226 76.3612 164.205C77.0058 164.201 77.5315 164.719 77.5358 165.364C77.5398 166.008 77.0208 166.534 76.3768 166.538C73.1912 166.559 70.1098 166.594 68.6742 166.651C68.0302 166.676 67.4878 166.175 67.4628 165.531C67.4375 164.887 67.9392 164.344 68.5828 164.319Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M164.748 86.9677L164.748 86.9678C169.331 91.3238 174.11 95.8669 176.139 101.79C177.613 106.094 177.554 110.619 176.219 114.962C175.176 118.355 173.897 122.082 171.759 125.073C173.4 127.149 172.911 130.386 171.841 132.67C170.631 135.251 167.904 137.011 165.126 136.664C165.068 137.837 165.002 139.01 164.918 140.181C164.899 140.454 164.888 140.746 164.877 141.048C164.832 142.299 164.78 143.723 164.069 144.681C163.539 145.396 162.736 145.924 161.831 146.337C161.976 149.587 160.321 153.19 158.657 155.782C157.787 157.138 156.733 158.724 155.426 159.774C156.2 161.597 156.29 163.79 156.369 165.706L156.375 165.839C156.485 168.506 156.109 171.02 155.564 173.625C155.39 174.454 155.212 175.283 155.011 176.106C154.937 176.407 154.838 176.724 154.737 177.047C154.512 177.762 154.278 178.51 154.288 179.197C154.299 179.897 154.516 180.551 154.733 181.205C154.929 181.797 155.126 182.39 155.17 183.018C155.35 185.554 152.797 186.936 150.642 187.32C146.371 188.08 139.612 187.271 138.357 182.3C137.814 180.15 137.952 177.964 138.089 175.779C138.148 174.843 138.207 173.907 138.212 172.974C138.23 169.992 138.152 166.913 137.297 164.034C137.244 163.857 137.236 163.699 137.261 163.557C136.673 163.627 136.087 163.689 135.511 163.75L135.51 163.75L135.508 163.75L135.506 163.75C135.014 163.803 134.529 163.854 134.056 163.909C130.665 164.301 127.257 164.551 123.844 164.635C120.108 164.726 116.367 164.666 112.64 164.366L112.597 164.362C109.43 164.108 106.162 163.846 103.031 163.178C102.799 166.72 102.459 170.332 101.524 173.739C101.388 174.237 101.247 174.728 101.107 175.215L101.105 175.219L101.105 175.22L101.105 175.221C100.451 177.499 99.8177 179.704 99.7713 182.129C99.7353 184.009 99.1247 185.992 97.4387 187.045C95.9589 187.969 94.033 188.012 92.3152 188.05H92.315L92.054 188.056C90.2903 188.097 88.3567 188.136 86.658 187.58C84.9793 187.03 84.014 185.487 83.887 183.739C83.8175 182.78 83.8533 181.835 83.8895 180.88L83.8986 180.639L83.906 180.433C83.9368 179.564 83.6907 178.768 83.4427 177.966L83.4426 177.965C83.36 177.698 83.2772 177.43 83.2043 177.159C83.1305 177.16 83.0566 177.161 82.9828 177.163C82.9094 177.164 82.836 177.166 82.7627 177.167C82.6868 177.168 82.6075 177.177 82.5278 177.186L82.5274 177.186C82.4124 177.199 82.2964 177.212 82.1883 177.202C82.103 177.194 81.299 177.087 81.7907 177.083C79.5663 177.102 77.3417 177.106 75.1173 177.107C69.5637 177.108 64.01 177.088 58.4567 177.041C57.5339 177.033 56.5954 177.049 55.6508 177.064H55.6504C53.6044 177.099 51.53 177.133 49.526 176.93C49.354 177.025 49.1423 177.071 48.89 177.038L48.6808 177.011C47.1473 176.815 45.753 176.637 44.545 175.543C43.475 174.573 42.9467 173.234 42.6133 171.863C41.8449 168.704 41.5726 165.414 41.3048 162.176L41.27 161.757C41.1907 160.801 41.1173 159.844 41.0439 158.888L41.0439 158.888L41.0439 158.887L41.0439 158.887L41.0439 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.886L41.0438 158.886L41.0438 158.886L41.0437 158.885C40.9874 158.151 40.931 157.417 40.872 156.683C40.8424 156.316 40.793 155.936 40.7429 155.551C40.6348 154.719 40.5237 153.865 40.6023 153.073C40.8107 150.974 41.8227 149.152 43.3823 148.056C43.0573 147.848 42.746 147.602 42.454 147.303C40.4785 145.285 40.601 142.949 40.7338 140.418C40.7457 140.19 40.7578 139.961 40.7683 139.73C40.8229 138.538 40.8636 137.345 40.9043 136.153C40.9711 134.193 41.038 132.232 41.1667 130.275C41.1927 129.878 41.2138 129.466 41.2354 129.043C41.3495 126.81 41.4782 124.291 42.432 122.361C43.108 120.993 44.0883 120.123 45.281 119.597C45.0287 119.445 44.7827 119.265 44.5443 119.049C43.4743 118.08 42.946 116.74 42.6127 115.369C41.8434 112.207 41.5711 108.913 41.3032 105.672L41.2693 105.264C41.1901 104.309 41.1168 103.353 41.0435 102.398L41.0435 102.398L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.396L41.0434 102.396L41.0434 102.396C40.9869 101.661 40.9305 100.925 40.8713 100.19C40.8417 99.8227 40.7923 99.4425 40.7422 99.0574C40.6341 98.2258 40.5231 97.3714 40.6017 96.5792C40.6847 95.7446 40.896 94.9546 41.2163 94.2352C35.4491 92.5322 35.9554 85.703 36.3472 80.4174C36.377 80.0163 36.4061 79.624 36.4317 79.2436L36.4554 78.8905C36.8213 73.4474 37.1994 67.8221 39.868 63.0072C37.903 59.6346 37.3603 55.9339 36.939 52.0289C36.4653 47.6406 36.061 43.1402 36.1037 38.7209C36.142 34.7092 37.8007 30.8919 42.2383 30.3239C46.0038 29.8418 49.8624 29.8019 53.6783 29.7624H53.6783H53.6784H53.6785H53.6786H53.6787H53.6788H53.6789H53.679H53.679H53.6791H53.6792H53.6793H53.6794C54.4275 29.7547 55.1739 29.7469 55.9177 29.7359C55.946 29.5126 55.9833 29.2889 56.039 29.0649C56.692 26.4376 59.026 24.8932 61.4583 24.0759C66.15 22.4996 77.1653 22.3106 77.4473 29.4342L77.4762 29.4307C77.5198 29.4252 77.5634 29.4197 77.6103 29.4202C80.8293 29.4582 84.052 29.5056 87.267 29.6836C87.6094 29.7024 87.9632 29.7157 88.3228 29.7293L88.323 29.7293L88.3231 29.7293L88.3231 29.7293C88.5054 29.7362 88.6892 29.7432 88.8737 29.7509C88.8617 29.6852 88.851 29.6182 88.8497 29.5462L88.8465 29.3843C88.7878 26.4129 88.6098 17.4072 93.5703 19.2379C95.749 20.0419 97.7987 21.4099 99.5723 22.8906C100.736 23.8626 102.041 24.9749 102.834 26.3316C108.575 24.1129 114.676 22.8909 120.819 22.7699C127.348 22.6406 133.728 23.5746 140.104 24.8616C141.587 22.8509 143.535 21.0996 145.679 19.8396C146.972 19.0796 149.049 17.9616 150.481 19.0339C151.882 20.0831 152.345 22.7358 152.636 24.3983L152.672 24.6059C153.16 27.3759 153.317 30.2526 152.705 33.0119C155.916 38.0016 158.923 43.1892 160.972 48.7719C161.28 49.6096 161.57 50.4632 161.839 51.3266C163.302 51.1902 164.776 51.1436 166.182 51.1062C167.32 51.0759 167.323 52.8689 166.26 53.0599C165.029 53.2806 163.767 53.4869 162.499 53.6596C162.763 54.7062 162.984 55.7636 163.15 56.8272C164.059 56.8682 164.958 56.9402 165.823 57.0252C167.037 57.1446 166.82 58.8596 165.648 58.8729C164.963 58.8804 164.265 58.9106 163.561 58.9411L163.404 58.9479C163.613 61.5452 163.443 64.1539 162.695 66.6919C161.786 69.7746 160.268 72.5272 158.318 74.9282C159.465 75.4346 160.267 76.6372 160.477 77.9696C160.683 79.2846 160.659 80.6379 160.491 81.9569C160.457 82.2229 160.431 82.5022 160.406 82.7856C160.506 82.8399 160.604 82.9072 160.695 83.0019C161.972 84.329 163.351 85.6397 164.748 86.9677ZM126.848 34.428C126.861 35.391 125.388 35.374 125.211 34.4937C124.93 33.1043 124.761 31.6927 124.593 30.2836L124.593 30.2811C124.544 29.8739 124.495 29.4669 124.444 29.0607C124.306 27.9637 125.882 27.6873 126.13 28.763C126.561 30.6253 126.823 32.5167 126.848 34.428ZM132.971 34.6152C133.265 35.5345 134.823 35.0282 134.587 34.0988C134.115 32.2405 133.623 30.3912 132.769 28.6648C132.263 27.6435 130.681 28.3891 131.168 29.4245C131.769 30.6998 132.181 32.049 132.592 33.3959L132.592 33.3959L132.592 33.396C132.717 33.8033 132.841 34.2104 132.971 34.6152ZM141.575 48.4589C141.589 48.6407 141.594 48.4666 141.598 48.3071V48.3071C141.601 48.2236 141.603 48.1442 141.606 48.1219C141.655 47.7802 141.76 47.4549 141.874 47.1299C142.19 46.2302 142.781 45.5419 143.742 45.3655C145.419 45.058 145.973 47.2255 146.319 48.5768C146.356 48.724 146.392 48.8616 146.425 48.9852C146.675 49.8962 148.171 49.9922 148.198 48.9142C148.261 46.3625 146.66 43.1049 143.712 43.3202C141.076 43.5129 139.571 46.1012 139.428 48.5442C139.337 50.1082 141.693 50.0462 141.575 48.4589ZM105.904 49.5421C105.917 49.7241 105.922 49.5501 105.927 49.3906V49.3905C105.929 49.3071 105.931 49.2277 105.935 49.2054C105.983 48.8637 106.089 48.5384 106.203 48.2134C106.518 47.3137 107.109 46.6254 108.071 46.4491C109.748 46.1416 110.301 48.309 110.647 49.6603C110.685 49.8076 110.72 49.9451 110.754 50.0687C111.003 50.9797 112.5 51.0757 112.526 49.9977C112.589 47.4461 110.988 44.1884 108.04 44.4037C105.405 44.5961 103.899 47.1847 103.757 49.6277C103.665 51.1917 106.021 51.1297 105.904 49.5421ZM127.068 63.41C124.902 66.5326 118.58 66.3863 117.594 62.004C117.378 61.0396 118.901 60.5393 119.26 61.472C119.884 63.0923 121.261 63.927 123.005 63.5236C124.68 63.137 125.416 62.0963 125.997 60.5713C126.064 60.3943 126.162 60.2633 126.275 60.167C126.28 60.1358 126.285 60.1048 126.289 60.0738C126.298 60.0138 126.306 59.9538 126.32 59.892C126.554 58.8086 128.162 58.8933 128.077 60.0583C127.956 61.7276 129.035 63.1496 130.749 63.3686C132.635 63.6096 133.521 62.6136 134.45 61.1293C134.924 60.372 136.335 60.8276 136.14 61.7513C135.189 66.237 129.301 66.245 127.068 63.41ZM117.376 34.939C117.362 36.021 118.977 36.2037 119.068 35.099C119.241 33.0087 119.025 30.9413 118.797 28.8633C118.673 27.7247 116.94 28.0437 117.053 29.171C117.246 31.0907 117.402 33.008 117.376 34.939ZM91.6019 22.6446C91.6293 22.5271 91.7125 22.2983 91.8029 22.05C91.9728 21.5833 92.1678 21.0474 92.0643 21.0502C92.5991 21.0362 93.1658 21.3073 93.6614 21.5444C93.7437 21.5838 93.824 21.6222 93.9019 21.6582C96.9433 23.0642 100.013 25.4449 101.869 28.2449C102.157 28.6796 102.761 28.6106 103.119 28.3032C104.674 27.9958 106.199 27.4859 107.721 26.9771L107.721 26.9771C108.775 26.6247 109.827 26.2728 110.887 25.9892C114.269 25.0839 117.743 24.8196 121.233 24.7389C127.501 24.5939 133.71 25.4509 139.854 26.6072C140.283 27.1036 141.116 27.2716 141.596 26.5709C142.725 24.9196 144.179 23.5556 145.772 22.3569C146.335 21.9322 148.796 20.2266 149.28 20.8442C150.078 21.8621 150.356 23.5157 150.582 24.8558L150.582 24.8573L150.582 24.8601L150.583 24.865L150.584 24.8678L150.584 24.8727C150.618 25.0701 150.65 25.2605 150.682 25.4409C151.08 27.6546 151.106 29.8642 150.924 32.0879C150.697 32.3139 150.588 32.6416 150.78 32.9596L150.844 33.0669C150.852 33.3842 151.03 33.6349 151.275 33.7872C154.04 38.4019 156.668 43.1082 158.685 48.1039C159.14 49.2306 159.561 50.3896 159.934 51.5696C159.034 51.7156 158.15 51.9059 157.306 52.1736C156.367 52.4719 156.179 54.1306 157.383 54.1012C158.441 54.0756 159.514 53.9989 160.589 53.8889C160.828 54.8492 161.028 55.8189 161.176 56.7942C160.205 56.8106 159.244 56.8782 158.323 57.0236C157.265 57.1909 157.404 58.6832 158.396 58.8356C159.38 58.9869 160.397 59.0196 161.42 59.0082C161.567 61.1886 161.429 63.3752 160.891 65.5142C158.039 76.8536 146.676 82.2786 136.115 84.1989C135.942 84.2302 135.805 84.2949 135.693 84.3786C130.319 85.1886 124.976 85.7946 119.503 85.7369C115.732 85.6972 111.967 85.3516 108.247 84.7316C104.442 84.0969 100.876 82.8859 97.2643 81.5816C97.1859 80.7372 97.1096 79.9029 97.0699 79.0946C97.0509 78.7082 97.0328 78.3222 97.0147 77.9366V77.9365C96.7763 72.8628 96.5418 67.8696 94.3339 63.2079C96.8081 58.0404 97.0048 52.1054 97.1965 46.3246C97.2558 44.5359 97.3146 42.7621 97.4403 41.0302C97.6039 38.7732 97.7013 36.7506 96.8169 34.6062C96.0736 32.8026 94.3276 30.9356 92.4623 30.2822C92.0043 30.1219 91.5183 30.0156 91.0203 29.9379C91.0283 29.8786 91.0359 29.8192 91.0343 29.7526C90.9783 27.3906 91.0643 24.9546 91.6019 22.6446ZM78.418 31.6113H78.4179H78.4178H78.4177H78.4176H78.4175H78.4174H78.4173C78.1029 31.6073 77.7886 31.6033 77.4745 31.5991C77.4115 32.4941 77.2282 33.3415 76.9365 34.1305L77.1588 34.1305C79.4527 34.1308 81.7463 34.1311 84.0395 34.1508C87.0235 34.1765 90.1762 34.2145 91.9129 37.1001C93.0537 38.9965 92.8948 41.0974 92.7358 43.1993C92.6961 43.7253 92.6563 44.2515 92.6369 44.7745C92.6109 45.4745 92.5876 46.175 92.5643 46.8756V46.8756V46.8757V46.8758C92.4791 49.4407 92.3938 52.0072 92.1765 54.5641C92.1522 54.8497 92.1305 55.1506 92.108 55.4622C91.9467 57.6961 91.7456 60.482 90.2769 62.1205C89.8959 62.5458 89.4709 62.8848 89.0185 63.1668C90.4419 64.1225 91.2959 65.6691 91.6619 67.5701C92.2302 70.5213 92.3527 73.5579 92.4737 76.5561V76.5562L92.4872 76.8888C92.5177 77.642 92.5409 78.3959 92.5641 79.15V79.1502C92.6227 81.0559 92.6813 82.9625 92.8585 84.8595C93.0982 87.4255 92.0462 90.0518 89.8739 91.3425C90.2832 91.5751 90.6725 91.8641 91.0325 92.2321C91.1525 92.3551 91.2625 92.4798 91.3679 92.6051C92.1789 92.3891 92.8562 91.9594 93.4709 91.3455C95.8218 88.998 95.552 85.9844 95.2839 82.9898C95.2372 82.4682 95.1906 81.9472 95.1579 81.4305C94.9352 77.9168 94.6952 74.3781 94.2265 70.8815C93.8765 68.2708 93.2585 66.0821 92.0815 63.7471C91.7354 63.0606 92.2298 62.2251 92.6356 61.5392C92.7397 61.3632 92.8381 61.197 92.9149 61.0458C93.4022 60.0858 93.6415 58.9798 93.8289 57.9275C94.8212 52.3448 95.0677 46.5005 95.308 40.8057L95.308 40.804C95.3322 40.2306 95.3564 39.6587 95.3812 39.0888C95.5285 35.6975 93.6862 32.4771 90.1555 32.1125C86.2645 31.7108 82.3298 31.6609 78.418 31.6113ZM84.894 90.0025C80.5911 90.0554 76.2875 90.0482 71.9842 90.0411H71.9841C71.1849 90.0398 70.3858 90.0384 69.5867 90.0375C63.9284 90.031 58.2697 90.0149 52.6114 89.9987L52.0613 89.9972L51.0947 89.9945L51.0836 89.9945C49.6901 89.9905 48.2967 89.9866 46.9033 89.9855C45.2373 89.9838 44.0923 89.1842 43.2993 87.7212C42.6755 86.5712 42.8089 85.3178 42.9409 84.0776C42.9667 83.836 42.9923 83.5949 43.0123 83.3552C43.0974 82.3374 43.1761 81.3192 43.2549 80.3011C43.4686 77.5374 43.6823 74.7745 44.0223 72.0222C44.2267 70.3688 44.455 68.6922 44.9393 67.0938C45.58 64.9788 47.0647 64.5735 48.9863 64.3125C49.564 64.3477 50.1445 64.3575 50.7192 64.3672L50.7197 64.3672L50.9683 64.3715C55.1712 64.4451 59.3762 64.4462 63.58 64.4473H63.5801H63.5801H63.5802H63.5802H63.5803H63.5804H63.5804H63.5805H63.5805L65.0287 64.4478C70.2413 64.4502 75.454 64.4422 80.6663 64.3875C81.0817 64.3832 81.5079 64.3861 81.9406 64.389H81.9407H81.9409H81.941H81.9412H81.9413H81.9415H81.9417H81.9418H81.942C82.9159 64.3955 83.9221 64.4022 84.9087 64.3282C84.9547 64.3322 84.9997 64.3355 85.046 64.3398C86.143 64.4405 87.201 64.5628 88.1113 65.2315C89.1109 65.9659 89.3497 67.4591 89.537 68.6301C89.5507 68.7161 89.5642 68.8004 89.5777 68.8825C90.0589 71.8092 90.1642 74.8085 90.2683 77.7748L90.2686 77.7823C90.279 78.0804 90.2895 78.3782 90.3003 78.6755C90.3135 79.0355 90.3263 79.3955 90.339 79.7555L90.3391 79.7574L90.3392 79.7593L90.3392 79.7612L90.3393 79.7631L90.3394 79.765L90.3394 79.7669L90.3395 79.7689L90.3396 79.7712C90.3761 80.8019 90.4127 81.8323 90.458 82.8628C90.4751 83.2511 90.5099 83.644 90.5448 84.0383C90.6187 84.8726 90.6932 85.7133 90.602 86.5302C90.261 89.5732 87.3353 89.9725 84.894 90.0025ZM75.6254 29.7716C73.8001 24.4782 65.4461 24.6222 61.2328 26.5209C59.5238 27.2906 57.9621 28.5699 58.0058 30.6086C58.0434 32.3712 59.0944 34.0339 60.2964 35.2532C62.7758 37.7699 66.3568 38.4516 69.7671 37.6909C73.7871 36.7946 75.9658 33.8582 75.6378 29.7979C75.6361 29.7935 75.634 29.7895 75.6319 29.7855L75.6286 29.7791C75.6275 29.7766 75.6264 29.7742 75.6254 29.7716ZM57.7547 36.1706C57.9267 36.1693 58.0743 36.1259 58.203 36.0586C61.0633 39.4956 65.4847 40.5249 69.8267 39.7363C72.422 39.2646 74.4763 38.0059 75.8043 36.2213C75.9267 36.2759 76.0697 36.3086 76.2374 36.3086C78.4794 36.3113 80.7213 36.3156 82.9633 36.3303C83.3415 36.3328 83.731 36.3246 84.1257 36.3163C85.3076 36.2916 86.5365 36.2659 87.6487 36.5223C90.8806 37.2681 90.6823 40.3632 90.5146 42.9803L90.5146 42.9808C90.494 43.3016 90.4739 43.6153 90.4607 43.9166C90.4157 44.9389 90.3783 45.9615 90.341 46.9841L90.341 46.9843L90.341 46.9846L90.341 46.9848L90.341 46.9851L90.3409 46.9853L90.3409 46.9856L90.3409 46.9858L90.3409 46.9862V46.9863V46.9864V46.9864V46.9865V46.9866V46.9866C90.2608 49.1811 90.1806 51.3755 90.0247 53.5666C90.0025 53.8791 89.9859 54.224 89.9682 54.5903L89.9682 54.5906C89.853 56.9808 89.6938 60.2852 87.6553 61.4933C86.8567 61.9666 85.8803 62.0756 85.0063 62.1026C84.7399 62.0984 84.473 62.0995 84.2057 62.1005H84.2055H84.2053H84.2051H84.2049H84.2047H84.2045H84.2043C83.9136 62.1017 83.6223 62.1028 83.3303 62.0973L81.3337 62.0696C80.2224 62.0616 79.1107 62.0576 77.999 62.0546C71.964 62.0386 65.9283 62.0619 59.8937 62.1069C58.8254 62.115 57.7386 62.0958 56.6446 62.0764H56.6445H56.6445H56.6444H56.6443H56.6443H56.6442H56.6441C54.802 62.0438 52.9397 62.0109 51.1113 62.1073C51.0787 62.1066 51.046 62.1066 51.0133 62.1059C50.1723 62.0903 49.3493 62.0559 48.5137 61.9676C47.0357 61.8109 45.969 61.4363 45.2567 60.0043C44.8741 59.2361 44.71 58.3443 44.5539 57.4962C44.5337 57.3859 44.5135 57.2764 44.493 57.1679C43.7935 53.4655 43.4818 49.702 43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9447L43.1707 45.9447C43.0663 44.6838 42.962 43.4236 42.843 42.1666C42.55 39.0699 43.7193 36.2706 47.2017 36.2496C49.6294 36.2349 52.0576 36.2155 54.486 36.1962C55.5755 36.1875 56.6651 36.1789 57.7547 36.1706ZM38.3432 86.4303C38.4359 89.3386 39.4676 91.7536 42.5199 92.297C42.8699 91.937 43.2642 91.625 43.6936 91.362C41.2766 89.8216 40.4492 87.0493 40.7226 84.1656C40.8587 82.7277 40.9679 81.2874 41.0772 79.8471L41.0772 79.8471C41.1884 78.3806 41.2997 76.914 41.4392 75.45C41.4661 75.1679 41.4925 74.8846 41.5189 74.6004C41.7685 71.9166 42.0258 69.1505 42.8082 66.5773C43.2196 65.2233 43.9282 64.0146 45.0896 63.1686C43.6402 62.1326 42.8492 60.4526 42.4349 58.514C41.5181 54.2246 41.2544 49.799 40.9922 45.3998C40.9052 43.94 40.8184 42.483 40.7079 41.035C40.4612 37.8053 43.0912 34.305 46.4626 34.3196C49.1469 34.3316 51.8312 34.3329 54.5157 34.3341H54.5157H54.5158H54.5158H54.5159H54.5159H54.516C55.3456 34.3345 56.1753 34.3349 57.0049 34.3356C56.5109 33.469 56.1352 32.537 55.9672 31.5713C55.2473 31.5923 54.5252 31.6105 53.8018 31.6287H53.8018C50.2088 31.719 46.5847 31.8101 43.0319 32.2626C41.2759 32.4863 39.7522 33.1633 39.0462 34.8723C38.3509 36.5543 38.3416 38.3646 38.4042 40.1583C38.5442 44.1423 38.7579 48.1356 39.2186 52.0973L39.2312 52.2059C39.6412 55.7296 40.0501 59.245 42.0172 62.266C42.3112 62.718 42.3716 63.1583 42.0802 63.6346C39.5151 67.8347 39.1335 72.8644 38.7666 77.6992L38.7432 78.0073C38.7128 78.4073 38.6811 78.8088 38.6492 79.2114C38.4596 81.6072 38.267 84.0405 38.3432 86.4303ZM45.2158 116.309C44.7537 115.381 44.5749 114.28 44.4069 113.246C44.3814 113.089 44.3561 112.933 44.3301 112.78C43.8073 109.699 43.5658 106.566 43.3257 103.451L43.2845 102.917C43.2414 102.361 43.1669 101.764 43.0899 101.147C42.7981 98.8108 42.4694 96.179 43.6721 94.3136C44.7927 92.576 46.6665 92.6186 48.4742 92.6596C48.7621 92.6662 49.0483 92.6727 49.3295 92.672C51.8935 92.6655 54.4575 92.657 57.0216 92.6484H57.0222H57.0227H57.0232H57.0236H57.0241H57.0261C65.5103 92.62 73.995 92.5916 82.4788 92.6413C82.9065 92.6438 83.3493 92.6329 83.799 92.6218C85.0883 92.59 86.4336 92.5568 87.6381 92.8346C90.8525 93.5758 90.6541 96.6544 90.4862 99.2582C90.4654 99.5809 90.4451 99.8962 90.4318 100.199C90.3869 101.222 90.3496 102.245 90.3123 103.268C90.2323 105.463 90.1523 107.657 89.9968 109.849C89.9746 110.162 89.9581 110.508 89.9405 110.875C89.8266 113.255 89.6689 116.553 87.6431 117.754C86.6119 118.365 85.2923 118.369 84.2825 118.372C84.1153 118.372 83.9566 118.373 83.8091 118.376C83.4705 118.383 83.1318 118.388 82.7938 118.394C82.707 118.395 82.6201 118.388 82.5332 118.382C82.387 118.371 82.2408 118.36 82.0951 118.386C82.0702 118.39 82.0442 118.395 82.0177 118.399C81.9927 118.403 81.9673 118.407 81.9418 118.411C81.9203 118.415 81.8988 118.418 81.8775 118.422L81.8752 118.422L81.875 118.422C81.553 118.473 81.2885 118.515 81.9878 118.503C80.9361 118.521 79.8838 118.533 78.8318 118.545C73.3918 118.606 67.9515 118.628 62.5115 118.637C59.4798 118.642 56.4485 118.641 53.4168 118.622C53.0159 118.62 52.609 118.626 52.1996 118.633C51.3478 118.646 50.4852 118.66 49.6441 118.594C49.5005 118.479 49.3211 118.394 49.0958 118.365L48.9372 118.344C47.3241 118.137 46.0448 117.972 45.2158 116.309ZM43.1732 136.272C43.136 137.293 43.0987 138.315 43.0539 139.336C43.0406 139.639 43.0203 139.954 42.9995 140.277C42.8319 142.881 42.6338 145.958 45.8479 146.7C47.0529 146.978 48.3988 146.945 49.6886 146.913H49.6887C50.1378 146.902 50.5801 146.892 51.0072 146.894C53.9842 146.911 56.9612 146.918 59.9385 146.92C66.0942 146.896 72.2499 146.873 78.4055 146.88H78.4675C80.3639 146.874 82.2602 146.868 84.1565 146.863C84.4363 146.862 84.7211 146.869 85.0075 146.875H85.0085H85.0094H85.0104C86.8187 146.917 88.6933 146.96 89.8139 145.221C91.0167 143.356 90.6881 140.723 90.3963 138.387C90.3193 137.77 90.2449 137.174 90.2019 136.618L90.1607 136.084C89.9205 132.969 89.679 129.836 89.1562 126.755C89.1301 126.601 89.1046 126.445 89.079 126.287C88.9109 125.253 88.732 124.154 88.2702 123.226C87.4414 121.563 86.1632 121.398 84.55 121.19L84.3902 121.17C84.1652 121.14 83.9862 121.056 83.8425 120.941C83.0012 120.874 82.1385 120.888 81.2866 120.902H81.2863H81.2859H81.2856H81.2853C80.8763 120.909 80.4697 120.915 80.0692 120.913C77.0375 120.893 74.0062 120.893 70.9745 120.898C65.5345 120.906 60.0942 120.929 54.6542 120.989C53.6022 121.001 52.5499 121.014 51.4982 121.031C52.1978 121.02 51.9328 121.062 51.6106 121.113L51.6104 121.113C51.5365 121.124 51.4597 121.136 51.3909 121.148C51.2454 121.174 51.0995 121.163 50.9536 121.153C50.8664 121.146 50.7792 121.14 50.6922 121.141C50.3539 121.146 50.0155 121.152 49.6769 121.159C49.5287 121.162 49.3692 121.162 49.2012 121.163C48.1917 121.166 46.8733 121.17 45.8429 121.78C43.8166 122.982 43.659 126.281 43.5453 128.661C43.5278 129.028 43.5113 129.373 43.4892 129.686C43.3333 131.879 43.2533 134.075 43.1732 136.272ZM83.8095 174.87C83.4759 174.877 83.1424 174.882 82.8095 174.887L82.7941 174.888C82.7065 174.889 82.6186 174.883 82.5308 174.876C82.3855 174.865 82.2402 174.854 82.0955 174.88C82.0245 174.893 81.9452 174.905 81.8694 174.917L81.8685 174.917C81.5496 174.968 81.2938 175.009 81.9881 174.997C80.9365 175.015 79.8841 175.027 78.8321 175.039C73.3921 175.1 67.9518 175.123 62.5118 175.131C59.4801 175.136 56.4488 175.135 53.4171 175.116C53.0169 175.114 52.6106 175.12 52.2017 175.127H52.2005H52.1992H52.1979C51.3466 175.141 50.4846 175.154 49.6441 175.088C49.5005 174.973 49.3211 174.888 49.0961 174.859L48.9383 174.839C47.3245 174.631 46.0446 174.467 45.2158 172.803C44.7542 171.876 44.5756 170.777 44.4076 169.743C44.3819 169.585 44.3564 169.428 44.3301 169.274C43.8073 166.193 43.5658 163.06 43.3257 159.945L43.2845 159.411C43.2414 158.855 43.1669 158.258 43.0899 157.641C42.7981 155.304 42.4695 152.673 43.6721 150.807C44.7929 149.069 46.6671 149.112 48.4753 149.153C48.7628 149.16 49.0486 149.166 49.3295 149.166C51.2061 149.161 53.0828 149.154 54.9595 149.148C55.0001 149.148 55.0405 149.148 55.0808 149.148C61.2138 149.155 67.3465 149.133 73.4791 149.109C76.4791 149.111 79.4791 149.118 82.4788 149.135C82.9048 149.138 83.3459 149.127 83.7938 149.116C85.0847 149.084 86.432 149.05 87.6381 149.329C90.8525 150.07 90.6541 153.148 90.4862 155.751L90.4862 155.751L90.4862 155.752L90.4862 155.752C90.4654 156.074 90.4451 156.389 90.4318 156.692C90.3869 157.714 90.3497 158.735 90.3125 159.757L90.3124 159.758L90.3124 159.759L90.3123 159.76C90.2323 161.956 90.1523 164.151 89.9968 166.343C89.9746 166.655 89.9581 167.001 89.9405 167.368L89.9405 167.368L89.9405 167.369L89.9405 167.369C89.8266 169.749 89.6689 173.047 87.6431 174.248C86.6112 174.86 85.2909 174.863 84.2809 174.866H84.2807C84.1143 174.866 83.9563 174.867 83.8095 174.87ZM156.613 154.802C157.539 153.367 158.337 151.84 158.859 150.207C159.181 149.202 159.355 148.181 159.53 147.159L159.53 147.159L159.533 147.141C159.049 147.275 158.573 147.394 158.127 147.506L158.123 147.507L158.123 147.507L158.122 147.507L158.121 147.508C157.911 147.56 157.708 147.611 157.514 147.661C154.281 148.491 150.974 149.023 147.661 149.421C138.755 150.49 129.742 150.78 120.778 150.672C115.647 150.611 110.513 150.43 105.395 150.051C100.452 149.686 95.5655 149.261 90.8355 147.687C90.7472 147.658 90.6739 147.619 90.6065 147.576C90.4455 147.716 90.2782 147.85 90.1029 147.973C90.4282 148.181 90.7395 148.427 91.0315 148.726C93.007 150.745 92.8845 153.08 92.7517 155.611L92.7517 155.612C92.7398 155.839 92.7278 156.068 92.7172 156.299C92.6624 157.493 92.6216 158.688 92.5808 159.883C92.5139 161.841 92.4471 163.799 92.3185 165.754C92.2925 166.151 92.2714 166.563 92.2498 166.986L92.2498 166.986C92.1357 169.22 92.007 171.739 91.0535 173.669C89.8792 176.045 87.7895 176.925 85.2575 177.091C85.2429 177.092 85.2285 177.092 85.2139 177.093C85.7749 178.589 86.0175 179.941 85.9835 181.697C85.9472 183.566 85.9892 185.384 88.1342 185.679C90.6125 186.02 97.0285 186.794 97.4792 183.202C97.5655 182.514 97.6045 181.842 97.6432 181.176C97.7145 179.948 97.7847 178.741 98.1475 177.491C98.3105 176.929 98.4838 176.366 98.6576 175.801L98.6577 175.801L98.6578 175.8C99.1408 174.231 99.6279 172.649 99.9085 171.045C100.445 167.978 100.718 164.816 100.906 161.709C100.97 160.643 102.219 160.492 102.809 161.08C104.045 161.214 105.277 161.377 106.508 161.541C108.612 161.819 110.715 162.098 112.841 162.234C116.369 162.459 119.91 162.555 123.445 162.458C126.861 162.364 130.276 162.132 133.669 161.712C135.289 161.512 136.907 161.286 138.516 161.006C138.981 160.924 139.452 160.821 139.924 160.717L139.925 160.717L139.925 160.717L139.925 160.716C140.796 160.525 141.674 160.331 142.539 160.275C143.654 160.202 144.415 161.845 143.188 162.306C141.973 162.762 140.645 163.06 139.29 163.279C139.368 163.384 139.434 163.504 139.477 163.648C140.53 167.194 140.391 170.798 140.252 174.412V174.412C140.194 175.939 140.135 177.468 140.166 178.994C140.217 181.507 140.684 183.63 143.246 184.473C145.374 185.174 147.65 185.603 149.88 185.206C150.891 185.025 153.237 184.552 152.966 183.06C152.884 182.607 152.731 182.168 152.579 181.73C152.396 181.204 152.213 180.679 152.152 180.129C151.952 178.33 152.492 176.434 153.018 174.589C153.272 173.696 153.523 172.815 153.685 171.963C154.417 168.114 154.795 163.538 153.386 159.776C153.28 159.616 153.228 159.43 153.254 159.233C153.263 158.868 153.499 158.536 153.8 158.372C153.89 158.267 153.98 158.162 154.07 158.057L154.071 158.056C154.968 157.01 155.859 155.97 156.613 154.802ZM169.889 131.509C169.034 133.646 167.258 134.518 165.224 134.521L165.236 134.242L165.24 134.132C165.246 133.993 165.252 133.854 165.258 133.715C165.304 132.639 165.349 131.563 165.392 130.486C167.238 129.843 169.176 128.663 170.23 127.034C170.9 128.347 170.395 130.248 169.889 131.509ZM171.559 120.443C172.577 118.253 173.453 115.94 174.076 113.604C175.16 109.537 175.139 105.248 173.378 101.368C171.341 96.878 167.913 93.4894 164.478 90.0942C162.963 88.5971 161.447 87.0986 160.049 85.5039C159.962 85.8526 159.853 86.1883 159.705 86.4986C159.303 87.3383 158.207 87.2286 157.958 86.3409C157.68 85.3458 157.869 84.0064 158.063 82.6328C158.4 80.2377 158.753 77.7387 156.667 76.7803C156.059 77.3983 155.418 77.9843 154.753 78.5449C154.979 79.6956 154.906 81.0013 154.839 82.2122C154.82 82.5455 154.802 82.8716 154.79 83.1853C154.73 84.8339 154.642 86.4743 154.491 88.1173C154.395 89.1626 152.856 88.9973 152.883 87.9649C152.909 86.9878 152.952 86.0119 152.996 85.0359C153.026 84.3652 153.056 83.6945 153.08 83.0233C153.1 82.4552 153.094 81.8728 153.088 81.2873C153.083 80.8084 153.077 80.3274 153.087 79.8506C151.931 80.6916 150.711 81.4533 149.443 82.1336C149.496 82.8618 149.453 83.6306 149.413 84.3468C149.397 84.6335 149.381 84.9118 149.372 85.1756C149.315 86.9173 149.235 88.6509 149.058 90.3846C148.953 91.4269 147.417 91.2663 147.451 90.2323C147.48 89.3491 147.519 88.4667 147.558 87.5844C147.59 86.8771 147.621 86.1698 147.647 85.4623C147.666 84.9649 147.653 84.4401 147.641 83.9083C147.634 83.6197 147.627 83.329 147.625 83.0396C146.4 83.6039 145.141 84.0979 143.858 84.5149C143.895 85.1458 143.854 85.813 143.817 86.4218C143.801 86.691 143.785 86.9488 143.777 87.1869C143.727 88.6486 143.665 90.1036 143.445 91.5513C143.29 92.5736 141.762 92.4453 141.837 91.3989C141.942 89.9449 142.019 88.4819 142.067 87.0249C142.08 86.6257 142.066 86.1974 142.051 85.7614C142.043 85.5261 142.035 85.2886 142.031 85.0523C140.767 85.3886 139.49 85.6529 138.209 85.8439C137.865 85.9473 137.52 86.0473 137.171 86.1409C137.193 86.2163 137.208 86.2956 137.208 86.3839C137.212 88.3813 137.178 90.3979 137.013 92.3883C136.924 93.4583 135.26 93.3029 135.353 92.2309C135.519 90.3386 135.583 88.4246 135.606 86.5239C133.793 86.9343 131.935 87.2316 130.058 87.4379C130.105 89.3739 130.128 91.3366 129.941 93.2589C129.838 94.3116 128.258 94.1549 128.312 93.1049C128.378 91.8198 128.38 90.5305 128.383 89.2413C128.384 88.693 128.385 88.1448 128.39 87.5969C126.19 87.7789 123.979 87.8509 121.805 87.8539C121.857 88.6671 121.865 89.4848 121.873 90.3027C121.883 91.2867 121.893 92.271 121.979 93.2479C122.078 94.3946 120.305 94.7139 120.209 93.5606C120.056 91.7169 119.896 89.7206 120.003 87.8433C119.602 87.8373 119.201 87.8293 118.804 87.8196C117.192 87.7803 115.543 87.7019 113.881 87.5716C113.895 88.2563 113.896 88.9419 113.897 89.6276C113.899 90.7739 113.901 91.9204 113.958 93.0629C114.01 94.0886 112.454 94.4136 112.348 93.3469C112.153 91.3896 112.177 89.3919 112.228 87.4233C110.493 87.2476 108.754 87.0059 107.035 86.6749C107.036 86.6826 107.037 86.6902 107.038 86.6978C107.043 86.7263 107.047 86.7547 107.047 86.7853C107.065 88.6156 107.134 90.4589 107.295 92.2826C107.389 93.3456 105.743 93.6416 105.653 92.5719C105.489 90.6036 105.445 88.6089 105.449 86.6343C105.45 86.5266 105.47 86.4353 105.501 86.3529C104.033 86.0206 102.589 85.6156 101.184 85.1283C101.185 85.448 101.177 85.7713 101.168 86.0924C101.155 86.5697 101.143 87.0423 101.164 87.4916C101.222 88.7173 101.292 89.9449 101.378 91.1689C101.449 92.1843 99.9511 92.4979 99.7878 91.4493C99.5651 90.0233 99.4911 88.5853 99.4468 87.1433C99.44 86.9265 99.4267 86.6957 99.4129 86.457C99.3754 85.8099 99.3346 85.104 99.4128 84.4583C98.7418 84.1829 98.0811 83.8883 97.4348 83.5676C97.5421 85.0869 97.5698 86.6019 97.3208 88.0279C96.8538 90.7026 94.9304 93.3193 92.3351 94.2343C92.9263 95.7509 92.8408 97.3982 92.7504 99.1384C92.7389 99.3596 92.7274 99.5822 92.7171 99.8063C92.6623 101.001 92.6215 102.196 92.5807 103.391C92.5138 105.349 92.447 107.307 92.3184 109.262C92.2924 109.658 92.2713 110.071 92.2497 110.493C92.1356 112.727 92.007 115.246 91.0534 117.176C90.3774 118.544 89.3968 119.414 88.2041 119.939C88.4568 120.092 88.7024 120.272 88.9411 120.488C90.0108 121.457 90.5391 122.797 90.8724 124.167C91.6414 127.328 91.9135 130.62 92.1812 133.859C92.1926 133.997 92.204 134.135 92.2154 134.273C92.2956 135.236 92.3695 136.199 92.4435 137.163C92.4993 137.891 92.5552 138.619 92.6138 139.347C92.6433 139.714 92.6928 140.095 92.7429 140.481C92.8508 141.312 92.9617 142.166 92.8831 142.957C92.7691 144.105 92.4111 145.166 91.8591 146.076C98.1517 147.686 104.664 147.936 111.134 148.184C111.358 148.192 111.582 148.201 111.806 148.209C121.515 148.584 131.274 148.573 140.963 147.764C141.282 147.737 141.603 147.711 141.925 147.684C148.082 147.175 154.779 146.622 160.491 144.227C160.597 144.182 160.72 144.138 160.851 144.091C161.33 143.92 161.914 143.711 162.123 143.317C162.416 142.767 162.44 142.029 162.462 141.355C162.469 141.152 162.475 140.955 162.489 140.77C162.627 138.894 162.728 137.016 162.81 135.137C163.032 130.056 163.189 124.968 163.272 119.883C163.416 111.061 161.249 102.658 159.071 94.2058C158.828 93.2639 158.585 92.3214 158.345 91.3776C158.048 90.2123 159.817 89.9543 160.153 91.0589C160.247 91.3703 160.342 91.6816 160.437 91.9928C162.003 97.1386 163.561 102.257 164.567 107.485C164.842 107.18 165.12 106.878 165.411 106.587C165.436 106.563 165.46 106.538 165.486 106.513C166.086 105.913 166.941 105.057 167.842 105.236C168.402 105.347 168.984 105.939 168.674 106.561C168.432 107.046 167.997 107.384 167.562 107.723C167.322 107.911 167.081 108.098 166.873 108.31C166.663 108.524 166.457 108.74 166.25 108.956C165.851 109.373 165.452 109.79 165.033 110.189C165.436 112.841 165.68 115.526 165.685 118.263C165.69 121.392 165.611 124.527 165.5 127.659C166.601 127.126 167.573 126.324 168.415 125.444C168.654 125.09 168.897 124.741 169.14 124.393C170.022 123.126 170.899 121.866 171.559 120.443Z"
            fill="#465B6D"
        />
    </svg>
);

export default TicketCatL;
