import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TicketCatM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 120 120"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M51.469 17.4978V12.948L52.6064 11.3745L54.9524 12.3127L58.1514 15.3556L60.5685 15.0143L63.9808 14.2181H68.2462L70.0946 13.6494L74.6443 14.2181L78.9097 14.4383L80.2604 14.7868L82.4642 12.948L84.3837 11.3745H85.45L86.4453 12.512L86.9429 15.9243V18.7679L87.796 20.7841L89.0756 22.7489L89.9998 25.0238L91.0661 27.2987L92.0614 29.8011L92.6301 32.9859V36.3982L91.6349 39.8105L89.0756 43.2229L97.8908 72.2276V75.0712L96.5401 76.948L94.4785 77.3461L93.5543 80.1897L91.0661 83.602L91.6349 85.8769C91.6349 85.8769 91.1372 87.0151 90.5685 87.7944C89.9998 88.5737 88.3647 90.4266 88.3647 90.4266V93.4816V95.7565L87.796 100.664V102.938L88.3647 104.556L86.4453 106.562H83.7439L81.6112 106.351C81.6112 106.351 80.2604 106.276 80.2604 105.649C80.2604 105.023 79.3363 104.076 79.3363 104.076V97.82V92.7015L70.0946 93.2702L58.1514 92.7015L56.9429 98.9574L55.7344 105.649L54.0993 106.562H49.5496L48.4121 103.507V98.3887L51.469 17.4978Z"
            fill="white"
        />
        <path
            d="M34.4784 14.7869L37.8196 13.6494L41.303 14.4383L43.0803 15.5011L43.649 18.542L42.3694 21.0428L40.0945 22.1802H37.1087C37.1087 22.1802 34.4784 21.3271 34.4784 21.185C34.4784 21.0428 33.0566 19.6945 33.0566 19.5156C33.0566 19.3366 32.3457 17.9148 32.3457 17.9148L32.7012 15.9243L33.5542 15.3556L34.4784 14.7869Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M88.0193 103.324C88.055 105.265 87.6824 106.541 83.8092 106.286C79.6412 105.577 79.5243 104.489 79.61 102.192C78.7136 102.116 77.787 102.048 76.8306 101.988C74.0416 101.815 71.0161 101.634 67.8546 101.634C64.175 101.634 61.3049 101.826 57.5268 101.908C57.1746 101.916 56.8285 101.927 56.4852 101.941C56.5683 104.81 57.2685 107.032 50.7614 106.572C49.2077 106.713 48.4923 105.386 48.1096 102.944C44.6774 103.712 42.627 104.783 42.627 105.752C42.627 107.269 47.6308 108.974 55.1243 109.223C59.5913 109.371 63.2113 109.87 67.8546 109.87C71.6711 109.87 75.2856 109.509 78.5327 109.399C87.5521 109.091 93.0824 107.404 93.0824 105.752C93.0824 104.823 91.1972 103.99 88.0193 103.324Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M48.3176 20.0635H42.9341C42.0941 21.376 40.2717 22.2858 38.1576 22.2858C36.0435 22.2858 34.221 21.376 33.381 20.0635C29.7616 20.0635 26.9206 20.0635 26.9206 20.0635C24.5715 20.0635 23.8096 21.5873 23.8096 23.6191C23.8096 25.6509 24.3639 29.9094 24.762 32.6349C25.2372 35.8886 26.2858 36 28.762 36C31.2381 36 47.0477 36.0635 49.2063 36.0635C51.365 36.0635 51.873 33.9682 52.0635 31.873C52.254 29.7778 52.1905 25.7143 52.3174 23.0477C52.4442 20.381 50.4128 20.0635 48.3176 20.0635Z"
            fill="#7DC9F0"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M52.3176 49.2204C52.1905 46.5537 52.2541 42.4903 52.0637 40.3951C51.8732 38.2998 51.3652 36.2046 49.2065 36.2046C47.0477 36.2046 31.2381 36.268 28.762 36.268C26.2858 36.268 25.2372 36.3794 24.762 39.6332C24.3639 42.3587 23.8096 46.6172 23.8096 48.649C23.8096 50.6808 24.5715 52.2046 26.9206 52.2046C26.9206 52.2046 46.2221 52.2046 48.3174 52.2046C50.4126 52.2046 52.4444 51.8871 52.3176 49.2204Z"
            fill="#F8CA45"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M48.3174 52.2959C46.2221 52.2959 26.9206 52.2959 26.9206 52.2959C24.5715 52.2959 23.8096 53.8197 23.8096 55.8515C23.8096 57.8833 24.3639 62.1418 24.762 64.8673C25.2372 68.121 26.2858 68.2325 28.762 68.2325C31.2381 68.2325 47.0477 68.2959 49.2063 68.2959C51.365 68.2959 51.873 66.2007 52.0635 64.1054C52.254 62.0102 52.1905 57.9468 52.3174 55.2801C52.4442 52.6134 50.4126 52.2959 48.3174 52.2959Z"
            fill="#6FCC62"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M52.1126 81.6013C51.9856 78.9346 51.7635 74.8712 51.573 72.7759C51.3825 70.6807 50.8749 68.5854 48.7172 68.5854C46.5595 68.5854 30.7579 68.6489 28.2829 68.6489C25.8078 68.6489 24.7598 68.7603 24.285 72.014C23.8871 74.7395 23.9044 78.998 23.9044 81.0298C23.9044 83.0616 24.6659 84.5854 27.0139 84.5854C27.0139 84.5854 46.0202 84.5854 48.1143 84.5854C50.2088 84.5854 52.2395 84.2679 52.1126 81.6013Z"
            fill="#DD89CE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M91.2378 48.1903C91.2378 48.1903 91.9997 43.0474 89.3331 43.4284C89.3331 43.4284 83.0473 49.3331 70.2854 49.3331C57.5235 49.3331 55.0473 47.0474 55.0473 47.0474C55.0473 47.0474 55.8092 50.095 53.9045 52.1903L51.9997 53.5236C51.9997 53.5236 52.3807 54.6665 52.1902 57.7141C51.9997 60.7617 51.9997 62.6665 51.8092 64.7617C51.6188 66.8569 49.1426 68.3808 49.1426 68.3808C49.1426 68.3808 50.6664 68.9522 51.4283 71.0474C52.1902 73.1427 52.1902 81.3331 52.1902 81.3331C52.1902 81.3331 52.3616 81.7884 51.8092 83.8093C61.714 87.0474 89.1426 85.3331 93.714 82.476V73.9046C93.714 73.9046 99.8092 72.1903 100.762 63.2379C101.714 54.2855 91.2378 48.1903 91.2378 48.1903Z"
            fill="#F0ECD8"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M86.2864 50.6667C86.2864 50.6667 86.5434 47.3528 86.096 45.7144L80.9531 48.0001L81.3341 52.0001C82.5687 68.0536 80.9531 84.762 80.9531 84.762L86.6674 84.0001C89.4403 62.9224 86.2864 50.6667 86.2864 50.6667ZM75.0475 48.9521L68.9523 49.3331V53.9045C68.3658 75.0019 68.1904 85.3331 68.1904 85.3331L74.6666 84.9521C75.3752 70.6384 75.238 53.1426 75.238 53.1426C75.238 53.1426 75.2999 51.5085 75.0475 48.9521ZM56.9528 48.0001C56.9528 48.0001 57.8347 48.894 62.4766 49.5239C62.2861 52.1906 62.8576 54.0953 62.8576 54.0953C62.8576 54.0953 62.5753 73.9033 62.8576 84.762C62.8576 84.762 59.048 85.7144 56.1909 84.5715C56.1909 84.5715 55.6195 69.7144 57.1433 53.3334L56.9528 48.0001Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M97.1426 54.1904C94.095 50.6666 91.0474 48.2856 91.0474 48.2856L90.9521 52.2856C94.9061 59.9207 93.9998 74.0952 93.9998 74.0952C93.9998 74.0952 98.1902 71.7142 99.8093 66.1904C101.428 60.6666 100.19 57.7142 97.1426 54.1904Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M89.5235 43.6191C92.1902 43.2382 91.4283 51.2382 91.4283 51.2382C84.3807 57.5239 62.2443 57.857 52.9736 53.5361C53.967 51.5252 55.0474 47.2382 55.0474 47.2382C78.6664 53.3334 89.5235 43.6191 89.5235 43.6191ZM52.3811 77.7144C52.3811 77.7144 66.5878 81.6649 93.143 76.9525L93.524 82.6668C93.524 82.6668 84.1906 87.8096 51.4287 84.1906C52.6146 82.6445 52.3811 77.7144 52.3811 77.7144Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M48.2099 84.584C46.1156 84.584 27.1095 84.584 27.1095 84.584C24.7615 84.584 24 86.1529 24 88.2449C24 90.3369 24.3634 94.4358 24.7615 97.2417C25.2366 100.592 26.2846 100.706 28.7594 100.706C31.2345 100.706 46.655 100.772 48.8128 100.772C50.9705 100.772 51.4781 98.6147 51.6684 96.4573C51.8589 94.3002 52.0811 90.4021 52.208 87.6566C52.3347 84.911 50.304 84.584 48.2099 84.584Z"
            fill="#FF815E"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M73.4422 13.4468C74.6881 15.4468 75.5694 20.8948 72.2965 21.0476C69.5589 21.1753 68.9723 18.673 68.3103 15.8489L68.3103 15.8488C68.1528 15.1769 67.991 14.4867 67.7949 13.8095C69.2534 13.054 73.4422 13.4468 73.4422 13.4468ZM59.9962 16.0387L59.9962 16.0387C60.6885 18.5218 61.3119 20.7578 63.3739 20.2129C65.6769 19.6047 65.559 16.5811 64.623 14.1841C62.5596 14.8573 59.8369 15.4708 59.8369 15.4708C59.8908 15.6608 59.9437 15.8504 59.9962 16.0387L59.9962 16.0387ZM76.5156 14.4418C76.6452 14.8243 76.7533 15.2689 76.8658 15.7319C77.2664 17.3799 77.7236 19.2607 79.4108 19.4026C81.6457 19.5906 81.2577 16.5264 80.2508 14.5123C78.6453 14.5321 76.5156 14.4418 76.5156 14.4418ZM75.4148 32.5964C73.7813 32.8467 70.9605 32.75 69.46 32.6538L69.3322 32.6455C67.8824 32.5514 66.5765 32.4667 66.0367 33.7721C65.6777 34.6399 65.5908 39.5896 72.3219 39.7444C79.339 39.906 79.472 33.881 78.5973 32.9591C77.8631 32.1851 76.8073 32.3634 75.8042 32.5327L75.804 32.5327C75.6731 32.5548 75.5431 32.5768 75.4148 32.5964ZM87.4668 32.523C86.7647 29.6283 88.6982 28.2039 91.5832 28.4656C93.0197 31.1219 93.0998 35.1195 93.1016 35.2115L93.1017 35.2131C91.368 35.3649 88.2015 35.5534 87.4668 32.523Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M87.1123 84.3858C87.8266 85.7323 89.8919 86.7841 91.4401 85.9265L91.9415 83.4873C90.5588 83.6269 87.1123 84.3858 87.1123 84.3858ZM59.8086 85.5232C59.8086 85.5232 65.4219 85.5256 71.8086 85.6184C78.8379 85.7205 81.9616 85.3203 81.9616 85.3203C79.7315 89.2896 64.6604 91.2702 59.8086 85.5232ZM87.3278 88.3546C85.411 88.8268 84.2882 90.1159 84.3947 91.154C84.5013 92.1923 86.837 93.4373 88.2945 92.63L88.0225 91.2561L90.0354 87.9434L90.0346 87.9433C90.0061 87.9415 89.2094 87.8914 87.3278 88.3546ZM84.2157 98.0687C84.2861 100.598 87.5273 99.9817 87.5273 99.9817C87.5273 99.9817 88.6014 97.692 88.2774 95.4028C86.2478 95.8495 84.1684 96.3758 84.2157 98.0687ZM52.0499 93.6776L52.1592 89.4022C54.0758 89.8744 54.9131 91.1635 54.8066 92.2016C54.7001 93.2399 53.5072 94.4848 52.0499 93.6776ZM51.5821 96.9673C51.5821 96.9673 52.0506 98.4723 49.96 101.124C49.96 101.124 53.1482 102.49 53.3668 99.2115C53.4476 97.9985 52.6853 97.3823 51.5821 96.9673ZM56.0887 84.9571C55.9124 87.2102 53.595 87.8315 52.0468 86.974L51.2598 84.0586C52.6424 84.1982 56.0887 84.9571 56.0887 84.9571Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M53.016 36.1902C53.016 36.1902 54.3493 38.3489 54.5398 40.5077C54.7303 42.6664 54.9844 50.2854 54.9844 50.2854C54.9844 50.2854 55.0735 53.2515 52.0638 53.6506L50.4129 51.9997C50.4129 51.9997 52.2541 51.9997 52.3809 49.6506C52.508 47.3012 52 41.9045 51.7461 39.7458C51.4922 37.587 50.6032 36.6982 49.7779 36.1902C49.7779 36.1902 51.1747 36.0632 51.4922 33.4601C51.8097 30.8569 52.3811 22.603 52.3811 22.603C52.3811 22.603 52.0002 20.6346 49.9049 20.3807C47.8097 20.1268 43.2383 19.9997 43.2383 19.9997L43.8731 17.3965C43.8731 17.3965 48.3177 17.4601 50.6669 17.714C53.016 17.9679 54.6032 18.9839 54.9208 21.1426C55.2383 23.3012 54.2859 32.5712 54.2859 32.5712C54.2859 32.5712 53.6509 34.8569 53.016 36.1902ZM25.2861 17.7176C25.3018 17.7165 25.3175 17.7153 25.3332 17.7141C27.0475 17.5871 32.3174 17.6507 32.3174 17.6507L33.0793 20.2537C33.0793 20.2537 28.9523 20.1903 26.857 20.1903C24.7618 20.1903 23.8729 21.2697 23.7458 23.3014C23.6189 25.3332 24.1268 31.1109 24.6348 33.2061C25.1428 35.3014 26.5395 35.8728 26.5395 35.8728C26.5395 35.8728 24.9523 37.5236 24.7618 39.3014C24.5713 41.0793 23.8094 48.6983 23.8094 48.6983C23.8094 48.6983 24.6984 51.7459 26.0317 52.1903L24.0633 53.5871C22.4759 53.0793 21.1426 51.9998 21.0791 49.3966C21.0157 46.7935 21.3332 41.3966 22.1586 38.7299C22.9841 36.0633 23.238 35.9998 23.238 35.9998C23.238 35.9998 21.9047 33.2061 21.6508 29.968C21.6133 29.4905 21.5676 28.9716 21.5197 28.4279C21.2427 25.2849 20.8929 21.3156 21.6508 19.7459C22.5313 17.9215 23.5991 17.8425 25.2861 17.7176Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M42.5668 18.988C42.1455 18.6482 41.4866 18.7661 41.095 19.2517C40.7034 19.737 40.7276 20.4061 41.1489 20.7459C41.57 21.0857 42.2291 20.9677 42.6207 20.4823C43.0121 19.9968 42.9879 19.328 42.5668 18.988ZM38.48 20.2438C37.7985 20.2632 37.2549 20.7173 37.2658 21.2586C37.2768 21.8 37.838 22.223 38.5195 22.2038C39.201 22.1845 39.7446 21.7303 39.7338 21.1889C39.7229 20.6478 39.1618 20.2247 38.48 20.2438ZM33.7878 19.3871C34.0729 18.9507 34.7519 18.8848 35.3043 19.2395C35.8567 19.5941 36.0733 20.2357 35.7881 20.672C35.503 21.1084 34.8239 21.1745 34.2716 20.8197C33.7192 20.4648 33.5026 19.8235 33.7878 19.3871Z"
            fill="#F0ABA7"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M43.024 26.8888C41.7015 26.901 40.5312 26.9187 39.9084 26.9433C39.5406 26.9576 39.2307 26.6709 39.2164 26.3031C39.2017 25.9351 39.4884 25.6252 39.8564 25.6107C40.513 25.5854 41.6825 25.5678 43.0118 25.5557C44.3398 25.5435 45.8229 25.5362 47.0878 25.5322C47.456 25.5311 47.7552 25.8286 47.7566 26.1968C47.7577 26.565 47.4602 26.8642 47.0918 26.8656C45.829 26.8694 44.3478 26.8768 43.024 26.8888ZM47.2784 28.9609C47.6466 28.9598 47.946 29.2573 47.9472 29.6255C47.9483 29.9937 47.6508 30.2929 47.2824 30.2943C46.0196 30.2981 44.5384 30.3055 43.2148 30.3175C41.8921 30.3297 40.7218 30.3474 40.099 30.3718V30.372C39.7312 30.3865 39.4211 30.0998 39.4068 29.7318C39.3923 29.3638 39.679 29.0539 40.047 29.0394C40.7037 29.0141 41.8731 28.9966 43.2024 28.9844C44.5304 28.9722 46.0137 28.9649 47.2784 28.9609ZM28.0992 41.4194C28.722 41.3948 29.8923 41.3771 31.215 41.3649C32.5386 41.3529 34.0197 41.3454 35.2826 41.3416C35.651 41.3405 35.9483 41.0411 35.9472 40.6729C35.946 40.3047 35.6466 40.0072 35.2784 40.0083C34.0135 40.0123 32.5304 40.0195 31.2024 40.0317C29.8731 40.0439 28.7037 40.0614 28.047 40.0868C27.679 40.1013 27.3923 40.4112 27.4068 40.7792C27.4213 41.1472 27.7312 41.4336 28.0992 41.4194ZM31.215 44.7936C29.8923 44.8058 28.722 44.8235 28.0992 44.8481C27.7312 44.8623 27.4213 44.5759 27.4068 44.2079C27.3923 43.8399 27.679 43.53 28.047 43.5155C28.7037 43.4902 29.8731 43.4726 31.2024 43.4604C32.5304 43.4483 34.0135 43.441 35.2784 43.437C35.6466 43.4359 35.946 43.7334 35.9472 44.1016C35.9483 44.4698 35.651 44.7692 35.2826 44.7703C34.0197 44.7742 32.5386 44.7816 31.215 44.7936ZM27.9087 48.6576C28.5478 48.6324 28.9986 48.6166 29.6072 48.6059C30.2156 48.5951 30.9834 48.5894 32.2461 48.5856C32.6144 48.5844 32.9118 48.285 32.9106 47.9168C32.9095 47.5484 32.6101 47.2511 32.2419 47.2522C30.9767 47.2562 30.2038 47.2619 29.5834 47.2728C28.963 47.2837 28.4971 47.3002 27.8565 47.325C27.4885 47.3395 27.2019 47.6494 27.2163 48.0174C27.2308 48.3852 27.5407 48.6719 27.9087 48.6576ZM43.2026 56.2221C44.5308 56.2101 46.0136 56.2032 47.2784 56.1992C47.6466 56.1981 47.946 56.4956 47.9471 56.8638C47.9483 57.232 47.651 57.5314 47.2826 57.5326C46.0197 57.5364 44.5386 57.5432 43.2146 57.5552C41.8921 57.567 40.7218 57.5842 40.0984 57.608C39.7304 57.6221 39.4209 57.3352 39.4068 56.9672C39.3927 56.5994 39.6795 56.2897 40.0475 56.2758C40.7037 56.2508 41.8732 56.2341 43.2026 56.2221ZM47.9471 60.2027C47.9462 59.8345 47.6466 59.5369 47.2784 59.5381C46.0136 59.5421 44.5308 59.5489 43.2026 59.5608C41.8732 59.5728 40.7037 59.5897 40.0475 59.6147C39.6795 59.6286 39.3927 59.9383 39.4068 60.3063C39.4209 60.6741 39.7304 60.9611 40.0984 60.9468C40.7218 60.923 41.8921 60.9059 43.2146 60.8941C44.5386 60.8821 46.0195 60.8752 47.2826 60.8714C47.6506 60.8701 47.9483 60.5707 47.9471 60.2027ZM40.1434 63.0457C40.7842 63.0213 41.2497 63.0053 41.8701 62.9946C42.4903 62.9839 43.2632 62.9784 44.5282 62.9746C44.8964 62.9735 45.1958 63.271 45.1969 63.6392C45.1981 64.0074 44.9004 64.3068 44.5322 64.3079C43.2695 64.3118 42.5017 64.3171 41.8927 64.3278C41.2844 64.3382 40.8329 64.3537 40.1939 64.3778C39.8261 64.3919 39.5166 64.1051 39.5025 63.7371C39.4886 63.3691 39.7756 63.0596 40.1434 63.0457ZM28.9562 75.6101C29.5791 75.5857 30.7494 75.568 32.0719 75.5558C33.3957 75.5436 34.8768 75.5364 36.1397 75.5326C36.508 75.5314 36.8056 75.232 36.8044 74.8638C36.8033 74.4954 36.5039 74.1981 36.1357 74.1992C34.8707 74.2032 33.3877 74.2103 32.0597 74.2225C30.7303 74.2348 29.5608 74.2522 28.9042 74.2779C28.5362 74.2922 28.2496 74.6021 28.2642 74.9701C28.2785 75.3379 28.5884 75.6246 28.9562 75.6101ZM32.2501 77.6507C33.5781 77.6385 35.0613 77.6314 36.3261 77.6274C36.6943 77.6263 36.9937 77.9238 36.9949 78.292C36.996 78.6602 36.6987 78.9596 36.3303 78.9608C35.0674 78.9646 33.5863 78.9718 32.2627 78.984C30.94 78.9962 29.7699 79.0139 29.1469 79.0383C28.7789 79.053 28.4689 78.7663 28.4547 78.3983C28.44 78.0303 28.7267 77.7204 29.0947 77.7061C29.7514 77.6804 30.9208 77.6631 32.2501 77.6507ZM46.2315 90.3896C44.9666 90.3937 43.4835 90.4009 42.1555 90.4131C40.8262 90.4253 39.6567 90.4428 39.0001 90.4683C38.6321 90.4826 38.3454 90.7925 38.3599 91.1605C38.3744 91.5285 38.6841 91.815 39.0521 91.8005C39.6752 91.7761 40.8453 91.7584 42.1677 91.7462C43.4915 91.734 44.9727 91.7268 46.2357 91.723C46.6041 91.7218 46.9014 91.4224 46.9003 91.0542C46.8992 90.686 46.5997 90.3885 46.2315 90.3896ZM39.1904 93.8966C40.0524 93.8629 41.8075 93.8433 43.6351 93.8311C44.0035 93.8288 44.3039 94.1252 44.3064 94.4934C44.3086 94.8615 44.0121 95.1619 43.6441 95.1644C41.8237 95.1764 40.0629 95.1966 39.2425 95.2288C38.8745 95.2434 38.5646 94.9568 38.5504 94.5888C38.5359 94.2208 38.8225 93.9109 39.1904 93.8966Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M94.1417 49.6958C96.7605 52.1849 99.4917 54.781 100.651 58.1658C101.493 60.625 101.459 63.2105 100.696 65.6926C100.1 67.6313 99.3697 69.7612 98.1482 71.4702C99.0857 72.6563 98.8063 74.5064 98.1949 75.8113C97.5036 77.2864 95.9453 78.2919 94.3575 78.0936C94.3244 78.7641 94.2867 79.434 94.2391 80.1035C94.2279 80.2595 94.2219 80.4263 94.2156 80.5989C94.1896 81.3137 94.16 82.1272 93.7537 82.6749C93.4511 83.0831 92.992 83.3852 92.4749 83.621C92.5575 85.4784 91.612 87.5372 90.6612 89.0184C90.1642 89.7928 89.5617 90.6995 88.8149 91.2995C89.257 92.3412 89.3087 93.5944 89.3538 94.6891L89.357 94.765C89.42 96.2888 89.2053 97.7258 88.8935 99.214C88.7945 99.6879 88.6926 100.162 88.5775 100.632C88.5355 100.804 88.4788 100.985 88.4209 101.17C88.2927 101.578 88.1587 102.006 88.1648 102.398C88.171 102.798 88.2949 103.172 88.4189 103.546C88.5311 103.884 88.6434 104.223 88.6688 104.581C88.7716 106.031 87.3124 106.82 86.081 107.04C83.6408 107.474 79.7781 107.012 79.0612 104.171C78.7511 102.943 78.8296 101.694 78.9081 100.445C78.9418 99.9102 78.9754 99.3753 78.9785 98.842C78.9884 97.138 78.9438 95.3785 78.4552 93.7334C78.4253 93.6326 78.4208 93.542 78.4347 93.4612C78.0987 93.5008 77.7642 93.5363 77.4352 93.5712C77.153 93.6012 76.8749 93.6307 76.6032 93.662C74.6655 93.886 72.7185 94.029 70.7682 94.0768C68.633 94.1292 66.4953 94.0946 64.3655 93.9231L64.3413 93.9212H64.3412C62.5313 93.7759 60.664 93.626 58.8749 93.2444C58.7425 95.2683 58.5478 97.3323 58.0137 99.2795C57.9355 99.5648 57.8546 99.8465 57.7743 100.126L57.7743 100.126C57.4005 101.428 57.0387 102.688 57.0122 104.074C56.9916 105.148 56.6427 106.281 55.6792 106.883C54.8336 107.411 53.7331 107.435 52.7514 107.457L52.6023 107.46C51.5945 107.484 50.4895 107.506 49.5189 107.188C48.5596 106.874 48.008 105.993 47.9354 104.993C47.8957 104.446 47.9162 103.906 47.9369 103.36C47.9401 103.275 47.9433 103.19 47.9463 103.105C47.9639 102.608 47.8233 102.153 47.6815 101.695L47.6815 101.694C47.6343 101.542 47.587 101.389 47.5453 101.233C47.5031 101.234 47.4609 101.235 47.4188 101.236C47.3768 101.237 47.3349 101.238 47.293 101.238C47.2496 101.239 47.2044 101.244 47.1589 101.249L47.1588 101.249C47.0929 101.256 47.0266 101.264 46.9648 101.258C46.916 101.253 46.4566 101.192 46.7375 101.19C45.4665 101.201 44.1952 101.203 42.9242 101.204C39.7507 101.205 36.5772 101.193 33.4038 101.166C32.8765 101.162 32.3402 101.171 31.8004 101.18C30.6312 101.199 29.4458 101.219 28.3006 101.103C28.2023 101.157 28.0813 101.183 27.9372 101.164L27.8176 101.149C26.9413 101.037 26.1446 100.936 25.4543 100.31C24.8429 99.7561 24.541 98.9907 24.3505 98.2075C23.9114 96.4023 23.7558 94.522 23.6027 92.6721L23.5829 92.4324C23.5375 91.8857 23.4955 91.3388 23.4536 90.7919C23.4214 90.3722 23.3892 89.9525 23.3554 89.5328C23.3385 89.3233 23.3103 89.1061 23.2817 88.8861C23.2199 88.4109 23.1564 87.9227 23.2013 87.47C23.3204 86.2707 23.8987 85.2298 24.7899 84.6033C24.6042 84.4846 24.4263 84.3439 24.2594 84.1732C23.1305 83.0197 23.2006 81.6851 23.2764 80.2387L23.2764 80.2386C23.2833 80.1085 23.2901 79.9775 23.2962 79.8456C23.3274 79.1645 23.3506 78.483 23.3739 77.8015C23.4121 76.6814 23.4503 75.5612 23.5238 74.4425C23.5387 74.2161 23.5507 73.9804 23.5631 73.7389C23.6283 72.4626 23.7018 71.0233 24.2469 69.9203C24.6332 69.1387 25.1933 68.6414 25.8749 68.3412C25.7307 68.2544 25.5901 68.1513 25.4539 68.0279C24.8425 67.474 24.5406 66.7086 24.3501 65.9252C23.9105 64.1182 23.7549 62.2358 23.6018 60.3841L23.5825 60.1505C23.5372 59.6048 23.4953 59.0588 23.4534 58.5128C23.4211 58.0922 23.3889 57.6715 23.3551 57.2511C23.3381 57.0415 23.3099 56.8242 23.2813 56.6041C23.2195 56.129 23.156 55.6407 23.201 55.1881C23.2484 54.7111 23.3692 54.2597 23.5522 53.8486C20.2566 52.8755 20.5459 48.9731 20.7698 45.9528C20.7868 45.7235 20.8035 45.4994 20.8181 45.282L20.8317 45.0802C21.0407 41.9699 21.2568 38.7554 22.7817 36.0041C21.6589 34.0768 21.3488 31.9622 21.108 29.7307C20.8373 27.2231 20.6063 24.6515 20.6307 22.1262C20.6526 19.8338 21.6004 17.6524 24.1362 17.3279C26.2879 17.0524 28.4928 17.0296 30.6733 17.007L30.6735 17.007C31.1011 17.0026 31.5278 16.9982 31.953 16.9919C31.9692 16.8643 31.9905 16.7364 32.0223 16.6084C32.3954 15.1071 33.7292 14.2246 35.1191 13.7576C37.8 12.8568 44.0945 12.7488 44.2556 16.8195L44.2721 16.8175C44.297 16.8143 44.3219 16.8112 44.3488 16.8115C46.1882 16.8332 48.0297 16.8603 49.8669 16.962C50.0625 16.9727 50.2648 16.9804 50.4703 16.9881C50.5745 16.9921 50.6795 16.996 50.785 17.0004C50.7781 16.9629 50.772 16.9246 50.7712 16.8835L50.7694 16.791C50.7359 15.093 50.6342 9.94689 53.4688 10.993C54.7137 11.4524 55.885 12.2342 56.8985 13.0803C57.5636 13.6357 58.3093 14.2713 58.7625 15.0465C62.0431 13.7787 65.529 13.0804 69.0396 13.0113C72.7705 12.9374 76.416 13.4711 80.0596 14.2065C80.9069 13.0576 82.0198 12.0568 83.2452 11.3368C83.984 10.9025 85.1711 10.2637 85.9893 10.8764C86.7896 11.476 87.0545 12.9918 87.2206 13.9418L87.2413 14.0604C87.52 15.6433 87.6099 17.2871 87.26 18.8639C89.0951 21.7151 90.8132 24.6795 91.9842 27.8696C92.16 28.3483 92.3255 28.8361 92.4796 29.3294C93.3152 29.2515 94.1575 29.2248 94.9612 29.2035C95.6113 29.1862 95.6133 30.2107 95.0057 30.3199C94.3021 30.446 93.5813 30.5639 92.8564 30.6625C93.0074 31.2606 93.1339 31.8648 93.2286 32.4726C93.7478 32.4961 94.2619 32.5372 94.756 32.5858C95.4499 32.654 95.3259 33.634 94.656 33.6416C94.2647 33.6458 93.8654 33.6632 93.463 33.6806L93.3737 33.6844C93.4932 35.1686 93.3958 36.6593 92.9684 38.1096C92.449 39.8711 91.5817 41.4441 90.4672 42.8161C91.1227 43.1054 91.5812 43.7926 91.701 44.554C91.8191 45.3054 91.805 46.0787 91.7092 46.8325C91.6897 46.9845 91.6749 47.1441 91.6608 47.306C91.7177 47.337 91.7735 47.3755 91.8255 47.4296C92.5551 48.1877 93.3429 48.9365 94.1411 49.6952L94.1412 49.6953L94.1413 49.6954L94.1413 49.6954L94.1414 49.6955L94.1415 49.6956L94.1415 49.6956L94.1416 49.6957L94.1417 49.6958ZM72.4851 19.6731C72.4925 20.2234 71.651 20.2136 71.5494 19.7106C71.389 18.9167 71.2927 18.1101 71.1964 17.3049L71.1964 17.3044L71.1963 17.3039L71.1963 17.3034L71.1962 17.303L71.1962 17.3026C71.1684 17.0701 71.1406 16.8379 71.1114 16.606C71.0323 15.9792 71.9329 15.8213 72.075 16.4359C72.3209 17.5001 72.4706 18.5809 72.4851 19.6731ZM75.9829 19.7801C76.1509 20.3054 77.0415 20.0161 76.9067 19.485C76.6368 18.4231 76.3554 17.3663 75.8674 16.3799C75.5783 15.7963 74.6745 16.2223 74.953 16.814C75.2961 17.5427 75.5316 18.3137 75.7667 19.0834L75.7667 19.0834L75.7668 19.0837C75.8379 19.3163 75.9089 19.5489 75.9829 19.7801ZM80.9002 27.6907C80.908 27.7946 80.9108 27.6951 80.9134 27.604L80.9134 27.6037V27.6035C80.9147 27.556 80.916 27.5109 80.9179 27.4981C80.9457 27.3029 81.0059 27.117 81.0711 26.9313C81.2513 26.4172 81.589 26.0239 82.1385 25.9231C83.0967 25.7474 83.4133 26.9859 83.6107 27.7581C83.6322 27.8422 83.6523 27.9208 83.6716 27.9915C83.8141 28.512 84.6694 28.5669 84.6846 27.9509C84.7206 26.4928 83.8055 24.6313 82.1212 24.7543C80.6151 24.8644 79.7549 26.3435 79.6734 27.7395C79.6212 28.6332 80.9674 28.5978 80.9002 27.6907ZM60.5164 28.3097C60.5242 28.4137 60.527 28.3142 60.5296 28.2231C60.531 28.1754 60.5322 28.13 60.5341 28.1173C60.5619 27.922 60.6221 27.7361 60.6873 27.5504C60.8675 27.0363 61.2052 26.643 61.7547 26.5422C62.713 26.3665 63.0295 27.6051 63.2269 28.3772L63.2269 28.3773L63.227 28.3776L63.2273 28.3789C63.2487 28.4624 63.2686 28.5405 63.2878 28.6106C63.4303 29.1312 64.2856 29.186 64.3008 28.57C64.3368 27.1119 63.4218 25.2504 61.7374 25.3735C60.2313 25.4834 59.3711 26.9626 59.2896 28.3586C59.2374 29.2523 60.5837 29.2169 60.5164 28.3097ZM72.6099 36.2341C71.3724 38.0185 67.7598 37.9349 67.1966 35.4307C67.0728 34.8797 67.9434 34.5938 68.1484 35.1267C68.5049 36.0526 69.2916 36.5296 70.2886 36.2991C71.2453 36.0781 71.6663 35.4835 71.9981 34.612C72.0366 34.5109 72.0924 34.436 72.1571 34.381L72.1605 34.3594L72.1651 34.3277C72.1701 34.2935 72.175 34.2591 72.1827 34.2238C72.3162 33.6048 73.235 33.6532 73.1867 34.3189C73.1173 35.2728 73.7343 36.0854 74.7133 36.2105C75.791 36.3482 76.2977 35.7791 76.8284 34.9309C77.099 34.4981 77.9057 34.7585 77.7939 35.2863C77.2507 37.8496 73.8863 37.8541 72.6099 36.2341ZM67.0724 19.9646C67.064 20.5829 67.9872 20.6872 68.0392 20.056C68.1379 18.8615 68.0143 17.6802 67.8844 16.4928C67.8131 15.8421 66.823 16.0244 66.8878 16.6686C66.9981 17.7655 67.0872 18.8612 67.0724 19.9646ZM52.3445 12.9394C52.3601 12.8723 52.4077 12.7416 52.4594 12.5996C52.5564 12.333 52.6679 12.0267 52.6087 12.0284C52.9143 12.0203 53.2382 12.1753 53.5214 12.3107L53.5214 12.3108L53.5215 12.3108L53.5217 12.3109L53.5222 12.3111C53.5689 12.3335 53.6146 12.3553 53.6588 12.3758C55.3967 13.1792 57.1506 14.5396 58.2112 16.1396C58.3759 16.388 58.7211 16.3485 58.9255 16.1729C59.8144 15.9973 60.6859 15.7059 61.5553 15.4151C62.1575 15.2138 62.7588 15.0127 63.3643 14.8506C65.2971 14.3333 67.2824 14.1823 69.2763 14.1362C72.858 14.0533 76.4062 14.543 79.9169 15.2038C80.1624 15.4874 80.6382 15.5834 80.9123 15.183C81.5577 14.2394 82.3883 13.46 83.2986 12.775C83.6207 12.5324 85.0268 11.5577 85.3034 11.9106C85.7593 12.4923 85.9183 13.4372 86.0472 14.203C86.0667 14.3192 86.0856 14.4313 86.1047 14.5373C86.3319 15.8023 86.3468 17.0649 86.243 18.3356C86.1131 18.4647 86.0508 18.652 86.1605 18.8337L86.1971 18.895C86.2015 19.0764 86.3032 19.2196 86.4436 19.3066C88.0232 21.9436 89.5249 24.6329 90.6777 27.4876C90.9375 28.1314 91.178 28.7937 91.3914 29.468C90.8771 29.5514 90.3718 29.6602 89.8895 29.8131C89.3533 29.9836 89.2455 30.9314 89.9335 30.9146C90.538 30.9 91.1514 30.8562 91.7657 30.7933C91.9022 31.3421 92.0165 31.8962 92.1013 32.4535C91.5464 32.4628 90.9971 32.5015 90.471 32.5845C89.866 32.6802 89.9457 33.5329 90.5125 33.62C91.0746 33.7064 91.6558 33.7251 92.2405 33.7186C92.3243 34.9645 92.2457 36.2141 91.9382 37.4364C90.3085 43.916 83.8152 47.016 77.7805 48.1133C77.6819 48.1312 77.6032 48.1682 77.5394 48.216C74.4685 48.6788 71.4154 49.0251 68.2881 48.9922C66.1333 48.9695 63.9818 48.772 61.8561 48.4177C59.6819 48.055 57.6441 47.363 55.5801 46.6177C55.5354 46.1352 55.4918 45.6584 55.4691 45.1965C55.4583 44.9772 55.448 44.7582 55.4377 44.5393L55.4377 44.5388L55.4377 44.5383L55.4376 44.5378L55.4376 44.5373L55.4376 44.5361L55.4375 44.5349V44.5348C55.3013 41.6355 55.1673 38.7823 53.9057 36.1185C55.3195 33.1656 55.4319 29.7742 55.5414 26.4708C55.5753 25.4488 55.6089 24.4351 55.6807 23.4455C55.7742 22.1558 55.8299 21 55.3245 19.7746C54.8998 18.744 53.902 17.6771 52.8361 17.3038C52.5744 17.2122 52.2967 17.1514 52.0121 17.107C52.0167 17.0731 52.0211 17.0392 52.0201 17.0011C51.9881 15.6514 52.0373 14.2594 52.3445 12.9394ZM44.8104 18.0636L44.2713 18.0566C44.2353 18.5681 44.1305 19.0523 43.9639 19.5031L44.0909 19.5031H44.0912C45.4019 19.5033 46.7124 19.5035 48.0227 19.5147C49.7279 19.5294 51.5294 19.5511 52.5218 21.2001C53.1737 22.2837 53.0829 23.4842 52.9921 24.6853L52.992 24.6854C52.9693 24.9859 52.9466 25.2866 52.9355 25.5854C52.9207 25.985 52.9074 26.3849 52.8941 26.7848L52.8941 26.7859L52.894 26.7862V26.7862V26.7863V26.7863V26.7863V26.7864V26.7864V26.7864V26.7865V26.7865C52.8453 28.2521 52.7966 29.7185 52.6724 31.1795C52.6587 31.3407 52.6465 31.5105 52.6338 31.6863L52.6337 31.687L52.6337 31.6876L52.6336 31.6881L52.6336 31.6884L52.6335 31.6894L52.6334 31.6909L52.6334 31.6919L52.6333 31.6927C52.5411 32.9692 52.4262 34.5612 51.5869 35.4974C51.3692 35.7405 51.1263 35.9342 50.8679 36.0953C51.6812 36.6414 52.1692 37.5252 52.3783 38.6115C52.7031 40.2978 52.7731 42.0331 52.8423 43.7463L52.85 43.9365C52.8674 44.3668 52.8807 44.7977 52.8939 45.2286C52.9274 46.3176 52.9609 47.4071 53.0622 48.4911C53.1991 49.9574 52.598 51.4582 51.3566 52.1957C51.5905 52.3286 51.813 52.4938 52.0187 52.7041C52.0873 52.7744 52.1502 52.8456 52.2103 52.9172C52.6738 52.7938 53.0608 52.5483 53.4121 52.1974C54.7554 50.856 54.6013 49.1339 54.4481 47.4227C54.4214 47.1247 54.3948 46.827 54.3761 46.5317C54.2488 44.5239 54.1117 42.5018 53.8439 40.5037C53.6439 39.0119 53.2907 37.7612 52.6182 36.4269C52.4203 36.0346 52.7029 35.5572 52.9348 35.1653L52.9348 35.1652C52.9943 35.0646 53.0505 34.9697 53.0943 34.8833C53.3728 34.3347 53.5096 33.7027 53.6166 33.1014C54.1837 29.9113 54.3246 26.5717 54.4618 23.3175C54.4757 22.9896 54.4895 22.6625 54.5037 22.3365C54.5879 20.3985 53.5351 18.5584 51.5176 18.35C49.2941 18.1204 47.0458 18.0919 44.8105 18.0636H44.8104ZM41.1347 51.452H41.134H41.1339H41.1338H41.1337H41.1337H41.1336H41.1335H41.1334H41.1333C40.6769 51.4513 40.2204 51.4505 39.764 51.45C36.5281 51.4463 33.292 51.437 30.0561 51.4278L29.7495 51.4269L29.1962 51.4254C28.3982 51.4231 27.6001 51.4209 26.8021 51.4202C25.8501 51.4193 25.1958 50.9623 24.7427 50.1263C24.3862 49.4692 24.4624 48.753 24.5379 48.0443C24.5526 47.9063 24.5672 47.7685 24.5787 47.6315C24.6273 47.05 24.6723 46.4682 24.7172 45.8866L24.7172 45.8865L24.7173 45.8863C24.8394 44.3071 24.9615 42.7283 25.1558 41.1555C25.2726 40.2107 25.403 39.2526 25.6798 38.3393C26.0459 37.1307 26.8943 36.8991 27.9924 36.75C28.3226 36.7701 28.6543 36.7757 28.9828 36.7812H28.9829L29.1249 36.7837C31.5266 36.8257 33.9295 36.8264 36.3316 36.827H36.3317H36.3317H36.3317H36.3318H36.3318H36.3318H36.3319H36.3319H36.3319L37.1594 36.8273C40.1381 36.8286 43.1168 36.8241 46.0952 36.7928C46.3328 36.7904 46.5767 36.792 46.8242 36.7936C47.3807 36.7974 47.9557 36.8012 48.5194 36.7589L48.5505 36.7615L48.5506 36.7615L48.5768 36.7637L48.5979 36.7656C49.2248 36.8231 49.8293 36.893 50.3495 37.2751C50.9207 37.6948 51.0572 38.548 51.1642 39.2172L51.1728 39.271L51.1874 39.3614C51.4624 41.0338 51.5226 42.7477 51.5821 44.4427L51.5821 44.4445C51.5882 44.6157 51.5942 44.7867 51.6004 44.9574C51.6079 45.1638 51.6152 45.3702 51.6226 45.5766L51.6226 45.5777L51.6226 45.5789L51.6227 45.58L51.6227 45.5812L51.6228 45.5823L51.6228 45.5834L51.6228 45.5838C51.6437 46.1726 51.6646 46.7614 51.6905 47.3502C51.7003 47.572 51.7201 47.7965 51.7401 48.0219C51.7823 48.4986 51.8249 48.979 51.7728 49.4458C51.5779 51.1846 49.9061 51.4128 48.511 51.43C46.0525 51.4602 43.5935 51.4561 41.1347 51.452ZM43.2145 17.0121C42.1714 13.9873 37.3977 14.0696 34.9901 15.1545C34.0135 15.5943 33.1211 16.3254 33.1461 17.4903C33.1676 18.4976 33.7682 19.4477 34.455 20.1444C35.8718 21.5825 37.9181 21.9721 39.8668 21.5374C42.164 21.0252 43.4089 19.3473 43.2215 17.0271C43.2205 17.0246 43.2193 17.0223 43.2181 17.02L43.2181 17.02L43.2181 17.02C43.2168 17.0174 43.2155 17.0149 43.2145 17.0121ZM33.0027 20.6688C33.101 20.6681 33.1853 20.6433 33.2589 20.6048C34.8933 22.5688 37.4198 23.157 39.901 22.7063C41.384 22.4368 42.5579 21.7176 43.3168 20.6978C43.3867 20.729 43.4684 20.7477 43.5642 20.7477C44.8453 20.7492 46.1265 20.7517 47.4076 20.7601C47.6237 20.7615 47.8463 20.7568 48.0718 20.7521C48.7472 20.738 49.4494 20.7233 50.085 20.8698C51.9317 21.296 51.8184 23.0646 51.7226 24.5601V24.5601V24.5601V24.5602C51.7109 24.7436 51.6994 24.9229 51.6918 25.0951C51.6661 25.6794 51.6447 26.2638 51.6234 26.8483L51.6234 26.8484L51.6234 26.8485L51.6234 26.8486L51.6234 26.8487L51.6234 26.8488L51.6234 26.8489L51.6234 26.849V26.849V26.849V26.8491C51.5776 28.1032 51.5318 29.3572 51.4427 30.6094C51.43 30.788 51.4205 30.9852 51.4104 31.1946C51.3446 32.5604 51.2536 34.4486 50.0888 35.1389C49.6324 35.4094 49.0745 35.4717 48.5751 35.4871C48.4228 35.4847 48.2703 35.4853 48.1175 35.4859C47.9511 35.4866 47.7844 35.4872 47.6173 35.4841L46.4764 35.4683C45.8413 35.4637 45.2061 35.4614 44.5709 35.4597C41.1223 35.4505 37.6733 35.4639 34.225 35.4896C33.6144 35.4942 32.9933 35.4832 32.3681 35.4721C31.3155 35.4535 30.2513 35.4347 29.2065 35.4898L29.1785 35.4894L29.1505 35.489C28.6699 35.4801 28.1996 35.4604 27.7221 35.41C26.8775 35.3204 26.268 35.1063 25.861 34.2881C25.6423 33.8491 25.5486 33.3395 25.4594 32.8549L25.4594 32.8549L25.4594 32.8548L25.4594 32.8547C25.4478 32.7917 25.4363 32.7292 25.4246 32.6673C25.0248 30.5516 24.8468 28.4011 24.669 26.2541L24.669 26.2541C24.6093 25.5335 24.5497 24.8134 24.4817 24.0951C24.3143 22.3256 24.9825 20.726 26.9724 20.714C28.3596 20.7056 29.7471 20.6945 31.1346 20.6835C31.7573 20.6785 32.38 20.6735 33.0027 20.6688ZM21.9101 49.3885C21.9631 51.0504 22.5526 52.4304 24.2968 52.7409C24.4968 52.5352 24.7221 52.3569 24.9675 52.2066C23.5863 51.3264 23.1136 49.7422 23.2698 48.0944C23.3475 47.2728 23.41 46.4497 23.4724 45.6267C23.536 44.7887 23.5995 43.9507 23.6793 43.114C23.6946 42.9529 23.7097 42.7911 23.7248 42.6288L23.7248 42.6286C23.8674 41.095 24.0144 39.5143 24.4616 38.044C24.6966 37.2702 25.1016 36.5796 25.7652 36.0961C24.937 35.5041 24.485 34.5441 24.2482 33.4363C23.7244 30.9853 23.5737 28.4564 23.4238 25.9425C23.3741 25.1083 23.3245 24.2758 23.2614 23.4483C23.1204 21.6028 24.6233 19.6026 26.5498 19.611C28.0836 19.6178 29.6174 19.6186 31.1513 19.6193H31.1514H31.1514H31.1514H31.1515H31.1515H31.1515C31.6257 19.6195 32.0998 19.6197 32.574 19.6201C32.2917 19.1249 32.077 18.5923 31.981 18.0405C31.5696 18.0526 31.157 18.0629 30.7437 18.0733H30.7437H30.7437H30.7437H30.7437H30.7436H30.7436C28.6905 18.1249 26.6195 18.177 24.5894 18.4356C23.586 18.5634 22.7153 18.9502 22.3119 19.9268C21.9145 20.888 21.9092 21.9224 21.945 22.9474C22.025 25.224 22.1471 27.5059 22.4103 29.7697L22.4176 29.8317C22.6518 31.8453 22.8855 33.8541 24.0096 35.5803C24.1776 35.8386 24.2121 36.0902 24.0456 36.3624C22.5798 38.7625 22.3617 41.6366 22.1521 44.3993L22.1387 44.5754C22.1213 44.804 22.1032 45.0334 22.085 45.2634C21.9766 46.6325 21.8666 48.0229 21.9101 49.3885ZM25.8379 66.4622C25.5738 65.932 25.4716 65.3031 25.3756 64.712C25.3611 64.6223 25.3466 64.5334 25.3318 64.4458C25.033 62.6852 24.895 60.895 24.7578 59.1149L24.7343 58.81C24.7097 58.4921 24.6671 58.1513 24.6231 57.7987C24.4563 56.4635 24.2685 54.9596 24.9558 53.8936C25.5961 52.9007 26.6669 52.925 27.6998 52.9485C27.8643 52.9522 28.0279 52.956 28.1885 52.9555C29.6537 52.9519 31.1188 52.947 32.584 52.9421H32.5843H32.5846H32.5849H32.5851H32.5854C37.4339 52.9259 42.2827 52.9096 47.131 52.938C47.3754 52.9394 47.6285 52.9332 47.8854 52.9269C48.6222 52.9087 49.3909 52.8898 50.0792 53.0485C51.916 53.472 51.8026 55.2312 51.7067 56.7191L51.7067 56.7193L51.7066 56.7204L51.7066 56.721C51.6947 56.9047 51.6832 57.0843 51.6756 57.2567C51.6499 57.8411 51.6286 58.4257 51.6073 59.0103L51.6073 59.0104L51.6073 59.0105L51.6073 59.0106L51.6073 59.0107L51.6073 59.0108C51.5616 60.2648 51.5159 61.5189 51.427 62.7712C51.4143 62.9498 51.4049 63.1472 51.3948 63.3572L51.3948 63.3575C51.3298 64.7173 51.2396 66.6021 50.0821 67.2881C49.4928 67.6375 48.7388 67.6396 48.1617 67.6412H48.1614C48.066 67.6415 47.9754 67.6417 47.8912 67.6435C47.6989 67.6475 47.5066 67.6505 47.3147 67.6536L47.311 67.6536C47.2614 67.6543 47.2118 67.6507 47.1621 67.647C47.0786 67.6408 46.995 67.6346 46.9118 67.6493C46.8723 67.6562 46.8283 67.6632 46.786 67.6699L46.786 67.6699C46.602 67.699 46.4509 67.723 46.8505 67.7163C46.2495 67.7262 45.6482 67.7334 45.047 67.7401C41.9385 67.7748 38.8297 67.7875 35.7211 67.7925C33.9887 67.7953 32.2565 67.7952 30.5242 67.7841C30.2951 67.7827 30.0625 67.7865 29.8286 67.7902C29.3418 67.7981 28.849 67.806 28.3684 67.7683C28.2863 67.7024 28.1838 67.6538 28.055 67.6373L27.9644 67.6256C27.0426 67.5069 26.3116 67.4128 25.8379 66.4622ZM24.6705 77.8696C24.6492 78.4532 24.6279 79.0369 24.6023 79.6204C24.5947 79.7935 24.5831 79.9738 24.5712 80.1583L24.5712 80.1583L24.5712 80.1584C24.4755 81.6462 24.3623 83.4048 26.1989 83.8286C26.8875 83.9876 27.6566 83.9687 28.3936 83.9506H28.394H28.3944H28.3948H28.3953C28.6513 83.9443 28.9035 83.9381 29.147 83.9395C30.8482 83.9494 32.5493 83.9532 34.2507 83.9542C37.7682 83.9406 41.2857 83.9277 44.8032 83.9317H44.8387L44.8705 83.9316C45.9435 83.928 47.0165 83.9244 48.0895 83.9216C48.25 83.9212 48.4132 83.925 48.5774 83.9287C49.6108 83.9524 50.682 83.977 51.3223 82.9835C52.0096 81.9176 51.8218 80.4134 51.6551 79.0782C51.6111 78.7257 51.5686 78.385 51.544 78.0673L51.5205 77.7624L51.5205 77.7623C51.3832 75.9822 51.2452 74.192 50.9465 72.4315C50.9316 72.3437 50.9171 72.2546 50.9025 72.1647L50.9024 72.1645L50.9024 72.1641C50.8063 71.5734 50.7041 70.9451 50.4402 70.4151C49.9666 69.4646 49.2362 69.3705 48.3144 69.2517L48.223 69.2399C48.0945 69.2231 47.9922 69.1747 47.9101 69.109C47.4294 69.0711 46.9364 69.0791 46.4497 69.087H46.4496C46.2156 69.0908 45.983 69.0946 45.7539 69.0932C44.0215 69.082 42.2893 69.0816 40.557 69.0846C37.4484 69.0894 34.3396 69.1022 31.231 69.1368C30.6299 69.1437 30.0286 69.1507 29.4276 69.1608C29.8274 69.1543 29.676 69.1782 29.4919 69.2072L29.4918 69.2072C29.4496 69.2139 29.4057 69.2208 29.3663 69.2277C29.2832 69.2425 29.1998 69.2363 29.1164 69.2301C29.0666 69.2264 29.0168 69.2227 28.967 69.2235C28.7737 69.2265 28.5804 69.2296 28.3869 69.2336C28.3022 69.2354 28.2111 69.2357 28.1151 69.236H28.115C27.5382 69.2377 26.7848 69.2399 26.196 69.5888C25.0381 70.2753 24.9481 72.1606 24.8831 73.5208C24.8731 73.7305 24.8637 73.9277 24.851 74.1062C24.762 75.3594 24.7162 76.6144 24.6705 77.8696ZM47.8914 99.9255C47.6991 99.9295 47.5068 99.9325 47.3148 99.9355L47.3112 99.9356C47.2611 99.9364 47.2109 99.9327 47.1607 99.929H47.1606C47.0777 99.9228 46.9947 99.9166 46.912 99.9312C46.8713 99.9384 46.8258 99.9457 46.7823 99.9526C46.6001 99.9815 46.4539 100.005 46.8506 99.9983C46.2497 100.008 45.6484 100.015 45.0472 100.022C41.9386 100.057 38.8299 100.07 35.7213 100.075C33.9889 100.077 32.2567 100.077 30.5244 100.066C30.2949 100.065 30.062 100.069 29.8277 100.072C29.3413 100.08 28.8486 100.088 28.3684 100.05C28.2863 99.9844 28.1838 99.9358 28.0552 99.9192L27.965 99.9076C27.0428 99.7891 26.3115 99.6951 25.8379 98.7442C25.5741 98.2146 25.472 97.5866 25.376 96.996L25.376 96.9958L25.376 96.9956L25.376 96.9954C25.3613 96.9051 25.3467 96.8157 25.3318 96.7276C25.033 94.967 24.895 93.1768 24.7578 91.3967L24.7343 91.0918C24.7097 90.7738 24.6671 90.4329 24.6231 90.0803C24.4563 88.745 24.2685 87.2413 24.9558 86.1754C25.5962 85.1823 26.6672 85.2067 27.7005 85.2302C27.8647 85.234 28.0281 85.2377 28.1885 85.2373C29.2609 85.2344 30.3333 85.2308 31.4057 85.2272L31.442 85.2274L31.475 85.2274C34.9796 85.2314 38.484 85.2184 41.9884 85.2051C43.7026 85.2061 45.4169 85.2099 47.131 85.22C47.3743 85.2213 47.6262 85.2151 47.882 85.2087L47.8824 85.2087C48.6201 85.1904 49.39 85.1714 50.0792 85.3304C51.916 85.7541 51.8026 87.5129 51.7067 89.0005C51.6948 89.1849 51.6832 89.3651 51.6756 89.5381C51.6499 90.1225 51.6286 90.707 51.6073 91.2914L51.6073 91.2917C51.5616 92.5461 51.5159 93.8002 51.427 95.0527C51.4143 95.2314 51.4049 95.429 51.3948 95.6391C51.3298 96.9991 51.2396 98.884 50.0821 99.5701C49.4924 99.9197 48.7378 99.9217 48.1607 99.9232H48.1602C48.0653 99.9235 47.9752 99.9237 47.8914 99.9255ZM89.4928 88.4587C90.0221 87.6385 90.4781 86.7657 90.7764 85.8329C90.9603 85.2584 91.06 84.6747 91.1598 84.0907L91.1616 84.0806C90.8839 84.1579 90.611 84.2261 90.3558 84.2899L90.3553 84.29C90.2352 84.3201 90.1189 84.3491 90.0078 84.3777C88.16 84.8524 86.2703 85.1564 84.3774 85.3834C79.2882 85.9943 74.1381 86.16 69.0155 86.0985C66.0835 86.0636 63.1497 85.96 60.2252 85.7438C57.4008 85.535 54.6086 85.292 51.9057 84.3928C51.8553 84.376 51.8134 84.3537 51.7749 84.3291C51.6829 84.4095 51.5873 84.4859 51.4871 84.5564C51.673 84.675 51.8509 84.8158 52.0177 84.9865C53.1466 86.1401 53.0766 87.4745 53.0007 88.921C52.9939 89.051 52.987 89.1819 52.981 89.3137C52.9496 89.9963 52.9263 90.6792 52.903 91.3621V91.3623C52.8648 92.4811 52.8266 93.5999 52.7532 94.7169C52.7383 94.9435 52.7262 95.1793 52.7139 95.4209C52.6487 96.6973 52.5752 98.1366 52.0303 99.2396C51.3593 100.598 50.1652 101.1 48.7183 101.195C48.7159 101.195 48.7135 101.195 48.711 101.195C48.7078 101.196 48.7046 101.196 48.7014 101.196L48.6934 101.196C49.0139 102.051 49.1526 102.823 49.1332 103.827C49.1124 104.895 49.1364 105.934 50.3621 106.102C51.7783 106.297 55.4446 106.74 55.7021 104.687C55.7514 104.294 55.7737 103.91 55.7958 103.529C55.8366 102.828 55.8767 102.138 56.084 101.423C56.1772 101.102 56.2762 100.78 56.3756 100.458C56.6516 99.561 56.93 98.6566 57.0903 97.74C57.397 95.9874 57.5528 94.1809 57.66 92.4053C57.6968 91.7962 58.4107 91.7101 58.7476 92.0457C59.4541 92.1226 60.1578 92.2159 60.8615 92.3091C62.0634 92.4684 63.2653 92.6277 64.4804 92.7053C66.4964 92.8341 68.5196 92.8888 70.5395 92.8331C72.4915 92.7798 74.4433 92.6469 76.3817 92.407C77.3075 92.2926 78.2322 92.1636 79.1515 92.0034C79.4175 91.9571 79.6864 91.8978 79.9565 91.8383L79.9566 91.8383L79.9568 91.8382C80.4544 91.7286 80.956 91.6181 81.4507 91.5857C82.0876 91.5444 82.5225 92.483 81.8212 92.7463C81.1271 93.0069 80.3682 93.1771 79.5939 93.3023C79.6385 93.3627 79.6762 93.4312 79.7006 93.5135C80.3025 95.5394 80.2233 97.5992 80.1439 99.6644C80.1104 100.537 80.0768 101.41 80.0945 102.282C80.1235 103.719 80.3907 104.932 81.8547 105.414C83.0707 105.814 84.3711 106.059 85.6454 105.832C86.2233 105.729 87.5635 105.458 87.409 104.606C87.3621 104.347 87.2748 104.096 87.1876 103.846L87.1875 103.846C87.0829 103.545 86.9783 103.245 86.9435 102.931C86.8293 101.903 87.138 100.82 87.4383 99.7654C87.5836 99.2552 87.727 98.7519 87.8196 98.2649C88.2379 96.0651 88.4537 93.4503 87.649 91.3006C87.588 91.2093 87.5585 91.1032 87.5734 90.9905C87.5785 90.7819 87.7134 90.5922 87.8856 90.4987L88.0405 90.3178L88.0405 90.3177C88.5529 89.7202 89.0623 89.126 89.4928 88.4587ZM97.0802 75.148C96.5914 76.3687 95.5765 76.8672 94.4141 76.8689C94.4205 76.7152 94.4274 76.5619 94.4339 76.4082C94.4598 75.7935 94.4855 75.1786 94.5101 74.5632C95.5651 74.196 96.6727 73.5215 97.275 72.5908C97.6579 73.3409 97.3689 74.427 97.0802 75.148ZM98.034 68.8243C98.6157 67.5725 99.1159 66.251 99.4719 64.9163C100.091 62.5921 100.079 60.1411 99.0732 57.9239C97.909 55.3585 95.9501 53.4221 93.9873 51.482C93.1218 50.6265 92.2556 49.7702 91.4564 48.859C91.4069 49.0582 91.3444 49.25 91.2599 49.4274C91.0305 49.9072 90.4041 49.8445 90.262 49.3373C90.1028 48.7686 90.2107 48.0032 90.3214 47.2183C90.5145 45.8497 90.7159 44.4217 89.5239 43.874C89.1768 44.2272 88.8103 44.562 88.4303 44.8824C88.5594 45.5399 88.5178 46.2861 88.4792 46.978C88.4686 47.1684 88.4582 47.3548 88.4517 47.534C88.4174 48.4761 88.3669 49.4135 88.2806 50.3523C88.2256 50.9496 87.3461 50.8552 87.3618 50.2653C87.3766 49.7068 87.4014 49.1491 87.4262 48.5914C87.4433 48.2082 87.4603 47.825 87.4742 47.4415C87.4859 47.1168 87.4823 46.784 87.4787 46.4494C87.4757 46.1758 87.4728 45.9009 87.4781 45.6285C86.8176 46.1091 86.1206 46.5443 85.3961 46.9331C85.4263 47.3492 85.4017 47.7885 85.3788 48.1978C85.3696 48.3616 85.3607 48.5206 85.3557 48.6714C85.3231 49.6666 85.277 50.6573 85.1762 51.6479C85.1159 52.2435 84.2383 52.1517 84.2578 51.5609C84.2741 51.0562 84.2966 50.552 84.3191 50.0478C84.3371 49.6437 84.3551 49.2395 84.37 48.8352C84.3803 48.551 84.3733 48.2511 84.3662 47.9472C84.3624 47.7823 84.3585 47.6162 84.3574 47.4508C83.657 47.7733 82.9376 48.0555 82.2048 48.2938C82.226 48.6543 82.2026 49.0356 82.1812 49.3835C82.1718 49.5373 82.1628 49.6846 82.1582 49.8207C82.13 50.6559 82.0945 51.4874 81.9688 52.3146C81.8799 52.8988 81.0069 52.8255 81.05 52.2275C81.1098 51.3967 81.1538 50.5607 81.1812 49.7281C81.1887 49.5 81.1804 49.2553 81.1719 49.0062C81.1673 48.8717 81.1626 48.736 81.1604 48.6009C80.4385 48.7931 79.7084 48.9441 78.9766 49.0533C78.7801 49.1123 78.5827 49.1695 78.3835 49.223C78.3959 49.266 78.4046 49.3114 78.4048 49.3618C78.4069 50.5032 78.3875 51.6555 78.2932 52.7929C78.2425 53.4043 77.2913 53.3155 77.3448 52.703C77.4393 51.6216 77.4762 50.5279 77.4892 49.4418C76.4532 49.6763 75.3913 49.8462 74.3187 49.9641C74.3458 51.0704 74.3591 52.1919 74.2521 53.2904C74.1932 53.8919 73.2905 53.8024 73.3212 53.2024C73.3589 52.468 73.3602 51.7312 73.3615 50.9946C73.3621 50.6813 73.3626 50.368 73.366 50.055C72.1084 50.159 70.8454 50.2001 69.6029 50.2018C69.6324 50.6665 69.6372 51.1337 69.6419 51.6011C69.6476 52.1634 69.6534 52.7259 69.7022 53.2841C69.7591 53.9394 68.7456 54.1218 68.6909 53.4628C68.6035 52.4093 68.5121 51.2685 68.5732 50.1957C68.3439 50.1923 68.1151 50.1877 67.8879 50.1822C66.9671 50.1597 66.0244 50.115 65.0751 50.0405C65.0826 50.4317 65.0832 50.8235 65.0839 51.2153C65.085 51.8704 65.0861 52.5255 65.1191 53.1784C65.1486 53.7645 64.2593 53.9502 64.1987 53.3407C64.0877 52.2222 64.101 51.0807 64.1305 49.9557C63.1391 49.8554 62.145 49.7173 61.1629 49.5281C61.1658 49.5489 61.1696 49.5691 61.1698 49.5912C61.1802 50.6371 61.2193 51.6904 61.3113 52.7325C61.365 53.3399 60.4246 53.5091 60.3734 52.8978C60.2795 51.7731 60.2543 50.6333 60.2568 49.5049C60.257 49.4434 60.2688 49.3912 60.2863 49.3441C59.4477 49.1542 58.6225 48.9228 57.8193 48.6443C57.8202 48.827 57.8153 49.0118 57.8104 49.1953C57.8031 49.468 57.7959 49.738 57.8081 49.9948C57.8414 50.6952 57.881 51.3967 57.9302 52.0961C57.9707 52.6763 57.1149 52.8555 57.0216 52.2563C56.8943 51.4415 56.8521 50.6197 56.8267 49.7957C56.8229 49.6719 56.8152 49.54 56.8074 49.4036C56.786 49.0338 56.7626 48.6304 56.8073 48.2615C56.4239 48.1041 56.0463 47.9357 55.677 47.7525C55.7383 48.6207 55.7542 49.4864 55.6119 50.3013C55.345 51.8296 54.246 53.3249 52.7629 53.8477C53.1007 54.7144 53.0519 55.6557 53.0002 56.6501C52.9937 56.7765 52.9871 56.9037 52.9812 57.0317C52.9499 57.7143 52.9266 58.3972 52.9032 59.0801C52.865 60.1989 52.8268 61.3176 52.7534 62.4348C52.7385 62.6613 52.7265 62.8971 52.7141 63.1387C52.6489 64.4151 52.5754 65.8544 52.0305 66.9575C51.6442 67.7392 51.0839 68.2363 50.4023 68.5363C50.5467 68.6234 50.6871 68.7264 50.8235 68.8498C51.4347 69.4037 51.7366 70.1691 51.9271 70.9523C52.3665 72.7587 52.522 74.6399 52.675 76.4907C52.6815 76.5694 52.688 76.6481 52.6945 76.7268C52.7403 77.2772 52.7826 77.8278 52.8248 78.3784C52.8568 78.7945 52.8887 79.2105 52.9222 79.6264C52.9391 79.8363 52.9673 80.0539 52.9959 80.2743C53.0576 80.7492 53.1209 81.2372 53.0761 81.6894C53.0109 82.3451 52.8063 82.9517 52.4909 83.4715C56.0866 84.3917 59.8076 84.5342 63.5051 84.6758C63.6331 84.6808 63.7611 84.6857 63.889 84.6906C69.4374 84.9049 75.0138 84.8982 80.5502 84.4361C80.7325 84.4209 80.9158 84.4058 81.0999 84.3905C84.618 84.0998 88.4452 83.7835 91.7092 82.4148C91.7696 82.3894 91.84 82.3642 91.915 82.3374C92.1887 82.2394 92.5222 82.12 92.6418 81.8952C92.8089 81.5807 92.8228 81.1591 92.8354 80.774C92.8392 80.658 92.843 80.5452 92.8507 80.4397C92.9296 79.3677 92.9873 78.2944 93.0341 77.2207C93.1612 74.3171 93.2511 71.4098 93.2983 68.5041C93.3804 63.4631 92.1425 58.661 90.8974 53.8315C90.7587 53.2932 90.6198 52.7546 90.4827 52.2154C90.3134 51.5494 91.3241 51.402 91.5159 52.0333C91.57 52.2112 91.6241 52.3891 91.6782 52.567C92.5731 55.5074 93.4632 58.4324 94.0385 61.4197C94.1955 61.2451 94.3545 61.0725 94.5208 60.9066C94.5347 60.8928 94.5488 60.8787 94.5631 60.8643C94.9064 60.5211 95.3951 60.0324 95.9096 60.1344C96.23 60.1978 96.5625 60.5363 96.385 60.8915C96.2466 61.1685 95.9982 61.362 95.7496 61.5558C95.6124 61.6628 95.475 61.7698 95.3561 61.891C95.2362 62.0132 95.1181 62.1366 95.0002 62.2599C94.7719 62.4986 94.5441 62.7368 94.3044 62.9647C94.5347 64.4803 94.6741 66.0144 94.6772 67.5784C94.6802 69.3664 94.6351 71.1578 94.5717 72.9477C95.2006 72.6432 95.7562 72.1847 96.237 71.6816C96.3736 71.4798 96.5126 71.2802 96.6513 71.081C97.1552 70.3572 97.6564 69.6374 98.034 68.8243Z"
            fill="#465B6D"
        />
    </svg>
);

export default TicketCatM;
