import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TouchLogoTravelSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="bd7afd73__mask0_16347_129"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={1}
            y={0}
            width={22}
            height={23}
        >
            <circle cx={12} cy={11.71} r={11} fill="white" />
        </mask>
        <g mask="url(#bd7afd73__mask0_16347_129)">
            <rect
                x={1}
                y={0.709961}
                width={22}
                height={22}
                fill="url(#bd7afd73__paint0_linear_16347_129)"
            />
            <path
                d="M16.3834 4.18701C15.6386 4.18701 14.9302 4.23794 14.3375 4.4386C13.7003 4.65435 13.1553 5.06013 12.8653 5.74841C12.6113 6.35133 12.5222 6.67883 12.2782 7.78818C12.1587 8.33146 12.4378 8.81763 12.9443 8.95625C13.4508 9.09487 13.9886 8.78095 14.1272 8.27447C14.3537 7.28959 14.4009 7.03796 14.562 6.62428C14.6391 6.42621 14.7361 6.31128 14.9473 6.23978C15.2334 6.14292 15.6839 6.08862 16.3834 6.08862C16.8568 6.08862 17.1798 6.14096 17.3869 6.20538C17.6136 6.27592 17.6827 6.4077 17.6368 6.64687C17.5359 7.17275 17.4663 7.49084 17.3623 8.01611C17.2603 8.53122 17.5953 9.03147 18.1104 9.13344C18.6255 9.23541 19.1258 8.90049 19.2277 8.38537C19.3692 7.67065 19.5273 6.95722 19.5648 6.44502C19.6252 5.61969 19.2017 5.00894 18.4987 4.61982C17.9164 4.29747 17.1704 4.18701 16.3834 4.18701Z"
                fill="#BD0C42"
            />
            <path
                d="M9.4158 9.74365L9.41605 9.74365C11.0116 9.74451 12.6072 9.74424 14.2027 9.74396C14.9894 9.74382 15.7761 9.74368 16.5628 9.74368C18.5372 9.74235 19.9561 11.0632 19.9502 13.0686C19.9474 14.0191 19.8518 15.4985 19.7058 17.096C19.5419 18.8891 19.3075 20.9309 19.036 22.7098H17.0353C17.3577 20.6755 17.6109 18.6302 17.7995 16.5793C17.923 15.2351 18.0093 14.2962 17.9991 13.2566C17.988 12.1315 17.4846 11.6396 16.413 11.6396H9.55816C7.99412 11.6396 6.97476 11.7572 6.30503 13.318C5.93448 14.1816 5.36913 15.9653 4.96142 18.1091C4.69445 19.5128 4.50064 21.1944 4.46752 22.7098H2.51636C2.55065 21.0244 2.76725 19.338 3.05492 17.8253C3.49082 15.5333 4.10317 13.5728 4.54653 12.5396C5.49791 10.3224 7.15309 9.74243 9.4158 9.74365Z"
                fill="#FF6D3A"
            />
            <path
                d="M14.3077 22.7098H12.3273C12.4835 19.1696 13.1804 15.5585 13.946 13.4166C14.1299 12.9021 14.696 12.6341 15.2105 12.818C15.725 13.0019 15.993 13.568 15.8091 14.0825C15.1215 16.0061 14.4633 19.3814 14.3077 22.7098Z"
                fill="#FF6D3A"
            />
        </g>
        <defs>
            <linearGradient
                id="bd7afd73__paint0_linear_16347_129"
                x1={22.9118}
                y1={0.61404}
                x2={1.25907}
                y2={22.7179}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEB75" />
                <stop offset={0.920669} stopColor="#FEE14A" />
            </linearGradient>
        </defs>
    </svg>
);

export default TouchLogoTravelSign;
