import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TouchLogoYaSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="89be4532__mask0_16347_128"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={1}
            y={0}
            width={23}
            height={23}
        >
            <ellipse
                cx={12.015}
                cy={11.7283}
                rx={11.015}
                ry={11.015}
                fill="white"
            />
        </mask>
        <g mask="url(#89be4532__mask0_16347_128)">
            <rect
                width={22}
                height={22}
                transform="translate(1 0.713379)"
                fill="#FC3F1D"
            />
            <path
                d="M13.622 6.87391H12.5088C10.6004 6.87391 9.64614 7.82813 9.64614 9.25945C9.64614 10.8498 10.2823 11.645 11.7136 12.5992L12.8269 13.3944L9.64614 18.3245H7.10156L10.1232 13.8715C8.37385 12.5992 7.41963 11.486 7.41963 9.41849C7.41963 6.87391 9.16903 5.12451 12.5088 5.12451H15.8485V18.3245H13.622V6.87391Z"
                fill="white"
            />
        </g>
    </svg>
);

export default TouchLogoYaSign;
