import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainBusNoCityPhotoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#0ce8d6e7__clip0_25495_5758)">
            <path
                d="M1200 0H0V349.85H1200V0Z"
                fill="url(#0ce8d6e7__paint0_linear_25495_5758)"
            />
            <path
                d="M1092.1 278.92C1096.86 279.984 1101.8 279.904 1106.53 278.687C1111.25 277.471 1115.62 275.151 1119.27 271.92C1122.48 269.03 1125.09 265.44 1128.72 263.12C1135.72 258.61 1144.8 259.78 1153.15 259.81C1155 259.946 1156.86 259.634 1158.56 258.9C1160.36 257.97 1161.56 256.24 1162.81 254.63C1168.64 247.01 1176.54 240.56 1185.89 238.44C1195.24 236.32 1206.07 239.31 1211.54 247.19C1214.23 251.06 1215.48 255.76 1217.86 259.83C1220.74 264.702 1225.14 268.496 1230.38 270.63C1235.53 272.7 1241.83 273.45 1244.93 278.06C1246.44 280.32 1246.85 283.12 1247.21 285.82C1247.67 289.367 1248.1 292.92 1248.49 296.48C1248.65 297.153 1248.56 297.86 1248.26 298.48C1247.73 299.3 1246.6 299.41 1245.63 299.48L1210.63 300.39C1195.89 300.78 1181.12 301.16 1166.43 299.9C1141.68 297.78 1117.6 291.03 1093.68 284.32"
                fill="#428C8A"
            />
            <path
                opacity={0.67}
                d="M555.905 242H440C440 242 458.538 231.024 466.241 231.61C473.944 232.195 472.645 237.605 472.645 237.605C472.645 237.605 488.131 224.988 501.767 225.722C515.403 226.456 513.788 233.144 513.788 233.144C513.788 233.144 528.812 218.16 552.747 220.189C571.529 221.739 555.905 242 555.905 242Z"
                fill="white"
            />
            <path
                opacity={0.5}
                d="M1273.52 102.6H1130.71C1130.71 102.6 1153.55 89.2901 1163 90.0001C1172.45 90.7101 1170.9 97.2501 1170.9 97.2501C1170.9 97.2501 1189.97 81.9501 1206.77 82.8501C1223.57 83.7501 1221.58 91.8501 1221.58 91.8501C1221.58 91.8501 1240.09 73.6801 1269.63 76.1401C1292.76 78.0001 1273.52 102.6 1273.52 102.6Z"
                fill="url(#0ce8d6e7__paint1_linear_25495_5758)"
            />
            <path
                opacity={0.6}
                d="M424.87 102.423H94C94 102.423 138.06 64.7732 184.53 59.1632C231 53.5532 229.39 80.7932 229.39 80.7932C229.39 80.7932 290.08 3.12318 383.01 10.4932C475.94 17.8632 438.49 72.7832 438.49 72.7832C438.49 72.7832 489.15 44.6832 522 56.2132C554.85 67.7432 529 102.423 529 102.423H424.87Z"
                fill="url(#0ce8d6e7__paint2_linear_25495_5758)"
            />
            <path
                opacity={0.4}
                d="M780 112.39H578.9C578.9 112.39 605.68 89.5101 633.9 86.1101C662.12 82.7101 661.17 99.2501 661.17 99.2501C661.17 99.2501 698.04 52.0601 754.52 56.5301C811 61.0001 788.23 94.3801 788.23 94.3801C788.23 94.3801 819 77.3101 839 84.3101C859 91.3101 843.26 112.39 843.26 112.39H780Z"
                fill="url(#0ce8d6e7__paint3_linear_25495_5758)"
            />
            <path
                opacity={0.7}
                d="M727.87 194.46H585.06C585.06 194.46 607.9 181.14 617.4 181.85C626.9 182.56 625.29 189.1 625.29 189.1C625.29 189.1 644.36 173.8 661.17 174.7C677.98 175.6 675.97 183.7 675.97 183.7C675.97 183.7 694.48 165.5 724 168C747.11 169.89 727.87 194.46 727.87 194.46Z"
                fill="url(#0ce8d6e7__paint4_linear_25495_5758)"
            />
            <path
                opacity={0.5}
                d="M80.48 31.5201C67.68 29.3801 50.64 35.9101 41.48 40.0901C41.8 28.7701 37.09 12.3901 7.19 12.3901C-38.52 12.3901 -58.81 42.2801 -58.81 42.2801C-58.81 42.2801 -55.87 27.7801 -78.03 27.7801C-100.19 27.7801 -125.74 50.6501 -125.74 50.6501H89C89 50.6501 98.88 34.6101 80.48 31.5201Z"
                fill="url(#0ce8d6e7__paint5_linear_25495_5758)"
            />
            <path
                d="M263.955 238.457C275.564 234.597 287.849 232.172 300.382 231.268C311.096 230.49 322.929 231.137 330.919 236.859C336.008 240.509 339.164 245.959 345.36 248.304C351.722 250.7 359.242 248.961 366.316 248.759C374.984 248.52 383.49 250.662 390.402 254.825C394.639 257.404 398.176 260.689 402.744 262.914C414.437 268.495 429.298 265.522 442.899 266.25C455.922 266.892 468.186 271.339 477.329 278.737C478.834 280.131 480.499 281.411 482.304 282.558C490.065 286.936 501.237 283.701 510.041 286.552C522.663 290.647 525.971 305.468 539 308.663C525.691 310.979 511.861 309.806 498.285 308.724C450.079 304.862 401.751 302.233 353.3 300.838C335.919 300.332 318.348 299.968 301.553 296.389C288.27 293.558 274.834 288.109 268.472 278.433C266.104 274.495 264.442 270.312 263.535 266.008C260.859 255.718 259.01 245.303 258 234.827"
                fill="#63A8A6"
            />
            <path
                d="M568.78 309.12C570.501 305.142 573.216 301.673 576.664 299.047C580.112 296.42 584.178 294.723 588.47 294.12C591.02 293.79 593.63 293.86 596.13 293.25C605.26 291.02 609.91 280.91 617.63 275.55C625.18 270.32 635.09 270.03 644.2 271.17C646.05 271.56 647.96 271.56 649.81 271.17C651.661 270.469 653.276 269.259 654.47 267.68C659.69 261.58 662.28 253.68 665 246.16C667.72 238.64 670.89 230.84 676.87 225.48C682.85 220.12 692.45 217.95 698.99 222.62C701.31 224.29 703.21 226.74 705.99 227.47C710.56 228.66 715.2 224.59 719.82 225.54C723.96 226.39 726.4 230.88 730.37 232.33C734.84 233.96 739.59 231.33 744.17 230.02C755.49 226.81 767.43 232.02 777.4 238.28C787.37 244.54 797 252.13 808.55 254.36C787.005 267.224 763.577 276.635 739.12 282.25C718.44 287 697.21 289 676.6 293.9C656.54 298.71 636.98 306.33 616.41 307.79C600.77 308.9 584.69 306.44 569.63 310.79"
                fill="#63A8A6"
            />
            <path
                d="M247 277.256C247 277.256 459.031 277.406 546.094 310.149C546.094 310.149 693.305 260.222 812.004 261.009C930.703 261.797 1316 296.992 1316 296.992L1286.33 442L293.681 439.618L247 277.256Z"
                fill="url(#0ce8d6e7__paint6_radial_25495_5758)"
            />
            <path
                d="M557.52 310.13C557.52 310.13 639.43 309.5 637.1 328.5C635.32 342.95 480.19 319.5 444.83 350.5C409.47 381.5 514.48 405.89 514.48 405.89L664.35 402.11C664.35 402.11 546.17 382.91 547.62 358C548.47 343.41 686.13 359.43 684.62 328.91C683.11 298.39 557.52 310.13 557.52 310.13Z"
                fill="url(#0ce8d6e7__paint7_linear_25495_5758)"
            />
            <path
                d="M548.81 356C548.81 356 557.72 351.93 576.3 348.84C594.88 345.75 614.07 346.35 622.3 346.35C630.53 346.35 645.59 342.04 649.69 340.67C653.79 339.3 709.14 313.54 745.26 318.76C781.38 323.98 764.67 354.24 764.67 354.24L732.83 386L682.15 403.22C669.742 402.522 657.398 400.951 645.21 398.52C627.32 394.73 582.78 384.9 566.21 375.83C549.64 366.76 548.07 363.53 547.7 359.76C547.33 355.99 548.81 356 548.81 356Z"
                fill="url(#0ce8d6e7__paint8_radial_25495_5758)"
            />
            <path
                d="M383.636 362C372.876 359.178 360.448 358.8 351.703 365.689C335.5 378.452 325.5 393.005 319.55 413.422C317.965 416.419 316.912 420.947 319.898 422.497C320.868 422.901 321.92 423.066 322.966 422.976C409.458 422.472 495.95 421.439 582.443 419.878L582.461 419.877C586.402 419.804 590.489 419.727 594 417.886C582.791 411.689 576.142 398.768 564.42 393.632C548.431 386.642 529.721 396.694 512.67 393.005C509.75 392.48 507.003 391.246 504.666 389.408C501.653 386.872 500.087 383.1 498.255 379.596C490.416 364.223 475.873 351.22 458.767 350.085C445.03 349.172 432.09 355.766 419.388 361.078C413.49 363.522 407.327 365.781 400.917 365.689C395.019 365.56 389.35 363.485 383.636 362Z"
                fill="#2E7C6F"
            />
            <path
                d="M937.07 -5.77979C937.07 -5.77979 905.54 60.0002 887.27 150C877.52 197.95 871.54 249 868.09 286.3C866.583 302.574 859.367 317.79 847.72 329.256C836.073 340.722 820.746 347.698 804.45 348.95C795.43 349.617 786.397 350.077 777.35 350.33C795.175 350.766 813.011 350.305 830.79 348.95C847.085 347.698 862.411 340.721 874.056 329.255C885.701 317.789 892.915 302.573 894.42 286.3C897.88 249.04 903.86 197.95 913.6 150C931.88 60.0002 963.41 -5.77979 963.41 -5.77979H937.07Z"
                fill="#FFD2C6"
            />
            <path
                d="M718.33 -11.0801L102.22 203.7C92.2761 255.092 87.562 307.358 88.1501 359.7L718.36 120.15L718.33 -11.0801Z"
                fill="url(#0ce8d6e7__paint9_linear_25495_5758)"
            />
            <path
                opacity={0.2}
                d="M718.36 185.78L49.3701 426.46L70.3101 488.07L717.44 240.17L718.36 185.78Z"
                fill="url(#0ce8d6e7__paint10_linear_25495_5758)"
            />
            <path
                d="M751.84 558.53L754.84 -76.91H1143.3L1135.86 -135H-243.32L-235.87 -76.94H39.3801L36.3801 558.5H-154.38L-152.38 573.9H1226.77L1224.77 558.5L751.84 558.53ZM109.84 558.77C60.0001 334.91 112.84 -76.67 112.84 -76.67H721.48L718.48 558.77H109.84Z"
                fill="url(#0ce8d6e7__paint11_linear_25495_5758)"
            />
            <path
                d="M865.6 558.53L868.6 -76.91H1177L1149.59 -135H-229.59L-222.14 -76.94H57.37L54.37 558.5H-140.63L-138.63 573.9H1240.5L1258.5 558.5L865.6 558.53ZM183.6 558.77L186.6 -76.67H739.21L736.21 558.77H183.6Z"
                fill="url(#0ce8d6e7__paint12_linear_25495_5758)"
            />
            <path
                opacity={0.2}
                d="M65.4701 196.06L-581.69 426.46L-560.75 488.07L64.5601 250.45L65.4701 196.06Z"
                fill="url(#0ce8d6e7__paint13_linear_25495_5758)"
            />
            <path
                d="M288.18 582.001C289.327 478.736 284.88 375.485 274.86 272.701C272.799 252.015 264.466 232.452 250.978 216.634C237.49 200.815 219.49 189.495 199.39 184.191C130.62 166.001 42.6001 152.841 -27.8799 149.551C-42.3699 148.881 -70.2199 150.551 -86.7699 155.901C-89.6499 156.841 -113.46 162.731 -114.98 163.971C-130.29 176.431 -112.34 195.411 -117.24 218.151C-133.3 292.641 -157.54 420.421 -169.17 558.751"
                fill="#5F8296"
            />
            <path
                d="M228.3 593.42C229.455 490.152 225.015 386.898 215 284.11C212.937 263.42 204.6 243.855 191.106 228.036C177.612 212.217 159.606 200.899 139.5 195.6C70.73 177.42 -17.28 164.25 -87.76 161C-108.363 160.007 -128.651 166.355 -145.013 178.914C-161.376 191.474 -172.753 209.431 -177.12 229.59C-193.18 304.05 -217.43 431.83 -229 570.16"
                fill="url(#0ce8d6e7__paint14_linear_25495_5758)"
            />
            <path
                d="M1170.5 527.772C1169.44 433.377 1163.26 339.109 1152 245.382C1149.7 226.519 1141.69 208.81 1129.04 194.628C1116.39 180.446 1099.71 170.468 1081.23 166.032C1018.01 150.812 937.31 140.572 872.83 139.032C857.27 138.662 824.97 141.552 812.38 149.032C793.45 160.332 796.98 180.542 792.56 203.512C779.41 271.902 759.85 389.172 752.05 515.832"
                fill="#5F8296"
            />
            <path
                d="M1123 534.262C1121.94 439.864 1115.77 345.592 1104.52 251.862C1102.22 232.999 1094.2 215.291 1081.56 201.109C1068.91 186.927 1052.23 176.949 1033.75 172.512C970.53 157.302 889.83 147.062 825.35 145.512C806.485 145.005 788.053 151.213 773.338 163.03C758.622 174.846 748.58 191.502 745 210.032C731.85 278.432 712.29 395.702 704.49 522.352"
                fill="#4F6C7F"
            />
            <path
                d="M893.735 -32.4427C861.424 -32.4427 837.487 -18.631 819.716 -1.59109C814.633 3.28324 808.893 7.27512 805.033 12.6928C793.403 29.017 787.362 46.9486 787.115 61.3103L798.748 83.1342C798.748 83.1342 800.105 108.555 767.99 125.607C735.876 142.66 720.361 163.727 731.525 186.645C731.525 186.645 702.123 212.954 713.559 242.574C724.994 272.193 764.182 276.995 764.182 276.995L1021.25 312.183C1021.25 312.183 1057.16 347.452 1087.42 321.551C1117.67 295.651 1114 234.5 1094.23 210.573C1081.24 194.844 1061.36 185.848 1061.36 185.848C1061.36 185.848 1070.4 162.859 1050.59 143.63C1030.79 124.401 1009.75 139.753 1003.49 114.373C997.225 88.9936 1025.03 34.0869 978.692 -10.0923C938.375 -42.8001 893.735 -32.4427 893.735 -32.4427Z"
                fill="#333333"
            />
            <path
                d="M920.923 203.132C996.297 218.653 1056.27 260.049 1073.86 306.097C1091.46 352.144 1100.11 410.062 1100.11 410.062C1100.11 410.062 1019.55 460.255 810.554 460.255C689.609 460.255 647.447 411.104 649.043 410.062C648.97 405.258 687.484 339.172 714.886 286.44C742.288 233.708 800.703 215.549 833.302 206.752C865.901 197.955 920.923 203.132 920.923 203.132Z"
                fill="url(#0ce8d6e7__paint15_linear_25495_5758)"
            />
            <path
                d="M868.944 213.69L860.286 231.314C860.286 231.314 863.529 252.587 850.448 270.161C837.367 287.735 818.107 299.467 791.568 293.884C765.028 288.3 750.221 257.843 756.092 227.119C761.964 196.394 797.201 173.693 797.201 173.693L866.475 176.559L868.944 213.69Z"
                fill="url(#0ce8d6e7__paint16_linear_25495_5758)"
            />
            <path
                d="M853.376 267.527C855.826 271.395 859.733 274.47 865.852 275.789C889.526 280.837 912.207 266.476 912.207 266.476C912.207 266.476 942.267 248.238 943.249 224.565C944.231 200.891 947.117 161.801 932.984 140.503C923.39 126.044 932.211 91.6891 932.211 91.6891C932.211 91.6891 896.161 78.9054 876.752 25.3506C876.752 25.3506 840.86 59.6257 787.305 58.6637C787.305 58.6637 786.532 74.7698 787.305 87.4246C788.079 100.079 791.957 108.767 790.211 126.044C788.466 143.32 787.891 159.763 794.674 179.787C801.458 199.81 808.727 211.682 823.723 215.946C836.616 219.606 849.588 217.632 862.53 212.713L864.236 218.793C861.071 220.989 858.88 224.327 858.127 228.105C857.135 234.185 858.9 245.57 857.869 254.238C856.837 262.906 853.376 267.527 853.376 267.527Z"
                fill="#FFD4C2"
            />
            <path
                opacity={0.6}
                d="M914.765 94.213C910.798 101.155 904.658 144.518 919.643 165.748C922.651 170.009 934.089 184.379 940.873 185.728C938.135 167.143 939.605 152.394 932.983 140.508C923.39 123.289 932.21 91.6939 932.21 91.6939C932.21 91.6939 896.685 79.0986 877.177 26.605C877.177 26.605 889.068 74.8341 914.765 94.213Z"
                fill="#F4C2AD"
            />
            <path
                opacity={0.6}
                d="M907 183.952C894.153 195.738 879.428 205.298 863.433 212.237L862.639 213.228L864.196 218.762C861.031 220.958 858.841 224.297 858.087 228.075C857.234 233.093 858.315 241.721 858.137 249.457C863.155 255.199 868.61 251.728 868.61 251.728C869.928 250.514 871.038 249.089 871.892 247.513C873.717 244.459 869.453 234.452 869.453 234.452C901.169 213.437 907 183.952 907 183.952Z"
                fill="#F8BDA4"
            />
            <path
                d="M934.214 147.131C934.214 147.131 972.644 145.554 999.461 176.556C1026.28 207.558 1029.91 269.295 997.478 300.307C965.048 331.32 902.785 328.513 887.7 296.668C872.616 264.822 892.887 241.645 912.355 231.311C931.824 220.977 940.264 208.431 940.938 193.624C939.163 178.222 936.882 162.721 934.214 147.131Z"
                fill="url(#0ce8d6e7__paint17_linear_25495_5758)"
            />
            <path
                d="M877.882 21.7937C877.882 21.7937 885.251 0.649429 904.461 -10.2202"
                stroke="#333333"
                strokeWidth={0.991756}
                strokeMiterlimit={10}
            />
            <path
                d="M912.245 178.191C896.705 197.788 862.529 212.665 862.529 212.665L871.583 241.346C871.583 241.346 874.559 248.913 867.676 252.256"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M886.518 160.07C899.637 154.907 906.463 141.041 901.764 129.099C897.064 117.157 882.619 111.662 869.5 116.824C856.381 121.987 849.555 135.853 854.254 147.795C858.953 159.737 873.398 165.233 886.518 160.07Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M810.631 131.339C809.047 127.216 806.323 123.629 802.778 120.995C799.233 118.361 795.012 116.789 790.607 116.462C790.647 119.642 790.501 122.821 790.171 125.983C788.951 138.103 788.306 149.855 790.379 162.678C793.095 162.674 795.785 162.163 798.313 161.171C809.798 156.648 815.332 143.289 810.631 131.339Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M864.78 108.121C865.482 104.379 863.612 100.888 860.603 100.323C857.594 99.7587 854.585 102.334 853.883 106.075C853.18 109.817 855.051 113.307 858.06 113.872C861.069 114.437 864.078 111.862 864.78 108.121Z"
                fill="#333333"
            />
            <path
                d="M812.707 108.121C813.409 104.379 811.539 100.888 808.53 100.323C805.521 99.7586 802.512 102.334 801.81 106.075C801.107 109.817 802.978 113.307 805.987 113.872C808.996 114.437 812.005 111.862 812.707 108.121Z"
                fill="#333333"
            />
            <path
                d="M855.567 85.9399C855.567 85.9399 875.164 81.4373 884.279 97.5434"
                stroke="#333333"
                strokeWidth={3.96702}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M812.405 85.9399C812.405 85.9399 796.388 81.4373 788.93 97.5434"
                stroke="#333333"
                strokeWidth={3.96702}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M823.554 91.4541C823.554 91.4541 827.432 104.654 821.481 112.668C815.531 120.681 807.26 126.185 807.26 132.503C807.26 141.429 820.153 145.693 820.153 145.693"
                fill="#FFD4C2"
            />
            <path
                d="M823.554 91.4541C823.554 91.4541 827.432 104.654 821.481 112.668C815.531 120.681 807.26 126.185 807.26 132.503C807.26 141.429 820.153 145.693 820.153 145.693"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M817.038 178.192C822.595 181.527 830.182 183.5 838.408 181.527C847.553 179.334 852.865 174.381 857.7 166.445"
                stroke="#E49776"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M731.252 348.933L714.826 406.532"
                stroke="#EEA70D"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M964.869 377.723L959.444 413.168"
                stroke="#EEA70D"
                strokeWidth={1.98351}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M1020.96 238.659C1021.29 242.355 1020.8 244.422 1020.8 244.422L1020.96 238.659C1019.89 226.758 1010.31 197.973 948.365 166.999C905.907 145.768 930.883 90.8208 930.883 90.8208L1023.29 154.509L1020.96 238.659Z"
                fill="#333333"
            />
        </g>
        <defs>
            <linearGradient
                id="0ce8d6e7__paint0_linear_25495_5758"
                x1={670}
                y1={-88}
                x2={576.4}
                y2={389.08}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint1_linear_25495_5758"
                x1={182237}
                y1={1948.15}
                x2={182245}
                y2={3009.11}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint2_linear_25495_5758"
                x1={144850}
                y1={516.479}
                x2={144769}
                y2={13911.1}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint3_linear_25495_5758"
                x1={194207}
                y1={2479.48}
                x2={194167}
                y2={7299.73}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint4_linear_25495_5758"
                x1={99984.3}
                y1={4324.57}
                x2={99976.2}
                y2={5677.43}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint5_linear_25495_5758"
                x1={-4136.57}
                y1={357.878}
                x2={-4125.98}
                y2={1936.79}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <radialGradient
                id="0ce8d6e7__paint6_radial_25495_5758"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(781.5 292.427) scale(238.49 235.115)"
            >
                <stop stopColor="#8BCCAD" />
                <stop offset={1} stopColor="#5C9D92" />
            </radialGradient>
            <linearGradient
                id="0ce8d6e7__paint7_linear_25495_5758"
                x1={552.45}
                y1={304.09}
                x2={572.01}
                y2={400.35}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#B6E4FD" />
                <stop offset={1} stopColor="#53ABDB" />
            </linearGradient>
            <radialGradient
                id="0ce8d6e7__paint8_radial_25495_5758"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(631.09 308.17) scale(93.82 93.82)"
            >
                <stop stopColor="#7FB8B6" />
                <stop offset={1} stopColor="#4A9185" />
            </radialGradient>
            <linearGradient
                id="0ce8d6e7__paint9_linear_25495_5758"
                x1={458205}
                y1={3770.08}
                x2={233039}
                y2={251164}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0.1} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint10_linear_25495_5758"
                x1={466162}
                y1={53385.5}
                x2={292421}
                y2={295030}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint11_linear_25495_5758"
                x1={-197.29}
                y1={218.779}
                x2={1158.5}
                y2={40.7459}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#CFE1ED" />
                <stop offset={1} stopColor="#D0D6DA" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint12_linear_25495_5758"
                x1={-183.56}
                y1={218.779}
                x2={1172.24}
                y2={40.7446}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FDFDFD" />
                <stop offset={1} stopColor="#D0DCE6" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint13_linear_25495_5758"
                x1={28984.8}
                y1={54549.8}
                x2={-133134}
                y2={280324}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint14_linear_25495_5758"
                x1={-5.90732}
                y1={416.162}
                x2={-17.4989}
                y2={181.778}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#79A1B5" />
                <stop offset={1} stopColor="#7E99AB" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint15_linear_25495_5758"
                x1={864.639}
                y1={321.647}
                x2={1096.21}
                y2={418.343}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint16_linear_25495_5758"
                x1={828.144}
                y1={187.012}
                x2={803.836}
                y2={248.184}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#587F9A" />
                <stop offset={1} stopColor="#6796B9" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint17_linear_25495_5758"
                x1={134350}
                y1={30435}
                x2={136399}
                y2={49278.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#587F9A" />
                <stop offset={1} stopColor="#6796B9" />
            </linearGradient>
            <clipPath id="0ce8d6e7__clip0_25495_5758">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default TrainBusNoCityPhotoL;
