import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainPayL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 220 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M196.451 59.5152C195.457 57.9335 193.973 56.7204 192.227 56.0607C190.48 55.4009 188.566 55.3306 186.776 55.8606C183.186 56.9558 179.743 58.4872 176.524 60.4207L171.73 48.933C171.256 47.7954 170.534 46.7785 169.617 45.9568C168.699 45.135 167.61 44.5293 166.428 44.1841C165.247 43.8389 164.003 43.7628 162.788 43.9616C161.573 44.1604 160.418 44.6289 159.408 45.3329L97.8608 88.371L33.3395 71.4066C32.1204 71.0843 30.8436 71.0466 29.6076 71.2963C28.3716 71.546 27.2093 72.0765 26.2104 72.847C25.2115 73.6175 24.4026 74.6073 23.8459 75.7402C23.2893 76.8732 22.9999 78.1189 23 79.3815V119.867C22.9949 123.041 24.0413 126.127 25.9754 128.642C27.9095 131.158 30.622 132.959 33.6882 133.766L94.9518 149.879C99.7385 151.137 104.741 151.339 109.613 150.47C114.485 149.602 119.111 147.684 123.17 144.85L182.309 103.502C184.992 101.63 186.953 98.8937 187.867 95.7497C188.78 92.6058 188.592 89.2434 187.332 86.2218L182.429 74.4504C185.635 71.4494 189.436 69.1595 193.586 67.7301C194.381 67.4625 195.104 67.0166 195.7 66.4264C196.296 65.8362 196.75 65.1174 197.026 64.3248C197.303 63.5323 197.395 62.6869 197.295 61.8534C197.195 61.0198 196.907 60.2201 196.451 59.5152ZM189.914 64.1191C187.844 64.1191 186.177 62.8208 186.177 61.2062C186.177 59.5916 187.844 58.2934 189.914 58.2934C191.984 58.2934 193.64 59.6025 193.64 61.2062C193.64 62.8099 192.017 64.1191 189.958 64.1191H189.914Z"
            fill="#E9F0F8"
        />
        <path
            d="M161.631 86.4403L153.666 84.433L160.737 56.2536C161.247 54.3168 161.368 52.298 161.093 50.3141C160.818 48.3302 160.153 46.4206 159.136 44.6959C158.119 42.9712 156.77 41.4656 155.168 40.2664C153.566 39.0672 151.742 38.1982 149.802 37.7097C147.862 37.2213 145.845 37.123 143.867 37.4206C141.889 37.7182 139.989 38.4058 138.278 39.4436C136.568 40.4814 135.079 41.8487 133.9 43.4664C132.721 45.0841 131.873 46.9201 131.407 48.8679L125.034 74.2653L117.069 72.2579L123.443 46.8605C125.126 41.0475 128.996 36.1152 134.239 33.1019C139.481 30.0887 145.686 29.2296 151.548 30.7055C157.41 32.1814 162.472 35.8772 165.667 41.0149C168.863 46.1525 169.943 52.3311 168.68 58.2501L161.631 86.4403Z"
            fill="#E50F4F"
        />
        <g opacity={0.49}>
            <path
                opacity={0.49}
                d="M128.847 59.0794L121.155 56.0029L117.069 72.2581L125.034 74.2655L128.847 59.0794Z"
                fill="#AC0F3D"
            />
            <path
                opacity={0.49}
                d="M164.878 73.4905L157.186 70.4141L154.059 82.8837L162.023 84.8801L164.878 73.4905Z"
                fill="#AC0F3D"
            />
        </g>
        <path
            d="M168.36 77.7389L114.534 64.191C110.327 63.132 106.059 65.6888 105.001 69.9019L92.7113 118.857C91.6537 123.07 94.2072 127.344 98.4147 128.403L152.24 141.951C156.448 143.01 160.716 140.453 161.774 136.24L174.063 87.2849C175.121 83.0718 172.568 78.7979 168.36 77.7389Z"
            fill="url(#964929f6__paint0_linear_31352_5414)"
        />
        <path
            opacity={0.5}
            d="M122.103 94.7426C120.89 88.5377 118.178 82.7246 114.204 77.811L113.267 76.7201L113.114 76.5237C112.809 76.1746 112.493 75.8364 112.177 75.5091L111.97 75.2909L110.99 74.3091L110.837 74.1672C108.937 72.3513 106.856 70.7354 104.627 69.3452C103.681 70.3252 103.009 71.5365 102.677 72.8581L91.1606 118.493C90.6559 120.506 90.9703 122.638 92.0347 124.42C93.0991 126.202 94.8263 127.488 96.8369 127.995L109.911 131.268C114.941 126.768 118.712 121.032 120.85 114.626C122.988 108.22 123.42 101.367 122.103 94.7426Z"
            fill="url(#964929f6__paint1_linear_31352_5414)"
        />
        <path
            d="M143.425 96.8372C143.792 95.3657 143.746 93.8212 143.292 92.3744C142.837 90.9276 141.992 89.6347 140.85 88.6388C139.707 87.6428 138.312 86.9825 136.819 86.7308C135.325 86.4791 133.791 86.6458 132.386 87.2125C130.981 87.7792 129.76 88.7239 128.857 89.942C127.955 91.1602 127.406 92.6045 127.272 94.1153C127.139 95.6261 127.424 97.1445 128.098 98.5028C128.772 99.861 129.808 101.006 131.092 101.812L121.362 117.293L137.291 121.296L135.995 103.034C137.729 102.924 139.384 102.264 140.72 101.15C142.056 100.036 143.003 98.5258 143.425 96.8372Z"
            fill="#BC0F43"
        />
        <path
            d="M82.0413 132.566C102.584 132.566 119.237 115.891 119.237 95.3208C119.237 74.7509 102.584 58.0757 82.0413 58.0757C61.4985 58.0757 44.8452 74.7509 44.8452 95.3208C44.8452 115.891 61.4985 132.566 82.0413 132.566Z"
            fill="url(#964929f6__paint2_linear_31352_5414)"
        />
        <path
            opacity={0.5}
            d="M82.0418 124.798C98.3004 124.798 111.481 111.601 111.481 95.3208C111.481 79.0408 98.3004 65.8433 82.0418 65.8433C65.7832 65.8433 52.603 79.0408 52.603 95.3208C52.603 111.601 65.7832 124.798 82.0418 124.798Z"
            fill="#FED42B"
        />
        <path
            opacity={0.2}
            d="M78.2499 132.358L110.935 71.8759C105.692 65.4034 98.4348 60.8753 90.3218 59.0136L89.2323 58.8936L55.479 121.449C61.5737 127.623 69.6247 131.48 78.2499 132.358Z"
            fill="url(#964929f6__paint3_linear_31352_5414)"
        />
        <path
            d="M76.7375 94.0441L74.0538 80.4853L81.6694 78.974C84.7659 78.3595 87.3616 78.5838 89.4564 79.6468C91.5736 80.6763 92.9194 82.6419 93.4937 85.5433C93.7919 87.0499 93.7948 88.383 93.5025 89.5428C93.2102 90.7026 92.67 91.7087 91.882 92.5609C91.1218 93.4076 90.1333 94.1257 88.9163 94.7152C87.6939 95.2767 86.3155 95.7097 84.7812 96.0142L82.4798 96.4709L83.0679 99.4421L91.4785 97.773L92.1577 101.205L83.7471 102.874L85.0558 109.486L79.9926 110.49L78.6839 103.878L75.5038 104.51L74.8246 101.078L78.0047 100.447L77.4167 97.4757L74.2365 98.1068L73.5573 94.6752L76.7375 94.0441ZM79.9287 83.5817L81.8006 93.0393L84.1439 92.5743C87.6588 91.8768 89.0904 89.882 88.4388 86.59C88.1241 84.9997 87.4932 83.9361 86.5462 83.3992C85.6215 82.8289 84.2665 82.7208 82.4812 83.0751L79.9287 83.5817Z"
            fill="#C69502"
        />
        <path
            d="M179.75 135.02L176.307 134.726C168.343 134.038 161.729 129.544 158.875 122.867L152.12 107.386L167.732 107.266L178.486 95.9424L185.197 111.423C188.096 118.1 186.853 126.009 181.929 132.304L179.75 135.02Z"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M155.006 114.052L170.619 113.976L181.351 102.608"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M61.3204 32.3451L33.6251 45.7154C31.8147 46.5894 31.0547 48.7674 31.9275 50.5801L39.0061 65.2813C39.8789 67.094 42.054 67.855 43.8644 66.9811L71.5597 53.6108C73.3701 52.7368 74.1301 50.5588 73.2573 48.7461L66.1787 34.0449C65.3059 32.2322 63.1308 31.4711 61.3204 32.3451Z"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M69.7185 41.3935L35.4673 57.9287L37.8994 62.9798L72.1505 46.4446L69.7185 41.3935Z"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M36.8267 52.0318L45.8152 47.7007"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M50.5435 45.4092L54.9233 43.3037"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M43.015 119.071L29.5703 127.253"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M50.6089 129.228L40.2803 140.377"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M60.7085 136.341L53.6812 149.858"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <defs>
            <linearGradient
                id="964929f6__paint0_linear_31352_5414"
                x1={139.838}
                y1={77.4216}
                x2={126.692}
                y2={129.649}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.23} stopColor="#E50F4F" />
                <stop offset={1} stopColor="#E50F4F" />
            </linearGradient>
            <linearGradient
                id="964929f6__paint1_linear_31352_5414"
                x1={112.504}
                y1={85.5459}
                x2={98.7525}
                y2={152.392}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.23} stopColor="#BC0F43" />
                <stop offset={1} stopColor="#BC0F43" />
            </linearGradient>
            <linearGradient
                id="964929f6__paint2_linear_31352_5414"
                x1={89.9466}
                y1={127.437}
                x2={71.2865}
                y2={51.8669}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE356" />
                <stop offset={1} stopColor="#FFE356" />
            </linearGradient>
            <linearGradient
                id="964929f6__paint3_linear_31352_5414"
                x1={79.0476}
                y1={140.721}
                x2={85.7721}
                y2={69.6701}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.24} stopColor="white" stopOpacity={0} />
                <stop offset={1} stopColor="white" />
            </linearGradient>
        </defs>
    </svg>
);

export default TrainPayL;
