import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainchoiseL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 220 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M180.931 90.8434C185.026 84.8348 187.358 77.7941 187.661 70.522C187.965 63.2499 186.228 56.0382 182.649 49.7071C179.07 43.3759 173.791 38.1792 167.413 34.7081C161.036 31.2369 153.815 29.6305 146.572 30.0715C139.33 30.5125 132.356 32.9832 126.443 37.2027C120.531 41.4222 115.918 47.2212 113.128 53.9402C110.338 60.6592 109.484 68.0286 110.662 75.2104C111.841 82.3923 115.005 89.0984 119.794 94.5661L89.2843 129.867C84.7151 135.106 87.2142 146.097 93.167 148.743C99.1198 151.39 95.3712 149.384 95.3712 149.384C100.091 152.611 110.795 149.717 115.273 142.046L135.689 105.465C143.779 108.408 152.615 108.569 160.805 105.922C168.996 103.275 176.076 97.9704 180.931 90.8434ZM136.596 86.9917C133.029 84.5478 130.266 81.0978 128.654 77.0782C127.042 73.0585 126.655 68.6497 127.541 64.4093C128.427 60.1689 130.547 56.2873 133.633 53.2555C136.718 50.2236 140.631 48.1777 144.875 47.3764C149.12 46.5751 153.506 47.0544 157.479 48.7537C161.452 50.4531 164.834 53.2961 167.196 56.9232C169.559 60.5504 170.795 64.7988 170.751 69.1312C170.706 73.4635 169.381 77.6853 166.945 81.2625C163.677 86.0589 158.644 89.3571 152.953 90.4315C147.262 91.5059 141.378 90.2686 136.596 86.9917Z"
            fill="#EDF2F7"
        />
        <path
            d="M77.622 86.8681L33.4555 90.8041C31.099 90.9419 29.0056 88.9238 28.7675 86.2476L26.0223 55.8131C25.7842 53.1557 27.4764 50.7991 29.8204 50.4732L73.7989 46.2051C74.4672 46.1271 75.1445 46.1867 75.789 46.3802C76.4335 46.5737 77.0315 46.8971 77.5464 47.3303C78.0612 47.7636 78.482 48.2976 78.7828 48.8996C79.0836 49.5015 79.258 50.1586 79.2954 50.8305L82.1721 81.3215C82.251 81.9867 82.1947 82.6611 82.0067 83.3041C81.8186 83.947 81.5027 84.5454 81.0778 85.0634C80.6529 85.5813 80.1278 86.0082 79.534 86.3183C78.9402 86.6284 78.2898 86.8154 77.622 86.8681V86.8681Z"
            stroke="#A1D2FF"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M30.3592 56.1266C31.1242 56.1266 31.7443 55.5065 31.7443 54.7415C31.7443 53.9766 31.1242 53.3564 30.3592 53.3564C29.5943 53.3564 28.9741 53.9766 28.9741 54.7415C28.9741 55.5065 29.5943 56.1266 30.3592 56.1266Z"
            fill="#A1D2FF"
        />
        <path
            d="M34.6903 55.5998C35.4552 55.5998 36.0754 54.9797 36.0754 54.2147C36.0754 53.4497 35.4552 52.8296 34.6903 52.8296C33.9253 52.8296 33.3052 53.4497 33.3052 54.2147C33.3052 54.9797 33.9253 55.5998 34.6903 55.5998Z"
            fill="#A1D2FF"
        />
        <path
            d="M39.0145 55.0671C39.7795 55.0671 40.3996 54.4469 40.3996 53.682C40.3996 52.917 39.7795 52.2969 39.0145 52.2969C38.2495 52.2969 37.6294 52.917 37.6294 53.682C37.6294 54.4469 38.2495 55.0671 39.0145 55.0671Z"
            fill="#A1D2FF"
        />
        <path
            d="M151.397 49.8155L37.2652 60.0216C35.5379 60.1761 34.2629 61.7015 34.4174 63.4288L40.9704 136.71C41.1249 138.437 42.6503 139.712 44.3776 139.557L158.509 129.351C160.237 129.197 161.512 127.671 161.357 125.944L154.804 52.6634C154.65 50.9361 153.124 49.6611 151.397 49.8155Z"
            fill="url(#2a7483c4__paint0_linear_31352_5412)"
        />
        <rect
            width={20}
            height={15}
            rx={4}
            transform="matrix(0.996195 -0.0871557 0.0920289 0.995756 44.646 85.0117)"
            stroke="white"
            strokeWidth={1.5}
        />
        <rect
            width={20}
            height={15}
            rx={4}
            transform="matrix(0.996195 -0.0871557 0.0920289 0.995756 68.3848 82.7432)"
            stroke="white"
            strokeWidth={1.5}
        />
        <rect
            width={20}
            height={15}
            rx={4}
            transform="matrix(0.996195 -0.0871557 0.0920289 0.995756 92.3848 79.7432)"
            stroke="white"
            strokeWidth={1.5}
        />
        <rect
            x={43.2871}
            y={66.7031}
            width={58.5853}
            height={8.20194}
            rx={2}
            transform="rotate(-5 43.2871 66.7031)"
            stroke="white"
            strokeWidth={1.5}
        />
        <rect
            width={60.2467}
            height={24}
            rx={4}
            transform="matrix(0.996195 -0.0871557 0.0920289 0.995756 46.8228 107.79)"
            fill="white"
        />
        <circle
            cx={59.7095}
            cy={114.579}
            r={3}
            transform="rotate(-5 59.7095 114.579)"
            fill="#E50F4F"
        />
        <circle
            cx={77.6412}
            cy={113.01}
            r={3}
            transform="rotate(-5 77.6412 113.01)"
            fill="#E50F4F"
        />
        <circle
            cx={95.5728}
            cy={111.441}
            r={3}
            transform="rotate(-5 95.5728 111.441)"
            fill="#E50F4F"
        />
        <circle
            cx={60.4942}
            cy={123.545}
            r={3}
            transform="rotate(-5 60.4942 123.545)"
            fill="#E50F4F"
        />
        <circle
            cx={78.4253}
            cy={121.976}
            r={3}
            transform="rotate(-5 78.4253 121.976)"
            fill="#E50F4F"
        />
        <circle
            cx={96.357}
            cy={120.407}
            r={3}
            transform="rotate(-5 96.357 120.407)"
            fill="#E50F4F"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M179.683 123.837C178.706 123.482 177.876 122.812 177.321 121.933C176.767 121.054 176.52 120.016 176.619 118.981L167.672 115.725C167.38 115.619 167.143 115.401 167.011 115.119C166.88 114.837 166.866 114.515 166.972 114.223C167.078 113.931 167.296 113.693 167.578 113.562C167.86 113.431 168.182 113.417 168.474 113.523L177.421 116.779C178.01 115.924 178.866 115.287 179.856 114.971C180.845 114.655 181.912 114.676 182.888 115.031C183.864 115.386 184.695 116.056 185.249 116.934C185.804 117.813 186.051 118.85 185.952 119.884L188.293 120.736C188.585 120.843 188.822 121.061 188.954 121.342C189.085 121.624 189.099 121.946 188.993 122.238C188.887 122.53 188.669 122.768 188.387 122.899C188.105 123.031 187.783 123.045 187.491 122.938L185.15 122.086C184.562 122.943 183.705 123.579 182.716 123.896C181.726 124.213 180.659 124.192 179.683 123.837ZM164.466 124.533C164.174 124.427 163.852 124.441 163.57 124.572C163.289 124.704 163.071 124.942 162.965 125.234C162.858 125.526 162.872 125.848 163.004 126.13C163.135 126.411 163.373 126.629 163.665 126.735L166.006 127.587C165.907 128.622 166.154 129.659 166.708 130.538C167.263 131.416 168.094 132.085 169.07 132.441C170.046 132.796 171.112 132.817 172.102 132.501C173.091 132.184 173.948 131.548 174.537 130.692L183.484 133.949C183.776 134.055 184.098 134.041 184.38 133.91C184.661 133.778 184.879 133.541 184.985 133.249C185.092 132.957 185.078 132.634 184.946 132.353C184.815 132.071 184.577 131.853 184.285 131.747L175.338 128.49C175.437 127.456 175.19 126.418 174.635 125.54C174.081 124.662 173.25 123.992 172.274 123.637C171.298 123.282 170.231 123.261 169.242 123.577C168.252 123.893 167.396 124.529 166.807 125.385L164.466 124.533ZM180.484 121.635C181.068 121.848 181.713 121.819 182.276 121.557C182.839 121.294 183.275 120.818 183.488 120.234C183.7 119.65 183.672 119.006 183.409 118.443C183.147 117.879 182.671 117.443 182.087 117.231C181.503 117.018 180.859 117.046 180.295 117.309C179.732 117.572 179.296 118.047 179.084 118.631C178.871 119.215 178.899 119.86 179.162 120.423C179.424 120.987 179.9 121.422 180.484 121.635ZM172.874 128.84C172.661 129.424 172.226 129.9 171.662 130.163C171.099 130.425 170.454 130.454 169.87 130.241C169.286 130.028 168.811 129.592 168.548 129.029C168.285 128.466 168.257 127.821 168.47 127.237C168.682 126.653 169.118 126.178 169.682 125.915C170.245 125.652 170.889 125.624 171.473 125.837C172.057 126.049 172.533 126.485 172.796 127.048C173.058 127.612 173.087 128.256 172.874 128.84Z"
            fill="#A1D2FF"
        />
        <defs>
            <linearGradient
                id="2a7483c4__paint0_linear_31352_5412"
                x1={48.2622}
                y1={130.18}
                x2={153.716}
                y2={49.9187}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE356" />
                <stop offset={1} stopColor="#FFE356" />
            </linearGradient>
        </defs>
    </svg>
);

export default TrainchoiseL;
