import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainsSchoolSaleL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 220 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M162.912 135.832C170.695 132.325 175.144 128.515 174.741 124.954C173.776 116.413 145.348 112.544 111.244 116.312C77.1409 120.08 50.277 130.058 51.242 138.598C52.207 147.139 80.6358 151.008 114.739 147.241C119.487 146.716 124.087 146.068 128.498 145.323C129.409 148.471 140.23 149.869 153.178 148.438C166.478 146.969 176.954 143.078 176.577 139.747C176.314 137.412 170.776 135.978 162.912 135.832Z"
            fill="#FF6D3A"
        />
        <path
            d="M143.519 126.168C143.152 126.168 142.787 126.141 142.424 126.085L122.301 123.008C121.15 122.835 120.058 122.386 119.118 121.701C118.178 121.015 117.417 120.113 116.9 119.072C116.389 118.034 116.139 116.887 116.172 115.731C116.205 114.575 116.521 113.445 117.091 112.438L158.01 40.1945C158.741 38.9192 159.841 37.8949 161.166 37.2566C162.491 36.6183 163.978 36.3959 165.432 36.6188L185.553 39.6955C186.704 39.8693 187.797 40.318 188.737 41.0036C189.677 41.6893 190.438 42.5915 190.955 43.6338C191.467 44.6713 191.717 45.8181 191.683 46.9742C191.65 48.1304 191.334 49.2608 190.763 50.267L149.845 122.509C149.207 123.622 148.286 124.546 147.175 125.189C146.064 125.831 144.802 126.169 143.519 126.168ZM164.332 39.3578C163.555 39.3576 162.791 39.5623 162.118 39.9512C161.446 40.3402 160.887 40.8996 160.5 41.573L119.581 113.817C119.231 114.425 119.038 115.11 119.018 115.811C118.998 116.512 119.152 117.207 119.467 117.834C119.776 118.468 120.235 119.016 120.805 119.432C121.375 119.848 122.038 120.118 122.736 120.218L142.859 123.295C143.74 123.43 144.641 123.295 145.443 122.909C146.246 122.523 146.912 121.903 147.355 121.131L188.273 48.8871C188.623 48.2794 188.817 47.5943 188.837 46.8933C188.858 46.1923 188.703 45.4972 188.389 44.8703C188.08 44.2363 187.62 43.6875 187.05 43.2718C186.48 42.8562 185.817 42.5862 185.118 42.4855L164.996 39.4088C164.776 39.3748 164.555 39.3577 164.332 39.3578Z"
            fill="#E50F4F"
        />
        <path
            d="M182.591 129.6C181.755 129.599 180.921 129.536 180.095 129.409C177.657 129.015 175.334 128.098 173.285 126.719C171.237 125.341 169.512 123.535 168.23 121.425C165.437 116.921 164.38 111.555 165.257 106.329C167.01 95.123 176.546 87.2465 186.452 88.76C188.891 89.1538 191.214 90.0716 193.263 91.4501C195.312 92.8285 197.037 94.6348 198.319 96.7441C201.111 101.248 202.168 106.614 201.291 111.84V111.841C200.525 117.093 197.88 121.89 193.845 125.343C190.717 128.049 186.728 129.557 182.591 129.6ZM183.986 91.3956C176.374 91.3956 169.468 97.8771 168.078 106.761C167.307 111.315 168.22 115.993 170.646 119.924C171.696 121.705 173.129 123.229 174.841 124.388C176.554 125.546 178.503 126.309 180.547 126.622C182.591 126.934 184.68 126.788 186.66 126.195C188.641 125.601 190.465 124.574 191.999 123.188C195.466 120.142 197.754 115.979 198.467 111.422C199.18 106.865 198.272 102.203 195.901 98.2452C194.837 96.4815 193.401 94.9696 191.695 93.8137C189.989 92.6578 188.052 91.8855 186.017 91.55C185.345 91.4475 184.666 91.3959 183.986 91.3957V91.3956Z"
            fill="#E50F4F"
        />
        <path
            d="M126.03 72.0231C125.195 72.0228 124.36 71.9592 123.535 71.8329C121.097 71.4389 118.773 70.5211 116.725 69.143C114.676 67.7648 112.952 65.959 111.67 63.8502C108.876 59.3457 107.819 53.9794 108.696 48.7533C110.448 37.5464 119.976 29.6836 129.892 31.1834C139.827 32.7039 146.483 43.0575 144.73 54.2644C143.964 59.5164 141.319 64.3132 137.285 67.7664C134.156 70.4724 130.168 71.9809 126.03 72.0231ZM127.426 33.819C119.814 33.819 112.908 40.3006 111.518 49.1848C110.746 53.7383 111.659 58.4168 114.086 62.3477C115.135 64.128 116.568 65.6527 118.28 66.8111C119.993 67.9696 121.942 68.7327 123.986 69.0452C126.031 69.3577 128.119 69.2118 130.1 68.6179C132.081 68.0241 133.904 66.9973 135.439 65.6119C138.95 62.5957 141.249 58.4106 141.909 53.8316C143.421 44.1644 137.835 35.2554 129.455 33.9734C128.784 33.8709 128.105 33.8193 127.426 33.819Z"
            fill="#E50F4F"
        />
        <path
            d="M154.098 80.2369C149.107 53.8038 124.937 36.0904 100.114 40.6731L86.4178 43.2035L86.8206 45.4876C69.8779 55.009 60.1765 75.497 64.205 96.832C68.1518 117.735 84.0939 133.172 102.866 136.456L103.337 139.131L118.123 136.406C118.145 136.402 118.167 136.4 118.188 136.396L118.252 136.382L118.549 136.328L118.547 136.32C143.164 131.56 159.064 106.541 154.098 80.2369Z"
            fill="#FED42B"
        />
        <path
            opacity={0.17}
            d="M149.933 67.523L136.208 70.8511L122.265 52.8568L136.383 50.249L136.573 50.4077L138.306 51.9061C143.178 56.2917 147.13 61.5999 149.933 67.523Z"
            fill="white"
        />
        <path
            d="M105.382 138.739C130.052 133.399 145.428 107.758 139.726 81.4674C134.025 55.1769 109.404 38.1929 84.7344 43.5327C60.065 48.8724 44.6886 74.5139 50.3904 100.804C56.0922 127.095 80.713 144.079 105.382 138.739Z"
            fill="url(#b6d15898__paint0_linear_31352_5418)"
        />
        <path
            d="M102.288 127.453C121.108 123.379 132.839 103.817 128.489 83.7603C124.139 63.7031 105.356 50.7459 86.5355 54.8197C67.715 58.8934 55.9843 78.4554 60.3342 98.5125C64.6841 118.57 83.4674 131.527 102.288 127.453Z"
            fill="#FEDB41"
        />
        <path
            d="M104.489 125.748C86.2203 129.561 68.0083 116.713 63.8111 97.0509C59.6139 77.3891 71.0213 58.359 89.2899 54.5462C90.2661 54.3425 91.2417 54.196 92.2154 54.0859C90.5802 54.1393 88.9513 54.3141 87.342 54.6088C68.4044 58.1048 56.1393 77.2867 59.9469 97.4526C63.7546 117.618 82.1933 131.132 101.131 127.636C106.365 126.671 111.286 124.451 115.471 121.166C112.135 123.377 108.408 124.932 104.489 125.748Z"
            fill="#FED42B"
        />
        <path
            d="M101.194 95.1439C103.269 94.7214 105.24 93.8936 106.994 92.7082C108.748 91.5229 110.25 90.0031 111.415 88.2363C112.579 86.4694 113.383 84.4902 113.78 82.4122C114.177 80.3342 114.16 78.1984 113.728 76.1273C113.049 71.9 110.723 68.1129 107.259 65.5928C103.794 63.0727 99.4726 62.0243 95.2371 62.6766L89.0448 63.7875L81.079 65.2166C80.8979 65.2535 80.7258 65.3258 80.5726 65.4293C80.4195 65.5328 80.2883 65.6655 80.1866 65.8198C80.0849 65.974 80.0147 66.1469 79.98 66.3283C79.9454 66.5098 79.9469 66.6963 79.9846 66.8771L83.6174 86.6758L78.3993 87.6119C78.2181 87.6488 78.046 87.721 77.8929 87.8245C77.7397 87.928 77.6085 88.0607 77.5068 88.215C77.4052 88.3693 77.335 88.5421 77.3003 88.7236C77.2656 88.9051 77.2672 89.0916 77.3048 89.2724L78.8344 97.6081C78.8937 97.9773 79.0968 98.308 79.3993 98.528C79.7018 98.7481 80.0792 98.8396 80.4491 98.7827L85.6671 97.8465L86.6419 103.159L81.4238 104.095C81.2426 104.132 81.0705 104.204 80.9173 104.308C80.7642 104.411 80.633 104.544 80.5313 104.698C80.4296 104.852 80.3594 105.025 80.3248 105.207C80.2901 105.388 80.2916 105.575 80.3293 105.755L81.8588 114.091C81.9181 114.461 82.1212 114.791 82.4237 115.011C82.7262 115.231 83.1036 115.323 83.4735 115.266L88.6915 114.33L89.2999 117.645C89.3592 118.014 89.5623 118.345 89.8648 118.565C90.1673 118.785 90.5447 118.877 90.9146 118.82L98.8803 117.391C99.0615 117.354 99.2336 117.282 99.3867 117.178C99.5399 117.075 99.6711 116.942 99.7727 116.788C99.8744 116.633 99.9446 116.46 99.9793 116.279C100.014 116.098 100.012 115.911 99.9748 115.73L99.3664 112.415L109.689 110.563C109.87 110.526 110.042 110.454 110.195 110.35C110.348 110.247 110.48 110.114 110.581 109.96C110.683 109.805 110.753 109.633 110.788 109.451C110.822 109.27 110.821 109.083 110.783 108.902L109.254 100.566C109.194 100.197 108.991 99.8666 108.689 99.6466C108.386 99.4265 108.009 99.335 107.639 99.3919L97.3167 101.244L96.3567 96.0119L101.194 95.1439ZM92.7092 76.1332C92.6715 75.9524 92.67 75.7659 92.7047 75.5844C92.7393 75.403 92.8095 75.2301 92.9112 75.0758C93.0129 74.9216 93.1441 74.7889 93.2973 74.6854C93.4504 74.5819 93.6225 74.5096 93.8037 74.4727L97.3251 73.8409C98.6287 73.6651 99.95 73.9975 101.015 74.7691C102.079 75.5408 102.806 76.6925 103.043 77.9851C103.28 79.2777 103.01 80.6119 102.288 81.7107C101.567 82.8095 100.45 83.5885 99.1683 83.886L95.6469 84.5177C95.277 84.5747 94.8996 84.4831 94.5971 84.2631C94.2946 84.043 94.0915 83.7123 94.0322 83.3432L92.7092 76.1332Z"
            fill="#FF6D3A"
        />
        <path
            d="M99.3068 95.4925C101.382 95.0699 103.353 94.2422 105.107 93.0568C106.86 91.8714 108.363 90.3517 109.527 88.5848C110.692 86.818 111.496 84.8388 111.893 82.7608C112.29 80.6828 112.272 78.547 111.841 76.4758C111.162 72.2485 108.836 68.4614 105.371 65.9413C101.907 63.4213 97.5849 62.3729 93.3494 63.0252L87.1571 64.1362L79.1913 65.5652C79.0102 65.6021 78.8381 65.6744 78.6849 65.7779C78.5318 65.8814 78.4006 66.0141 78.2989 66.1684C78.1972 66.3227 78.127 66.4955 78.0923 66.6769C78.0577 66.8584 78.0592 67.0449 78.0968 67.2257L81.7297 87.0244L76.5116 87.9605C76.3304 87.9974 76.1583 88.0697 76.0052 88.1732C75.852 88.2767 75.7208 88.4094 75.6191 88.5637C75.5174 88.7179 75.4473 88.8908 75.4126 89.0722C75.3779 89.2537 75.3795 89.4402 75.4171 89.621L76.9467 97.9568C77.006 98.3259 77.2091 98.6566 77.5116 98.8767C77.8141 99.0967 78.1915 99.1883 78.5614 99.1313L83.7794 98.1952L84.7542 103.507L79.5361 104.443C79.3549 104.48 79.1828 104.553 79.0296 104.656C78.8765 104.76 78.7453 104.892 78.6436 105.047C78.5419 105.201 78.4717 105.374 78.4371 105.555C78.4024 105.737 78.4039 105.923 78.4416 106.104L79.9712 114.44C80.0305 114.809 80.2336 115.14 80.5361 115.36C80.8386 115.58 81.216 115.671 81.5859 115.614L86.8039 114.678L87.4123 117.994C87.4716 118.363 87.6747 118.694 87.9772 118.914C88.2797 119.134 88.6571 119.225 89.027 119.168L96.9927 117.739C97.1739 117.702 97.346 117.63 97.4991 117.527C97.6523 117.423 97.7835 117.29 97.8851 117.136C97.9868 116.982 98.057 116.809 98.0917 116.628C98.1264 116.446 98.1248 116.26 98.0872 116.079L97.4788 112.763L107.801 110.911C107.982 110.875 108.154 110.802 108.308 110.699C108.461 110.595 108.592 110.463 108.694 110.308C108.795 110.154 108.866 109.981 108.9 109.8C108.935 109.618 108.933 109.432 108.896 109.251L107.366 100.915C107.307 100.546 107.104 100.215 106.801 99.9951C106.499 99.775 106.121 99.6835 105.751 99.7405L95.4291 101.592L94.4691 96.3604L99.3068 95.4925ZM90.8216 76.4818C90.7839 76.3009 90.7823 76.1144 90.817 75.933C90.8517 75.7515 90.9219 75.5787 91.0236 75.4244C91.1253 75.2701 91.2564 75.1374 91.4096 75.0339C91.5628 74.9304 91.7349 74.8581 91.9161 74.8213L95.4375 74.1895C96.7411 74.0136 98.0624 74.346 99.1272 75.1176C100.192 75.8893 100.918 77.041 101.155 78.3336C101.393 79.6262 101.122 80.9605 100.401 82.0593C99.6794 83.1581 98.5619 83.9371 97.2806 84.2345L93.7592 84.8663C93.3894 84.9232 93.012 84.8317 92.7094 84.6116C92.4069 84.3916 92.2038 84.0609 92.1445 83.6918L90.8216 76.4818Z"
            fill="url(#b6d15898__paint1_linear_31352_5418)"
        />
        <path
            d="M193.79 72.9861C193.669 72.9864 193.549 72.9716 193.433 72.942C193.252 72.8971 193.082 72.8169 192.932 72.7061C192.783 72.5952 192.657 72.4559 192.561 72.2961C192.466 72.1364 192.403 71.9593 192.376 71.7751C192.349 71.591 192.359 71.4034 192.405 71.2231L193.455 67.1938C193.554 66.831 193.792 66.5214 194.117 66.3315C194.442 66.1416 194.828 66.0865 195.194 66.1779C195.374 66.2228 195.544 66.303 195.694 66.4139C195.844 66.5247 195.97 66.664 196.065 66.8238C196.161 66.9836 196.224 67.1606 196.25 67.3448C196.277 67.5289 196.267 67.7166 196.221 67.8968L195.171 71.9261C195.091 72.2305 194.911 72.4996 194.661 72.6914C194.411 72.8831 194.105 72.9868 193.79 72.9861Z"
            fill="#E50F4F"
        />
        <path
            d="M190.861 84.2302C190.741 84.2305 190.621 84.2157 190.504 84.1861C190.323 84.1412 190.153 84.061 190.004 83.9501C189.854 83.8393 189.728 83.7 189.632 83.5402C189.537 83.3804 189.474 83.2034 189.447 83.0192C189.421 82.8351 189.431 82.6474 189.477 82.4672L190.526 78.4379C190.625 78.0745 190.862 77.7642 191.187 77.5741C191.512 77.384 191.9 77.3294 192.265 77.422C192.446 77.4669 192.616 77.5471 192.765 77.658C192.915 77.7688 193.041 77.9081 193.137 78.0679C193.232 78.2277 193.295 78.4047 193.322 78.5889C193.348 78.773 193.338 78.9607 193.292 79.1409L192.243 83.1702C192.162 83.4746 191.983 83.7437 191.733 83.9354C191.483 84.1272 191.176 84.2309 190.861 84.2302Z"
            fill="#E50F4F"
        />
        <path
            d="M200.574 78.5606C200.453 78.5609 200.333 78.5461 200.217 78.5165L196.142 77.4785C195.961 77.4336 195.791 77.3534 195.641 77.2426C195.492 77.1317 195.366 76.9924 195.27 76.8326C195.175 76.6729 195.112 76.4958 195.085 76.3117C195.058 76.1275 195.068 75.9399 195.114 75.7596C195.213 75.3965 195.451 75.0867 195.776 74.8967C196.101 74.7068 196.488 74.6518 196.853 74.7437L200.928 75.7817C201.263 75.8649 201.557 76.0685 201.752 76.3536C201.948 76.6388 202.031 76.9857 201.988 77.3285C201.944 77.6713 201.776 77.9862 201.515 78.2133C201.255 78.4404 200.919 78.564 200.574 78.5606L200.574 78.5606Z"
            fill="#E50F4F"
        />
        <path
            d="M189.201 75.6643C189.08 75.6646 188.96 75.6498 188.844 75.6202L184.769 74.5822C184.588 74.5373 184.418 74.4571 184.268 74.3463C184.119 74.2354 183.993 74.0961 183.897 73.9363C183.802 73.7766 183.739 73.5995 183.712 73.4154C183.685 73.2312 183.695 73.0436 183.741 72.8633C183.84 72.5001 184.077 72.1902 184.403 72.0001C184.728 71.8101 185.114 71.7553 185.48 71.8474L189.555 72.8854C189.89 72.9687 190.184 73.1722 190.379 73.4573C190.575 73.7425 190.658 74.0894 190.615 74.4322C190.571 74.775 190.403 75.0898 190.142 75.317C189.882 75.5441 189.546 75.6677 189.201 75.6643L189.201 75.6643Z"
            fill="#E50F4F"
        />
        <path
            d="M52.0924 40.8514C51.9721 40.8517 51.8522 40.8369 51.7356 40.8073C51.5548 40.7624 51.3847 40.6822 51.2351 40.5713C51.0855 40.4605 50.9593 40.3211 50.8638 40.1614C50.7683 40.0016 50.7054 39.8246 50.6787 39.6404C50.652 39.4562 50.6619 39.2686 50.7081 39.0883L51.7579 35.059C51.857 34.6962 52.0946 34.3866 52.4196 34.1967C52.7446 34.0068 53.1311 33.9517 53.4963 34.0432C53.677 34.0881 53.8471 34.1683 53.9967 34.2792C54.1463 34.39 54.2725 34.5293 54.368 34.6891C54.4635 34.8489 54.5264 35.0259 54.5532 35.2101C54.5799 35.3942 54.5699 35.5818 54.5237 35.7621L53.474 39.7914C53.3933 40.0958 53.214 40.3649 52.9641 40.5566C52.7141 40.7484 52.4076 40.852 52.0924 40.8514Z"
            fill="#E50F4F"
        />
        <path
            d="M49.1637 52.0963C49.0434 52.0966 48.9235 52.0818 48.8068 52.0523C48.6261 52.0073 48.456 51.9271 48.3064 51.8163C48.1568 51.7054 48.0306 51.5661 47.9351 51.4064C47.8396 51.2466 47.7767 51.0695 47.75 50.8854C47.7232 50.7012 47.7332 50.5136 47.7794 50.3333L48.8291 46.3041C48.9279 45.941 49.1654 45.6311 49.4905 45.4412C49.8156 45.2512 50.2023 45.1962 50.5675 45.2881C50.7483 45.3331 50.9184 45.4133 51.068 45.5241C51.2176 45.635 51.3438 45.7743 51.4393 45.9341C51.5348 46.0938 51.5977 46.2709 51.6244 46.455C51.6512 46.6392 51.6412 46.8268 51.595 47.0071L50.5453 51.0363C50.4646 51.3407 50.2853 51.6098 50.0354 51.8016C49.7854 51.9934 49.4789 52.097 49.1637 52.0963Z"
            fill="#E50F4F"
        />
        <path
            d="M58.8763 46.4275C58.756 46.4278 58.6361 46.413 58.5194 46.3834L54.4445 45.3454C54.2638 45.3005 54.0937 45.2203 53.9441 45.1094C53.7945 44.9986 53.6683 44.8593 53.5728 44.6995C53.4773 44.5397 53.4144 44.3627 53.3877 44.1785C53.3609 43.9944 53.3709 43.8067 53.4171 43.6264C53.5152 43.263 53.7526 42.9526 54.0779 42.7625C54.4032 42.5724 54.7902 42.5178 55.1555 42.6105L59.2304 43.6485C59.5661 43.7318 59.8595 43.9353 60.055 44.2205C60.2504 44.5056 60.3342 44.8525 60.2905 45.1953C60.2469 45.5382 60.0787 45.853 59.818 46.0802C59.5573 46.3073 59.2222 46.4309 58.8763 46.4275L58.8763 46.4275Z"
            fill="#E50F4F"
        />
        <path
            d="M47.5034 43.5295C47.3831 43.5298 47.2632 43.515 47.1465 43.4854L43.0716 42.4488C42.8908 42.404 42.7207 42.3238 42.5711 42.213C42.4214 42.1022 42.2952 41.9628 42.1997 41.803C42.1042 41.6433 42.0413 41.4662 42.0146 41.282C41.9879 41.0978 41.9979 40.9102 42.0442 40.7299C42.1424 40.3664 42.3798 40.0562 42.705 39.8661C43.0303 39.676 43.4173 39.6214 43.7826 39.7139L47.8575 40.7505C48.1932 40.8338 48.4866 41.0374 48.682 41.3225C48.8774 41.6076 48.9613 41.9545 48.9176 42.2973C48.8739 42.6401 48.7058 42.955 48.4451 43.1821C48.1844 43.4092 47.8493 43.5329 47.5034 43.5295L47.5034 43.5295Z"
            fill="#E50F4F"
        />
        <path
            d="M44.6123 122.687C44.5385 122.782 44.453 122.867 44.3579 122.941C44.2112 123.056 44.0433 123.14 43.8638 123.19C43.6844 123.24 43.4969 123.253 43.3122 123.23C43.1275 123.207 42.9493 123.148 42.7877 123.055C42.6261 122.963 42.4844 122.84 42.3708 122.692L39.8419 119.384C39.6171 119.083 39.5194 118.705 39.5698 118.332C39.6202 117.959 39.8148 117.62 40.1117 117.389C40.2584 117.274 40.4263 117.19 40.6058 117.14C40.7852 117.09 40.9727 117.077 41.1574 117.1C41.3421 117.123 41.5203 117.182 41.6819 117.275C41.8435 117.367 41.9852 117.49 42.0988 117.638L44.6276 120.946C44.8178 121.196 44.9195 121.503 44.9167 121.818C44.9139 122.134 44.8069 122.439 44.6123 122.687Z"
            fill="#E50F4F"
        />
        <path
            d="M51.6702 131.918C51.5964 132.013 51.5109 132.098 51.4158 132.172C51.2691 132.287 51.1012 132.371 50.9217 132.421C50.7423 132.471 50.5548 132.484 50.3701 132.461C50.1854 132.438 50.0071 132.379 49.8456 132.286C49.684 132.194 49.5423 132.071 49.4287 131.923L46.8999 128.616C46.6746 128.314 46.5766 127.936 46.627 127.563C46.6775 127.19 46.8723 126.851 47.1696 126.62C47.3163 126.505 47.4842 126.421 47.6636 126.371C47.8431 126.321 48.0305 126.308 48.2152 126.331C48.3999 126.354 48.5782 126.413 48.7398 126.506C48.9013 126.598 49.043 126.721 49.1567 126.869L51.6855 130.177C51.8757 130.428 51.9773 130.735 51.9746 131.05C51.9718 131.365 51.8648 131.67 51.6702 131.918Z"
            fill="#E50F4F"
        />
        <path
            d="M53.1827 120.774C53.1088 120.869 53.0233 120.955 52.9282 121.028L49.6015 123.6C49.4548 123.715 49.2869 123.8 49.1075 123.85C48.928 123.899 48.7405 123.913 48.5558 123.89C48.3711 123.867 48.1929 123.807 48.0313 123.715C47.8697 123.623 47.728 123.499 47.6144 123.352C47.3884 123.051 47.29 122.673 47.3404 122.299C47.3909 121.926 47.5862 121.587 47.8841 121.356L51.2108 118.784C51.4831 118.571 51.8242 118.465 52.1692 118.487C52.5142 118.508 52.8392 118.656 53.0824 118.901C53.3257 119.147 53.4703 119.473 53.4887 119.818C53.5072 120.164 53.3983 120.504 53.1827 120.774L53.1827 120.774Z"
            fill="#E50F4F"
        />
        <path
            d="M43.8974 127.952C43.8236 128.047 43.7381 128.132 43.6429 128.206L40.3173 130.779C40.1707 130.894 40.0028 130.979 39.8233 131.028C39.6438 131.078 39.4563 131.092 39.2716 131.069C39.0869 131.045 38.9086 130.986 38.7471 130.894C38.5855 130.801 38.4438 130.678 38.3302 130.53C38.1043 130.229 38.006 129.851 38.0564 129.478C38.1069 129.104 38.3021 128.766 38.5999 128.535L41.9255 125.962C42.1978 125.749 42.5389 125.643 42.8839 125.665C43.2289 125.686 43.5538 125.834 43.7971 126.079C44.0403 126.325 44.1849 126.651 44.2034 126.996C44.2219 127.341 44.113 127.682 43.8974 127.952L43.8974 127.952Z"
            fill="#E50F4F"
        />
        <defs>
            <linearGradient
                id="b6d15898__paint0_linear_31352_5418"
                x1={84.7344}
                y1={43.5327}
                x2={130.769}
                y2={156.139}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE356" />
                <stop offset={1} stopColor="#FFE356" />
            </linearGradient>
            <linearGradient
                id="b6d15898__paint1_linear_31352_5418"
                x1={66.8074}
                y1={46.6381}
                x2={112.275}
                y2={136.24}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFD454" />
                <stop offset={1} stopColor="#E3B014" />
            </linearGradient>
        </defs>
    </svg>
);

export default TrainsSchoolSaleL;
