import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TravelM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="e49374ff__mask0_30037_5064"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={20}
            height={20}
        >
            <circle cx={10} cy={10} r={10} fill="white" />
        </mask>
        <g mask="url(#e49374ff__mask0_30037_5064)">
            <rect
                width={20}
                height={20}
                fill="url(#e49374ff__paint0_linear_30037_5064)"
            />
            <path
                d="M13.9855 3.16113C13.3084 3.16113 12.6644 3.20743 12.1256 3.38985C11.5463 3.58598 11.0508 3.95488 10.7872 4.58058C10.5563 5.1287 10.4753 5.42642 10.2535 6.43492C10.1449 6.92881 10.3986 7.37078 10.859 7.4968C11.3194 7.62283 11.8084 7.33744 11.9344 6.877C12.1403 5.98166 12.1832 5.7529 12.3296 5.37683C12.3998 5.19677 12.488 5.09229 12.68 5.02728C12.9401 4.93923 13.3495 4.88986 13.9855 4.88986C14.4159 4.88986 14.7095 4.93745 14.8977 4.99602C15.1039 5.06014 15.1667 5.17994 15.1249 5.39737C15.0332 5.87544 14.9699 6.16461 14.8754 6.64213C14.7827 7.11042 15.0872 7.56519 15.5555 7.65789C16.0238 7.75059 16.4785 7.44611 16.5712 6.97782C16.6998 6.32808 16.8436 5.6795 16.8777 5.21387C16.9326 4.46356 16.5475 3.90834 15.9085 3.5546C15.3791 3.26155 14.7009 3.16113 13.9855 3.16113Z"
                fill="#BD0C42"
            />
            <path
                d="M7.65112 8.2124L7.65136 8.2124C9.10186 8.21318 10.5524 8.21293 12.0029 8.21268C12.718 8.21256 13.4332 8.21243 14.1484 8.21243C15.9433 8.21122 17.2332 9.41196 17.2279 11.2351C17.2253 12.0992 17.1384 13.4441 17.0057 14.8964C16.8566 16.5265 16.6436 18.3827 16.3968 19.9998H14.5779C14.8711 18.1505 15.1012 16.2911 15.2726 14.4266C15.385 13.2046 15.4634 12.351 15.4541 11.4059C15.444 10.3832 14.9864 9.93595 14.0122 9.93595H7.78054C6.35869 9.93595 5.432 10.0429 4.82315 11.4618C4.48629 12.2469 3.97233 13.8685 3.60169 15.8174C3.35899 17.0935 3.1828 18.6222 3.15269 19.9998H1.37891C1.41008 18.4676 1.60699 16.9345 1.86851 15.5594C2.26478 13.4758 2.82146 11.6934 3.22452 10.7541C4.08941 8.73854 5.59412 8.2113 7.65112 8.2124Z"
                fill="#FF6D3A"
            />
            <path
                d="M12.0983 19.9998H10.2979C10.44 16.7815 11.0735 13.4987 11.7695 11.5514C11.9367 11.0837 12.4514 10.8401 12.9191 11.0072C13.3868 11.1744 13.6304 11.6891 13.4632 12.1568C12.8382 13.9055 12.2398 16.974 12.0983 19.9998Z"
                fill="#FF6D3A"
            />
        </g>
        <defs>
            <linearGradient
                id="e49374ff__paint0_linear_30037_5064"
                x1={19.9198}
                y1={-0.087201}
                x2={0.235522}
                y2={20.0072}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEB75" />
                <stop offset={0.920669} stopColor="#FEE14A" />
            </linearGradient>
        </defs>
    </svg>
);

export default TravelM;
