import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TravelLogoL = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 32 32" fill="none" focusable={false} {...props}>
        <rect
            width={30}
            height={30}
            rx={15}
            transform="matrix(1 0 0 -1 1 31)"
            fill="#FC0"
        />
        <mask
            id="77c2282a__a"
            maskUnits="userSpaceOnUse"
            x={1}
            y={1}
            width={30}
            height={30}
        >
            <path
                d="M1 16c0 8.284 6.716 15 15 15 8.284 0 15-6.716 15-15 0-8.284-6.716-15-15-15C7.716 1 1 7.716 1 16z"
                fill="#C4C4C4"
            />
        </mask>
        <g mask="url(#77c2282a__a)">
            <path
                d="M19.792 8.206h1.334L23.524.565h-1.333l-2.399 7.64zM18.731-1.03l-2.967 9.236h1.333l2.968-9.236H18.73zM9.73 20.706a2.113 2.113 0 00-1.153-.007c-.664.152-1.154 1.022-1.154 2.287 0 1.264.394 1.948.919 2.252.4.132.83.146 1.237.028.463-.117 1.154-1.022 1.154-2.287 0-1.264-.373-2.087-1.002-2.273zM22.065 20.706a2.04 2.04 0 00-1.133-.007c-.65.152-1.133 1.022-1.133 2.287 0 1.264.387 1.948.905 2.252.394.132.815.146 1.216.028.456-.117 1.133-1.022 1.133-2.287 0-1.264-.373-2.087-.988-2.273z"
                fill="#292929"
            />
            <path
                d="M22.052 7.46h-8.61c-2.066 0-2.785 2.314-2.785 2.314s-2.46 7.974-3.365 10.883c-.905 2.91 2.28 4.056 3.089 4.056h8.997c.822 0 1.354-.608 1.354-1.838 0-1.444.767-2.17 1.306-2.149.186.035.36.132.477.277.801-2.619 2.812-9.004 2.888-9.308.947-2.702-1.852-4.236-3.351-4.236z"
                fill="url(#77c2282a__paint0_linear)"
            />
            <path
                d="M22.915 8.296a.55.55 0 00-.56.393l-3.579 10.966c0 .007-.007.014-.007.028-.082.387-.228.76-.428 1.099-.228.248-.131.684.947.428 1.078-.256 1.188-.919 1.658-2.35.408-1.243 2.35-7.358 2.854-8.948a1.37 1.37 0 00-.09-1.091.941.941 0 00-.795-.525z"
                fill="url(#77c2282a__paint1_linear)"
            />
            <path
                d="M18.644 9.837c-.214.511-2.971 9.328-3.116 9.784-.145.456.477.601.477.601l3.413-10.869.007-.02h-.02a.727.727 0 00-.76.504z"
                fill="url(#77c2282a__paint2_linear)"
            />
            <path
                d="M16.524 9.332c-.235.049-.567-.007-.781.505-.214.511-2.972 9.328-3.117 9.784-.145.456.477.601.477.601l3.42-10.89z"
                fill="url(#77c2282a__paint3_linear)"
            />
            <path
                d="M13.497 9.332a.744.744 0 00-.78.505c-.215.511-2.972 9.328-3.117 9.784-.145.456.477.601.477.601l3.42-10.89z"
                fill="url(#77c2282a__paint4_linear)"
            />
        </g>
        <defs>
            <linearGradient
                id="77c2282a__paint0_linear"
                x1={16.363}
                y1={24.587}
                x2={16.363}
                y2={7.336}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.085} stopColor="#C70100" />
                <stop offset={0.195} stopColor="#E11C1B" />
                <stop offset={0.979} stopColor="#E11C1B" />
            </linearGradient>
            <linearGradient
                id="77c2282a__paint1_linear"
                x1={19.108}
                y1={21.443}
                x2={23.133}
                y2={8.332}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E52F2D" />
                <stop offset={0.075} stopColor="#E63634" />
                <stop offset={1} stopColor="#EF8883" />
            </linearGradient>
            <linearGradient
                id="77c2282a__paint2_linear"
                x1={15.78}
                y1={19.97}
                x2={20.099}
                y2={5.986}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="77c2282a__paint3_linear"
                x1={13.128}
                y1={19.15}
                x2={17.448}
                y2={5.167}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="77c2282a__paint4_linear"
                x1={10.369}
                y1={18.298}
                x2={14.689}
                y2={4.315}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
        </defs>
    </svg>
);

export default TravelLogoL;
